const AsSignedness = math.AsSignedness;
const checkExpected = math.checkExpected;
const Compare = math.Compare;
const fmax = math.fmax;
const fmin = math.fmin;
const Gpr = math.Gpr;
const inf = math.inf;
const Log2IntCeil = math.Log2IntCeil;
const math = @import("math.zig");
const nan = math.nan;
const RoundBitsUp = math.RoundBitsUp;
const Scalar = math.Scalar;
const Sse = math.Sse;
const tmin = math.tmin;

inline fn runtime(comptime Type: type, comptime value: Type) Type {
    if (@inComptime()) return value;
    return struct {
        var variable: Type = value;
    }.variable;
}

fn unary(comptime op: anytype, comptime opts: struct {
    libc_name: ?[]const u8 = null,
    compare: Compare = .relaxed,
}) type {
    return struct {
        // noinline so that `mem_arg` is on the stack
        noinline fn testArgKinds(
            _: Gpr,
            _: Gpr,
            _: Gpr,
            _: Gpr,
            _: Gpr,
            _: Gpr,
            _: Gpr,
            _: Gpr,
            _: Sse,
            _: Sse,
            _: Sse,
            _: Sse,
            _: Sse,
            _: Sse,
            _: Sse,
            _: Sse,
            comptime Type: type,
            comptime imm_arg: Type,
            mem_arg: Type,
        ) !void {
            const expected = expected: {
                if (opts.libc_name) |libc_name| libc: {
                    const libc_func = @extern(*const fn (Scalar(Type)) callconv(.c) Scalar(Type), .{
                        .name = switch (Scalar(Type)) {
                            f16 => "__" ++ libc_name ++ "h",
                            f32 => libc_name ++ "f",
                            f64 => libc_name,
                            f80 => "__" ++ libc_name ++ "x",
                            f128 => libc_name ++ "q",
                            else => break :libc,
                        },
                        .library_name = switch (@import("builtin").object_format) {
                            else => null,
                            .coff => "compiler_rt",
                        },
                    });
                    switch (@typeInfo(Type)) {
                        else => break :expected libc_func(imm_arg),
                        .vector => |vector| {
                            var res: Type = undefined;
                            inline for (0..vector.len) |i| res[i] = libc_func(imm_arg[i]);
                            break :expected res;
                        },
                    }
                }
                break :expected comptime op(Type, imm_arg);
            };
            var reg_arg = mem_arg;
            _ = .{&reg_arg};
            try checkExpected(expected, op(Type, reg_arg), opts.compare);
            try checkExpected(expected, op(Type, mem_arg), opts.compare);
            if (opts.libc_name == null) try checkExpected(expected, op(Type, imm_arg), opts.compare);
        }
        // noinline for a more helpful stack trace
        noinline fn testArgs(comptime Type: type, comptime imm_arg: Type) !void {
            try testArgKinds(
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                undefined,
                Type,
                imm_arg,
                imm_arg,
            );
        }
        fn testBools() !void {
            try testArgs(bool, false);
            try testArgs(bool, true);
        }
        fn testIntTypes() !void {
            try testArgs(i1, undefined);
            try testArgs(u1, undefined);
            try testArgs(i2, undefined);
            try testArgs(u2, undefined);
            try testArgs(i3, undefined);
            try testArgs(u3, undefined);
            try testArgs(i4, undefined);
            try testArgs(u4, undefined);
            try testArgs(i5, undefined);
            try testArgs(u5, undefined);
            try testArgs(i7, undefined);
            try testArgs(u7, undefined);
            try testArgs(i8, undefined);
            try testArgs(u8, undefined);
            try testArgs(i9, undefined);
            try testArgs(u9, undefined);
            try testArgs(i15, undefined);
            try testArgs(u15, undefined);
            try testArgs(i16, undefined);
            try testArgs(u16, undefined);
            try testArgs(i17, undefined);
            try testArgs(u17, undefined);
            try testArgs(i31, undefined);
            try testArgs(u31, undefined);
            try testArgs(i32, undefined);
            try testArgs(u32, undefined);
            try testArgs(i33, undefined);
            try testArgs(u33, undefined);
            try testArgs(i63, undefined);
            try testArgs(u63, undefined);
            try testArgs(i64, undefined);
            try testArgs(u64, undefined);
            try testArgs(i65, undefined);
            try testArgs(u65, undefined);
            try testArgs(i95, undefined);
            try testArgs(u95, undefined);
            try testArgs(i96, undefined);
            try testArgs(u96, undefined);
            try testArgs(i97, undefined);
            try testArgs(u97, undefined);
            try testArgs(i127, undefined);
            try testArgs(u127, undefined);
            try testArgs(i128, undefined);
            try testArgs(u128, undefined);
            try testArgs(i129, undefined);
            try testArgs(u129, undefined);
            try testArgs(i159, undefined);
            try testArgs(u159, undefined);
            try testArgs(i160, undefined);
            try testArgs(u160, undefined);
            try testArgs(i161, undefined);
            try testArgs(u161, undefined);
            try testArgs(i191, undefined);
            try testArgs(u191, undefined);
            try testArgs(i192, undefined);
            try testArgs(u192, undefined);
            try testArgs(i193, undefined);
            try testArgs(u193, undefined);
            try testArgs(i223, undefined);
            try testArgs(u223, undefined);
            try testArgs(i224, undefined);
            try testArgs(u224, undefined);
            try testArgs(i225, undefined);
            try testArgs(u225, undefined);
            try testArgs(i255, undefined);
            try testArgs(u255, undefined);
            try testArgs(i256, undefined);
            try testArgs(u256, undefined);
            try testArgs(i257, undefined);
            try testArgs(u257, undefined);
            try testArgs(i511, undefined);
            try testArgs(u511, undefined);
            try testArgs(i512, undefined);
            try testArgs(u512, undefined);
            try testArgs(i513, undefined);
            try testArgs(u513, undefined);
            try testArgs(i1023, undefined);
            try testArgs(u1023, undefined);
            try testArgs(i1024, undefined);
            try testArgs(u1024, undefined);
            try testArgs(i1025, undefined);
            try testArgs(u1025, undefined);
        }
        fn testInts() !void {
            try testArgs(i1, -1);
            try testArgs(i1, 0);
            try testArgs(u1, 0);
            try testArgs(u1, 1 << 0);

            try testArgs(i2, -1 << 1);
            try testArgs(i2, -1);
            try testArgs(i2, 0);
            try testArgs(u2, 0);
            try testArgs(u2, 1 << 0);
            try testArgs(u2, 1 << 1);

            try testArgs(i3, -1 << 2);
            try testArgs(i3, -1);
            try testArgs(i3, 0);
            try testArgs(u3, 0);
            try testArgs(u3, 1 << 0);
            try testArgs(u3, 1 << 1);
            try testArgs(u3, 1 << 2);

            try testArgs(i4, -1 << 3);
            try testArgs(i4, -1);
            try testArgs(i4, 0);
            try testArgs(u4, 0);
            try testArgs(u4, 1 << 0);
            try testArgs(u4, 1 << 1);
            try testArgs(u4, 1 << 2);
            try testArgs(u4, 1 << 3);

            try testArgs(i5, -1 << 4);
            try testArgs(i5, -1);
            try testArgs(i5, 0);
            try testArgs(u5, 0);
            try testArgs(u5, 1 << 0);
            try testArgs(u5, 1 << 1);
            try testArgs(u5, 1 << 3);
            try testArgs(u5, 1 << 4);

            try testArgs(i7, -1 << 6);
            try testArgs(i7, -1);
            try testArgs(i7, 0);
            try testArgs(u7, 0);
            try testArgs(u7, 1 << 0);
            try testArgs(u7, 1 << 1);
            try testArgs(u7, 1 << 5);
            try testArgs(u7, 1 << 6);

            try testArgs(i8, -1 << 7);
            try testArgs(i8, -1);
            try testArgs(i8, 0);
            try testArgs(u8, 0);
            try testArgs(u8, 1 << 0);
            try testArgs(u8, 1 << 1);
            try testArgs(u8, 1 << 6);
            try testArgs(u8, 1 << 7);

            try testArgs(i9, -1 << 8);
            try testArgs(i9, -1);
            try testArgs(i9, 0);
            try testArgs(u9, 0);
            try testArgs(u9, 1 << 0);
            try testArgs(u9, 1 << 1);
            try testArgs(u9, 1 << 7);
            try testArgs(u9, 1 << 8);

            try testArgs(i15, -1 << 14);
            try testArgs(i15, -1);
            try testArgs(i15, 0);
            try testArgs(u15, 0);
            try testArgs(u15, 1 << 0);
            try testArgs(u15, 1 << 1);
            try testArgs(u15, 1 << 13);
            try testArgs(u15, 1 << 14);

            try testArgs(i16, -1 << 15);
            try testArgs(i16, -1);
            try testArgs(i16, 0);
            try testArgs(u16, 0);
            try testArgs(u16, 1 << 0);
            try testArgs(u16, 1 << 1);
            try testArgs(u16, 1 << 14);
            try testArgs(u16, 1 << 15);

            try testArgs(i17, -1 << 16);
            try testArgs(i17, -1);
            try testArgs(i17, 0);
            try testArgs(u17, 0);
            try testArgs(u17, 1 << 0);
            try testArgs(u17, 1 << 1);
            try testArgs(u17, 1 << 15);
            try testArgs(u17, 1 << 16);

            try testArgs(i31, -1 << 30);
            try testArgs(i31, -1);
            try testArgs(i31, 0);
            try testArgs(u31, 0);
            try testArgs(u31, 1 << 0);
            try testArgs(u31, 1 << 1);
            try testArgs(u31, 1 << 29);
            try testArgs(u31, 1 << 30);

            try testArgs(i32, -1 << 31);
            try testArgs(i32, -1);
            try testArgs(i32, 0);
            try testArgs(u32, 0);
            try testArgs(u32, 1 << 0);
            try testArgs(u32, 1 << 1);
            try testArgs(u32, 1 << 30);
            try testArgs(u32, 1 << 31);

            try testArgs(i33, -1 << 32);
            try testArgs(i33, -1);
            try testArgs(i33, 0);
            try testArgs(u33, 0);
            try testArgs(u33, 1 << 0);
            try testArgs(u33, 1 << 1);
            try testArgs(u33, 1 << 31);
            try testArgs(u33, 1 << 32);

            try testArgs(i63, -1 << 62);
            try testArgs(i63, -1);
            try testArgs(i63, 0);
            try testArgs(u63, 0);
            try testArgs(u63, 1 << 0);
            try testArgs(u63, 1 << 1);
            try testArgs(u63, 1 << 61);
            try testArgs(u63, 1 << 62);

            try testArgs(i64, -1 << 63);
            try testArgs(i64, -1);
            try testArgs(i64, 0);
            try testArgs(u64, 0);
            try testArgs(u64, 1 << 0);
            try testArgs(u64, 1 << 1);
            try testArgs(u64, 1 << 62);
            try testArgs(u64, 1 << 63);

            try testArgs(i65, -1 << 64);
            try testArgs(i65, -1);
            try testArgs(i65, 0);
            try testArgs(u65, 0);
            try testArgs(u65, 1 << 0);
            try testArgs(u65, 1 << 1);
            try testArgs(u65, 1 << 63);
            try testArgs(u65, 1 << 64);

            try testArgs(i95, -1 << 94);
            try testArgs(i95, -1);
            try testArgs(i95, 0);
            try testArgs(u95, 0);
            try testArgs(u95, 1 << 0);
            try testArgs(u95, 1 << 1);
            try testArgs(u95, 1 << 93);
            try testArgs(u95, 1 << 94);

            try testArgs(i96, -1 << 95);
            try testArgs(i96, -1);
            try testArgs(i96, 0);
            try testArgs(u96, 0);
            try testArgs(u96, 1 << 0);
            try testArgs(u96, 1 << 1);
            try testArgs(u96, 1 << 94);
            try testArgs(u96, 1 << 95);

            try testArgs(i97, -1 << 96);
            try testArgs(i97, -1);
            try testArgs(i97, 0);
            try testArgs(u97, 0);
            try testArgs(u97, 1 << 0);
            try testArgs(u97, 1 << 1);
            try testArgs(u97, 1 << 95);
            try testArgs(u97, 1 << 96);

            try testArgs(i127, -1 << 126);
            try testArgs(i127, -1);
            try testArgs(i127, 0);
            try testArgs(u127, 0);
            try testArgs(u127, 1 << 0);
            try testArgs(u127, 1 << 1);
            try testArgs(u127, 1 << 125);
            try testArgs(u127, 1 << 126);

            try testArgs(i128, -1 << 127);
            try testArgs(i128, -1);
            try testArgs(i128, 0);
            try testArgs(u128, 0);
            try testArgs(u128, 1 << 0);
            try testArgs(u128, 1 << 1);
            try testArgs(u128, 1 << 126);
            try testArgs(u128, 1 << 127);

            try testArgs(i129, -1 << 128);
            try testArgs(i129, -1);
            try testArgs(i129, 0);
            try testArgs(u129, 0);
            try testArgs(u129, 1 << 0);
            try testArgs(u129, 1 << 1);
            try testArgs(u129, 1 << 127);
            try testArgs(u129, 1 << 128);

            try testArgs(i159, -1 << 158);
            try testArgs(i159, -1);
            try testArgs(i159, 0);
            try testArgs(u159, 0);
            try testArgs(u159, 1 << 0);
            try testArgs(u159, 1 << 1);
            try testArgs(u159, 1 << 157);
            try testArgs(u159, 1 << 158);

            try testArgs(i160, -1 << 159);
            try testArgs(i160, -1);
            try testArgs(i160, 0);
            try testArgs(u160, 0);
            try testArgs(u160, 1 << 0);
            try testArgs(u160, 1 << 1);
            try testArgs(u160, 1 << 158);
            try testArgs(u160, 1 << 159);

            try testArgs(i161, -1 << 160);
            try testArgs(i161, -1);
            try testArgs(i161, 0);
            try testArgs(u161, 0);
            try testArgs(u161, 1 << 0);
            try testArgs(u161, 1 << 1);
            try testArgs(u161, 1 << 159);
            try testArgs(u161, 1 << 160);

            try testArgs(i191, -1 << 190);
            try testArgs(i191, -1);
            try testArgs(i191, 0);
            try testArgs(u191, 0);
            try testArgs(u191, 1 << 0);
            try testArgs(u191, 1 << 1);
            try testArgs(u191, 1 << 189);
            try testArgs(u191, 1 << 190);

            try testArgs(i192, -1 << 191);
            try testArgs(i192, -1);
            try testArgs(i192, 0);
            try testArgs(u192, 0);
            try testArgs(u192, 1 << 0);
            try testArgs(u192, 1 << 1);
            try testArgs(u192, 1 << 190);
            try testArgs(u192, 1 << 191);

            try testArgs(i193, -1 << 192);
            try testArgs(i193, -1);
            try testArgs(i193, 0);
            try testArgs(u193, 0);
            try testArgs(u193, 1 << 0);
            try testArgs(u193, 1 << 1);
            try testArgs(u193, 1 << 191);
            try testArgs(u193, 1 << 192);

            try testArgs(i223, -1 << 222);
            try testArgs(i223, -1);
            try testArgs(i223, 0);
            try testArgs(u223, 0);
            try testArgs(u223, 1 << 0);
            try testArgs(u223, 1 << 1);
            try testArgs(u223, 1 << 221);
            try testArgs(u223, 1 << 222);

            try testArgs(i224, -1 << 223);
            try testArgs(i224, -1);
            try testArgs(i224, 0);
            try testArgs(u224, 0);
            try testArgs(u224, 1 << 0);
            try testArgs(u224, 1 << 1);
            try testArgs(u224, 1 << 222);
            try testArgs(u224, 1 << 223);

            try testArgs(i225, -1 << 224);
            try testArgs(i225, -1);
            try testArgs(i225, 0);
            try testArgs(u225, 0);
            try testArgs(u225, 1 << 0);
            try testArgs(u225, 1 << 1);
            try testArgs(u225, 1 << 223);
            try testArgs(u225, 1 << 224);

            try testArgs(i255, -1 << 254);
            try testArgs(i255, -1);
            try testArgs(i255, 0);
            try testArgs(u255, 0);
            try testArgs(u255, 1 << 0);
            try testArgs(u255, 1 << 1);
            try testArgs(u255, 1 << 253);
            try testArgs(u255, 1 << 254);

            try testArgs(i256, -1 << 255);
            try testArgs(i256, -1);
            try testArgs(i256, 0);
            try testArgs(u256, 0);
            try testArgs(u256, 1 << 0);
            try testArgs(u256, 1 << 1);
            try testArgs(u256, 1 << 254);
            try testArgs(u256, 1 << 255);

            try testArgs(i257, -1 << 256);
            try testArgs(i257, -1);
            try testArgs(i257, 0);
            try testArgs(u257, 0);
            try testArgs(u257, 1 << 0);
            try testArgs(u257, 1 << 1);
            try testArgs(u257, 1 << 255);
            try testArgs(u257, 1 << 256);

            try testArgs(i383, -1 << 382);
            try testArgs(i383, -1);
            try testArgs(i383, 0);
            try testArgs(u383, 0);
            try testArgs(u383, 1 << 0);
            try testArgs(u383, 1 << 1);
            try testArgs(u383, 1 << 381);
            try testArgs(u383, 1 << 382);

            try testArgs(i384, -1 << 383);
            try testArgs(i384, -1);
            try testArgs(i384, 0);
            try testArgs(u384, 0);
            try testArgs(u384, 1 << 0);
            try testArgs(u384, 1 << 1);
            try testArgs(u384, 1 << 382);
            try testArgs(u384, 1 << 383);

            try testArgs(i385, -1 << 384);
            try testArgs(i385, -1);
            try testArgs(i385, 0);
            try testArgs(u385, 0);
            try testArgs(u385, 1 << 0);
            try testArgs(u385, 1 << 1);
            try testArgs(u385, 1 << 383);
            try testArgs(u385, 1 << 384);

            try testArgs(i511, -1 << 510);
            try testArgs(i511, -1);
            try testArgs(i511, 0);
            try testArgs(u511, 0);
            try testArgs(u511, 1 << 0);
            try testArgs(u511, 1 << 1);
            try testArgs(u511, 1 << 509);
            try testArgs(u511, 1 << 510);

            try testArgs(i512, -1 << 511);
            try testArgs(i512, -1);
            try testArgs(i512, 0);
            try testArgs(u512, 0);
            try testArgs(u512, 1 << 0);
            try testArgs(u512, 1 << 1);
            try testArgs(u512, 1 << 510);
            try testArgs(u512, 1 << 511);

            try testArgs(i513, -1 << 512);
            try testArgs(i513, -1);
            try testArgs(i513, 0);
            try testArgs(u513, 0);
            try testArgs(u513, 1 << 0);
            try testArgs(u513, 1 << 1);
            try testArgs(u513, 1 << 511);
            try testArgs(u513, 1 << 512);

            try testArgs(i1023, -1 << 1022);
            try testArgs(i1023, -1);
            try testArgs(i1023, 0);
            try testArgs(u1023, 0);
            try testArgs(u1023, 1 << 0);
            try testArgs(u1023, 1 << 1);
            try testArgs(u1023, 1 << 1021);
            try testArgs(u1023, 1 << 1022);

            try testArgs(i1024, -1 << 1023);
            try testArgs(i1024, -1);
            try testArgs(i1024, 0);
            try testArgs(u1024, 0);
            try testArgs(u1024, 1 << 0);
            try testArgs(u1024, 1 << 1);
            try testArgs(u1024, 1 << 1022);
            try testArgs(u1024, 1 << 1023);

            try testArgs(i1025, -1 << 1024);
            try testArgs(i1025, -1);
            try testArgs(i1025, 0);
            try testArgs(u1025, 0);
            try testArgs(u1025, 1 << 0);
            try testArgs(u1025, 1 << 1);
            try testArgs(u1025, 1 << 1023);
            try testArgs(u1025, 1 << 1024);
        }
        fn testFloatTypes() !void {
            try testArgs(f16, undefined);
            try testArgs(f32, undefined);
            try testArgs(f64, undefined);
            try testArgs(f80, undefined);
            try testArgs(f128, undefined);
        }
        fn testFloats() !void {
            try testArgs(f16, -nan(f16));
            try testArgs(f16, -inf(f16));
            try testArgs(f16, -fmax(f16));
            try testArgs(f16, -1e1);
            try testArgs(f16, -1e0);
            try testArgs(f16, -1e-1);
            try testArgs(f16, -fmin(f16));
            try testArgs(f16, -tmin(f16));
            try testArgs(f16, -0.0);
            try testArgs(f16, 0.0);
            try testArgs(f16, tmin(f16));
            try testArgs(f16, fmin(f16));
            try testArgs(f16, 1e-1);
            try testArgs(f16, 1e0);
            try testArgs(f16, 1e1);
            try testArgs(f16, fmax(f16));
            try testArgs(f16, inf(f16));
            try testArgs(f16, nan(f16));

            try testArgs(f32, -nan(f32));
            try testArgs(f32, -inf(f32));
            try testArgs(f32, -fmax(f32));
            try testArgs(f32, -1e1);
            try testArgs(f32, -1e0);
            try testArgs(f32, -1e-1);
            try testArgs(f32, -fmin(f32));
            try testArgs(f32, -tmin(f32));
            try testArgs(f32, -0.0);
            try testArgs(f32, 0.0);
            try testArgs(f32, tmin(f32));
            try testArgs(f32, fmin(f32));
            try testArgs(f32, 1e-1);
            try testArgs(f32, 1e0);
            try testArgs(f32, 1e1);
            try testArgs(f32, fmax(f32));
            try testArgs(f32, inf(f32));
            try testArgs(f32, nan(f32));

            try testArgs(f64, -nan(f64));
            try testArgs(f64, -inf(f64));
            try testArgs(f64, -fmax(f64));
            try testArgs(f64, -1e1);
            try testArgs(f64, -1e0);
            try testArgs(f64, -1e-1);
            try testArgs(f64, -fmin(f64));
            try testArgs(f64, -tmin(f64));
            try testArgs(f64, -0.0);
            try testArgs(f64, 0.0);
            try testArgs(f64, tmin(f64));
            try testArgs(f64, fmin(f64));
            try testArgs(f64, 1e-1);
            try testArgs(f64, 1e0);
            try testArgs(f64, 1e1);
            try testArgs(f64, fmax(f64));
            try testArgs(f64, inf(f64));
            try testArgs(f64, nan(f64));

            try testArgs(f80, -nan(f80));
            try testArgs(f80, -inf(f80));
            try testArgs(f80, -fmax(f80));
            try testArgs(f80, -1e1);
            try testArgs(f80, -1e0);
            try testArgs(f80, -1e-1);
            try testArgs(f80, -fmin(f80));
            try testArgs(f80, -tmin(f80));
            try testArgs(f80, -0.0);
            try testArgs(f80, 0.0);
            try testArgs(f80, tmin(f80));
            try testArgs(f80, fmin(f80));
            try testArgs(f80, 1e-1);
            try testArgs(f80, 1e0);
            try testArgs(f80, 1e1);
            try testArgs(f80, fmax(f80));
            try testArgs(f80, inf(f80));
            try testArgs(f80, nan(f80));

            try testArgs(f128, -nan(f128));
            try testArgs(f128, -inf(f128));
            try testArgs(f128, -fmax(f128));
            try testArgs(f128, -1e1);
            try testArgs(f128, -1e0);
            try testArgs(f128, -1e-1);
            try testArgs(f128, -fmin(f128));
            try testArgs(f128, -tmin(f128));
            try testArgs(f128, -0.0);
            try testArgs(f128, 0.0);
            try testArgs(f128, tmin(f128));
            try testArgs(f128, fmin(f128));
            try testArgs(f128, 1e-1);
            try testArgs(f128, 1e0);
            try testArgs(f128, 1e1);
            try testArgs(f128, fmax(f128));
            try testArgs(f128, inf(f128));
            try testArgs(f128, nan(f128));
        }
        fn testBoolVectors() !void {
            try testArgs(@Vector(1, bool), .{
                true,
            });
            try testArgs(@Vector(2, bool), .{
                false, false,
            });
            try testArgs(@Vector(3, bool), .{
                false, false, false,
            });
            try testArgs(@Vector(4, bool), .{
                true, true, true, true,
            });
            try testArgs(@Vector(5, bool), .{
                true, true, true, true, true,
            });
            try testArgs(@Vector(7, bool), .{
                false, false, false, false, false, false, false,
            });
            try testArgs(@Vector(8, bool), .{
                false, true, false, true, true, false, true, false,
            });
            try testArgs(@Vector(9, bool), .{
                true, false, false, false, true, true, false, true, false,
            });
            try testArgs(@Vector(15, bool), .{
                false, false, false, false, false, false, false, false, false, false, false, false, false, false, false,
            });
            try testArgs(@Vector(16, bool), .{
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
            });
            try testArgs(@Vector(17, bool), .{
                true, false, true, true, true, true, false, false, true, false, true, true, false, false, false, true,
                true,
            });
            try testArgs(@Vector(31, bool), .{
                false, false, false, false, false, false, true, true, true, false, false, true, false, false, false, false,
                true,  true,  false, false, true,  false, true, true, true, false, false, true, true,  false, false,
            });
            try testArgs(@Vector(32, bool), .{
                false, true,  true,  false, true,  false, false, false, true, false, false, false, true, true,  true,  true,
                false, false, false, true,  false, true,  false, true,  true, false, false, false, true, false, false, false,
            });
            try testArgs(@Vector(33, bool), .{
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true,
            });
            try testArgs(@Vector(63, bool), .{
                true,  false, false, true,  false, false, true,  false, true, true,  true, false, false, false, false, true,
                true,  true,  false, false, false, true,  true,  false, true, false, true, false, false, true,  true,  false,
                true,  true,  true,  true,  false, true,  true,  true,  true, true,  true, false, false, false, false, true,
                false, false, true,  false, true,  true,  false, true,  true, true,  true, true,  true,  false, true,
            });
            try testArgs(@Vector(64, bool), .{
                true,  true, false, true,  true,  false, false, false, false, true,  false, true,  false, false, false, false,
                true,  true, true,  false, true,  true,  false, true,  true,  true,  false, false, false, true,  true,  false,
                false, true, false, false, false, false, false, false, true,  true,  false, true,  false, false, false, false,
                false, true, true,  true,  false, false, false, false, true,  false, false, true,  false, true,  false, true,
            });
            try testArgs(@Vector(65, bool), .{
                false, false, true,  false, false, false, false, true,  false, true,  false, true,  true, true,  true,  false,
                false, true,  false, true,  true,  false, false, true,  true,  false, true,  false, true, true,  true,  false,
                false, true,  true,  true,  true,  false, false, false, true,  true,  false, true,  true, true,  false, false,
                false, true,  false, false, false, false, true,  true,  false, false, false, true,  true, false, false, false,
                false,
            });
            try testArgs(@Vector(127, bool), .{
                true,  true,  true,  false, false, false, false, true,  true,  true,  true,  true,  false, false, true,  false,
                false, true,  false, true,  true,  false, true,  true,  true,  true,  true,  false, true,  false, true,  true,
                true,  true,  false, true,  true,  true,  true,  true,  false, false, true,  false, true,  true,  true,  false,
                false, true,  true,  false, true,  true,  false, false, true,  false, true,  true,  false, false, true,  true,
                false, false, false, false, false, true,  true,  false, true,  true,  false, true,  true,  true,  false, true,
                true,  false, false, false, false, false, false, true,  true,  true,  false, true,  true,  true,  false, true,
                false, true,  true,  false, false, false, false, true,  true,  false, false, false, true,  false, true,  true,
                true,  false, true,  false, true,  true,  false, true,  false, false, false, true,  false, false, true,
            });
            try testArgs(@Vector(128, bool), .{
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
                true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
            });
            try testArgs(@Vector(129, bool), .{
                true,  true,  false, true,  true,  false, true,  false, false, true,  true,  false, true,  true,  true,  false,
                true,  true,  true,  false, false, false, true,  true,  false, false, false, true,  true,  false, false, true,
                true,  false, false, true,  false, true,  true,  false, true,  true,  false, true,  false, false, true,  false,
                false, false, false, false, true,  true,  false, false, true,  true,  false, false, false, false, true,  false,
                false, true,  true,  true,  true,  true,  false, true,  true,  true,  false, false, true,  false, false, true,
                true,  true,  true,  true,  true,  false, true,  false, false, true,  true,  true,  true,  false, true,  true,
                true,  false, true,  true,  true,  true,  true,  true,  false, false, false, false, false, true,  true,  true,
                true,  true,  false, false, false, false, false, true,  true,  false, true,  true,  true,  false, false, false,
                false,
            });
        }
        fn testIntVectorTypes() !void {
            try testArgs(@Vector(3, i1), undefined);
            try testArgs(@Vector(3, u1), undefined);
            try testArgs(@Vector(3, i2), undefined);
            try testArgs(@Vector(3, u2), undefined);
            try testArgs(@Vector(3, i3), undefined);
            try testArgs(@Vector(3, u3), undefined);
            try testArgs(@Vector(3, i4), undefined);
            try testArgs(@Vector(1, i4), undefined);
            try testArgs(@Vector(2, i4), undefined);
            try testArgs(@Vector(4, i4), undefined);
            try testArgs(@Vector(8, i4), undefined);
            try testArgs(@Vector(16, i4), undefined);
            try testArgs(@Vector(32, i4), undefined);
            try testArgs(@Vector(64, i4), undefined);
            try testArgs(@Vector(128, i4), undefined);
            try testArgs(@Vector(256, i4), undefined);
            try testArgs(@Vector(3, u4), undefined);
            try testArgs(@Vector(1, u4), undefined);
            try testArgs(@Vector(2, u4), undefined);
            try testArgs(@Vector(4, u4), undefined);
            try testArgs(@Vector(8, u4), undefined);
            try testArgs(@Vector(16, u4), undefined);
            try testArgs(@Vector(32, u4), undefined);
            try testArgs(@Vector(64, u4), undefined);
            try testArgs(@Vector(128, u4), undefined);
            try testArgs(@Vector(256, u4), undefined);
            try testArgs(@Vector(3, i5), undefined);
            try testArgs(@Vector(3, u5), undefined);
            try testArgs(@Vector(3, i7), undefined);
            try testArgs(@Vector(3, u7), undefined);
            try testArgs(@Vector(3, i8), undefined);
            try testArgs(@Vector(1, i8), undefined);
            try testArgs(@Vector(2, i8), undefined);
            try testArgs(@Vector(4, i8), undefined);
            try testArgs(@Vector(8, i8), undefined);
            try testArgs(@Vector(16, i8), undefined);
            try testArgs(@Vector(32, i8), undefined);
            try testArgs(@Vector(64, i8), undefined);
            try testArgs(@Vector(128, i8), undefined);
            try testArgs(@Vector(3, u8), undefined);
            try testArgs(@Vector(1, u8), undefined);
            try testArgs(@Vector(2, u8), undefined);
            try testArgs(@Vector(4, u8), undefined);
            try testArgs(@Vector(8, u8), undefined);
            try testArgs(@Vector(16, u8), undefined);
            try testArgs(@Vector(32, u8), undefined);
            try testArgs(@Vector(64, u8), undefined);
            try testArgs(@Vector(128, u8), undefined);
            try testArgs(@Vector(3, i9), undefined);
            try testArgs(@Vector(3, u9), undefined);
            try testArgs(@Vector(3, i15), undefined);
            try testArgs(@Vector(3, u15), undefined);
            try testArgs(@Vector(3, i16), undefined);
            try testArgs(@Vector(1, i16), undefined);
            try testArgs(@Vector(2, i16), undefined);
            try testArgs(@Vector(4, i16), undefined);
            try testArgs(@Vector(8, i16), undefined);
            try testArgs(@Vector(16, i16), undefined);
            try testArgs(@Vector(32, i16), undefined);
            try testArgs(@Vector(64, i16), undefined);
            try testArgs(@Vector(3, u16), undefined);
            try testArgs(@Vector(1, u16), undefined);
            try testArgs(@Vector(2, u16), undefined);
            try testArgs(@Vector(4, u16), undefined);
            try testArgs(@Vector(8, u16), undefined);
            try testArgs(@Vector(16, u16), undefined);
            try testArgs(@Vector(32, u16), undefined);
            try testArgs(@Vector(64, u16), undefined);
            try testArgs(@Vector(3, i17), undefined);
            try testArgs(@Vector(3, u17), undefined);
            try testArgs(@Vector(3, i31), undefined);
            try testArgs(@Vector(3, u31), undefined);
            try testArgs(@Vector(3, i32), undefined);
            try testArgs(@Vector(1, i32), undefined);
            try testArgs(@Vector(2, i32), undefined);
            try testArgs(@Vector(4, i32), undefined);
            try testArgs(@Vector(8, i32), undefined);
            try testArgs(@Vector(16, i32), undefined);
            try testArgs(@Vector(32, i32), undefined);
            try testArgs(@Vector(3, u32), undefined);
            try testArgs(@Vector(1, u32), undefined);
            try testArgs(@Vector(2, u32), undefined);
            try testArgs(@Vector(4, u32), undefined);
            try testArgs(@Vector(8, u32), undefined);
            try testArgs(@Vector(16, u32), undefined);
            try testArgs(@Vector(32, u32), undefined);
            try testArgs(@Vector(3, i33), undefined);
            try testArgs(@Vector(3, u33), undefined);
            try testArgs(@Vector(3, i63), undefined);
            try testArgs(@Vector(3, u63), undefined);
            try testArgs(@Vector(3, i64), undefined);
            try testArgs(@Vector(1, i64), undefined);
            try testArgs(@Vector(2, i64), undefined);
            try testArgs(@Vector(4, i64), undefined);
            try testArgs(@Vector(8, i64), undefined);
            try testArgs(@Vector(16, i64), undefined);
            try testArgs(@Vector(3, u64), undefined);
            try testArgs(@Vector(1, u64), undefined);
            try testArgs(@Vector(2, u64), undefined);
            try testArgs(@Vector(4, u64), undefined);
            try testArgs(@Vector(8, u64), undefined);
            try testArgs(@Vector(16, u64), undefined);
            try testArgs(@Vector(3, i65), undefined);
            try testArgs(@Vector(3, u65), undefined);
            try testArgs(@Vector(3, i127), undefined);
            try testArgs(@Vector(3, u127), undefined);
            try testArgs(@Vector(3, i128), undefined);
            try testArgs(@Vector(1, i128), undefined);
            try testArgs(@Vector(2, i128), undefined);
            try testArgs(@Vector(4, i128), undefined);
            try testArgs(@Vector(8, i128), undefined);
            try testArgs(@Vector(3, u128), undefined);
            try testArgs(@Vector(1, u128), undefined);
            try testArgs(@Vector(2, u128), undefined);
            try testArgs(@Vector(4, u128), undefined);
            try testArgs(@Vector(8, u128), undefined);
            try testArgs(@Vector(3, i129), undefined);
            try testArgs(@Vector(3, u129), undefined);
            try testArgs(@Vector(3, i191), undefined);
            try testArgs(@Vector(3, u191), undefined);
            try testArgs(@Vector(3, i192), undefined);
            try testArgs(@Vector(1, i192), undefined);
            try testArgs(@Vector(2, i192), undefined);
            try testArgs(@Vector(4, i192), undefined);
            try testArgs(@Vector(3, u192), undefined);
            try testArgs(@Vector(1, u192), undefined);
            try testArgs(@Vector(2, u192), undefined);
            try testArgs(@Vector(4, u192), undefined);
            try testArgs(@Vector(3, i193), undefined);
            try testArgs(@Vector(3, u193), undefined);
            try testArgs(@Vector(3, i255), undefined);
            try testArgs(@Vector(3, u255), undefined);
            try testArgs(@Vector(3, i256), undefined);
            try testArgs(@Vector(1, i256), undefined);
            try testArgs(@Vector(2, i256), undefined);
            try testArgs(@Vector(4, i256), undefined);
            try testArgs(@Vector(3, u256), undefined);
            try testArgs(@Vector(1, u256), undefined);
            try testArgs(@Vector(2, u256), undefined);
            try testArgs(@Vector(4, u256), undefined);
            try testArgs(@Vector(3, i257), undefined);
            try testArgs(@Vector(3, u257), undefined);
            try testArgs(@Vector(3, i511), undefined);
            try testArgs(@Vector(3, u511), undefined);
            try testArgs(@Vector(3, i512), undefined);
            try testArgs(@Vector(1, i512), undefined);
            try testArgs(@Vector(2, i512), undefined);
            try testArgs(@Vector(3, u512), undefined);
            try testArgs(@Vector(1, u512), undefined);
            try testArgs(@Vector(2, u512), undefined);
            try testArgs(@Vector(3, i513), undefined);
            try testArgs(@Vector(3, u513), undefined);
            try testArgs(@Vector(3, i1023), undefined);
            try testArgs(@Vector(3, u1023), undefined);
            try testArgs(@Vector(3, i1024), undefined);
            try testArgs(@Vector(1, i1024), undefined);
            try testArgs(@Vector(3, u1024), undefined);
            try testArgs(@Vector(1, u1024), undefined);
            try testArgs(@Vector(3, i1025), undefined);
            try testArgs(@Vector(3, u1025), undefined);
        }
        fn testIntVectors() !void {
            try testArgs(@Vector(1, i1), .{
                0x0,
            });
            try testArgs(@Vector(2, i1), .{
                -0x1, -0x1,
            });
            try testArgs(@Vector(3, i1), .{
                0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(4, i1), .{
                -0x1, -0x1, -0x1, 0x0,
            });
            try testArgs(@Vector(5, i1), .{
                -0x1, -0x1, 0x0, 0x0, -0x1,
            });
            try testArgs(@Vector(7, i1), .{
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(8, i1), .{
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(9, i1), .{
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(15, i1), .{
                0x0, 0x0, -0x1, -0x1, 0x0, 0x0, 0x0, 0x0, -0x1, 0x0, 0x0, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(16, i1), .{
                -0x1, -0x1, 0x0, -0x1, 0x0, 0x0, -0x1, 0x0, -0x1, -0x1, -0x1, -0x1, 0x0, 0x0, -0x1, -0x1,
            });
            try testArgs(@Vector(17, i1), .{
                -0x1, -0x1, 0x0, -0x1, 0x0, -0x1, 0x0, 0x0, 0x0, -0x1, 0x0, 0x0, -0x1, -0x1, -0x1, 0x0,
                -0x1,
            });
            try testArgs(@Vector(31, i1), .{
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(32, i1), .{
                0x0, -0x1, 0x0,  0x0,  -0x1, -0x1, -0x1, -0x1, -0x1, 0x0, -0x1, -0x1, -0x1, -0x1, 0x0,  0x0,
                0x0, 0x0,  -0x1, -0x1, 0x0,  0x0,  0x0,  -0x1, 0x0,  0x0, -0x1, 0x0,  0x0,  -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(33, i1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0,
            });
            try testArgs(@Vector(63, i1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(64, i1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(65, i1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                0x0,
            });
            try testArgs(@Vector(127, i1), .{
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(128, i1), .{
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(129, i1), .{
                -0x1, -0x1, 0x0,  -0x1, -0x1, -0x1, 0x0,  -0x1, -0x1, 0x0,  0x0,  0x0,  0x0,  -0x1, 0x0,  0x0,
                0x0,  -0x1, -0x1, -0x1, -0x1, -0x1, -0x1, 0x0,  -0x1, -0x1, 0x0,  0x0,  0x0,  -0x1, 0x0,  0x0,
                0x0,  -0x1, 0x0,  -0x1, 0x0,  0x0,  0x0,  0x0,  0x0,  -0x1, 0x0,  0x0,  -0x1, 0x0,  0x0,  0x0,
                -0x1, -0x1, 0x0,  -0x1, -0x1, 0x0,  0x0,  -0x1, -0x1, 0x0,  -0x1, -0x1, 0x0,  -0x1, -0x1, -0x1,
                -0x1, 0x0,  -0x1, 0x0,  -0x1, -0x1, -0x1, -0x1, 0x0,  0x0,  -0x1, 0x0,  -0x1, 0x0,  -0x1, 0x0,
                0x0,  -0x1, -0x1, 0x0,  0x0,  -0x1, -0x1, 0x0,  -0x1, 0x0,  0x0,  -0x1, 0x0,  -0x1, 0x0,  0x0,
                0x0,  0x0,  0x0,  -0x1, -0x1, 0x0,  -0x1, -0x1, 0x0,  -0x1, -0x1, -0x1, -0x1, -0x1, 0x0,  0x0,
                0x0,  -0x1, 0x0,  0x0,  0x0,  0x0,  -0x1, 0x0,  -0x1, -0x1, 0x0,  0x0,  -0x1, -0x1, -0x1, -0x1,
                0x0,
            });

            try testArgs(@Vector(1, u1), .{
                0x1,
            });
            try testArgs(@Vector(2, u1), .{
                0x0, 0x0,
            });
            try testArgs(@Vector(3, u1), .{
                0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(4, u1), .{
                0x1, 0x1, 0x1, 0x1,
            });
            try testArgs(@Vector(5, u1), .{
                0x1, 0x1, 0x1, 0x1, 0x1,
            });
            try testArgs(@Vector(7, u1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(8, u1), .{
                0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0,
            });
            try testArgs(@Vector(9, u1), .{
                0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0,
            });
            try testArgs(@Vector(15, u1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(16, u1), .{
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
            });
            try testArgs(@Vector(17, u1), .{
                0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1,
                0x1,
            });
            try testArgs(@Vector(31, u1), .{
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
                0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0,
            });
            try testArgs(@Vector(32, u1), .{
                0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1,
                0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
            });
            try testArgs(@Vector(33, u1), .{
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1,
            });
            try testArgs(@Vector(63, u1), .{
                0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1,
                0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0,
                0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1,
                0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1,
            });
            try testArgs(@Vector(64, u1), .{
                0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
                0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0,
                0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
                0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1,
            });
            try testArgs(@Vector(65, u1), .{
                0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0,
                0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0,
                0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0,
                0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0,
                0x0,
            });
            try testArgs(@Vector(127, u1), .{
                0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0,
                0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x1,
                0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0,
                0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1,
                0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1,
                0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1,
                0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1,
                0x1, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1,
            });
            try testArgs(@Vector(128, u1), .{
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
            });
            try testArgs(@Vector(129, u1), .{
                0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0,
                0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1,
                0x1, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0,
                0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
                0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1,
                0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1,
                0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1,
                0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0,
                0x0,
            });

            try testArgs(@Vector(1, i2), .{
                0x1,
            });
            try testArgs(@Vector(2, i2), .{
                0x0, 0x0,
            });
            try testArgs(@Vector(3, i2), .{
                -0x2, 0x1, -0x2,
            });
            try testArgs(@Vector(4, i2), .{
                0x1, 0x0, 0x0, -0x2,
            });
            try testArgs(@Vector(5, i2), .{
                -0x1, -0x2, -0x1, 0x1, 0x1,
            });
            try testArgs(@Vector(7, i2), .{
                0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1,
            });
            try testArgs(@Vector(8, i2), .{
                0x1, -0x1, -0x1, -0x1, 0x1, 0x1, -0x1, 0x1,
            });
            try testArgs(@Vector(9, i2), .{
                -0x2, -0x2, 0x0, 0x0, 0x0, 0x0, 0x0, -0x2, -0x2,
            });
            try testArgs(@Vector(15, i2), .{
                -0x1, 0x1, -0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
            });
            try testArgs(@Vector(16, i2), .{
                0x0, -0x2, 0x1, -0x2, 0x1, -0x1, -0x2, -0x1, 0x0, -0x2, -0x1, 0x1, 0x1, 0x1, -0x1, -0x1,
            });
            try testArgs(@Vector(17, i2), .{
                -0x2, 0x0, 0x1, 0x0, -0x2, 0x0, -0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x1, -0x2,
                -0x1,
            });
            try testArgs(@Vector(31, i2), .{
                0x0,  0x1, -0x1, 0x1, -0x1, -0x2, -0x1, 0x1,  0x0,  -0x2, -0x1, 0x0,  0x0, 0x1,  0x0,  -0x1,
                -0x1, 0x0, 0x1,  0x0, -0x2, -0x1, -0x1, -0x2, -0x2, 0x0,  -0x1, -0x1, 0x1, -0x2, -0x1,
            });
            try testArgs(@Vector(32, i2), .{
                0x1, 0x0,  -0x1, 0x0, 0x0,  -0x1, 0x0,  0x1, -0x1, 0x0, -0x1, -0x1, 0x1,  0x0,  -0x2, -0x1,
                0x1, -0x1, 0x0,  0x1, -0x1, 0x1,  -0x1, 0x0, -0x2, 0x1, -0x1, 0x1,  -0x1, -0x2, 0x1,  -0x2,
            });
            try testArgs(@Vector(33, i2), .{
                0x0,  -0x1, -0x2, -0x1, 0x0, -0x1, -0x2, 0x0,  -0x2, 0x1, -0x2, -0x1, -0x2, -0x1, -0x2, -0x1,
                -0x1, -0x1, 0x1,  0x0,  0x1, -0x2, -0x1, -0x2, -0x1, 0x1, -0x1, 0x0,  -0x1, -0x1, -0x2, 0x0,
                -0x1,
            });
            try testArgs(@Vector(63, i2), .{
                -0x2, -0x2, -0x2, 0x0,  0x0,  -0x1, 0x1, 0x1,  0x1,  0x0,  -0x2, 0x1,  -0x2, -0x2, 0x0,  -0x2,
                0x1,  -0x1, 0x0,  0x1,  0x1,  -0x2, 0x0, -0x2, -0x1, -0x1, 0x1,  0x1,  -0x1, -0x2, -0x1, 0x0,
                0x1,  0x0,  0x1,  0x1,  -0x2, -0x2, 0x0, 0x1,  0x1,  -0x2, -0x2, -0x2, 0x1,  0x1,  -0x2, -0x2,
                -0x2, 0x1,  0x0,  -0x2, 0x1,  -0x2, 0x0, 0x0,  0x0,  -0x2, -0x1, 0x1,  0x0,  0x1,  -0x2,
            });
            try testArgs(@Vector(64, i2), .{
                -0x1, 0x1,  0x1,  -0x1, -0x1, 0x1,  -0x1, 0x1,  0x1,  0x1,  0x1,  0x1,  -0x1, -0x1, 0x1,  0x1,
                -0x1, -0x1, -0x1, 0x1,  -0x1, 0x1,  -0x1, 0x1,  0x1,  0x1,  -0x1, 0x1,  0x1,  -0x1, 0x1,  -0x1,
                0x1,  -0x1, 0x1,  0x1,  0x1,  -0x1, 0x1,  0x1,  -0x1, -0x1, 0x1,  0x1,  0x1,  -0x1, -0x1, -0x1,
                -0x1, 0x1,  0x1,  -0x1, 0x1,  -0x1, -0x1, -0x1, -0x1, 0x1,  0x1,  -0x1, 0x1,  -0x1, 0x1,  -0x1,
            });
            try testArgs(@Vector(65, i2), .{
                0x1,  -0x1, 0x1,  0x1,  0x1,  -0x2, -0x1, -0x1, 0x1, 0x1,  -0x2, 0x0,  -0x1, -0x2, -0x1, -0x1,
                0x0,  0x1,  -0x2, -0x2, 0x0,  -0x2, -0x2, 0x1,  0x1, -0x2, 0x0,  -0x1, 0x0,  -0x2, -0x1, -0x2,
                -0x2, -0x1, 0x1,  0x0,  -0x2, -0x1, -0x2, 0x0,  0x1, -0x2, -0x1, -0x2, 0x0,  -0x1, -0x2, -0x1,
                0x0,  0x1,  -0x1, 0x1,  -0x2, -0x1, 0x1,  -0x2, 0x1, 0x0,  -0x2, 0x1,  -0x1, 0x0,  -0x2, 0x0,
                -0x1,
            });
            try testArgs(@Vector(127, i2), .{
                -0x1, 0x0,  -0x1, 0x0,  -0x2, -0x2, -0x2, -0x1, 0x0,  -0x1, 0x1,  -0x2, -0x1, -0x2, 0x0,  -0x1,
                0x1,  0x0,  0x1,  -0x2, 0x1,  0x0,  -0x2, 0x0,  0x1,  -0x1, -0x1, 0x1,  -0x1, -0x2, -0x1, -0x2,
                0x0,  0x1,  -0x1, 0x0,  0x0,  -0x2, 0x0,  -0x2, -0x2, 0x0,  0x0,  0x1,  0x0,  -0x2, 0x0,  -0x1,
                -0x2, 0x0,  -0x1, -0x2, 0x1,  0x0,  -0x2, -0x1, -0x1, 0x1,  -0x1, 0x0,  0x0,  -0x2, -0x1, -0x1,
                0x0,  0x0,  0x1,  0x0,  -0x2, -0x1, 0x0,  0x0,  0x1,  0x0,  -0x2, -0x2, 0x0,  -0x2, -0x1, -0x2,
                0x0,  0x0,  -0x1, -0x2, 0x1,  -0x2, -0x1, 0x0,  -0x1, -0x1, -0x1, 0x0,  0x0,  -0x1, 0x1,  -0x1,
                -0x1, -0x1, -0x2, 0x0,  -0x2, 0x0,  0x1,  0x0,  -0x1, -0x1, 0x1,  0x1,  -0x1, 0x0,  -0x1, 0x1,
                0x1,  0x0,  -0x1, -0x2, 0x1,  -0x2, 0x1,  -0x2, -0x1, 0x1,  0x1,  -0x2, -0x2, 0x1,  -0x1,
            });
            try testArgs(@Vector(128, i2), .{
                -0x2, 0x0,  -0x2, 0x0,  0x0,  -0x2, -0x2, 0x0,  -0x2, 0x0,  -0x2, 0x0,  0x0,  0x0,  -0x2, 0x0,
                -0x2, -0x2, 0x0,  0x0,  0x0,  -0x2, 0x0,  0x0,  0x0,  -0x2, 0x0,  -0x2, -0x2, 0x0,  0x0,  -0x2,
                -0x2, 0x0,  -0x2, 0x0,  0x0,  -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, 0x0,  -0x2, 0x0,  -0x2, 0x0,
                0x0,  -0x2, 0x0,  -0x2, 0x0,  0x0,  0x0,  -0x2, -0x2, 0x0,  0x0,  -0x2, -0x2, -0x2, -0x2, -0x2,
                -0x2, -0x2, -0x2, -0x2, -0x2, 0x0,  0x0,  0x0,  -0x2, -0x2, -0x2, -0x2, 0x0,  0x0,  0x0,  -0x2,
                0x0,  -0x2, 0x0,  0x0,  -0x2, 0x0,  0x0,  -0x2, -0x2, 0x0,  -0x2, 0x0,  0x0,  0x0,  0x0,  0x0,
                0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  -0x2, 0x0,  -0x2, -0x2, -0x2, -0x2, 0x0,  0x0,  0x0,  -0x2,
                0x0,  -0x2, -0x2, -0x2, 0x0,  0x0,  -0x2, 0x0,  -0x2, -0x2, 0x0,  -0x2, 0x0,  -0x2, 0x0,  0x0,
            });
            try testArgs(@Vector(129, i2), .{
                -0x1, -0x2, -0x2, -0x2, -0x2, -0x2, -0x1, -0x1, -0x1, -0x2, -0x1, -0x2, -0x2, -0x1, -0x2, -0x1,
                -0x2, -0x2, -0x2, -0x2, -0x1, -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x2, -0x1, -0x2, -0x2, -0x2, -0x1, -0x2, -0x1, -0x1, -0x2, -0x2, -0x2,
                -0x1, -0x1, -0x1, -0x1, -0x1, -0x2, -0x2, -0x1, -0x2, -0x1, -0x2, -0x2, -0x2, -0x1, -0x1, -0x1,
                -0x1, -0x2, -0x2, -0x2, -0x1, -0x1, -0x2, -0x2, -0x1, -0x2, -0x1, -0x2, -0x1, -0x1, -0x2, -0x2,
                -0x1, -0x1, -0x2, -0x1, -0x1, -0x2, -0x1, -0x2, -0x1, -0x1, -0x1, -0x1, -0x1, -0x2, -0x2, -0x1,
                -0x1, -0x1, -0x1, -0x1, -0x2, -0x2, -0x2, -0x2, -0x2, -0x2, -0x1, -0x1, -0x2, -0x2, -0x2, -0x1,
                -0x2, -0x1, -0x2, -0x1, -0x1, -0x2, -0x1, -0x2, -0x2, -0x1, -0x2, -0x2, -0x2, -0x1, -0x1, -0x2,
                -0x2,
            });

            try testArgs(@Vector(1, u2), .{
                0x2,
            });
            try testArgs(@Vector(2, u2), .{
                0x3, 0x1,
            });
            try testArgs(@Vector(3, u2), .{
                0x1, 0x3, 0x3,
            });
            try testArgs(@Vector(4, u2), .{
                0x0, 0x2, 0x2, 0x1,
            });
            try testArgs(@Vector(5, u2), .{
                0x1, 0x3, 0x3, 0x0, 0x0,
            });
            try testArgs(@Vector(7, u2), .{
                0x2, 0x3, 0x2, 0x2, 0x2, 0x3, 0x2,
            });
            try testArgs(@Vector(8, u2), .{
                0x2, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3,
            });
            try testArgs(@Vector(9, u2), .{
                0x3, 0x3, 0x2, 0x3, 0x0, 0x0, 0x0, 0x2, 0x3,
            });
            try testArgs(@Vector(15, u2), .{
                0x1, 0x2, 0x3, 0x3, 0x1, 0x0, 0x3, 0x2, 0x3, 0x3, 0x2, 0x1, 0x0, 0x1, 0x0,
            });
            try testArgs(@Vector(16, u2), .{
                0x1, 0x3, 0x0, 0x2, 0x2, 0x3, 0x1, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 0x2,
            });
            try testArgs(@Vector(17, u2), .{
                0x1, 0x0, 0x3, 0x0, 0x3, 0x1, 0x3, 0x0, 0x2, 0x0, 0x3, 0x3, 0x1, 0x3, 0x1, 0x3,
                0x2,
            });
            try testArgs(@Vector(31, u2), .{
                0x2, 0x2, 0x1, 0x3, 0x3, 0x2, 0x2, 0x1, 0x3, 0x0, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3,
                0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, 0x1, 0x3, 0x0, 0x0,
            });
            try testArgs(@Vector(32, u2), .{
                0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
                0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1,
            });
            try testArgs(@Vector(33, u2), .{
                0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2,
                0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3,
                0x2,
            });
            try testArgs(@Vector(63, u2), .{
                0x1, 0x1, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x0, 0x0, 0x1, 0x2, 0x0, 0x1, 0x0,
                0x0, 0x1, 0x2, 0x1, 0x1, 0x0, 0x0, 0x0, 0x2, 0x2, 0x3, 0x3, 0x3, 0x2, 0x1, 0x0,
                0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x2, 0x1, 0x3, 0x3, 0x2, 0x3, 0x2, 0x1, 0x1, 0x3,
                0x1, 0x3, 0x3, 0x0, 0x2, 0x3, 0x3, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x3, 0x3,
            });
            try testArgs(@Vector(64, u2), .{
                0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x3, 0x0, 0x3, 0x1, 0x2, 0x0, 0x2, 0x2,
                0x3, 0x2, 0x0, 0x3, 0x0, 0x3, 0x0, 0x1, 0x1, 0x1, 0x0, 0x3, 0x1, 0x0, 0x3, 0x1,
                0x1, 0x0, 0x3, 0x2, 0x3, 0x3, 0x2, 0x3, 0x0, 0x1, 0x0, 0x2, 0x3, 0x3, 0x1, 0x2,
                0x2, 0x2, 0x0, 0x2, 0x3, 0x3, 0x0, 0x1, 0x2, 0x2, 0x1, 0x1, 0x0, 0x3, 0x3, 0x3,
            });
            try testArgs(@Vector(65, u2), .{
                0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x3, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x3,
                0x3, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x2, 0x2,
                0x2, 0x2, 0x2, 0x3, 0x3, 0x2, 0x3, 0x3, 0x2, 0x3, 0x3, 0x2, 0x3, 0x2, 0x2, 0x3,
                0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3,
                0x3,
            });
            try testArgs(@Vector(127, u2), .{
                0x2, 0x2, 0x2, 0x3, 0x2, 0x3, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2,
                0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3,
                0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x2,
                0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3,
                0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2,
                0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3,
                0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x2,
                0x3, 0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2,
            });
            try testArgs(@Vector(128, u2), .{
                0x3, 0x1, 0x2, 0x3, 0x0, 0x1, 0x2, 0x0, 0x3, 0x2, 0x3, 0x1, 0x1, 0x3, 0x3, 0x3,
                0x2, 0x0, 0x0, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x1,
                0x0, 0x3, 0x1, 0x2, 0x3, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x1,
                0x3, 0x0, 0x0, 0x3, 0x2, 0x1, 0x3, 0x1, 0x0, 0x0, 0x3, 0x2, 0x0, 0x2, 0x1, 0x0,
                0x2, 0x0, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x3, 0x2, 0x3, 0x3, 0x1, 0x3, 0x3,
                0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x0, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x0, 0x1,
                0x1, 0x1, 0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x1, 0x1, 0x1,
                0x3, 0x1, 0x1, 0x2, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x3, 0x3, 0x1, 0x0, 0x3, 0x1,
            });
            try testArgs(@Vector(129, u2), .{
                0x2, 0x0, 0x0, 0x0, 0x2, 0x1, 0x3, 0x1, 0x1, 0x2, 0x0, 0x1, 0x2, 0x2, 0x0, 0x1,
                0x1, 0x0, 0x0, 0x3, 0x3, 0x3, 0x0, 0x3, 0x3, 0x1, 0x3, 0x0, 0x0, 0x1, 0x2, 0x3,
                0x1, 0x3, 0x2, 0x2, 0x3, 0x0, 0x2, 0x1, 0x2, 0x3, 0x3, 0x3, 0x1, 0x1, 0x1, 0x2,
                0x0, 0x2, 0x2, 0x2, 0x0, 0x2, 0x3, 0x0, 0x0, 0x2, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0,
                0x0, 0x0, 0x0, 0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 0x2, 0x3, 0x0, 0x2, 0x0, 0x0, 0x3,
                0x1, 0x0, 0x3, 0x2, 0x3, 0x0, 0x0, 0x2, 0x3, 0x0, 0x3, 0x0, 0x0, 0x2, 0x1, 0x1,
                0x2, 0x3, 0x0, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x2, 0x1, 0x2, 0x2, 0x0,
                0x3, 0x3, 0x3, 0x3, 0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x3, 0x3, 0x1, 0x1, 0x3, 0x1,
                0x0,
            });

            try testArgs(@Vector(1, i3), .{
                -0x3,
            });
            try testArgs(@Vector(2, i3), .{
                -0x4, -0x3,
            });
            try testArgs(@Vector(3, i3), .{
                0x1, -0x1, 0x3,
            });
            try testArgs(@Vector(4, i3), .{
                -0x3, 0x0, 0x2, 0x3,
            });
            try testArgs(@Vector(5, i3), .{
                -0x1, -0x1, -0x2, 0x3, 0x0,
            });
            try testArgs(@Vector(7, i3), .{
                0x2, 0x2, -0x4, -0x4, 0x1, 0x0, 0x1,
            });
            try testArgs(@Vector(8, i3), .{
                0x1, 0x2, -0x4, -0x3, 0x1, 0x0, -0x2, -0x1,
            });
            try testArgs(@Vector(9, i3), .{
                0x0, -0x1, 0x3, -0x2, 0x1, -0x3, -0x3, -0x2, -0x1,
            });
            try testArgs(@Vector(15, i3), .{
                -0x1, -0x3, -0x4, -0x3, -0x1, -0x3, -0x3, -0x4, -0x1, -0x2, -0x1, -0x1, -0x2, -0x2, -0x2,
            });
            try testArgs(@Vector(16, i3), .{
                0x1, -0x3, 0x3, -0x3, 0x3, -0x3, 0x3, 0x1, 0x1, -0x3, -0x3, -0x1, 0x1, 0x3, 0x3, -0x3,
            });
            try testArgs(@Vector(17, i3), .{
                0x2,  -0x4, -0x2, 0x0, 0x2, -0x2, -0x2, 0x0, 0x2, -0x2, -0x4, 0x0, -0x4, -0x2, 0x2, -0x2,
                -0x4,
            });
            try testArgs(@Vector(31, i3), .{
                -0x4, -0x4, 0x2, 0x0,  -0x4, 0x0,  0x2,  -0x2, -0x2, -0x4, -0x2, 0x0, -0x4, 0x0,  -0x4, 0x0,
                0x2,  -0x4, 0x0, -0x2, -0x4, -0x4, -0x4, -0x4, 0x0,  -0x4, -0x2, 0x0, -0x2, -0x4, 0x0,
            });
            try testArgs(@Vector(32, i3), .{
                -0x1, 0x3,  0x3, 0x3,  0x0, -0x2, 0x0,  0x1,  0x1, -0x1, -0x2, -0x2, 0x3, 0x2,  0x1,  -0x1,
                0x3,  -0x3, 0x1, -0x4, 0x3, 0x1,  -0x2, -0x1, 0x2, 0x1,  0x0,  0x3,  0x1, -0x4, -0x1, 0x0,
            });
            try testArgs(@Vector(33, i3), .{
                -0x2, 0x0,  0x0,  0x2, -0x4, -0x2, -0x4, 0x2,  0x2, 0x2,  0x0,  -0x4, 0x0,  0x2, 0x2,  -0x4,
                -0x2, -0x2, -0x4, 0x0, 0x2,  0x0,  0x0,  -0x2, 0x2, -0x4, -0x4, -0x2, -0x2, 0x0, -0x2, -0x2,
                0x2,
            });
            try testArgs(@Vector(63, i3), .{
                -0x1, -0x2, -0x1, -0x2, -0x2, -0x2, -0x2, 0x2,  0x3,  -0x1, 0x2, -0x1, 0x3, -0x1, -0x1, 0x3,
                -0x2, -0x1, 0x2,  0x3,  0x2,  -0x2, -0x2, 0x3,  -0x2, -0x2, 0x3, -0x1, 0x3, -0x1, -0x1, -0x1,
                -0x2, 0x2,  -0x1, 0x3,  0x3,  0x3,  -0x2, 0x3,  0x2,  -0x2, 0x3, -0x1, 0x3, 0x3,  -0x2, 0x3,
                -0x1, 0x2,  0x3,  -0x2, -0x1, -0x2, -0x2, -0x1, -0x1, 0x3,  0x2, 0x3,  0x2, -0x2, -0x1,
            });
            try testArgs(@Vector(64, i3), .{
                -0x2, -0x4, 0x1,  0x2,  -0x2, 0x3,  -0x3, -0x3, 0x1,  0x3,  0x2, 0x2, -0x3, 0x3,  0x2,  -0x2,
                0x0,  -0x4, -0x4, -0x3, -0x3, 0x0,  -0x1, 0x0,  0x0,  0x2,  0x1, 0x1, 0x1,  0x3,  0x0,  0x2,
                -0x3, -0x2, 0x3,  0x3,  -0x3, -0x1, -0x1, 0x3,  0x0,  0x3,  0x2, 0x0, -0x2, 0x0,  -0x4, -0x4,
                0x2,  0x2,  0x0,  0x0,  0x3,  -0x1, 0x0,  -0x3, -0x2, -0x1, 0x1, 0x1, -0x4, -0x4, -0x3, 0x1,
            });
            try testArgs(@Vector(65, i3), .{
                0x0, 0x2, 0x0, 0x3, 0x3, 0x2, 0x0, 0x2, 0x3, 0x3, 0x1, 0x3, 0x1, 0x3, 0x2, 0x0,
                0x0, 0x1, 0x0, 0x2, 0x2, 0x3, 0x2, 0x2, 0x0, 0x1, 0x0, 0x2, 0x1, 0x1, 0x3, 0x2,
                0x0, 0x1, 0x0, 0x1, 0x2, 0x1, 0x3, 0x3, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x3, 0x2,
                0x2, 0x0, 0x3, 0x1, 0x2, 0x2, 0x0, 0x1, 0x3, 0x3, 0x3, 0x0, 0x3, 0x3, 0x3, 0x1,
                0x0,
            });
            try testArgs(@Vector(127, i3), .{
                0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 0x2, 0x3, 0x3, 0x2, 0x1,
                0x1, 0x0, 0x2, 0x1, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x1, 0x2, 0x0, 0x0, 0x3, 0x3,
                0x2, 0x3, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x0, 0x3, 0x1, 0x3, 0x3, 0x3,
                0x3, 0x1, 0x2, 0x0, 0x2, 0x1, 0x0, 0x1, 0x1, 0x2, 0x3, 0x1, 0x2, 0x1, 0x3, 0x2,
                0x2, 0x3, 0x1, 0x0, 0x1, 0x3, 0x0, 0x0, 0x3, 0x1, 0x0, 0x2, 0x1, 0x3, 0x0, 0x2,
                0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x0, 0x0, 0x2, 0x0, 0x1, 0x0, 0x2, 0x2,
                0x0, 0x1, 0x1, 0x3, 0x2, 0x3, 0x1, 0x1, 0x3, 0x0, 0x2, 0x2, 0x0, 0x2, 0x3, 0x3,
                0x2, 0x3, 0x1, 0x1, 0x2, 0x1, 0x3, 0x0, 0x3, 0x3, 0x0, 0x0, 0x1, 0x0, 0x1,
            });
            try testArgs(@Vector(128, i3), .{
                0x3,  -0x2, -0x1, -0x2, 0x2,  0x0,  -0x1, 0x2,  -0x3, -0x1, 0x2,  0x0,  0x0,  0x0,  0x0,  -0x1,
                -0x3, 0x3,  -0x3, 0x0,  -0x4, -0x4, 0x0,  -0x1, 0x1,  0x2,  0x3,  -0x2, -0x3, 0x3,  -0x3, 0x2,
                -0x2, 0x1,  -0x3, 0x1,  -0x4, -0x3, -0x4, -0x2, -0x3, 0x2,  0x0,  -0x1, 0x3,  0x1,  0x1,  -0x1,
                -0x4, 0x2,  -0x4, 0x0,  -0x3, -0x2, -0x1, -0x4, 0x2,  -0x4, 0x2,  0x2,  0x0,  0x3,  -0x4, 0x2,
                -0x4, -0x3, 0x0,  -0x3, 0x3,  -0x1, 0x3,  0x3,  -0x2, 0x3,  -0x1, 0x0,  0x0,  0x1,  0x3,  -0x3,
                -0x1, 0x1,  0x1,  0x2,  0x3,  0x3,  0x0,  0x3,  0x0,  0x1,  -0x1, -0x3, -0x4, -0x3, 0x2,  -0x4,
                0x2,  0x1,  0x2,  -0x2, 0x2,  0x0,  -0x3, -0x4, -0x3, -0x1, 0x1,  0x0,  -0x4, -0x3, -0x1, -0x3,
                0x3,  -0x3, 0x1,  0x3,  -0x3, 0x2,  -0x4, -0x3, 0x2,  0x2,  -0x4, 0x3,  -0x3, 0x0,  0x2,  -0x4,
            });
            try testArgs(@Vector(129, i3), .{
                -0x3, -0x3, -0x4, -0x3, 0x1,  -0x4, -0x4, -0x4, -0x4, -0x4, -0x3, 0x0,  -0x3, 0x1,  0x1,  -0x4,
                -0x3, 0x0,  -0x4, 0x0,  -0x3, 0x1,  -0x4, 0x0,  -0x4, 0x0,  0x1,  -0x3, -0x4, -0x4, 0x1,  0x1,
                0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  -0x3, -0x3, 0x1,  0x0,  -0x3, -0x3, -0x4, 0x1,  -0x4, -0x4,
                0x0,  0x1,  0x1,  0x0,  0x0,  0x0,  -0x4, -0x4, -0x4, 0x1,  0x0,  -0x3, 0x0,  -0x4, -0x3, -0x4,
                -0x3, -0x4, 0x0,  -0x4, -0x4, 0x0,  -0x4, 0x1,  0x0,  0x1,  -0x3, 0x0,  -0x3, -0x4, -0x3, -0x4,
                0x0,  0x1,  -0x4, -0x4, 0x0,  -0x4, 0x0,  -0x3, -0x3, -0x3, -0x3, -0x3, -0x3, 0x1,  0x1,  0x0,
                -0x3, -0x3, -0x3, 0x1,  -0x3, 0x0,  0x0,  0x0,  0x0,  0x0,  -0x4, 0x0,  -0x3, -0x3, 0x0,  0x1,
                0x1,  -0x4, -0x4, -0x3, -0x3, 0x0,  -0x4, 0x1,  -0x3, -0x4, 0x0,  0x1,  -0x3, -0x4, 0x1,  0x1,
                -0x4,
            });

            try testArgs(@Vector(1, u3), .{
                0x5,
            });
            try testArgs(@Vector(2, u3), .{
                0x4, 0x6,
            });
            try testArgs(@Vector(3, u3), .{
                0x4, 0x1, 0x1,
            });
            try testArgs(@Vector(4, u3), .{
                0x1, 0x4, 0x1, 0x5,
            });
            try testArgs(@Vector(5, u3), .{
                0x3, 0x4, 0x6, 0x4, 0x5,
            });
            try testArgs(@Vector(7, u3), .{
                0x1, 0x3, 0x1, 0x3, 0x7, 0x1, 0x1,
            });
            try testArgs(@Vector(8, u3), .{
                0x6, 0x0, 0x0, 0x4, 0x2, 0x4, 0x0, 0x6,
            });
            try testArgs(@Vector(9, u3), .{
                0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 0x0, 0x6, 0x6,
            });
            try testArgs(@Vector(15, u3), .{
                0x7, 0x5, 0x4, 0x3, 0x6, 0x6, 0x6, 0x1, 0x5, 0x5, 0x6, 0x4, 0x2, 0x3, 0x0,
            });
            try testArgs(@Vector(16, u3), .{
                0x7, 0x6, 0x2, 0x7, 0x2, 0x7, 0x7, 0x2, 0x6, 0x2, 0x3, 0x6, 0x3, 0x2, 0x3, 0x7,
            });
            try testArgs(@Vector(17, u3), .{
                0x4, 0x2, 0x2, 0x0, 0x2, 0x0, 0x4, 0x4, 0x6, 0x2, 0x2, 0x6, 0x0, 0x0, 0x0, 0x2,
                0x2,
            });
            try testArgs(@Vector(31, u3), .{
                0x3, 0x0, 0x5, 0x3, 0x3, 0x5, 0x2, 0x3, 0x3, 0x6, 0x1, 0x3, 0x5, 0x7, 0x6, 0x6,
                0x6, 0x6, 0x0, 0x6, 0x4, 0x5, 0x3, 0x3, 0x3, 0x3, 0x0, 0x2, 0x7, 0x0, 0x0,
            });
            try testArgs(@Vector(32, u3), .{
                0x7, 0x1, 0x3, 0x1, 0x7, 0x1, 0x5, 0x1, 0x1, 0x5, 0x5, 0x5, 0x1, 0x1, 0x5, 0x1,
                0x3, 0x1, 0x3, 0x1, 0x7, 0x5, 0x1, 0x5, 0x1, 0x3, 0x7, 0x5, 0x3, 0x5, 0x5, 0x5,
            });
            try testArgs(@Vector(33, u3), .{
                0x3, 0x2, 0x4, 0x2, 0x7, 0x2, 0x1, 0x5, 0x6, 0x0, 0x0, 0x3, 0x0, 0x6, 0x2, 0x5,
                0x2, 0x4, 0x1, 0x4, 0x4, 0x1, 0x0, 0x7, 0x7, 0x2, 0x1, 0x5, 0x4, 0x2, 0x1, 0x0,
                0x3,
            });
            try testArgs(@Vector(63, u3), .{
                0x0, 0x6, 0x5, 0x1, 0x4, 0x7, 0x5, 0x4, 0x5, 0x3, 0x0, 0x5, 0x5, 0x7, 0x4, 0x5,
                0x0, 0x0, 0x2, 0x7, 0x2, 0x6, 0x0, 0x1, 0x4, 0x7, 0x4, 0x5, 0x5, 0x2, 0x2, 0x0,
                0x5, 0x4, 0x6, 0x0, 0x1, 0x2, 0x2, 0x1, 0x3, 0x5, 0x0, 0x2, 0x3, 0x5, 0x5, 0x2,
                0x3, 0x6, 0x3, 0x7, 0x1, 0x5, 0x5, 0x2, 0x1, 0x2, 0x7, 0x6, 0x2, 0x4, 0x5,
            });
            try testArgs(@Vector(64, u3), .{
                0x2, 0x1, 0x3, 0x3, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x2,
                0x0, 0x0, 0x0, 0x3, 0x3, 0x1, 0x3, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x3,
                0x2, 0x3, 0x1, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x1, 0x3, 0x2, 0x0, 0x3, 0x2,
                0x3, 0x2, 0x1, 0x1, 0x2, 0x2, 0x0, 0x2, 0x2, 0x1, 0x3, 0x1, 0x3, 0x3, 0x3, 0x3,
            });
            try testArgs(@Vector(65, u3), .{
                0x4, 0x5, 0x6, 0x6, 0x7, 0x4, 0x4, 0x4, 0x6, 0x5, 0x6, 0x5, 0x7, 0x4, 0x6, 0x5,
                0x4, 0x6, 0x4, 0x7, 0x4, 0x4, 0x4, 0x4, 0x7, 0x4, 0x7, 0x6, 0x6, 0x4, 0x5, 0x6,
                0x7, 0x7, 0x4, 0x6, 0x6, 0x4, 0x5, 0x6, 0x4, 0x5, 0x7, 0x7, 0x7, 0x7, 0x5, 0x5,
                0x6, 0x6, 0x7, 0x5, 0x6, 0x4, 0x5, 0x6, 0x5, 0x6, 0x4, 0x6, 0x4, 0x6, 0x6, 0x5,
                0x5,
            });
            try testArgs(@Vector(127, u3), .{
                0x0, 0x5, 0x0, 0x0, 0x5, 0x6, 0x5, 0x1, 0x3, 0x3, 0x3, 0x2, 0x5, 0x5, 0x3, 0x7,
                0x6, 0x4, 0x5, 0x4, 0x3, 0x6, 0x1, 0x5, 0x5, 0x4, 0x2, 0x2, 0x1, 0x5, 0x0, 0x2,
                0x7, 0x3, 0x0, 0x7, 0x0, 0x7, 0x2, 0x2, 0x5, 0x5, 0x3, 0x4, 0x4, 0x0, 0x5, 0x1,
                0x7, 0x2, 0x6, 0x4, 0x7, 0x3, 0x5, 0x6, 0x3, 0x5, 0x5, 0x6, 0x4, 0x3, 0x4, 0x1,
                0x1, 0x4, 0x6, 0x7, 0x5, 0x0, 0x2, 0x0, 0x1, 0x3, 0x2, 0x2, 0x5, 0x3, 0x0, 0x1,
                0x5, 0x4, 0x2, 0x0, 0x0, 0x4, 0x3, 0x2, 0x7, 0x6, 0x6, 0x7, 0x1, 0x1, 0x5, 0x1,
                0x6, 0x4, 0x1, 0x7, 0x0, 0x7, 0x1, 0x1, 0x3, 0x6, 0x5, 0x1, 0x0, 0x5, 0x4, 0x0,
                0x7, 0x7, 0x7, 0x2, 0x0, 0x1, 0x6, 0x0, 0x4, 0x2, 0x3, 0x7, 0x7, 0x2, 0x2,
            });
            try testArgs(@Vector(128, u3), .{
                0x2, 0x4, 0x4, 0x6, 0x2, 0x6, 0x6, 0x2, 0x2, 0x0, 0x6, 0x6, 0x0, 0x0, 0x2, 0x4,
                0x0, 0x0, 0x4, 0x6, 0x2, 0x0, 0x6, 0x6, 0x0, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x6,
                0x6, 0x6, 0x4, 0x4, 0x2, 0x4, 0x4, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x4, 0x0, 0x6,
                0x2, 0x6, 0x0, 0x0, 0x2, 0x4, 0x2, 0x4, 0x6, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0,
                0x0, 0x2, 0x4, 0x4, 0x2, 0x6, 0x0, 0x4, 0x6, 0x6, 0x6, 0x2, 0x4, 0x6, 0x4, 0x6,
                0x0, 0x4, 0x6, 0x6, 0x2, 0x0, 0x2, 0x2, 0x6, 0x4, 0x6, 0x6, 0x2, 0x0, 0x6, 0x4,
                0x2, 0x2, 0x2, 0x0, 0x2, 0x6, 0x6, 0x4, 0x4, 0x2, 0x6, 0x0, 0x2, 0x4, 0x2, 0x0,
                0x2, 0x2, 0x6, 0x4, 0x4, 0x0, 0x6, 0x4, 0x4, 0x2, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6,
            });
            try testArgs(@Vector(129, u3), .{
                0x4, 0x7, 0x3, 0x7, 0x5, 0x1, 0x7, 0x3, 0x7, 0x6, 0x1, 0x3, 0x2, 0x0, 0x1, 0x1,
                0x0, 0x4, 0x6, 0x5, 0x2, 0x5, 0x6, 0x7, 0x5, 0x2, 0x4, 0x7, 0x4, 0x3, 0x6, 0x4,
                0x1, 0x3, 0x0, 0x4, 0x5, 0x0, 0x2, 0x7, 0x5, 0x0, 0x1, 0x4, 0x4, 0x3, 0x0, 0x3,
                0x4, 0x4, 0x6, 0x2, 0x0, 0x5, 0x6, 0x5, 0x6, 0x7, 0x7, 0x1, 0x2, 0x5, 0x7, 0x4,
                0x5, 0x5, 0x2, 0x7, 0x5, 0x0, 0x5, 0x7, 0x0, 0x7, 0x0, 0x3, 0x5, 0x1, 0x0, 0x6,
                0x6, 0x4, 0x1, 0x7, 0x6, 0x7, 0x0, 0x0, 0x7, 0x6, 0x1, 0x1, 0x2, 0x4, 0x0, 0x1,
                0x7, 0x3, 0x3, 0x5, 0x6, 0x6, 0x6, 0x6, 0x2, 0x3, 0x4, 0x0, 0x4, 0x5, 0x1, 0x4,
                0x1, 0x5, 0x1, 0x0, 0x3, 0x1, 0x4, 0x7, 0x5, 0x6, 0x2, 0x0, 0x7, 0x2, 0x7, 0x1,
                0x0,
            });

            try testArgs(@Vector(1, i4), .{
                0x4,
            });
            try testArgs(@Vector(2, i4), .{
                0x5, 0x1,
            });
            try testArgs(@Vector(3, i4), .{
                -0x8, 0x2, 0x0,
            });
            try testArgs(@Vector(4, i4), .{
                0x4, -0x7, -0x8, -0x7,
            });
            try testArgs(@Vector(5, i4), .{
                -0x3, -0x6, -0x5, -0x7, -0x7,
            });
            try testArgs(@Vector(7, i4), .{
                0x4, -0x3, 0x7, 0x2, -0x6, -0x7, 0x5,
            });
            try testArgs(@Vector(8, i4), .{
                -0x5, -0x6, 0x0, 0x3, -0x8, -0x5, 0x3, 0x3,
            });
            try testArgs(@Vector(9, i4), .{
                0x5, 0x1, 0x5, -0x1, 0x3, -0x3, -0x3, 0x1, 0x1,
            });
            try testArgs(@Vector(15, i4), .{
                0x7, -0x7, 0x0, 0x0, 0x0, -0x8, 0x5, -0x1, 0x4, -0x5, -0x3, 0x6, -0x7, -0x8, -0x1,
            });
            try testArgs(@Vector(16, i4), .{
                0x7, -0x1, 0x4, 0x3, -0x5, -0x4, -0x1, -0x8, -0x7, 0x6, -0x6, 0x6, -0x6, 0x6, -0x3, 0x7,
            });
            try testArgs(@Vector(17, i4), .{
                0x4, 0x2, 0x6, 0x3, 0x6, 0x2, 0x1, 0x5, 0x3, 0x4, 0x5, 0x2, 0x0, 0x0, 0x1, 0x5,
                0x0,
            });
            try testArgs(@Vector(31, i4), .{
                0x6, 0x4, 0x7,  -0x8, 0x7,  -0x8, 0x5, 0x7, -0x1, -0x5, -0x6, -0x3, -0x4, 0x1, 0x5,  0x3,
                0x0, 0x5, -0x6, 0x0,  -0x1, -0x8, 0x1, 0x7, 0x2,  0x3,  -0x3, 0x5,  -0x2, 0x2, -0x6,
            });
            try testArgs(@Vector(32, i4), .{
                -0x3, -0x4, -0x4, -0x8, 0x2,  0x3,  -0x2, 0x4,  -0x5, 0x7,  0x0,  -0x7, -0x3, 0x2, 0x3, 0x3,
                0x5,  -0x1, -0x8, 0x0,  -0x3, -0x1, -0x8, -0x6, -0x5, -0x4, -0x3, 0x2,  0x4,  0x3, 0x3, 0x2,
            });
            try testArgs(@Vector(33, i4), .{
                0x5,  0x6, 0x7, -0x1, -0x8, 0x5, 0x1,  0x7, 0x5,  -0x2, 0x3,  -0x1, 0x0,  0x0, -0x1, -0x2,
                -0x3, 0x3, 0x0, -0x2, 0x0,  0x7, -0x7, 0x1, -0x8, 0x5,  -0x6, -0x3, -0x3, 0x6, 0x0,  0x6,
                -0x3,
            });
            try testArgs(@Vector(63, i4), .{
                -0x7, -0x8, 0x2, 0x6,  0x6, -0x6, -0x8, -0x7, 0x7,  -0x3, -0x5, -0x1, -0x8, -0x4, 0x1,  -0x6,
                -0x4, -0x1, 0x2, -0x3, 0x4, 0x3,  0x0,  -0x3, 0x7,  0x1,  -0x5, -0x4, 0x2,  0x5,  0x7,  0x5,
                -0x4, -0x2, 0x0, -0x2, 0x3, 0x2,  0x0,  -0x1, -0x7, -0x2, -0x2, 0x6,  0x3,  -0x6, -0x6, -0x5,
                0x4,  -0x1, 0x3, 0x4,  0x7, -0x1, -0x5, -0x8, -0x5, -0x7, 0x3,  0x2,  -0x6, -0x8, -0x3,
            });
            try testArgs(@Vector(64, i4), .{
                -0x6, -0x8, -0x3, 0x5,  -0x7, -0x3, -0x8, -0x6, 0x3,  0x6,  0x5,  0x7, -0x7, 0x5,  0x4,  -0x8,
                -0x4, -0x2, -0x1, -0x4, 0x3,  0x4,  0x3,  -0x8, -0x5, 0x6,  0x7,  0x3, 0x6,  -0x1, 0x4,  0x2,
                -0x6, 0x4,  -0x1, 0x2,  -0x1, -0x2, -0x4, 0x4,  -0x2, -0x2, -0x3, 0x1, 0x0,  0x2,  -0x7, -0x8,
                0x1,  -0x7, -0x5, 0x6,  0x2,  0x7,  -0x6, 0x7,  -0x5, 0x0,  -0x6, 0x2, 0x6,  0x4,  -0x3, -0x6,
            });
            try testArgs(@Vector(65, i4), .{
                0x4,  -0x3, -0x1, 0x0,  -0x1, -0x7, 0x4,  -0x7, -0x3, -0x1, -0x5, 0x2,  -0x3, 0x5,  -0x8, 0x7,
                -0x7, 0x0,  0x2,  -0x7, 0x4,  -0x5, -0x4, 0x7,  -0x2, 0x6,  0x3,  0x4,  -0x1, 0x2,  0x5,  0x7,
                -0x2, 0x7,  0x2,  -0x1, 0x2,  0x2,  0x2,  0x7,  -0x2, -0x2, -0x5, 0x4,  0x7,  0x0,  0x3,  0x1,
                0x0,  -0x5, -0x1, 0x6,  0x2,  -0x3, -0x7, -0x4, 0x2,  -0x5, 0x4,  -0x7, 0x2,  -0x4, 0x2,  -0x1,
                -0x2,
            });
            try testArgs(@Vector(127, i4), .{
                -0x2, 0x2,  0x6,  0x3,  0x1,  -0x2, 0x1,  0x1,  -0x4, 0x5,  -0x5, 0x7,  0x7,  -0x5, -0x5, -0x6,
                0x0,  -0x8, 0x4,  0x7,  0x4,  -0x1, 0x3,  0x7,  -0x5, 0x7,  -0x8, 0x6,  -0x7, -0x6, 0x3,  -0x6,
                -0x4, -0x8, 0x1,  -0x7, 0x7,  0x2,  -0x2, 0x5,  0x1,  -0x8, -0x3, -0x5, -0x8, 0x0,  -0x4, 0x0,
                -0x8, 0x5,  -0x8, 0x0,  0x4,  -0x4, -0x4, -0x5, 0x2,  -0x8, -0x3, -0x1, -0x7, 0x0,  0x0,  -0x4,
                -0x5, 0x5,  -0x1, -0x7, -0x7, -0x8, -0x2, 0x7,  0x4,  0x6,  0x4,  0x5,  -0x1, 0x3,  -0x4, 0x7,
                -0x1, -0x1, 0x3,  0x1,  0x4,  0x1,  -0x3, 0x2,  -0x2, -0x6, -0x4, 0x5,  -0x7, -0x2, 0x0,  0x5,
                -0x4, 0x4,  -0x7, -0x7, -0x3, 0x4,  -0x3, -0x3, -0x7, -0x8, 0x1,  0x6,  0x5,  -0x3, -0x4, 0x7,
                0x3,  0x5,  0x0,  -0x7, -0x1, -0x7, 0x5,  0x1,  -0x4, -0x6, 0x6,  0x6,  -0x1, 0x1,  0x6,
            });
            try testArgs(@Vector(128, i4), .{
                -0x2, 0x3,  -0x1, -0x6, 0x1,  -0x7, 0x4,  0x4,  0x2, -0x5, 0x0,  0x4,  0x3,  0x2,  0x0,  -0x7,
                0x4,  -0x5, -0x6, -0x8, 0x7,  -0x8, 0x5,  0x3,  0x2, 0x5,  0x3,  -0x8, -0x8, -0x8, 0x1,  0x4,
                -0x3, -0x5, 0x6,  0x2,  -0x4, -0x2, 0x3,  -0x1, 0x1, -0x2, -0x7, -0x8, 0x5,  0x5,  0x3,  -0x6,
                0x3,  0x5,  0x7,  -0x7, 0x3,  0x6,  0x5,  0x2,  0x2, -0x3, 0x0,  -0x5, 0x7,  -0x8, 0x1,  0x1,
                0x6,  0x3,  0x1,  0x5,  -0x7, 0x1,  -0x5, -0x1, 0x4, -0x2, 0x1,  0x3,  0x4,  -0x3, 0x5,  0x1,
                -0x2, -0x6, -0x5, -0x1, -0x5, 0x6,  -0x5, 0x0,  0x0, -0x8, -0x8, 0x3,  -0x5, 0x3,  -0x1, -0x7,
                -0x2, 0x0,  0x3,  -0x3, -0x6, -0x5, -0x2, -0x5, 0x0, -0x1, 0x6,  -0x6, 0x4,  0x5,  0x6,  -0x3,
                -0x7, -0x4, 0x2,  0x5,  0x0,  -0x5, 0x7,  0x6,  0x2, 0x6,  0x6,  -0x2, 0x7,  -0x2, 0x0,  0x3,
            });
            try testArgs(@Vector(129, i4), .{
                0x3,  0x1,  0x3,  0x1,  0x2,  0x0,  -0x5, -0x6, -0x7, 0x2,  -0x6, 0x2,  0x0,  -0x8, -0x6, -0x6,
                0x0,  0x3,  0x2,  0x3,  -0x6, 0x2,  -0x6, -0x8, -0x6, 0x2,  -0x6, -0x7, 0x0,  0x3,  -0x7, 0x3,
                -0x5, -0x6, 0x0,  0x1,  0x0,  0x3,  0x2,  -0x5, -0x6, 0x3,  0x2,  0x0,  -0x5, 0x0,  0x0,  -0x7,
                -0x6, -0x6, -0x5, -0x8, 0x0,  -0x7, 0x3,  0x2,  -0x5, -0x6, -0x8, 0x3,  -0x8, 0x0,  -0x5, 0x0,
                -0x5, -0x5, 0x3,  -0x6, 0x3,  0x1,  0x3,  -0x5, 0x1,  -0x8, 0x0,  -0x6, -0x6, -0x8, -0x5, 0x0,
                0x2,  0x0,  0x0,  0x2,  -0x7, 0x3,  -0x5, -0x6, -0x5, 0x3,  0x1,  0x0,  -0x7, -0x5, -0x5, 0x3,
                0x0,  -0x5, 0x0,  0x0,  0x3,  0x2,  0x3,  0x3,  -0x7, 0x2,  0x0,  -0x6, -0x8, 0x2,  -0x6, -0x6,
                0x2,  0x0,  0x3,  -0x5, 0x1,  -0x7, 0x2,  0x0,  -0x7, 0x2,  -0x6, -0x6, 0x0,  0x2,  0x2,  0x1,
                -0x8,
            });

            try testArgs(@Vector(1, u4), .{
                0xb,
            });
            try testArgs(@Vector(2, u4), .{
                0x0, 0xf,
            });
            try testArgs(@Vector(3, u4), .{
                0x9, 0xa, 0xe,
            });
            try testArgs(@Vector(4, u4), .{
                0x0, 0x9, 0x9, 0x9,
            });
            try testArgs(@Vector(5, u4), .{
                0xe, 0x8, 0x9, 0xd, 0x9,
            });
            try testArgs(@Vector(7, u4), .{
                0x5, 0xc, 0x1, 0x4, 0x1, 0xe, 0xd,
            });
            try testArgs(@Vector(8, u4), .{
                0x4, 0x0, 0x0, 0x7, 0x2, 0x1, 0x2, 0x3,
            });
            try testArgs(@Vector(9, u4), .{
                0x9, 0x4, 0x8, 0x9, 0xc, 0x9, 0x9, 0xc, 0xd,
            });
            try testArgs(@Vector(15, u4), .{
                0x8, 0x5, 0xc, 0x4, 0x7, 0x0, 0x0, 0x7, 0x6, 0xc, 0x5, 0x9, 0xa, 0x0, 0x2,
            });
            try testArgs(@Vector(16, u4), .{
                0xf, 0xf, 0x7, 0xf, 0x7, 0xb, 0x2, 0x6, 0x6, 0xf, 0x2, 0xb, 0x3, 0xa, 0xa, 0x2,
            });
            try testArgs(@Vector(17, u4), .{
                0x0, 0x6, 0x1, 0x7, 0x7, 0x6, 0x0, 0x6, 0x6, 0x7, 0x6, 0x1, 0x5, 0x7, 0x7, 0x3,
                0x1,
            });
            try testArgs(@Vector(31, u4), .{
                0x3, 0x1, 0xa, 0xa, 0x1, 0x3, 0xa, 0xb, 0xb, 0x1, 0x1, 0xa, 0x8, 0x3, 0x0, 0x9,
                0x8, 0x9, 0x0, 0x8, 0x2, 0x0, 0x2, 0xb, 0x0, 0x0, 0x1, 0x1, 0x0, 0x8, 0x3,
            });
            try testArgs(@Vector(32, u4), .{
                0x8, 0x7, 0x3, 0x9, 0xd, 0x0, 0x8, 0xe, 0xb, 0x8, 0x4, 0x4, 0x4, 0x8, 0x4, 0x2,
                0xd, 0x9, 0x1, 0xe, 0x1, 0xc, 0x0, 0x9, 0xa, 0x5, 0x1, 0x6, 0x9, 0x1, 0xd, 0xe,
            });
            try testArgs(@Vector(33, u4), .{
                0x5, 0xd, 0x0, 0x7, 0x8, 0x0, 0xd, 0x5, 0x3, 0x0, 0xe, 0xf, 0xd, 0xd, 0x6, 0xd,
                0x4, 0x4, 0x4, 0x0, 0x4, 0x1, 0x2, 0x0, 0x4, 0x2, 0x2, 0x9, 0x3, 0x7, 0xf, 0xb,
                0xd,
            });
            try testArgs(@Vector(63, u4), .{
                0x2, 0x2, 0x8, 0x7, 0x7, 0x3, 0xa, 0x0, 0x7, 0x7, 0xe, 0xb, 0xb, 0xe, 0x8, 0x8,
                0xe, 0x7, 0x7, 0x7, 0x1, 0xe, 0xb, 0x7, 0x8, 0x2, 0x7, 0x9, 0xd, 0x0, 0x2, 0x1,
                0xb, 0xc, 0xb, 0xa, 0x8, 0xb, 0x5, 0x3, 0x2, 0xf, 0x6, 0x2, 0x7, 0x7, 0x4, 0x3,
                0x2, 0xd, 0xb, 0x6, 0x6, 0x2, 0xd, 0x4, 0x4, 0x9, 0x9, 0x4, 0x5, 0x8, 0x2,
            });
            try testArgs(@Vector(64, u4), .{
                0x2, 0x0, 0x1, 0xb, 0x1, 0x8, 0x2, 0xa, 0x3, 0x3, 0x1, 0x1, 0x8, 0xb, 0x3, 0x3,
                0x9, 0xa, 0x2, 0x2, 0x8, 0x8, 0x2, 0x3, 0xb, 0x3, 0x8, 0xa, 0x8, 0xa, 0x8, 0x8,
                0x2, 0x2, 0x1, 0x8, 0x1, 0x1, 0x9, 0xa, 0x0, 0x0, 0x0, 0x3, 0x8, 0xb, 0x2, 0x2,
                0xb, 0xb, 0xb, 0x0, 0xb, 0x2, 0x0, 0x2, 0x1, 0xb, 0xb, 0x1, 0xa, 0x9, 0xb, 0x0,
            });
            try testArgs(@Vector(65, u4), .{
                0xb, 0x2, 0xb, 0xf, 0xf, 0xe, 0x6, 0xa, 0xf, 0x7, 0x7, 0xf, 0xa, 0x7, 0x2, 0x3,
                0xb, 0x3, 0xe, 0x6, 0x7, 0xa, 0x6, 0x2, 0x6, 0xb, 0xe, 0xf, 0xe, 0xa, 0xf, 0xf,
                0xf, 0x2, 0x6, 0xb, 0xa, 0x7, 0xb, 0x7, 0xa, 0x2, 0xa, 0xe, 0xe, 0x3, 0xb, 0xa,
                0x3, 0x2, 0xe, 0x6, 0xf, 0x2, 0x6, 0xe, 0xf, 0xe, 0x7, 0x7, 0x3, 0xb, 0x2, 0x7,
                0x2,
            });
            try testArgs(@Vector(127, u4), .{
                0x3, 0x1, 0x6, 0xf, 0x2, 0x1, 0x2, 0x3, 0x3, 0x9, 0xe, 0x8, 0x4, 0xe, 0xd, 0x8,
                0x6, 0x4, 0xa, 0xe, 0xa, 0x6, 0xe, 0x5, 0x0, 0x8, 0x3, 0xd, 0x5, 0x9, 0x5, 0xd,
                0x7, 0x0, 0x9, 0xb, 0xc, 0xd, 0x3, 0x2, 0x9, 0x4, 0xb, 0xd, 0x5, 0xd, 0xb, 0x2,
                0xe, 0x0, 0x6, 0xf, 0x4, 0x4, 0x8, 0xf, 0xb, 0xe, 0xf, 0x9, 0x5, 0x7, 0x7, 0xb,
                0x4, 0xf, 0x5, 0x2, 0x3, 0x2, 0xd, 0x9, 0xd, 0x9, 0x6, 0xe, 0x9, 0x4, 0x1, 0xa,
                0x7, 0xb, 0xe, 0xd, 0x7, 0x7, 0xa, 0xa, 0x2, 0x9, 0x6, 0x7, 0x9, 0x6, 0x9, 0x9,
                0xd, 0x6, 0x0, 0x1, 0x1, 0x5, 0xf, 0xe, 0x4, 0x7, 0x3, 0x4, 0x7, 0xb, 0x7, 0xd,
                0x0, 0x8, 0xf, 0x5, 0x1, 0x7, 0xb, 0x7, 0x1, 0x3, 0x3, 0x0, 0xe, 0x0, 0x4,
            });
            try testArgs(@Vector(128, u4), .{
                0x0, 0xb, 0x9, 0x0, 0x6, 0xd, 0x9, 0x3, 0xd, 0xa, 0x4, 0xb, 0x8, 0x7, 0xc, 0xe,
                0x6, 0x9, 0xb, 0x5, 0xc, 0x8, 0xd, 0x8, 0xc, 0x3, 0x2, 0xd, 0x9, 0x9, 0x2, 0x7,
                0xa, 0x0, 0xf, 0x7, 0xd, 0x6, 0x0, 0x6, 0x8, 0x3, 0x3, 0x0, 0xa, 0x4, 0xf, 0x6,
                0x6, 0x6, 0x5, 0x8, 0x4, 0xe, 0x2, 0x3, 0x4, 0x7, 0x3, 0x5, 0xa, 0xc, 0x1, 0xf,
                0x0, 0xf, 0xd, 0x8, 0x2, 0xe, 0x0, 0xa, 0x9, 0x0, 0x0, 0xf, 0x3, 0x4, 0x3, 0xd,
                0x8, 0xd, 0xb, 0xd, 0x6, 0xc, 0xc, 0x9, 0x3, 0x5, 0xa, 0xe, 0x9, 0xf, 0x0, 0x9,
                0xa, 0xf, 0x4, 0xd, 0x4, 0xa, 0x3, 0xb, 0xe, 0x7, 0x8, 0x6, 0xc, 0x0, 0x3, 0xd,
                0xc, 0xc, 0x1, 0x5, 0x4, 0xc, 0xd, 0x9, 0xa, 0x7, 0xd, 0x2, 0x6, 0x3, 0x4, 0x2,
            });
            try testArgs(@Vector(129, u4), .{
                0xd, 0x2, 0xd, 0xd, 0xc, 0x7, 0x4, 0x1, 0xa, 0xc, 0xf, 0xe, 0xb, 0xc, 0xc, 0x8,
                0x0, 0x1, 0xf, 0x4, 0xb, 0x4, 0x7, 0x9, 0x9, 0x2, 0x7, 0xc, 0x4, 0xb, 0xd, 0xc,
                0x5, 0x5, 0xd, 0x9, 0x7, 0x2, 0x7, 0xa, 0x2, 0x4, 0x1, 0x3, 0x2, 0x4, 0x6, 0x8,
                0x9, 0xd, 0x9, 0x7, 0x1, 0x5, 0x5, 0x1, 0x3, 0x2, 0x4, 0x7, 0x3, 0xf, 0x2, 0xa,
                0x3, 0x5, 0xf, 0x4, 0x6, 0xd, 0xa, 0x1, 0xb, 0x3, 0xa, 0xd, 0x6, 0x0, 0x0, 0x7,
                0x0, 0xf, 0x0, 0xa, 0xf, 0x5, 0xc, 0x5, 0x5, 0x8, 0x8, 0x0, 0x5, 0x3, 0xf, 0x4,
                0xb, 0x7, 0x1, 0x0, 0x3, 0x6, 0x6, 0xd, 0xd, 0x5, 0xd, 0x4, 0x8, 0x9, 0x1, 0x8,
                0x7, 0x6, 0x4, 0x2, 0x7, 0x0, 0x6, 0x9, 0xb, 0x5, 0x6, 0x8, 0xd, 0xe, 0x5, 0x7,
                0x9,
            });

            try testArgs(@Vector(1, i5), .{
                -0x07,
            });
            try testArgs(@Vector(2, i5), .{
                0x00, 0x09,
            });
            try testArgs(@Vector(3, i5), .{
                0x08, -0x04, 0x04,
            });
            try testArgs(@Vector(4, i5), .{
                0x07, 0x06, -0x0a, 0x01,
            });
            try testArgs(@Vector(5, i5), .{
                -0x06, -0x06, -0x03, -0x06, 0x0e,
            });
            try testArgs(@Vector(7, i5), .{
                0x08, -0x0c, 0x05, 0x08, 0x02, -0x05, 0x06,
            });
            try testArgs(@Vector(8, i5), .{
                0x0b, -0x07, 0x01, 0x0d, -0x0e, -0x10, 0x0e, -0x01,
            });
            try testArgs(@Vector(9, i5), .{
                -0x02, -0x0e, -0x05, -0x0d, -0x10, -0x01, -0x0b, -0x0e, -0x05,
            });
            try testArgs(@Vector(15, i5), .{
                -0x09, 0x07, 0x00, -0x10, 0x00, -0x0a, -0x09, 0x00, 0x02, -0x10, -0x0a, -0x0d, 0x00, 0x05, -0x0f,
            });
            try testArgs(@Vector(16, i5), .{
                0x0f, 0x07, 0x0d, -0x05, -0x0f, -0x07, -0x01, -0x0d, -0x0f, -0x0f, -0x07, 0x05, -0x09, -0x01, -0x0b, 0x0b,
            });
            try testArgs(@Vector(17, i5), .{
                0x07, -0x08, 0x0e, 0x0a, -0x0f, -0x0c, -0x10, -0x0e, 0x0c, -0x05, 0x04, 0x06, 0x00, 0x07, -0x10, -0x0e,
                0x0f,
            });
            try testArgs(@Vector(31, i5), .{
                0x01,  0x0d, -0x04, -0x0b, 0x08, -0x08, -0x08, 0x00, 0x08, -0x08, -0x0b, -0x07, -0x0c, -0x03, 0x0c, 0x05,
                -0x03, 0x08, -0x07, 0x09,  0x0c, 0x01,  -0x10, 0x00, 0x09, -0x03, 0x09,  0x0d,  0x04,  0x09,  0x0c,
            });
            try testArgs(@Vector(32, i5), .{
                0x03,  -0x0d, -0x0f, 0x01,  -0x0f, -0x07, -0x03, -0x0f, 0x07,  -0x06, 0x02, 0x01, 0x0f, -0x0c, -0x0f, -0x0a,
                -0x07, -0x06, -0x02, -0x08, 0x08,  0x05,  -0x0f, 0x0b,  -0x02, -0x0e, 0x07, 0x02, 0x07, -0x04, 0x0b,  0x0d,
            });
            try testArgs(@Vector(33, i5), .{
                -0x0e, -0x08, -0x02, -0x0e, -0x04, -0x02, -0x08, -0x10, 0x04, 0x0c,  0x02, -0x10, -0x02, 0x08, -0x0c, -0x06,
                -0x0a, -0x06, -0x10, -0x02, 0x02,  -0x06, 0x0e,  -0x10, 0x06, -0x08, 0x04, 0x06,  -0x02, 0x00, 0x08,  0x08,
                -0x0e,
            });
            try testArgs(@Vector(63, i5), .{
                0x07,  0x05,  -0x03, -0x01, 0x03, 0x0b,  0x01,  -0x0d, 0x0b,  -0x09, -0x03, 0x01,  -0x01, -0x09, 0x05,  -0x0b,
                -0x0d, 0x0d,  0x0f,  -0x0b, 0x0b, -0x03, 0x05,  -0x03, -0x0d, -0x07, 0x0b,  0x0f,  0x0d,  -0x0b, -0x09, 0x03,
                0x05,  -0x0b, 0x0f,  0x07,  0x0d, -0x09, 0x0d,  -0x01, -0x09, 0x0f,  -0x03, -0x01, -0x0d, -0x07, -0x01, 0x09,
                0x0f,  -0x05, -0x03, -0x05, 0x0f, 0x01,  -0x0d, -0x05, -0x0d, -0x0b, -0x0f, 0x05,  0x09,  0x07,  -0x09,
            });
            try testArgs(@Vector(64, i5), .{
                -0x04, -0x03, 0x0f,  -0x0f, -0x04, -0x10, 0x0c,  -0x03, -0x0a, -0x06, 0x08,  -0x0a, -0x0b, 0x0f,  0x07,  0x02,
                -0x0b, 0x09,  -0x0b, 0x0b,  -0x0e, -0x04, -0x08, 0x00,  0x0d,  -0x0a, 0x01,  0x06,  0x0a,  0x05,  0x07,  -0x0a,
                0x05,  0x09,  -0x04, -0x08, -0x04, -0x02, -0x0e, 0x0d,  0x03,  -0x09, -0x0e, -0x01, 0x0f,  0x04,  0x0d,  -0x05,
                -0x04, 0x0d,  -0x0c, -0x0e, 0x0c,  0x0a,  -0x02, 0x0c,  0x00,  0x04,  0x06,  0x01,  0x0d,  -0x07, -0x04, 0x0a,
            });
            try testArgs(@Vector(65, i5), .{
                -0x02, 0x02, -0x04, -0x01, 0x07,  -0x02, -0x0c, 0x00,  -0x05, 0x0b,  0x0d,  -0x01, -0x09, 0x05,  -0x08, -0x04,
                0x00,  0x01, -0x04, -0x0e, -0x02, -0x04, -0x0d, 0x04,  -0x05, 0x01,  0x06,  0x07,  0x04,  -0x07, 0x02,  0x02,
                -0x0b, 0x0f, -0x02, -0x0e, 0x07,  -0x0c, 0x06,  -0x10, -0x0f, -0x03, -0x06, -0x0c, 0x0b,  -0x07, -0x06, 0x02,
                0x0a,  0x08, 0x01,  0x05,  0x03,  -0x0b, -0x0a, -0x0f, -0x10, -0x05, -0x0a, -0x0e, -0x0b, -0x06, 0x0c,  -0x08,
                0x04,
            });
            try testArgs(@Vector(127, i5), .{
                0x09,  0x0a,  -0x03, 0x08,  -0x04, -0x01, 0x0c,  0x0d,  0x0f,  -0x08, 0x09,  -0x05, -0x05, -0x01, -0x04, 0x0a,
                -0x02, 0x0c,  0x08,  0x0c,  -0x06, 0x0b,  0x0a,  0x09,  0x09,  0x0c,  -0x01, 0x09,  -0x01, -0x03, -0x04, 0x0c,
                0x0e,  0x0c,  0x0d,  -0x01, 0x0a,  0x0c,  -0x04, 0x09,  0x0f,  0x0e,  0x0f,  -0x08, -0x04, -0x04, 0x0f,  -0x02,
                0x0c,  -0x08, -0x06, -0x03, -0x07, 0x0d,  0x0d,  -0x01, 0x08,  -0x07, 0x08,  -0x01, -0x04, 0x0e,  -0x06, -0x03,
                -0x04, -0x05, 0x0e,  0x0c,  0x0a,  -0x04, 0x0e,  0x0e,  0x0a,  0x0c,  0x0d,  0x08,  0x0a,  -0x08, -0x06, 0x0a,
                0x0e,  -0x08, 0x09,  0x08,  -0x03, 0x0b,  -0x02, -0x06, 0x0f,  0x08,  -0x07, 0x0b,  0x0f,  -0x07, -0x06, -0x01,
                0x09,  0x09,  0x0d,  0x0e,  0x09,  0x0b,  -0x05, 0x0d,  0x08,  0x08,  -0x07, -0x07, 0x0e,  -0x07, -0x02, 0x0b,
                -0x05, 0x0d,  0x0e,  -0x04, -0x02, -0x07, -0x04, -0x06, -0x04, -0x07, 0x0e,  0x08,  -0x01, -0x03, 0x09,
            });
            try testArgs(@Vector(128, i5), .{
                -0x0c, -0x0d, -0x0b, -0x0c, -0x05, -0x09, 0x05,  0x02,  0x0a,  0x01,  -0x07, 0x01,  -0x09, -0x0c, -0x02, 0x03,
                -0x0f, 0x08,  0x03,  0x0b,  -0x03, 0x07,  -0x0b, 0x0a,  -0x04, 0x0f,  0x06,  -0x0a, -0x06, -0x0f, -0x0d, -0x0e,
                0x0a,  0x02,  -0x0f, 0x0c,  0x0d,  -0x03, 0x09,  -0x0a, 0x0d,  -0x10, -0x02, 0x06,  0x01,  -0x08, 0x0f,  -0x0b,
                -0x06, 0x01,  0x00,  -0x07, 0x08,  -0x03, -0x05, -0x03, -0x10, 0x00,  0x02,  0x09,  -0x05, 0x0e,  -0x04, 0x07,
                -0x09, -0x06, 0x0c,  0x00,  -0x09, 0x0d,  0x01,  -0x02, 0x07,  -0x0f, 0x09,  -0x0a, 0x04,  0x05,  -0x06, 0x03,
                0x0c,  0x02,  -0x05, -0x04, -0x06, -0x03, -0x0a, 0x01,  0x01,  -0x06, -0x06, -0x0e, 0x01,  0x0a,  0x03,  -0x0e,
                -0x10, 0x0a,  0x05,  0x04,  -0x01, -0x04, -0x09, -0x0a, 0x0e,  -0x0f, 0x0c,  -0x06, 0x0e,  0x09,  0x00,  0x06,
                0x0e,  -0x0a, -0x07, 0x04,  0x0b,  0x0f,  0x09,  -0x0b, 0x03,  0x0b,  0x06,  -0x0f, -0x04, -0x10, 0x03,  -0x01,
            });
            try testArgs(@Vector(129, i5), .{
                -0x02, 0x09,  0x08,  -0x06, 0x02,  -0x0e, -0x01, -0x05, -0x0c, -0x0a, -0x03, 0x06,  -0x02, -0x02, 0x09,  0x06,
                -0x02, 0x06,  -0x09, -0x0c, 0x05,  0x07,  -0x02, 0x0c,  0x09,  -0x01, -0x02, 0x04,  0x04,  0x05,  0x05,  0x02,
                0x0d,  -0x0f, 0x0c,  -0x08, -0x0a, 0x07,  0x09,  -0x04, -0x0c, 0x00,  0x01,  -0x01, -0x09, -0x0c, 0x0e,  0x0d,
                0x0e,  0x0e,  -0x0c, 0x0c,  -0x05, 0x0e,  0x05,  -0x0b, 0x0b,  0x01,  0x04,  0x0b,  -0x10, -0x03, -0x05, 0x0b,
                0x05,  -0x0f, -0x10, 0x08,  -0x01, 0x0f,  -0x0e, -0x10, 0x0d,  0x09,  0x00,  -0x01, -0x0f, 0x01,  0x0f,  -0x02,
                0x0d,  -0x01, 0x0a,  -0x0a, -0x0a, 0x0c,  -0x01, 0x00,  0x09,  0x01,  -0x08, -0x0e, 0x0d,  0x00,  0x02,  -0x01,
                0x04,  -0x0d, 0x00,  0x03,  0x08,  0x0d,  0x05,  0x03,  0x08,  -0x09, -0x01, -0x0c, -0x0f, 0x0b,  0x0d,  -0x08,
                0x0e,  0x0d,  0x0d,  0x05,  0x03,  0x01,  -0x0b, 0x0f,  0x07,  -0x08, -0x0d, -0x0b, 0x0f,  -0x0c, -0x05, -0x04,
                0x00,
            });

            try testArgs(@Vector(1, u5), .{
                0x1a,
            });
            try testArgs(@Vector(2, u5), .{
                0x0c, 0x0c,
            });
            try testArgs(@Vector(3, u5), .{
                0x07, 0x19, 0x07,
            });
            try testArgs(@Vector(4, u5), .{
                0x17, 0x16, 0x1f, 0x13,
            });
            try testArgs(@Vector(5, u5), .{
                0x03, 0x1a, 0x07, 0x04, 0x0a,
            });
            try testArgs(@Vector(7, u5), .{
                0x00, 0x1c, 0x1d, 0x1a, 0x13, 0x15, 0x00,
            });
            try testArgs(@Vector(8, u5), .{
                0x14, 0x13, 0x11, 0x16, 0x1c, 0x1a, 0x18, 0x1e,
            });
            try testArgs(@Vector(9, u5), .{
                0x09, 0x1a, 0x1a, 0x14, 0x04, 0x09, 0x17, 0x0d, 0x0b,
            });
            try testArgs(@Vector(15, u5), .{
                0x03, 0x01, 0x0c, 0x05, 0x11, 0x06, 0x09, 0x01, 0x15, 0x09, 0x1c, 0x13, 0x16, 0x03, 0x06,
            });
            try testArgs(@Vector(16, u5), .{
                0x13, 0x07, 0x02, 0x10, 0x15, 0x03, 0x00, 0x01, 0x10, 0x13, 0x17, 0x11, 0x16, 0x00, 0x07, 0x10,
            });
            try testArgs(@Vector(17, u5), .{
                0x1b, 0x1b, 0x1b, 0x02, 0x00, 0x02, 0x03, 0x09, 0x08, 0x00, 0x19, 0x01, 0x18, 0x10, 0x13, 0x03,
                0x18,
            });
            try testArgs(@Vector(31, u5), .{
                0x1d, 0x1d, 0x1b, 0x12, 0x18, 0x12, 0x1c, 0x14, 0x12, 0x15, 0x19, 0x13, 0x13, 0x15, 0x1c, 0x1f,
                0x1c, 0x10, 0x1b, 0x11, 0x17, 0x14, 0x18, 0x1e, 0x17, 0x14, 0x1d, 0x11, 0x14, 0x15, 0x19,
            });
            try testArgs(@Vector(32, u5), .{
                0x00, 0x00, 0x11, 0x19, 0x0d, 0x10, 0x01, 0x10, 0x08, 0x11, 0x00, 0x15, 0x08, 0x05, 0x14, 0x1c,
                0x18, 0x01, 0x10, 0x1d, 0x01, 0x18, 0x14, 0x1d, 0x18, 0x08, 0x1d, 0x1d, 0x18, 0x11, 0x1c, 0x1c,
            });
            try testArgs(@Vector(33, u5), .{
                0x0b, 0x18, 0x0f, 0x0c, 0x1f, 0x1f, 0x0f, 0x1a, 0x1b, 0x1e, 0x18, 0x08, 0x0f, 0x0c, 0x0b, 0x1d,
                0x1a, 0x0a, 0x0b, 0x0a, 0x1b, 0x19, 0x1c, 0x0a, 0x0b, 0x0e, 0x1b, 0x0a, 0x0b, 0x0b, 0x08, 0x1d,
                0x09,
            });
            try testArgs(@Vector(63, u5), .{
                0x14, 0x1b, 0x00, 0x0a, 0x0b, 0x00, 0x05, 0x17, 0x06, 0x1f, 0x1e, 0x0a, 0x03, 0x17, 0x0a, 0x1a,
                0x19, 0x01, 0x0d, 0x14, 0x19, 0x0c, 0x09, 0x0e, 0x0a, 0x1c, 0x05, 0x15, 0x0e, 0x17, 0x07, 0x09,
                0x0a, 0x1f, 0x17, 0x19, 0x17, 0x13, 0x16, 0x16, 0x0a, 0x02, 0x10, 0x19, 0x10, 0x10, 0x1b, 0x1d,
                0x08, 0x08, 0x1b, 0x09, 0x0a, 0x10, 0x1e, 0x1f, 0x18, 0x10, 0x09, 0x07, 0x05, 0x09, 0x1b,
            });
            try testArgs(@Vector(64, u5), .{
                0x09, 0x0d, 0x1c, 0x11, 0x15, 0x0d, 0x09, 0x10, 0x0c, 0x01, 0x05, 0x14, 0x14, 0x18, 0x1d, 0x14,
                0x01, 0x15, 0x08, 0x15, 0x0c, 0x10, 0x18, 0x10, 0x11, 0x15, 0x00, 0x1d, 0x08, 0x1d, 0x10, 0x04,
                0x1d, 0x05, 0x05, 0x08, 0x00, 0x0c, 0x05, 0x08, 0x09, 0x0d, 0x0c, 0x1d, 0x14, 0x18, 0x01, 0x0d,
                0x18, 0x1c, 0x15, 0x19, 0x18, 0x19, 0x09, 0x08, 0x10, 0x0c, 0x1c, 0x1d, 0x0c, 0x04, 0x10, 0x19,
            });
            try testArgs(@Vector(65, u5), .{
                0x15, 0x00, 0x15, 0x13, 0x06, 0x01, 0x10, 0x16, 0x15, 0x01, 0x16, 0x01, 0x00, 0x07, 0x15, 0x00,
                0x13, 0x02, 0x13, 0x06, 0x13, 0x14, 0x10, 0x11, 0x00, 0x05, 0x13, 0x04, 0x00, 0x11, 0x15, 0x15,
                0x05, 0x11, 0x13, 0x01, 0x07, 0x14, 0x05, 0x13, 0x03, 0x05, 0x07, 0x04, 0x17, 0x14, 0x00, 0x01,
                0x13, 0x17, 0x03, 0x15, 0x04, 0x12, 0x13, 0x06, 0x17, 0x00, 0x07, 0x02, 0x16, 0x14, 0x07, 0x10,
                0x13,
            });
            try testArgs(@Vector(127, u5), .{
                0x09, 0x04, 0x19, 0x07, 0x1c, 0x0b, 0x1b, 0x1b, 0x1a, 0x11, 0x1f, 0x15, 0x05, 0x08, 0x08, 0x11,
                0x08, 0x05, 0x08, 0x0f, 0x00, 0x13, 0x05, 0x0c, 0x15, 0x10, 0x00, 0x0d, 0x13, 0x1d, 0x19, 0x1b,
                0x0c, 0x0a, 0x18, 0x09, 0x1c, 0x15, 0x04, 0x17, 0x19, 0x12, 0x05, 0x16, 0x09, 0x19, 0x0c, 0x12,
                0x14, 0x12, 0x1a, 0x15, 0x0d, 0x02, 0x1b, 0x05, 0x0d, 0x1e, 0x05, 0x1a, 0x01, 0x1b, 0x06, 0x0b,
                0x1c, 0x07, 0x00, 0x06, 0x09, 0x19, 0x13, 0x0a, 0x08, 0x04, 0x1d, 0x15, 0x0f, 0x1f, 0x0b, 0x1c,
                0x14, 0x15, 0x1e, 0x15, 0x15, 0x19, 0x0c, 0x0e, 0x07, 0x1f, 0x09, 0x1e, 0x18, 0x0f, 0x1d, 0x15,
                0x01, 0x19, 0x0d, 0x15, 0x10, 0x02, 0x15, 0x1f, 0x1e, 0x1d, 0x17, 0x17, 0x05, 0x1d, 0x10, 0x0c,
                0x17, 0x00, 0x10, 0x00, 0x0b, 0x12, 0x13, 0x0b, 0x09, 0x08, 0x1c, 0x0d, 0x1d, 0x11, 0x16,
            });
            try testArgs(@Vector(128, u5), .{
                0x14, 0x0f, 0x12, 0x10, 0x04, 0x0b, 0x11, 0x12, 0x18, 0x00, 0x1c, 0x0a, 0x11, 0x0a, 0x0f, 0x1d,
                0x09, 0x19, 0x06, 0x11, 0x03, 0x1a, 0x08, 0x0d, 0x03, 0x0e, 0x0e, 0x1a, 0x09, 0x00, 0x1c, 0x05,
                0x1c, 0x17, 0x19, 0x0a, 0x0a, 0x08, 0x1b, 0x0f, 0x0a, 0x15, 0x1e, 0x17, 0x1f, 0x1b, 0x10, 0x01,
                0x02, 0x1d, 0x11, 0x19, 0x0a, 0x15, 0x0d, 0x09, 0x03, 0x02, 0x00, 0x1d, 0x19, 0x03, 0x0d, 0x10,
                0x1b, 0x15, 0x1b, 0x13, 0x03, 0x08, 0x0c, 0x00, 0x16, 0x19, 0x05, 0x17, 0x1d, 0x07, 0x05, 0x15,
                0x00, 0x07, 0x01, 0x17, 0x0a, 0x00, 0x0c, 0x08, 0x19, 0x00, 0x0c, 0x06, 0x0b, 0x13, 0x01, 0x0b,
                0x0c, 0x03, 0x1c, 0x03, 0x08, 0x07, 0x14, 0x00, 0x02, 0x09, 0x08, 0x05, 0x18, 0x0d, 0x10, 0x1c,
                0x0d, 0x11, 0x12, 0x07, 0x01, 0x1d, 0x1e, 0x13, 0x08, 0x09, 0x08, 0x05, 0x16, 0x0c, 0x08, 0x1c,
            });
            try testArgs(@Vector(129, u5), .{
                0x1d, 0x12, 0x0a, 0x02, 0x03, 0x14, 0x1b, 0x00, 0x16, 0x0d, 0x1d, 0x1e, 0x0c, 0x17, 0x0f, 0x07,
                0x04, 0x1d, 0x03, 0x0b, 0x0a, 0x10, 0x04, 0x12, 0x00, 0x11, 0x00, 0x11, 0x03, 0x16, 0x0b, 0x08,
                0x17, 0x1e, 0x19, 0x10, 0x0f, 0x1d, 0x0a, 0x04, 0x11, 0x0a, 0x1c, 0x16, 0x02, 0x14, 0x13, 0x0f,
                0x0d, 0x04, 0x0a, 0x03, 0x1a, 0x0c, 0x18, 0x10, 0x00, 0x0d, 0x03, 0x06, 0x10, 0x03, 0x0e, 0x08,
                0x14, 0x10, 0x0b, 0x0d, 0x00, 0x0c, 0x0a, 0x07, 0x06, 0x10, 0x11, 0x1d, 0x06, 0x12, 0x0c, 0x12,
                0x00, 0x1d, 0x0f, 0x09, 0x02, 0x1d, 0x17, 0x13, 0x02, 0x09, 0x11, 0x0c, 0x1d, 0x14, 0x01, 0x11,
                0x03, 0x1f, 0x16, 0x0c, 0x16, 0x09, 0x11, 0x17, 0x01, 0x12, 0x13, 0x00, 0x1c, 0x0b, 0x03, 0x04,
                0x18, 0x0d, 0x06, 0x04, 0x10, 0x1e, 0x09, 0x1c, 0x04, 0x0a, 0x01, 0x0d, 0x1f, 0x1c, 0x1f, 0x1e,
                0x00,
            });

            try testArgs(@Vector(1, i7), .{
                0x1e,
            });
            try testArgs(@Vector(2, i7), .{
                -0x2b, 0x17,
            });
            try testArgs(@Vector(3, i7), .{
                0x15, 0x36, 0x3a,
            });
            try testArgs(@Vector(4, i7), .{
                0x10, 0x17, -0x19, 0x1b,
            });
            try testArgs(@Vector(5, i7), .{
                -0x18, 0x0a, 0x2a, -0x3c, -0x2c,
            });
            try testArgs(@Vector(7, i7), .{
                -0x37, 0x1d, 0x2a, -0x3d, 0x07, 0x22, 0x38,
            });
            try testArgs(@Vector(8, i7), .{
                0x2a, -0x06, 0x03, -0x26, 0x18, -0x11, 0x12, 0x3f,
            });
            try testArgs(@Vector(9, i7), .{
                0x39, 0x0b, -0x1d, 0x10, -0x18, -0x2a, -0x2b, 0x16, 0x15,
            });
            try testArgs(@Vector(15, i7), .{
                -0x27, 0x3c, 0x39, -0x27, 0x1f, -0x2b, 0x39, 0x3b, -0x06, 0x38, -0x26, 0x11, -0x23, -0x01, 0x13,
            });
            try testArgs(@Vector(16, i7), .{
                0x31, -0x35, -0x21, 0x27, 0x13, 0x05, 0x07, 0x0d, -0x27, 0x3d, -0x0b, 0x0d, -0x1f, -0x13, -0x09, 0x1b,
            });
            try testArgs(@Vector(17, i7), .{
                0x2d, 0x2d, -0x05, -0x0a, 0x38, -0x3a, -0x36, 0x09, -0x34, -0x15, 0x34, 0x3d, 0x07, -0x16, -0x23, 0x10,
                0x35,
            });
            try testArgs(@Vector(31, i7), .{
                -0x32, -0x39, 0x37,  0x2d, -0x2a, 0x17,  -0x3a, 0x17, 0x0e,  -0x39, -0x11, 0x07,  0x0c,  0x2c, -0x19, -0x12,
                0x1e,  0x1f,  -0x3c, 0x0d, 0x25,  -0x0a, -0x13, 0x15, -0x33, 0x3f,  0x3c,  -0x3b, -0x0b, 0x06, -0x23,
            });
            try testArgs(@Vector(32, i7), .{
                0x1d, 0x2e, 0x1e, 0x00, 0x10, 0x09, 0x07, 0x20, 0x26, 0x2b, 0x0a, 0x02, 0x0c, 0x3d, 0x3f, 0x06,
                0x34, 0x13, 0x17, 0x1d, 0x1d, 0x0f, 0x1b, 0x05, 0x36, 0x0a, 0x1f, 0x14, 0x13, 0x3f, 0x1a, 0x3a,
            });
            try testArgs(@Vector(33, i7), .{
                0x19, 0x31, 0x3d, -0x38, -0x3b, 0x2b, -0x11, -0x1c, 0x2c, 0x25,  0x37, 0x3d, 0x34, -0x38, -0x0d, 0x01,
                0x37, 0x3c, 0x3f, 0x02,  0x00,  0x0e, 0x22,  -0x03, 0x26, -0x1f, 0x0b, 0x0f, 0x0f, -0x39, 0x10,  0x27,
                0x28,
            });
            try testArgs(@Vector(63, i7), .{
                0x13,  0x2c,  -0x08, 0x2f,  0x2c,  -0x3a, 0x3e,  -0x01, 0x0a,  0x12,  -0x1f, 0x34, 0x21,  -0x3f, -0x0f, -0x3d,
                0x38,  0x1e,  0x11,  0x3a,  -0x36, 0x2f,  -0x03, -0x39, 0x3b,  -0x3f, -0x29, 0x33, 0x25,  0x18,  0x0c,  -0x3e,
                -0x0f, 0x0d,  -0x01, -0x08, -0x2a, 0x33,  0x2b,  0x35,  0x18,  -0x29, -0x05, 0x20, 0x02,  0x39,  -0x24, 0x2f,
                0x36,  -0x04, -0x40, 0x2e,  0x07,  0x04,  -0x39, -0x3c, -0x24, 0x13,  -0x10, 0x30, -0x2f, -0x39, -0x01,
            });
            try testArgs(@Vector(64, i7), .{
                0x20,  -0x18, -0x15, -0x3a, 0x11,  0x39,  -0x23, 0x19,  -0x0a, -0x02, -0x1b, -0x28, -0x1f, -0x12, -0x33, -0x0f,
                -0x37, 0x2a,  0x35,  -0x08, 0x19,  0x2c,  0x11,  -0x13, -0x16, 0x00,  -0x40, -0x3c, -0x16, 0x39,  0x01,  0x3c,
                0x01,  -0x3e, -0x27, -0x17, -0x08, -0x3b, 0x13,  0x2f,  0x38,  -0x37, 0x0b,  0x03,  -0x21, -0x10, -0x40, 0x0a,
                -0x3c, 0x2f,  -0x0b, 0x12,  -0x2e, -0x32, 0x1b,  -0x35, -0x20, -0x1d, -0x10, 0x2f,  -0x40, 0x09,  0x13,  0x13,
            });
            try testArgs(@Vector(65, i7), .{
                0x0a,  0x16,  -0x31, -0x06, -0x26, -0x14, -0x38, -0x32, -0x2e, -0x07, 0x03,  0x3c,  0x34,  -0x14, -0x3b, 0x03,
                -0x11, -0x18, -0x12, -0x2f, -0x1c, 0x17,  0x0f,  0x0f,  0x2d,  -0x15, 0x33,  -0x2c, -0x2a, 0x2e,  0x26,  -0x3f,
                -0x07, -0x3f, -0x23, -0x31, -0x05, -0x32, -0x0e, 0x15,  -0x33, -0x03, -0x28, -0x1e, 0x15,  -0x3e, 0x37,  0x30,
                -0x35, 0x31,  -0x3e, 0x03,  0x17,  -0x0e, 0x2d,  -0x19, -0x2b, -0x3b, -0x16, 0x3f,  0x3c,  0x1b,  -0x12, -0x30,
                -0x08,
            });
            try testArgs(@Vector(127, i7), .{
                -0x2c, -0x13, -0x40, 0x12,  0x16,  -0x15, -0x29, 0x3c,  -0x2f, 0x24,  0x24,  0x27,  0x11,  -0x0b, 0x24,  -0x11,
                0x0a,  0x2a,  0x23,  -0x0f, 0x0f,  0x01,  -0x2b, -0x06, 0x02,  -0x1d, -0x09, -0x09, 0x2f,  0x09,  0x1c,  -0x0e,
                -0x3a, -0x18, -0x1e, -0x34, -0x20, 0x27,  -0x26, 0x26,  0x1f,  0x3c,  -0x35, -0x33, 0x15,  0x32,  -0x3e, -0x27,
                -0x3b, 0x0f,  -0x1c, -0x33, -0x28, 0x0b,  -0x1d, -0x21, -0x2b, 0x1d,  0x2a,  0x37,  -0x26, 0x0c,  -0x3e, -0x19,
                0x0a,  -0x34, 0x03,  0x02,  -0x2a, 0x36,  -0x06, 0x15,  0x09,  -0x0a, 0x0f,  0x07,  -0x09, 0x07,  -0x14, 0x24,
                -0x2f, 0x29,  -0x29, -0x0f, -0x3b, 0x08,  -0x0d, 0x11,  0x09,  -0x0f, 0x0c,  -0x27, -0x16, -0x2c, -0x14, 0x2e,
                -0x0c, -0x01, 0x19,  0x15,  0x21,  0x3f,  -0x03, 0x28,  -0x3d, -0x04, -0x0a, -0x2a, 0x2c,  -0x25, 0x1b,  0x2e,
                0x23,  -0x31, 0x03,  -0x06, 0x2b,  -0x04, 0x2e,  -0x07, -0x10, -0x10, -0x35, 0x24,  -0x3b, -0x36, 0x21,
            });
            try testArgs(@Vector(128, i7), .{
                0x28,  0x0a,  -0x3c, -0x31, 0x35,  -0x19, 0x3b,  0x3e,  -0x17, 0x0e,  0x3e,  -0x34, 0x23,  0x2d,  -0x27, -0x1a,
                0x38,  -0x1d, 0x10,  0x0c,  -0x20, -0x0e, 0x33,  -0x01, 0x0e,  -0x14, -0x14, 0x0f,  -0x39, 0x3d,  0x03,  -0x1b,
                0x0c,  0x04,  -0x0c, -0x2b, -0x25, 0x02,  0x20,  -0x1b, -0x04, 0x37,  -0x30, -0x10, -0x05, 0x0c,  -0x0d, -0x40,
                0x20,  0x29,  -0x3b, -0x24, -0x3e, 0x29,  -0x3c, 0x1a,  0x34,  0x2f,  -0x05, -0x11, 0x27,  0x25,  -0x25, 0x19,
                -0x2d, -0x14, 0x0c,  0x3b,  -0x22, -0x04, -0x19, 0x12,  -0x15, -0x0c, 0x29,  0x0a,  -0x18, -0x22, 0x27,  0x17,
                -0x2e, -0x01, -0x24, -0x10, 0x18,  -0x0b, -0x1f, 0x1f,  0x30,  -0x1e, -0x32, 0x17,  -0x34, -0x11, 0x29,  0x0f,
                0x37,  -0x01, 0x06,  -0x32, 0x1d,  -0x2a, 0x23,  -0x1c, 0x36,  0x33,  0x0b,  -0x19, 0x02,  0x15,  0x1b,  -0x1a,
                -0x30, 0x34,  -0x1f, 0x1e,  0x13,  -0x20, -0x31, -0x03, 0x1a,  -0x01, 0x36,  0x10,  0x2b,  0x17,  0x1f,  0x0e,
            });
            try testArgs(@Vector(129, i7), .{
                0x13, 0x20, 0x21, 0x11, 0x2c, 0x12, 0x23, 0x38, 0x00, 0x02, 0x2b, 0x30, 0x03, 0x21, 0x31, 0x3b,
                0x2c, 0x33, 0x1b, 0x3d, 0x1d, 0x2d, 0x22, 0x0a, 0x16, 0x3b, 0x04, 0x39, 0x24, 0x1e, 0x25, 0x2f,
                0x1e, 0x3d, 0x0a, 0x2f, 0x14, 0x18, 0x31, 0x2f, 0x07, 0x1d, 0x20, 0x25, 0x29, 0x36, 0x06, 0x2e,
                0x29, 0x1f, 0x3f, 0x26, 0x3d, 0x0b, 0x1b, 0x1d, 0x2f, 0x00, 0x14, 0x2b, 0x02, 0x13, 0x3c, 0x32,
                0x37, 0x0c, 0x00, 0x03, 0x28, 0x05, 0x39, 0x18, 0x38, 0x3c, 0x19, 0x1e, 0x35, 0x27, 0x0d, 0x08,
                0x0a, 0x28, 0x2a, 0x26, 0x0d, 0x10, 0x1b, 0x37, 0x2d, 0x11, 0x3b, 0x35, 0x1b, 0x31, 0x01, 0x0c,
                0x0d, 0x31, 0x32, 0x2c, 0x22, 0x2a, 0x0b, 0x05, 0x26, 0x3f, 0x13, 0x2c, 0x1a, 0x21, 0x1f, 0x14,
                0x16, 0x0d, 0x39, 0x20, 0x00, 0x23, 0x03, 0x34, 0x0a, 0x06, 0x17, 0x1b, 0x22, 0x11, 0x0e, 0x2e,
                0x0f,
            });

            try testArgs(@Vector(1, u7), .{
                0x52,
            });
            try testArgs(@Vector(2, u7), .{
                0x06, 0x14,
            });
            try testArgs(@Vector(3, u7), .{
                0x03, 0x0d, 0x6b,
            });
            try testArgs(@Vector(4, u7), .{
                0x05, 0x26, 0x0c, 0x0b,
            });
            try testArgs(@Vector(5, u7), .{
                0x12, 0x43, 0x4b, 0x5d, 0x76,
            });
            try testArgs(@Vector(7, u7), .{
                0x51, 0x04, 0x52, 0x71, 0x05, 0x33, 0x53,
            });
            try testArgs(@Vector(8, u7), .{
                0x06, 0x65, 0x03, 0x61, 0x2a, 0x21, 0x01, 0x63,
            });
            try testArgs(@Vector(9, u7), .{
                0x38, 0x42, 0x79, 0x30, 0x20, 0x00, 0x00, 0x28, 0x22,
            });
            try testArgs(@Vector(15, u7), .{
                0x1e, 0x3f, 0x32, 0x2c, 0x01, 0x3f, 0x0a, 0x32, 0x39, 0x09, 0x24, 0x2b, 0x0f, 0x03, 0x3e,
            });
            try testArgs(@Vector(16, u7), .{
                0x74, 0x34, 0x11, 0x67, 0x52, 0x6d, 0x5e, 0x77, 0x00, 0x75, 0x4f, 0x54, 0x79, 0x21, 0x6d, 0x66,
            });
            try testArgs(@Vector(17, u7), .{
                0x71, 0x6c, 0x68, 0x5f, 0x42, 0x47, 0x7e, 0x42, 0x50, 0x50, 0x78, 0x57, 0x7b, 0x72, 0x57, 0x79,
                0x44,
            });
            try testArgs(@Vector(31, u7), .{
                0x3f, 0x64, 0x09, 0x5d, 0x61, 0x72, 0x50, 0x52, 0x5f, 0x2d, 0x54, 0x0b, 0x38, 0x08, 0x2a, 0x01,
                0x43, 0x1b, 0x21, 0x23, 0x26, 0x02, 0x0c, 0x32, 0x34, 0x4a, 0x77, 0x71, 0x68, 0x14, 0x2f,
            });
            try testArgs(@Vector(32, u7), .{
                0x03, 0x32, 0x20, 0x55, 0x77, 0x66, 0x71, 0x13, 0x55, 0x23, 0x34, 0x34, 0x40, 0x40, 0x45, 0x44,
                0x13, 0x00, 0x74, 0x21, 0x61, 0x12, 0x52, 0x32, 0x50, 0x05, 0x45, 0x22, 0x51, 0x07, 0x74, 0x03,
            });
            try testArgs(@Vector(33, u7), .{
                0x42, 0x42, 0x4c, 0x03, 0x53, 0x4a, 0x4c, 0x06, 0x44, 0x09, 0x01, 0x12, 0x4d, 0x01, 0x47, 0x1c,
                0x4c, 0x0b, 0x5a, 0x10, 0x42, 0x5a, 0x49, 0x0b, 0x19, 0x4f, 0x5b, 0x4b, 0x4e, 0x58, 0x4b, 0x1f,
                0x56,
            });
            try testArgs(@Vector(63, u7), .{
                0x51, 0x65, 0x25, 0x1b, 0x0f, 0x2f, 0x7a, 0x5e, 0x0f, 0x07, 0x40, 0x24, 0x5b, 0x29, 0x32, 0x14,
                0x43, 0x0b, 0x3e, 0x7a, 0x33, 0x08, 0x4a, 0x2d, 0x47, 0x5b, 0x17, 0x21, 0x25, 0x33, 0x14, 0x28,
                0x58, 0x60, 0x52, 0x67, 0x3c, 0x31, 0x0e, 0x09, 0x36, 0x15, 0x06, 0x13, 0x64, 0x46, 0x3a, 0x58,
                0x75, 0x68, 0x58, 0x56, 0x45, 0x44, 0x7c, 0x74, 0x51, 0x13, 0x49, 0x41, 0x0d, 0x5f, 0x64,
            });
            try testArgs(@Vector(64, u7), .{
                0x3b, 0x10, 0x70, 0x63, 0x0e, 0x36, 0x15, 0x00, 0x1d, 0x39, 0x4b, 0x0b, 0x03, 0x20, 0x27, 0x18,
                0x34, 0x48, 0x70, 0x37, 0x67, 0x21, 0x24, 0x09, 0x74, 0x62, 0x49, 0x34, 0x50, 0x05, 0x17, 0x47,
                0x13, 0x16, 0x34, 0x00, 0x00, 0x0d, 0x57, 0x1f, 0x4b, 0x53, 0x50, 0x00, 0x32, 0x02, 0x11, 0x16,
                0x39, 0x0d, 0x12, 0x3a, 0x5e, 0x51, 0x32, 0x48, 0x3a, 0x5e, 0x61, 0x64, 0x0b, 0x50, 0x56, 0x2e,
            });
            try testArgs(@Vector(65, u7), .{
                0x6e, 0x03, 0x6e, 0x39, 0x79, 0x49, 0x76, 0x12, 0x58, 0x52, 0x61, 0x58, 0x6f, 0x1a, 0x52, 0x1b,
                0x55, 0x77, 0x2a, 0x61, 0x1c, 0x4d, 0x0c, 0x71, 0x7c, 0x6b, 0x5f, 0x18, 0x63, 0x52, 0x5d, 0x6a,
                0x0f, 0x41, 0x4d, 0x0a, 0x7f, 0x78, 0x34, 0x0a, 0x37, 0x38, 0x31, 0x11, 0x45, 0x7e, 0x32, 0x2f,
                0x16, 0x0d, 0x45, 0x43, 0x67, 0x6d, 0x76, 0x54, 0x28, 0x5d, 0x09, 0x0b, 0x52, 0x20, 0x68, 0x65,
                0x7d,
            });
            try testArgs(@Vector(127, u7), .{
                0x02, 0x34, 0x23, 0x24, 0x28, 0x3c, 0x0e, 0x20, 0x03, 0x27, 0x13, 0x23, 0x1d, 0x32, 0x3f, 0x3f,
                0x1b, 0x37, 0x28, 0x2b, 0x38, 0x38, 0x2f, 0x0f, 0x07, 0x0c, 0x3d, 0x35, 0x2d, 0x0f, 0x1b, 0x32,
                0x3d, 0x30, 0x1c, 0x1a, 0x34, 0x21, 0x3d, 0x0f, 0x1e, 0x02, 0x0a, 0x2c, 0x16, 0x0c, 0x30, 0x37,
                0x16, 0x2a, 0x1f, 0x2d, 0x1f, 0x3d, 0x0c, 0x2e, 0x15, 0x1f, 0x2a, 0x10, 0x37, 0x3d, 0x2a, 0x3c,
                0x22, 0x17, 0x23, 0x0f, 0x3b, 0x21, 0x31, 0x02, 0x36, 0x31, 0x03, 0x14, 0x1b, 0x39, 0x29, 0x25,
                0x37, 0x37, 0x09, 0x33, 0x0a, 0x10, 0x10, 0x20, 0x07, 0x1e, 0x1c, 0x36, 0x05, 0x2f, 0x1a, 0x1a,
                0x21, 0x0b, 0x20, 0x30, 0x2c, 0x1e, 0x03, 0x2e, 0x09, 0x26, 0x3f, 0x30, 0x06, 0x37, 0x1c, 0x34,
                0x31, 0x0d, 0x2e, 0x3d, 0x24, 0x26, 0x10, 0x08, 0x14, 0x0f, 0x1c, 0x27, 0x37, 0x04, 0x02,
            });
            try testArgs(@Vector(128, u7), .{
                0x7b, 0x60, 0x69, 0x7b, 0x74, 0x5f, 0x51, 0x43, 0x69, 0x4b, 0x6f, 0x7f, 0x79, 0x5b, 0x56, 0x56,
                0x67, 0x70, 0x72, 0x73, 0x51, 0x60, 0x47, 0x5b, 0x79, 0x56, 0x62, 0x4f, 0x6f, 0x69, 0x6e, 0x68,
                0x4a, 0x47, 0x5e, 0x5b, 0x67, 0x6d, 0x64, 0x4a, 0x4e, 0x72, 0x50, 0x6b, 0x51, 0x43, 0x4b, 0x74,
                0x63, 0x6a, 0x75, 0x6f, 0x66, 0x74, 0x44, 0x51, 0x79, 0x46, 0x6d, 0x49, 0x49, 0x54, 0x62, 0x7d,
                0x40, 0x55, 0x70, 0x40, 0x6a, 0x5a, 0x65, 0x7d, 0x58, 0x4b, 0x49, 0x59, 0x5d, 0x5a, 0x61, 0x6a,
                0x4d, 0x5f, 0x5a, 0x62, 0x7f, 0x66, 0x7d, 0x53, 0x6b, 0x4f, 0x7e, 0x7b, 0x75, 0x73, 0x67, 0x6f,
                0x64, 0x6b, 0x75, 0x5a, 0x76, 0x53, 0x7b, 0x7a, 0x5d, 0x40, 0x6b, 0x5b, 0x6c, 0x65, 0x7a, 0x6a,
                0x5b, 0x43, 0x54, 0x74, 0x43, 0x7a, 0x57, 0x44, 0x44, 0x60, 0x4b, 0x47, 0x46, 0x7c, 0x63, 0x6b,
            });
            try testArgs(@Vector(129, u7), .{
                0x0f, 0x3b, 0x4f, 0x51, 0x55, 0x67, 0x07, 0x17, 0x53, 0x73, 0x25, 0x7b, 0x33, 0x6b, 0x0d, 0x29,
                0x51, 0x0b, 0x1d, 0x39, 0x1b, 0x2b, 0x33, 0x47, 0x73, 0x17, 0x59, 0x0d, 0x4b, 0x67, 0x5f, 0x1b,
                0x49, 0x3d, 0x7f, 0x3b, 0x49, 0x7f, 0x2d, 0x4b, 0x49, 0x55, 0x7d, 0x37, 0x29, 0x5d, 0x5f, 0x5d,
                0x4f, 0x39, 0x13, 0x39, 0x75, 0x6b, 0x2f, 0x33, 0x6f, 0x05, 0x45, 0x37, 0x0f, 0x7b, 0x25, 0x35,
                0x77, 0x09, 0x1d, 0x3d, 0x19, 0x11, 0x65, 0x6d, 0x01, 0x59, 0x6d, 0x2f, 0x5d, 0x01, 0x43, 0x0b,
                0x7f, 0x43, 0x13, 0x5d, 0x2b, 0x0d, 0x09, 0x69, 0x0d, 0x41, 0x37, 0x43, 0x5b, 0x07, 0x3d, 0x49,
                0x53, 0x0f, 0x15, 0x75, 0x01, 0x43, 0x3b, 0x45, 0x63, 0x15, 0x25, 0x15, 0x27, 0x5b, 0x33, 0x17,
                0x5d, 0x2b, 0x25, 0x73, 0x23, 0x2d, 0x49, 0x67, 0x51, 0x75, 0x31, 0x63, 0x39, 0x61, 0x1d, 0x1d,
                0x0d,
            });

            try testArgs(@Vector(1, i8), .{
                -0x16,
            });
            try testArgs(@Vector(2, i8), .{
                0x18, 0x1b,
            });
            try testArgs(@Vector(3, i8), .{
                0x7a, 0x6f, 0x40,
            });
            try testArgs(@Vector(4, i8), .{
                0x14, -0x12, -0x53, 0x34,
            });
            try testArgs(@Vector(5, i8), .{
                -0x39, 0x63, 0x1a, 0x03, -0x48,
            });
            try testArgs(@Vector(7, i8), .{
                -0x56, -0x40, -0x1f, 0x7b, -0x7a, 0x39, -0x7b,
            });
            try testArgs(@Vector(8, i8), .{
                0x75, -0x64, -0x12, -0x0c, -0x47, 0x6f, 0x53, 0x1b,
            });
            try testArgs(@Vector(9, i8), .{
                0x29, 0x55, 0x4c, -0x4f, 0x54, 0x34, -0x21, -0x42, 0x36,
            });
            try testArgs(@Vector(15, i8), .{
                0x5f, -0x41, 0x76, 0x7c, 0x26, -0x5b, -0x4a, -0x7c, 0x26, 0x45, -0x69, 0x05, 0x67, 0x0f, -0x64,
            });
            try testArgs(@Vector(16, i8), .{
                -0x05, 0x77, 0x6f, -0x07, -0x7a, 0x56, -0x4d, -0x75, 0x02, -0x01, -0x4d, -0x7e, -0x24, 0x3a, -0x0b, 0x0a,
            });
            try testArgs(@Vector(17, i8), .{
                0x68,  0x06, -0x31, 0x7e, 0x07, 0x1d, 0x63, -0x01, -0x66, -0x75, 0x15, 0x00, 0x17, 0x00, -0x74, 0x03,
                -0x6b,
            });
            try testArgs(@Vector(31, i8), .{
                0x49, -0x72, 0x72, 0x15, 0x63,  -0x4c, 0x04,  0x62, 0x21, -0x30, 0x57,  0x53,  -0x33, 0x1b, -0x3b, -0x03,
                0x7d, -0x2c, 0x4a, 0x7b, -0x63, 0x36,  -0x0b, 0x26, 0x4d, -0x60, -0x14, -0x6e, 0x6f,  0x7c, 0x3e,
            });
            try testArgs(@Vector(32, i8), .{
                -0x1a, -0x5f, -0x79, -0x10, -0x5e, 0x62, -0x0c, -0x3a, 0x37,  0x60, -0x1b, 0x72, 0x74, -0x1d, 0x32,  -0x7c,
                0x31,  -0x7b, 0x70,  -0x4e, -0x7f, 0x53, 0x32,  -0x3d, -0x49, 0x42, -0x4b, 0x74, 0x13, 0x70,  -0x79, 0x64,
            });
            try testArgs(@Vector(33, i8), .{
                0x60,  -0x0e, 0x06, -0x2a, -0x4a, -0x1a, 0x13,  0x20, 0x21, 0x60, 0x63, -0x6a, -0x1e, -0x10, 0x24,  0x76,
                0x22,  -0x5c, 0x03, 0x03,  0x46,  -0x30, -0x0e, 0x24, 0x73, 0x30, 0x24, -0x5d, -0x5d, 0x24,  -0x1b, 0x31,
                -0x79,
            });
            try testArgs(@Vector(63, i8), .{
                -0x6b, 0x17,  -0x12, -0x5b, 0x29,  -0x03, -0x57, -0x1e, -0x70, 0x69,  -0x1e, 0x40,  0x18,  0x32,  0x5e, 0x3b,
                0x39,  0x2b,  -0x04, 0x54,  0x6a,  0x15,  -0x04, 0x74,  0x12,  -0x6f, 0x36,  -0x1b, -0x7a, 0x3a,  0x63, -0x4d,
                -0x6e, -0x5e, 0x34,  0x39,  -0x79, -0x1b, -0x6e, -0x3d, -0x5f, -0x1e, 0x70,  -0x6c, -0x46, 0x45,  0x6f, 0x6e,
                0x38,  -0x2d, -0x1e, -0x2c, -0x7a, 0x1c,  0x33,  0x26,  -0x37, 0x06,  -0x68, -0x7b, -0x2e, -0x48, 0x72,
            });
            try testArgs(@Vector(64, i8), .{
                0x23,  0x3b,  0x67,  -0x61, 0x11,  -0x45, -0x39, 0x43,  0x23,  0x37,  0x57, 0x6b,  -0x4f, 0x05,  -0x23, 0x1b,
                -0x3d, -0x73, 0x31,  0x6d,  -0x2f, -0x7b, 0x49,  -0x4d, -0x03, -0x5f, 0x13, 0x17,  -0x79, -0x03, 0x47,  -0x1f,
                0x51,  0x2d,  -0x55, -0x4d, -0x5f, 0x2b,  0x53,  -0x2f, -0x39, 0x23,  0x01, 0x29,  -0x65, -0x61, 0x57,  0x21,
                -0x6d, 0x71,  0x59,  -0x2d, -0x6d, 0x59,  -0x39, 0x55,  0x27,  0x67,  0x73, -0x4d, 0x1f,  0x75,  -0x05, 0x15,
            });
            try testArgs(@Vector(65, i8), .{
                -0x59, -0x45, -0x4a, -0x55, -0x0a, -0x11, 0x70,  0x20,  -0x1f, -0x56, 0x28,  0x2d,  0x7e,  0x2f,  -0x0e, -0x5d,
                0x2e,  0x7f,  -0x04, -0x48, -0x51, 0x27,  0x72,  0x24,  0x39,  -0x05, -0x4a, -0x60, 0x21,  0x7c,  -0x51, 0x6d,
                -0x55, -0x42, 0x71,  -0x08, -0x1f, 0x2a,  0x60,  -0x07, -0x10, -0x0a, 0x68,  0x39,  -0x4f, -0x44, 0x2b,  -0x15,
                0x7f,  0x71,  -0x51, -0x03, 0x3c,  0x3d,  -0x46, 0x70,  0x20,  -0x4b, 0x37,  0x72,  -0x50, -0x0a, 0x27,  -0x5b,
                -0x0d,
            });
            try testArgs(@Vector(127, i8), .{
                -0x13, -0x04, -0x6e, 0x5c,  0x20,  -0x51, 0x21,  0x7b,  -0x5d, 0x14,  0x72,  -0x32, 0x50,  0x3f,  0x0e,  -0x5d,
                0x3e,  0x77,  -0x4e, -0x4d, 0x71,  0x71,  0x49,  0x11,  0x27,  -0x0f, 0x08,  0x37,  0x08,  0x01,  -0x77, 0x2e,
                0x45,  0x20,  0x1c,  -0x17, 0x03,  -0x22, 0x01,  -0x1f, 0x71,  -0x05, -0x1e, -0x3d, 0x02,  -0x30, -0x5f, 0x17,
                -0x4a, -0x50, 0x16,  0x6f,  0x0c,  0x77,  -0x44, -0x6c, -0x79, -0x75, 0x05,  -0x3a, 0x11,  0x45,  0x57,  -0x0f,
                0x57,  0x44,  0x4c,  -0x63, 0x4b,  0x35,  0x16,  -0x3e, 0x5d,  -0x02, 0x22,  -0x0c, 0x6f,  0x37,  0x49,  0x0b,
                0x2a,  0x27,  0x3c,  0x21,  -0x7f, 0x7e,  -0x29, -0x04, -0x72, -0x1a, -0x35, 0x69,  0x20,  0x68,  -0x72, -0x58,
                -0x32, 0x0f,  0x4a,  -0x2a, 0x1b,  0x07,  0x74,  -0x44, -0x3e, -0x45, 0x54,  -0x4e, 0x27,  -0x4a, -0x0d, 0x55,
                -0x55, -0x67, 0x48,  -0x0d, -0x6c, 0x6a,  0x2c,  0x18,  -0x6d, -0x50, -0x2d, -0x2f, -0x01, -0x6b, 0x61,
            });
            try testArgs(@Vector(128, i8), .{
                0x55,  0x0f,  -0x65, 0x0c,  0x0f,  -0x22, -0x7a, 0x53,  -0x3c, -0x35, 0x50,  0x5c,  0x53,  -0x3d, -0x38, 0x18,
                0x5c,  -0x66, 0x0c,  -0x30, -0x77, -0x2d, -0x37, 0x5d,  -0x30, -0x7b, -0x68, 0x1f,  -0x2f, 0x56,  0x44,  -0x7c,
                0x02,  -0x2d, 0x15,  -0x22, -0x6b, 0x07,  -0x77, 0x1e,  -0x3a, 0x0e,  0x0e,  -0x69, 0x54,  -0x65, 0x54,  0x02,
                -0x2b, 0x56,  0x49,  -0x23, -0x40, 0x53,  0x0c,  -0x66, -0x21, -0x67, -0x26, -0x65, -0x6c, -0x22, -0x3a, -0x79,
                0x45,  0x50,  0x0e,  -0x34, -0x80, 0x13,  -0x2c, -0x22, -0x7e, -0x24, 0x46,  -0x21, 0x04,  0x41,  -0x37, 0x10,
                -0x7c, 0x4e,  -0x3a, 0x01,  0x12,  -0x6c, -0x2e, -0x21, -0x6a, -0x22, 0x04,  -0x6d, -0x7e, 0x02,  -0x27, -0x6e,
                -0x64, -0x70, 0x50,  0x48,  -0x24, 0x5a,  0x41,  -0x68, -0x3b, 0x47,  0x0d,  -0x70, -0x3a, 0x0f,  -0x28, -0x40,
                0x1a,  -0x6c, 0x11,  0x05,  0x5d,  0x5f,  0x5a,  0x0f,  0x56,  -0x37, -0x29, 0x5e,  0x56,  0x4b,  -0x22, 0x19,
            });
            try testArgs(@Vector(129, i8), .{
                0x0a,  -0x15, -0x4a, -0x03, -0x0b, -0x5f, 0x7a,  -0x52, 0x44,  -0x40, 0x4d,  0x22,  0x51,  -0x5c, 0x59,  0x1e,
                0x1c,  0x45,  -0x31, -0x6f, 0x39,  0x6a,  -0x1a, -0x36, 0x70,  -0x6e, -0x29, 0x49,  0x4d,  0x29,  -0x2f, 0x36,
                -0x08, -0x20, 0x18,  -0x68, -0x3e, 0x13,  -0x69, -0x6d, -0x31, 0x50,  0x16,  -0x73, 0x67,  0x05,  -0x24, 0x47,
                0x1e,  0x06,  -0x13, -0x4b, -0x5d, -0x02, -0x4e, 0x01,  -0x2a, 0x7b,  0x09,  -0x25, 0x48,  -0x65, 0x1c,  -0x25,
                -0x58, 0x35,  0x63,  0x06,  0x30,  -0x1d, -0x33, 0x2f,  0x7c,  -0x6e, -0x69, -0x57, -0x2d, 0x72,  -0x7c, 0x2c,
                -0x15, 0x0c,  0x0f,  -0x60, -0x01, -0x10, 0x4f,  0x6a,  0x3b,  0x34,  -0x18, 0x79,  0x1b,  -0x5b, 0x61,  0x17,
                -0x24, -0x20, -0x07, -0x16, -0x38, 0x13,  0x44,  -0x68, -0x32, -0x12, -0x51, 0x78,  -0x6d, -0x24, -0x37, 0x52,
                0x27,  -0x08, -0x48, -0x57, -0x2c, -0x66, -0x4c, 0x15,  0x67,  0x1f,  0x4e,  -0x4b, -0x09, -0x6d, -0x06, 0x53,
                -0x74,
            });

            try testArgs(@Vector(1, u8), .{
                0x24,
            });
            try testArgs(@Vector(2, u8), .{
                0xe0, 0xf6,
            });
            try testArgs(@Vector(3, u8), .{
                0xa4, 0xc5, 0xfa,
            });
            try testArgs(@Vector(4, u8), .{
                0x40, 0x1e, 0x54, 0x19,
            });
            try testArgs(@Vector(5, u8), .{
                0xe1, 0xe4, 0x6d, 0xec, 0x24,
            });
            try testArgs(@Vector(7, u8), .{
                0xa1, 0x99, 0x91, 0x20, 0xe3, 0x2a, 0xca,
            });
            try testArgs(@Vector(8, u8), .{
                0x62, 0x03, 0x04, 0xa1, 0x19, 0xa4, 0xbc, 0xec,
            });
            try testArgs(@Vector(9, u8), .{
                0x5a, 0x3e, 0x4c, 0x7a, 0x79, 0xde, 0xff, 0x6b, 0xcd,
            });
            try testArgs(@Vector(15, u8), .{
                0x73, 0xdd, 0x7d, 0x97, 0x0b, 0x27, 0xa9, 0x55, 0x0f, 0x35, 0x07, 0x1f, 0x81, 0xbf, 0x83,
            });
            try testArgs(@Vector(16, u8), .{
                0xef, 0x69, 0x8f, 0xd9, 0x3d, 0xef, 0x2f, 0x43, 0x27, 0x3d, 0x49, 0xcf, 0xed, 0x3d, 0xfb, 0x97,
            });
            try testArgs(@Vector(17, u8), .{
                0x0e, 0xd4, 0x7d, 0x16, 0xe7, 0xf5, 0xf4, 0x54, 0xb6, 0x55, 0x06, 0x17, 0xbe, 0xfd, 0xae, 0x4f,
                0x6e,
            });
            try testArgs(@Vector(31, u8), .{
                0x97, 0x3d, 0xed, 0xdf, 0xd9, 0xe9, 0xbd, 0x4b, 0xfb, 0x4f, 0x6b, 0x51, 0xa1, 0xa1, 0xa5, 0x9f,
                0x8d, 0xad, 0xdb, 0x27, 0xc7, 0x9f, 0x8f, 0x23, 0x07, 0x15, 0x7b, 0xad, 0x73, 0xc5, 0x9d,
            });
            try testArgs(@Vector(32, u8), .{
                0xed, 0xbc, 0xf3, 0x76, 0xb4, 0xb5, 0xb7, 0xa4, 0x79, 0x73, 0xb7, 0x20, 0xe1, 0xf5, 0x76, 0xef,
                0x63, 0xbc, 0x34, 0x20, 0x3e, 0x3e, 0xa4, 0x3a, 0x61, 0xbe, 0xfb, 0xa2, 0xe9, 0x69, 0x6e, 0x7e,
            });
            try testArgs(@Vector(33, u8), .{
                0x65, 0xac, 0x6f, 0x6d, 0x3d, 0x0d, 0x5f, 0x66, 0xba, 0x74, 0x78, 0x6b, 0xf2, 0x7f, 0x41, 0xa9,
                0x20, 0x09, 0xbc, 0xd3, 0x97, 0x74, 0x05, 0x09, 0xfa, 0x69, 0x8c, 0x5e, 0xfa, 0xe2, 0x82, 0x10,
                0x8d,
            });
            try testArgs(@Vector(63, u8), .{
                0x80, 0x65, 0xd4, 0xed, 0xa5, 0xf1, 0x8d, 0x9d, 0x99, 0x25, 0x6d, 0x28, 0xf9, 0x35, 0xe9, 0x9d,
                0x74, 0x7d, 0x00, 0xc5, 0xed, 0x75, 0xb5, 0xec, 0x5c, 0x01, 0xb4, 0x39, 0xb9, 0xc4, 0x34, 0xb0,
                0xd1, 0x1c, 0xfd, 0xd9, 0xc5, 0xe1, 0xe1, 0x58, 0x69, 0x40, 0x7d, 0xdc, 0xc0, 0x20, 0x95, 0xb4,
                0x15, 0x31, 0x7d, 0x75, 0x49, 0x2c, 0x60, 0x2d, 0x28, 0x61, 0xe4, 0xb8, 0x09, 0x6d, 0xa0,
            });
            try testArgs(@Vector(64, u8), .{
                0x3a, 0x1e, 0x95, 0x0b, 0x8e, 0x91, 0xaf, 0x25, 0x4a, 0x7b, 0xc4, 0xce, 0x72, 0xec, 0x80, 0xc2,
                0xae, 0xeb, 0xa3, 0x6a, 0x32, 0xc9, 0x6b, 0x2a, 0xd6, 0x7b, 0x9b, 0x8d, 0xb8, 0xe3, 0x28, 0x07,
                0xe1, 0xd0, 0x3d, 0xca, 0xb6, 0x33, 0x18, 0x0a, 0x37, 0xc2, 0x5c, 0x10, 0x1e, 0x93, 0xdf, 0xf9,
                0xb5, 0x8c, 0x09, 0x26, 0x91, 0x3b, 0x05, 0x38, 0xd8, 0x4f, 0x24, 0xa3, 0x16, 0x6f, 0x1a, 0x21,
            });
            try testArgs(@Vector(65, u8), .{
                0xc2, 0x3a, 0xa7, 0x9e, 0xd5, 0x94, 0x9a, 0x92, 0xdd, 0x16, 0xf4, 0x07, 0xc1, 0x95, 0xe2, 0xf1,
                0xaa, 0x53, 0x45, 0xda, 0xb5, 0x2c, 0x98, 0xda, 0x83, 0xc0, 0x0f, 0x3a, 0x56, 0x58, 0x28, 0xb1,
                0xaf, 0x85, 0x3d, 0xbf, 0x3a, 0x4c, 0x39, 0x9b, 0xb8, 0x2d, 0x2e, 0x75, 0x37, 0x50, 0x16, 0xb9,
                0xb5, 0xc4, 0x08, 0x99, 0x0d, 0x82, 0x3e, 0x05, 0xe7, 0xdf, 0x48, 0x01, 0x73, 0x85, 0x5d, 0x4d,
                0xf5,
            });
            try testArgs(@Vector(127, u8), .{
                0x1e, 0xdb, 0x7a, 0xf1, 0xeb, 0xe7, 0x8e, 0xe1, 0xd2, 0x19, 0x00, 0xc3, 0x8c, 0x64, 0x2c, 0xd0,
                0x7e, 0x47, 0x3b, 0x35, 0x6d, 0xdf, 0xfa, 0x2d, 0x42, 0x67, 0xc6, 0x88, 0xf1, 0xd5, 0xca, 0x69,
                0xa4, 0xf7, 0xe4, 0xc8, 0xdd, 0x93, 0x6b, 0xd3, 0x11, 0xff, 0xc2, 0xf3, 0xbf, 0xa2, 0x4c, 0xec,
                0xce, 0xdc, 0xad, 0xb0, 0xf6, 0x56, 0xcc, 0xe4, 0x3b, 0xeb, 0x10, 0x93, 0xce, 0x86, 0xb1, 0xb8,
                0xed, 0x34, 0xad, 0xe2, 0x60, 0x03, 0xff, 0x5c, 0x6d, 0x63, 0xd0, 0xc9, 0x4a, 0x66, 0x83, 0x53,
                0x15, 0x0e, 0xd4, 0xc2, 0xa2, 0x7c, 0x21, 0x7b, 0xfc, 0x95, 0xb9, 0x61, 0x92, 0x7c, 0x32, 0xe6,
                0x5a, 0x29, 0x90, 0x40, 0x05, 0x86, 0x9a, 0xae, 0x5b, 0x20, 0x3d, 0xd0, 0x03, 0x52, 0x72, 0x5a,
                0x21, 0xe1, 0x96, 0xf4, 0xc4, 0x80, 0x9e, 0x9e, 0xe8, 0xe6, 0x4c, 0x78, 0x63, 0x91, 0xd4,
            });
            try testArgs(@Vector(128, u8), .{
                0x72, 0x66, 0xed, 0xd6, 0xfe, 0x4a, 0xed, 0xeb, 0xd9, 0x6e, 0x5c, 0x64, 0xf1, 0xd2, 0xf1, 0x66,
                0xe4, 0x77, 0x65, 0x75, 0xe7, 0xd7, 0x78, 0x64, 0xc7, 0x6f, 0xf2, 0x61, 0xf7, 0x63, 0x45, 0xd7,
                0x6f, 0x6f, 0x57, 0x5d, 0x44, 0xd5, 0x7b, 0x55, 0x51, 0xdb, 0x4a, 0x55, 0xea, 0xca, 0x75, 0xc5,
                0x48, 0x76, 0xc6, 0xfd, 0xd6, 0xde, 0xd7, 0x61, 0x53, 0xc7, 0xcd, 0xce, 0x61, 0xe3, 0x53, 0x6b,
                0xf0, 0xe7, 0x65, 0xf4, 0xc8, 0x6b, 0xc4, 0xf6, 0xdc, 0x6d, 0x63, 0xd8, 0x48, 0x4e, 0x60, 0xff,
                0x4a, 0xd4, 0xe0, 0x7e, 0x5c, 0x5c, 0xd9, 0x76, 0x4c, 0x69, 0xe4, 0xfc, 0x7e, 0x73, 0x79, 0x54,
                0xc6, 0xf4, 0x55, 0x60, 0x65, 0x59, 0x4d, 0xee, 0xda, 0x74, 0xc7, 0x62, 0x7d, 0xf9, 0x75, 0x67,
                0x4b, 0xc6, 0x78, 0xf5, 0x5b, 0xca, 0xc5, 0xdd, 0x62, 0x53, 0xd8, 0x46, 0xd6, 0x68, 0xd6, 0x6f,
            });
            try testArgs(@Vector(129, u8), .{
                0x67, 0x97, 0xcc, 0x16, 0x15, 0x7f, 0x6d, 0xf8, 0x3b, 0x96, 0xd0, 0x94, 0x47, 0x7a, 0x71, 0x15,
                0x67, 0x08, 0x61, 0xf0, 0xf8, 0x94, 0x34, 0xff, 0x49, 0xb0, 0xf8, 0x07, 0xd3, 0x64, 0xa4, 0xc5,
                0x43, 0x67, 0x02, 0xc2, 0xc8, 0x05, 0xf0, 0x47, 0x1f, 0xbf, 0x78, 0x5a, 0x19, 0xf8, 0x75, 0xb7,
                0xf7, 0x9e, 0x57, 0x81, 0xa0, 0x59, 0x0c, 0x72, 0x82, 0x3f, 0x6a, 0xd8, 0x6d, 0xef, 0x70, 0x6b,
                0x2a, 0xc7, 0x02, 0x16, 0x59, 0xa2, 0xef, 0x0f, 0x4e, 0x5f, 0xdb, 0x43, 0x70, 0x15, 0x51, 0xd1,
                0xeb, 0xab, 0x14, 0x07, 0x8d, 0x94, 0x55, 0xfe, 0xd4, 0x56, 0xbc, 0x82, 0xa7, 0xec, 0xe7, 0x69,
                0xaa, 0xaa, 0x7d, 0xd4, 0x28, 0x07, 0x60, 0x6e, 0x66, 0x0c, 0xd3, 0xcf, 0x30, 0xee, 0xf0, 0x86,
                0x4d, 0xaa, 0xc3, 0x96, 0x8c, 0xe8, 0xb5, 0xfc, 0x23, 0xa4, 0x78, 0x5c, 0x4d, 0xdd, 0x2b, 0x3f,
                0xbc,
            });

            try testArgs(@Vector(1, i9), .{
                -0x061,
            });
            try testArgs(@Vector(2, i9), .{
                -0x0bc, -0x0e1,
            });
            try testArgs(@Vector(3, i9), .{
                -0x0e6, -0x024, -0x049,
            });
            try testArgs(@Vector(4, i9), .{
                0x001, 0x059, 0x0e9, -0x031,
            });
            try testArgs(@Vector(5, i9), .{
                0x0e2, 0x052, -0x0d8, 0x05d, -0x0d0,
            });
            try testArgs(@Vector(7, i9), .{
                -0x025, 0x0d5, -0x00d, 0x0d2, 0x0c1, -0x03f, -0x0e8,
            });
            try testArgs(@Vector(8, i9), .{
                -0x031, -0x0bf, -0x0ed, 0x070, 0x055, -0x08e, 0x094, 0x0a2,
            });
            try testArgs(@Vector(9, i9), .{
                -0x003, 0x0fb, 0x0f7, -0x04d, -0x0bd, 0x019, 0x06d, -0x001,
                0x06f,
            });
            try testArgs(@Vector(15, i9), .{
                0x06d, -0x0ac, -0x060, -0x0ab, 0x005, -0x0b5, 0x0c4, 0x00d,
                0x075, 0x0d1,  0x025,  -0x076, 0x01c, 0x01b,  0x0d2,
            });
            try testArgs(@Vector(16, i9), .{
                -0x04a, 0x01f, 0x077, 0x067,  -0x0cb, -0x0b9, 0x0af,  -0x0b2,
                0x045,  0x0dd, 0x0ff, -0x031, -0x0e1, 0x004,  -0x02b, -0x0fc,
            });
            try testArgs(@Vector(17, i9), .{
                -0x0c9, -0x0a2, -0x094, -0x0d9, -0x063, -0x07f, -0x019, -0x064,
                -0x0c4, -0x060, -0x0b4, -0x0df, -0x08a, -0x0fe, -0x0fa, -0x097,
                -0x031,
            });
            try testArgs(@Vector(31, i9), .{
                0x00d,  0x05b,  0x07a,  0x074,  -0x069, -0x024, -0x0f5, -0x065,
                -0x0b6, -0x08e, 0x0d3,  0x0f6,  -0x026, -0x087, 0x0e3,  -0x0a0,
                0x07c,  0x047,  -0x046, -0x0e8, 0x079,  0x018,  0x080,  0x032,
                -0x09b, 0x053,  0x095,  0x0d7,  0x02f,  -0x0ed, 0x0cf,
            });
            try testArgs(@Vector(32, i9), .{
                -0x0a9, 0x0b8,  -0x0e4, 0x0c4,  0x0df,  0x0c2, -0x0d6, 0x04d,
                0x0f2,  -0x0e7, 0x05b,  0x016,  -0x066, 0x0c1, 0x0a4,  0x0c6,
                0x0ff,  0x01b,  -0x021, 0x005,  -0x03d, 0x074, -0x0c1, 0x09a,
                0x0b7,  -0x0ed, -0x086, -0x003, -0x098, 0x005, 0x05e,  0x0ea,
            });
            try testArgs(@Vector(33, i9), .{
                0x00d,  0x03e,  0x084,  0x092,  0x055,  -0x0ed, 0x006,  0x0ca,
                0x020,  0x01b,  0x060,  0x058,  -0x044, -0x04b, -0x03d, 0x029,
                0x04a,  0x090,  -0x036, 0x009,  0x02d,  0x098,  -0x0fc, -0x029,
                -0x05d, -0x0d9, 0x0df,  -0x0bf, -0x0ab, 0x010,  0x0aa,  -0x0a4,
                -0x0d5,
            });
            try testArgs(@Vector(63, i9), .{
                0x028,  0x04e,  0x016,  0x02c,  -0x043, -0x0c0, -0x075, -0x078,
                0x006,  -0x0c9, -0x09d, 0x02e,  -0x041, -0x0cb, -0x0b1, -0x052,
                -0x01c, -0x059, -0x086, -0x073, 0x042,  -0x087, -0x034, 0x0be,
                0x0df,  -0x07f, -0x031, 0x0d9,  0x0d2,  -0x082, 0x080,  -0x043,
                0x0cb,  -0x0b5, 0x049,  0x028,  -0x08a, -0x0bf, -0x034, 0x053,
                0x02f,  -0x007, -0x085, 0x058,  -0x0c4, -0x0c3, 0x07c,  -0x064,
                -0x0d2, 0x027,  0x0fd,  0x0cd,  0x0e5,  0x0cc,  -0x055, 0x08b,
                0x07e,  -0x0e8, -0x052, 0x02a,  0x0b7,  0x0ea,  -0x0b0,
            });
            try testArgs(@Vector(64, i9), .{
                -0x088, 0x036,  0x06a,  -0x05c, -0x08d, -0x090, 0x0e3,  0x03b,
                -0x017, -0x0c7, 0x0a0,  0x0b4,  -0x09f, -0x013, -0x0c9, -0x0de,
                -0x09d, 0x027,  0x06f,  0x0a2,  0x0a5,  -0x099, -0x020, 0x071,
                0x0af,  0x0b4,  -0x0d1, 0x02f,  0x031,  0x0a4,  -0x048, -0x041,
                -0x0cf, -0x0c5, -0x020, 0x027,  -0x050, 0x075,  -0x0c4, 0x07a,
                -0x01f, -0x01d, 0x074,  0x03a,  0x038,  -0x044, 0x030,  -0x0c1,
                -0x002, 0x0e5,  -0x008, 0x0a4,  0x0be,  0x066,  -0x098, 0x021,
                -0x0cd, -0x00f, -0x04c, 0x0ab,  0x0f4,  -0x0c2, 0x0e3,  -0x014,
            });
            try testArgs(@Vector(65, i9), .{
                -0x048, -0x040, -0x0e5, 0x001,  0x056,  0x08a,  0x0ef,  -0x01b,
                -0x002, -0x03a, 0x04f,  -0x091, 0x0c6,  0x0b2,  0x038,  0x02e,
                -0x0a5, -0x020, -0x015, -0x068, -0x0d3, 0x081,  0x068,  0x0a3,
                0x097,  -0x0d0, 0x0af,  -0x0ab, -0x0ad, 0x0fa,  0x068,  -0x05d,
                -0x073, 0x0ad,  -0x091, -0x0ff, -0x0f4, -0x0b3, 0x009,  -0x0aa,
                0x046,  0x0a0,  -0x008, 0x018,  -0x017, -0x0be, 0x0cb,  0x087,
                -0x0e5, 0x0a3,  -0x05f, 0x0b5,  0x011,  0x0d1,  -0x02e, -0x0a9,
                -0x0e1, -0x0be, 0x026,  -0x0b2, -0x076, -0x0ec, 0x0bf,  0x0a0,
                0x063,
            });

            try testArgs(@Vector(1, u9), .{
                0x180,
            });
            try testArgs(@Vector(2, u9), .{
                0x1d9, 0x15c,
            });
            try testArgs(@Vector(3, u9), .{
                0x112, 0x150, 0x0b7,
            });
            try testArgs(@Vector(4, u9), .{
                0x0b7, 0x1aa, 0x043, 0x033,
            });
            try testArgs(@Vector(5, u9), .{
                0x1e8, 0x012, 0x087, 0x039, 0x01f,
            });
            try testArgs(@Vector(7, u9), .{
                0x100, 0x0e9, 0x026, 0x08b, 0x071, 0x1e2, 0x15e,
            });
            try testArgs(@Vector(8, u9), .{
                0x007, 0x1c3, 0x113, 0x01d, 0x0be, 0x181, 0x110, 0x1d0,
            });
            try testArgs(@Vector(9, u9), .{
                0x073, 0x033, 0x1bd, 0x1ee, 0x1ab, 0x17c, 0x0bf, 0x1ba,
                0x1aa,
            });
            try testArgs(@Vector(15, u9), .{
                0x1bd, 0x039, 0x1ae, 0x1de, 0x12c, 0x05d, 0x09d, 0x118,
                0x068, 0x1b8, 0x1ed, 0x17d, 0x13a, 0x1ca, 0x01a,
            });
            try testArgs(@Vector(16, u9), .{
                0x186, 0x1ce, 0x134, 0x197, 0x144, 0x043, 0x051, 0x01d,
                0x158, 0x025, 0x13d, 0x0d0, 0x1d6, 0x0c2, 0x13f, 0x02f,
            });
            try testArgs(@Vector(17, u9), .{
                0x13b, 0x161, 0x0c7, 0x1ba, 0x0db, 0x1d3, 0x117, 0x091,
                0x17f, 0x1a4, 0x187, 0x0f2, 0x081, 0x02b, 0x02a, 0x1c4,
                0x0e8,
            });
            try testArgs(@Vector(31, u9), .{
                0x1f2, 0x1ba, 0x18a, 0x1d4, 0x072, 0x0c8, 0x05e, 0x0f8,
                0x0c0, 0x1c2, 0x002, 0x078, 0x002, 0x054, 0x188, 0x132,
                0x15e, 0x1ee, 0x16a, 0x0bc, 0x1a4, 0x1e6, 0x05c, 0x034,
                0x126, 0x020, 0x1b6, 0x07e, 0x02e, 0x12e, 0x004,
            });
            try testArgs(@Vector(32, u9), .{
                0x0e4, 0x0af, 0x1ab, 0x1e2, 0x096, 0x1c0, 0x117, 0x1c9,
                0x189, 0x0a0, 0x1e9, 0x060, 0x094, 0x11a, 0x0ff, 0x0ce,
                0x047, 0x083, 0x107, 0x0d4, 0x068, 0x13d, 0x06a, 0x164,
                0x0f1, 0x180, 0x059, 0x042, 0x0bd, 0x189, 0x157, 0x021,
            });
            try testArgs(@Vector(33, u9), .{
                0x048, 0x059, 0x170, 0x12f, 0x042, 0x11c, 0x059, 0x07c,
                0x13a, 0x13c, 0x07a, 0x047, 0x03e, 0x03e, 0x05d, 0x02d,
                0x17b, 0x056, 0x174, 0x077, 0x03b, 0x146, 0x15c, 0x031,
                0x057, 0x066, 0x04d, 0x058, 0x04a, 0x065, 0x044, 0x037,
                0x07d,
            });
            try testArgs(@Vector(63, u9), .{
                0x175, 0x0ca, 0x0df, 0x1c8, 0x0c0, 0x0cd, 0x16b, 0x042,
                0x1c9, 0x16d, 0x174, 0x14c, 0x064, 0x0d4, 0x153, 0x06f,
                0x1d5, 0x1d3, 0x050, 0x170, 0x0e8, 0x1db, 0x16e, 0x176,
                0x14d, 0x160, 0x0d7, 0x1cc, 0x1fd, 0x0de, 0x168, 0x0fd,
                0x175, 0x04a, 0x0cd, 0x0f7, 0x164, 0x1c1, 0x05f, 0x14a,
                0x1f6, 0x145, 0x0c2, 0x07e, 0x145, 0x0ea, 0x176, 0x154,
                0x0c9, 0x1f5, 0x1c4, 0x1f6, 0x15e, 0x1e0, 0x043, 0x1cb,
                0x0c9, 0x041, 0x1e2, 0x1e7, 0x14a, 0x074, 0x0f3,
            });
            try testArgs(@Vector(64, u9), .{
                0x169, 0x193, 0x044, 0x083, 0x13a, 0x06b, 0x1cc, 0x02a,
                0x04d, 0x078, 0x04d, 0x1bb, 0x14a, 0x1b4, 0x09a, 0x0eb,
                0x191, 0x044, 0x16c, 0x1f3, 0x04d, 0x19d, 0x0b7, 0x0de,
                0x15e, 0x04a, 0x184, 0x187, 0x1e0, 0x114, 0x0da, 0x055,
                0x1b1, 0x09d, 0x0aa, 0x183, 0x148, 0x103, 0x045, 0x0c4,
                0x117, 0x121, 0x1c5, 0x133, 0x1c1, 0x039, 0x023, 0x038,
                0x102, 0x01c, 0x1e0, 0x188, 0x149, 0x048, 0x075, 0x0b9,
                0x0c0, 0x1ee, 0x0ed, 0x171, 0x087, 0x177, 0x05f, 0x0f2,
            });
            try testArgs(@Vector(65, u9), .{
                0x00d, 0x10e, 0x05f, 0x138, 0x0c8, 0x138, 0x07f, 0x1fc,
                0x04e, 0x16a, 0x15d, 0x0de, 0x07d, 0x05f, 0x17d, 0x0f9,
                0x1bf, 0x14c, 0x08e, 0x06a, 0x029, 0x158, 0x188, 0x1bf,
                0x159, 0x1dc, 0x12f, 0x16c, 0x1fb, 0x0bc, 0x07c, 0x109,
                0x149, 0x0ce, 0x0db, 0x169, 0x10e, 0x178, 0x179, 0x028,
                0x098, 0x099, 0x0ff, 0x1c9, 0x17e, 0x0fa, 0x158, 0x01b,
                0x1bf, 0x0f8, 0x01a, 0x13f, 0x0b8, 0x0dd, 0x138, 0x029,
                0x13d, 0x1bb, 0x0eb, 0x05a, 0x13f, 0x1bc, 0x10e, 0x0ac,
                0x139,
            });

            try testArgs(@Vector(1, i15), .{
                0x3e64,
            });
            try testArgs(@Vector(2, i15), .{
                0x1459, 0x24f0,
            });
            try testArgs(@Vector(3, i15), .{
                0x022d, 0x2f6e, 0x3993,
            });
            try testArgs(@Vector(4, i15), .{
                0x2a50, 0x1e30, -0x2e82, -0x0138,
            });
            try testArgs(@Vector(5, i15), .{
                0x1ea5, -0x175a, -0x38c9, -0x076d, -0x2dd6,
            });
            try testArgs(@Vector(7, i15), .{
                -0x1bea, 0x26d2, -0x34b4, 0x3192, 0x3f05, -0x1277, 0x35c0,
            });
            try testArgs(@Vector(8, i15), .{
                -0x00cc, 0x3ef1, 0x01af, -0x147a, -0x3b72, 0x04a2, 0x1dec, -0x0620,
            });
            try testArgs(@Vector(9, i15), .{
                -0x1d58, -0x28a6, 0x39cc, -0x219d, -0x1e51, 0x1f67, 0x2fef, 0x26e1,
                -0x3e39,
            });
            try testArgs(@Vector(15, i15), .{
                -0x2671, 0x00cb,  0x36c0, 0x2092, -0x3fb7, 0x2858, 0x00cd,  0x34a6,
                0x3f9c,  -0x13b2, 0x3ff9, 0x0c90, 0x0f2c,  0x02a9, -0x3174,
            });
            try testArgs(@Vector(16, i15), .{
                0x0255, 0x1966,  0x3135,  0x399a,  0x21b9,  0x3a16,  -0x1e8b, 0x1893,
                0x0d4d, -0x3b4d, -0x36e3, -0x1197, -0x2645, -0x3da3, -0x05d0, -0x1191,
            });
            try testArgs(@Vector(17, i15), .{
                -0x0805, -0x1a74, -0x22cd, -0x24d3, -0x0c9a, 0x158b, -0x1c5a, 0x318b,
                0x1b43,  -0x2ca2, -0x10ea, -0x366b, -0x3435, 0x3d02, 0x0d77,  -0x36d8,
                -0x3065,
            });
            try testArgs(@Vector(31, i15), .{
                -0x31db, -0x245a, 0x0894,  0x3405, -0x277c, -0x1680, 0x0a8c,  0x3425,
                -0x093b, -0x1df4, 0x1e07,  0x2dba, 0x2482,  -0x0ac3, 0x00f6,  -0x30b0,
                -0x19d2, -0x3c32, -0x3591, 0x1bfc, 0x1b37,  0x2d2a,  -0x2de3, 0x0c23,
                -0x2860, 0x03ea,  0x0253,  0x34b4, -0x100c, 0x1133,  -0x0950,
            });
            try testArgs(@Vector(32, i15), .{
                0x14a2,  0x0b4a,  -0x061e, 0x1cd0, 0x15a7,  0x263c,  0x31a2,  0x37e5,
                -0x04a3, -0x0ce2, -0x27dc, 0x1fc1, 0x118d,  0x2ca4,  0x00b8,  -0x388d,
                -0x3c35, 0x294c,  -0x0866, 0x22b0, -0x0088, -0x2609, 0x0e46,  0x38ba,
                -0x28fc, -0x011c, 0x0f58,  0x0552, -0x2108, -0x2dc9, -0x2a76, -0x1568,
            });
            try testArgs(@Vector(33, i15), .{
                0x3d65,  0x12d4,  -0x0ee6, 0x1df0,  -0x1701, -0x2fe6, -0x2113, -0x09cd,
                -0x01dc, -0x3b32, 0x0406,  -0x0db7, -0x3a96, -0x187c, -0x3eb5, -0x07a5,
                0x1390,  -0x256d, -0x16c8, -0x2d79, -0x091e, -0x1426, -0x2bc7, 0x395f,
                0x1f6e,  -0x3412, -0x22db, 0x3e3c,  0x01ed,  -0x3223, 0x0206,  0x252c,
                0x0149,
            });
            try testArgs(@Vector(63, i15), .{
                0x160d,  -0x0fc7, 0x0990,  -0x1180, 0x1131,  -0x1993, 0x1dd8,  -0x2c33,
                -0x3424, -0x1ee4, -0x1e07, 0x2a01,  0x1a01,  0x03ec,  -0x0fa8, 0x12b4,
                -0x1824, -0x2b8b, -0x0357, -0x2440, 0x0721,  0x303d,  0x092d,  -0x196c,
                -0x1070, 0x066c,  -0x1684, -0x1dd4, -0x2ba8, 0x11b9,  -0x1460, -0x0b7c,
                0x325c,  0x2f60,  0x25b1,  0x342c,  -0x051f, -0x25ac, 0x2d61,  -0x0a80,
                0x11f9,  -0x0e64, -0x2053, 0x24b1,  -0x2088, -0x358c, 0x24f5,  0x24b8,
                0x3581,  0x2fb0,  -0x0a6f, 0x18b5,  0x0041,  -0x2d93, 0x0901,  -0x18fb,
                0x37cc,  -0x3954, -0x3097, 0x38d5,  0x06d8,  -0x3fb0, -0x2e80,
            });
            try testArgs(@Vector(64, i15), .{
                -0x3948, -0x22d7, 0x0ad3, -0x304e, 0x0b52,  -0x1674, -0x0283, -0x11d9,
                -0x35ca, -0x15bd, 0x341d, 0x108e,  -0x0688, 0x2cb8,  -0x0dea, 0x35f9,
                -0x34e1, 0x39b1,  0x2bd2, -0x2515, 0x32ce,  0x33aa,  -0x3cda, 0x0be0,
                0x3596,  0x16de,  0x2df1, -0x3ef0, -0x3e7b, -0x1f4b, 0x18cb,  -0x1e56,
                0x237d,  -0x1cbb, 0x12c4, -0x2b65, 0x3967,  -0x0cc7, 0x2a17,  0x3a54,
                0x27b0,  0x0225,  0x33a3, -0x1a7e, 0x0756,  0x0d35,  -0x0ab8, 0x2b53,
                0x2751,  0x0784,  0x1ea0, -0x2a27, -0x02c6, 0x06da,  0x0e3c,  -0x1662,
                -0x291f, -0x324d, 0x32a8, -0x2326, 0x3b6e,  0x2519,  -0x15bb, 0x1ca3,
            });
            try testArgs(@Vector(65, i15), .{
                0x3e90,  -0x315b, -0x376e, -0x04ed, -0x308a, 0x2469,  0x0f32,  -0x2555,
                0x3b7a,  0x3830,  0x13f2,  0x0dc0,  0x06d7,  0x1953,  0x3945,  -0x18ee,
                -0x135e, -0x08da, 0x29e5,  -0x0fb4, -0x02a6, -0x3844, 0x2e42,  -0x24c6,
                -0x04b6, 0x0055,  0x22fc,  0x05a3,  -0x1e25, -0x12f9, 0x215d,  0x34b8,
                -0x28d8, 0x0f90,  0x307f,  -0x0849, -0x330a, 0x2ecf,  0x1243,  0x2bf6,
                0x070b,  0x2636,  -0x27a2, 0x2b60,  -0x03e8, -0x3492, 0x0d5d,  0x39e2,
                0x2b82,  0x0e2d,  -0x3d26, 0x3b02,  0x3302,  0x254a,  -0x0f5c, -0x25bf,
                -0x0979, -0x22d6, 0x098e,  -0x0be8, 0x3022,  -0x2918, -0x2327, -0x219e,
                0x3b74,
            });

            try testArgs(@Vector(1, u15), .{
                0x1107,
            });
            try testArgs(@Vector(2, u15), .{
                0x5408, 0x1b06,
            });
            try testArgs(@Vector(3, u15), .{
                0x5487, 0x6f41, 0x4f6f,
            });
            try testArgs(@Vector(4, u15), .{
                0x233c, 0x7b1b, 0x74d0, 0x11dc,
            });
            try testArgs(@Vector(5, u15), .{
                0x2fe4, 0x7db8, 0x470a, 0x69d8, 0x7f73,
            });
            try testArgs(@Vector(7, u15), .{
                0x7fb2, 0x0395, 0x0464, 0x05ab, 0x6470, 0x1ed6, 0x5301,
            });
            try testArgs(@Vector(8, u15), .{
                0x053d, 0x4d61, 0x4d29, 0x01a2, 0x6f27, 0x7b7e, 0x68f0, 0x7e35,
            });
            try testArgs(@Vector(9, u15), .{
                0x57c1, 0x0325, 0x519c, 0x5b51, 0x0119, 0x395a, 0x7f1f, 0x03c7,
                0x178e,
            });
            try testArgs(@Vector(15, u15), .{
                0x651c, 0x4234, 0x7ce4, 0x4e77, 0x5668, 0x1a1c, 0x6a80, 0x0823,
                0x7b0c, 0x12e2, 0x70de, 0x1952, 0x0bc9, 0x6bc1, 0x4c7f,
            });
            try testArgs(@Vector(16, u15), .{
                0x19fd, 0x0bf2, 0x0c0f, 0x1f92, 0x0ad3, 0x2e77, 0x2904, 0x2429,
                0x36a3, 0x1cf7, 0x3069, 0x04ec, 0x03ea, 0x1839, 0x0928, 0x2248,
            });
            try testArgs(@Vector(17, u15), .{
                0x219f, 0x2472, 0x28fa, 0x6733, 0x2c3c, 0x2a9b, 0x0e15, 0x6d19,
                0x2d13, 0x58ff, 0x78b2, 0x1fd9, 0x20f9, 0x6cb5, 0x33d2, 0x24db,
                0x089c,
            });
            try testArgs(@Vector(31, u15), .{
                0x11ed, 0x77f9, 0x4737, 0x1f92, 0x15ee, 0x61f7, 0x410c, 0x27a4,
                0x0910, 0x2f1d, 0x4721, 0x0be5, 0x5501, 0x5b40, 0x3db3, 0x0bf5,
                0x750f, 0x4f99, 0x4138, 0x5144, 0x4147, 0x13ed, 0x69cd, 0x374d,
                0x29cd, 0x45a4, 0x4189, 0x5178, 0x33c8, 0x5ffd, 0x433e,
            });
            try testArgs(@Vector(32, u15), .{
                0x4d4e, 0x6f97, 0x09aa, 0x12ee, 0x7322, 0x7add, 0x28f7, 0x3a07,
                0x058a, 0x73fc, 0x37a8, 0x1737, 0x763d, 0x1a18, 0x7dc5, 0x24bc,
                0x50f2, 0x2486, 0x4217, 0x635a, 0x6c7d, 0x2e1c, 0x72fe, 0x6e52,
                0x707b, 0x38d4, 0x04b0, 0x6ca3, 0x7e65, 0x5233, 0x06c7, 0x6e0d,
            });
            try testArgs(@Vector(33, u15), .{
                0x2382, 0x4c0e, 0x7720, 0x0233, 0x6894, 0x4aaa, 0x7a09, 0x2089,
                0x3fb8, 0x5f9b, 0x7628, 0x04b0, 0x0692, 0x690a, 0x49be, 0x5ffb,
                0x5a4f, 0x29c2, 0x308b, 0x6b3c, 0x5c24, 0x3764, 0x2c53, 0x44d5,
                0x3863, 0x7757, 0x57c6, 0x3654, 0x575c, 0x77c5, 0x4c94, 0x61f4,
                0x67d2,
            });
            try testArgs(@Vector(63, u15), .{
                0x422e, 0x5fbc, 0x2366, 0x145a, 0x3c76, 0x4892, 0x5208, 0x5fd4,
                0x7e52, 0x74a2, 0x3834, 0x201c, 0x05d6, 0x7d02, 0x5f6a, 0x0d96,
                0x72a4, 0x3304, 0x6514, 0x4d6c, 0x5b56, 0x697c, 0x5f62, 0x164a,
                0x6260, 0x267e, 0x3620, 0x372a, 0x7218, 0x5a6e, 0x0a82, 0x07e4,
                0x7a04, 0x5e62, 0x38ca, 0x4b64, 0x3106, 0x21b6, 0x41a4, 0x6828,
                0x4838, 0x3574, 0x5d9e, 0x55ee, 0x352a, 0x049e, 0x678e, 0x7604,
                0x6af0, 0x17a0, 0x74e4, 0x252e, 0x4c2e, 0x3744, 0x61e4, 0x1cca,
                0x3ade, 0x69cc, 0x6066, 0x7d6e, 0x1afa, 0x6daa, 0x5fa6,
            });
            try testArgs(@Vector(64, u15), .{
                0x4163, 0x5b5d, 0x0d65, 0x56b2, 0x7788, 0x3b80, 0x0faf, 0x3292,
                0x75ec, 0x5cba, 0x3a09, 0x60c0, 0x2840, 0x2798, 0x2957, 0x7a3b,
                0x4fb6, 0x478d, 0x38f8, 0x2cc2, 0x0d5b, 0x63f5, 0x208f, 0x26e2,
                0x0924, 0x411a, 0x6d93, 0x7c19, 0x45fb, 0x6f45, 0x5581, 0x1e1d,
                0x4a7f, 0x7fd8, 0x3ce3, 0x7244, 0x4f7b, 0x2327, 0x6e09, 0x2c02,
                0x55d9, 0x7f8d, 0x438b, 0x4bf4, 0x389b, 0x2c96, 0x75e9, 0x1aad,
                0x0bc0, 0x2de3, 0x6dc8, 0x0d5b, 0x35f9, 0x21ce, 0x73fd, 0x30db,
                0x25d0, 0x2ca9, 0x3478, 0x0f73, 0x726b, 0x5e32, 0x0ae8, 0x67a4,
            });
            try testArgs(@Vector(65, u15), .{
                0x7ea5, 0x6508, 0x140c, 0x68c4, 0x1b2a, 0x01ab, 0x27cd, 0x7943,
                0x4209, 0x48a7, 0x6d81, 0x727f, 0x2e0c, 0x709a, 0x04c0, 0x1ac4,
                0x6efd, 0x57db, 0x593b, 0x2331, 0x6a45, 0x2011, 0x3a1a, 0x7d33,
                0x3053, 0x42d1, 0x08c1, 0x28ea, 0x1f0f, 0x0abc, 0x2051, 0x5125,
                0x7298, 0x0bfd, 0x75b9, 0x4cfe, 0x0b22, 0x2a06, 0x4f2d, 0x29a1,
                0x7a91, 0x4268, 0x72db, 0x11c1, 0x04e4, 0x35dd, 0x29c6, 0x411d,
                0x11de, 0x2399, 0x61ec, 0x2386, 0x5d27, 0x033d, 0x1c83, 0x3e41,
                0x5915, 0x4aa1, 0x28ef, 0x385e, 0x64bc, 0x1d0b, 0x7f84, 0x1546,
                0x7d72,
            });

            try testArgs(@Vector(1, i16), .{
                -0x3d83,
            });
            try testArgs(@Vector(2, i16), .{
                -0x3e9f, -0x6fd5,
            });
            try testArgs(@Vector(3, i16), .{
                0x2a8d, 0x0b83, 0x26e9,
            });
            try testArgs(@Vector(4, i16), .{
                -0x6d64, 0x7972, -0x4200, -0x102f,
            });
            try testArgs(@Vector(5, i16), .{
                -0x4e21, 0x1c47, -0x2fd6, 0x3235, -0x4484,
            });
            try testArgs(@Vector(7, i16), .{
                0x7846, 0x49c6, -0x46d0, 0x5866, 0x440f, 0x710c, -0x1b93,
            });
            try testArgs(@Vector(8, i16), .{
                -0x6ca8, 0x38df, -0x2893, 0x0ec8, -0x4c26, -0x5d34, -0x61f4, 0x45fa,
            });
            try testArgs(@Vector(9, i16), .{
                0x5b79, 0x00e5, 0x4b71, -0x102b, 0x0ae1, 0x1c7f, 0x247e, 0x5445,
                0x5270,
            });
            try testArgs(@Vector(15, i16), .{
                0x6cdd,  -0x3e62, 0x3681,  -0x409c, -0x2ecf, 0x5437,  -0x540f, -0x4fa8,
                -0x0846, -0x62be, -0x70ea, 0x6020,  -0x2b00, -0x29af, 0x6fe3,
            });
            try testArgs(@Vector(16, i16), .{
                0x7e6b, -0x1a1c, 0x6a16,  0x2a32, -0x52f2, 0x350f, 0x76ae, -0x52ac,
                0x620e, -0x4ab1, -0x18b8, 0x379a, -0x5c9d, 0x6c61, 0x6615, 0x7c8c,
            });
            try testArgs(@Vector(17, i16), .{
                -0x08d6, 0x760a,  -0x79f6, 0x5529,  0x0440,  0x5636, 0x3376,  -0x7ec8,
                -0x2c94, -0x74a0, 0x5a88,  -0x4429, -0x47b4, 0x3127, -0x2099, -0x192b,
                -0x3512,
            });
            try testArgs(@Vector(31, i16), .{
                0x6e1c,  0x7729,  -0x31f6, 0x199d, 0x1cb1,  -0x60fd, 0x1cae, -0x26f7,
                -0x00f1, -0x3755, 0x6dae,  0x7ca8, -0x3059, 0x0398,  0x0130, 0x032c,
                0x1c33,  -0x5df1, 0x4628,  0x30ba, -0x0842, 0x32ad,  0x7489, -0x3d75,
                0x0a20,  0x151e,  0x0b06,  0x6220, -0x105f, 0x168a,  0x6d02,
            });
            try testArgs(@Vector(32, i16), .{
                -0x788f, -0x1481, 0x546e,  0x2bc4,  0x2cdb,  -0x0afe, 0x3d1d,  -0x0019,
                -0x1559, -0x5ad7, 0x1741,  -0x3445, -0x510c, -0x28a7, 0x4407,  -0x03c0,
                -0x7339, -0x2038, 0x24c8,  0x30c0,  0x1d35,  -0x76df, -0x03c7, 0x29a8,
                -0x000a, 0x47c7,  -0x648b, -0x7610, 0x755b,  -0x21ec, -0x1106, 0x5255,
            });
            try testArgs(@Vector(33, i16), .{
                -0x008a, -0x19d2, -0x49af, -0x67c4, -0x586f, -0x2365, -0x1a6d, -0x2535,
                -0x2ff2, -0x598c, -0x6dd3, -0x2ca0, -0x2e5c, -0x2513, -0x312a, -0x0d80,
                -0x703c, -0x16bf, -0x46e0, -0x7725, -0x6fe0, -0x7f8e, -0x7e83, -0x6b72,
                -0x492d, -0x234f, -0x5862, -0x0134, -0x4b2a, -0x50f4, -0x3b89, -0x25ce,
                -0x43ec,
            });
            try testArgs(@Vector(63, i16), .{
                -0x6e10, -0x1886, -0x0821, 0x5f19,  -0x3542, -0x42cf, 0x22f6,  0x5418,
                -0x134f, -0x5ea5, 0x5f93,  -0x26ef, 0x49f6,  0x2bf3,  -0x5126, 0x5ebf,
                -0x2c82, 0x4ddb,  -0x7a10, 0x29d3,  0x5b11,  0x171f,  -0x2587, -0x1eea,
                -0x0e2f, 0x1151,  -0x6243, -0x2682, 0x0ab5,  0x39b7,  0x5799,  0x20b6,
                0x7919,  0x6cd9,  0x7874,  0x6f72,  -0x2128, 0x2990,  0x4d5f,  -0x7621,
                -0x77e1, -0x54c2, -0x344f, 0x3f93,  -0x7d43, 0x0450,  0x3353,  -0x414c,
                0x633d,  0x2831,  0x2d32,  -0x4f48, -0x4604, 0x6c38,  -0x72e5, 0x25b5,
                -0x310b, 0x3a17,  0x0119,  -0x56e8, 0x6332,  -0x29a4, -0x5c90,
            });
            try testArgs(@Vector(64, i16), .{
                -0x11a2, 0x1875,  0x295d,  0x26a4,  -0x61a0, 0x0ce3,  0x7700,  -0x3cbe,
                0x606c,  0x2b3c,  -0x209f, 0x2330,  -0x3389, 0x6aa5,  -0x2396, -0x5700,
                0x3e00,  -0x4ed1, -0x228f, 0x7ccf,  -0x0c7b, -0x4ea4, 0x5c3b,  -0x3d8a,
                -0x7320, 0x02b7,  0x72db,  0x0542,  -0x32a6, -0x29c3, -0x5566, 0x66f5,
                0x5562,  0x3604,  -0x4117, 0x1942,  -0x3430, 0x4b70,  0x2ea0,  -0x2326,
                -0x715d, -0x292a, -0x16ab, -0x1471, 0x4ce7,  0x5246,  0x4672,  0x342c,
                -0x2dff, 0x6788,  -0x1114, -0x4756, 0x77b4,  0x41a3,  -0x01dc, 0x6671,
                -0x6255, -0x0bd2, 0x534e,  -0x628c, 0x03d2,  -0x7835, -0x4720, 0x5293,
            });
            try testArgs(@Vector(65, i16), .{
                0x2743,  -0x47c2, 0x39e3,  0x3e4e,  -0x46aa, 0x729e,  0x7707,  0x4697,
                -0x4726, -0x06d6, -0x1d9e, -0x71bd, 0x0efa,  -0x3cb9, -0x23ad, -0x75a1,
                -0x3652, -0x3a95, -0x04a1, -0x66ae, -0x59c9, -0x7f55, 0x523f,  -0x6d8a,
                0x272a,  -0x3955, 0x0206,  0x73d6,  -0x2375, 0x42a7,  0x3986,  0x179b,
                0x6e63,  -0x7119, -0x73b2, -0x22b1, 0x28ab,  0x1fae,  -0x65f1, 0x4a4a,
                -0x37aa, -0x5cb6, -0x3c42, -0x16c2, 0x3e0a,  -0x7f7a, 0x15fb,  0x52c7,
                -0x018a, 0x0176,  -0x4b2d, -0x13e5, 0x057f,  -0x3ba9, -0x5805, 0x45d6,
                -0x787e, 0x2f2a,  0x7082,  -0x0b5e, 0x16c6,  -0x7a92, -0x68c6, -0x7869,
                -0x63ce,
            });

            try testArgs(@Vector(1, u16), .{
                0x275d,
            });
            try testArgs(@Vector(2, u16), .{
                0x72e1, 0xd759,
            });
            try testArgs(@Vector(3, u16), .{
                0x366a, 0x4e97, 0xeb63,
            });
            try testArgs(@Vector(4, u16), .{
                0x57a8, 0x7ae8, 0x6e0f, 0xb7ac,
            });
            try testArgs(@Vector(5, u16), .{
                0x0ff3, 0xc907, 0xd1b7, 0x4820, 0x6e24,
            });
            try testArgs(@Vector(7, u16), .{
                0x5ca4, 0x5fff, 0x6fea, 0xc089, 0xdfbc, 0x6808, 0xd12f,
            });
            try testArgs(@Vector(8, u16), .{
                0xfcb4, 0xf7a2, 0xb84f, 0x9eaa, 0x3c5b, 0x9092, 0xf2ce, 0x10a0,
            });
            try testArgs(@Vector(9, u16), .{
                0x2c7d, 0xfa5b, 0x8039, 0xdb41, 0xe676, 0x2674, 0x7c5f, 0xc575,
                0x9d24,
            });
            try testArgs(@Vector(15, u16), .{
                0x0da3, 0x8306, 0x644f, 0xfad0, 0x09b6, 0x3936, 0x1883, 0xf19d,
                0xad5c, 0x07bd, 0x4e7d, 0xbce0, 0xa55e, 0xf653, 0xeea3,
            });
            try testArgs(@Vector(16, u16), .{
                0xc8d7, 0x16bd, 0x5e6d, 0x4ec3, 0x95f2, 0x5876, 0x4b0c, 0x5286,
                0x62d1, 0xebb7, 0x8db9, 0xecdc, 0x1bd7, 0x7b0f, 0x1fd8, 0x7f17,
            });
            try testArgs(@Vector(17, u16), .{
                0x24c8, 0xdc8d, 0x81db, 0xdfb9, 0xeac1, 0x84a6, 0x549c, 0xf3bd,
                0xd2e4, 0xf089, 0xcebb, 0x4af0, 0xab83, 0xf9fe, 0xacc0, 0x2295,
                0xdff9,
            });
            try testArgs(@Vector(31, u16), .{
                0x403b, 0x11b5, 0xf09e, 0x7524, 0xc26a, 0x43b1, 0x06cd, 0xea16,
                0xfd76, 0xd91e, 0xd79f, 0xbeb6, 0x4677, 0xf9ca, 0x8595, 0x8d8a,
                0xe17d, 0xf13e, 0x4f1f, 0x0fdd, 0x522b, 0x6376, 0x85f4, 0x98b2,
                0xc2dc, 0xdac3, 0x195e, 0x66d2, 0x0261, 0x83b3, 0x5394,
            });
            try testArgs(@Vector(32, u16), .{
                0x28bd, 0x1845, 0xe8b0, 0x41bb, 0xec1f, 0xa140, 0x666a, 0x7dad,
                0x448e, 0x972b, 0x81db, 0xe582, 0xce85, 0x8927, 0x05d8, 0x7cf1,
                0x1f69, 0x1087, 0xf2df, 0xfcf0, 0x98a2, 0x4fe5, 0x0482, 0x9599,
                0x2964, 0x5275, 0xc3f4, 0x3a58, 0xca17, 0x955b, 0x59d2, 0x40b0,
            });
            try testArgs(@Vector(33, u16), .{
                0x55cb, 0x6633, 0x78ad, 0x9412, 0xdbc4, 0x209a, 0x62c1, 0xf6ac,
                0xee41, 0x2273, 0xb4e4, 0x8be3, 0x07df, 0xf834, 0x052d, 0x3b82,
                0xf4e7, 0xbf41, 0xeb0d, 0x92ab, 0x88d9, 0x9409, 0xc131, 0x0f66,
                0x7b4f, 0x41f6, 0xb59b, 0xd18d, 0x1235, 0x119d, 0x9dbf, 0xa16c,
                0xc22e,
            });
            try testArgs(@Vector(63, u16), .{
                0x292b, 0x76cb, 0xbb04, 0x3962, 0xe678, 0x54a4, 0x13ba, 0x6419,
                0x646c, 0x5241, 0x5b13, 0xb54a, 0x4967, 0xfbed, 0xaf9d, 0xde8f,
                0x68ae, 0xa5be, 0xf3f9, 0x0c40, 0x1c32, 0xa8b3, 0xb19e, 0xd093,
                0x8e8c, 0xcb05, 0xe5c3, 0x2e06, 0xcfe2, 0xdd4c, 0x66af, 0x9fb9,
                0x4a8f, 0xe4be, 0xe203, 0x77cb, 0x70cd, 0x871d, 0xb16a, 0x4f34,
                0xfe15, 0x8ddd, 0xf389, 0x38ae, 0x31ff, 0xe966, 0x2470, 0x9c16,
                0x2c85, 0xc2c4, 0x94d1, 0x693c, 0xcad6, 0x4eb2, 0x0892, 0x5ede,
                0x6509, 0x7de4, 0xeeb6, 0xe686, 0x3b36, 0x0600, 0x79d2,
            });
            try testArgs(@Vector(64, u16), .{
                0x3896, 0x7e5b, 0x2e2f, 0xae17, 0xdf3f, 0xa69e, 0x7a2f, 0xe468,
                0x5410, 0x80fa, 0xfcea, 0xabcd, 0x6349, 0x7477, 0x7855, 0xa0ae,
                0xb797, 0xcb52, 0x0569, 0x579a, 0x0117, 0x7254, 0x3458, 0xde51,
                0x1900, 0x3d53, 0x25b5, 0x3b2a, 0x04d1, 0x4ab4, 0x5f5e, 0xf56a,
                0x066b, 0x7e74, 0xc044, 0x7eb7, 0x5b9f, 0xa7d9, 0xfeda, 0x6b3a,
                0xfbd5, 0xa8d8, 0xe4ab, 0x33b8, 0xfca7, 0x519e, 0xc49a, 0x3340,
                0xe08e, 0x8e0e, 0xf0ca, 0x87d9, 0x8965, 0x61f0, 0xe3da, 0x482e,
                0x3909, 0xe40f, 0x96f3, 0x494b, 0xdde3, 0x0361, 0xbc80, 0x3d92,
            });
            try testArgs(@Vector(65, u16), .{
                0xba2b, 0xfd21, 0x640f, 0x550d, 0x3a95, 0x8969, 0x9455, 0xe1cd,
                0x4d01, 0x1d2f, 0x97f9, 0xeb9f, 0xefd9, 0xfc03, 0x5527, 0xabc9,
                0x8f8d, 0x8435, 0x065d, 0xf11b, 0x61eb, 0x9ef5, 0x1051, 0x58df,
                0xe1d5, 0xeab7, 0x8753, 0x6fbb, 0xf28f, 0x7bc7, 0x025b, 0x29d3,
                0x59d3, 0x2a0d, 0x10f5, 0x5ac9, 0x0d33, 0x56ff, 0x5213, 0xf7e5,
                0xa1d5, 0xefaf, 0xec75, 0x36bb, 0x1641, 0x1a5b, 0x099f, 0x726d,
                0x7e19, 0x0b09, 0x9085, 0xdecf, 0x1e23, 0xa92b, 0xe9f3, 0x0873,
                0xfcb5, 0x9afd, 0x702f, 0x2785, 0x3b0b, 0x03d5, 0xb43b, 0x5a0d,
                0x413f,
            });

            try testArgs(@Vector(1, i17), .{
                0x0202b,
            });
            try testArgs(@Vector(2, i17), .{
                -0x0c0d7, -0x066d3,
            });
            try testArgs(@Vector(3, i17), .{
                0x0f620, 0x07c24, 0x04e4b,
            });
            try testArgs(@Vector(4, i17), .{
                0x0fb3b, 0x03d42, 0x03e54, 0x0af90,
            });
            try testArgs(@Vector(5, i17), .{
                0x0a9cf,  -0x05bed, 0x0e110, 0x0994b,
                -0x0ece6,
            });
            try testArgs(@Vector(7, i17), .{
                0x046d3,  0x04690,  -0x076c0, 0x08758,
                -0x07460, -0x039bf, 0x0a20e,
            });
            try testArgs(@Vector(8, i17), .{
                0x06e32, -0x0474e, 0x0e18f, -0x066dd,
                0x06e45, -0x0eaf6, 0x05365, -0x0f05d,
            });
            try testArgs(@Vector(9, i17), .{
                -0x058ab, -0x046ff, -0x012a9, 0x0ea46,
                -0x05320, 0x03073,  0x0eb08,  0x06b31,
                -0x02cf0,
            });
            try testArgs(@Vector(15, i17), .{
                -0x034cb, 0x0ecd5,  -0x00dfc, 0x0f1f4,
                0x03c82,  0x040c3,  0x01a20,  0x00e95,
                0x0d9d7,  -0x0ed69, -0x0012d, 0x03906,
                0x04d22,  0x0b604,  -0x0b30b,
            });
            try testArgs(@Vector(16, i17), .{
                0x064ad,  -0x014c9, 0x0f32f,  0x03808,
                -0x029e8, 0x0b9bc,  -0x04ff1, -0x010fb,
                0x05d25,  0x01fac,  -0x0e463, 0x02cbf,
                -0x015e4, 0x0c69d,  -0x0facb, -0x0ba53,
            });
            try testArgs(@Vector(17, i17), .{
                0x0c52e,  0x0fa5d,  -0x02799, 0x0c4e2,
                -0x046e3, 0x0c498,  0x0b1de,  -0x05e9e,
                -0x041d2, -0x06633, 0x0dbcb,  -0x00636,
                0x0a4ec,  0x0dc90,  0x0839f,  -0x026d4,
                -0x06c4e,
            });
            try testArgs(@Vector(31, i17), .{
                0x03016,  -0x0f230, -0x03a13, 0x0e818,
                -0x01bb0, 0x070ef,  0x09372,  0x077f0,
                0x0e933,  0x0701f,  0x08dcb,  -0x0ca62,
                -0x09016, 0x05b53,  0x0a2ed,  -0x031dd,
                0x052d7,  -0x034a2, -0x0a200, 0x095fd,
                -0x077a7, 0x0388c,  0x0560c,  0x09aab,
                0x0b1f1,  0x04a01,  -0x0b3a2, 0x091e5,
                0x0b34d,  0x043ad,  0x0f724,
            });
            try testArgs(@Vector(32, i17), .{
                0x0728d,  0x0410d,  0x0c361,  0x087b4,
                -0x00ccd, 0x0ac76,  0x0fd60,  -0x0bc3a,
                0x0fa1c,  0x07886,  -0x0d023, 0x034fd,
                -0x0ad34, 0x00953,  0x02c9f,  -0x0423e,
                -0x0804c, -0x0c794, -0x0052e, 0x0ed76,
                0x087b6,  -0x0ad23, -0x018b7, 0x0e471,
                -0x03cdd, 0x0b991,  -0x00ac2, -0x08600,
                -0x0f09b, 0x0d8c6,  0x0c5f6,  0x0909d,
            });
            try testArgs(@Vector(33, i17), .{
                0x0008f,  0x0955f,  0x0468f,  0x0f764,
                -0x0c02a, -0x09c51, -0x077b2, 0x04b66,
                0x0ff45,  0x04914,  0x06c4e,  0x021fd,
                0x09def,  0x0a0ff,  0x0eeb5,  0x08c27,
                0x009b7,  0x01e47,  -0x07f19, -0x00de1,
                -0x03409, -0x093ec, 0x01fc5,  0x0d2ac,
                -0x02a02, -0x0e383, -0x0dc33, 0x09c24,
                0x0e007,  0x07e4f,  -0x0b7b1, -0x0f623,
                0x0d21e,
            });

            try testArgs(@Vector(1, u17), .{
                0x11623,
            });
            try testArgs(@Vector(2, u17), .{
                0x15a11, 0x19fd4,
            });
            try testArgs(@Vector(3, u17), .{
                0x1ab5b, 0x0506b, 0x07d78,
            });
            try testArgs(@Vector(4, u17), .{
                0x0768c, 0x08441, 0x1f5a8, 0x09628,
            });
            try testArgs(@Vector(5, u17), .{
                0x1e9cd, 0x02822, 0x1e69a, 0x1a728,
                0x14b1d,
            });
            try testArgs(@Vector(7, u17), .{
                0x001b3, 0x06963, 0x012fc, 0x13c02,
                0x04f1e, 0x12aa0, 0x11097,
            });
            try testArgs(@Vector(8, u17), .{
                0x1c9e5, 0x1700f, 0x10903, 0x01130,
                0x07523, 0x1689c, 0x11a72, 0x00db7,
            });
            try testArgs(@Vector(9, u17), .{
                0x1d512, 0x1fa25, 0x18e17, 0x1e0b9,
                0x0e1ca, 0x090a9, 0x19617, 0x08522,
                0x1dd51,
            });
            try testArgs(@Vector(15, u17), .{
                0x15869, 0x150c4, 0x1d78b, 0x139c7,
                0x0a0d0, 0x1d336, 0x0cda4, 0x0d1f5,
                0x07020, 0x0645a, 0x12f59, 0x18ae7,
                0x0a2a6, 0x08fde, 0x15b31,
            });
            try testArgs(@Vector(16, u17), .{
                0x13eb8, 0x1a482, 0x17589, 0x0ed6b,
                0x11029, 0x02430, 0x1fb7a, 0x0c905,
                0x17584, 0x191d1, 0x1ae69, 0x0d313,
                0x06b92, 0x08f72, 0x1b00b, 0x08d76,
            });
            try testArgs(@Vector(17, u17), .{
                0x0bde4, 0x08ec6, 0x138dc, 0x14f4d,
                0x169aa, 0x12db2, 0x0d0fc, 0x1af45,
                0x0a2f9, 0x08f46, 0x1bcb6, 0x1848f,
                0x0cffe, 0x0748d, 0x07ca8, 0x15191,
                0x0f9f6,
            });
            try testArgs(@Vector(31, u17), .{
                0x07d61, 0x10245, 0x1df09, 0x1aaec,
                0x0204d, 0x0a101, 0x131f1, 0x07340,
                0x09510, 0x04f60, 0x1946d, 0x1e8c1,
                0x06030, 0x1923c, 0x031ed, 0x147e1,
                0x1199d, 0x12621, 0x16f85, 0x0b180,
                0x0dbd1, 0x10901, 0x1d188, 0x1fa81,
                0x0ba30, 0x155dd, 0x01ed4, 0x1b8f9,
                0x13bec, 0x13361, 0x06efd,
            });
            try testArgs(@Vector(32, u17), .{
                0x0a881, 0x17906, 0x1bce8, 0x1b384,
                0x03462, 0x0cfcb, 0x08246, 0x0f001,
                0x0c683, 0x1c0cc, 0x026c9, 0x14306,
                0x0cdca, 0x12348, 0x0f246, 0x0a420,
                0x1a56a, 0x046ab, 0x004c0, 0x1bc02,
                0x14f6f, 0x1a66c, 0x0b6cf, 0x07167,
                0x09702, 0x07dab, 0x14667, 0x02ce9,
                0x00a03, 0x09aca, 0x11746, 0x125c2,
            });
            try testArgs(@Vector(33, u17), .{
                0x1bde5, 0x1910a, 0x0d78d, 0x177d0,
                0x17c40, 0x0123b, 0x12446, 0x1ceca,
                0x1e79e, 0x15013, 0x19cf7, 0x15016,
                0x17566, 0x1c0e8, 0x12da4, 0x0fb6c,
                0x1c442, 0x1e8e9, 0x1aa74, 0x0ba54,
                0x14fb7, 0x1aab0, 0x030a5, 0x041ed,
                0x05d98, 0x1d1ed, 0x0083d, 0x128f7,
                0x1e93a, 0x14a00, 0x0ac7c, 0x1c052,
                0x17fd7,
            });

            try testArgs(@Vector(1, i31), .{
                -0x3f5c3228,
            });
            try testArgs(@Vector(2, i31), .{
                -0x307f1325, -0x0e59e507,
            });
            try testArgs(@Vector(3, i31), .{
                0x24544bf1, -0x104aebe0, -0x371b3c03,
            });
            try testArgs(@Vector(4, i31), .{
                -0x3616321a, 0x3b48f54b, -0x2790d613, 0x10122d7e,
            });
            try testArgs(@Vector(5, i31), .{
                0x2bfa57aa, -0x1392b765, -0x05d1942f, 0x3c868ece,
                0x32bc4fbc,
            });
            try testArgs(@Vector(7, i31), .{
                0x327ca4d4, -0x262b2dfc, 0x3d97b95c, -0x350d9a5f,
                0x0e9f3560, 0x1e7abb41,  0x38f6b827,
            });
            try testArgs(@Vector(8, i31), .{
                -0x3facecea, -0x267ee011, -0x3d4c39b3, -0x3681b9cc,
                -0x0cc15566, 0x1ac2d80d,  0x0b73bf53,  0x3ac83f51,
            });
            try testArgs(@Vector(9, i31), .{
                0x140fe5f4,  -0x316532d0, 0x3bfa5171, -0x10ec6a3b,
                0x24c600b5,  -0x1105f5c3, 0x02ede996, -0x10ae24a9,
                -0x3cf0b288,
            });
            try testArgs(@Vector(15, i31), .{
                0x39c4bcec,  0x11477e23,  0x1fe75212,  -0x338b45ac,
                0x3674ff0a,  0x0d6158db,  0x0daeb9cc,  0x28163c31,
                -0x246068ac, 0x2759ba5a,  -0x0c332dfb, -0x2e940d23,
                -0x202082f6, -0x28f86695, -0x138ee60f,
            });
            try testArgs(@Vector(16, i31), .{
                0x299b126f,  -0x036abc93, -0x316932c9, -0x000ec330,
                0x2b5b55e5,  0x1152d33c,  -0x38795956, -0x21775cfb,
                0x33b2f235,  -0x176a2b8a, -0x35a414c1, -0x05cea30b,
                -0x15d3fae1, -0x25099671, -0x2b129fc8, 0x1d85ef27,
            });
            try testArgs(@Vector(17, i31), .{
                -0x223aadf8, 0x33234ff2,  -0x1db41796, 0x22e5237c,
                -0x1410d17e, -0x1ed10316, 0x30dff9be,  0x074e62a4,
                0x2390942e,  0x226001ee,  -0x21707fa4, -0x133ec03e,
                0x3a1b2d46,  -0x008bb082, 0x2a9b9b06,  0x1d9d86d8,
                -0x155eec72,
            });
            try testArgs(@Vector(31, i31), .{
                -0x069867e7, 0x3e0186da,  0x051764c2,  0x285c56eb,
                0x13ec479a,  -0x15186c10, -0x3a8075f2, -0x024b4bfe,
                -0x05b08735, 0x09370e80,  0x27d62abd,  -0x0b7b1b4a,
                -0x150b9bf2, 0x1f605503,  0x1c8775dc,  0x3ff9f92c,
                -0x2dd39a05, -0x21cf63bb, 0x3152b0af,  0x32a0bd47,
                0x3bc898df,  -0x1fbadec1, -0x3d109aa9, 0x396300a9,
                -0x3fa15657, 0x385611db,  -0x194a13eb, 0x023adda1,
                0x051dc63e,  0x35aff5e7,  -0x0e90420b,
            });
            try testArgs(@Vector(32, i31), .{
                0x112b30e4,  -0x0da9c739, -0x10174644, 0x157e992d,
                0x19473df4,  0x3b194945,  -0x2e6a085c, 0x2eae0b44,
                -0x0258e533, -0x3954621c, -0x3bac17c9, -0x12d5ca74,
                0x27f994df,  -0x0a1af60a, -0x283eea84, -0x304d9adc,
                -0x0dcbf719, -0x26a8ad2a, -0x26da09cc, 0x3e897a4d,
                -0x33e8b253, 0x173b1b37,  0x1949b69f,  -0x3e40aae4,
                0x34b03b07,  -0x30c7c779, -0x2817e4d2, -0x13c5b391,
                0x314f4544,  -0x07966d92, -0x07e94444, 0x3e344c6d,
            });
            try testArgs(@Vector(33, i31), .{
                0x10c8e0c8,  -0x08367b53, -0x039c1426, 0x0f5abdc6,
                -0x38664c7c, -0x1ffeeff5, 0x0e89e2fa,  -0x047559e3,
                0x3b1a6467,  -0x070764a4, -0x1227de1b, 0x05f20469,
                -0x2926e5ee, 0x1a026b3a,  0x1f0122b1,  -0x2bc4e9ac,
                -0x01173206, 0x2b69af3f,  -0x00052dce, 0x2e9332f3,
                -0x1ef69302, 0x1f20844a,  -0x03cc2644, -0x206d68c4,
                -0x15c57bf9, 0x211a14ec,  -0x35fe6ae4, -0x0ac708c4,
                0x3829ca16,  -0x11476434, 0x2402fbb8,  0x0c78da7b,
                0x3e40fb9a,
            });

            try testArgs(@Vector(1, u31), .{
                0x2c6b497e,
            });
            try testArgs(@Vector(2, u31), .{
                0x0f9eb70f, 0x688a61f6,
            });
            try testArgs(@Vector(3, u31), .{
                0x05045dcc, 0x5dafb08f, 0x72314cfd,
            });
            try testArgs(@Vector(4, u31), .{
                0x5bdb842a, 0x2cbf89db, 0x01ca9eb3, 0x0c06df26,
            });
            try testArgs(@Vector(5, u31), .{
                0x31a4c3c4, 0x3db09048, 0x0b169f8c, 0x35feaf93,
                0x0e3ab88b,
            });
            try testArgs(@Vector(7, u31), .{
                0x1f83eae7, 0x5b49e350, 0x0c324714, 0x46a152c4,
                0x5fa04eeb, 0x1339412b, 0x6c8113e9,
            });
            try testArgs(@Vector(8, u31), .{
                0x611bb129, 0x5d2aaa83, 0x33fe2094, 0x4196b6e7,
                0x4149fddc, 0x5439adc5, 0x4b88bbfd, 0x1c217427,
            });
            try testArgs(@Vector(9, u31), .{
                0x3aed8e55, 0x24cc6983, 0x202a1a4a, 0x2b2c7a1f,
                0x0b356172, 0x6d5d4290, 0x705bab83, 0x231da4ac,
                0x3c8da70f,
            });
            try testArgs(@Vector(15, u31), .{
                0x598fde59, 0x7e4123c8, 0x3eff4e38, 0x2278501a,
                0x7d0181ac, 0x2fd9cbc9, 0x58e249ee, 0x52ebe5ed,
                0x6d26aabf, 0x64e0376b, 0x511f2fc9, 0x5ccbbacd,
                0x7218842b, 0x01d2076a, 0x34427409,
            });
            try testArgs(@Vector(16, u31), .{
                0x528a3575, 0x563d5ea6, 0x09958a5c, 0x1b78e232,
                0x46df9a07, 0x1e25132f, 0x4cb32673, 0x0e62352e,
                0x05cf2d1e, 0x48f3e722, 0x6c8bd3ea, 0x3a3d18c1,
                0x11a6c988, 0x0a1d6527, 0x091272d9, 0x4217d85a,
            });
            try testArgs(@Vector(17, u31), .{
                0x46cfe55d, 0x71e0a946, 0x69be47c6, 0x447c001a,
                0x4d955f10, 0x3de520fe, 0x71172bfe, 0x3565930f,
                0x57a0a6e1, 0x6141f169, 0x05f34daf, 0x08394745,
                0x367b0a18, 0x0f03b206, 0x06b738c5, 0x6c99eefc,
                0x16080d55,
            });
            try testArgs(@Vector(31, u31), .{
                0x63d9eb09, 0x3471a86f, 0x75c2261b, 0x139932ae,
                0x4440b017, 0x37927e7e, 0x066348e7, 0x3539f369,
                0x4b68b426, 0x7eeb5e62, 0x102acfd3, 0x19a2be5e,
                0x130b4bcd, 0x046017c3, 0x14d105eb, 0x08d03f5c,
                0x5f2b7043, 0x5d9947ea, 0x6290f828, 0x22ba5819,
                0x348a8398, 0x73cb09bb, 0x2baaeb81, 0x23432105,
                0x41a27099, 0x45c95496, 0x450a1390, 0x3ef286c7,
                0x1239a9f3, 0x4e02de22, 0x6b026142,
            });
            try testArgs(@Vector(32, u31), .{
                0x16d1447a, 0x512f1aec, 0x7e0b81bc, 0x61e01788,
                0x4b04fa9e, 0x5347bc4c, 0x54dfd0ba, 0x5e6f604d,
                0x7c030feb, 0x4b752bfc, 0x7a6f0ff8, 0x37ab4908,
                0x75a473dc, 0x4f47141b, 0x48273189, 0x6c0dab29,
                0x4db28e4d, 0x38499d28, 0x413d5398, 0x6e1a6e2f,
                0x6c371778, 0x573122ed, 0x4eca8dec, 0x578b3f3f,
                0x44227c9b, 0x3ed38de8, 0x5bda357b, 0x221e6b2d,
                0x26adc9a9, 0x03cbf79a, 0x4c1b67ae, 0x23bc3b4f,
            });
            try testArgs(@Vector(33, u31), .{
                0x30658443, 0x6e6b28e0, 0x4ddcf7fa, 0x213d137a,
                0x5665eb75, 0x7584b67f, 0x752e0758, 0x2219b79f,
                0x63260da1, 0x63eb63c0, 0x5e6379fa, 0x5e6092ba,
                0x3b9ef10c, 0x70007fa1, 0x5168d49d, 0x500165f2,
                0x3cce8495, 0x2ccc37a0, 0x77355fd8, 0x6db8713a,
                0x32be3c7f, 0x6c5d8fd6, 0x0661a0d7, 0x2addb6f5,
                0x7f6ffe40, 0x3e044497, 0x31aa9ce7, 0x68f27de6,
                0x29ac6c5a, 0x33a9ac02, 0x1cebe9be, 0x008f2d15,
                0x114ece53,
            });

            try testArgs(@Vector(1, i32), .{
                -0x57167162,
            });
            try testArgs(@Vector(2, i32), .{
                -0x0afc5ccf, 0x7c289f05,
            });
            try testArgs(@Vector(3, i32), .{
                -0x62b04b64, -0x749219be, -0x5f6f4126,
            });
            try testArgs(@Vector(4, i32), .{
                -0x057cc6de, -0x76130bb3, -0x58686a0f, 0x7c2f79d8,
            });
            try testArgs(@Vector(5, i32), .{
                0x13e42c0c, -0x30bf125a, 0x6cfc00ce, 0x45cd40ec,
                0x2b23633c,
            });
            try testArgs(@Vector(7, i32), .{
                -0x05e67091, 0x610956e2, 0x6f3044e4,  0x55f7c13a,
                -0x025bd536, 0x7e9b59d9, -0x2643b7f9,
            });
            try testArgs(@Vector(8, i32), .{
                0x02242952, 0x1c9e0018, 0x0202ca9a, 0x613a616e,
                0x1a7d609f, 0x08df0618, 0x67d9f0bb, 0x62f5eaa7,
            });
            try testArgs(@Vector(9, i32), .{
                -0x560db429, 0x1b2a7851, -0x08c78275, -0x44062b5d,
                0x15a9056e,  0x67387ef1, -0x1a9e2649, -0x2b0a542c,
                0x4a753362,
            });
            try testArgs(@Vector(15, i32), .{
                0x65c0a394,  -0x5776b4dc, 0x4a04bafd,  0x05cebaa5,
                -0x2d850047, -0x54125808, -0x1ad50b8e, -0x18155809,
                -0x49d97a00, 0x7b4a7238,  -0x14e94ce1, -0x3eb4baec,
                -0x31e938da, -0x2478216f, 0x3f44efb9,
            });
            try testArgs(@Vector(16, i32), .{
                0x19eef434,  -0x52773350, -0x17d21248, -0x5344d662,
                -0x0e9bddfd, 0x336d8629,  -0x4923275c, -0x4d2cdcde,
                0x265c60b0,  -0x1ea18441, -0x60576071, 0x4305bca0,
                0x3d91f4a8,  0x5c7c692f,  0x5d9fee97,  -0x37b8cee3,
            });
            try testArgs(@Vector(17, i32), .{
                0x4adeebba,  -0x4ea233b1, -0x13f148a7, 0x2b84b4ce,
                0x6a3696fd,  0x5c8fbdf8,  -0x79b39489, 0x6a2e0352,
                0x28de7593,  0x36afb0c1,  0x35e7b750,  -0x798a2b63,
                -0x6dc14668, 0x3bb49d78,  0x12efb113,  0x08d78e70,
                0x7e4e6b26,
            });
            try testArgs(@Vector(31, i32), .{
                0x3313989c,  -0x6114ea29, 0x24a5413f,  0x5403f71c,
                0x6cd915b8,  0x1491266e,  -0x33c2d8e9, -0x7758cc5f,
                0x53928da8,  -0x0e3fa3e8, 0x69f14e4e,  -0x0238a052,
                0x32c41453,  0x022675a1,  -0x345e5943, 0x3cd5446e,
                0x5f581036,  0x129b3b3a,  -0x4872b525, 0x3d0e213b,
                0x5a548a0d,  -0x70911c7d, 0x552ffd1a,  -0x66dc962a,
                -0x0e6ad8fe, 0x759e3543,  -0x3b9be89f, -0x49b6d632,
                -0x4ce29b04, 0x3faa898d,  -0x4f32bd09,
            });
            try testArgs(@Vector(32, i32), .{
                -0x352ba6a8, -0x74bb8a9e, 0x5328eafd,  -0x26f782be,
                -0x5a68e0ce, 0x0a28563b,  -0x1f3389ce, 0x60a45ab6,
                0x4b3d4026,  0x3d1fe7fe,  -0x7417a38d, -0x1907cd8d,
                0x797cc6d0,  0x431a0fe1,  0x5999b33f,  0x3b4692d2,
                0x23bf1d7e,  0x39db2e30,  0x4d11c405,  0x322da6ce,
                0x1101d6f7,  -0x063b8045, -0x56e008cc, -0x109cef25,
                -0x11cd8d98, -0x7a6d3339, -0x5b96ffcb, 0x29ffea46,
                0x00241d06,  -0x6666bd45, -0x0fef4041, 0x51ea50c3,
            });
            try testArgs(@Vector(33, i32), .{
                0x41619032,  0x76143ec6,  0x066d2c66,  0x65a92981,
                -0x1f054f6a, 0x1336e00d,  0x06c8d108,  -0x792c47c5,
                -0x3aa8fce1, 0x571943c1,  -0x3a04cfdc, 0x70d9852a,
                -0x2a504bb2, -0x6bab1ae8, 0x52df682a,  0x7645a921,
                0x21d00f11,  0x2288afe8,  0x3608772c,  -0x5dda74e7,
                0x26a729b3,  0x62a08b04,  -0x48b9799b, 0x764ff513,
                -0x5c0d65a9, -0x79476e8c, -0x38f32713, -0x5aa0a813,
                0x53c26d99,  0x01b24f7c,  -0x6e562527, -0x28dbdacf,
                -0x0af1abe6,
            });

            try testArgs(@Vector(1, u32), .{
                0x417af061,
            });
            try testArgs(@Vector(2, u32), .{
                0x67d25405, 0x24530653,
            });
            try testArgs(@Vector(3, u32), .{
                0xea5a8586, 0xa486d5c7, 0x441951fa,
            });
            try testArgs(@Vector(4, u32), .{
                0x1330c66d, 0x190e4b87, 0xc40a763c, 0x1e04942a,
            });
            try testArgs(@Vector(5, u32), .{
                0xf2417484, 0x4628508b, 0xe5ce63a1, 0xedff9058,
                0x67e5a112,
            });
            try testArgs(@Vector(7, u32), .{
                0x294d002e, 0xb11b9a83, 0xd41dbc28, 0x956abbab,
                0x27aa5a4d, 0x236634c4, 0xfcb579e8,
            });
            try testArgs(@Vector(8, u32), .{
                0xdaaaf612, 0x3e5ba097, 0xaab27d52, 0xc4057607,
                0xc2377f4c, 0xaed82c05, 0x681c6c6e, 0xd33108ab,
            });
            try testArgs(@Vector(9, u32), .{
                0xb286c075, 0x95e2365c, 0x7db24272, 0x4d87734d,
                0x74b07a88, 0xc7f664a7, 0x94b83937, 0x61edd88b,
                0xddc2ce66,
            });
            try testArgs(@Vector(15, u32), .{
                0x37c1fd6a, 0x72b89c34, 0x9835fc75, 0x232fed02,
                0x33cc380a, 0xf8bc2d4f, 0x91944e7a, 0x70825173,
                0x78662e47, 0x9c6f9d5e, 0xb60e6b29, 0xabf644ab,
                0x43f862a8, 0xffab8ea1, 0xf66309e0,
            });
            try testArgs(@Vector(16, u32), .{
                0xdaa0372e, 0xfc2bd33b, 0xdc12c2ec, 0xc0965f29,
                0xbe7f49dc, 0xf16d3f9e, 0x0afbef72, 0x57683019,
                0xd4daf23a, 0x8008f39c, 0xf50ba3e1, 0x5112baa2,
                0x28b6f532, 0xd0c76d49, 0x245fa32e, 0xdfdad69f,
            });
            try testArgs(@Vector(17, u32), .{
                0xf2c0946e, 0xec9a560f, 0x828cbfe0, 0x59e22a95,
                0x3e3d7663, 0x16cee3ce, 0xad45d67b, 0x164c7ce7,
                0xf08aa758, 0xc43048e4, 0xbef1aaf1, 0xa933e19a,
                0x501a3c3b, 0x664e1fc0, 0xea91d637, 0xcba5ff92,
                0x494e8b1d,
            });
            try testArgs(@Vector(31, u32), .{
                0x5a667dbb, 0x2a1aa819, 0xac4b64b2, 0xfa76177d,
                0x900d48f0, 0xe53bd516, 0xea3dcaeb, 0xb1fe1e32,
                0x717ac9bf, 0x5c27b4b2, 0x6cb0c361, 0x90110ef8,
                0x63d63e78, 0x9bd0bdb4, 0x72e55414, 0x517ce90e,
                0x565443d0, 0x37c93db9, 0x193f0667, 0x2a4ecad8,
                0x13e08477, 0x2e0d69fd, 0x104dd13a, 0xbec0f4f1,
                0x728a93b4, 0x3253cd55, 0x99fa6707, 0x69b406c1,
                0x27ff507a, 0x15167dee, 0xb2615448,
            });
            try testArgs(@Vector(32, u32), .{
                0xeb065322, 0x3946a581, 0x81c97d07, 0x565e01bb,
                0x14949bc8, 0xfddfd79e, 0x349bae23, 0x6d797548,
                0xef62d1a6, 0x44192db6, 0x5fcb4512, 0x74a5f104,
                0xda03c6e3, 0xbbbedf47, 0x709794a3, 0x77942d36,
                0x66a49d4d, 0x0a83e3a5, 0xd3b40484, 0x278ad9de,
                0x8f382688, 0x9da30151, 0x1c067c60, 0x94145f5c,
                0x45ff36bc, 0xaeef3443, 0x3597cd33, 0x41f8008b,
                0xf7c801fa, 0xd3048ea5, 0xbb2c2bbb, 0x84693546,
            });
            try testArgs(@Vector(33, u32), .{
                0x46f29173, 0xd69fe90c, 0xd7b827e3, 0xb02aa49a,
                0x398d3cc7, 0x85d7ff46, 0x9a471601, 0x490652a2,
                0xc60d1927, 0x4baf48d1, 0x59272b71, 0x78567058,
                0xa9cd7ac3, 0x50fa223c, 0xf9b2caf4, 0xa1b5d026,
                0x2083ddb0, 0x5f8b1aac, 0x34b6528a, 0xfe1e2d7c,
                0xf93418cb, 0xc873e475, 0xf031b8fa, 0xe5ebe15c,
                0x086875a9, 0xf2a6e152, 0xa07bbe62, 0xaace4a7c,
                0xc7a88fc2, 0x5ffd5bfd, 0x646bb619, 0xa6425229,
                0xe203858f,
            });

            try testArgs(@Vector(1, i33), .{
                -0x06cb7eb3c,
            });
            try testArgs(@Vector(2, i33), .{
                -0x08e99ce23, -0x04f4fc81d,
            });
            try testArgs(@Vector(3, i33), .{
                0x04dca5870,  -0x057649287,
                -0x0629b7859,
            });
            try testArgs(@Vector(4, i33), .{
                -0x03ac9fa2d, -0x056448c8c,
                -0x06327f240, 0x057caa00d,
            });
            try testArgs(@Vector(5, i33), .{
                -0x0eda7ca37, 0x00c150a49,
                0x0961b87fb,  -0x0efac7b65,
                -0x0abf89ecc,
            });
            try testArgs(@Vector(7, i33), .{
                0x0174d5a59,  -0x09103671b,
                -0x0920ebe1b, -0x05f76f77b,
                0x02f912948,  -0x036177518,
                0x0d8c9d0c9,
            });
            try testArgs(@Vector(8, i33), .{
                0x01609ce6e,  -0x02816dc90,
                -0x08be4b46a, 0x032e9d1c6,
                0x070c248ab,  0x02700eade,
                -0x0d5b561fe, -0x0c5ecfe6b,
            });
            try testArgs(@Vector(9, i33), .{
                0x0ff839829,  0x0a7311ec7,
                -0x0875b2074, 0x04b868bf9,
                0x05c7baa1a,  -0x096406153,
                0x08858ca39,  0x0e3b478b0,
                -0x02456564b,
            });
            try testArgs(@Vector(15, i33), .{
                0x0358b5e15,  -0x02489976c,
                0x0e710e92f,  0x0cb044409,
                0x0bf246fce,  -0x081e28596,
                0x0b6040038,  -0x043f0f0ea,
                0x0e4ba67c8,  -0x0c22ed81d,
                0x0f23c0c0e,  0x06540b535,
                -0x067b1d030, 0x09f71bb39,
                0x0c23fa3b0,
            });
            try testArgs(@Vector(16, i33), .{
                -0x0142ab9ee, 0x0459423ea,
                0x0de356963,  -0x0332d4d5e,
                -0x0e3352b48, 0x0d0f05ada,
                0x06684b9de,  0x0f1e76fa6,
                -0x0d9f75c96, 0x07e244fb3,
                0x08b8cab5a,  0x0debabd35,
                0x0f5434271,  -0x01bc41173,
                0x0a27988f5,  0x0fb4e5cf0,
            });
            try testArgs(@Vector(17, i33), .{
                -0x076e0997e, -0x074090dcb,
                -0x05a6ec729, -0x0a5a88f89,
                -0x020066f29, 0x08cb7a55c,
                -0x092eb4cf8, 0x06ff474ce,
                0x023df42a8,  0x0dd1a69fe,
                0x0b9150082,  -0x0162fde21,
                0x024df7571,  0x0bb74d943,
                -0x05de07f92, -0x09f02a5e2,
                0x09416d842,
            });

            try testArgs(@Vector(1, u33), .{
                0x0ebec10d6,
            });
            try testArgs(@Vector(2, u33), .{
                0x1f42bc395, 0x1eb083140,
            });
            try testArgs(@Vector(3, u33), .{
                0x0727b446a, 0x1ac44a4b3,
                0x0b0730c42,
            });
            try testArgs(@Vector(4, u33), .{
                0x1d821cff0, 0x011b28b87,
                0x0739856cb, 0x19ed6a1fa,
            });
            try testArgs(@Vector(5, u33), .{
                0x0b2314516, 0x19c0de98e,
                0x00eb7fc2e, 0x1987258e6,
                0x003e3280e,
            });
            try testArgs(@Vector(7, u33), .{
                0x156b9af69, 0x16623874a,
                0x198771fa2, 0x1891367f0,
                0x1158cfd5a, 0x1c6a51cab,
                0x084f757b5,
            });
            try testArgs(@Vector(8, u33), .{
                0x1be002f1d, 0x0dd42ad31,
                0x04ba63298, 0x1534bd4a1,
                0x0a72dfea0, 0x0eae2b4bf,
                0x1bf962681, 0x0e57f3613,
            });
            try testArgs(@Vector(9, u33), .{
                0x11f21a47d, 0x0a8fef8a1,
                0x0009fb473, 0x06e94c939,
                0x0a9c9c22e, 0x0bfb8f89e,
                0x17ade9bf2, 0x11e4bc9e0,
                0x15968c696,
            });
            try testArgs(@Vector(15, u33), .{
                0x02af9eb53, 0x19ac3812b,
                0x1632dbb21, 0x023d5a196,
                0x1e154b359, 0x0b371fa45,
                0x0e565a06f, 0x1965c7126,
                0x018bf92f3, 0x14b48f26e,
                0x10c954288, 0x08c945996,
                0x0216073fd, 0x15fa9132e,
                0x0b6a428db,
            });
            try testArgs(@Vector(16, u33), .{
                0x0a6a69363, 0x19ea477ba,
                0x0493ff35e, 0x1fece1b1d,
                0x063eb6012, 0x103c65796,
                0x0e98ca7fd, 0x04b972c94,
                0x1b0dce10e, 0x088b67474,
                0x181322bd9, 0x1f78856bb,
                0x0f2f70b1b, 0x15ac608f8,
                0x08c9817f4, 0x00bc52fa0,
            });
            try testArgs(@Vector(17, u33), .{
                0x17d631441, 0x17e9ee0b7,
                0x08ef8565f, 0x103428ae3,
                0x03b039a4b, 0x00e90f659,
                0x1c66d2e73, 0x07347d531,
                0x1a03c6ad9, 0x0e6cedf41,
                0x0b30405ab, 0x0d2520be7,
                0x03f97d747, 0x1af71f3e1,
                0x01bf05ceb, 0x100526d23,
                0x0941ec325,
            });

            try testArgs(@Vector(1, i63), .{
                0x3751c894e8fbe69b,
            });
            try testArgs(@Vector(2, i63), .{
                0x02659637000f4849, -0x1c21ef23a4708c02,
            });
            try testArgs(@Vector(3, i63), .{
                -0x3bd1aa5cccdac018, -0x1a70b3d17b0a767e,
                -0x3e6cf9c01feced83,
            });
            try testArgs(@Vector(4, i63), .{
                -0x21cf08dffb8c4261, -0x02952228a9555748,
                -0x0d28be6a86a51bbd, -0x048efe42b6a083e6,
            });
            try testArgs(@Vector(5, i63), .{
                0x191b8bf9c3cb1974,  0x173fcea0524d0dbe,
                -0x1d8fb8b6f758c797, -0x3837eb2a2bda5c45,
                0x31ad632bd048b341,
            });
            try testArgs(@Vector(7, i63), .{
                -0x2d8b6c97799235ea, 0x26d281f112edb009,
                0x300456663162abb3,  0x01530ea40f5a18c5,
                -0x12da0488be671be3, 0x0ec6f12b30534b7f,
                -0x216deec3e431f0bf,
            });
            try testArgs(@Vector(8, i63), .{
                0x245bf28fd8b546ba,  -0x2956bf6106b5d362,
                -0x319ab740f51b4154, -0x0e2e242a7881fac6,
                0x3bfcc5138251883a,  -0x1149a93f2eb40973,
                0x388be2cc2f89ad62,  0x28e30c5c7552f64a,
            });
            try testArgs(@Vector(9, i63), .{
                0x01944c5c05ed619c,  -0x01e49493b7503176,
                0x0629c5be94d83864,  -0x0c07c0a839450459,
                0x1a0382b2beff495a,  -0x2fd440b33af6eefb,
                0x00c526ddfbcaacda,  0x326e139a32198f4d,
                -0x11b5067f11748882,
            });
            try testArgs(@Vector(15, i63), .{
                -0x22eaa5b856307e6b, 0x06b7518dad66dd8d,
                -0x1c666681c4ca06f1, -0x34febd64e274f4f3,
                0x1305d4b063fbb18c,  -0x1df2eaa1ebb176b4,
                0x19dd5ae15bb8f765,  -0x066c6c1d31def660,
                -0x1bf661e9d29b449c, -0x3eaedd122226c2de,
                -0x0fb1ba685fdb2b68, -0x32fd1e57bb04eb26,
                0x3fd66e9f96aa8df0,  -0x3fbe307aa6523b61,
                0x1df0e564a0a8e2d7,
            });
            try testArgs(@Vector(16, i63), .{
                0x061767e9366a32ac,  -0x1c7542a68d5750aa,
                -0x174386205ba10e99, 0x1f7ae720e2b8513c,
                -0x286d271f72914c1b, 0x0ba2ccdcdae61287,
                -0x294d3c0c5c99c1ad, -0x094390e09b71d711,
                0x1ff69b4e11e4577d,  0x38376ee4fd90d9c7,
                -0x1fed65c3a90bb2ff, -0x0158ed8a5643f0f2,
                0x101e5ce53748f42f,  0x0a29f1e053325ddb,
                0x3b5826ebb9380e0f,  -0x08593f40b8e95311,
            });
            try testArgs(@Vector(17, i63), .{
                0x267962dbbbc555e2,  0x3acabce21dcfa860,
                0x3b3bd612d8ac0fe6,  0x164fbaeb4b6ebf96,
                0x0b59a4caca202e9f,  -0x1005cf4dd7d841ea,
                0x04900ca2be0565a9,  -0x1c0749e904112370,
                0x02e4f2e360a13b6c,  0x16baa5d7696d83ec,
                0x0c2616a3d3dec6a7,  0x041bea2fa7bac749,
                -0x2ecc7a999b3da500, -0x0def15b53d6a7490,
                -0x2c8d96e583a7dc12, -0x2f75e205478cbd3d,
                -0x2746871924743046,
            });

            try testArgs(@Vector(1, u63), .{
                0x2177701462817ae8,
            });
            try testArgs(@Vector(2, u63), .{
                0x4d8aefa47c681718, 0x3c8bc100dc62a229,
            });
            try testArgs(@Vector(3, u63), .{
                0x51efe053a56e54cc, 0x4813340907e62f02,
                0x6cf745dfcfc5a0f8,
            });
            try testArgs(@Vector(4, u63), .{
                0x64b75da9ac93ca30, 0x163e34f890f56173,
                0x0a04ca663e580162, 0x14693b19720c5b04,
            });
            try testArgs(@Vector(5, u63), .{
                0x06bc896f283c63d7, 0x010d4ad73df2c443,
                0x3322a2732c5175a0, 0x1021e5e040a6c335,
                0x45afd197802c1448,
            });
            try testArgs(@Vector(7, u63), .{
                0x2efe752b1ee67744, 0x78c4c63665a5b5d2,
                0x1f0bfdabc6ef4bf1, 0x2be2324013eaff8a,
                0x5439d73093cd89d5, 0x61254b8532f1f7bd,
                0x6f3523b66691dba5,
            });
            try testArgs(@Vector(8, u63), .{
                0x7221f7d6f82ce4da, 0x591e824f45c20f9d,
                0x4e5f3d829a9090a1, 0x4b46fe4492b60c10,
                0x792e48d707425d79, 0x12454f364b8a3642,
                0x02cd18a19104066a, 0x099e27552e33ea05,
            });
            try testArgs(@Vector(9, u63), .{
                0x22f0f07ebf34daab, 0x0e52ab968e844242,
                0x1d5979b9177b31d9, 0x59b2d70b05eaca66,
                0x7eb234b48319fe7a, 0x2ef2c5db4b85978d,
                0x43f1d01e26f2c33f, 0x4eb09118689a5aba,
                0x43f205474675dd47,
            });
            try testArgs(@Vector(15, u63), .{
                0x14fa00be6ffab27e, 0x369543c3445d91aa,
                0x11754739f827f2e7, 0x3ff0ac34ed39c6ec,
                0x726b45a4e174a68c, 0x09c2a9b2197f0ade,
                0x22edec3dd9ae3783, 0x0611bd9d50406ae7,
                0x63b9ade47da2ba37, 0x04bd2c7a867bcba2,
                0x0d68a5438ae1d495, 0x70da32c6373f1036,
                0x5b85033485c5fe55, 0x43e6169b503ca8de,
                0x40cde07fe0470dc6,
            });
            try testArgs(@Vector(16, u63), .{
                0x1c635b835478a911, 0x0995b39ff44566a4,
                0x0cc867c3c17916ab, 0x10ed098c1ba3c91c,
                0x551afb772998e956, 0x4494d2d8453467de,
                0x48ae36cf8787812e, 0x163ec6db793793c2,
                0x1096a8cc35ad1ce1, 0x4029214025020ed9,
                0x4b322be7dd63b2da, 0x08c9e6ae8356922a,
                0x06efd2d7fa64419c, 0x5299f1bd4ef1d8af,
                0x4685daa8a2a8d7dc, 0x500d31c70e37dfac,
            });
            try testArgs(@Vector(17, u63), .{
                0x0c9e8888be3a1d7a, 0x3eb6dba412d9e9f8,
                0x4a36342aa344f7ba, 0x6c8baf91ed4085ef,
                0x343c5eeb15de875b, 0x001082f9c30cb0f0,
                0x3875a1104b976588, 0x737ad1482363b5b0,
                0x47e6be33674ea76f, 0x4d4fad5f4d31c8e6,
                0x3bde471489363a93, 0x462f3ee217211130,
                0x5139c07adde61547, 0x34f5436cce96302e,
                0x47f433875f988720, 0x2d984bcfe65386b6,
                0x70fe9dd022a1ace7,
            });

            try testArgs(@Vector(1, i64), .{
                -0x4b7fb0b786be5c3a,
            });
            try testArgs(@Vector(2, i64), .{
                0x2137d770dcd7210d, 0x57f8f60e1ae33a48,
            });
            try testArgs(@Vector(3, i64), .{
                0x01f4d5911e62a232, -0x6f02ad23979236ad,
                0x78b48dc1d900fc75,
            });
            try testArgs(@Vector(4, i64), .{
                -0x7127d14674e525fd, 0x6305c7259a0349c1,
                0x7692ac00c0ec1cfa,  0x59ea1f91b10d5365,
            });
            try testArgs(@Vector(5, i64), .{
                0x11a559214771da81,  -0x09bfa4f3e16f9ac7,
                -0x0c6a6d70a5812ecd, 0x3a8731e64f568239,
                0x1911ef10b4fba5bc,
            });
            try testArgs(@Vector(7, i64), .{
                0x7afc6a3fda5693f6,  0x3810984cc9a442cf,
                -0x57dc022511143fee, 0x1c3104cde6237c23,
                -0x547d7db283a6bec4, 0x1c5abae6f7f692eb,
                -0x2d1de6d188652687,
            });
            try testArgs(@Vector(8, i64), .{
                -0x77388284294cc650, 0x4eaacacd5f19da71,
                -0x7a55c43d7f0c2e69, -0x181ffd0b2bba3542,
                -0x03c7eed19ea409f0, 0x02d7a2d738ec292c,
                -0x79518d662eb65d07, -0x0554d622b3d8bdc7,
            });
            try testArgs(@Vector(9, i64), .{
                0x089a5a66fa037603,  -0x0fad9e9572978fe2,
                -0x30e890e380bbbfe0, -0x029960ad7adec445,
                0x739971f03b533351,  -0x3d7a8714758eddc8,
                -0x0e438dca01a4c7f1, -0x498770017bf7829e,
                0x3f91d9063f19e5e9,
            });
            try testArgs(@Vector(15, i64), .{
                0x10e7e0bc67dd9007,  0x3f98419baf874724,
                0x5734cc0c224c897c,  0x309b977f13650658,
                0x69e4368beccb9363,  0x5f59916d2153f2c8,
                -0x68baea76bc430b80, 0x64df0fc97c44e6db,
                -0x6f653ae097106799, 0x047ea3393d8ea124,
                -0x12b554d34241c116, -0x4b129c9655dd20e8,
                0x5e1c137e8cf8c657,  -0x4de73be2ed085459,
                -0x4db87055403fae80,
            });
            try testArgs(@Vector(16, i64), .{
                0x4a200de54cf8a7d2,  0x7aa8a43d6ce85e1d,
                0x635c52f9d27dc223,  -0x4f8273cfef9532a5,
                0x28e0934381355f7d,  -0x1f4c5936fdc08f03,
                -0x1e48c06274cedf3b, -0x437a90f8ae575a54,
                -0x47a1285dc3053bfb, -0x2b9f621c5282cf9c,
                -0x3afbbad2d44d3b2c, 0x093993c1a3e2446c,
                -0x06e64b37f5cbf493, 0x7ef6fa9fdbf10a56,
                0x584892e663ff7964,  -0x39cec290300b6b26,
            });
            try testArgs(@Vector(17, i64), .{
                0x5d63f7f3ea59a706,  0x66479c3ea87e877d,
                0x60bbb83aa7074fef,  0x18af9352281786b6,
                -0x6585bf8d88ec68b0, 0x4061a05c9d172919,
                0x5416c7dbe6504682,  0x7099f1f3b043d901,
                0x74d29539167d4ebe,  -0x7c0d98061999fa98,
                0x650f42990507957f,  0x67a6137616636aa2,
                -0x79aab7fb99bca92b, -0x780079d7c8e19ca0,
                0x0cd27dfe2c7521a6,  0x765e9335c8148fa2,
                0x784d1133125c6938,
            });

            try testArgs(@Vector(1, u64), .{
                0x355b7529a18f6e0a,
            });
            try testArgs(@Vector(2, u64), .{
                0x93377f019ceeb5f9, 0x990ccc5803cebd4b,
            });
            try testArgs(@Vector(3, u64), .{
                0xdcf28cd5bc1bcd54, 0x3770fa01b4bc08f9,
                0x5feeab26a2e0c753,
            });
            try testArgs(@Vector(4, u64), .{
                0xfb61199844333d29, 0xfac4e5a64b92413c,
                0x9d6d13d41ef64ba0, 0x632935cc93fd1804,
            });
            try testArgs(@Vector(5, u64), .{
                0x48f503b75b7c871d, 0x0bf3302c1c7311a9,
                0xa7c84e61899d845f, 0x26c4a4d696c3a12f,
                0x10fe1869c95ddde5,
            });
            try testArgs(@Vector(7, u64), .{
                0xa882300f7b3feb0c, 0x3d006e16890ec7e6,
                0x807a2a2da9c68810, 0x3574c34f46fadbb9,
                0xfd1ff4b713ff7e75, 0xe7741a11125e5734,
                0xa219656fc3e08bc9,
            });
            try testArgs(@Vector(8, u64), .{
                0x794ce49dc61ffe02, 0x26ded6f4ca236f77,
                0x2bb852a1a181e016, 0x9218a461b622abf3,
                0x250471ad116f28ab, 0x732280396a95f70f,
                0x913532dcdb1abe1a, 0x8b550b165f6f3c0d,
            });
            try testArgs(@Vector(9, u64), .{
                0xe0e3bc1116099b0c, 0x0a5dd53ba26770d2,
                0x43995c799f295c76, 0x4c169b362ce40ac2,
                0xb50ad4961a4c1508, 0xc46d51f361ed7b6a,
                0x2d7432e560138aae, 0x88e8d2b4338bfa38,
                0xac1cf0c39508b21a,
            });
            try testArgs(@Vector(15, u64), .{
                0xf3da70a7e248f183, 0x85386f2f82fa4906,
                0x8ccc8c1328dc408c, 0x563a8a2d52bd286d,
                0x87501c5a211a884f, 0xf740939299cc59fc,
                0x00c656fb3cf431f2, 0xbd74f9747be208d6,
                0x45013667a3ba98cc, 0x2954ea4409a605a3,
                0xf9bb98de17f87873, 0x94770fedfd97b1e6,
                0xfa90322d59fdb4bb, 0x7242fb5f83e8c199,
                0x2340d307e4438482,
            });
            try testArgs(@Vector(16, u64), .{
                0xd09341c824a83e25, 0x8a30caf3359f3d58,
                0x46cbadcd68afd397, 0x9f5f3e7ef79d9255,
                0xa247f41fd962e4ae, 0x8437c02fa08497e8,
                0xc375990c3cd82fe9, 0x5168826a7224f73f,
                0xc99ca45a2b746bb4, 0x42b849004159ce02,
                0x007c450769410f61, 0x8f2f91cf22e178fa,
                0x86ee7d1ff41c0f89, 0x079e9ec26a77aa45,
                0x3d2ffdbecf9660b0, 0xbb9ee5348ef39666,
            });
            try testArgs(@Vector(17, u64), .{
                0xcc4ba58941a112da, 0xfbbb48cbf9da0088,
                0xd558a4110617b6a2, 0xfe39ed646f5519db,
                0x56f3fbd81853b1e0, 0xd895d679446390d4,
                0x6eba9cc3f0d682d7, 0x248cbedaa78b144f,
                0x6be12ab5dce9a518, 0x7c30ffeefd1a097b,
                0x8ff88cf1643c385b, 0x6f6e9f5191889057,
                0xc4b4beeb8b531de0, 0x0189188d979da467,
                0xab22fceefbdd33d6, 0x1616bbf79271a0f3,
                0x52075d69a6cf3450,
            });

            try testArgs(@Vector(1, i65), .{
                -0x04a1a4da1d9da76bf,
            });
            try testArgs(@Vector(2, i65), .{
                0x03c475f6c2f0951e5,
                0x0704f02479fb01242,
            });
            try testArgs(@Vector(3, i65), .{
                0x0138ba6e706a5ca65,
                -0x06c79c32b5080c6f7,
                -0x052327b60748ab35f,
            });
            try testArgs(@Vector(4, i65), .{
                -0x0815fe21ee3c89d70,
                -0x07100c511bbecfc96,
                0x04c3d645430697de9,
                -0x04d3fe6078180a7de,
            });
            try testArgs(@Vector(5, i65), .{
                -0x0c18f313629a95a15,
                -0x0ff2287b0afcce461,
                0x0f244ae6e9a14a1fe,
                -0x04eb5f56df21aeef8,
                0x0c84f100c53ecb805,
            });
            try testArgs(@Vector(7, i65), .{
                0x08242f0645e164a6b,
                0x0bae1b6147f56fd3b,
                -0x00043aa964b5c8834,
                0x0e44433985af34829,
                -0x01e7806be748ac6e9,
                -0x0e539dbff9fc2ed67,
                -0x087db7cf263c37dd9,
            });
            try testArgs(@Vector(8, i65), .{
                0x0fc8f809919517224,
                -0x0a09049fd34fe9525,
                -0x082c50cffe1f00ce6,
                0x0a58b97a6a016097f,
                -0x0605ab965554e1f64,
                0x01786432da6221baf,
                0x0cf8d7ffa9bd1a9d1,
                0x06a5e63bd10028fd3,
            });
            try testArgs(@Vector(9, i65), .{
                -0x064688784ee533a87,
                -0x0e36f7c74d13cb8af,
                -0x00fbf8cdce6c2ad1f,
                0x083a32da05be62d94,
                0x0e8518099bbc20330,
                -0x0bdc61a1ab64481f9,
                -0x0dcd7b2ac1bbb4f0c,
                0x0a085abafc8c3f27b,
                0x00fbf0b4bd400496e,
            });

            try testArgs(@Vector(1, u65), .{
                0x0e0e8009c8e1ec0b5,
            });
            try testArgs(@Vector(2, u65), .{
                0x1c117d8ad564625d7,
                0x0c3747a5467b37ee5,
            });
            try testArgs(@Vector(3, u65), .{
                0x12b461e9764b53748,
                0x003a204e80672e085,
                0x014fe8f2e3ec390f2,
            });
            try testArgs(@Vector(4, u65), .{
                0x000e3560e820cbc54,
                0x05fb40efe3f1ea8f8,
                0x12037f424845e037c,
                0x193cc5a0da63d3df1,
            });
            try testArgs(@Vector(5, u65), .{
                0x0590bf116c607ce3e,
                0x19a477b6e89225818,
                0x0cf6987fe2b219e38,
                0x19f9962c1f211ae36,
                0x147ee711783a46478,
            });
            try testArgs(@Vector(7, u65), .{
                0x14cac53222c7edefd,
                0x1ca73b489f6a2837c,
                0x0174a046c14a44609,
                0x16ad206733a8d5306,
                0x082b7307498cdb16c,
                0x103fe2c5bccab3ac9,
                0x1980a02379a8ea497,
            });
            try testArgs(@Vector(8, u65), .{
                0x0bb30b196c3ee122c,
                0x131a3e0b3aa6d2271,
                0x1c350e1290fe9f771,
                0x0258f532f8e77bcfd,
                0x0de19ad96c7ab9b22,
                0x0af82d4983087e3c5,
                0x04359e9aec8013c5f,
                0x05ef28227ff853f26,
            });
            try testArgs(@Vector(9, u65), .{
                0x1a50f55a41b5bbbb7,
                0x1594b5f154f6b9e75,
                0x1ce13b94426f2edfa,
                0x165ee33c5d7805448,
                0x1337ab026ed906b22,
                0x1b6d719acce8941ba,
                0x0a2e49415413db37a,
                0x162394487c383a1f3,
                0x1c7c0ab4d0d5aff59,
            });

            try testArgs(@Vector(1, i127), .{
                -0x1269fabc2d3ef2a76ffe049437be10dd,
            });
            try testArgs(@Vector(2, i127), .{
                -0x1ea96c9f0850491ef73e8c3d34cfd7d9,
                0x39e6865468b439fa018c83f91e5e105a,
            });
            try testArgs(@Vector(3, i127), .{
                -0x0db4b1d90b444db2a143ded070f85b1e,
                -0x01b3f62ea0ea5d91e76ed09e4a18956a,
                -0x33d5c74e99e40e151f32815402d90a9f,
            });
            try testArgs(@Vector(4, i127), .{
                -0x2ef61a8bfff8747de1ed931e98feac6e,
                -0x04ce48788f7f8ae9a4403add50551fa4,
                0x16beaff854c2ef6837d7ee0b623ea0a2,
                -0x2e4803db1cea5884f8c7e1d1c0fb2870,
            });
            try testArgs(@Vector(5, i127), .{
                -0x3c906f554a2ffe1fe72322b58ea5540f,
                0x3075e0a554755389e92bc63618b70034,
                0x3bb4ebf828754a38051d2f13dd0bf959,
                -0x09dc745d7419586dfd7bf71386027d45,
                0x3b142d80ddac6aaa50e61c797d2d931d,
            });
            try testArgs(@Vector(7, i127), .{
                0x1a801572a9f38591e6ec3a23628c4bf0,
                -0x129714e4602059eccfecbfca90ca0a49,
                -0x0f92f4230c9256fcb8dba6b68744a52b,
                -0x0b146fca739b47d0a85bcdbc33c4b16a,
                -0x3f6f76d3757db60d9d39200af6b3489c,
                -0x02e080402f7ec59fa07192fc395a57d1,
                -0x2b4fdb5e3b7bf0f312d82b1c93603580,
            });
            try testArgs(@Vector(8, i127), .{
                -0x2211dd783e1ad24c3d5af011f68354b4,
                0x3f005440e5b5c058cdfa285a7880da62,
                0x3b30ad071407b244f241aceae163a42d,
                -0x23c4fc0e1bf6dfbd3388b644c763d1ca,
                0x1186ab95a8b6d3c4e55703615a460fa7,
                0x32585f76772b93a3e9afd7e8940be7f6,
                -0x2f9f404af316876929a92939993a1681,
                -0x0590af0c94d4cfea1cf610aab419adf9,
            });
            try testArgs(@Vector(9, i127), .{
                0x08add0b42220fd2a71f04fe45f14dd2f,
                0x251bf6cce8f1d4003e92eb52f2501c74,
                -0x17e27992906723b7cd7e831928b02c97,
                -0x3d2d8f1d98bf76b2429e2a2a208a6055,
                0x2a2f48a325b72b72c4392a131c41ffc5,
                -0x0c590b2e084ac595d76a19c894e68859,
                0x30ec3b18bbcb33c301cb24a46b3be921,
                0x1cc175f62cdc953f5eb16a0a8913093b,
                -0x0fc33d8630d2e2ae5a75c4beaf7bd2f4,
            });

            try testArgs(@Vector(1, u127), .{
                0x7462f202109a0e999de7ab35e87e0325,
            });
            try testArgs(@Vector(2, u127), .{
                0x6f19d7c613d714caab882675ecce9a53,
                0x6aa8cab6046949bdeb0edc41c0d42186,
            });
            try testArgs(@Vector(3, u127), .{
                0x5b97d59261ac4dd16f957a0291754717,
                0x3e38b6db3f9734f625a892b08e86e214,
                0x247d026b349f5a9fd940120c80ad8b52,
            });
            try testArgs(@Vector(4, u127), .{
                0x3717b59f6196b1eea95558d55bd6b96a,
                0x1868e935eb0494b7b9b548f049129a47,
                0x5fc089af4203a0efab982138893f279c,
                0x1b869da17109a01ce820f002a65c26a4,
            });
            try testArgs(@Vector(5, u127), .{
                0x0d89c344326d130d22b8dd899707aa38,
                0x5af65ed48bc78475d2ae1d56017daea7,
                0x2b67eb9fec417d211336c46fad38aba1,
                0x072712b1bf92c551f6d3e1cf71953224,
                0x66ed8a0aa3a31a6ed45c24807f0ac25a,
            });
            try testArgs(@Vector(7, u127), .{
                0x133d50c8794c33f96b432a9e84182bbe,
                0x43bec0f35bea1a9b6a706f39d4e5c563,
                0x3af628ccbc1973aee83a136f73f2f09f,
                0x7f80cc2c0b23cb51c10da6f65c95ac0b,
                0x08b8e883ac49809c919126bf716ea90d,
                0x30285cc5ba8ffecb816c344eea07b1d8,
                0x6befbab2ff599032ed04cc1e002d8c34,
            });
            try testArgs(@Vector(8, u127), .{
                0x6c92a56152df1d0bc4003108d2c035e5,
                0x1012581d4b7de3403694621515c85ccc,
                0x1ca797428f6e4ee601cad585b6c5d098,
                0x1b762e4e4606637ad02de1494b2da26a,
                0x1dfe3129064ab88a66967141a3109fbc,
                0x35a3c0f38ffb5b3701ac383b9499a665,
                0x38d199f20d34841d7350a02d83c7e4a7,
                0x6a87705d91b3325b7edcb4ed3f9eed30,
            });
            try testArgs(@Vector(9, u127), .{
                0x18a96634c100beb14a9f7255f577244c,
                0x21d39a8a3e9af9f883cdc413a4b29f21,
                0x5f7e1f12a47d2530ef0bbe01e836e290,
                0x244fdb35a6e32c5ab8f8a2ce536b2111,
                0x0829eda9af0f9e1b9301de171cae5d79,
                0x4a4485619560dca50f7e9ea47e5c4879,
                0x70c3f24bdb370119e60db26ff7c8dde0,
                0x4dc4da0a82f10073fff7f4c79216dd14,
                0x314a855e0ee8f5401006af852258adfc,
            });

            try testArgs(@Vector(1, i128), .{
                0x743d7edc2f7bae65332567ccb7e17140,
            });
            try testArgs(@Vector(2, i128), .{
                0x29cba1f54ca060061ce2a082f24d3cff,
                0x67fe5eecb0e54c0b6680c8723c91ee1f,
            });
            try testArgs(@Vector(3, i128), .{
                0x5d23fbff853640375e4fea765d45096a,
                0x0510c243956b80ca93838c661f4c4ce9,
                0x7bde7db0cc6a7aaedd636197705b85e2,
            });
            try testArgs(@Vector(4, i128), .{
                -0x744c77b7f40ccec86498d4e3ff92260b,
                -0x2c3f3f0b6a8cd17f73a082846a77dbb7,
                0x2af1c5e71f3764211e95b37db75008cf,
                -0x082a87b4571760fb876d47e2a13ee6a0,
            });
            try testArgs(@Vector(5, i128), .{
                -0x7a34a250a0d7e02875ea9b589a3f7009,
                -0x44ad60deaa4229c0584e61b71e66653c,
                0x48b53a60ba3c8961476b7e288b1f1aa8,
                0x25f896ea80a5d0f1c051b122ce9f40f3,
                -0x2e2b3c3855e8964e4115757517d1f62b,
            });
            try testArgs(@Vector(7, i128), .{
                -0x78e261d24f5803a086cdb650789236dc,
                -0x274c41a258e7bec4d5301316859f51fd,
                -0x7b53e0d4310a27b1236d267fc9c92bfe,
                0x13069a0197a87a6abfa57fd7cf0a0360,
                -0x2d7041962c6c6f5d3c344b760803f68b,
                -0x715518f77daef65d9cdd4bb3e4ad2b5a,
                -0x68e9587c2cee9840d54907b97430ef8e,
            });
            try testArgs(@Vector(8, i128), .{
                -0x7c4635f4573902107d7f9287beed86ad,
                -0x57a0f8b1fc10c247bc362724cb2638d1,
                0x47a5955f0fee284a2c14ce5f8efaf8f4,
                0x6b3b18486e73a0277abaca37235ae1c2,
                0x5694cacab37b6a83e9399d4d8bfb0d8c,
                -0x7ad35792e9e56fbfdf964c31f9dfe641,
                0x5729001f2b5ae188d92aa361d4d3bc6a,
                -0x738c6d97d020d94f56b367721cafff40,
            });
            try testArgs(@Vector(9, i128), .{
                0x03c8f6e9a23c18ee51f9e7588582fb4c,
                0x789d77f0d91035467aebaa094e43aaf3,
                0x2ce9790bf03fee2b9386f3458182b415,
                -0x516ab5386fd98498688a2a06b8038c6e,
                -0x36ad4507626b6e9b4ca1c846694d0f7e,
                0x18193adfda9ada0a449a9e6667350ed3,
                -0x0d88d1123261cdc0ff373bafa9c9bfdd,
                0x1f529ee80d509d8ae3f0dbf532c127b9,
                0x30629d533c1286d30ced4c219cf078ba,
            });

            try testArgs(@Vector(1, u128), .{
                0x5566c76797d4523a32920021e51621d5,
            });
            try testArgs(@Vector(2, u128), .{
                0x7e82f7f4dfef8f442243b3b3b355a96e,
                0xf967bd965d50a70c0d4000d9f7928b83,
            });
            try testArgs(@Vector(3, u128), .{
                0xd2c9228d99fc7a00a9331c6b81545e7c,
                0xdb03015497d36dd203b3349722706791,
                0xd3fe8ece75a5f18e8e34a257cc2c6c64,
            });
            try testArgs(@Vector(4, u128), .{
                0xa505ecca2d7b80d447475b9dd1f5e07c,
                0xc347f7b77a199786fabb8da91b40925a,
                0xbd2f98ea28ad941c21b342cdfbb4d297,
                0x2a91d184034d85bcf7bc2501ea07d73b,
            });
            try testArgs(@Vector(5, u128), .{
                0x8b4439cc68b09f984c3ccacee6ab94a8,
                0x78894d3a02536275951e9011483eb7d5,
                0x1a446bd15eab7cc896d1a9c299285957,
                0x1fd269e765c4a36996f1561e0bf50b31,
                0xe03c9a87b79c7fa082fc8f65aa50ebdd,
            });
            try testArgs(@Vector(7, u128), .{
                0x5008ab32979156a8acd32a7e32ef7f15,
                0x94aeced9de5b111f8003fec9b526f527,
                0x92fc060348f1ee6b482bd667aa43ba26,
                0xdaf4347b4b58ba2ded70a52cb5b5fbfa,
                0xf4e7a373762b18a2ce100f8a34e39444,
                0xe2186b935e0099ca342a61c1fb9a8091,
                0x4d661e1d2199985909534e9e2abb1c44,
            });
            try testArgs(@Vector(8, u128), .{
                0x7267d2c9d89152d441e28beac39fa0e5,
                0x92612c4fa59b5584bd5c68a6ef468616,
                0xb5c583d6b304b3843951ae367133504c,
                0xf1b17d139b8c683990dcbe42f2ffe671,
                0x71f721519c179ee00f737645f456b65f,
                0x8ab931bcf9d54fe8f998ea07f7ad8e55,
                0xd4b148cd313442ec6445e5c09a3de2ea,
                0x5698f95052ae8dffddf09bbc6216d38d,
            });
            try testArgs(@Vector(9, u128), .{
                0x4d322a5f0575a4b6efd05d6f67c6e7cb,
                0x6b22b0fd0300add6fc6583cca73324a6,
                0x73c79c8c3aba60a9d5b5f2afcc69da22,
                0x7d278f7642f544b91fb0967559738ec6,
                0xd39b8bd774220a07f81c1655a3ea4b04,
                0xf6e6b067fe824d7a88e7de3c9b528e58,
                0x369b7db29173bedd0b689ada1ccb3f53,
                0x85bfd20640039457bd071af527feb986,
                0x77cb6db8dcaaf7c679a3952bdf3b46ed,
            });

            try testArgs(@Vector(1, i129), .{
                -0x0f44902992dd90b6b2bdcd3dee26ed81b,
            });
            try testArgs(@Vector(2, i129), .{
                -0x0305d2bf464b50a05766933859bb32851,
                -0x0db8e49f48667923a7316b6b02c24956c,
            });
            try testArgs(@Vector(3, i129), .{
                -0x0ff7d15e1c921f6c09189f8c22a1eebe5,
                0x0c6b14a671cd4a0ea34b31dd3762f8e93,
                0x011c8b2dd5616cd38811691ed41e44a7f,
            });
            try testArgs(@Vector(4, i129), .{
                0x08083e8a84ee72ecb5ec61d6255fbdc6e,
                0x0d1d7ddb25c8e41bb05595cddd06f3c51,
                0x0b32b29ab5070e4c89a8e318c42b8307c,
                0x006bd80101e00f7247f4345e66af09850,
            });
            try testArgs(@Vector(5, i129), .{
                0x0eb5215d4f542021cd904624dc94b4d09,
                -0x0077f53ce5c2297e6b6eec1ed435b6edb,
                0x0fb0abfc2444105aee10adaefc8574bf6,
                -0x0634b1120f0ce9002980ee8ea7df397fb,
                -0x0b13ad1cbf50d89b70195e07eaf539cf8,
            });

            try testArgs(@Vector(1, u129), .{
                0x04bf162b7335a7ed6595ef439c3bca959,
            });
            try testArgs(@Vector(2, u129), .{
                0x11f0b8a2dd0106c219bb3178e05494541,
                0x12860bc7203d4df432a3cf65e162278d9,
            });
            try testArgs(@Vector(3, u129), .{
                0x0e7240ab63132cb5a050a3a37f0aae72f,
                0x1761ee40c60d0e3d8d10b9b085401766d,
                0x06ab93ee8933a9900386d6161cebbcde6,
            });
            try testArgs(@Vector(4, u129), .{
                0x14abbd1dabf3b66dc4834bb6ca71cd663,
                0x0cec8c3f6edf7f1c4041ba3e9290fc368,
                0x065f7a02e2c674f50bf17a027dd99b6d6,
                0x14fea575487ebbbb907d4ea477bb41f51,
            });
            try testArgs(@Vector(5, u129), .{
                0x0c7364e53c0e3d1b7adc4302471e944ce,
                0x01b877b126e0cac7eac0d8f1f21c186aa,
                0x0fb4e479178be9a9363dee23c7c772e8b,
                0x0a79c2021801327e5685c8f69afc82c80,
                0x0bb084ee07f1f1b0eae7b632b21effb99,
            });

            try testArgs(@Vector(1, i255), .{
                0x08ffa1eb6ae037d6fcdc279d548082bfc27c77e30c265e04ff55e4d60fa1a886,
            });
            try testArgs(@Vector(2, i255), .{
                -0x08f3626e9f1b561d3364559676fffe16e809176ec624c1687f318bad67ab2b12,
                0x3328c8b59d09073fcb7e54d5632b565322ee296d727dbf93b7863b13a7256f8d,
            });
            try testArgs(@Vector(3, i255), .{
                0x05bd12ab3e8171b1dafc5716ef851a77830f619c1fc233e3175a6e6ebf8237f2,
                -0x0c5142c3de521d31e3284000a30fab14cb4c70d447eebfc78e7b7f422a5f2258,
                0x3b0e22e5807d7e4704b5db2800cd15ac964c3d9b12a13e6b614620f3507feb7f,
            });
            try testArgs(@Vector(4, i255), .{
                -0x14fb179f14c52dad21b622efe2fcae82f1bf1fce4b49bccdd918b2600168eb19,
                0x1432a7fd08acfe8165207e4c96bad7b422f79a492e00412e505d1179187007b5,
                0x347734d964e8bc5e6e737fe8486998cccd7a67fca36ea2be9816c5014e9ae93e,
                0x1630ffda865d3e2b7c204ecb7534c04397c6c5afc1df36a0febc9cb028629ae2,
            });
            try testArgs(@Vector(5, i255), .{
                -0x0a867735be9212a216e5a0ce6d77f8d787b7f340b0c091ad95939d21b5c02e12,
                0x1005df8d3c60aa085ad3302a9d02269cf3505a4ab3ce0b3cbac8328edfcd006c,
                0x0261f5d27bd0d6bce9bfc3624eb11dd699a227171729e3f81020014dd12cdcda,
                0x203a7c3e34b012a40d49c238c73a499e72ea35e1f73ede7458397780fe7a400e,
                0x0810b59e887390b9d1fe864b97722b74382777d2217f7617e6cd30e35df031c9,
            });

            try testArgs(@Vector(1, u255), .{
                0x68b48f7d3a9b48503994f5f1766ddb8d4ac4475e241c87ddf8da6a76db27d27c,
            });
            try testArgs(@Vector(2, u255), .{
                0x337ec1d10605419d8dd4355be390a4f023499e34db52bf3b0d0a62606e348fdb,
                0x77bd83bc7a4710a1d2e1bef57f2106d591d99b56ae7e3607f02f6bb88936c38e,
            });
            try testArgs(@Vector(3, u255), .{
                0x1227d2db3e23ef3f557816e951e4bb10e72ff351ab91b5cacc71bbeca8b0d596,
                0x43a799e7b87842c06371083027c79ca49c371476e20ecc2f06eaf90109ab8879,
                0x28ee9a513882d1783c349978eb8113872e36db3a9f622865197259c170e6b0c5,
            });
            try testArgs(@Vector(4, u255), .{
                0x29fbe1da4fb030b7a41f4efc39782901e2ed36bb3a2bf6fce3328f1bb35a5d4a,
                0x181c6db7ec0704df46fb7ae82dab95b4b0c35e3792749fdd37c82b099def90fb,
                0x4f2a40171922d1ac76fb75284c58d5999dc471983dfd18ea9c09e2358b9bd958,
                0x73bd72cd5c05d4539e9068bf63f790f57a5209198308e82bbda5d794882e4006,
            });
            try testArgs(@Vector(5, u255), .{
                0x750d690dc749b9915d831d18a10bb93284829479a0995f2faffdbc9c5d688571,
                0x20c66f9fa79198e4cde0773e4eff0e99facbbec68e00363cf25ee2a244ff44f5,
                0x0af314300283a888b3c8b1d463c24308f459c99cd56f86ad94b9cbfc9b8d892e,
                0x3f748216e8320fcbac46856706cba9307cda93b051f96b0dbe6fc7aa2e852d40,
                0x230599336b1286dad05f7f7cd278456da672540599e5c582636b06e6bf4e5db6,
            });

            try testArgs(@Vector(1, i256), .{
                0x11ee16bea436e0ca62a4b2210bf40485200d01cbd7cdf7dffdeaa211341cc1b9,
            });
            try testArgs(@Vector(2, i256), .{
                -0x2d656db593551216afa0151ba461ab2b45065679f5906fcaf982650d1ae08700,
                -0x1a9eca0762dc0aa39484646be3a3d31413399f03b752877ee1895cebacf79bb3,
            });
            try testArgs(@Vector(3, i256), .{
                0x1ce1dbf5cc4de891d8cb2650fd51532656189f6af66531e17e9898421b8eeb70,
                0x79693e75be0632e29a7c9d8fc6b8c6d999d99e5729c001c3d8be215166563374,
                0x360042a6f7deacda9311f0e6e720e4fcf569c49957872a7e4e2a9f29bff58efd,
            });
            try testArgs(@Vector(4, i256), .{
                -0x3afaf6fc3c751086bb171ee26d4fa5d5867401468e860df8622cd70c74ecd286,
                -0x3286f5d9152243d178e5215e797b3fc6194e0bb3cc7eab1787131b5002bab4b1,
                -0x48c21dad136e077f3160b044d45088d6e38e1f6360810ad1d2e5236cf6291f53,
                -0x7ffe532698217c24e1aef9da766a880482864bd3edcefa5d691dc3eb987f9eec,
            });
            try testArgs(@Vector(5, i256), .{
                -0x683d8b39ca890a8bb379f971b7ce21ccfb2d02960fbb545f6184ff3b2b1b9e00,
                0x5234f0155f933ed2f6142c0482911c3752c18851c5826eab3c7b0367cb0222b0,
                -0x106f2a3eb03fedcbd8e09a7e50d4ddb711869d85b0933a1ae4990c60d18b02ee,
                0x1841840fa31b745ce19f58a0e26aeaf201ae47b20218ec1ac0f742d0a824fa70,
                -0x1beda34721cb08e6d259b090c4b86460113f5d3714e04a9efdbd838230b87e50,
            });

            try testArgs(@Vector(1, u256), .{
                0xe160c3257eedecf8e4e794287d2bdbe05e0199f9fa377bacaab7150a08218c43,
            });
            try testArgs(@Vector(2, u256), .{
                0x2a2890961f9c32fd6862a8a789e13ae578b8e97e85df9bfe2cd1c3633f470bb9,
                0x42ff3305839a8fab4f37fcadfce0280df965a34fe306251ece6160dd39e51628,
            });
            try testArgs(@Vector(3, u256), .{
                0x1662b2361088c58a203bcc4248650c2b0c42cdd1fca6f9e075a1e3723ea39ad2,
                0x16fecf186c81ad2d5879a8f8fd32c07ef5d3e6864e0fa9d02e07d73d58eff0a3,
                0xa7a55547b67ecde8dd03f7821ca174f0c700ccfa4279be827da689db22a67b73,
            });
            try testArgs(@Vector(4, u256), .{
                0x38425be8fb0d50bd71de47f3a43e79f1c5ff4e218c7e819fc99fc575d105fdcf,
                0xb35710b4e5f00e105b10198a43bdc34dbb311580649a5fe6ee95419288002437,
                0x6a0ffbd570da143aa47b79cdcffad77021e01c5089fd3b2ddeaeb0e6a742a0e2,
                0x378da7275797290db1da610eedbd504caa9562d792589c3c5ca63adf44f6ba7e,
            });
            try testArgs(@Vector(5, u256), .{
                0xc1df4ef4fec749a7e71674a74477ef38acffaf9fb9b13bd318134125a64f55a9,
                0x0f695983ce7b6efbe77e1d816c19d0d7d2825a0ca48a4ffbf46da056cc28de13,
                0xd945eee12e936cf69057cf1c6b13b2bb0b6a04625ac5264e3d98923c08bd5551,
                0x675f485918245af4d97fa5ec823f1d8286738757b6927bae35319802a9ac927b,
                0x1dafd52324617304934a3334232dbfd80bdda0a45e77071122673ffdfd1e2952,
            });

            try testArgs(@Vector(1, i257), .{
                -0x0a14b20a35b536bd782a57c787dc3794c01134dba9173488fdaf6bca38f249bf0,
            });
            try testArgs(@Vector(2, i257), .{
                0x072d6a41d972033f35915badd23cf7b0e9ff57fa31183a33619b0cad46ccdec82,
                0x0380e7167fd18fe02359089fb1da1404d822d65c556e0c50793e57de38a80f974,
            });
            try testArgs(@Vector(3, i257), .{
                -0x04fd7d97aa324f2481852db7186940af86c33a3edf3aaf3ed89ffb1ecb3e051e4,
                -0x0e7ec48cdda939b3973b1c275a790f4322e70a0a6c1b6ad76e86ffe32b3ac54d2,
                0x0d8dfa23dfc9a6574f1ac8d20a14cd8f3c35186a7b0b0a7c5f66e4a0d4b5d555a,
            });

            try testArgs(@Vector(1, u257), .{
                0x0239060d6fe46f05ff1107848d3f90a6a59bac53dbb5c568ed0fc463553ff9090,
            });
            try testArgs(@Vector(2, u257), .{
                0x1505201ee876be14f9e58adb9c64eab8c3b8df4f511241ba9732bd81a5447d159,
                0x0dff5626712281ab4ee02cd6fd76723c4028f99868c216c2f4e3effeb3df5279c,
            });
            try testArgs(@Vector(3, u257), .{
                0x1121004d94622d9cfe548894040386f04b6ebd3045ea9672e9de10a899dc98807,
                0x0bc7d4225c4b91e1707b7dd22e3f0c04ca7676be3df0566612f5a151b45a2ab09,
                0x179ffd9dee9a9353f35bd1da0d1abfe1d9a24e8e8f69d3a0f8e7a45abfac92f25,
            });

            try testArgs(@Vector(1, i511), .{
                -0x24b04efc6e320fc823ddcf4e48f5ec8440a14267a4d972870a8d2883f5163f5037dd5a14ffb0294c4f3ced659380d6684d20234fb901bb34b67e28799f6b9091,
            });
            try testArgs(@Vector(2, i511), .{
                0x2df4135d518b6415b175a27a3e22300e76621372b8d4080170f980a2959e6f908ab64f100f48731d4b918b459521785de090eb686c24e509009086fb637dfed4,
                -0x33b264d68a02580d594a601c0cf67b57115e7a7bae762141f8ba392921c708824802fe2198503266dfd39ee7f00167ef2b044e3c83f8354087191a2ea60a0a5a,
            });
            try testArgs(@Vector(3, i511), .{
                0x167a905e5d767a9c721b11961b85bfa375f04f701848f6619347c6c2f88a8934be52aeb57263cb0e874de75a749939aad35c7221a9d47ac11dc6ad77648e66fe,
                -0x34ba5e2cfc8cbc6aa5eecd2f07100b38101b964fe007b47b2a36b7ac8a1a68bec4004afdbb05bab85afd7d524f7ca093ba6d3e3d88ee13cd52de40151a02e7b9,
                0x1d89093f8c8621d86658bf59b6c14d0653aa0cbc5400a35bd21999151b492e1969f74d62cd661b162affd0a905b9a845bda703b7d5a4fc109c06ebf1d482dfb5,
            });

            try testArgs(@Vector(1, u511), .{
                0x6804f3f0fc2750d4b8d384d6b09ed3179d41846cc34aee1d5c7c6966262de3e34b69080d1f8f4c5d155801b291485a38568073906c643f95d841a4d7477d9b6e,
            });
            try testArgs(@Vector(2, u511), .{
                0x7af109f0eea82258c259e19cfcf141ab0afd05d435df15f431ed2abff952fb369507ad24402ab17e7f63699944cec282b091478eaeb4788063b22fd1f8ea0b7a,
                0x454dcddc7106161cd0d52bdccf6250dee079886424fc4aa8916c2aa7abe94f0d4a2b728d1bf98455183b435f24e8b365de40fcf8b2cf9e94b430e5abb83a3305,
            });
            try testArgs(@Vector(3, u511), .{
                0x185c3fa8e5ec1f6e4290000ba4483a00a90413d81666d011cfa4492615d1e96458ba37084e11dd526f8fb02cf329ac68992c06a1a3e714516712caa64debf8a4,
                0x102ced8900b60d10660543aeabca571bdcd1c1fc24fb02e82eddde7c2801d877a96f5290e25eeb6055bb475e432a77fc1ef1940d57a68535016e7ee22d4b750b,
                0x3f30eedf6b47b3877012d36088fcc4371d5dfbdf270c7e784528cbe2e6db3506432d085b90be8086368ba8d11fb01c900f4a77037e272730ae9b0a2e93412d99,
            });

            try testArgs(@Vector(1, i512), .{
                0x7ac92c65ddd5102b216946290a59ebc58643006e65ad6f2b1c05fed84d660f8160c023d37da70d4c48a3a1220d7c897b57126e15e952c887c7f711ecbdb3f68a,
            });
            try testArgs(@Vector(2, i512), .{
                -0x5ce5c020744c7861891edc07ce7061c36767d58dcc89e6170895d10aea976b522b07416dc99c1d0df95511ef48ed8228f72cf73d95021f3aeeee36a4b45873c1,
                -0x7f1a17797bfc2022c64e650d6f347c826bb639503b8a0d08e025e647a823939edce5cb5ed3f4b287a176ec0f12af4e4137022259b5a2eeac3386997fdbe72094,
            });
            try testArgs(@Vector(3, i512), .{
                0x34fa3aeaf7e293ee5ca8c7fec8eb46fc52ebbee34b9e6348353145f11415f6764533ba41b8cab3227592644f7a44031dbf19280a60ea636117ff92c699e877fa,
                -0x2584de3309c35198d821a17ae79c48898309ce22980de644914be32bce6a8d885c01d06b197faaa1fd91880be1e67936b6752d3851d7eef913f44e7a59f75ad9,
                -0x75da521d275117328d53d7c4c702ded96cc3ac868d4eefb4656822673dcc0811cc0ee3352fc492d3a6ced47d60efac5acddf08aff4b9e27ef6fbb090a6cea9f5,
            });

            try testArgs(@Vector(1, u512), .{
                0x79a47336a6fba6e6813ccfa098a9dd34c328106806d0df7d76e3f1aa1394487b8defe6edcb48e99375d7b1cbd48ccb1ed0d0944ef63c4a2efea7ba0428ebd763,
            });
            try testArgs(@Vector(2, u512), .{
                0x422895dc913417a5dd65b107ba3a025e3bf314009be30c819920105e9aa030d188d9a3ba91701d0affa6ed029e47e7f5190ae59f668c2645f31e41f5919dd57c,
                0x4d00d445c33a06ada34d7b6f71c3142c0839640e9431fe1643898885fed7cdebc64b5f696396ce0d761c59207780161d55d4e31d9197e4fdfca3db49de92ebee,
            });
            try testArgs(@Vector(3, u512), .{
                0x8f03cb52100b861f78b20e82a42cc93372d026718dbfe5a6e02eb4dafef402ac01e5c25215f041a8c0141d4b3893a9b00d5831af0ef6a2332ad91530358ac976,
                0x87073b8771f973cb4f20c2bb3471baaace1b96257f539b0c95a72e067875bce909658986d93e472283e6f2531139f419161d0d3b06f8e0d54aac251625881dcb,
                0x39b9325af9096a3bbd433949373e1fe3bdc4c3b4b815217cc434a619589331793f8464a3d39edf0ce03412571a115b0068b59939254f424cb283292c138d7402,
            });

            try testArgs(@Vector(1, i513), .{
                -0x02fa7925db1974eed505becad489203de3f5b16a24345e5ac2b0aef5760354411707fd7f71a55ba4f5496122b33c09fc22bba6fccb442ad87a33a5702ab2ae80d,
            });
            try testArgs(@Vector(2, i513), .{
                -0x0572883196ec1f59abf0d223a1b267548aab3723a52c42b8dab05a5b55098499eec99d366df601ebf9ca2e4538f09963dbd0a4a757340b241704cdd8525472817,
                -0x0e67935e5e7bde4ec95b5a8785a8607cbb19198f6b51eb3767875f11c34df66ca37c29618b3e7cb446b2b5ceef3ecd784d42df002465662e38494f5cce5d04c3e,
            });
            try testArgs(@Vector(3, i513), .{
                0x083c8d7784c3710a10d1522b3317f07e1c837bbdfb283c9a8fd68d9d21d8e458e8a0e2858bfeeea66d5360d0c93fbf1b2d74566f331d7f2b13bd72d5e1ffb1411,
                -0x0279620ff484da4f6bc4d3c4001d440fe874a3878dcf108c960eeac423ac294da02e001190755d67017438c84aa64d8268013f4c11f48d66d85cb556114fd4b59,
                0x0415824b87729d90e61248d87119f51cf696c77a8a91f3cc16fd71369e9acac27a348efbaed8289ee4d9461cdac60590320c6f0f925c61a92280f182278a04197,
            });

            try testArgs(@Vector(1, u513), .{
                0x0b3f0061e17faf60492be4c606127c198047d8848e60f9bb396b2b211ce905f4cbb0809728578a1b104232caf75ec24dcc6a0ed99c2bfeb78a45ce7c13da6f3e1,
            });
            try testArgs(@Vector(2, u513), .{
                0x17a2be6257dc9ee463ac0bd361f45085318085f00a2612d1394b298155f521d5015997553d82ab09a9e3e091efe6b1bb4abf5f2071b67c409982991c831099201,
                0x0719c3a3f236d6efbbe8c195957ed4f7abf32a97d4aa2a2998c0745ac038595a034d5bd4f908a425d7c562ba1e32ecb771028c5d68fb38c0885c0d811858b9592,
            });
            try testArgs(@Vector(3, u513), .{
                0x0125117a5e455d03de6a22e7e32751bedd25a0c3609c1626a2a3c951043e140ee55cae5f5df26b7dd72b24869a22c685c4aa86704bda24ba43018ebd77b4a9989,
                0x0aa290b16b679378e0c8698c827337aca4d962c02251a4e33755e2836729a7e0f6e9948e2db432301042099fa52aeaa83179297480be45f6178d6cbdab7010c68,
                0x1970f094defc472dfafb94c8bae6fe0e307885be5b59c3d3e861fcfa118565e4b4ad404d1bbe771d445aeaf4efcbb3415a124ad108ac187e4117b25c41dc107b3,
            });

            try testArgs(@Vector(1, i1023), .{
                0x3d2da46d447f8bb6cb002f67cad8990a07b561c2967691d608a5f351cc9ace90327f5221e29c60e1a3aef30bfb7caa1ab0feb1b11f933a05b7a3e43d47319e41762d855bddcabc30a1ccc61dc00f5af7fcb2e94e880d74580aff5a82863115779ba6fbb687686b075be218397a4f5a3c457704a5d2da19cb0eea7de769e60c73,
            });
            try testArgs(@Vector(2, i1023), .{
                -0x2a754a676246ef2ee43171d120dcb05e4ad3f66c4783740af3b2ab0cbc825b90db0688e7b68b8fda5acc8b56b373d41071df282935f9e8dfef774bb43d4ed5afd8f3d7808a7cee4f488fd975e4bef3d7a0409bac6cb707ff26c557d7d7af7082ef2ee8e7862c35fb33094b27eea6cddf92978b3939f35d5207dddf60a44de455,
                0x161c7a3ea3411359a1938ce40bec3a76a5d8e15522c1be6cfafcfe3b5c58d941430721d4cb8e0efbd247063b1706c2388668e1cb11abbaba4d8a46fff5b0442490be242dd448fc90e7a7c1dfbbdcaf500b294cca878be34cec1407046772577047cfa17db746ee1d97e35670c9ee4ccc58ff4968001dfe6332a50e75eec9b276,
            });
            try testArgs(@Vector(3, i1023), .{
                -0x3fcc7f6eb4824d52d478ab4d1035f48a99001ec13352b1f9f05a90311b1e78429d6486d771ee17793f2966cef28568423f8d71d6feb03d554bb956231e73a17b3acaab219917c726e85dfbfa4262c331e76e5740dc78480fdc0f6d2e5e67ec5b9ae7a574c0e75a2db4cefbe4115ab8b9c2f2b7e16ac808053c7451ce8f298a5b,
                -0x1a9bca992bc979547fd708aff54b2b58e1d450cedc583582882bfdb522beaca79cf04cd113575a2790c9eb39462a515c36df90f0d1a690b8b5d1a674026a3ddc35da3780c9b4f63029f7a108f17183dffa9d467e8a2c2586881fe3cba85732e44ccd9c23f89139ea1d63a6628a04a800d878c0931523ef2edf15222f6a900d07,
                0x341194925f80b89df2023b8978fe45d12c897966639abb3fb1d49ecf07c7bb1608fbfcccce81802c5f52251cb73cd7c056764e100ebe5bf5c462f77cb9e7b7de1300a5b0c7853ecc93ff29097d8e08eb8407e4dd26f97a08d75543a9303195907301ae8702fc1e2dae527592b54cff4bb04ceeb686e4a7cc8a750866743b63bd,
            });

            try testArgs(@Vector(1, u1023), .{
                0x3c5f7f4de2f1d7e49c67d6a3a18c2997cee8494cdcee98bd581be84286828c3e051fec9971701a6477143ab5a08a60992bc7511e88f784f58ec072ba8b37243008c3df6d0e4b146f41c1ef226d1b89132f89108978a0daaa21853e1a571ed882a808b8ae6c28214bb0e0b11e9d94cc2b691d23332a53834e5fbcd8990178442f,
            });
            try testArgs(@Vector(2, u1023), .{
                0x2b8dd03f8be36509fa36620048fc62c2d49d8a5376678fd0dcc5dd25db0d7e3a7978db01be60a5a301923a3797aa59f64ea84dcfb374051c7a7dbbacdda9f143aedbb63ff7395fa36a683d7a8cafa0c1c1b2a1e490e9ffa76d9c8952041253165eb627f51edfb0d95e1a73435d5e5f3e8e0c515360fcd8a9fb12b2889e99fadb,
                0x4c2ddc4fca46ac0447e6aa6da47fe92bd282623814bda4b053ef60f9d5fd3c978ef1a77f7738f0c6469fd2580a3f2322080c51ed1b5be87bc12674025df47157854d99be18f5affd10200de2cab1b2753b4414ad28f845d9995f04b0b0f9b705c81b79af74c738ee0c4cf099859d6361f04042ab8e916180039cd17dbc9f27c5,
            });
            try testArgs(@Vector(3, u1023), .{
                0x24ceb8803d48f284d4c0b51a2033fc2fde5794adfe9a0db8bdc812178e8277e9a2b90d07e58addc1cf02e40ce81286ac56db4d93432bba560d184ca319863bcd2c7176952b924388d1571b03356ed48837e278fd0aa16e915fa08bade0171d16b4a0d942c582dfefbfc906bfcbbc1dc260963eb5afcb353feb89d0d414501af2,
                0x44e492d7b289c654b650ac836b9635e71a3478d1a9d1518f4be5fb03f994dca3f4eedd30ad37006fc773cd22544ec724575407e04882b45be1c5bd41ca22efcdf89c2d9f298bbfb2dca1be1b1152ba318c59b3bdc61916876b70a83b1a1fc875113147eecd20aa89a1681b3912510ee719f1566593f822ca5eb286feca4f3721,
                0x4b812d648fd33de234ce48a62920510b609bce412f66945def4d63dfdf84bbacdbc5b59ed9c1eea8a34b6ddbf9a2d3a585190c7144bc2fde3dc776e89accea0e20c9e53dccd8173a09860fbd65b7d48939d9e38cebe9946f342b922cc314aaae6b238034f5cefa371b2c5736949937a5ad865058caae6c7f6b2522db34ff79e3,
            });

            try testArgs(@Vector(1, i1024), .{
                0x6b671c8f7bed2bbb3c498c95de279178c68b8ae7d1ebf0551257362b741b6cf4381e4a7df5d7ba4eb9e58d1939214bb11bac2fcc1963680dc4967f44c3cc1a3fe00b6aeb1feb2258859573d7b4b6b12a20f006f6b92d6001244c8aaadb1df4d98c71dff3c87f097dcd43dd81334bed77c31292b6824f7830e029ff6d8bddc289,
            });
            try testArgs(@Vector(2, i1024), .{
                -0x0e21c88d159ed365504f6ea10dc9761424daaccafd3ef26adbafbe7500079237b0f7b73b71e81348d0dd151d4b42a1f49b4851c67a714f282966a5dd3c4b471457e13e954061e3e7c492b814575387ce6e541e86188c4f3cc77a494be7d1dfaa238dfc3a4533553ee20ca474c1e6099ea9f47c6825173f6cbd9683e75df28ae0,
                -0x107ef3d7b677ef54de72a85a9b10678737e94bfec2ee6d5aa4721075b71d3fa76be4901bca74776d5beceeef7453f3076242386e6f5904fc7bb278d94d6b94b347726bde745ddad57f6832b30faaea4f8900f2886b1784fa058505c2a85a6adf88ba17abd66345d3921b222610cd2d3d99a2a3c9feb3db8138dc8777c132c7b5,
            });
            try testArgs(@Vector(3, i1024), .{
                -0x02ff499fa41dfaac5c55ccaa6be1329170cacef301eb9fe6c90c313fb0eff4fe6408a9e88c49c124c219dc2acc76547e3b2068529a16df5a3a17618d278971e14fd63657e85adfaca61da450d2317ee221983efb560844bff2dac0b7a0a32eebeb6bf99b90786228d854ae293c42d6c0f8991aef0593ae3a92fbe5f8d8994120,
                0x5931557062aa9cb6887b469754dfcac235f1eb6a363735b45eded73cd1b267b1cc7e9cd745aae97fbeec6321ebc316a3bc8cd9001611844582e5d2305e6884b40aeb81f73b6879b3ef5ff559d4e263e3fdbe4d192d6f4c95dca64080d1de222c0d3cefcdfed787e62a878cb6976a567d02aef2a639134691713388ddc04ab964,
                0x0af9d629a1875b08ce10d8bd0103f75374d89fe6b9aec783bf4a17ffb6d048db702280ea8059a8e4489e58903d81fa3df53d2f24fa74f90c5b4fd5076fa7c3e22731ca433777d2d1db2052e1f8d2682765cf6d4adacf26321a85144db8b76ad6a0b8028b7dd65f6e4c88b11f7f88bc0e31200a1b931e20d8e17c227bc7fef8f4,
            });

            try testArgs(@Vector(1, u1024), .{
                0x246608fcdc604ae118a4cfb7ec317eeb96ce4b1abc421d3780a9ac94bbfc09f0818daa620c413e93c1daffde3763becf724fbbef43628701d2d335daed8a5248b535e29d907289e3d1478d7299c23d7b15344505870d64e91590b7f896df2e5df3f824310ce626b6326bf8dca77948d198708721db81e8b23cbe0c7cd9288e55,
            });
            try testArgs(@Vector(2, u1024), .{
                0xbfad2b801641bb3668e502bc63577ced965e241e29660b08044658950f1d849d378f0029aede7becef9fac4f63f1f82e581810233ae7708173b318b64220bf7db0bf6cfb4fc2340cb174d3bdf06ed8c08d0d6beb155f54a1878c94edcc0104a340ad16481da6197cf879519414258ff4c7b7f05970c3153937229870677c0dbf,
                0x5cbfd667b1cc9363c85b460cf5028ff6f2e3af5e3c7f59799be0d826b500b8dc1e80eae818df0529b478e190eaccfb59c2b33978897c45bc29e1b416f032ab03baf6f14b043aeb9675137f5c2c06eb52f9b4f56e7ab6ccbefcaa67ef5b024d81f6b2b65d6b40153bc7738094d2a3a527377bdd7562d039229d946c6cde2de286,
            });
            try testArgs(@Vector(3, u1024), .{
                0x1001d073a02929017fa89db7fafd02e8ed7ae9e0b4ea1821d60f3edddb621312ae1c8b37b4a509e0aea10398f08f1bbd1d594f7514e4235931efb7161a244d0746796d509b894e4dd27cdd7aa093b3e68d057b6acf6678157a285c740c60b74be183ef1646cc872ff1581d84c2ee4b37d6a4e8e2d9b6906a8c117774bbd152af,
                0x39d642282ca74c0f3716f84658e72ba4244a56209f9058a1aff1e30a3b7ae0283a4470e39d025c4c9e822ae921724304cae1a795772609bceb0387bcd6e440d1b2f78fab2dfe1472fa9011bf57d90cfbf3dde03591ecce21edff98996513a0447eb46e4a32121fe2f6da5333a42c740f64822fd9ebe823557c8d2873869a1d1c,
                0x63aa1ffdebbe1810ac982923ca104863b3bc1191a0418a25a400ddad005fb959ee42076bbee7e4dedc6a49f426631e0e61a17a624759a145393dadeedcd7b43cd116d4ed16f335b1917a46892383c132639fe834305db2f020afe90bb4397dcd33a75b021cc1cf14cc25b9f070ab49f093904cbf1ed510689c9262c9ee0a4850,
            });

            try testArgs(@Vector(1, i1025), .{
                -0x0c2cc48ef611337f59351a70d7663ff4fc7181b04680d67d9ff73e18fe40fbf4bf12072149c91e056363607f0670f1912daa6d2c25ff23970d79d5cb033c42e1f0a2fe2d498896fa9c064b241c9c8b218fa49dc060e9f0842130925d29e9baf51e789fff2ffb0dae09af96e64e9951747c40d25edf4dfb69d8a69370962361e49,
            });
            try testArgs(@Vector(2, i1025), .{
                -0x00fdcce826852665a7765c534543b9d70416312b53d96270cb588ce17f86f16d48445fd4d79924fa1785fee2968519e4d183fbd31c94a405d467615ad1f015b692916ee99bac4dda4a52fc200a490d8844aa25c58f419d698b91f376bba340af761bd8779e172cca71afbecbaa82f992a43c73f610686c36951e072ebc8f57a1d,
                0x0cffea79609ddaae8ef7262ab9cc8cdb3a52564e843b7fee701f5a5a04b8c9709976a00800b79752ba7be72f816c665d12e5ea62637da669b5fb207ae52d6629a6f60235e3d9e10d4afa92405c8db29f6ce9b54d013bb0a95646b17257e6df2eae063e27815f9f08b7be1e089ce734af5128ba0d7a601adff3f02f783cd756b7a,
            });
            try testArgs(@Vector(3, i1025), .{
                0x04461ed6de3fca86c238e890d4a3fc30597b881dfa207400d2b3c042705dd529f7a8f0a9328e94d9804afd014ae72a0d9f301c858a28bf6dcb181868366aa34db89b0ce469936ae69da8fcf82838d41bbb97473318aa9b81350ed69855d8fece3941bf5c1810155f46cea627b0dff0a6102c8b823f2c1a25a52ace05c4436cc99,
                -0x04ddaee982bc812cc8bffc99e8e0d5767426748c0875e111ccec02215a454b64e1528c4055e357048c50484c7c9ce1889de5d8bd1ba94b89a11f01bbdf94627e9447c054a144848be9f61db4f07605b9fa72d25084d495c136fba5ff242b9aa08b8a456e6a3e994d3e341ffb675000126b971b3e9379c90c06c7bd99570fcc1c7,
                -0x0df9e9416e77e5248dce87efacb4c381e5303d4d7d4b86da7da5effaa16f1ae564339b0bff27fd7a39469ca107d1a995f5b46bb6b9eb1fb7ef2fb1850dae69d32a4dcbd8fd8dcfd740757ab5fc218cf15d3d0460a8ded650e254414ff076df919c0d87453495dc658629301302db07a231b340150b1f910453835a74304c893fd,
            });

            try testArgs(@Vector(1, u1025), .{
                0x1cf0886108e6cf9a178542832e0ecd6e10863173eb13a9340e9b4cb8f9c98e2e0dbf9adacc655f29f39f7aa3be7aae7c7a9e6f295bc7dd82caa8952a34f7e89888023416df303ee75dcfd93dd82a2be14a592eea41c5805806de0af9f587e6c4689acdca6ec5a4ac1b3b25b9316b3b568ea0668fbc915f153478e95f70f9e7e0d,
            });
            try testArgs(@Vector(2, u1025), .{
                0x05d2fd186099cf21acc255b80551d93720cab2db1c405eb550e04108b794dc0381267e189e8f653ef0a2fc23521ddbb79220556af1319cbd72012d133f2b7139b812138a477bddf01c0f2ef0dfd391161931a6660c797d5cd6b816d973262b381ea1c61a15580059a72a48b87d16955b8f41fd1fd5665fbf254e9c568f2f7b7ea,
                0x10fd90feb241e00b33a58ba6cd404acc87c73f0d110b33e14495c22d6a9c63ec234f7071831b51e8dc5f050cb4abf597a19f2c2ac611a9305d012d0ca89b7be66de3c08e83f05d792795bba102bfb2e25ebb534b52693005a6075acaf3d6e6a6b7c6adaa083f3003c749c4851cff102d8c007eb1865c27339d442bba8552d8bee,
            });
            try testArgs(@Vector(3, u1025), .{
                0x0d31cc56a6d6165e5814cdb97af9d13c78ab9ccff06dae36a866895d27b3a04981a55c22877e4dff45fe178492ede49dc3501b6c69e83b797632b45f94137b997857cfe8780179ad1c42e15273b33751cf04b96de00a16e564e7d144404f955032b775b90da2526d88f7540ffb5d10e3c171222841b2a1db353cb85fbe483935a,
                0x0950f7ce2ee39dfe774b4672fcdcf822303d0f0133e1652352df92f35e8f7e8136e4352b031cc59d7beb7c02997882ae4c2fb1465775c16cc30e4af1652591385a4861f3f347791c1af71c10a32d0282153e51762f62fbb76a44242c7f14e083879040226a74d8e240fa8f69edbe78a774359b2295ed2bb177044906ab3f65248,
                0x069f6540fa60e45dffd4a990048e4210a8b1d0a65e9b6ca0bbb3cb88e509fa129d5f91bc7f45ca77e699e01d81ac7686f26ceb67abbee88ac2fab1a529e7290ee7163e40833c806a6e82547a8f0628829d510367e06304c2eed7634da133f19de2a284b7094102374d9b1b779206a8d102d2e4cfd663bb9b06a71ee56b709e058,
            });
        }
        fn testFloatVectorTypes() !void {
            try testArgs(@Vector(1, f16), undefined);
            try testArgs(@Vector(2, f16), undefined);
            try testArgs(@Vector(4, f16), undefined);
            try testArgs(@Vector(8, f16), undefined);
            try testArgs(@Vector(16, f16), undefined);
            try testArgs(@Vector(32, f16), undefined);
            try testArgs(@Vector(64, f16), undefined);

            try testArgs(@Vector(1, f32), undefined);
            try testArgs(@Vector(2, f32), undefined);
            try testArgs(@Vector(4, f32), undefined);
            try testArgs(@Vector(8, f32), undefined);
            try testArgs(@Vector(16, f32), undefined);
            try testArgs(@Vector(32, f32), undefined);

            try testArgs(@Vector(1, f64), undefined);
            try testArgs(@Vector(2, f64), undefined);
            try testArgs(@Vector(4, f64), undefined);
            try testArgs(@Vector(8, f64), undefined);
            try testArgs(@Vector(16, f64), undefined);

            try testArgs(@Vector(1, f80), undefined);
            try testArgs(@Vector(2, f80), undefined);
            try testArgs(@Vector(4, f80), undefined);
            try testArgs(@Vector(8, f80), undefined);

            try testArgs(@Vector(1, f128), undefined);
            try testArgs(@Vector(2, f128), undefined);
            try testArgs(@Vector(4, f128), undefined);
            try testArgs(@Vector(8, f128), undefined);
        }
        fn testFloatVectors() !void {
            try testArgs(@Vector(1, f16), .{
                0x1.7d8p12,
            });
            try testArgs(@Vector(2, f16), .{
                -0x0.054p-14, -0x1.c6cp10,
            });
            try testArgs(@Vector(3, f16), .{
                -0x1.39cp-3, -0x1.088p4, -0x0.644p-14,
            });
            try testArgs(@Vector(4, f16), .{
                -0x1.108p11, 0x1.364p-3, 0x1.8f4p-2, -0x0.8acp-14,
            });
            try testArgs(@Vector(5, f16), .{
                0x1.e1p8, 0x1.ddp11, 0x0.388p-14, 0x1.7p-7, -0x0.a08p-14,
            });
            try testArgs(@Vector(7, f16), .{
                0x1.988p-14, -0x1.f7p-14, 0x1.38cp12, 0x0.0fp-14, -0x1.774p2, -0x1.de4p11, -0x1.9bp-10,
            });
            try testArgs(@Vector(8, f16), .{
                0x1.6ecp12, -0x1.834p9, -0x1.2c8p13, 0x1.e7cp3, -0x1.418p3, 0x1.15cp-1, 0x1.fecp-2, 0x1.1dp-3,
            });
            try testArgs(@Vector(9, f16), .{
                0x1.da8p-1, 0x1.d44p-11, 0x1.884p-10, -0x1.898p1, 0x1.5ccp-5, 0x1.68p0, 0x1.618p14, -0x1.c34p2,
                -0x1.318p6,
            });
            try testArgs(@Vector(15, f16), .{
                0x1.41cp11, 0x1.edp-1,   0x1.1c8p-12, -0x0.0ecp-14, -0x1.abp8,   0x1.34p0,  -0x1.24cp-4, -0x1.214p1,
                -0x1.604p9, -0x1.364p-1, 0x1.adp0,    0x0.63p-14,   0x0.60cp-14, 0x1.6ep-6, 0x0.84cp-14,
            });
            try testArgs(@Vector(16, f16), .{
                0x1.308p6,  -0x1.078p-1, 0x0.81p-14, 0x1.1b4p-14, 0x1.4ep-7,   0x1.75p12,  0x1.264p-8,   0x1.a6p2,
                0x1.9a4p-3, 0x1.e9p4,    -0x1.a4p-6, 0x1.6acp-1,  0x1.7e8p-12, -0x1.02cp6, -0x1.0ccp-14, 0x1.edp-12,
            });
            try testArgs(@Vector(17, f16), .{
                0x1.2c4p-1,  0x1.91cp-3,   0x1.bf8p10,  -0x0.25p-14, 0x1.45p-9,   0x1.cap-2,   0x1.e9cp8,  0x1.b7p8,
                0x1.21cp9,   -0x0.ba4p-14, -0x1.ddcp-4, -0x1.bcp9,   -0x1.7dcp-3, 0x1.6a4p-12, 0x1.ca8p-8, -0x1.558p11,
                0x0.26cp-14,
            });
            try testArgs(@Vector(31, f16), .{
                -0x1.f94p7,   0x1.55cp9,   -0x1.f78p11,  -0x0.f48p-14, -0x1.b6p-2,  0x1.85cp1,    -0x1.114p4,  -0x1.97cp-5,
                -0x1.6f8p2,   0x1.79cp-3,  0x1.e58p-9,   -0x1.f5cp-10, 0x1.a74p5,   -0x0.1e8p-14, 0x1.15cp-14, 0x1.814p-7,
                -0x0.318p-14, -0x1.b5p-5,  -0x1.058p-10, 0x1.124p0,    -0x1.20cp-1, 0x1.978p10,   -0x1.808p-8, 0x1.528p-6,
                -0x1.ba8p9,   0x0.294p-14, 0x1.11cp0,    0x1.e5p5,     0x1.904p-11, 0x1.d78p11,   -0x1.c1p5,
            });
            try testArgs(@Vector(32, f16), .{
                -0x0.11p-14, 0x0.29cp-14, 0x1.7a8p5,    0x1.49cp-11,  0x1.6c4p-3,   -0x1.85cp-11, 0x1.ap-8,   -0x0.49cp-14,
                0x1.dfp2,    -0x1.4cp1,   0x1.138p-5,   -0x1.45p-9,   0x0.88cp-14,  0x1.6acp10,   0x1.594p3,  0x1.704p6,
                -0x1.c34p13, 0x1.44cp0,   -0x1.cfcp-10, 0x1.5c8p-4,   -0x1.b2cp-10, -0x1.178p1,   -0x1.b74p7, -0x1.d18p0,
                0x1.0fcp-9,  0x1.b6p-11,  -0x1.ff4p-2,  -0x0.0b8p-14, 0x1.4dcp-10,  -0x1.af4p-5,  -0x1.eap2,  -0x1.79cp-4,
            });
            try testArgs(@Vector(33, f16), .{
                -0x1.6e8p0,  -0x1.304p-12, 0x1.558p11,  0x1.cf4p13,  0x1.cc4p-9,   0x1.d88p-11,  0x1.838p8,   -0x1.2ecp-10,
                -0x1.65cp-1, -0x1.644p8,   -0x1.048p10, 0x0.114p-14, 0x1.8a4p13,   0x1.c9p-3,    0x1.dfp-6,   -0x1.774p12,
                -0x0.4dp-14, 0x1.2ccp-12,  0x0.98p-14,  -0x1.b18p-6, 0x0.1ecp-14,  0x0.86cp-14,  0x0.6e8p-14, -0x1.6dp14,
                0x1.9e8p-3,  0x1.1ep10,    -0x1.6cp13,  -0x1.d44p1,  -0x1.f54p-12, -0x1.fe8p-14, 0x1.968p-1,  -0x1.ab4p-9,
                0x1.f0cp0,
            });
            try testArgs(@Vector(63, f16), .{
                -0x1.3ecp-1,  0x0.04p-14,  -0x1.1cp-2,   0x1.0dp10,    0x1.ddcp-12,  -0x1.57cp-11, -0x1.84p-9,  0x1.dfp4,
                0x1.6e4p-9,   0x0.5d4p-14, -0x0.51cp-14, -0x1.bp2,     -0x1.8ecp-14, 0x1.268p-2,   -0x0.69p-14, -0x1.b98p7,
                -0x0.cb4p-14, -0x1.accp-3, 0x1.cdcp6,    -0x1.e6p7,    0x1.4ep-14,   0x1.5fp5,     -0x1.95p8,   0x1.044p8,
                -0x1.e14p9,   0x1.e84p14,  0x1.ee8p-10,  -0x1.0a4p8,   0x1.b14p-8,   -0x1.5dp9,    0x0.e68p-14, -0x0.1acp-14,
                -0x1.7ccp-11, 0x1.45p-10,  0x0.044p-14,  0x1.078p4,    0x1.c8p-1,    -0x1.8fp11,   -0x1.cbp0,   -0x1.208p-10,
                -0x1.a5p-1,   -0x1.164p-8, -0x1.304p-3,  -0x1.038p-10, -0x1.4dp11,   0x0.248p-14,  0x1.09cp-4,  -0x1.a7cp14,
                -0x1.a38p-6,  -0x1.0bp-9,  -0x1.fecp-14, -0x1.c78p-10, -0x1.e38p-11, 0x1.47p-5,    -0x1.3bcp5,  0x1.6a4p9,
                0x0.728p-14,  0x1.9c8p9,   0x1.88p12,    -0x1.e6p0,    0x1.5dcp-2,   -0x1.7f4p-4,  -0x1.a6p3,
            });
            try testArgs(@Vector(64, f16), .{
                -0x1.67cp-13, 0x1.f2cp-10, 0x1.69cp11,  -0x1.0dp-2,  0x1.a8p9,     0x1.7dp-11,   0x1.908p-5,  -0x1.37cp0,
                0x1.8f8p5,    0x1.38p11,   0x1.d2p8,    0x1.b74p-10, -0x1.188p-7,  0x1.578p5,    0x1.68p-11,  -0x1.b9cp8,
                -0x1.ba4p2,   0x0.b78p-14, 0x1.458p-8,  0x0.054p-14, -0x0.63p-14,  0x1.83p10,    0x1.94cp-2,  -0x1.d7p2,
                -0x1.62p4,    0x1.b34p4,   -0x1.4cp-11, -0x1.714p9,  -0x1.ce4p1,   0x1.75p-3,    -0x1.cbp-13, 0x1.714p6,
                -0x1.cb8p7,   -0x1.b98p-4, 0x1.facp-13, -0x1.1f4p8,  -0x1.92p-3,   0x0.144p-14,  0x1.504p-4,  0x1.a9p-10,
                0x1.a94p3,    0x1.708p-2,  0x1.c84p-14, 0x1.77cp9,   -0x0.1e4p-14, -0x0.3d8p-14, -0x1.f8p4,   -0x1.2bp5,
                0x1.5b8p-14,  0x1.898p14,  -0x1.e2p3,   -0x1.0e8p-5, 0x1.4dcp-12,  0x1.368p8,    0x1.968p-7,  -0x1.98cp-5,
                0x1.39cp-13,  0x1.23p2,    0x1.8e8p6,   0x1.344p7,   0x1.70cp-5,   -0x1.f24p11,  -0x1.54p-7,  -0x1.904p3,
            });
            try testArgs(@Vector(65, f16), .{
                -0x1.d78p-4, 0x1.ea8p-8,   -0x1.b4cp6,   -0x1.c7cp4,   0x1.dfcp7,    0x1.a8cp6,   -0x1.768p11,  0x0.0fp-14,
                -0x1.a3p-4,  -0x1.868p-9,  0x1.23p-1,    -0x1.2e8p3,   -0x1.9e8p-12, 0x1.8a8p3,   0x1.168p-5,   -0x1.608p8,
                -0x1.9d4p-4, -0x1.17cp-1,  -0x1.f2p1,    -0x1.d38p-11, 0x1.f38p-12,  -0x1.92p-11, 0x1.c44p6,    0x1.4fp-3,
                0x0.18p-14,  0x1.3dp11,    -0x1.ce4p9,   -0x1.bf8p-12, 0x0.88cp-14,  -0x1.998p-9, 0x1.788p-2,   -0x1.5c4p2,
                0x0.08cp-14, -0x0.6f8p-14, 0x1.c7cp-10,  -0x0.1p-14,   -0x1.0fcp-9,  -0x1.5a4p6,  -0x1.8c8p-12, 0x0.57p-14,
                -0x1.96cp-9, 0x1.6ecp10,   -0x1.c18p1,   -0x1.0ap5,    -0x0.768p-14, -0x1.f8cp-6, 0x0.44p-14,   -0x1.2b4p-2,
                0x1.efcp-13, -0x1.434p-13, 0x1.434p-3,   0x1.a6p-2,    0x1.bc4p7,    -0x0.e1p-14, -0x1.d9cp-7,  -0x1.f94p-9,
                0x1.448p-6,  0x1.0d8p3,    -0x0.4a4p-14, -0x1.25cp-10, 0x1.c18p12,   0x0.1ccp-14, -0x1.ep14,    -0x1.42cp6,
                0x1.14p8,
            });

            try testArgs(@Vector(1, f32), .{
                0x1.12e082p8,
            });
            try testArgs(@Vector(2, f32), .{
                -0x1.f04666p17, 0x1.27d624p4,
            });
            try testArgs(@Vector(3, f32), .{
                -0x1.c3168cp-85, -0x1.169cdcp9, -0x1.4bdb2ap13,
            });
            try testArgs(@Vector(4, f32), .{
                -0x1.a8b1d6p29, -0x1.b94e32p-76, 0x1.f4d9aap-43, 0x1.e6c654p44,
            });
            try testArgs(@Vector(5, f32), .{
                0x1.37c57ep-53,  -0x1.832c84p49, -0x1.04256ep-110, -0x1.de4454p-37,
                -0x1.a36832p-34,
            });
            try testArgs(@Vector(7, f32), .{
                -0x1.35df86p87, -0x1.d96a52p62, 0x1.f9d3ecp-12, 0x1.5f4cc6p112,
                0x1.176cfap94,  0x1.bb86fcp69,  0x1.015e56p0,
            });
            try testArgs(@Vector(8, f32), .{
                -0x1.9dd6cap3,   0x1.726066p-42, 0x1.5b1f5ep-20, -0x1.347ed6p29,
                0x1.bfb5d4p-126, -0x1.b0e8dp45,  0x1.5577bep45,  -0x1.9d1608p2,
            });
            try testArgs(@Vector(9, f32), .{
                -0x1.4159b2p76,  0x1.bea7b8p-107, -0x1.b47036p-82, -0x1.4635ap-26,
                -0x1.27bc98p-47, 0x1.1e0ap-116,   0x1.0f628p-118,  0x1.2e63bcp-62,
                0x1.d0e45ep-57,
            });
            try testArgs(@Vector(15, f32), .{
                0x1.65e0bcp-12, 0x1.d947c6p-42, -0x1.4596acp64,   -0x1.2a897cp75,
                0x1.cb074ap-8,  0x1.e44a98p-62, -0x1.3edb2p74,    0x1.07aecep-2,
                -0x1.fda1f8p14, 0x1.2f2c7ap-95, 0x1.9814e6p-33,   0x1.6d6a58p3,
                0x1.6a1478p-3,  -0x1.85886ap64, -0x1.e2b9bcp-114,
            });
            try testArgs(@Vector(16, f32), .{
                0x1.348b38p103,  0x1.bbc8e4p8,   -0x1.03f48ap-119, -0x1.90f87cp115,
                -0x1.88aaaep28,  -0x1.21ec4p-94, 0x1.e1f21cp-57,   0x1.0e7dd2p-37,
                -0x1.5963a2p-24, 0x1.4c314cp-61, -0x1.753d5ap113,  -0x1.65705p-12,
                -0x1.e34902p-54, -0x1.ab8022p87, -0x1.5cc252p-99,  0x1.4f4fe6p41,
            });
            try testArgs(@Vector(17, f32), .{
                0x1.6be79ap-19, -0x1.38819p-21,  -0x1.8551dp2,     -0x1.43155ep-126,
                0x1.96e6p108,   0x1.58abaap41,   0x1.145ffcp124,   -0x1.8e314ep-41,
                -0x1.63151p42,  0x1.9585e8p124,  0x1.4bdd42p-66,   0x1.858674p-45,
                -0x1.bccb68p66, -0x1.88e0e8p-14, -0x1.e0461cp-116, 0x1.3c1e2ep120,
                -0x1.0076dep14,
            });
            try testArgs(@Vector(31, f32), .{
                0x1.8d5b34p-49,   -0x1.bd019cp-83, -0x1.1d06e2p-95, -0x1.d9ac6ap-45,
                0x1.f942dap10,    -0x1.c23402p121, -0x1.8e5656p-32, 0x1.925222p-53,
                -0x1.16440ep-117, 0x1.b146cep107,  -0x1.b58cdep-52, 0x1.713f34p8,
                0x1.3de424p99,    -0x1.3e6d6ep-28, -0x1.8261b4p-69, 0x1.043d66p-91,
                -0x1.fbcd6ep113,  0x1.7934dcp-47,  0x1.fa8152p99,   0x1.c29968p-58,
                0x1.77f26ap82,    0x1.4602aap-57,  -0x1.8a4cb4p8,   0x1.d48cdap113,
                0x1.636a7ep29,    0x1.730262p57,   0x1.29e668p7,    0x1.58592cp20,
                0x1.d09ebp-107,   0x1.7a85c6p-39,  0x1.38e1d6p44,
            });
            try testArgs(@Vector(32, f32), .{
                -0x1.95dec4p-65,  0x1.3833cp65,    -0x1.0ef5ap-53,  0x1.86e4c8p101,
                -0x1.713132p24,   -0x1.c6fd0ep123, -0x1.75aadcp88,  -0x1.b8f0fp18,
                0x1.0f5b8ep-34,   -0x1.0d0d66p-15, 0x0.842836p-126, -0x1.157782p22,
                -0x1.025e8ap-100, 0x1.be825ep117,  0x1.d3efc6p-45,  0x1.ed8462p-34,
                -0x1.b373c8p-118, -0x1.dbfd16p4,   0x1.73ee9p-56,   -0x1.cdff48p-69,
                0x1.1b806ep-78,   0x1.65a58ap-4,   -0x1.0d851cp77,  0x1.442c12p41,
                0x1.215116p47,    -0x1.75f266p-48, 0x1.2273d4p89,   0x1.1bab24p-100,
                -0x1.0300ep-22,   0x1.8c199cp-70,  -0x1.70e08cp-66, 0x1.aa6b3ep-24,
            });
            try testArgs(@Vector(33, f32), .{
                -0x1.4eddccp-116, 0x1.724e18p-94,  -0x1.9d40bep54,  -0x1.0afc5p-14,
                0x1.576c2p92,     0x1.cf52b6p110,  -0x1.7e67ep117,  -0x1.7db66ep90,
                0x1.3eac22p-38,   0x1.6ba068p72,   -0x1.72dc2cp97,  -0x1.4193f4p72,
                0x1.aa81f6p86,    0x1.984268p53,   -0x1.14ba6ep-45, 0x1.15603ep-122,
                0x1.85e75p-56,    0x1.108a82p-121, 0x1.569ecp62,    -0x1.7f3268p-68,
                -0x1.d0964ep0,    0x0.f7a596p-126, -0x1.367646p-11, 0x1.2065bp-26,
                0x1.cc954ap125,   -0x1.956e1cp65,  0x1.774dep112,   0x1.69dfcep-16,
                -0x1.b0efb2p76,   0x1.14c54p70,    -0x1.7c6b08p25,  0x1.ae20b4p31,
                -0x1.73c584p-118,
            });

            try testArgs(@Vector(1, f64), .{
                0x1.58849bfb1303cp-254,
            });
            try testArgs(@Vector(2, f64), .{
                -0x1.b4a24030f3facp215, -0x1.c1bdddbc41cdep950,
            });
            try testArgs(@Vector(3, f64), .{
                -0x1.7d154dcee386cp-284, -0x1.2fdda9cbabfap-84,
                0x1.00c86a9c3de5cp-46,
            });
            try testArgs(@Vector(4, f64), .{
                0x1.70f298f25a9bfp826,   0x1.4b944832c8eecp-319,
                -0x1.d801afafdbc01p-708, -0x1.65d0b4b097a57p-872,
            });
            try testArgs(@Vector(5, f64), .{
                -0x1.4796bdf4c112bp938, 0x1.3661030c6a2fp-156,
                -0x1.20d194f89bc7fp-9,  -0x1.f545d17a1d9e8p604,
                0x1.c786013e7205ep-514,
            });
            try testArgs(@Vector(7, f64), .{
                -0x1.8f6d6e549941fp501, -0x1.56374640d779p-762,
                -0x1.4ea02d12bd9cfp209, -0x1.ab85b639e78c6p-879,
                -0x1.fcd56fe4f85abp47,  -0x1.8963745584169p-957,
                -0x1.581a8a0033e8p915,
            });
            try testArgs(@Vector(8, f64), .{
                -0x1.2a8fb1782b7f2p-126, -0x1.b246d12815c21p606,
                0x1.6bc24f2a268b9p837,   0x1.1d550478ebd71p1016,
                0x1.d2ba52815edc2p252,   0x1.a8d87e5eb97ecp-450,
                -0x1.c8a3d899aa89p601,   -0x1.1fa47083d9a8fp289,
            });
            try testArgs(@Vector(9, f64), .{
                -0x1.312d39a09757p-567,  -0x1.4b0ef2ac9424ep-10,
                0x1.84302715c6852p930,   -0x1.01565f82fd32p761,
                -0x1.36ad9c057719ap-351, 0x1.dc4929f2400c8p793,
                -0x1.e90f3ae855d3dp-474, 0x1.4e65fb145865ep-834,
                0x1.4236a94937ee3p-987,
            });
            try testArgs(@Vector(15, f64), .{
                0x1.df73a72937309p351,  -0x1.73506ab182b9p-23,
                0x1.b2c954612187p-997,  0x1.7c5ee7c602989p-93,
                -0x1.5edba35428d13p762, -0x1.e3bc1f194dc8cp-386,
                0x1.ca056fb59bdb9p651,  0x1.e59b99b174a0dp-528,
                0x1.7a995c7651aa7p929,  -0x1.a25d3d5153405p413,
                0x1.e5579317d4b37p-50,  0x1.f9d5578c67f67p-90,
                -0x1.5da751d423506p611, 0x1.9a2cba7bf2467p488,
                0x1.db3d45f662c4ep-619,
            });
            try testArgs(@Vector(16, f64), .{
                0x1.fd61de463a33cp898,  -0x1.47be52b4f1241p-18,
                0x1.729aa777312a3p-930, -0x1.2db258cd9984dp895,
                0x1.a1fbc900c10cbp517,  -0x1.e93dfa8923807p815,
                -0x1.e8f19fc0aa2a8p191, -0x1.1b084206321d5p861,
                -0x1.0be3c6310c58ep457, 0x1.816c3bcf4b9f5p-504,
                0x1.ec4b026b00c91p-831, 0x1.e42d18f5c7e4bp924,
                -0x1.f1483ecd74646p560, -0x1.cc5aea97d2264p447,
                -0x1.a0b1e5b69d166p597, 0x1.e9a109fcf1358p694,
            });
            try testArgs(@Vector(17, f64), .{
                -0x1.cd163cf2878e5p-934, -0x1.ce0ad5b67552p196,
                -0x1.da0fd3a62b298p508,  0x1.1981c99b14943p3,
                0x1.d2f6461a9d1a9p390,   -0x1.e8e877d3b4e96p-539,
                -0x1.8ad9d3e185c43p864,  0x1.61786be9783eep-110,
                -0x1.1f4be91d90cc3p-500, 0x1.71cacdd984837p956,
                0x1.7b6ae301fd95ep-661,  0x1.24571ba56e32p343,
                0x1.b1a9454ab9481p648,   -0x1.887873f8044fep842,
                -0x1.2f4ee57b9de22p-967, -0x1.c931346ced885p-983,
                0x1.fe31b9923796bp-772,
            });

            try testArgs(@Vector(1, f80), .{
                -0x1.482098130df28b74p12578,
            });
            try testArgs(@Vector(2, f80), .{
                -0x1.275157565b1eee5ep14003,
                0x1.a27b82ef4be6132ap3681,
            });
            try testArgs(@Vector(3, f80), .{
                0x1.9825fbd9b22021fep-10432,
                -0x1.b8c8c4e5e3911ca8p13568,
                0x1.aa99cc199c8e524p9865,
            });
            try testArgs(@Vector(4, f80), .{
                -0x1.9d8ab0a36953d0f6p-760,
                0x1.869b464121ce6576p-13660,
                0x1.a54b1d1e8ae2b62ap12073,
                -0x1.2abe41c9a9d89ea4p-13141,
            });
            try testArgs(@Vector(5, f80), .{
                0x1.0fb10e205522f5aep-15041,
                -0x1.13e0c338580504dap10809,
                0x1.50e7c6666fd851acp-5508,
                -0x1.e2231120481fc762p-8351,
                0x1.4fae86dc45b06fe2p10741,
            });
            try testArgs(@Vector(7, f80), .{
                -0x1.fe8f8caa4e8697ecp-2992,
                0x1.2623c910a340e286p-14518,
                0x1.c5524642a438569p-9469,
                0x1.3d416ca0a47c73cep2981,
                0x1.a3a1eb1243923114p-6689,
                -0x1.a55df9ded3010b1cp-5798,
                -0x1.3d593df395b03e5ap-14382,
            });
            try testArgs(@Vector(8, f80), .{
                -0x1.9bb73ea024f4167cp3116,
                0x1.adf6241753b29ed2p-4428,
                -0x1.1494fa8680f9f5f4p2008,
                -0x1.c68a673c59edeb24p2377,
                0x1.26c7ab4021afb6dcp1376,
                0x1.c829b0b3935a2ac6p-11758,
                -0x1.11e39b110c2fb122p-3836,
                -0x1.6db14745e291d466p1604,
            });
            try testArgs(@Vector(9, f80), .{
                0x1.f6e537676c132cc6p-10213,
                -0x1.b86eadf24d8c80eep808,
                -0x1.54bc27c9a9a2348cp-2369,
                -0x1.99453820b245bc5p-840,
                -0x1.93c299090fd981e6p-5264,
                -0x1.c742059979281ec4p-6347,
                -0x1.e3efe7b892591d3p-1877,
                -0x1.350c20a2d59c67dap-8972,
                -0x1.e3879f20ffc62ff2p-2600,
            });

            try testArgs(@Vector(1, f128), .{
                -0x1.274ece23c1832bfe66a1bc59cf87p-8354,
            });
            try testArgs(@Vector(2, f128), .{
                0x1.838a4e7ba1e2191cebe701eac5d4p6581,
                0x1.cdfbda51a2adbce757d7c2e0981bp446,
            });
            try testArgs(@Vector(3, f128), .{
                -0x1.ff45938938f76db417c980c368c6p-7215,
                -0x1.277a316793a0172e49c7227952ccp10618,
                0x1.d85027eb4f4ed3512c10bff9a199p-8465,
            });
            try testArgs(@Vector(4, f128), .{
                -0x1.43d8ecf283d4ec6fc4993f385386p-12233,
                -0x1.384424d239aa2ed9719d2c2d1e58p7346,
                -0x1.d33fd11001f0ab6d0f9a2790b41cp14692,
                -0x1.40219a635ef4b042cfb9d7bd9781p900,
            });
            try testArgs(@Vector(5, f128), .{
                -0x1.3273c97faf4619baedaebb51148fp9085,
                -0x1.f381263ad1033a071dff3a143b14p-13649,
                -0x1.24b24810f9a1f9b5d1542e2b5841p1425,
                -0x1.df9e062d482c2bbae0b8fcb07efep-5044,
                -0x1.15cbca8b8384412d7d09ff76bfe4p-2424,
            });
            try testArgs(@Vector(7, f128), .{
                -0x1.0972e6da79fa8bcd49431d813ea5p12192,
                0x1.568e3e61ac4fb17303e4ead041dcp-2542,
                0x1.a55c3f0014942187e6d40c72f12p-13437,
                -0x1.31fb0ec6dbdf7e4ea8ecc307e6f4p13767,
                -0x1.5dcc12514e3e540fea9dbd257935p-8938,
                -0x1.32471cd1d5d2a36e9148a8ce879ap-3274,
                -0x1.3fd3eb6d86a14567e49f358cf029p-4569,
            });
            try testArgs(@Vector(8, f128), .{
                -0x1.05fe5035b415bdc5f8f9ae4c8815p455,
                -0x1.fafde904d5cad82413daee7b88b8p-244,
                0x1.53041230913c654449b12eb4d89bp2214,
                -0x1.12d9f4b006063e9c0c7bdf19f61ap-2483,
                0x1.aee9d4ba013f668773e4f0fd9002p5461,
                0x1.a6776670633403e78a3cc6fcf8fdp8324,
                -0x1.392aa756df3b993ea9db22def53ep15136,
                0x1.823ef104549bdd4624961a44736cp-1097,
            });
            try testArgs(@Vector(9, f128), .{
                -0x1.bde12739521a2bff70e510a6aca3p12384,
                -0x1.0001c77658eb15cd7cb631b4836bp2147,
                -0x1.f24c72b8cde26d95bd40f689a2aep-1416,
                -0x1.61957e7946030c0432af0381f64ap-9492,
                -0x1.631851492fa27fe7adc7441e0d21p16144,
                -0x1.9dd39ece97e7a70c6d36e7e3026p-15761,
                0x1.b044e441d7377755389d0bab3256p-1181,
                0x1.5c11719701b7ff21384fbbf32922p-1671,
                -0x1.1a2944a4dff2a4f96732bf03e8f7p-10567,
            });
        }
    };
}

inline fn boolNot(comptime Type: type, rhs: Type) Type {
    return !rhs;
}
test boolNot {
    const test_bool_not = unary(boolNot, .{});
    try test_bool_not.testBools();
    try test_bool_not.testBoolVectors();
}

inline fn bitNot(comptime Type: type, rhs: Type) Type {
    return ~rhs;
}
test bitNot {
    const test_bit_not = unary(bitNot, .{});
    try test_bit_not.testBools();
    try test_bit_not.testBoolVectors();
    try test_bit_not.testInts();
    try test_bit_not.testIntVectors();
}

inline fn clz(comptime Type: type, rhs: Type) Log2IntCeil(Type) {
    return @clz(rhs);
}
test clz {
    const test_clz = unary(clz, .{});
    try test_clz.testInts();
    try test_clz.testIntVectors();
}

inline fn ctz(comptime Type: type, rhs: Type) Log2IntCeil(Type) {
    return @ctz(rhs);
}
test ctz {
    const test_ctz = unary(ctz, .{});
    try test_ctz.testInts();
    try test_ctz.testIntVectors();
}

inline fn popCount(comptime Type: type, rhs: Type) Log2IntCeil(Type) {
    return @popCount(rhs);
}
test popCount {
    const test_pop_count = unary(popCount, .{});
    try test_pop_count.testInts();
    try test_pop_count.testIntVectors();
}

inline fn byteSwap(comptime Type: type, rhs: Type) RoundBitsUp(Type, 8) {
    return @byteSwap(@as(RoundBitsUp(Type, 8), rhs));
}
test byteSwap {
    const test_byte_swap = unary(byteSwap, .{});
    try test_byte_swap.testInts();
    try test_byte_swap.testIntVectors();
}

inline fn bitReverse(comptime Type: type, rhs: Type) Type {
    return @bitReverse(rhs);
}
test bitReverse {
    const test_bit_reverse = unary(bitReverse, .{});
    try test_bit_reverse.testInts();
    try test_bit_reverse.testIntVectors();
}

inline fn sqrt(comptime Type: type, rhs: Type) Type {
    return @sqrt(rhs);
}
test sqrt {
    const test_sqrt = unary(sqrt, .{ .libc_name = "sqrt", .compare = .approx });
    try test_sqrt.testFloats();
    try test_sqrt.testFloatVectors();
}

inline fn sin(comptime Type: type, rhs: Type) Type {
    return @sin(rhs);
}
test sin {
    const test_sin = unary(sin, .{ .libc_name = "sin", .compare = .strict });
    try test_sin.testFloats();
    try test_sin.testFloatVectors();
}

inline fn cos(comptime Type: type, rhs: Type) Type {
    return @cos(rhs);
}
test cos {
    const test_cos = unary(cos, .{ .libc_name = "cos", .compare = .strict });
    try test_cos.testFloats();
    try test_cos.testFloatVectors();
}

inline fn tan(comptime Type: type, rhs: Type) Type {
    return @tan(rhs);
}
test tan {
    const test_tan = unary(tan, .{ .libc_name = "tan", .compare = .strict });
    try test_tan.testFloats();
    try test_tan.testFloatVectors();
}

inline fn exp(comptime Type: type, rhs: Type) Type {
    return @exp(rhs);
}
test exp {
    const test_exp = unary(exp, .{ .libc_name = "exp", .compare = .strict });
    try test_exp.testFloats();
    try test_exp.testFloatVectors();
}

inline fn exp2(comptime Type: type, rhs: Type) Type {
    return @exp2(rhs);
}
test exp2 {
    const test_exp2 = unary(exp2, .{ .libc_name = "exp2", .compare = .strict });
    try test_exp2.testFloats();
    try test_exp2.testFloatVectors();
}

inline fn log(comptime Type: type, rhs: Type) Type {
    return @log(rhs);
}
test log {
    const test_log = unary(log, .{ .libc_name = "log", .compare = .strict });
    try test_log.testFloats();
    try test_log.testFloatVectors();
}

inline fn log2(comptime Type: type, rhs: Type) Type {
    return @log2(rhs);
}
test log2 {
    const test_log2 = unary(log2, .{ .libc_name = "log2", .compare = .strict });
    try test_log2.testFloats();
    try test_log2.testFloatVectors();
}

inline fn log10(comptime Type: type, rhs: Type) Type {
    return @log10(rhs);
}
test log10 {
    const test_log10 = unary(log10, .{ .libc_name = "log10", .compare = .strict });
    try test_log10.testFloats();
    try test_log10.testFloatVectors();
}

inline fn abs(comptime Type: type, rhs: Type) AsSignedness(Type, .unsigned) {
    return @abs(rhs);
}
test abs {
    const test_abs = unary(abs, .{ .compare = .strict });
    try test_abs.testInts();
    try test_abs.testIntVectors();
    try test_abs.testFloats();
    try test_abs.testFloatVectors();
}

inline fn floor(comptime Type: type, rhs: Type) Type {
    return @floor(rhs);
}
test floor {
    const test_floor = unary(floor, .{ .libc_name = "floor", .compare = .strict });
    try test_floor.testFloats();
    try test_floor.testFloatVectors();
}

inline fn ceil(comptime Type: type, rhs: Type) Type {
    return @ceil(rhs);
}
test ceil {
    const test_ceil = unary(ceil, .{ .libc_name = "ceil", .compare = .strict });
    try test_ceil.testFloats();
    try test_ceil.testFloatVectors();
}

inline fn round(comptime Type: type, rhs: Type) Type {
    return @round(rhs);
}
test round {
    const test_round = unary(round, .{ .libc_name = "round", .compare = .strict });
    try test_round.testFloats();
    try test_round.testFloatVectors();
}

inline fn trunc(comptime Type: type, rhs: Type) Type {
    return @trunc(rhs);
}
test trunc {
    const test_trunc = unary(trunc, .{ .libc_name = "trunc", .compare = .strict });
    try test_trunc.testFloats();
    try test_trunc.testFloatVectors();
}

inline fn negate(comptime Type: type, rhs: Type) Type {
    return -rhs;
}
test negate {
    const test_negate = unary(negate, .{ .compare = .strict });
    try test_negate.testFloats();
    try test_negate.testFloatVectors();
}

inline fn nullIsNull(comptime Type: type, _: Type) bool {
    return runtime(?Type, null) == null;
}
test nullIsNull {
    const test_null_is_null = unary(nullIsNull, .{});
    try test_null_is_null.testIntTypes();
    try test_null_is_null.testIntVectorTypes();
    try test_null_is_null.testFloatTypes();
    try test_null_is_null.testFloatVectorTypes();
}

inline fn nullIsNotNull(comptime Type: type, _: Type) bool {
    return runtime(?Type, null) != null;
}
test nullIsNotNull {
    const test_null_is_not_null = unary(nullIsNotNull, .{});
    try test_null_is_not_null.testIntTypes();
    try test_null_is_not_null.testIntVectorTypes();
    try test_null_is_not_null.testFloatTypes();
    try test_null_is_not_null.testFloatVectorTypes();
}

inline fn optionalIsNull(comptime Type: type, lhs: Type) bool {
    return @as(?Type, lhs) == null;
}
test optionalIsNull {
    const test_optional_is_null = unary(optionalIsNull, .{});
    try test_optional_is_null.testInts();
    try test_optional_is_null.testFloats();
}

inline fn optionalIsNotNull(comptime Type: type, lhs: Type) bool {
    return @as(?Type, lhs) != null;
}
test optionalIsNotNull {
    const test_optional_is_not_null = unary(optionalIsNotNull, .{});
    try test_optional_is_not_null.testInts();
    try test_optional_is_not_null.testFloats();
}

inline fn nullEqualNull(comptime Type: type, _: Type) bool {
    return runtime(?Type, null) == runtime(?Type, null);
}
test nullEqualNull {
    const test_null_equal_null = unary(nullEqualNull, .{});
    try test_null_equal_null.testIntTypes();
    try test_null_equal_null.testFloatTypes();
}

inline fn nullNotEqualNull(comptime Type: type, _: Type) bool {
    return runtime(?Type, null) != runtime(?Type, null);
}
test nullNotEqualNull {
    const test_null_not_equal_null = unary(nullNotEqualNull, .{});
    try test_null_not_equal_null.testIntTypes();
    try test_null_not_equal_null.testFloatTypes();
}

inline fn optionalEqualNull(comptime Type: type, lhs: Type) bool {
    return lhs == runtime(?Type, null);
}
test optionalEqualNull {
    const test_optional_equal_null = unary(optionalEqualNull, .{});
    try test_optional_equal_null.testInts();
    try test_optional_equal_null.testFloats();
}

inline fn optionalNotEqualNull(comptime Type: type, lhs: Type) bool {
    return lhs != runtime(?Type, null);
}
test optionalNotEqualNull {
    const test_optional_not_equal_null = unary(optionalIsNotNull, .{});
    try test_optional_not_equal_null.testInts();
    try test_optional_not_equal_null.testFloats();
}

inline fn reduceAnd(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.And, rhs);
}
test reduceAnd {
    const test_reduce_and = unary(reduceAnd, .{});
    try test_reduce_and.testBoolVectors();
    try test_reduce_and.testIntVectors();
}

inline fn reduceOr(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.Or, rhs);
}
test reduceOr {
    const test_reduce_or = unary(reduceOr, .{});
    try test_reduce_or.testBoolVectors();
    try test_reduce_or.testIntVectors();
}

inline fn reduceXor(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.Xor, rhs);
}
test reduceXor {
    const test_reduce_xor = unary(reduceXor, .{});
    try test_reduce_xor.testBoolVectors();
    try test_reduce_xor.testIntVectors();
}

inline fn reduceMinUnoptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.Min, rhs);
}
test reduceMinUnoptimized {
    const test_reduce_min_unoptimized = unary(reduceMinUnoptimized, .{});
    try test_reduce_min_unoptimized.testIntVectors();
    try test_reduce_min_unoptimized.testFloatVectors();
}

inline fn reduceMaxUnoptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.Max, rhs);
}
test reduceMaxUnoptimized {
    const test_reduce_max_unoptimized = unary(reduceMaxUnoptimized, .{});
    try test_reduce_max_unoptimized.testIntVectors();
    try test_reduce_max_unoptimized.testFloatVectors();
}

inline fn reduceAddUnoptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.Add, rhs);
}
test reduceAddUnoptimized {
    const test_reduce_add_unoptimized = unary(reduceAddUnoptimized, .{});
    try test_reduce_add_unoptimized.testIntVectors();
    try test_reduce_add_unoptimized.testFloatVectors();
}

inline fn reduceMulUnoptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    return @reduce(.Mul, rhs);
}
test reduceMulUnoptimized {
    const test_reduce_mul_unoptimized = unary(reduceMulUnoptimized, .{});
    try test_reduce_mul_unoptimized.testIntVectors();
    try test_reduce_mul_unoptimized.testFloatVectors();
}

inline fn reduceMinOptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    @setFloatMode(.optimized);
    return @reduce(.Min, rhs);
}
test reduceMinOptimized {
    const test_reduce_min_optimized = unary(reduceMinOptimized, .{});
    try test_reduce_min_optimized.testFloatVectors();
}

inline fn reduceMaxOptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    @setFloatMode(.optimized);
    return @reduce(.Max, rhs);
}
test reduceMaxOptimized {
    const test_reduce_max_optimized = unary(reduceMaxOptimized, .{});
    try test_reduce_max_optimized.testFloatVectors();
}

inline fn reduceAddOptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    @setFloatMode(.optimized);
    return @reduce(.Add, rhs);
}
test reduceAddOptimized {
    const test_reduce_add_optimized = unary(reduceAddOptimized, .{ .compare = .approx });
    try test_reduce_add_optimized.testFloatVectors();
}

inline fn reduceMulOptimized(comptime Type: type, rhs: Type) @typeInfo(Type).vector.child {
    @setFloatMode(.optimized);
    return @reduce(.Mul, rhs);
}
test reduceMulOptimized {
    const test_reduce_mul_optimized = unary(reduceMulOptimized, .{ .compare = .approx_or_overflow });
    try test_reduce_mul_optimized.testFloatVectors();
}

inline fn splat(comptime Type: type, rhs: Type) Type {
    return @splat(rhs[0]);
}
test splat {
    const test_splat = unary(splat, .{});
    try test_splat.testIntVectors();
    try test_splat.testFloatVectors();
}
