---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, 
              style de la bibliographie, espace, items
---

# Comment changer l'espace entre les items ?

Comme une bibliographie est en fait un environnement de type `list`, 
l'idée revient à simplement augmenter la valeur de la variable `\itemsep` 
en charge de cet espace entre deux items consécutifs. Toutefois, 
cette modification doit être faite *à l'intérieur* de l'environnement 
`thebibliography`. Voici deux possibilités découlant de cette idée.


## Modification du fichier BBL

Vous pouvez ajouter la commande suivante dans le fichier BBL, juste 
après le début de l'environnement `thebibliography`.

```{noedit}
\addtolength\itemsep{1ex}
```

Il faut ici noter que toute mise à jour de la bibliographie supprimera 
cette ligne (le fichier BBL étant totalement regénéré) 
et qu'elle n'est donc utile que pour un document finalisé.


## Redéfinition de l'environnement `thebibliography`

Vous pouvez également redéfinir l'environnement `thebibliography`. 
Voici un exemple d'une telle redéfinition (ici, en langage TeX 
comme le montre la présence de la commande `\let`) :

```{noedit}
\let\oldtb=\thebibliography
\def\thebibliography#1{\oldtb{#1}%
           \addtolength\itemsep{1ex}}
```

:::{todo} Ajouter un exemple.
:::


:::{seealso}
Pour en savoir plus sur la mise en forme des listes, vous pouvez consulter
la section "[](/3_composition/texte/listes/start)".
:::