/*
 * Copyright © 2022 Codethink Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <wayland-client.h>

#include "backend.h"
#include "ivi-wm-client-protocol.h"

struct wayland_screen {
  struct wl_output *output;
  struct ivi_wm_screen *wm_screen;
  int width, height, offset_x, offset_y;
  struct wl_list link;
  int id_screen;
};

struct wayland_data {
  struct wl_display *display;
  struct wl_event_queue *queue;
  struct wl_registry *registry;
  struct ivi_wm *wm;
  struct wl_list output_list;
};

struct screenshot {
  unsigned char *data;
  int width, height, stride;
  int done;
};

void ilm_list_screens(char *reply);
int ilm_grab_fb(qad_screen_buffer_t *screen_buffer, int screen);
int ilm_create_backend(qad_backend_screen_t *backend);
void ilm_destroy_backend();
