# CHANGELOG


## v3.12.0 (2025-08-18)

### Documentation

- **vtklocal**: Add push camera example
  ([`0c45443`](https://github.com/Kitware/trame/commit/0c45443151b42bb8d2fab9a333ff5d8c56dc6c91))

- **widgets**: Update listing
  ([`e89182a`](https://github.com/Kitware/trame/commit/e89182a24a999223877c7bf5906c789590fee795))

### Features

- **tools**: Add a retry tool for launcher
  ([`c3110e5`](https://github.com/Kitware/trame/commit/c3110e5f8bc1265d2fbea53d7ebd899dd8fab887))


## v3.11.0 (2025-07-24)

### Documentation

- Update wasm to use script notation
  ([`5317d1a`](https://github.com/Kitware/trame/commit/5317d1a78c2d72dfb1d3d3a891759ab153284138))

- **pv**: Update to vue3
  ([`40bc0bf`](https://github.com/Kitware/trame/commit/40bc0bf0ea3381dc99b39ea0eefeaaee4ecd2367))

- **wasm**: Add link to wasm website
  ([`ab901d0`](https://github.com/Kitware/trame/commit/ab901d0d1898be39b68445ce7c51b779de66f275))

- **widgets**: Add dockview
  ([`fc8ff92`](https://github.com/Kitware/trame/commit/fc8ff9231a19c3ce192e187efae090717dccea6b))

### Features

- **jupyter**: Add css helper
  ([`c5fecb9`](https://github.com/Kitware/trame/commit/c5fecb9414194ceae76ca27ed5665b6bca08b1ed))


## v3.10.2 (2025-06-06)

### Bug Fixes

- **assets**: Expose download_file_from_google_drive
  ([`351d13b`](https://github.com/Kitware/trame/commit/351d13b7a44e7606bd0acef01abb6f595e801593))

### Continuous Integration

- Try to fix rtd
  ([`bd48e8b`](https://github.com/Kitware/trame/commit/bd48e8bfb9b6557a871c0c31b0aceef7381e5ce7))

### Documentation

- Update basic example with new TrameApp
  ([`3a7f8f2`](https://github.com/Kitware/trame/commit/3a7f8f2e9740eb243018a4fb63f784e7e82b8124))

- Update cone docker app image
  ([`36be943`](https://github.com/Kitware/trame/commit/36be9438d2d9063659c8f0f20731b08985befe91))

- Update plotly and docker
  ([`12291ec`](https://github.com/Kitware/trame/commit/12291ec655c99c05b0f07ba379b5f76b8c84af24))

- Upgrade sample code on website
  ([`615c85f`](https://github.com/Kitware/trame/commit/615c85f02b733f6cc69bf5c4fb7cad6b6b3dd242))

- **jupyter**: Update example with TrameApp
  ([`8b4cf3a`](https://github.com/Kitware/trame/commit/8b4cf3a28ee511c5d70a02f1020dcda73e57dd24))

- **website**: Add activity section and update news
  ([`1361bbc`](https://github.com/Kitware/trame/commit/1361bbc2c76607fe8f110beac3aeeb5ccc780f65))


## v3.10.1 (2025-05-28)

### Bug Fixes

- **vtk**: Return import error
  ([`73b9a34`](https://github.com/Kitware/trame/commit/73b9a34c63f104e450728fae607d490a886a2bf1))


## v3.10.0 (2025-05-28)

### Features

- **vtk**: Add tool for displaying rendering capabilities
  ([`e644c0f`](https://github.com/Kitware/trame/commit/e644c0f3ba0a58eca78c7bcb2e04cf4cbea3dcbb))


## v3.9.1 (2025-05-27)

### Bug Fixes

- **common**: Update dep version on trame-common
  ([`f72ea0e`](https://github.com/Kitware/trame/commit/f72ea0e62a5afc461428dd13b22ed2538c733716))

### Chores

- **deps-dev**: Bump vite from 4.5.11 to 4.5.13 in /docs/vitepress
  ([`f2f2a04`](https://github.com/Kitware/trame/commit/f2f2a0499f5835f652cc36d8401ba5bd6ba7a159))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.5.11 to 4.5.13. -
  [Release notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.13/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.13/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-version: 4.5.13

dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

- **deps-dev**: Bump vite from 4.5.13 to 4.5.14 in /docs/vitepress
  ([`a7d19b8`](https://github.com/Kitware/trame/commit/a7d19b878a3622b8135c5c19e5617af3d9c5ce36))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.5.13 to 4.5.14. -
  [Release notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.14/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.14/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-version: 4.5.14

dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

- **docker**: Add option to configure launcher timeout
  ([`9dd07cc`](https://github.com/Kitware/trame/commit/9dd07ccdde520a5bc5b7fbc53b5a60e2515ba9fb))

### Continuous Integration

- Make docker.yml exec manual
  ([`6898ffa`](https://github.com/Kitware/trame/commit/6898ffafccc613094f6794038578e8030ee913a5))

- **docker**: Add uv setup
  ([`ace80cd`](https://github.com/Kitware/trame/commit/ace80cd33466c78a7529a91f221bd0d00fb52d18))

### Documentation

- Add trame-alerts in known available widgets
  ([`9fd77df`](https://github.com/Kitware/trame/commit/9fd77dfec4118920710ccefa4415451f0299cc04))

- Update website
  ([`eca8cb7`](https://github.com/Kitware/trame/commit/eca8cb7364abc2525f8ac603e65a1696610ce530))

- **html**: Precise the usage of parentheses for expressions
  ([`081dbe9`](https://github.com/Kitware/trame/commit/081dbe9f3ab06554cb43b2fb0a6abd6f8f6b686f))

- **wasm**: Add example
  ([`8afb47b`](https://github.com/Kitware/trame/commit/8afb47bcfe14e9c2952772bffde1d25a1ea0add1))

- **wasm**: Add example
  ([`e39eb87`](https://github.com/Kitware/trame/commit/e39eb877e166bfcf38ee33fe64e476933ef2d87a))

- **wasm**: Add example
  ([`b60b429`](https://github.com/Kitware/trame/commit/b60b4295061e32a16f441fdf0bc6f4834fa460f9))

- **wasm**: Add example
  ([`9fee106`](https://github.com/Kitware/trame/commit/9fee106efd27d56bacd0948ecbef4104554f701f))

- **wasm**: Add example
  ([`6646477`](https://github.com/Kitware/trame/commit/66464776455da64f542ea834af19fafc4549230f))


## v3.9.0 (2025-04-25)

### Bug Fixes

- **client**: Bump client to get v_on
  ([`863c052`](https://github.com/Kitware/trame/commit/863c0527231bf46d5acafcf3f977e66ff93409a7))

- **import**: Circular import in trame.app
  ([`61c5960`](https://github.com/Kitware/trame/commit/61c59601d86ec58f5412c08b8fd41aab868f7006))

### Code Style

- **ruff**: Import sort
  ([`b7a4ce8`](https://github.com/Kitware/trame/commit/b7a4ce87a6f95d4cb32d20fa722b9f7c63aab781))

- **ruff**: Reformat helper scripts
  ([`5190d77`](https://github.com/Kitware/trame/commit/5190d774855ab51795924597e3943abfaa412ed0))

### Documentation

- **discussion**: Add example 707
  ([`a684a5b`](https://github.com/Kitware/trame/commit/a684a5b0a6269919336afd0c1c35f794e31fc459))

- **examples**: Fix image path in readmes
  ([`37a9e38`](https://github.com/Kitware/trame/commit/37a9e38e3d762b77ddce7cc9bc6f53f4f218611d))

- **examples**: Images
  ([`0c154b2`](https://github.com/Kitware/trame/commit/0c154b29524075dd616057bf5d3d35c22f7fe8bb))

- **examples**: Images
  ([`9c7618b`](https://github.com/Kitware/trame/commit/9c7618b9313646c0b6a05dd1cbe396125f5cb6a2))

- **examples**: Images
  ([`0bc5c30`](https://github.com/Kitware/trame/commit/0bc5c30b7c77e48999a283cbef475ad5eb163eb8))

- **examples**: Images
  ([`26c69da`](https://github.com/Kitware/trame/commit/26c69dace91a34d42bb2a92fb6a83e496a8bf120))

- **examples**: Images
  ([`daed428`](https://github.com/Kitware/trame/commit/daed428b41cc254dce79c4abb07a6f736fc90b9d))

- **examples**: Reformat using ruff and sorting import
  ([`74b0276`](https://github.com/Kitware/trame/commit/74b0276384e001ded22b91f182b5114e79e597b3))

### Features

- **common**: Leverage trame-common for utility class/function
  ([`61b60a9`](https://github.com/Kitware/trame/commit/61b60a9b5e5f669ea2d89ea0fd005c2423809b24))

__New Features__: - Add dependency to trame-common for providing generic classes that can be
  relevant across trame packages. This includes assets handling, execution helper (throttle, async
  task), decorators and abstract classes for building components or apps. - Expose new TrameApp and
  TrameComponent classes from trame.app to simplify the creation of trame pieces when using
  inheritance instead of the @TrameApp() decorator.

__Deprecation and cleanup__ - trame.app.dev should be deprecated/removed but for now we just remove
  a method that has been broken for quite some time. In general that package is fairly advanced and
  internal. It should not be needed by 99.99% of folks. - trame.app.jupyter has been removed since
  the Jupyter integration is directly part of the layouts and that package should not be used
  anymore.

### Testing

- Update endlines
  ([`834fab6`](https://github.com/Kitware/trame/commit/834fab6818d2e7d812f9129d803bc59695f308c1))


## v3.8.2 (2025-04-10)

### Bug Fixes

- **yaml**: Add missing dependency for tools.widget
  ([`5d0e0c7`](https://github.com/Kitware/trame/commit/5d0e0c7675e3d73366cfcc50127d076b102085c4))

### Build System

- Install `gosu` from `tianon/gosu` image instead of ap
  ([`dc12610`](https://github.com/Kitware/trame/commit/dc12610b4224ab1e1b330b485bdd588e15ac3234))

- **ci**: Build Python 3.12 images on top of Ubuntu 24.04
  ([`1c0f557`](https://github.com/Kitware/trame/commit/1c0f55789efd4694f4e9778e2a61d14a0276c18c))

### Chores

- **deps-dev**: Bump vite from 4.5.9 to 4.5.11 in /docs/vitepress
  ([`cee0585`](https://github.com/Kitware/trame/commit/cee058512c48a7defb74132f220ae1dc6553b31d))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.5.9 to 4.5.11. -
  [Release notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.11/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.11/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Documentation

- Update community.md
  ([`095f86f`](https://github.com/Kitware/trame/commit/095f86fe07cb34672087cf845580c66e5117a3ce))

- **citing**: Add citing information
  ([`18368d3`](https://github.com/Kitware/trame/commit/18368d3136b8684230d4d7f06eb1c069672cb336))

- **examples**: Ruff + add deep reactive
  ([`6b1a595`](https://github.com/Kitware/trame/commit/6b1a595a97aef8714af6688f1a5ce9c88f3cfd8e))

- **launcher**: Update instructions to make the launcher example works
  ([`6d67d21`](https://github.com/Kitware/trame/commit/6d67d21adc8798371fd6c1eaeb712a6b3ffb95f2))

- **parsli**: Add parsli to the community page
  ([`3c815e2`](https://github.com/Kitware/trame/commit/3c815e22eb3541c9317218aecec5597ec4574559))


## v3.8.1 (2025-03-08)

### Bug Fixes

- **tools**: Fix indent for widget generation
  ([`e9ed78b`](https://github.com/Kitware/trame/commit/e9ed78bddc61a3ed960d3f8d635465c532c2a9a1))

### Continuous Integration

- Add commit message validation hook
  ([`96fbedb`](https://github.com/Kitware/trame/commit/96fbedbc8fb4e6e2de072f287d382916de591654))

- Build Python 3.11 docker image ([#676](https://github.com/Kitware/trame/pull/676),
  [`d4888e3`](https://github.com/Kitware/trame/commit/d4888e3c64c309c9b61f87ea2f4f1a42b23bae4c))

### Documentation

- **drilldown**: Add Drill Down to community page
  ([`0845e47`](https://github.com/Kitware/trame/commit/0845e4793780b9d8ed6625ff15f93d77a9960ebe))

- **example**: Load style for missing font
  ([`7ec0e6f`](https://github.com/Kitware/trame/commit/7ec0e6fb3a82ee062565a11e97a77d83440ebc60))

- **examples**: Fix vue3 vuetify datatable example
  ([`4ff6b19`](https://github.com/Kitware/trame/commit/4ff6b19d6a46e61e6a89d737b53c3d57f262f416))


## v3.8.0 (2025-02-04)

### Chores

- **deps-dev**: Bump vite from 4.5.3 to 4.5.9 in /docs/vitepress
  ([`b34a4b2`](https://github.com/Kitware/trame/commit/b34a4b26a3506fc368f632ff4d86b9fab8d6e290))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.5.3 to 4.5.9. - [Release
  notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.9/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.9/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Continuous Integration

- Try to fix website update
  ([`e239c53`](https://github.com/Kitware/trame/commit/e239c53332bf9f2ac42bc45bee3d3b00ee455ba2))

- Update website upload action
  ([`e8d010e`](https://github.com/Kitware/trame/commit/e8d010e87359fbdae9ca0207aea9c1daac5e594a))

### Documentation

- **ai**: Add chat bot
  ([`f0c1989`](https://github.com/Kitware/trame/commit/f0c1989c00b7f750aa4c11de806e553793704da0))

- **docker**: Update base image
  ([`1528091`](https://github.com/Kitware/trame/commit/15280919ab22d2448f77b87d98f9585f830a054f))

- **guide**: Update 'Forcing state exchange' section
  ([`5ec0c85`](https://github.com/Kitware/trame/commit/5ec0c859511944ef129f65b9853f3012e2159da9))

- **multi-view**: Trigger 2 render
  ([`445c7b8`](https://github.com/Kitware/trame/commit/445c7b85109db7a459ab01d8e67bd3aa143e0378))

### Features

- **TrameApp**: Avoid intermediate class
  ([`1af1fd8`](https://github.com/Kitware/trame/commit/1af1fd87a879ff8fa27608a6c4fd895c968da7fc))

- **TrameApp**: Support decorated class inheritance
  ([`7e7b9ff`](https://github.com/Kitware/trame/commit/7e7b9ff5457cd534eee326d8e82bd016889b1db6))


## v3.7.6 (2025-01-01)

### Bug Fixes

- **tools**: Using google syntax in widget generator
  ([`6b21e99`](https://github.com/Kitware/trame/commit/6b21e9919e9858df489ecd9f92416fb2f3dc5b6b))

### Documentation

- **rtd**: Update python version
  ([`a8ed1e2`](https://github.com/Kitware/trame/commit/a8ed1e2537e212c3726635d4d0b9c352934247af))

- **widgets**: Move trame-router and small tweaks
  ([`3e9072c`](https://github.com/Kitware/trame/commit/3e9072cde1c495b143cfc176949de2e35616f8e1))


## v3.7.5 (2024-12-30)

### Bug Fixes

- License string
  ([`cf94c77`](https://github.com/Kitware/trame/commit/cf94c777a463ac816c79baf74c06d8f7eec2fb78))


## v3.7.4 (2024-12-29)

### Bug Fixes

- **ci**: Pypi publish
  ([`7834633`](https://github.com/Kitware/trame/commit/78346332f559dd5e5a6533291b5e806f00b63181))

### Continuous Integration

- Update action version
  ([`e5faf52`](https://github.com/Kitware/trame/commit/e5faf527163d5534dc7c3f27d0e8552baf48820c))


## v3.7.3 (2024-12-29)

### Bug Fixes

- **ci**: Pypi publish step
  ([`d3f0275`](https://github.com/Kitware/trame/commit/d3f027564c70a7225c4321b50fa32481f70b5ce0))


## v3.7.2 (2024-12-29)

### Bug Fixes

- Migrate to pyproject
  ([`7fcf67a`](https://github.com/Kitware/trame/commit/7fcf67ae2d86bed3ce8d9fb03662e8656ab6c756))

### Continuous Integration

- Start using ruff
  ([`49ca9ed`](https://github.com/Kitware/trame/commit/49ca9ed6682f24c55e4d371bcd41169be2935cab))

### Documentation

- Image update
  ([`277af15`](https://github.com/Kitware/trame/commit/277af15ef48d8b706cd0c2abe3f1e8dd375eb745))

- **652**: Add discussion code
  ([`aa457e5`](https://github.com/Kitware/trame/commit/aa457e596972592290b791e852a6b3957ee8a59e))

- **discussion**: Add answer to 655
  ([`fc3f5ef`](https://github.com/Kitware/trame/commit/fc3f5efd7e55aec8a2dc991487df80400875f081))

- **example**: Update 03_advanced_git_tree.py
  ([`ef6abea`](https://github.com/Kitware/trame/commit/ef6abeac81630440b1977121d70286e888108f50))

- **visualizer**: Add text to reach out
  ([`4a933bd`](https://github.com/Kitware/trame/commit/4a933bd4415d78e93e3949a662a7d4d9ac0dd672))

- **widgets**: Add disclaimer
  ([`e8dafc8`](https://github.com/Kitware/trame/commit/e8dafc8f4f2de016fdc61f90db44d99a304031a6))

- **widgets**: Add goldenlayout, annotations, large-image
  ([`e487564`](https://github.com/Kitware/trame/commit/e4875643084b5b5bcdcb87c3a3fb4350254e2edf))

- **widgets**: Add trame-gwc
  ([`ba10079`](https://github.com/Kitware/trame/commit/ba10079487d9e3676dcf729f98f4fb072fdfbdf4))

- **widgets**: Add trame-react
  ([`dbbb97a`](https://github.com/Kitware/trame/commit/dbbb97a5a5bcdbb492bd24ed3bb8960a7b150d0a))

- **widgets**: Split widgets into sections
  ([`202c4e0`](https://github.com/Kitware/trame/commit/202c4e01d94332521961abd5c2393c9536cb513c))

Add links to repos. Add tooltips


## v3.7.1 (2024-12-05)

### Bug Fixes

- **pypi**: Update README.rst
  ([`53147af`](https://github.com/Kitware/trame/commit/53147afa70599f1f5114b3c917900006e02100db))

### Documentation

- Update arrowflow image
  ([`a691d12`](https://github.com/Kitware/trame/commit/a691d120b8550631742229d31dcd6013327252f2))

- **news**: Update news with images
  ([`b6f5d75`](https://github.com/Kitware/trame/commit/b6f5d751f3b5020e80de07f3d1e898f7e5bde377))

- **news**: Update the news
  ([`aeb3544`](https://github.com/Kitware/trame/commit/aeb3544a03e95de71424d6a5250c6319300ce8b3))

- **readme**: Introducing Trame Guru on Gurubase.io
  ([#635](https://github.com/Kitware/trame/pull/635),
  [`55c67da`](https://github.com/Kitware/trame/commit/55c67daa1126cb497e5b82fad7d236d41f4e3e9c))

Signed-off-by: Kursat Aktas <kursat.ce@gmail.com>


## v3.7.0 (2024-10-20)

### Chores

- **deps-dev**: Bump rollup from 3.29.1 to 3.29.5 in /docs/vitepress
  ([#598](https://github.com/Kitware/trame/pull/598),
  [`ff0966f`](https://github.com/Kitware/trame/commit/ff0966ff4a4328198114a9e8ee2d7674c1d401a8))

Bumps [rollup](https://github.com/rollup/rollup) from 3.29.1 to 3.29.5. - [Release
  notes](https://github.com/rollup/rollup/releases) -
  [Changelog](https://github.com/rollup/rollup/blob/master/CHANGELOG.md) -
  [Commits](https://github.com/rollup/rollup/compare/v3.29.1...v3.29.5)

--- updated-dependencies: - dependency-name: rollup dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

### Continuous Integration

- **docker**: Fix runtime_patch to properly remap trame-user
  ([`e1b4395`](https://github.com/Kitware/trame/commit/e1b4395502e201a6dd6b6536b77b1ac7a8735ab8))

- **docker**: Trame-user ownership fix
  ([`2876cbd`](https://github.com/Kitware/trame/commit/2876cbd0b0ad47db7858e4b5abe08657a0abff2a))

- **docker**: Update ownership of /deploy
  ([`c91bcbb`](https://github.com/Kitware/trame/commit/c91bcbb506a61a2267026daadd7b26cad986f02a))

### Documentation

- **blogs**: Add sample code we use to showcase blogs
  ([`d7596fb`](https://github.com/Kitware/trame/commit/d7596fb896b51a00870a239ef1ffcf41192a4255))

- **example**: Busy task
  ([`6bf226a`](https://github.com/Kitware/trame/commit/6bf226afa88436d94f000a4bfc8827d5d7b6f170))

- **example**: Fetch data from remote url
  ([`c20ea0e`](https://github.com/Kitware/trame/commit/c20ea0ee999dbd98193f82475d4231dbb6875df6))

- **example**: Fix chart height issue
  ([`0fd5bd0`](https://github.com/Kitware/trame/commit/0fd5bd0d40e76e0e2479f02ba622f15099cd02be))

- **example**: Update blog code sample
  ([`74a5162`](https://github.com/Kitware/trame/commit/74a51621e0fe00462ebb7790d7159506616642d6))

- **example**: Update blog code sample
  ([`136a26b`](https://github.com/Kitware/trame/commit/136a26b94c1e1ee1f52c37d9b41ea5c5ea3d91b5))

- **examples**: Improve some examples
  ([`b337de2`](https://github.com/Kitware/trame/commit/b337de24d944dcddc9a975c36c8aa435e79fb35e))

- **webinar**: Add jupyter examples
  ([`1a729dd`](https://github.com/Kitware/trame/commit/1a729dd7210de014990b3ff01979e8d6f95d497b))

### Features

- **client**: Update client to enable deepReactive
  ([`5a13239`](https://github.com/Kitware/trame/commit/5a132391d315271e220e49394ae1096672c78e8c))


## v3.6.5 (2024-09-09)

### Bug Fixes

- **tools.serve**: Resolve another coroutine
  ([`99a9c97`](https://github.com/Kitware/trame/commit/99a9c97826cedb6d43c9b4927bef036cf8ae519f))


## v3.6.4 (2024-09-09)

### Bug Fixes

- **tools.serve**: Resolve coroutine
  ([`11795b6`](https://github.com/Kitware/trame/commit/11795b601e7a79fdbc76b831cf54b5521ab773f0))

### Chores

- **docker**: Add fallback resource for vue router
  ([`799f388`](https://github.com/Kitware/trame/commit/799f388699ea9744b7b47dcdc6dd13e10eb288d7))

- **docker**: Add session monitor
  ([`8c5547d`](https://github.com/Kitware/trame/commit/8c5547d2443194eb82398e8c1379728793a07bef))

- **docker**: Fully support TRAME_URL_PREFIX
  ([`ac7f71f`](https://github.com/Kitware/trame/commit/ac7f71fc23511f19d01c93d7ffeeb86f4cf02af4))

- **docker**: Trame_url_prefix patch <base href>
  ([`bc95b9f`](https://github.com/Kitware/trame/commit/bc95b9f2b0ed5583c243585577cd04aaec487932))

### Continuous Integration

- **docker**: Add rule for API access
  ([`8be9873`](https://github.com/Kitware/trame/commit/8be9873f7e7e310b732d878eee17ec3e1fb98eea))

- **docker**: Try to get docker prefix
  ([`52ecb18`](https://github.com/Kitware/trame/commit/52ecb18df8aa91d75060193607182aecbe315aab))

### Documentation

- **api**: Add vtk for vtklocal doc
  ([`5f60a81`](https://github.com/Kitware/trame/commit/5f60a81a5f75f7f577ab2ed42e33c5b55256fa80))

- **community**: Swap order to put new one at the top
  ([`3db1e64`](https://github.com/Kitware/trame/commit/3db1e64868dc2ea88285126ebc340ff9262e3569))

- **docker**: Add API endpoint with docker
  ([`089e84a`](https://github.com/Kitware/trame/commit/089e84a829be8ad66e2572ec9fc43218987aa008))

- **docker**: Update guide with useful flag to see build log
  ([`ef9b5cc`](https://github.com/Kitware/trame/commit/ef9b5cc769d9e08a777247e5bcbc2aacda3d12da))

- **example**: Update pv voi example
  ([`10ff703`](https://github.com/Kitware/trame/commit/10ff703b2a05a75347ee771b97a0e81daefaccca))

- **news**: Add another entry for feb 2024
  ([`0aa7fb5`](https://github.com/Kitware/trame/commit/0aa7fb5e468f34ee42351637d282d185d86e9ad1))

- **news**: Update page
  ([`c55b9a3`](https://github.com/Kitware/trame/commit/c55b9a37c03cdf7f8363c0cc9cbb31e37810bbc2))

- **readme**: Add professional support
  ([`58a2c7f`](https://github.com/Kitware/trame/commit/58a2c7f96817a6293a9882e4ab6b5b4100fc2ac3))

- **vtklocal**: Add in API
  ([`29b99c1`](https://github.com/Kitware/trame/commit/29b99c1a037fc8ac7b8ef3612873a17c2dcb3749))

- **vuetify**: Add table example for vue3
  ([`6665226`](https://github.com/Kitware/trame/commit/6665226dfbf5f9503ba7b0caee30fcbb015a4d85))

- **website**: Add ImpactX to community page
  ([`a06b8f1`](https://github.com/Kitware/trame/commit/a06b8f19480b4995e2d25734de459d2d9fa8bb04))

We adopted Trame to build a neat, user-facing control dashboard for ImpactX :)

- **website**: Add link to trame services at kitware
  ([`96edf43`](https://github.com/Kitware/trame/commit/96edf43e17153a92ad85a18c298d7923deafa3ee))


## v3.6.3 (2024-06-19)

### Bug Fixes

- **type**: Add type hints in trame.app
  ([`4d6d6b2`](https://github.com/Kitware/trame/commit/4d6d6b2641c2fff86db096ccc0bee3cb702da745))

### Documentation

- **example**: Pv roi
  ([`85c3b5e`](https://github.com/Kitware/trame/commit/85c3b5e1d22280d3f8183ad0c5620bafc1579ba1))

- **readme**: Add conda download badge
  ([`53454f0`](https://github.com/Kitware/trame/commit/53454f01d97b565a174fbf876f29dbfb1120ec48))

- **readme**: Better intro
  ([`5199b10`](https://github.com/Kitware/trame/commit/5199b108b49b1b4ed20bc8d82f38181e160b8f24))

- **readme**: Update readme with stars
  ([`48e5ca1`](https://github.com/Kitware/trame/commit/48e5ca1dbfafee6716617ad91b6995c624612926))

- **widgets**: Update listing of widgets
  ([`9b34817`](https://github.com/Kitware/trame/commit/9b34817adb51b93d843323242c7fae58051d3a91))


## v3.6.2 (2024-06-01)

### Bug Fixes

- **demo**: Update demo to vue3 and add ParaView one
  ([`bcb27ac`](https://github.com/Kitware/trame/commit/bcb27ac819f098d5d9d1809d1be072fccf5f091d))


## v3.6.1 (2024-05-27)

### Bug Fixes

- **tools**: Make www look like a real server
  ([`6c778fc`](https://github.com/Kitware/trame/commit/6c778fcca30b291f0b8ff0f67047af5caf0af6d1))

### Continuous Integration

- Update Dockerfile.common with nvidia env
  ([`f98df78`](https://github.com/Kitware/trame/commit/f98df782efa32e23652f2b994c3301c8670fc98c))

### Documentation

- **495**: Provide discussion example
  ([`be6b63c`](https://github.com/Kitware/trame/commit/be6b63c452ce9aa92bfcbb6f4c24374f04da19e4))

- **black**: Update example formatting
  ([`1e01732`](https://github.com/Kitware/trame/commit/1e0173289aa6aa999102ea7351c0a0f977910b64))

- **community**: Add mri-viewer into community page
  ([`c274800`](https://github.com/Kitware/trame/commit/c27480048d4cb22ec1c448b33c638934f3ad333b))

- **community**: Fix image urls
  ([`b2c095e`](https://github.com/Kitware/trame/commit/b2c095e393c149ff8732b48f42e9f47c264df108))

- **tabler-icons**: Updated example
  ([`80abbe0`](https://github.com/Kitware/trame/commit/80abbe00f6e1fae95648dc1c2369e2bf9e20ca05))


## v3.6.0 (2024-04-10)

### Chores

- **deps-dev**: Bump vite from 4.5.2 to 4.5.3 in /docs/vitepress
  ([`0518f37`](https://github.com/Kitware/trame/commit/0518f378bceea6171d907135917f7b74227905e5))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.5.2 to 4.5.3. - [Release
  notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.3/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.3/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Continuous Integration

- Lint commit
  ([`5ad6a1b`](https://github.com/Kitware/trame/commit/5ad6a1b10c99d9d1641c7c4085725318e6d438c2))

- Lint commit
  ([`f909c60`](https://github.com/Kitware/trame/commit/f909c60d9b1ee66d77d6f41e0a9cadbb86fc5975))

### Documentation

- **jupyter**: Add guide section to jupyter
  ([`b664273`](https://github.com/Kitware/trame/commit/b66427334d9fda8e272c1c454387c15a9c2a3f4a))

- **jupyter**: Add more info on extension
  ([`6bbc8bd`](https://github.com/Kitware/trame/commit/6bbc8bd86db324c2f225a06f4f7e321b0ff4a480))

- **picking**: Update pv picking readme and code
  ([`7e480b9`](https://github.com/Kitware/trame/commit/7e480b992e0aea49b648d717b984eed16d9615f0))

### Features

- **wslink**: Use msgpack and use streaming to limit msg size
  ([`487499f`](https://github.com/Kitware/trame/commit/487499f4c248f00e0a6eee728a4daad27e48339c))


## v3.5.5 (2024-04-02)

### Bug Fixes

- **version**: Prevent v3 from client+server
  ([`ff62287`](https://github.com/Kitware/trame/commit/ff62287e374e90e588ce4aecbcea86362e8286f3))

### Documentation

- **docker**: Add info on setup/www
  ([`b48c964`](https://github.com/Kitware/trame/commit/b48c964e7c90a7abf6b156f9d2e85fbc588a58fa))

- **docker**: Expend www_modules usage
  ([`d15e1c2`](https://github.com/Kitware/trame/commit/d15e1c24d6e4df8a66d50e632f173dec84a6c929))

- **widgets**: Update listing
  ([`55fc7b2`](https://github.com/Kitware/trame/commit/55fc7b2eaab69ca8295acd569304c2fd2a6c6346))


## v3.5.4 (2024-03-21)

### Bug Fixes

- **dev reload**: 17_dev_reload + trame.app.dev
  ([`90fb83a`](https://github.com/Kitware/trame/commit/90fb83aceb61f087e18da85d4fec0909fa250ecb))

clear _change_callbacks from server.state instead of server

### Documentation

- **file_upload**: Update docstring
  ([`817d835`](https://github.com/Kitware/trame/commit/817d83590e4f4d6b3b05e22dbcf622f06a163116))

- **tutorial**: Update to be compatible with v3
  ([`350cd91`](https://github.com/Kitware/trame/commit/350cd91ec388b796b0b0a7b04bc6bbbf0f562eac))

- **widgets**: Update compatibility list
  ([`527a40c`](https://github.com/Kitware/trame/commit/527a40c45f61859a6c39cc61c81c72bb48567c21))


## v3.5.3 (2024-03-13)

### Bug Fixes

- Uniform __init__.py for package
  ([`2acbce9`](https://github.com/Kitware/trame/commit/2acbce97bbd24219baf9f5974c075305fe3b0a17))

### Documentation

- **api**: Add more widgets to rtd
  ([`9dc46f1`](https://github.com/Kitware/trame/commit/9dc46f1cb8c4b53c6b46ecebc95644ebb64e6c93))

- **api**: Expose serve
  ([`51cea2c`](https://github.com/Kitware/trame/commit/51cea2c62491894c43e30e28c2e3842792f9be71))

- **discussion**: #443
  ([`fe4e7de`](https://github.com/Kitware/trame/commit/fe4e7de8a171f2cb09b617987e36cbe3583eeac4))

- **discussion**: #443
  ([`996d9ee`](https://github.com/Kitware/trame/commit/996d9ee5e582a0412eb68206f126358f33dcde9d))

- **discussion**: Add solution for 431
  ([`0b3ca3b`](https://github.com/Kitware/trame/commit/0b3ca3bc9dc88122d30a4aa79a7067b29e5a3333))

- **discussion**: Provide example for #440
  ([`026eed0`](https://github.com/Kitware/trame/commit/026eed0e823e295c155a152fadcb97f40735ff39))

- **example**: Fix lut local rendering
  ([`c4481e0`](https://github.com/Kitware/trame/commit/c4481e0d28a2000ff8ca9e48768373e07763c42a))

- **example**: Update multi-filter app
  ([`6d98c4e`](https://github.com/Kitware/trame/commit/6d98c4e554ab09c014a4b4038fe185a51ac049aa))

- **i18n**: Update vuetify3 example
  ([`af29e78`](https://github.com/Kitware/trame/commit/af29e78920f9bda483cc6443d5e0ed007e4f3493))

- **news**: Update trame references
  ([`2e8a8cb`](https://github.com/Kitware/trame/commit/2e8a8cbd75a79d21a5820d73dc79bd042e046e7f))

- **tools**: Add serve info
  ([`ee11657`](https://github.com/Kitware/trame/commit/ee116571f7a097c4a1b69f0bb8e8728a269f1bfa))


## v3.5.2 (2024-02-01)

### Bug Fixes

- **tools**: Widgets generator handle methods
  ([`b796009`](https://github.com/Kitware/trame/commit/b7960095712fe9ca383798c4d4b1a6c0d79325af))

### Chores

- **deps-dev**: Bump vite from 4.5.1 to 4.5.2 in /docs/vitepress
  ([`7ad2935`](https://github.com/Kitware/trame/commit/7ad29353d5e7ce953fdffdac1ba5e8862b937564))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.5.1 to 4.5.2. - [Release
  notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.2/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.2/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Continuous Integration

- **docker**: Better user right and docker-in-docker
  ([`bc19861`](https://github.com/Kitware/trame/commit/bc198615cc92ac51ddd506a9997c50cb8168cb8b))

- **docker**: Check if docker.sock is a socket
  ([`5806997`](https://github.com/Kitware/trame/commit/5806997d43094023339cc7011976762a6b67c81c))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **docker**: Fix condition to update user uid/gid
  ([`9f74eae`](https://github.com/Kitware/trame/commit/9f74eae7c4b675d4841ee3cfc0c8ea3268350376))

- **docker**: Update run_patch.sh
  ([`fb1ceb5`](https://github.com/Kitware/trame/commit/fb1ceb55961344016609ef980c60675b131895e2))

### Documentation

- **custom_js**: Add more comment to code example
  ([`38de8e6`](https://github.com/Kitware/trame/commit/38de8e6416d246736d937bfd9df1514f33d0204d))

- **custom_js**: Example with custom JS
  ([`85795e2`](https://github.com/Kitware/trame/commit/85795e2d364993cbbada80cc8266df4d005fcbd2))

- **custom_js**: Expend example with JSEval
  ([`f59d512`](https://github.com/Kitware/trame/commit/f59d51276655762ba519e6cdc3fb3a9cc094eb5f))

- **docker**: Add use ENV TRAME_CLIENT_TYPE
  ([`a483a96`](https://github.com/Kitware/trame/commit/a483a96e2d6714b01ae4679c89f8e9b500933164))

- **example**: Add popup window example
  ([`e9a57dd`](https://github.com/Kitware/trame/commit/e9a57dd5123d572b7eeb35d845bf41c74851c035))


## v3.5.1 (2024-01-10)

### Bug Fixes

- **vue3**: New default for tools/docker
  ([`0e77b63`](https://github.com/Kitware/trame/commit/0e77b63d9fc17b09789fa9f47a0cece738e0aaf8))

### Continuous Integration

- **docker**: Add a conda-glvnd flavor
  ([`c2c1e6d`](https://github.com/Kitware/trame/commit/c2c1e6da97002765693512c1cea07448c952b477))

- **docker**: Add a conda-glvnd flavor x86 only
  ([`6ae3434`](https://github.com/Kitware/trame/commit/6ae3434493015be1eb6f64d910c493c94eface4e))

### Documentation

- **docker**: More info on docker GPU and EGL
  ([`27df248`](https://github.com/Kitware/trame/commit/27df2489b9de3ef433cdc6848c895889aa7660d9))

- **example**: Use explicit client_type when it matters
  ([`41c78bf`](https://github.com/Kitware/trame/commit/41c78bf10a64b172b20aaa7d75ad0ca5ed40150f))

- **news**: Add new entry
  ([`c9a1628`](https://github.com/Kitware/trame/commit/c9a1628b24ada548b5c5be46c242832096cebea1))

- **website**: Add news entry
  ([`296c7d1`](https://github.com/Kitware/trame/commit/296c7d18bb9b7293c4430d0ec9b3e2a651429238))


## v3.5.0 (2024-01-01)

### Continuous Integration

- Learning sh...
  ([`be0334c`](https://github.com/Kitware/trame/commit/be0334cbd51afbc6705c71efd765056da64f9c7b))

- Make docker images for 3.9, 3.10
  ([`ae53161`](https://github.com/Kitware/trame/commit/ae53161017b20a433a2853b1a21cb50cb9e1823a))

- **docker**: Fix build-args definition
  ([`e043b12`](https://github.com/Kitware/trame/commit/e043b120e08cc3d7ff9f54477862dc03a1868c61))

- **docker**: Fix sh condition syntax
  ([`3361429`](https://github.com/Kitware/trame/commit/3361429f55ae0463dae35908e46aa447a45e4401))

- **docker**: Fixed sh condition
  ([`506b9c4`](https://github.com/Kitware/trame/commit/506b9c4a4fe4271ef549cb30aea660ab281eef91))

- **docker**: Move to ubuntu 22.04
  ([`d4c239b`](https://github.com/Kitware/trame/commit/d4c239be77700153a7f0a15f34e8bf34e1e8d1ed))

- **docker**: Try to get py matrix build
  ([`d37754d`](https://github.com/Kitware/trame/commit/d37754d0627d19d29e5087828348d1da55fcfbaf))

- **docker**: Try to get py matrix build
  ([`810007b`](https://github.com/Kitware/trame/commit/810007b8688977fd044bfb7d61f99aab6226aec6))

- **docker**: Try to get py matrix build
  ([`4fb2eba`](https://github.com/Kitware/trame/commit/4fb2ebad6124ad72293f73a2931e2579a04530ad))

- **docker**: Try to get uniform handling
  ([`3dcc580`](https://github.com/Kitware/trame/commit/3dcc5808ec09277a1b16c3b791bc1af319f5d473))

- **docker**: Use config to match os version with package name
  ([`2ce2539`](https://github.com/Kitware/trame/commit/2ce253993491b29037a934aee07d01ecc829da94))

- **docker**: Use meta package python3-distutils
  ([`3dd85e5`](https://github.com/Kitware/trame/commit/3dd85e575ff092205a9c29a97685f4acf41123bd))

### Documentation

- **example**: Add paraview remote rendering within docker
  ([`32dcdda`](https://github.com/Kitware/trame/commit/32dcdda6cb14a0b2572be7ccc38f43a5c96cd60a))

### Features

- **vue3**: Vue3 client is the new default
  ([`35013f4`](https://github.com/Kitware/trame/commit/35013f4da38aad3e9354f107a42d4ac01d524a77))


## v3.4.0 (2023-12-11)

### Chores

- **deps-dev**: Bump vite from 4.4.9 to 4.5.1 in /docs/vitepress
  ([`eaf2898`](https://github.com/Kitware/trame/commit/eaf2898e374a0fc87eaa05f0fc3d3de86770b3cf))

Bumps [vite](https://github.com/vitejs/vite/tree/HEAD/packages/vite) from 4.4.9 to 4.5.1. - [Release
  notes](https://github.com/vitejs/vite/releases) -
  [Changelog](https://github.com/vitejs/vite/blob/v4.5.1/packages/vite/CHANGELOG.md) -
  [Commits](https://github.com/vitejs/vite/commits/v4.5.1/packages/vite)

--- updated-dependencies: - dependency-name: vite dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Continuous Integration

- **docker**: Add support for vue3 www generation
  ([`d238b8c`](https://github.com/Kitware/trame/commit/d238b8c52941f69d3572aaa8ba2de2f56d646a47))

### Documentation

- **apps**: Comment out private apps
  ([`6236bb8`](https://github.com/Kitware/trame/commit/6236bb8f0a1dca6e8521449d625d017d9926d78c))

- **discussion**: Add missing property
  ([`181f6d7`](https://github.com/Kitware/trame/commit/181f6d751c1664705d91f9f78d347697cc7362c4))

- **discussion**: Check #376
  ([`1321814`](https://github.com/Kitware/trame/commit/1321814c1e43acd74391e55ab39965bc9186e18a))

- **example**: Bind reset camera to icon
  ([`ad4e2cb`](https://github.com/Kitware/trame/commit/ad4e2cb4158adbd9a9626a2dfe576f8bbeefcd56))

- **example**: Cone with class
  ([`e533873`](https://github.com/Kitware/trame/commit/e53387399ada58f93bcd6cbd4b88ac19e00b7771))

- **news**: Add blog on azure
  ([`c5f343b`](https://github.com/Kitware/trame/commit/c5f343b10276889081bbe74c0cf657059f24c680))

- **website**: Add star/download + news
  ([`09bf854`](https://github.com/Kitware/trame/commit/09bf85451e0c4362f9c3a0d76d4a3ad3101e4126))

### Features

- **namespace**: Child-server/namespace for app instance isolation
  ([`2381ad4`](https://github.com/Kitware/trame/commit/2381ad422d2336ce6d8fad7fdbd665fb784aa2cd))


## v3.3.0 (2023-11-03)

### Bug Fixes

- **jupyter**: Use get_server in show
  ([`d758ead`](https://github.com/Kitware/trame/commit/d758ead7d2c2f81b33acbfc62cb0b3fe81e92a57))

### Documentation

- **news**: Add medium blog entry
  ([`57142e4`](https://github.com/Kitware/trame/commit/57142e4289c2d5c1a59a8fa405c2243d0f1f4041))

- **news**: Medium
  ([`a29fffa`](https://github.com/Kitware/trame/commit/a29fffa249bcc0f4aba19612b2cd92abe2211e67))

- **tutorial**: Add missing pip install
  ([`03e7886`](https://github.com/Kitware/trame/commit/03e7886695702d1beeaff7c0c883bea396b528d3))

### Features

- **tools**: Add multi-client server for app
  ([`41b495a`](https://github.com/Kitware/trame/commit/41b495a18a7f3fe3045ef6984e505a5cac56173d))


## v3.2.8 (2023-10-24)

### Bug Fixes

- **www**: Allow www to support dict module
  ([`adc43a3`](https://github.com/Kitware/trame/commit/adc43a39ea494826e494af8dc19d95f2a679ad20))

### Chores

- **deps-dev**: Bump postcss from 8.4.29 to 8.4.31 in /docs/vitepress
  ([`2b9dbab`](https://github.com/Kitware/trame/commit/2b9dbab299c04b035e9bd1f50c6760098ec0e45b))

Bumps [postcss](https://github.com/postcss/postcss) from 8.4.29 to 8.4.31. - [Release
  notes](https://github.com/postcss/postcss/releases) -
  [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/postcss/postcss/compare/8.4.29...8.4.31)

--- updated-dependencies: - dependency-name: postcss dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Documentation

- **community**: Highlight community applications
  ([`e447803`](https://github.com/Kitware/trame/commit/e447803c39192dff554b128178eadaa66db3f981))

- **examples**: Update example
  ([`a6eafc7`](https://github.com/Kitware/trame/commit/a6eafc760f3921cf137daece1130cf6fd80e647d))

- **matplotlib**: Update examples to close the plots
  ([`1f11e35`](https://github.com/Kitware/trame/commit/1f11e3576fad2a83c5a5de670b4f1220032adb69))

- **news**: Add a news section
  ([`bde6704`](https://github.com/Kitware/trame/commit/bde6704ca787c70b9aa2eaca90ae440127868a6c))

- **widgets**: Update listing
  ([`51e14d1`](https://github.com/Kitware/trame/commit/51e14d1d25b258bf31062828200d850b4ab9e7a8))


## v3.2.7 (2023-09-28)

### Bug Fixes

- **jupyter**: Fix infrastructure for jupyter extension
  ([`43795d6`](https://github.com/Kitware/trame/commit/43795d63bed0c9a8eea34b4bfa957bffabcbb1b3))

### Documentation

- **discussion**: 343
  ([`79f3802`](https://github.com/Kitware/trame/commit/79f3802df0a19f7379e4ce57df9326815a2c9822))


## v3.2.6 (2023-09-21)

### Bug Fixes

- **get_server**: Enable decorator like usage of the method
  ([`c47f5fa`](https://github.com/Kitware/trame/commit/c47f5fa70827abc242282c0efb9800f611d95871))

### Continuous Integration

- Try to make website work on / as well
  ([`438bafe`](https://github.com/Kitware/trame/commit/438bafed45e14bc1776c8c2c16d686e54ff7effb))

### Documentation

- Improve doc
  ([`427f79f`](https://github.com/Kitware/trame/commit/427f79fbaf7d2193f8b23f977e60c3fda37d2486))

- **discussion**: Add example for 342
  ([`7df9327`](https://github.com/Kitware/trame/commit/7df9327b25cc538ef2c22a6c30b2adc2b9733fd2))

- **events**: Update core features
  ([`8617dc1`](https://github.com/Kitware/trame/commit/8617dc1a2082022578d196df71bd6cce831518f6))

- **examples**: Better formatting
  ([`b69f286`](https://github.com/Kitware/trame/commit/b69f286bf39cee5a5bf699e12c55baf8bad0d538))

- **examples**: Fix links on gallery
  ([`a337c85`](https://github.com/Kitware/trame/commit/a337c856403dbbfc629585069579ae90580fbd22))

- **examples**: The basics
  ([`0b48852`](https://github.com/Kitware/trame/commit/0b48852a5fd056527776a001c1f051eff8dbd2c3))

- **website**: Add more basic examples
  ([`d18860e`](https://github.com/Kitware/trame/commit/d18860ef0e78aa599a7ec2ad5745c523aa4f8dea))

- **website**: Fix image path
  ([`3d77c93`](https://github.com/Kitware/trame/commit/3d77c931ab279d48565de68cec66bb59e1a2d0f9))

- **website**: Improve responsiveness
  ([`dfd4c6c`](https://github.com/Kitware/trame/commit/dfd4c6c119c25caebb46aa1959836bb3fed2947a))

- **website**: Update guides
  ([`533dce1`](https://github.com/Kitware/trame/commit/533dce1e716ba8f4ceffd66acdc03b30a91a46e0))


## v3.2.5 (2023-09-15)

### Bug Fixes

- **readme**: Links for PyPI
  ([`e57cb3e`](https://github.com/Kitware/trame/commit/e57cb3ee690f7b02680c599aea531816634c5381))

### Chores

- **deps-dev**: Bump json5 from 1.0.1 to 1.0.2
  ([`08f3825`](https://github.com/Kitware/trame/commit/08f3825e8f9309f76967667867aa64329fb75405))

Bumps [json5](https://github.com/json5/json5) from 1.0.1 to 1.0.2. - [Release
  notes](https://github.com/json5/json5/releases) -
  [Changelog](https://github.com/json5/json5/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/json5/json5/compare/v1.0.1...v1.0.2)

--- updated-dependencies: - dependency-name: json5 dependency-type: indirect

...

Signed-off-by: dependabot[bot] <support@github.com>

### Continuous Integration

- Add workflow to build website
  ([`2c5c1a5`](https://github.com/Kitware/trame/commit/2c5c1a5360b85f652ae8d24a1ee0e107a6081824))

- Remove root package.json
  ([`a7cb72d`](https://github.com/Kitware/trame/commit/a7cb72d73791441c867ceefb64df892dfc14ae85))

- Vitepress
  ([`3b7c776`](https://github.com/Kitware/trame/commit/3b7c7760291f9b02932ae89c5222e61711af03b5))

- Vitepress
  ([`304f417`](https://github.com/Kitware/trame/commit/304f4179aa2b536ef17e81894ffc69ff7bafeec6))

- Vitepress
  ([`815f4cd`](https://github.com/Kitware/trame/commit/815f4cd2b16e3efa149182a9c720d97e890567c0))

### Documentation

- **discussion**: Working example for 328
  ([`9d7677f`](https://github.com/Kitware/trame/commit/9d7677f595a813e7160db68c18856d4f606ecaab))

- **example**: Add mutli server example in jupyter
  ([`4ee68a8`](https://github.com/Kitware/trame/commit/4ee68a8fd4c85f0cf0778b60646e4127f915e0df))

- **examples**: Improve error validation one
  ([`e42ea8e`](https://github.com/Kitware/trame/commit/e42ea8e33ee954f0e24642a116cdde89a28c8566))

- **features**: Add missing links
  ([`c156261`](https://github.com/Kitware/trame/commit/c15626106eb88197f0621b5bb25564b49af23e85))

- **issue**: Add working code for 329
  ([`641cd3e`](https://github.com/Kitware/trame/commit/641cd3e2b176d6dacb55abc708695dfefbca59c9))

- **jupyter**: More examples
  ([`b962d9e`](https://github.com/Kitware/trame/commit/b962d9e7ae00c6a6459c84d55d3a600268db8714))

- **jupyter**: Update notebook
  ([`24964bc`](https://github.com/Kitware/trame/commit/24964bc4a867954c4f3e95e61d93cf05bbef1241))

- **panel**: Add example to compare with panel
  ([`12de48e`](https://github.com/Kitware/trame/commit/12de48e5921ceee3b43a57ae239be657e4e76907))

- **panel**: Provide parity example
  ([`8304056`](https://github.com/Kitware/trame/commit/830405665ffc4804c4b660cc2601cb9faa42ba6b))

- **readme**: Add pypi badges
  ([`8c363c1`](https://github.com/Kitware/trame/commit/8c363c19283947b08759559cf7e31f5563e30495))

- **readme**: Update image links
  ([`47d205c`](https://github.com/Kitware/trame/commit/47d205c35b37deb533634cd84eda8c4eb5282e99))

- **v3**: Update listing with vue3 router support
  ([`b634e2a`](https://github.com/Kitware/trame/commit/b634e2ab69aee5ff764724e54ccd55e4db870b12))

- **vitepress**: Update content
  ([`a116c31`](https://github.com/Kitware/trame/commit/a116c316edf84f537bc953fa0ab4ffeebfed1f76))

- **vue3**: Trame-components now support vue2 and 3
  ([`ea5bbcf`](https://github.com/Kitware/trame/commit/ea5bbcf1d678f01122458658bc652f20950a7506))

- **website**: Migrate to vitepress
  ([`e8a8acf`](https://github.com/Kitware/trame/commit/e8a8acf354ab07da04d8951fe74db08ac0cb28c5))


## v3.2.4 (2023-08-18)

### Bug Fixes

- **tools.widgets**: Add utils functions
  ([`478d581`](https://github.com/Kitware/trame/commit/478d581d4ba6c9e5f7a8d6f263dcb97ee9284fc4))


## v3.2.3 (2023-08-18)

### Bug Fixes

- **tools.widgets**: Fix invalid import
  ([`289e30c`](https://github.com/Kitware/trame/commit/289e30cd2d984cb9a041c65a58044046893011cf))


## v3.2.2 (2023-08-17)

### Bug Fixes

- **tools.widgets**: Improve url handler to filename
  ([`68a6d48`](https://github.com/Kitware/trame/commit/68a6d48f7413a8c901c2a6c4c0c8bc97fdc974c4))

### Documentation

- **api**: Update decorators
  ([`347a82b`](https://github.com/Kitware/trame/commit/347a82b283edb4f09416a7a67f4cb291e4ce7c1c))

- **decorators**: Add mode docstring
  ([`17db3ce`](https://github.com/Kitware/trame/commit/17db3ce260867799e32ef18c15136ae444ad4988))


## v3.2.1 (2023-08-16)

### Bug Fixes

- **doc**: Only expose what is needed
  ([`d479033`](https://github.com/Kitware/trame/commit/d4790335f44978007f4f6c35673e6ed6b28694f5))

### Documentation

- **api**: Improve API doc
  ([`32d87b5`](https://github.com/Kitware/trame/commit/32d87b56e90c7195700a73957f14a8483cf59c2b))

- **api**: Update tools
  ([`9efeea0`](https://github.com/Kitware/trame/commit/9efeea0f0240739fe0d79ee012f7d497d63d4498))

- **tools**: Fix docs on widgets
  ([`a9ab5fb`](https://github.com/Kitware/trame/commit/a9ab5fb9ce23fde594dc101b380f83ac206db605))

- **tools**: Improve widgets tool
  ([`fc65f72`](https://github.com/Kitware/trame/commit/fc65f728cf83d0b67babe2e29b352fef4d0f021c))


## v3.2.0 (2023-08-16)

### Bug Fixes

- **widgets**: Add helper to create widget class
  ([`923c080`](https://github.com/Kitware/trame/commit/923c08023668ebc226e4a90706b832dc0d8835f2))

### Documentation

- **examples**: List trame-* dependencies for trame v3
  ([`4b78baa`](https://github.com/Kitware/trame/commit/4b78baa8aea42ec2b4524cc7b182ad6951690765))

### Features

- **tools**: Add widget generator
  ([`75998c7`](https://github.com/Kitware/trame/commit/75998c790419ed8669603d232097d380a82c5e38))

- **tools**: Add widget generator
  ([`fc9dc83`](https://github.com/Kitware/trame/commit/fc9dc835ffe503cd2203dbb063b479a973ba6b6e))


## v3.1.0 (2023-08-04)

### Documentation

- **example**: Fix client_type
  ([`78023e8`](https://github.com/Kitware/trame/commit/78023e86e1dd78dd5090bf27351c066f6099d332))

- **examples**: Add missing dep for trame v3
  ([`78821d1`](https://github.com/Kitware/trame/commit/78821d1c35d850ae158b6477974f6afa74f9c1eb))

- **flyer**: Add 2023 pdf flyer
  ([`8e739f9`](https://github.com/Kitware/trame/commit/8e739f9f39f03c2761b2a67477abe47e7369f67d))

- **flyer**: Add download link
  ([`3353f1b`](https://github.com/Kitware/trame/commit/3353f1b28c7e6b7a2cbd5213eb0b542cb85198cd))

- **v3**: Update migration page
  ([`f1f5ac4`](https://github.com/Kitware/trame/commit/f1f5ac48cc8a26b083968ebc57bc4306a867b075))

- **v3**: Update migration page
  ([`90be23f`](https://github.com/Kitware/trame/commit/90be23faafac20289a533d70f1aa8f020a4c50b4))

- **v3**: Update migration page
  ([`4de8d3d`](https://github.com/Kitware/trame/commit/4de8d3d309fcee9adfc04d7878b99eaa1a42a1e3))

- **v3**: Update tutorial to support v3
  ([`4ede54c`](https://github.com/Kitware/trame/commit/4ede54ca91a411171905bdec11a90f3cd2137d2f))

### Features

- **decorator**: Expose class level decorators
  ([`0db65a1`](https://github.com/Kitware/trame/commit/0db65a11993e4def6e43e26d5894b8173fd999e8))


## v3.0.2 (2023-07-20)

### Bug Fixes

- **warn**: Disable message with TRAME_DISABLE_V3_WARNING env
  ([`ffc3d15`](https://github.com/Kitware/trame/commit/ffc3d152b351b44d3792ebe85dbed095520ec5e2))


## v3.0.1 (2023-07-20)

### Bug Fixes

- **v3**: Use logger for warning message
  ([`dd3d220`](https://github.com/Kitware/trame/commit/dd3d220fdae7b94a5bbf78d4ea732e642799a923))


## v3.0.0 (2023-07-20)

### Features

- **v3**: Streamline trame for vue3 support
  ([`85f6a48`](https://github.com/Kitware/trame/commit/85f6a48fa7c52a68437704adf1645327e633edcf))

BREAKING CHANGE: In December 2023, the default client type will be vue3

### BREAKING CHANGES

- **v3**: In December 2023, the default client type will be vue3


## v2.5.2 (2023-07-20)

### Bug Fixes

- Last release before trame3
  ([`ff3aa76`](https://github.com/Kitware/trame/commit/ff3aa76c2c1446516c0945870e12b1aaefdbe797))

### Continuous Integration

- Fix version
  ([`fe48af4`](https://github.com/Kitware/trame/commit/fe48af40c0baf0dda772c5df91135438a31ed5c2))

### Documentation

- **example**: Add working examples for issues
  ([`5fc1187`](https://github.com/Kitware/trame/commit/5fc11876a18df20c4b7468266add7a9bcd3d0795))


## v2.5.1 (2023-07-19)

### Bug Fixes

- **v2**: Last trame v2 release
  ([`6c66b44`](https://github.com/Kitware/trame/commit/6c66b446f0343b2ba74c247daeb3c7806b3c23cc))

### Continuous Integration

- Add cuda based docker image
  ([`b69e7cb`](https://github.com/Kitware/trame/commit/b69e7cb1cb15bffe6d3991766ee3c9f684757fb0))

### Documentation

- Update README.rst
  ([`23f4497`](https://github.com/Kitware/trame/commit/23f4497918bf4d7d54897d00035d8eb567e2534e))

- **discussion**: Add example 291
  ([`07688e9`](https://github.com/Kitware/trame/commit/07688e9d19dd87001325e9eaeb516740baead2b5))

- **discussion**: Add sample code
  ([`5c2a424`](https://github.com/Kitware/trame/commit/5c2a424f755224bc62f1c2aef691dcf4cfd12e61))

- **nginx**: Add config info
  ([`43c1193`](https://github.com/Kitware/trame/commit/43c11936f36b5744f02643447318bdc65923bb60))

- **nginx**: Update deploy-nginx.md
  ([`89bcfab`](https://github.com/Kitware/trame/commit/89bcfabb3e871688c4e9c6b897b4b265121b6a51))

- **readme**: Add markdown for indexing
  ([`dbbeab5`](https://github.com/Kitware/trame/commit/dbbeab5b9bf9f8212db6b1cca4a885056c3bcd75))

- **readme**: Add markdown for indexing
  ([`6b9ebce`](https://github.com/Kitware/trame/commit/6b9ebce9bf9cdc19a246f3dd5d7d9f60ba812ef9))

- **website**: Fix license reference
  ([`979aa84`](https://github.com/Kitware/trame/commit/979aa84b9803bf539edf50ff98a3dd4b4cde76ef))

This commit fixes a regression introduced in 5f55d6a57 (docs(website): update content to match new
  api ) updating the text describing the license to mention "Apache License Version 2.0" instead of
  "BSD-3".

The text now described the license effectively associated with the trame v2 project originally
  introduced in 0e44015c8 (trame a framework to write ubiquitous applications in Python).

For reference, trame v1 license (originally introduced in e8fe5944b (chore: Getting started)) was
  BSD-3.


## v2.5.0 (2023-05-19)

### Documentation

- **example**: Add <trame-getter> example
  ([`6a2b20c`](https://github.com/Kitware/trame/commit/6a2b20c78b70460e40c164d9736bffef7d52a006))

- **getter**: Add example with nested update
  ([`cb67736`](https://github.com/Kitware/trame/commit/cb67736b78c75f7e6e9e1c07c802b40de45ba760))

- **GroupChips**: Add example
  ([`be98f8f`](https://github.com/Kitware/trame/commit/be98f8ff074b569f007a20b9ed948d3cae150358))

- **website**: Add more help
  ([`97bf7ff`](https://github.com/Kitware/trame/commit/97bf7ff484ac7e3af31191687313546a2d2af2ad))

- **website**: Add mstar image in the app section
  ([`77a290c`](https://github.com/Kitware/trame/commit/77a290c0d4d8584380c9c90b4ebe6c3fdb8056fd))

- **website**: Add roadmap and v2-3 mention
  ([`10ad9a3`](https://github.com/Kitware/trame/commit/10ad9a332e6596bb8da465f4d5c453fe9059ec65))

- **website**: Add roadmap and v2-3 mention
  ([`97f6476`](https://github.com/Kitware/trame/commit/97f6476c5056df73b3b4585eaad718abbb4b1cf5))

- **website**: Update applications anchor
  ([`6379042`](https://github.com/Kitware/trame/commit/6379042985602583ce8b1d0a7f01ca88c94e8736))

- **website**: Update mstar tooltip
  ([`49c3c93`](https://github.com/Kitware/trame/commit/49c3c93c136c4ce8392b44a48e354ec3b83f64c0))

### Features

- **dependencies**: Version update for all vue2 widgets
  ([`ddddb65`](https://github.com/Kitware/trame/commit/ddddb6581df8ef22ab8b38ad46283cc16e34c7d6))


## v2.4.2 (2023-05-11)

### Bug Fixes

- **demo**: Rename cone to demo and add jupyter helper
  ([`429c10b`](https://github.com/Kitware/trame/commit/429c10b03d251c00b01a0deca5b2ecb6a9721f01))


## v2.4.1 (2023-05-11)

### Bug Fixes

- Add cone application for validation
  ([`bf84770`](https://github.com/Kitware/trame/commit/bf84770826dfb247bce0cca155845b9812935a08))


## v2.4.0 (2023-04-25)

### Documentation

- **api**: List external widgets
  ([`a333db1`](https://github.com/Kitware/trame/commit/a333db1dfccd9f3a838d25cdded59acfe9cc4c44))

- **docker**: Fix docker remote rendering example
  ([`ab55187`](https://github.com/Kitware/trame/commit/ab5518795a3c8b5827f05e2e650e39bff32e55ac))

- **docker**: Vtk remote rendering
  ([`e11ff23`](https://github.com/Kitware/trame/commit/e11ff23beadb26ad16aa56f2925a0b92a62c056c))

- **examples**: Add docker remote rendering example
  ([`7a847a0`](https://github.com/Kitware/trame/commit/7a847a0ca1294cbff2f191275a09fe7007d6f66e))

- **osmesa**: Update requirements.txt for remote rendering
  ([`7b0fcbd`](https://github.com/Kitware/trame/commit/7b0fcbdf564b936ad1b7f5d927d4e0fe2fe1824a))

- **vtk**: Update example with latest trame-vtk
  ([`f306d2d`](https://github.com/Kitware/trame/commit/f306d2d37eb668362773e6b5e3d3ce0f012a9630))

- **vue23**: Clarify some aspect
  ([`a5e2a5a`](https://github.com/Kitware/trame/commit/a5e2a5ac2223174f1ba128fbdd486b94f750f8f2))

- **vue3**: New template handling syntax
  ([`fbaffe3`](https://github.com/Kitware/trame/commit/fbaffe301a6a0d747d80782c9e7e29a529e20763))

- **website**: Update to add doc on vue2/3
  ([`d70f097`](https://github.com/Kitware/trame/commit/d70f097c173cfd572ebeae51b8ddb90a939d9d6a))

### Features

- **py-client**: Enable cross trame-server communication
  ([`afab046`](https://github.com/Kitware/trame/commit/afab0462c8fedc9b8b0f70f86d7eb08f3ead9fe3))


## v2.3.2 (2023-02-14)

### Bug Fixes

- **www**: Allow www tool to support either vue2 or vue3
  ([`363dd53`](https://github.com/Kitware/trame/commit/363dd5336034dbd9d5c5d03ce13ea242aa5f99c0))

fix #204


## v2.3.1 (2023-02-10)

### Bug Fixes

- **testing**: Add testing helpers
  ([`493803d`](https://github.com/Kitware/trame/commit/493803d26b8c8d33b1f28c59cd5cdabb6c713636))

### Documentation

- **table**: Handle dynamic table
  ([`be314bf`](https://github.com/Kitware/trame/commit/be314bf58eef73dd0394f1dcc1c7735720fdcf73))


## v2.3.0 (2023-02-08)

### Documentation

- **hot_reload**: Deprecate @reloading example
  ([`96b4eb5`](https://github.com/Kitware/trame/commit/96b4eb5e5bd036ebc2816870022dcbbefdbc04ac))

- **hot_reload**: Make content center
  ([`e6aec3f`](https://github.com/Kitware/trame/commit/e6aec3fb41a6edecb379d2d7651ca3ecb40fe45f))

- **utils.tree**: Add API doc
  ([`2818473`](https://github.com/Kitware/trame/commit/28184737d7712f9ffe749ac3543bf3b43f4200fd))

- **website**: Update value proposition
  ([`e96749c`](https://github.com/Kitware/trame/commit/e96749c2360294ab5527d75052e2804dcc1aa210))

### Features

- **client_type**: Preparation for 3.x release
  ([`b88a994`](https://github.com/Kitware/trame/commit/b88a994e2acea87bf624340a178022158f00a79b))


## v2.2.6 (2023-01-20)

### Bug Fixes

- **hot_reload**: Remove old code
  ([`7fc2948`](https://github.com/Kitware/trame/commit/7fc2948a61a2b304f72648cae062be2a1f52b697))

### Chores

- Update issue template
  ([`08a1f57`](https://github.com/Kitware/trame/commit/08a1f577d5e18e5ebda92e4cb78ac24d435f80fa))

### Documentation

- **docker**: Update readme
  ([`ade4c25`](https://github.com/Kitware/trame/commit/ade4c25dc634d9dd30a25158e58c66d5a4b89322))

- **DynamicLocalRemoteRendering**: Fix example to flush geometry
  ([`d0a1deb`](https://github.com/Kitware/trame/commit/d0a1deb65a5a8f6bbe7a2dcbbfda14a5ba563a91))

- **Example**: Add cursor example
  ([`78e31cc`](https://github.com/Kitware/trame/commit/78e31cc1d9c593c58f664fbf10c9e943f9468e28))

- **hot_reload**: Add example
  ([`f0f3cc8`](https://github.com/Kitware/trame/commit/f0f3cc8238677a7b2b2afd4585881873132dd97d))

- **HPC**: Update hpc doc
  ([`208b711`](https://github.com/Kitware/trame/commit/208b71123da8428414d3c909b5d988cd665b9ac0))

Corrected InfiniteTactics name and edited the description

- **issues**: Add issue code base
  ([`f177d4e`](https://github.com/Kitware/trame/commit/f177d4e35e855542513e17895092882bcc2d8521))

- **reloading**: Allow dynamic method reloading
  ([`06be552`](https://github.com/Kitware/trame/commit/06be55252f885ddf7ac917b47f6a5149b3cdb756))

- **website**: Update some website guides
  ([`7f58c1a`](https://github.com/Kitware/trame/commit/7f58c1a987066d92efbb460d65954695a912bd9e))


## v2.2.5 (2022-12-17)

### Bug Fixes

- **docker**: Separate out build and run steps
  ([`7393f1d`](https://github.com/Kitware/trame/commit/7393f1d44f9ddbc3d51db5cafbe88a4039ff9cc2))

This also updates the README with new relevant instructions.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

### Documentation

- **docker**: Update docker to use build script
  ([`c3b7bd1`](https://github.com/Kitware/trame/commit/c3b7bd130af104549e2a18dafee4719ba59abf24))

- **docker**: Update readme
  ([`33e050d`](https://github.com/Kitware/trame/commit/33e050d986b22cadb377c57ac5d5d0ae714135a6))


## v2.2.4 (2022-12-12)

### Bug Fixes

- **docker**: Move apps.json creation into launcher section
  ([`eeb4a88`](https://github.com/Kitware/trame/commit/eeb4a886e39721b9059a7957ecdb3ea09d4a9b58))

The `/deploy/setup` directory won't necessarily exist at runtime, because it is optional if
  `/deploy/server` exists.

Thus, we should only create the `apps.json` file if we are performing one of the other build steps
  (all of which require the `/deploy/server` directory). It makes most sense to put this in the
  `launcher` section, since the launcher uses this.

However, we must create the `apps.json` file before activating the venv, because we have pyyaml in
  the root env, but not necessarily in the venv. Also, the launcher creation script only uses
  built-in libraries, so it can be moved before the venv as well.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>


## v2.2.3 (2022-12-11)

### Bug Fixes

- **docker**: Add ability to replace USE_HOST
  ([`3cd4dc3`](https://github.com/Kitware/trame/commit/3cd4dc321db1e404ec4ce8ae7db8747868b4d255))

If a `TRAME_USE_HOST` environment variable is defined, then this will replace `USE_HOST` in the
  final copy of the launcher json file.

If `TRAME_USE_HOST` contains `://`, then this will replace `ws://USE_HOST` instead.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **docker**: Add additional build options
  ([`8ad6f44`](https://github.com/Kitware/trame/commit/8ad6f449347969e091bd178560edebb41c6aafb4))

This allows the user to separate out building the venv, launcher, and www.

The default behavior is that all will build if they do not exist. If they do exist, then they will
  not be built.

However, the user can now select some options via a `TRAME_BUILD` environment variable. If this
  string contains (single or any combination of) "venv", "launcher", or "www", then those respective
  parts will be re-built, even if they already exist.

Additionally, a "no_www" can be specified in the `TRAME_BUILD` environment variable, which indicates
  to skip the `www` generation, even if it does not exist.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **docker**: Add build.sh script for easier builds
  ([`26effc0`](https://github.com/Kitware/trame/commit/26effc03b88cf5e86411fca80994c515ce29dee6))

Any arguments that you provide it get put into `TRAME_BUILD`, so you can add arguments like `no_www`
  or `venv`.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

### Documentation

- **examples**: Reformat using black
  ([`6fdc5a5`](https://github.com/Kitware/trame/commit/6fdc5a5f2bb52a2eff42ed4c1dfac9ec187cf372))

- **markdown**: Provide encoding at read time
  ([`2760bc2`](https://github.com/Kitware/trame/commit/2760bc28917fa31cc7f97ea8dd9a361cfe9f541c))

- **readme**: Handle typos
  ([`12879f2`](https://github.com/Kitware/trame/commit/12879f2e1f0e5f0f8550221278908a32180e2d5b))

Minor edits

- **Selection**: Add paraview remote rendering selection example
  ([`f9f6f7b`](https://github.com/Kitware/trame/commit/f9f6f7bbb23585e65bf2aaa0ccbfd00e342ebd14))

- **selection**: Update pv selection with clear and click
  ([`0d06739`](https://github.com/Kitware/trame/commit/0d06739114ed3b37f838304b334295d6f93bf50d))

- **Style**: Add global css style example
  ([`00fa606`](https://github.com/Kitware/trame/commit/00fa60618aaff4f383b50e34e1c85d3a89d2e4b5))


## v2.2.2 (2022-12-02)

### Bug Fixes

- **docker**: Add `wheel` to pip docker image
  ([`6f34a4e`](https://github.com/Kitware/trame/commit/6f34a4eead0e4f50372d3c6f524dfdd3f4a4b018))

Pip is now deprecating installation via the older install method that does not use wheel. This
  deprecation message is now displaying, and it appears that in a version of pip soon, we may start
  seeing errors.

Add wheel to the trame docker image to keep the installation process simple for users (so that they
  will not be required to install wheel themselves or create a `pyproject.toml` file).

See: https://github.com/pypa/pip/issues/8559

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

### Documentation

- **caprover**: Add info for caprover deploy
  ([`ea6fec4`](https://github.com/Kitware/trame/commit/ea6fec4b3c9d45241d00ff8b4913aab45200ebc0))

- **deploy**: Add a deployment section
  ([`2b5e122`](https://github.com/Kitware/trame/commit/2b5e122e09658534f970c2f0b1bb9fc9043df0d9))

- **docker**: Add single file example
  ([`18fa307`](https://github.com/Kitware/trame/commit/18fa30792e6d6b8f8a8decc54d659ea306d36be9))

- **example**: Switch view validation
  ([`662c5cb`](https://github.com/Kitware/trame/commit/662c5cb7c5092ff749edca94f15381cb72f22c6d))

- **examples**: Fix typo in vtkClass arg
  ([`4822ad3`](https://github.com/Kitware/trame/commit/4822ad3bbb60caab3630e8100cd71c3e4dc2d27e))

- **fileUpload**: Add validation example
  ([`9c81ea9`](https://github.com/Kitware/trame/commit/9c81ea995473f205348e5639d528ba9dde03521f))

- **menu**: Update doc menu
  ([`89ee007`](https://github.com/Kitware/trame/commit/89ee0074f495a383ac171a2982db08f3c24abc88))

- **readme**: Remove the --pre in pip install command
  ([`dc01c70`](https://github.com/Kitware/trame/commit/dc01c70370c25fcb9e77fd86d46cd786a9a4e740))

- **video**: Add video on landing page
  ([`76926cf`](https://github.com/Kitware/trame/commit/76926cfdcfabd724af34acd7e5bd613dd1e072c0))

- **video**: Add video on landing page
  ([`168a3c9`](https://github.com/Kitware/trame/commit/168a3c983bc71f5e03c27a0409d3f93f34683d54))

- **website**: Correct tutorial code examples
  ([`eb4a628`](https://github.com/Kitware/trame/commit/eb4a6283b2d1585d7c34b189c94871563817940e))


## v2.2.1 (2022-10-21)

### Bug Fixes

- **rca**: Add trame-rca in default dependencies
  ([`7fa2253`](https://github.com/Kitware/trame/commit/7fa2253058aebe6e4e1c5150407f0019b275110b))

### Documentation

- **course**: Add links to the course
  ([`4f79912`](https://github.com/Kitware/trame/commit/4f79912a039c10a46afadc85c084c31977b146e7))

- **course**: Expanded and polished description of course
  ([`cc4e0ac`](https://github.com/Kitware/trame/commit/cc4e0ac9932ecdabefdcac5b67071bd461e937f8))

- **course**: Update links of documents
  ([`73bb2e7`](https://github.com/Kitware/trame/commit/73bb2e71c68fb691aa8d265b410a5547accc656a))

- **download**: Add binary download example
  ([`af70938`](https://github.com/Kitware/trame/commit/af70938509d966eae4cea5d76389ecdd9c97bc88))

- **example**: Add stats to pv/wavelet example
  ([`c257a54`](https://github.com/Kitware/trame/commit/c257a54a0a06c2a5a0dc2f2879819a9f69effc24))

- **example**: Collaboration state async/busy update
  ([`792dd28`](https://github.com/Kitware/trame/commit/792dd28e288547f7dfe20eff5596c16554f80a70))

- **examples**: Multi-server example
  ([`78008d9`](https://github.com/Kitware/trame/commit/78008d9a3b7ba0817df302ae1c81f93b7f618e5a))

- **FiniteElementAnalysis**: Fix file chunk handling
  ([`7790cd1`](https://github.com/Kitware/trame/commit/7790cd1df397b6988fabf4238317a1957b57c3c7))

- **paraview**: Add info for using conda
  ([`5e1160d`](https://github.com/Kitware/trame/commit/5e1160d72aef0d0b1edcab0450f90a03b9c0977c))

- **SurfacePicking**: Add jupyter helper function
  ([`76e6c8b`](https://github.com/Kitware/trame/commit/76e6c8b2a35e34e4a15ac6d3e479941b54500b36))

- **tutorial**: Fix typo in example
  ([`77b3a1b`](https://github.com/Kitware/trame/commit/77b3a1b6c262dfcfe50f10da26992ae023805f76))

- **vtk**: Rename trame.widgets.vtk to not confuse with vtk import
  ([`b480332`](https://github.com/Kitware/trame/commit/b48033261f364fd79f0dcd039b4c04c153eb67b1))

fix #127

- **wavelet**: Add sc demo comparison
  ([`f9d5e36`](https://github.com/Kitware/trame/commit/f9d5e367eefcfa7c27e63e79daa1112b2dba3daf))

- **wavelet**: Add sc demo comparison
  ([`def850b`](https://github.com/Kitware/trame/commit/def850b5768e2099c0c5c3610117e02b0e8126c9))


## v2.2.0 (2022-08-29)

### Documentation

- **website**: Fix spacing
  ([`7073f5a`](https://github.com/Kitware/trame/commit/7073f5a401e0b9f626908784f3d8d73ac7316f9e))

### Features

- **ClientFile**: Add helper to handle multi-part upload file
  ([`d00907f`](https://github.com/Kitware/trame/commit/d00907f9b3806cb2d94b6565527956475848a7a2))


## v2.1.2 (2022-08-24)

### Bug Fixes

- **simput**: Add simput as default dependency
  ([`b6ca24c`](https://github.com/Kitware/trame/commit/b6ca24ccace036122abe6dce27f5d51fab53fb2e))

### Chores

- **ignore**: Remove test directory
  ([`3967b9c`](https://github.com/Kitware/trame/commit/3967b9c234e31e4a06651df99bb2b5a4dcda2eca))

- **semantic-release**: Bump version to latest
  ([`3718950`](https://github.com/Kitware/trame/commit/37189505b4ef067898727a9258556d9f5e8af0cf))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

### Documentation

- **api**: Update client side API
  ([`738565f`](https://github.com/Kitware/trame/commit/738565fe1960aba916fd7bf6709de5b3f6a33c0a))

- **ci**: Add coverage and codecov upload
  ([`e6f3181`](https://github.com/Kitware/trame/commit/e6f3181c053c009017a95355721525dc502c5d35))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **coverage**: Add .coveragerc
  ([`41c4d62`](https://github.com/Kitware/trame/commit/41c4d62e7a6f5dba41fd9305b314c87fa8ed7b6f))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **coverage**: Remove codecov PR comment
  ([`49065a0`](https://github.com/Kitware/trame/commit/49065a0abb766c06c12972fa5022ee455d1fce9f))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **example**: Add validation for download with promise
  ([`51ad010`](https://github.com/Kitware/trame/commit/51ad0108a72f24a67449e05eba306581c0f818b9))

- **examples**: Add tkinter file browser example
  ([`190b37d`](https://github.com/Kitware/trame/commit/190b37dbcf56c900db0e38031f953b5695685067))

This adds an example that uses tkinter for the selection of a directory.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **examples**: Add validation examples
  ([`8a7e1ca`](https://github.com/Kitware/trame/commit/8a7e1ca1416e61014c31315096343c83e1c8f91e))

- **examples**: Ensure file browser appears in front
  ([`ef1a869`](https://github.com/Kitware/trame/commit/ef1a869dd4e6aa8c38a4da2dc3ebd1e1b47332f8))

This is particularly an issue on Windows. Add the line that is necessary to place the dialog in
  front.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **readme**: Add CI badge
  ([`c07b0d2`](https://github.com/Kitware/trame/commit/c07b0d22c673883e58914ea36489d49fc54b8ac4))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **readme**: Fix invalid path for pict
  ([`97b4a3c`](https://github.com/Kitware/trame/commit/97b4a3cb0c5a2346775d4f921107772200c87670))

- **relay**: Add reverse connection and relay scenario
  ([`7cbfbf4`](https://github.com/Kitware/trame/commit/7cbfbf46bf1dc46850768909802da08d725c0944))

- **reverse-stop**: Test client to ask server to stop
  ([`1877a46`](https://github.com/Kitware/trame/commit/1877a46c9e2be8b4e0a6157de16851d362761734))

- **website**: Improve language and grammar
  ([`6959dc8`](https://github.com/Kitware/trame/commit/6959dc8971f2bbe34c0afdfc90fe2fabde29c242))


## v2.1.1 (2022-06-15)

### Bug Fixes

- **mimetypes**: Ensure javascript files get the correct mimetype
  ([`40a9618`](https://github.com/Kitware/trame/commit/40a9618af62da9f7d2b88bc333938c9ccc647487))

On Windows, the mimetypes are obtained from the registry. However, the mimetype for javascript files
  is broken. Add some code to ensure that javascript files are identified correctly.

This also adds some infrastructure for adding extra mimetypes that persist even if
  `mimetypes.init()` is called.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

### Documentation

- **contributing**: Add CONTRIBUTING.rst
  ([`9e51275`](https://github.com/Kitware/trame/commit/9e5127537c23b743b04cbafff3f5f21ba277344a))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **example**: Fix SimpleCone/RemoteRendering
  ([`498fd78`](https://github.com/Kitware/trame/commit/498fd7803505068cf269aa1ac83806e1b16d3d03))


## v2.1.0 (2022-06-04)

### Chores

- **pre-commit**: Fix format issue
  ([`0224fb5`](https://github.com/Kitware/trame/commit/0224fb5fb267c5e8819b09fd241bf2f20c12e424))

### Code Style

- **black**: Fix indentation
  ([`a4977db`](https://github.com/Kitware/trame/commit/a4977db8e3db910785f8b5de22dd42fe5f923797))

### Continuous Integration

- **docker**: Add custom www module + app.html
  ([`95d1ef9`](https://github.com/Kitware/trame/commit/95d1ef9eb1fef9a2c1b0a090aff8cfc44ace7362))

- **docker**: Fix launcher generator script
  ([`51fe646`](https://github.com/Kitware/trame/commit/51fe6468759a7ef553880206acde39996c48dbbb))

- **docker**: Fix www generator for app.html name
  ([`6c99fc6`](https://github.com/Kitware/trame/commit/6c99fc6ac7d860d702f74860960e098df72871f3))

- **docker**: Make app key optional with cmd
  ([`9d73f24`](https://github.com/Kitware/trame/commit/9d73f2428bab44a3be7746293df2499e5b7f0a22))

- **docker**: Make apps.yaml/name/app optional
  ([`45b8cc5`](https://github.com/Kitware/trame/commit/45b8cc5042fb6908c792b32ef7a6755a1dd96d0f))

### Documentation

- **intro**: Remove --pre from pip install command
  ([`f748dd6`](https://github.com/Kitware/trame/commit/f748dd6736e4736365f9f18c00c5846c53f47793))

- **welcome**: Update note
  ([`cee6461`](https://github.com/Kitware/trame/commit/cee64613717607cb374e9c2ca07f5d40f1c6c7c8))

### Features

- **ui**: Add virtual node ui manager with server
  ([`6956009`](https://github.com/Kitware/trame/commit/695600928f2bd3e3795c556d609eb11c93ba7c50))


## v2.0.1 (2022-05-31)

### Bug Fixes

- **CI**: Add initial CI with semantic-release
  ([`a881ffb`](https://github.com/Kitware/trame/commit/a881ffb9232fd2f78e445be4be58dcc112181ff5))

This adds initial CI for trame 2.0, which includes a pre-commit (that currently uses black,
  codespell, and flake8), some simple tests, and automatically releasing a new version with semantic
  release (including a push to PyPI).

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **jupyter**: Proper server.start() call
  ([`e67625e`](https://github.com/Kitware/trame/commit/e67625e9775f688da7d80d5b2ea97d779af61dfb))

- **tools.app**: Add tool to create html app
  ([`d8c11e6`](https://github.com/Kitware/trame/commit/d8c11e679500005b976c8e934230aa8ea9f0d072))

- **tools/www**: Make it server independent
  ([`1d7ad31`](https://github.com/Kitware/trame/commit/1d7ad3197d445ffd600d5069c993a44c5f831a18))

### Chores

- **black**: Run black on source code
  ([`ea45740`](https://github.com/Kitware/trame/commit/ea457408e97795003a99e70ae881bcfc395f521f))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **commitlint**: Fix commitlint in CI
  ([`c35973c`](https://github.com/Kitware/trame/commit/c35973ca9029c17a97b16ffbfeb95927ba504430))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **commitlint**: Only run commitlint on PR
  ([`5ed2b65`](https://github.com/Kitware/trame/commit/5ed2b654935441d04a5460fff76f856a23b9cb87))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **docker**: Update scripts to use v2 www tools
  ([`361c976`](https://github.com/Kitware/trame/commit/361c976999dfc39f2daffb45bbde2e2a1c86cbe1))

- **fix**: Fix codespell issues
  ([`1696a9a`](https://github.com/Kitware/trame/commit/1696a9ac36b6a4f0bf136034abf6d080c26babf7))

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **flake8**: Fix flake8 issues
  ([`a66127c`](https://github.com/Kitware/trame/commit/a66127c67504ae4844a69ff5c81093605c2e585f))

Jupyter also had an issue with the __all__ statement that was fixed.

Signed-off-by: Patrick Avery <patrick.avery@kitware.com>

- **tools**: List possible tools to be added
  ([`95a8356`](https://github.com/Kitware/trame/commit/95a8356d461909332848763e4b929391209fe3c4))

- **tools**: List possible tools to be added
  ([`6309364`](https://github.com/Kitware/trame/commit/6309364757553874255baa3eeb05d579d21564c4))

### Continuous Integration

- **actions**: Bring back some basic actions
  ([`fe6d329`](https://github.com/Kitware/trame/commit/fe6d32910cc20a166f1e0c3331e8aa7457290146))

- **actions**: Removed semantic-release
  ([`f176c4c`](https://github.com/Kitware/trame/commit/f176c4cd5f0713788e874dce8db58c39a9128a64))

### Documentation

- **api**: Add missing information
  ([`32a9a4a`](https://github.com/Kitware/trame/commit/32a9a4a47232a24e7c79d3f037cd3c2fad7fcf56))

- **api**: Adding more api doc
  ([`0c9948d`](https://github.com/Kitware/trame/commit/0c9948d03f4a271747965afe7f68b3889e4c9daa))

- **api**: Adding more api doc
  ([`a78df91`](https://github.com/Kitware/trame/commit/a78df91235244a6cff4f688298bee91e98df5096))

- **content**: Fix doc wording
  ([`490196e`](https://github.com/Kitware/trame/commit/490196e62a5252a7b8b50d0b6bda03746d796ce8))

It seemed like "change" was referenced too many times in the same sentence.

- **example**: Add link to v1-v2 delta
  ([`b28723d`](https://github.com/Kitware/trame/commit/b28723d7e9ea56006e230b1898f3d158f77f49d6))

- **example**: Add missing v2 migration
  ([`7b3cda7`](https://github.com/Kitware/trame/commit/7b3cda7c45b8a60132892f762e16ed28cb709481))

- **example**: Fix RemoteSelection for trame v2
  ([`4c2ba6d`](https://github.com/Kitware/trame/commit/4c2ba6d2ebc5c4af0bb6427ecaff0435bf6d4a39))

- **examples**: Add ref to v1 + delta
  ([`c9bc9dc`](https://github.com/Kitware/trame/commit/c9bc9dc80d14c23782c246e3c202d89ffeed3f95))

- **examples**: Update and cleanup examples for v2
  ([`e8ad216`](https://github.com/Kitware/trame/commit/e8ad2164e64ab1656516f399afed639413ee5421))

- **migration**: Add widgets.html info
  ([`4e57496`](https://github.com/Kitware/trame/commit/4e5749670935e6ba684289d9f894782a1151c0a8))

- **rtd**: Update wwww
  ([`13258ad`](https://github.com/Kitware/trame/commit/13258ad7e807d18b5fa7123d28b59f452833a114))

- **website**: Update content to match new api
  ([`5f55d6a`](https://github.com/Kitware/trame/commit/5f55d6a575d3fb6afb28d49adc66e7f1afb22d96))

- **website**: Update landing page
  ([`faba163`](https://github.com/Kitware/trame/commit/faba16314dc229be1b9991fb8b3108d3d94a81a9))
