"""
This type stub file was generated by pyright.
"""

import datetime
from collections.abc import Sequence
from typing import Any
from . import _mssql
from .exceptions import *

__author__: str
__full_version__: str
__version__: str
VERSION: tuple[int, ...]
apilevel: str
threadsafety: int
paramstyle: str
NoParams = _mssql.NoParams

class DBAPIType:
    def __init__(self, value: Any) -> None: ...
    def __cmp__(self, other: Any) -> int: ...
    def __eq__(self, other: object) -> bool: ...

STRING: int
BINARY: int
NUMBER: int
DATETIME: int
DECIMAL: int
Date = datetime.date
Time = datetime.time
Timestamp = datetime.datetime
DateFromTicks: Date
TimeFromTicks: Time
TimestampFromTicks: Timestamp
Binary: bytearray

def row2dict(row: tuple[Any, ...]) -> dict[Any, Any]:
    """Filter dict so it only has string keys; used when as_dict == True"""
    ...

class output:
    object: Any
    value: Any
    def __init__(self, param_type: Any, value: Any | None = None) -> None: ...

class Connection:
    """
    This class represents an MS-SQL database connection.
    """

    as_dict: bool
    autocommit_state: bool
    _conn: _mssql.MSSQLConnection
    arraysize: int
    def __init__(
        self,
        conn: _mssql.MSSQLConnection,
        as_dict: bool,
        autocommit: bool,
        arraysize: int = ...,
    ) -> None: ...
    def __dealloc__(self) -> None: ...
    def autocommit(self, status: bool) -> None:
        """
        Turn autocommit ON or OFF.
        """
        ...

    def __enter__(self) -> Connection: ...
    def __exit__(self, exc_type, exc_value, traceback) -> None: ...
    def close(self) -> None:
        """
        Close the connection to the database. Implicitly rolls back all
        uncommitted transactions.
        """
        ...

    def commit(self) -> None:
        """
        Commit transaction which is currently in progress.
        """
        ...

    def cursor(
        self, as_dict: bool | None = None, arraysize: int | None = None
    ) -> Cursor:
        """
        Return cursor object that can be used to make queries and fetch
        results from the database.
        """
        ...

    def rollback(self) -> None:
        """
        Roll back transaction which is currently in progress.
        """
        ...

    def bulk_copy(
        self,
        table_name: str,
        elements: list,
        column_ids: list[int] | None = None,
        batch_size: int = 1000,
        tablock: bool = False,
        check_constraints: bool = False,
        fire_triggers: bool = False,
    ) -> None: ...

class Cursor:
    """
    This class represents a database cursor, which is used to issue queries
    and fetch results from a database connection.
    """

    connection: Connection
    description: tuple[Any, ...]
    lastrowid: int
    rowcount: int
    returnvalue: object
    rownumber: int
    _source: Connection
    arraysize: int
    def __init__(
        self,
        conn: Connection,
        as_dict: bool,
        arraysize: int = 1,
    ) -> None: ...
    def __iter__(self) -> Cursor:
        """
        Return self to make cursors compatible with Python iteration
        protocol.
        """
        ...

    def __enter__(self) -> Cursor: ...
    def __exit__(self, exc_type, exc_value, traceback) -> None: ...
    def callproc(
        self,
        procname: str,
        parameters: Sequence[str] = ...,
    ) -> tuple[Any, ...]:
        """
        Call a stored procedure with the given name.

        :param procname: The name of the procedure to call
        :type procname: str
        :keyword parameters: The optional parameters for the procedure
        :type parameters: sequence
        """
        ...

    def close(self) -> None:
        """
        Closes the cursor. The cursor is unusable from this point.
        """
        ...

    def execute(self, operation: str, params: object = ...) -> None: ...
    def executemany(
        self,
        operation: str,
        seq_of_parameters: Sequence[str],
        *,
        batch_size: int = -1,
    ) -> None: ...
    def nextset(self) -> int | None: ...
    def getrow(self) -> tuple[Any, ...]:
        """
        Helper method used by fetchone and fetchmany to fetch and handle
        converting the row if as_dict = True.
        """
        ...

    def fetchone(self) -> tuple[Any, ...] | None: ...
    def fetchmany(self, size: int | None = None) -> list[tuple[Any, ...]] | None: ...
    def fetchall(self) -> list[tuple[Any, ...]] | None: ...
    def __next__(self) -> tuple[Any, ...] | None: ...
    def setinputsizes(self, sizes: int | None = None) -> None:
        """
        This method does nothing, as permitted by DB-API specification.
        """
        ...

    def setoutputsize(self, size: int | None = None, column: int = 0) -> None:
        """
        This method does nothing, as permitted by DB-API specification.
        """
        ...

def connect(
    server: str = ".",
    user: str | None = None,
    password: str | None = None,
    database: str = "",
    timeout: int = 0,
    login_timeout: int = 60,
    charset: str = "UTF-8",
    as_dict: bool = False,
    host: str = "",
    appname: str | None = None,
    port: str = "1433",
    encryption: str | None = None,
    read_only: bool = False,
    conn_properties: str | list[str] | None = None,
    autocommit: bool = False,
    tds_version: str | None = None,
    use_datetime2=False,
    arraysize: int = 1,
) -> Connection:
    """
    Constructor for creating a connection to the database. Returns a
    Connection object.

    :param server: database host
    :type server: string
    :param user: database user to connect as. Default value: None.
    :type user: string
    :param password: user's password. Default value: None.
    :type password: string
    :param database: the database to initially connect to
    :type database: string
    :param timeout: query timeout in seconds, default 0 (no timeout)
    :type timeout: int
    :param login_timeout: timeout for connection and login in seconds, default 60
    :type login_timeout: int
    :param charset: character set with which to connect to the database
    :type charset: string
    :keyword as_dict: whether rows should be returned as dictionaries instead of tuples.
    :type as_dict: boolean
    :keyword appname: Set the application name to use for the connection
    :type appname: string
    :keyword port: the TCP port to use to connect to the server
    :type port: string
    :keyword conn_properties: SQL queries to send to the server upon connection
                              establishment. Can be a string or another kind
                              of iterable of strings
    :keyword autocommit: Whether to use default autocommitting mode or not
    :type autocommit: boolean
    :keyword tds_version: TDS protocol version to use.
    :type tds_version: string
    :keyword use_datetime2: Whether to use datetime.datetime conversion compatible with DATETIME2. Default: False.
    :type use_datetime2: bool
    :keyword arraysize:
        This read/write attribute specifies the number of rows to fetch at a time
        with .fetchmany(). It defaults to 1 meaning to fetch a single row at a time.
        Default value: 1.
    :type arraysize: int
    """
    ...

def get_max_connections() -> int:
    """
    Get the maximum number of simultaneous connections pymssql will open
    to the server.
    """
    ...

def set_max_connections(limit: int) -> int:
    """
    Set maximum simultaneous connections db-lib will open to the server.

    :param limit: the connection limit
    :type limit: int
    """
    ...

def get_dbversion() -> str:
    """
    Return string representing the version of db-lib.
    """
    ...

def version_info() -> str:
    """
    Returns string with version information about pymssql, FreeTDS, Python and OS.
    """
    ...
