"""Find my iPhone test constants."""

from typing import Any

from tests.const import CLIENT_ID
from tests.const_account_family import (
    FIRST_NAME,
    FULL_NAME,
    LAST_NAME,
    MEMBER_1_APPLE_ID,
    MEMBER_1_FIRST_NAME,
    MEMBER_1_LAST_NAME,
    MEMBER_1_PERSON_ID,
    MEMBER_2_APPLE_ID,
    MEMBER_2_FIRST_NAME,
    MEMBER_2_LAST_NAME,
    MEMBER_2_PERSON_ID,
    PERSON_ID,
)

# Fakers
UUID = "ABCDEFGH-1234-5678-1234-ABCDEFGHIJKL"
LOCATION_LATITUDE = 45.123456789012345
LOCATION_LONGITUDE = 6.1234567890123456

IPHONE4_1 = "iPhone4,1"
IPHONE12_1 = "iPhone12,1"
MACBOOKPRO10_1 = "MacBookPro10,1"
IPAD7_3 = "iPad7,3"
MACBOOKPRO15_1 = "MacBookPro15,1"
MACBOOK_PRO_15 = "MacBook Pro 15"
MACBOOK_PRO = "MacBook Pro"

# Data
# Re-generated device :
# id = rawDeviceModel + prsId (if not None)
# baUUID = UUID + id
# So they can still be faked and unique
FMI_FAMILY_WORKING: dict[str, Any] = {
    "userInfo": {
        "accountFormatter": 0,
        "firstName": FIRST_NAME,
        "lastName": LAST_NAME,
        "membersInfo": {
            MEMBER_1_PERSON_ID: {
                "accountFormatter": 0,
                "firstName": MEMBER_1_FIRST_NAME,
                "lastName": MEMBER_1_LAST_NAME,
                "deviceFetchStatus": "LOADING",
                "useAuthWidget": True,
                "isHSA": True,
                "appleId": MEMBER_1_APPLE_ID,
            },
            MEMBER_2_PERSON_ID: {
                "accountFormatter": 0,
                "firstName": MEMBER_2_FIRST_NAME,
                "lastName": MEMBER_2_LAST_NAME,
                "deviceFetchStatus": "LOADING",
                "useAuthWidget": True,
                "isHSA": True,
                "appleId": MEMBER_2_APPLE_ID,
            },
        },
        "hasMembers": True,
    },
    "serverContext": {
        "minCallbackIntervalInMS": 5000,
        "enable2FAFamilyActions": False,
        "preferredLanguage": "fr-fr",
        "lastSessionExtensionTime": None,
        "enableMapStats": True,
        "callbackIntervalInMS": 2000,
        "validRegion": True,
        "timezone": {
            "currentOffset": -25200000,
            "previousTransition": 1583661599999,
            "previousOffset": -28800000,
            "tzCurrentName": "Pacific Daylight Time",
            "tzName": "America/Los_Angeles",
        },
        "authToken": None,
        "maxCallbackIntervalInMS": 60000,
        "classicUser": False,
        "isHSA": True,
        "trackInfoCacheDurationInSecs": 86400,
        "imageBaseUrl": "https://statici.icloud.com",
        "minTrackLocThresholdInMts": 100,
        "maxLocatingTime": 90000,
        "sessionLifespan": 900000,
        "info": "info_id",
        "prefsUpdateTime": 1413548552466,
        "useAuthWidget": True,
        "clientId": CLIENT_ID,
        "enable2FAFamilyRemove": False,
        "serverTimestamp": 1585867038112,
        "deviceImageVersion": "4",
        "macCount": 0,
        "deviceLoadStatus": "200",
        "maxDeviceLoadTime": 60000,
        "prsId": PERSON_ID,
        "showSllNow": False,
        "cloudUser": True,
        "enable2FAErase": False,
    },
    "alert": None,
    "userPreferences": {
        "webPrefs": {
            "id": "web_prefs",
            "selectedDeviceId": IPHONE4_1,
        }
    },
    "content": [
        {
            "msg": {
                "strobe": False,
                "userText": False,
                "playSound": True,
                "vibrate": True,
                "createTimestamp": 1584520568680,
                "statusCode": "200",
            },
            "canWipeAfterLock": True,
            "baUUID": UUID + IPHONE12_1,
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": True,
            "passcodeLength": 6,
            "deviceStatus": "200",
            "deviceColor": "1-6-0",
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": False,
                "LST": True,
                "LKM": False,
                "WMG": True,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": False,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": True,
            "rawDeviceModel": IPHONE12_1,
            "id": IPHONE12_1,
            "remoteLock": None,
            "isLocating": True,
            "modelDisplayName": "iPhone",
            "lostTimestamp": "",
            "batteryLevel": 0.8299999833106995,
            "mesg": None,
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": {"createTimestamp": 1584520568680, "statusCode": "200"},
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPhone 11",
            "prsId": None,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "NotCharging",
            "trackingInfo": None,
            "name": "iPhone de " + FIRST_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPhone",
            "location": {
                "isOld": False,
                "isInaccurate": False,
                "altitude": 0.0,
                "positionType": "GPS",
                "latitude": LOCATION_LATITUDE,
                "floorLevel": 0,
                "horizontalAccuracy": 4.5370291025030465,
                "locationType": "",
                "timeStamp": 1585867037749,
                "locationFinished": True,
                "verticalAccuracy": 0.0,
                "longitude": LOCATION_LONGITUDE,
            },
            "deviceModel": "iphone11-1-6-0",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432463,
                "statusCode": "205",
            },
            "canWipeAfterLock": True,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 4,
            "deviceStatus": "203",
            "deviceColor": None,
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": True,
                "LST": True,
                "LKM": False,
                "WMG": False,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": IPHONE4_1,
            "id": IPHONE4_1,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "iPhone",
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": {"createTimestamp": 1583057432463, "statusCode": "205"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": {
                "stopLostMode": False,
                "emailUpdates": True,
                "userText": True,
                "sound": False,
                "ownerNbr": "",
                "text": "",
                "createTimestamp": 1463594549526,
                "statusCode": "2201",
            },
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPhone 4s",
            "prsId": None,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "iPhone " + FULL_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPhone",
            "location": None,
            "deviceModel": "FifthGen",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432463,
                "statusCode": "205",
            },
            "canWipeAfterLock": True,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 4,
            "deviceStatus": "203",
            "deviceColor": "white",
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": True,
                "LST": True,
                "LKM": False,
                "WMG": False,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": "iPod4,1",
            "id": "iPod4,1",
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "iPod",
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": {"createTimestamp": 1583057432463, "statusCode": "205"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPod touch (4th generation)",
            "prsId": None,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "iPod Touch 4 " + MEMBER_2_FIRST_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPod",
            "location": None,
            "deviceModel": "FourthGen-white",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": False,
                "playSound": True,
                "vibrate": False,
                "createTimestamp": 1398963329049,
                "statusCode": "200",
            },
            "canWipeAfterLock": False,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 4,
            "deviceStatus": "203",
            "deviceColor": None,
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": False,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": True,
                "LKL": True,
                "LST": False,
                "LKM": True,
                "WMG": False,
                "PSS": False,
                "PIN": True,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": True,
                "KPD": True,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": MACBOOKPRO10_1,
            "id": MACBOOKPRO10_1,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": MACBOOK_PRO,
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": None,
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": {"createTimestamp": 1398963329049, "statusCode": "200"},
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": False,
            "wipedTimestamp": None,
            "deviceDisplayName": MACBOOK_PRO_15,
            "prsId": None,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "Retina " + MEMBER_2_FIRST_NAME,
            "isMac": True,
            "thisDevice": False,
            "deviceClass": "MacBookPro",
            "location": None,
            "deviceModel": "MacBookPro10_1",
            "maxMsgChar": 500,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432463,
                "statusCode": "200",
            },
            "canWipeAfterLock": False,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 6,
            "deviceStatus": "203",
            "deviceColor": None,
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": False,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": True,
                "LKL": True,
                "LST": False,
                "LKM": True,
                "WMG": False,
                "PSS": False,
                "PIN": True,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": True,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": "MacBookPro11,3",
            "id": "MacBookPro11,3",
            "remoteLock": {"createTimestamp": 1433338956786, "statusCode": "2201"},
            "isLocating": False,
            "modelDisplayName": MACBOOK_PRO,
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": {"createTimestamp": 1583057432463, "statusCode": "200"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": False,
            "wipedTimestamp": None,
            "deviceDisplayName": MACBOOK_PRO_15,
            "prsId": None,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "Retina " + FIRST_NAME,
            "isMac": True,
            "thisDevice": False,
            "deviceClass": "MacBookPro",
            "location": None,
            "deviceModel": "MacBookPro11_3",
            "maxMsgChar": 500,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432463,
                "statusCode": "200",
            },
            "canWipeAfterLock": False,
            "baUUID": UUID + MACBOOKPRO15_1,
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": True,
            "passcodeLength": 6,
            "deviceStatus": "201",
            "deviceColor": "spacegray",
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": False,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": True,
                "LKL": False,
                "LST": False,
                "LKM": True,
                "WMG": False,
                "PSS": False,
                "PIN": True,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": True,
                "KPD": True,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": MACBOOKPRO15_1,
            "id": MACBOOKPRO15_1,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": MACBOOK_PRO,
            "lostTimestamp": "",
            "batteryLevel": 0.26968246698379517,
            "mesg": {"createTimestamp": 1583057432463, "statusCode": "200"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": False,
            "wipedTimestamp": None,
            "deviceDisplayName": MACBOOK_PRO_15,
            "prsId": None,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Charging",
            "trackingInfo": None,
            "name": "MacBook Pro de " + FIRST_NAME,
            "isMac": True,
            "thisDevice": False,
            "deviceClass": "MacBookPro",
            "location": {
                "isOld": False,
                "isInaccurate": False,
                "altitude": 0.0,
                "positionType": "Wifi",
                "latitude": LOCATION_LATITUDE,
                "floorLevel": 0,
                "horizontalAccuracy": 65.0,
                "locationType": "",
                "timeStamp": 1585867020040,
                "locationFinished": False,
                "verticalAccuracy": 0.0,
                "longitude": LOCATION_LONGITUDE,
            },
            "deviceModel": "MacBookPro15_1-spacegray",
            "maxMsgChar": 500,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": None,
            "canWipeAfterLock": False,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 6,
            "deviceStatus": "200",
            "deviceColor": "0",
            "features": {
                "BTR": True,
                "LLC": False,
                "CLK": False,
                "TEU": False,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": False,
                "LST": False,
                "LKM": False,
                "WMG": False,
                "PSS": True,
                "PIN": False,
                "LCK": False,
                "REM": False,
                "MCS": True,
                "KEY": False,
                "KPD": False,
                "WIP": False,
            },
            "lowPowerMode": False,
            "rawDeviceModel": "AirPods_8207",
            "id": "AirPods_8207",
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "Accessory",
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": None,
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": False,
            "wipedTimestamp": None,
            "deviceDisplayName": "Accessory",
            "prsId": None,
            "audioChannels": [
                {"name": "left", "available": 1, "playing": False, "muted": False},
                {"name": "right", "available": 1, "playing": False, "muted": False},
            ],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "AirPods de " + FULL_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "Accessory",
            "location": {
                "isOld": False,
                "isInaccurate": False,
                "altitude": 0.0,
                "positionType": "GPS",
                "latitude": LOCATION_LATITUDE,
                "floorLevel": 0,
                "horizontalAccuracy": 4.5370291025030465,
                "locationType": "",
                "timeStamp": 1585867037749,
                "locationFinished": True,
                "verticalAccuracy": 0.0,
                "longitude": LOCATION_LONGITUDE,
            },
            "deviceModel": "AirPods_8207-0",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": None,
            "canWipeAfterLock": False,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 4,
            "deviceStatus": "201",
            "deviceColor": None,
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": False,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": True,
                "LKL": False,
                "LST": False,
                "LKM": True,
                "WMG": False,
                "PSS": False,
                "PIN": True,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": True,
                "KPD": True,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": MACBOOKPRO10_1,
            "id": MACBOOKPRO10_1 + MEMBER_2_PERSON_ID,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": MACBOOK_PRO,
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": None,
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": False,
            "wipedTimestamp": None,
            "deviceDisplayName": MACBOOK_PRO_15,
            "prsId": MEMBER_2_PERSON_ID,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "MacBook Pro de " + MEMBER_2_FIRST_NAME,
            "isMac": True,
            "thisDevice": False,
            "deviceClass": "MacBookPro",
            "location": None,
            "deviceModel": "MacBookPro10_1",
            "maxMsgChar": 500,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": None,
            "canWipeAfterLock": True,
            "baUUID": UUID + IPHONE12_1 + MEMBER_2_PERSON_ID,
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": True,
            "passcodeLength": 6,
            "deviceStatus": "200",
            "deviceColor": "1-7-0",
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": False,
                "LST": True,
                "LKM": False,
                "WMG": True,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": IPHONE12_1,
            "id": IPHONE12_1 + MEMBER_2_PERSON_ID,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "iPhone",
            "lostTimestamp": "",
            "batteryLevel": 0.3400000035762787,
            "mesg": None,
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": True,
            "snd": None,
            "fmlyShare": False,
            "lostDevice": None,
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPhone 11",
            "prsId": MEMBER_2_PERSON_ID,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "NotCharging",
            "trackingInfo": None,
            "name": "iPhone " + MEMBER_2_FIRST_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPhone",
            "location": None,
            "deviceModel": "iphone11-1-7-0",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432335,
                "statusCode": "200",
            },
            "canWipeAfterLock": False,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 6,
            "deviceStatus": "203",
            "deviceColor": None,
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": False,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": True,
                "LKL": True,
                "LST": False,
                "LKM": True,
                "WMG": False,
                "PSS": False,
                "PIN": True,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": True,
                "KPD": True,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": "iMac10,1",
            "id": "iMac10,1" + MEMBER_1_PERSON_ID,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "iMac",
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": {"createTimestamp": 1583057432335, "statusCode": "200"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": True,
            "lostDevice": None,
            "lostModeCapable": False,
            "wipedTimestamp": None,
            "deviceDisplayName": "iMac",
            "prsId": MEMBER_1_PERSON_ID,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": 'iMac 27" ' + MEMBER_1_LAST_NAME,
            "isMac": True,
            "thisDevice": False,
            "deviceClass": "iMac",
            "location": None,
            "deviceModel": "iMac10_1",
            "maxMsgChar": 500,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": None,
            "canWipeAfterLock": True,
            "baUUID": UUID + IPAD7_3 + MEMBER_1_PERSON_ID,
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": True,
            "passcodeLength": 6,
            "deviceStatus": "201",
            "deviceColor": "2-2-0",
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": True,
                "LST": True,
                "LKM": False,
                "WMG": True,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": IPAD7_3,
            "id": IPAD7_3 + MEMBER_1_PERSON_ID,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "iPad",
            "lostTimestamp": "",
            "batteryLevel": 0.3799999952316284,
            "mesg": None,
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": True,
            "lostDevice": None,
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPad Pro",
            "prsId": MEMBER_1_PERSON_ID,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "NotCharging",
            "trackingInfo": None,
            "name": "iPad " + MEMBER_1_LAST_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPad",
            "location": None,
            "deviceModel": "NinthGen-2-2-0",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432335,
                "statusCode": "205",
            },
            "canWipeAfterLock": True,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": False,
            "passcodeLength": 4,
            "deviceStatus": "203",
            "deviceColor": None,
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": True,
                "LST": True,
                "LKM": False,
                "WMG": False,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": False,
            "rawDeviceModel": IPHONE4_1,
            "id": IPHONE4_1 + MEMBER_1_PERSON_ID,
            "remoteLock": None,
            "isLocating": False,
            "modelDisplayName": "iPhone",
            "lostTimestamp": "",
            "batteryLevel": 0.0,
            "mesg": {"createTimestamp": 1583057432335, "statusCode": "205"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": True,
            "lostDevice": None,
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPhone 4s",
            "prsId": MEMBER_1_PERSON_ID,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "Unknown",
            "trackingInfo": None,
            "name": "iPhone",
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPhone",
            "location": None,
            "deviceModel": "FifthGen",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
        {
            "msg": {
                "strobe": False,
                "userText": True,
                "playSound": False,
                "vibrate": False,
                "createTimestamp": 1583057432335,
                "statusCode": "200",
            },
            "canWipeAfterLock": True,
            "baUUID": "",
            "wipeInProgress": False,
            "lostModeEnabled": False,
            "activationLocked": True,
            "passcodeLength": 6,
            "deviceStatus": "201",
            "deviceColor": "e1e4e3-d7d9d8",
            "features": {
                "BTR": False,
                "LLC": False,
                "CLK": False,
                "TEU": True,
                "SND": True,
                "CLT": False,
                "SVP": False,
                "SPN": False,
                "XRM": False,
                "CWP": False,
                "MSG": True,
                "LOC": True,
                "LMG": False,
                "LKL": False,
                "LST": True,
                "LKM": False,
                "WMG": True,
                "PSS": False,
                "PIN": False,
                "LCK": True,
                "REM": True,
                "MCS": False,
                "KEY": False,
                "KPD": False,
                "WIP": True,
            },
            "lowPowerMode": True,
            "rawDeviceModel": "iPhone6,2",
            "id": "iPhone6,2" + MEMBER_1_PERSON_ID,
            "remoteLock": None,
            "isLocating": True,
            "modelDisplayName": "iPhone",
            "lostTimestamp": "",
            "batteryLevel": 0.800000011920929,
            "mesg": {"createTimestamp": 1583057432335, "statusCode": "200"},
            "locationEnabled": True,
            "lockedTimestamp": None,
            "locFoundEnabled": False,
            "snd": None,
            "fmlyShare": True,
            "lostDevice": None,
            "lostModeCapable": True,
            "wipedTimestamp": None,
            "deviceDisplayName": "iPhone 5s",
            "prsId": MEMBER_1_PERSON_ID,
            "audioChannels": [],
            "locationCapable": True,
            "batteryStatus": "NotCharging",
            "trackingInfo": None,
            "name": "iPhone de " + MEMBER_1_FIRST_NAME,
            "isMac": False,
            "thisDevice": False,
            "deviceClass": "iPhone",
            "location": {
                "isOld": False,
                "isInaccurate": False,
                "altitude": 0.0,
                "positionType": "GPS",
                "latitude": LOCATION_LATITUDE,
                "floorLevel": 0,
                "horizontalAccuracy": 50.0,
                "locationType": "",
                "timeStamp": 1585866941186,
                "locationFinished": False,
                "verticalAccuracy": 0.0,
                "longitude": LOCATION_LONGITUDE,
            },
            "deviceModel": "5s-e1e4e3-d7d9d8",
            "maxMsgChar": 160,
            "darkWake": False,
            "remoteWipe": None,
        },
    ],
    "statusCode": "200",
}
