/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absent\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"conditional\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"empty\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"error\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"format\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"indent\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"json\0"
	"json_array\0"
	"json_arrayagg\0"
	"json_exists\0"
	"json_object\0"
	"json_objectagg\0"
	"json_query\0"
	"json_scalar\0"
	"json_serialize\0"
	"json_table\0"
	"json_value\0"
	"keep\0"
	"key\0"
	"keys\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"merge_action\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"nested\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"omit\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"path\0"
	"pgpool\0"
	"placing\0"
	"plan\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"quotes\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"scalar\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"source\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"string\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"system_user\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"target\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unconditional\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	13,
	22,
	29,
	36,
	40,
	46,
	52,
	62,
	66,
	71,
	77,
	84,
	92,
	100,
	104,
	108,
	114,
	117,
	121,
	132,
	142,
	153,
	164,
	167,
	174,
	181,
	191,
	205,
	214,
	221,
	227,
	235,
	242,
	249,
	253,
	261,
	266,
	274,
	277,
	283,
	288,
	295,
	303,
	312,
	317,
	322,
	330,
	336,
	341,
	351,
	367,
	373,
	384,
	390,
	396,
	404,
	413,
	421,
	431,
	438,
	446,
	454,
	463,
	470,
	480,
	492,
	505,
	517,
	531,
	540,
	551,
	562,
	574,
	582,
	591,
	602,
	607,
	612,
	619,
	625,
	629,
	634,
	642,
	658,
	671,
	684,
	699,
	712,
	730,
	743,
	750,
	756,
	761,
	770,
	774,
	785,
	789,
	797,
	805,
	813,
	822,
	833,
	842,
	850,
	857,
	867,
	878,
	886,
	892,
	897,
	904,
	915,
	923,
	931,
	940,
	943,
	952,
	959,
	966,
	971,
	976,
	981,
	987,
	994,
	1003,
	1013,
	1017,
	1022,
	1028,
	1035,
	1041,
	1048,
	1056,
	1066,
	1076,
	1084,
	1091,
	1099,
	1110,
	1120,
	1129,
	1137,
	1143,
	1150,
	1156,
	1163,
	1172,
	1178,
	1184,
	1194,
	1198,
	1204,
	1212,
	1219,
	1227,
	1234,
	1239,
	1244,
	1253,
	1263,
	1273,
	1280,
	1286,
	1294,
	1303,
	1309,
	1318,
	1325,
	1333,
	1340,
	1347,
	1352,
	1357,
	1366,
	1369,
	1375,
	1385,
	1395,
	1404,
	1411,
	1414,
	1422,
	1432,
	1442,
	1449,
	1455,
	1463,
	1471,
	1480,
	1490,
	1497,
	1503,
	1509,
	1515,
	1527,
	1534,
	1542,
	1546,
	1554,
	1564,
	1573,
	1578,
	1586,
	1589,
	1596,
	1606,
	1611,
	1616,
	1627,
	1641,
	1653,
	1665,
	1680,
	1691,
	1703,
	1718,
	1729,
	1740,
	1745,
	1749,
	1754,
	1760,
	1769,
	1775,
	1780,
	1788,
	1796,
	1806,
	1812,
	1817,
	1823,
	1828,
	1834,
	1841,
	1846,
	1852,
	1862,
	1877,
	1886,
	1891,
	1898,
	1905,
	1913,
	1919,
	1927,
	1940,
	1949,
	1955,
	1968,
	1975,
	1982,
	1991,
	1996,
	2002,
	2007,
	2012,
	2018,
	2027,
	2035,
	2041,
	2048,
	2052,
	2057,
	2061,
	2065,
	2070,
	2075,
	2078,
	2083,
	2093,
	2104,
	2108,
	2116,
	2123,
	2131,
	2138,
	2143,
	2150,
	2156,
	2164,
	2171,
	2174,
	2178,
	2185,
	2190,
	2194,
	2199,
	2202,
	2207,
	2216,
	2223,
	2231,
	2234,
	2240,
	2251,
	2258,
	2262,
	2268,
	2273,
	2282,
	2290,
	2301,
	2307,
	2313,
	2322,
	2332,
	2339,
	2347,
	2357,
	2365,
	2374,
	2379,
	2386,
	2394,
	2399,
	2405,
	2412,
	2421,
	2431,
	2441,
	2449,
	2458,
	2467,
	2475,
	2481,
	2492,
	2503,
	2513,
	2524,
	2532,
	2544,
	2550,
	2557,
	2563,
	2568,
	2573,
	2582,
	2590,
	2600,
	2604,
	2615,
	2627,
	2635,
	2643,
	2652,
	2660,
	2667,
	2678,
	2686,
	2694,
	2700,
	2708,
	2717,
	2724,
	2734,
	2742,
	2749,
	2755,
	2760,
	2769,
	2776,
	2784,
	2793,
	2797,
	2802,
	2807,
	2817,
	2824,
	2831,
	2839,
	2846,
	2853,
	2860,
	2869,
	2876,
	2885,
	2895,
	2908,
	2915,
	2923,
	2936,
	2940,
	2946,
	2951,
	2957,
	2962,
	2970,
	2977,
	2982,
	2991,
	3000,
	3005,
	3012,
	3016,
	3023,
	3034,
	3040,
	3050,
	3061,
	3067,
	3074,
	3082,
	3089,
	3096,
	3103,
	3109,
	3122,
	3132,
	3140,
	3150,
	3156,
	3163,
	3175,
	3181,
	3188,
	3200,
	3211,
	3218,
	3223,
	3232,
	3242,
	3247,
	3252,
	3257,
	3262,
	3272,
	3275,
	3284,
	3296,
	3306,
	3312,
	3320,
	3325,
	3330,
	3339,
	3347,
	3352,
	3358,
	3366,
	3376,
	3388,
	3402,
	3414,
	3420,
	3427,
	3435,
	3444,
	3453,
	3459,
	3466,
	3471,
	3477,
	3484,
	3490,
	3499,
	3509,
	3515,
	3522,
	3530,
	3539,
	3547,
	3555,
	3563,
	3568,
	3574,
	3583,
	3588,
	3594,
	3605,
	3612,
	3617,
	3624,
	3632,
	3637,
	3645,
	3651,
	3655,
	3669,
	3679,
	3690,
	3700,
	3710,
	3724,
	3733,
	3739,
	3747,
	3760,
	3769,
	3774,
	3778,
};

#define SCANKEYWORDS_NUM_KEYWORDS 492

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[985] = {
		-2,    143,   32767, 200,   0,     0,     448,   302,
		769,   -52,   32767, 0,     32767, 0,     32767, 0,
		281,   253,   248,   612,   32767, 8,     -436,  0,
		32767, 0,     32767, 354,   -267,  362,   32767, 32767,
		568,   32767, 0,     32767, 289,   32767, 75,    32767,
		32767, 33,    32767, 165,   0,     32767, 32767, 32767,
		32767, -97,   32767, 358,   78,    -272,  73,    339,
		2,     386,   43,    32767, 0,     32767, 508,   -93,
		-589,  -159,  -10,   0,     -8,    32767, -359,  32767,
		288,   -224,  58,    32767, -226,  -10,   201,   32767,
		347,   32767, 255,   0,     464,   -8,    0,     32767,
		225,   32767, -118,  32767, -658,  305,   297,   -235,
		32767, 177,   -393,  0,     -43,   136,   32767, 32767,
		32767, 0,     270,   -106,  190,   32767, 65,    32767,
		32767, 32767, 32767, -77,   32767, 148,   -179,  334,
		0,     32767, 0,     32767, 32767, 280,   477,   346,
		32767, 148,   335,   66,    265,   -204,  32767, 9,
		-158,  32767, 372,   16,    32767, 227,   -247,  0,
		228,   -598,  32767, 257,   32767, 32767, 32767, 32767,
		32767, 402,   32767, 32767, 332,   -42,   603,   32767,
		32767, 32767, 971,   -38,   32767, 242,   0,     221,
		-109,  459,   310,   126,   32767, 32767, 114,   -410,
		130,   0,     32767, 312,   32767, 313,   32767, 392,
		516,   217,   32767, 0,     70,    32767, 478,   33,
		32767, 303,   32767, 0,     59,    194,   32767, 32767,
		0,     116,   0,     32767, 0,     32767, 32767, -325,
		81,    -325,  32767, 0,     -204,  0,     0,     32767,
		460,   32767, 0,     379,   375,   32767, 303,   159,
		32767, -24,   32767, 32767, 32767, 511,   32767, -185,
		-622,  32767, 32767, 32767, 304,   1204,  0,     520,
		542,   593,   -52,   32767, 32767, 291,   32767, 344,
		0,     31,    -121,  0,     32767, 32767, 32767, 347,
		0,     32767, 32767, -1259, 0,     32767, 32767, 32767,
		480,   40,    153,   35,    582,   32767, 34,    115,
		32767, -83,   32767, 32767, 36,    324,   -434,  32767,
		430,   -24,   -95,   32767, 32767, 32767, 172,   -1264,
		-236,  -110,  32767, 87,    -227,  179,   305,   0,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     134,
		32767, 299,   32767, 32767, 25,    0,     14,    -38,
		32767, 105,   392,   32767, 32767, 437,   32767, 32767,
		446,   32767, 358,   264,   209,   32767, 238,   596,
		156,   -689,  32767, 435,   32767, 85,    -9,    -155,
		414,   0,     65,    32767, 32767, -94,   354,   46,
		69,    -119,  185,   275,   1727,  32767, 32767, -99,
		32767, 445,   32767, -975,  -183,  32767, 32767, 479,
		78,    32767, 0,     32767, 32767, 32767, 452,   252,
		32767, 0,     378,   32767, 32767, -34,   88,    13,
		32767, 32767, 32767, 32767, 107,   32767, 32767, -86,
		298,   1307,  180,   32767, 32767, 32767, 32767, -150,
		95,    0,     32767, 377,   32767, 182,   32767, -1192,
		287,   32767, 0,     554,   -1011, 32767, 346,   26,
		0,     32767, 338,   426,   32767, 652,   240,   -244,
		0,     118,   32767, -203,  133,   32767, 79,    0,
		94,    32767, 456,   32767, -657,  462,   32767, 266,
		158,   781,   32767, -273,  32767, 351,   0,     32767,
		392,   0,     89,    32767, 41,    370,   32767, 61,
		-148,  32767, 32767, -37,   32767, -76,   315,   32767,
		32767, 32767, 358,   139,   56,    458,   32767, 415,
		32767, 32767, 653,   32767, 32767, 32767, -236,  32767,
		0,     0,     615,   32767, 0,     32767, 55,    -912,
		32767, 113,   206,   32767, 32767, 32767, 32767, 0,
		32767, 96,    32767, 396,   175,   129,   32767, 32767,
		138,   -147,  32767, 32767, -157,  270,   32767, -460,
		263,   448,   32767, 32767, 0,     371,   32767, 32767,
		32767, 32767, -283,  32767, 32767, 197,   0,     32767,
		374,   581,   -549,  32767, 32767, 56,    32767, 0,
		234,   -115,  32767, -439,  466,   32767, 32767, 0,
		388,   184,   32767, 32767, 83,    32767, 32767, 120,
		-277,  0,     32767, 0,     180,   32767, 0,     205,
		32767, 32767, 219,   0,     32767, 32767, -32,   159,
		32767, 204,   0,     826,   495,   32767, 190,   0,
		400,   379,   32767, 32767, -108,  72,    459,   32767,
		32767, 0,     92,    32767, 276,   133,   32767, 32767,
		160,   -36,   32767, 70,    871,   32767, 32767, -436,
		32767, 32767, 980,   385,   0,     9,     32767, 327,
		519,   0,     32767, 0,     -31,   0,     11,    0,
		32767, 412,   124,   -121,  377,   0,     32767, 32767,
		0,     137,   32767, 66,    -123,  264,   -50,   3,
		-190,  21,    32767, 267,   32767, 0,     0,     32767,
		32767, 32767, 221,   32767, 32767, -301,  38,    -319,
		389,   32767, 32767, 275,   964,   -30,   330,   172,
		32767, 329,   -299,  32767, 524,   341,   32767, 32767,
		123,   -76,   415,   151,   32767, 179,   0,     -365,
		32767, -268,  32767, -425,  203,   0,     146,   32767,
		290,   32767, 259,   32767, 0,     1,     32767, 239,
		160,   914,   39,    32767, -194,  104,   0,     0,
		32767, 32767, 32767, 0,     32767, 32767, 10,    487,
		0,     279,   32767, 223,   32767, 32767, 0,     -286,
		-510,  151,   429,   32767, 0,     115,   32767, -66,
		647,   291,   32767, -290,  32767, 0,     -433,  0,
		180,   32767, 116,   32767, 301,   32767, 282,   294,
		0,     32767, -126,  0,     -412,  0,     315,   32767,
		400,   0,     32767, 32767, 32767, 109,   -227,  0,
		-352,  32767, 112,   0,     471,   0,     32767, 32767,
		461,   32767, 32767, 233,   32767, 32767, 406,   32767,
		464,   32767, 118,   382,   0,     32767, 0,     32767,
		32767, 541,   -305,  814,   0,     268,   0,     403,
		268,   372,   84,    32767, -91,   32767, 0,     32767,
		208,   467,   0,     32767, 32767, 32767, -236,  32767,
		32767, -53,   -317,  32767, 338,   0,     0,     646,
		32767, 78,    32767, 158,   399,   0,     32767, 0,
		-269,  32767, 32767, -213,  -786,  32767, 162,   32767,
		32767, -259,  401,   383,   453,   0,     32767, 0,
		-232,  -159,  322,   32767, 32767, 203,   0,     32767,
		183,   314,   32767, -86,   32767, 377,   195,   878,
		93,    -80,   212,   32767, 49,    32767, 614,   337,
		32767, 318,   -59,   285,   32767, 0,     32767, 0,
		98,    17,    32767, 0,     -192,  482,   0,     32767,
		102,   32767, 331,   366,   0,     -325,  -143,  438,
		465,   35,    472,   32767, 670,   32767, 0,     0,
		32767, 32767, 32767, 0,     109,   226,   32767, 32767,
		25,    -227,  0,     0,     768,   32767, -363,  32767,
		245,   129,   32767, 405,   95,    407,   345,   1494,
		32767, 0,     473,   32767, 32767, 32767, 32767, 0,
		0,     32767, 32767, 244,   32767, 82,    32767, 38,
		32767, 97,    -39,   397,   32767, 32767, 32767, 32767,
		32767, 90,    605,   105,   32767, 0,     0,     0,
		250,   32767, 372,   32767, 32767, 0,     -434,  0,
		32767, 216,   32767, 443,   32767, 185,   51,    367,
		32767, 87,    0,     560,   0,     0,     0,     0,
		349,   -120,  32767, 32767, 408,   32767, 32767, 0,
		32767, 0,     32767, 32767, 32767, 744,   250,   -146,
		32767, 142,   0,     -492,  32767, 334,   441,   32767,
		0
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 31 + c;
	}
	return h[a % 985] + h[b % 985];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
