find_path(MBEDTLS_INCLUDE_DIRS mbedtls/ssl.h)

find_library(MBEDTLS_LIBRARY mbedtls)
find_library(MBEDX509_LIBRARY mbedx509)
find_library(MBEDCRYPTO_LIBRARY mbedcrypto)

set(MBEDTLS_LIBRARIES
    "${MBEDTLS_LIBRARY}"
    "${MBEDX509_LIBRARY}"
    "${MBEDCRYPTO_LIBRARY}")

if(MBEDTLS_LIBRARY)
  set(MbedTLS_FOUND TRUE)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
  MBEDTLS
  DEFAULT_MSG
  MBEDTLS_INCLUDE_DIRS
  MBEDTLS_LIBRARY
  MBEDX509_LIBRARY
  MBEDCRYPTO_LIBRARY)

mark_as_advanced(
  MBEDTLS_INCLUDE_DIRS
  MBEDTLS_LIBRARY
  MBEDX509_LIBRARY
  MBEDCRYPTO_LIBRARY)

message(STATUS "MBEDTLS_INCLUDE_DIRS: ${MBEDTLS_INCLUDE_DIRS}")
message(STATUS "MBEDTLS_LIBRARY: ${MBEDTLS_LIBRARY}")
message(STATUS "MBEDX509_LIBRARY: ${MBEDX509_LIBRARY}")
message(STATUS "MBEDCRYPTO_LIBRARY: ${MBEDCRYPTO_LIBRARY}")
message(STATUS "MBEDTLS_LIBRARIES: ${MBEDTLS_LIBRARIES}")
