//go:build linux && cgo && !agent

// Code generated by generate-database from the incus project - DO NOT EDIT.

package cluster

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
	"strings"
)

var networkPeerObjects = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByName = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.name = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByID = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.id = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByNetworkID = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.network_id = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByTargetNetworkID = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.target_network_id = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByNetworkIDAndName = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.network_id = ? AND networks_peers.name = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByNetworkIDAndID = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.network_id = ? AND networks_peers.id = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByNetworkIDAndTargetNetworkProjectAndTargetNetworkName = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.network_id = ? AND networks_peers.target_network_project = ? AND networks_peers.target_network_name = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerObjectsByTypeAndTargetNetworkProjectAndTargetNetworkName = RegisterStmt(`
SELECT networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id
  FROM networks_peers
  WHERE ( networks_peers.type = ? AND networks_peers.target_network_project = ? AND networks_peers.target_network_name = ? )
  ORDER BY networks_peers.network_id, networks_peers.name
`)

var networkPeerCreate = RegisterStmt(`
INSERT INTO networks_peers (network_id, name, description, type, target_network_project, target_network_name, target_network_integration_id, target_network_id)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?)
`)

var networkPeerID = RegisterStmt(`
SELECT networks_peers.id FROM networks_peers
  WHERE networks_peers.network_id = ? AND networks_peers.name = ?
`)

var networkPeerUpdate = RegisterStmt(`
UPDATE networks_peers
  SET network_id = ?, name = ?, description = ?, type = ?, target_network_project = ?, target_network_name = ?, target_network_integration_id = ?, target_network_id = ?
 WHERE id = ?
`)

var networkPeerDeleteByNetworkIDAndID = RegisterStmt(`
DELETE FROM networks_peers WHERE network_id = ? AND id = ?
`)

// networkPeerColumns returns a string of column names to be used with a SELECT statement for the entity.
// Use this function when building statements to retrieve database entries matching the NetworkPeer entity.
func networkPeerColumns() string {
	return "networks_peers.id, networks_peers.network_id, networks_peers.name, networks_peers.description, networks_peers.type, networks_peers.target_network_project, networks_peers.target_network_name, networks_peers.target_network_integration_id, networks_peers.target_network_id"
}

// getNetworkPeers can be used to run handwritten sql.Stmts to return a slice of objects.
func getNetworkPeers(ctx context.Context, stmt *sql.Stmt, args ...any) ([]NetworkPeer, error) {
	objects := make([]NetworkPeer, 0)

	dest := func(scan func(dest ...any) error) error {
		n := NetworkPeer{}
		err := scan(&n.ID, &n.NetworkID, &n.Name, &n.Description, &n.Type, &n.TargetNetworkProject, &n.TargetNetworkName, &n.TargetNetworkIntegrationID, &n.TargetNetworkID)
		if err != nil {
			return err
		}

		objects = append(objects, n)

		return nil
	}

	err := selectObjects(ctx, stmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"networks_peers\" table: %w", err)
	}

	return objects, nil
}

// getNetworkPeersRaw can be used to run handwritten query strings to return a slice of objects.
func getNetworkPeersRaw(ctx context.Context, db dbtx, sql string, args ...any) ([]NetworkPeer, error) {
	objects := make([]NetworkPeer, 0)

	dest := func(scan func(dest ...any) error) error {
		n := NetworkPeer{}
		err := scan(&n.ID, &n.NetworkID, &n.Name, &n.Description, &n.Type, &n.TargetNetworkProject, &n.TargetNetworkName, &n.TargetNetworkIntegrationID, &n.TargetNetworkID)
		if err != nil {
			return err
		}

		objects = append(objects, n)

		return nil
	}

	err := scan(ctx, db, sql, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"networks_peers\" table: %w", err)
	}

	return objects, nil
}

// GetNetworkPeers returns all available network_peers.
// generator: network_peer GetMany
func GetNetworkPeers(ctx context.Context, db dbtx, filters ...NetworkPeerFilter) (_ []NetworkPeer, _err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	var err error

	// Result slice.
	objects := make([]NetworkPeer, 0)

	// Pick the prepared statement and arguments to use based on active criteria.
	var sqlStmt *sql.Stmt
	args := []any{}
	queryParts := [2]string{}

	if len(filters) == 0 {
		sqlStmt, err = Stmt(db, networkPeerObjects)
		if err != nil {
			return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
		}
	}

	for i, filter := range filters {
		if filter.Type != nil && filter.TargetNetworkProject != nil && filter.TargetNetworkName != nil && filter.ID == nil && filter.NetworkID == nil && filter.Name == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.Type, filter.TargetNetworkProject, filter.TargetNetworkName}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByTypeAndTargetNetworkProjectAndTargetNetworkName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByTypeAndTargetNetworkProjectAndTargetNetworkName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByTypeAndTargetNetworkProjectAndTargetNetworkName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.NetworkID != nil && filter.TargetNetworkProject != nil && filter.TargetNetworkName != nil && filter.ID == nil && filter.Name == nil && filter.Type == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.NetworkID, filter.TargetNetworkProject, filter.TargetNetworkName}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByNetworkIDAndTargetNetworkProjectAndTargetNetworkName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByNetworkIDAndTargetNetworkProjectAndTargetNetworkName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByNetworkIDAndTargetNetworkProjectAndTargetNetworkName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.NetworkID != nil && filter.Name != nil && filter.ID == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.NetworkID, filter.Name}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByNetworkIDAndName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByNetworkIDAndName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByNetworkIDAndName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.NetworkID != nil && filter.ID != nil && filter.Name == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.NetworkID, filter.ID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByNetworkIDAndID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByNetworkIDAndID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByNetworkIDAndID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.TargetNetworkID != nil && filter.ID == nil && filter.NetworkID == nil && filter.Name == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil {
			args = append(args, []any{filter.TargetNetworkID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByTargetNetworkID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByTargetNetworkID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByTargetNetworkID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.NetworkID != nil && filter.ID == nil && filter.Name == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.NetworkID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByNetworkID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByNetworkID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByNetworkID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.Name != nil && filter.ID == nil && filter.NetworkID == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.Name}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID != nil && filter.NetworkID == nil && filter.Name == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			args = append(args, []any{filter.ID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, networkPeerObjectsByID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"networkPeerObjectsByID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(networkPeerObjectsByID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"networkPeerObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID == nil && filter.NetworkID == nil && filter.Name == nil && filter.Type == nil && filter.TargetNetworkProject == nil && filter.TargetNetworkName == nil && filter.TargetNetworkIntegrationID == nil && filter.TargetNetworkID == nil {
			return nil, fmt.Errorf("Cannot filter on empty NetworkPeerFilter")
		} else {
			return nil, errors.New("No statement exists for the given Filter")
		}
	}

	// Select.
	if sqlStmt != nil {
		objects, err = getNetworkPeers(ctx, sqlStmt, args...)
	} else {
		queryStr := strings.Join(queryParts[:], "ORDER BY")
		objects, err = getNetworkPeersRaw(ctx, db, queryStr, args...)
	}

	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"networks_peers\" table: %w", err)
	}

	return objects, nil
}

// GetNetworkPeerConfig returns all available NetworkPeer Config
// generator: network_peer GetMany
func GetNetworkPeerConfig(ctx context.Context, db tx, networkPeerID int, filters ...ConfigFilter) (_ map[string]string, _err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	networkPeerConfig, err := GetConfig(ctx, db, "networks_peers", "network_peer", filters...)
	if err != nil {
		return nil, err
	}

	config, ok := networkPeerConfig[networkPeerID]
	if !ok {
		config = map[string]string{}
	}

	return config, nil
}

// GetNetworkPeer returns the network_peer with the given key.
// generator: network_peer GetOne
func GetNetworkPeer(ctx context.Context, db dbtx, networkID int64, name string) (_ *NetworkPeer, _err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	filter := NetworkPeerFilter{}
	filter.NetworkID = &networkID
	filter.Name = &name

	objects, err := GetNetworkPeers(ctx, db, filter)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"networks_peers\" table: %w", err)
	}

	switch len(objects) {
	case 0:
		return nil, ErrNotFound
	case 1:
		return &objects[0], nil
	default:
		return nil, fmt.Errorf("More than one \"networks_peers\" entry matches")
	}
}

// NetworkPeerExists checks if a network_peer with the given key exists.
// generator: network_peer Exists
func NetworkPeerExists(ctx context.Context, db dbtx, networkID int64, name string) (_ bool, _err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	stmt, err := Stmt(db, networkPeerID)
	if err != nil {
		return false, fmt.Errorf("Failed to get \"networkPeerID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, networkID, name)
	var id int64
	err = row.Scan(&id)
	if errors.Is(err, sql.ErrNoRows) {
		return false, nil
	}

	if err != nil {
		return false, fmt.Errorf("Failed to get \"networks_peers\" ID: %w", err)
	}

	return true, nil
}

// CreateNetworkPeer adds a new network_peer to the database.
// generator: network_peer Create
func CreateNetworkPeer(ctx context.Context, db dbtx, object NetworkPeer) (_ int64, _err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	args := make([]any, 8)

	// Populate the statement arguments.
	args[0] = object.NetworkID
	args[1] = object.Name
	args[2] = object.Description
	args[3] = object.Type
	args[4] = object.TargetNetworkProject
	args[5] = object.TargetNetworkName
	args[6] = object.TargetNetworkIntegrationID
	args[7] = object.TargetNetworkID

	// Prepared statement to use.
	stmt, err := Stmt(db, networkPeerCreate)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"networkPeerCreate\" prepared statement: %w", err)
	}

	// Execute the statement.
	result, err := stmt.Exec(args...)
	if err != nil && strings.HasPrefix(err.Error(), "UNIQUE constraint failed:") {
		return -1, ErrConflict
	}

	if err != nil {
		return -1, fmt.Errorf("Failed to create \"networks_peers\" entry: %w", err)
	}

	id, err := result.LastInsertId()
	if err != nil {
		return -1, fmt.Errorf("Failed to fetch \"networks_peers\" entry ID: %w", err)
	}

	return id, nil
}

// CreateNetworkPeerConfig adds new network_peer Config to the database.
// generator: network_peer Create
func CreateNetworkPeerConfig(ctx context.Context, db dbtx, networkPeerID int64, config map[string]string) (_err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	referenceID := int(networkPeerID)
	for key, value := range config {
		insert := Config{
			ReferenceID: referenceID,
			Key:         key,
			Value:       value,
		}

		err := CreateConfig(ctx, db, "networks_peers", "network_peer", insert)
		if err != nil {
			return fmt.Errorf("Insert Config failed for NetworkPeer: %w", err)
		}

	}

	return nil
}

// GetNetworkPeerID return the ID of the network_peer with the given key.
// generator: network_peer ID
func GetNetworkPeerID(ctx context.Context, db tx, networkID int64, name string) (_ int64, _err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	stmt, err := Stmt(db, networkPeerID)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"networkPeerID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, networkID, name)
	var id int64
	err = row.Scan(&id)
	if errors.Is(err, sql.ErrNoRows) {
		return -1, ErrNotFound
	}

	if err != nil {
		return -1, fmt.Errorf("Failed to get \"networks_peers\" ID: %w", err)
	}

	return id, nil
}

// DeleteNetworkPeer deletes the network_peer matching the given key parameters.
// generator: network_peer DeleteOne-by-NetworkID-and-ID
func DeleteNetworkPeer(ctx context.Context, db dbtx, networkID int64, id int64) (_err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	stmt, err := Stmt(db, networkPeerDeleteByNetworkIDAndID)
	if err != nil {
		return fmt.Errorf("Failed to get \"networkPeerDeleteByNetworkIDAndID\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(networkID, id)
	if err != nil {
		return fmt.Errorf("Delete \"networks_peers\": %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n == 0 {
		return ErrNotFound
	} else if n > 1 {
		return fmt.Errorf("Query deleted %d NetworkPeer rows instead of 1", n)
	}

	return nil
}

// UpdateNetworkPeer updates the network_peer matching the given key parameters.
// generator: network_peer Update
func UpdateNetworkPeer(ctx context.Context, db tx, networkID int64, name string, object NetworkPeer) (_err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	id, err := GetNetworkPeerID(ctx, db, networkID, name)
	if err != nil {
		return err
	}

	stmt, err := Stmt(db, networkPeerUpdate)
	if err != nil {
		return fmt.Errorf("Failed to get \"networkPeerUpdate\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(object.NetworkID, object.Name, object.Description, object.Type, object.TargetNetworkProject, object.TargetNetworkName, object.TargetNetworkIntegrationID, object.TargetNetworkID, id)
	if err != nil {
		return fmt.Errorf("Update \"networks_peers\" entry failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query updated %d rows instead of 1", n)
	}

	return nil
}

// UpdateNetworkPeerConfig updates the network_peer Config matching the given key parameters.
// generator: network_peer Update
func UpdateNetworkPeerConfig(ctx context.Context, db tx, networkPeerID int64, config map[string]string) (_err error) {
	defer func() {
		_err = mapErr(_err, "Network_peer")
	}()

	err := UpdateConfig(ctx, db, "networks_peers", "network_peer", int(networkPeerID), config)
	if err != nil {
		return fmt.Errorf("Replace Config for NetworkPeer failed: %w", err)
	}

	return nil
}
