"""
Below are flex arrays with x,y,z points for numerical integration on a sphere with unit weights, a so called
spherical t-design

The design implemented below contains 100 points and provides exact integrals over the surface for polynomial
functions on that sphere up to order 13.

The design has been taken from

http://www2.research.att.com/~njas/sphdesigns/dim3/

"""
from __future__ import absolute_import, division, print_function
from scitbx.array_family import flex

t_x = flex.double([ 0.845786926423 , -0.0634417983892 , -0.845786926456 , -0.529735418328 , 0.0634417986396 , -0.529735418346 , 0.0634417984036 , 0.529735418468 , -0.0634417984896 , 0.52973541844 , 0.845786926346 , -0.845786926415 , 0.929917825559 , -0.196162596035 , -0.929917825491 , 0.311083708412 , 0.196162596119 , 0.311083708425 , 0.196162596063 , -0.311083708452 , -0.196162595926 , -0.311083708551 , 0.929917825507 , -0.929917825406 , -0.842584243732 , -0.495799724243 , 0.842584243612 , -0.210319816656 , 0.495799724512 , -0.210319816854 , 0.495799724443 , 0.210319816609 , -0.495799724459 , 0.210319816771 , -0.842584243891 , 0.842584243715 , 0.896721022727 , 0.311078300883 , -0.896721022772 , 0.314835985985 , -0.311078301038 , 0.314835986057 , -0.31107830098 , -0.314835986039 , 0.31107830104 , -0.314835986019 , 0.896721022766 , -0.896721022776 , -0.986889783137 , -0.155620975564 , 0.986889783118 , 0.0427863048269 , 0.15562097569 , 0.0427863047153 , 0.155620975706 , -0.0427863049388 , -0.155620975684 , -0.0427863048734 , -0.986889783158 , 0.986889783143 , -0.662121344635 , 0.396667964582 , 0.66212134462 , -0.635806457189 , -0.396667964267 , -0.635806457181 , -0.396667964383 , 0.635806457293 , 0.396667964393 , 0.635806457367 , -0.662121344545 , 0.662121344488 , 0.581325232381 , -0.10635914801 , -0.581325232439 , -0.80668996891 , 0.106359148208 , -0.806689968881 , 0.106359148018 , 0.806689969064 , -0.10635914814 , 0.80668996899 , 0.581325232223 , -0.581325232366 , 0.736077680608 , 0.291056986499 , -0.736077680454 , -0.611126401618 , -0.291056986482 , -0.611126401421 , -0.29105698668 , 0.611126401395 , 0.291056986389 , 0.611126401291 , 0.736077680695 , -0.736077680618 , -0.577350269177 , 0.577350269044 , 0.577350269134 , -0.577350269314 , ])
t_y = flex.double([ -0.063441798167 , -0.529735418358 , 0.0634417984532 , 0.845786926364 , -0.529735418249 , -0.845786926353 , 0.529735418303 , -0.845786926255 , 0.529735418273 , 0.845786926264 , 0.0634417983435 , -0.0634417986471 , -0.196162596037 , 0.311083708403 , 0.19616259597 , 0.929917825616 , 0.311083708701 , -0.929917825595 , -0.311083708528 , -0.929917825508 , -0.311083708571 , 0.929917825463 , 0.196162596269 , -0.196162596229 , -0.495799724547 , -0.210319816476 , 0.495799724769 , -0.842584243735 , -0.210319816834 , 0.842584243659 , 0.210319816811 , 0.842584243983 , 0.210319816511 , -0.842584243879 , 0.495799724323 , -0.49579972458 , 0.311078300858 , 0.314835985948 , -0.311078301036 , 0.896721022714 , 0.314835985871 , -0.89672102269 , -0.314835986025 , -0.896721022757 , -0.314835985795 , 0.896721022742 , -0.311078300782 , 0.311078300979 , -0.15562097571 , 0.0427863048563 , 0.155620975792 , -0.986889783106 , 0.0427863047246 , 0.986889783105 , -0.0427863046612 , 0.986889783153 , -0.0427863048966 , -0.986889783147 , 0.155620975538 , -0.155620975623 , 0.396667964571 , -0.63580645716 , -0.396667964319 , -0.662121344638 , -0.635806457356 , 0.662121344671 , 0.635806457223 , 0.662121344445 , 0.635806457261 , -0.662121344469 , -0.396667964636 , 0.39666796434 , -0.106359147977 , -0.806689969022 , 0.106359148266 , 0.581325232279 , -0.806689968851 , -0.581325232326 , 0.806689968901 , -0.581325232067 , 0.806689968943 , 0.581325232153 , 0.106359147993 , -0.106359148293 , 0.291056986738 , -0.611126401593 , -0.29105698644 , 0.73607768052 , -0.611126401475 , -0.736077680629 , 0.611126401332 , -0.736077680752 , 0.611126401765 , 0.736077680828 , -0.291056986626 , 0.291056986373 , -0.577350269035 , 0.577350269266 , -0.577350269225 , 0.577350269039 , ])
t_z = flex.double([ -0.52973541824 , 0.845786926332 , -0.529735418153 , -0.0634417982194 , -0.845786926382 , 0.063441798214 , 0.845786926366 , -0.0634417984998 , -0.845786926378 , 0.063441798606 , 0.529735418341 , 0.529735418194 , 0.311083708385 , 0.929917825554 , 0.311083708631 , -0.196162595726 , -0.929917825437 , 0.196162595807 , 0.929917825506 , -0.196162596176 , -0.929917825521 , 0.196162596231 , -0.311083708397 , -0.311083708724 , -0.210319816836 , -0.842584244 , -0.210319816791 , -0.495799724618 , 0.842584243753 , 0.495799724664 , -0.842584243799 , -0.495799724217 , 0.842584243865 , 0.495799724325 , 0.210319816725 , 0.210319816824 , 0.314835986087 , 0.896721022767 , 0.314835985783 , 0.311078300998 , -0.89672102274 , -0.311078300993 , 0.896721022706 , 0.311078300821 , -0.896721022766 , -0.311078300883 , -0.314835986051 , -0.314835985828 , 0.0427863045687 , -0.986889783148 , 0.042786304716 , -0.155620975834 , 0.986889783134 , 0.155620975871 , -0.986889783134 , -0.155620975508 , 0.986889783127 , 0.155620975562 , -0.0427863047074 , -0.0427863047443 , -0.635806457078 , -0.66212134455 , -0.63580645725 , 0.396667964387 , 0.66212134455 , -0.396667964347 , -0.662121344609 , 0.396667964543 , 0.662121344566 , -0.396667964385 , 0.635806457131 , 0.635806457375 , -0.806689968847 , 0.581325232132 , -0.806689968768 , -0.106359148058 , -0.581325232333 , 0.106359148016 , 0.581325232299 , -0.10635914805 , -0.581325232219 , 0.10635914814 , 0.806689968959 , 0.806689968816 , -0.611126401477 , 0.736077680606 , -0.611126401804 , 0.291056986663 , -0.73607768071 , -0.291056986803 , 0.736077680751 , 0.291056986545 , -0.736077680507 , -0.291056986571 , 0.611126401425 , 0.611126401638 , -0.577350269357 , -0.577350269258 , 0.57735026921 , 0.577350269216 , ])
