from __future__ import absolute_import, division, print_function
from libtbx import easy_run

small_pdb = '''
CRYST1   67.764   73.374   89.188  90.00  90.00  90.00 P 21 21 21
SCALE1      0.014757  0.000000  0.000000        0.00000
SCALE2      0.000000  0.013629  0.000000        0.00000
SCALE3      0.000000  0.000000  0.011212        0.00000
ATOM      1  CD1 LEU B  72       8.667 -35.470  -5.077  1.00 59.79           C
ANISOU    1  CD1 LEU B  72     6414   8428   7875    523   1603   1997       C
ATOM      2  OD2 ASP B  73      12.724 -38.374 -11.812  1.00 88.34           O
ANISOU    2  OD2 ASP B  73    10138  12571  10858   -103    489   1759       O
ATOM      3  NH2 ARG B  75      14.028 -38.071 -14.297  1.00 37.51           N
ANISOU    3  NH2 ARG B  75     3656   6350   4245    -76    315   1819       N
ATOM      4  CE  LYS B  82      17.480 -35.482 -12.533  1.00 53.69           C
ANISOU    4  CE  LYS B  82     6220   7461   6719    236    729   1552       C
ATOM      5  NZ  LYS B  82      16.277 -34.849 -13.106  1.00 47.71           N
ANISOU    5  NZ  LYS B  82     5220   6893   6016    349    794   1830       N
TER
ATOM      6  C6   DG C   5      13.380 -35.454 -16.997  1.00 55.38           C
ANISOU    6  C6   DG C   5     7038   7537   6465  -2349  -2046   1030       C
ATOM      7  O6   DG C   5      12.844 -35.974 -16.003  1.00 55.39           O
ANISOU    7  O6   DG C   5     6490   7702   6853  -2340  -2093   1187       O
ATOM      8  N1   DG C   5      12.788 -34.348 -17.615  1.00 55.50           N
ANISOU    8  N1   DG C   5     7219   7595   6272  -2261  -2308   1153       N
ATOM      9  C5   DG C   6      15.752 -32.181 -16.614  1.00 49.45           C
ANISOU    9  C5   DG C   6     6580   6784   5425  -1809   -942    838       C
ATOM     10  C6   DG C   6      14.837 -32.426 -15.573  1.00 47.58           C
ANISOU   10  C6   DG C   6     5799   6807   5471  -1736  -1178   1041       C
ATOM     11  O6   DG C   6      14.820 -33.371 -14.798  1.00 48.06           O
ANISOU   11  O6   DG C   6     5544   6935   5781  -1777  -1175   1056       O
ATOM     12  N1   DG C   6      13.878 -31.427 -15.468  1.00 46.77           N
ANISOU   12  N1   DG C   6     5555   6852   5363  -1576  -1370   1262       N
ATOM     13  C2   DG C   6      13.795 -30.332 -16.288  1.00 48.97           C
ANISOU   13  C2   DG C   6     6199   7043   5364  -1495  -1408   1290       C
ATOM     14  N2   DG C   6      12.777 -29.485 -16.060  1.00 49.05           N
ANISOU   14  N2   DG C   6     5979   7190   5466  -1303  -1608   1541       N
ATOM     15  N3   DG C   6      14.631 -30.103 -17.301  1.00 51.62           N
ANISOU   15  N3   DG C   6     7118   7128   5367  -1581  -1217   1106       N
ATOM     16  O2   DC C   7      14.973 -27.621 -14.169  1.00 47.56           O
ANISOU   16  O2   DC C   7     5780   6947   5345   -996   -605   1243       O
ATOM     17  C3'  DA C  16      37.852  -9.655   4.024  1.00183.91           C
ANISOU   17  C3'  DA C  16    24314  16850  28714  -7056  -9451  -4932       C
ATOM     18  O3'  DA C  16      38.675  -8.488   3.955  1.00187.48           O
ANISOU   18  O3'  DA C  16    24548  17238  29446  -7688  -8925  -5266       O
TER
ATOM     19  C5'  DG D  10      11.714 -32.153  -4.599  1.00 52.39           C
ANISOU   19  C5'  DG D  10     5649   7656   6599    612    672   1410       C
ATOM     20  C4'  DG D  10      11.196 -31.311  -5.747  1.00 52.11           C
ANISOU   20  C4'  DG D  10     5418   7630   6751    490    384   1385       C
ATOM     21  O4'  DG D  10      12.222 -31.189  -6.760  1.00 49.39           O
ANISOU   21  O4'  DG D  10     5315   7201   6250    233     30   1112       O
ATOM     22  C3'  DG D  10       9.952 -31.848  -6.451  1.00 54.58           C
ANISOU   22  C3'  DG D  10     5206   7973   7559    275    284   1638       C
ATOM     23  O3'  DG D  10       9.016 -30.796  -6.576  1.00 58.75           O
ANISOU   23  O3'  DG D  10     5490   8567   8267    512    297   1794       O
ATOM     24  C2'  DG D  10      10.477 -32.307  -7.809  1.00 51.83           C
ANISOU   24  C2'  DG D  10     4978   7529   7186   -143   -178   1447       C
ATOM     25  C1'  DG D  10      11.640 -31.352  -8.025  1.00 49.44           C
ANISOU   25  C1'  DG D  10     5132   7167   6485    -32   -268   1161       C
ATOM     26  N9   DG D  10      12.684 -31.840  -8.943  1.00 47.12           N
ANISOU   26  N9   DG D  10     5146   6716   6042   -316   -476    956       N
ATOM     27  C8   DG D  10      13.307 -33.070  -8.914  1.00 46.20           C
ANISOU   27  C8   DG D  10     5133   6515   5904   -515   -409    937       C
ATOM     28  N7   DG D  10      14.254 -33.199  -9.818  1.00 44.53           N
ANISOU   28  N7   DG D  10     5246   6119   5554   -679   -524    774       N
ATOM     29  C5   DG D  10      14.280 -31.969 -10.477  1.00 43.30           C
ANISOU   29  C5   DG D  10     5225   5914   5314   -597   -675    667       C
ATOM     30  C6   DG D  10      15.112 -31.506 -11.556  1.00 41.62           C
ANISOU   30  C6   DG D  10     5395   5462   4955   -668   -744    507       C
ATOM     31  O6   DG D  10      15.979 -32.137 -12.188  1.00 41.25           O
ANISOU   31  O6   DG D  10     5636   5194   4842   -819   -674    445       O
ATOM     32  N1   DG D  10      14.797 -30.192 -11.935  1.00 41.60           N
ANISOU   32  N1   DG D  10     5469   5445   4892   -509   -832    459       N
ATOM     33  C2   DG D  10      13.813 -29.418 -11.332  1.00 43.73           C
ANISOU   33  C2   DG D  10     5468   5915   5233   -286   -849    563       C
ATOM     34  N2   DG D  10      13.646 -28.173 -11.808  1.00 43.93           N
ANISOU   34  N2   DG D  10     5658   5867   5167   -113   -891    518       N
ATOM     35  N3   DG D  10      13.041 -29.841 -10.321  1.00 45.36           N
ANISOU   35  N3   DG D  10     5302   6335   5597   -199   -748    732       N
ATOM     36  C4   DG D  10      13.317 -31.120  -9.954  1.00 44.89           C
ANISOU   36  C4   DG D  10     5171   6288   5599   -373   -668    771       C
ATOM     37  P    DC D  11       7.464 -31.076  -6.856  1.00 64.47           P
ANISOU   37  P    DC D  11     5497   9365   9635    459    284   2173       P
ATOM     38  OP1  DC D  11       6.694 -30.199  -5.955  1.00 68.29           O
ANISOU   38  OP1  DC D  11     5821   9892  10233    961    768   2440       O
ATOM     39  OP2  DC D  11       7.221 -32.542  -6.838  1.00 66.22           O
ANISOU   39  OP2  DC D  11     5442   9536  10183     92    297   2280       O
ATOM     40  O5'  DC D  11       7.294 -30.564  -8.369  1.00 64.31           O
ANISOU   40  O5'  DC D  11     5423   9353   9659    251   -357   2068       O
ATOM     41  C5'  DC D  11       7.627 -29.216  -8.713  1.00 63.28           C
ANISOU   41  C5'  DC D  11     5632   9211   9200    523   -437   1929       C
ATOM     42  C4'  DC D  11       8.011 -29.086 -10.181  1.00 62.67           C
ANISOU   42  C4'  DC D  11     5821   9041   8950    261  -1009   1721       C
ATOM     43  O4'  DC D  11       9.255 -29.758 -10.428  1.00 58.49           O
ANISOU   43  O4'  DC D  11     5760   8365   8097    -24  -1057   1430       O
ATOM     44  C3'  DC D  11       7.016 -29.681 -11.186  1.00 67.45           C
ANISOU   44  C3'  DC D  11     6000   9677   9951    -27  -1557   1885       C
ATOM     45  O3'  DC D  11       6.256 -28.657 -11.805  1.00 72.04           O
ANISOU   45  O3'  DC D  11     6413  10328  10632    230  -1830   2033       O
ATOM     46  C2'  DC D  11       7.890 -30.400 -12.212  1.00 64.48           C
ANISOU   46  C2'  DC D  11     6150   9097   9252   -428  -1934   1593       C
ATOM     47  C1'  DC D  11       9.306 -30.020 -11.805  1.00 58.64           C
ANISOU   47  C1'  DC D  11     5982   8251   8047   -301  -1549   1328       C
ATOM     48  N1   DC D  11      10.301 -31.101 -12.087  1.00 54.72           N
ANISOU   48  N1   DC D  11     5853   7578   7362   -630  -1553   1136       N
ATOM     49  C2   DC D  11      11.214 -30.932 -13.141  1.00 52.51           C
ANISOU   49  C2   DC D  11     6165   7054   6734   -727  -1703    915       C
ATOM     50  O2   DC D  11      11.240 -29.851 -13.751  1.00 52.40           O
ANISOU   50  O2   DC D  11     6386   6974   6548   -537  -1809    863       O
ATOM     51  N3   DC D  11      12.076 -31.957 -13.436  1.00 51.07           N
ANISOU   51  N3   DC D  11     6319   6673   6412   -983  -1636    793       N
ATOM     52  C4   DC D  11      12.018 -33.112 -12.738  1.00 51.92           C
ANISOU   52  C4   DC D  11     6202   6832   6694  -1150  -1478    871       C
ATOM     53  N4   DC D  11      12.895 -34.084 -13.036  1.00 50.99           N
ANISOU   53  N4   DC D  11     6456   6495   6424  -1347  -1360    775       N
ATOM     54  C5   DC D  11      11.056 -33.313 -11.693  1.00 53.75           C
ANISOU   54  C5   DC D  11     5848   7303   7273  -1078  -1345   1085       C
ATOM     55  C6   DC D  11      10.213 -32.306 -11.428  1.00 54.96           C
ANISOU   55  C6   DC D  11     5658   7636   7588   -821  -1379   1220       C
ATOM     56  P    DC D  12       4.982 -29.027 -12.712  1.00 79.92           P
ANISOU   56  P    DC D  12     6815  11412  12140     35  -2495   2280       P
ATOM     57  OP1  DC D  12       4.045 -27.883 -12.655  1.00 84.68           O
ANISOU   57  OP1  DC D  12     7009  12168  12999    510  -2460   2587       O
ATOM     58  OP2  DC D  12       4.513 -30.390 -12.342  1.00 82.50           O
ANISOU   58  OP2  DC D  12     6639  11752  12957   -372  -2514   2401       O
ATOM     59  O5'  DC D  12       5.591 -29.119 -14.190  1.00 78.68           O
ANISOU   59  O5'  DC D  12     7339  11049  11508   -225  -3141   1981       O
ATOM     60  C5'  DC D  12       6.341 -28.033 -14.735  1.00 75.42           C
ANISOU   60  C5'  DC D  12     7617  10501  10539     57  -3086   1788       C
ATOM     61  C4'  DC D  12       7.081 -28.473 -15.987  1.00 73.85           C
ANISOU   61  C4'  DC D  12     8167  10013   9878   -235  -3505   1508       C
ATOM     62  O4'  DC D  12       8.144 -29.361 -15.612  1.00 68.93           O
ANISOU   62  O4'  DC D  12     7855   9247   9089   -518  -3156   1294       O
ATOM     63  C1'  DC D  12       8.392 -30.247 -16.669  1.00 69.20           C
ANISOU   63  C1'  DC D  12     8373   9022   8899   -878  -3589   1142       C
ATOM     64  N1   DC D  12       8.969 -31.516 -16.114  1.00 65.22           N
ANISOU   64  N1   DC D  12     7875   8442   8465  -1214  -3298   1054       N
ATOM     65  C2   DC D  12      10.097 -32.088 -16.724  1.00 61.84           C
ANISOU   65  C2   DC D  12     8201   7678   7618  -1383  -3174    828       C
ATOM     66  O2   DC D  12      10.648 -31.493 -17.653  1.00 61.62           O
ANISOU   66  O2   DC D  12     8828   7406   7177  -1244  -3231    703       O
ATOM     67  N3   DC D  12      10.570 -33.278 -16.249  1.00 59.55           N
ANISOU   67  N3   DC D  12     7919   7307   7399  -1647  -2908    788       N
ATOM     68  C4   DC D  12       9.933 -33.914 -15.251  1.00 60.34           C
ANISOU   68  C4   DC D  12     7360   7627   7939  -1767  -2789    947       C
ATOM     69  N4   DC D  12      10.438 -35.079 -14.825  1.00 58.98           N
ANISOU   69  N4   DC D  12     7286   7338   7787  -1987  -2495    915       N
ATOM     70  C5   DC D  12       8.755 -33.372 -14.641  1.00 63.69           C
ANISOU   70  C5   DC D  12     7020   8364   8816  -1619  -2885   1183       C
ATOM     71  C6   DC D  12       8.305 -32.190 -15.105  1.00 65.90           C
ANISOU   71  C6   DC D  12     7254   8739   9047  -1342  -3145   1236       C
TER
HETATM   72  O   HOH B 355      10.526 -35.905  -9.116  1.00 45.59           O
HETATM   73  O   HOH D 105       4.788 -32.025  -5.002  1.00 63.52           O
HETATM   74  O   HOH D 108       9.056 -30.329  -2.445  1.00 63.77           O
END
'''

large_pdb = '''
CRYST1   67.764   73.374   89.188  90.00  90.00  90.00 P 21 21 21
SCALE1      0.014757  0.000000  0.000000        0.00000
SCALE2      0.000000  0.013629  0.000000        0.00000
SCALE3      0.000000  0.000000  0.011212        0.00000
ATOM      1  CA  SER B  71      13.994 -39.212  -4.120  1.00 45.22           C
ANISOU    1  CA  SER B  71     5466   6212   5502    -96    997   1012       C
ATOM      2  C   SER B  71      12.571 -39.663  -4.589  1.00 50.17           C
ANISOU    2  C   SER B  71     5879   7033   6149   -132    964   1216       C
ATOM      3  O   SER B  71      12.262 -40.864  -4.559  1.00 49.13           O
ANISOU    3  O   SER B  71     5722   6986   5958   -273    854   1220       O
ATOM      4  CB  SER B  71      14.796 -38.614  -5.271  1.00 45.76           C
ANISOU    4  CB  SER B  71     5553   6230   5602    -72    937   1003       C
ATOM      5  OG  SER B  71      14.965 -39.550  -6.319  1.00 45.13           O
ANISOU    5  OG  SER B  71     5444   6258   5445   -202    754   1021       O
ATOM      6  N   LEU B  72      11.699 -38.711  -4.977  1.00 48.67           N
ANISOU    6  N   LEU B  72     5526   6910   6058     -5   1067   1390       N
ATOM      7  CA  LEU B  72      10.334 -39.015  -5.453  1.00 50.38           C
ANISOU    7  CA  LEU B  72     5509   7338   6295    -29   1037   1605       C
ATOM      8  C   LEU B  72      10.357 -39.904  -6.717  1.00 58.22           C
ANISOU    8  C   LEU B  72     6426   8488   7208   -190    816   1628       C
ATOM      9  O   LEU B  72       9.649 -40.909  -6.806  1.00 61.15           O
ANISOU    9  O   LEU B  72     6697   8995   7543   -329    717   1670       O
ATOM     10  CB  LEU B  72       9.546 -37.719  -5.735  1.00 51.47           C
ANISOU   10  CB  LEU B  72     5480   7515   6561    160   1196   1807       C
ATOM     11  CG  LEU B  72       9.294 -36.752  -4.569  1.00 56.90           C
ANISOU   11  CG  LEU B  72     6211   8058   7352    332   1444   1792       C
ATOM     12  CD1 LEU B  72       8.667 -35.470  -5.077  1.00 59.79           C
ANISOU   12  CD1 LEU B  72     6414   8428   7875    523   1603   1997       C
ATOM     13  CD2 LEU B  72       8.398 -37.364  -3.475  1.00 54.12           C
ANISOU   13  CD2 LEU B  72     5814   7778   6971    310   1511   1824       C
ATOM     14  N   ASP B  73      11.181 -39.505  -7.668  1.00 54.44           N
ANISOU   14  N   ASP B  73     5994   7984   6705   -172    751   1590       N
ATOM     15  CA  ASP B  73      11.484 -40.139  -8.937  1.00 55.25           C
ANISOU   15  CA  ASP B  73     6061   8221   6710   -296    560   1571       C
ATOM     16  C   ASP B  73      12.080 -41.544  -8.698  1.00 56.62           C
ANISOU   16  C   ASP B  73     6382   8333   6798   -487    428   1371       C
ATOM     17  O   ASP B  73      11.678 -42.493  -9.366  1.00 57.96           O
ANISOU   17  O   ASP B  73     6469   8649   6906   -643    282   1361       O
ATOM     18  CB  ASP B  73      12.562 -39.251  -9.613  1.00 57.88           C
ANISOU   18  CB  ASP B  73     6477   8461   7052   -192    579   1542       C
ATOM     19  CG  ASP B  73      12.772 -39.405 -11.096  1.00 79.37           C
ANISOU   19  CG  ASP B  73     9113  11366   9678   -242    431   1592       C
ATOM     20  OD1 ASP B  73      13.028 -40.544 -11.543  1.00 83.06           O
ANISOU   20  OD1 ASP B  73     9627  11903  10029   -414    269   1463       O
ATOM     21  OD2 ASP B  73      12.724 -38.374 -11.812  1.00 88.34           O
ANISOU   21  OD2 ASP B  73    10138  12571  10858   -103    489   1759       O
ATOM     22  N   GLY B  74      13.046 -41.628  -7.772  1.00 48.60           N
ANISOU   22  N   GLY B  74     5573   7105   5786   -472    486   1214       N
ATOM     23  N   ARG B  75      15.493 -41.737  -8.902  1.00 39.07           N
ANISOU   23  N   ARG B  75     4633   5732   4480   -510    345    971       N
ATOM     24  CA  ARG B  75      16.798 -41.429  -9.486  1.00 37.13           C
ANISOU   24  CA  ARG B  75     4511   5393   4205   -479    311    879       C
ATOM     25  C   ARG B  75      17.640 -40.524  -8.596  1.00 37.86           C
ANISOU   25  C   ARG B  75     4735   5282   4368   -365    439    810       C
ATOM     26  O   ARG B  75      17.117 -39.707  -7.866  1.00 37.75           O
ANISOU   26  O   ARG B  75     4682   5225   4438   -263    575    866       O
ATOM     27  CB  ARG B  75      16.629 -40.738 -10.847  1.00 38.49           C
ANISOU   27  CB  ARG B  75     4548   5717   4361   -414    277   1012       C
ATOM     28  CG  ARG B  75      16.196 -41.644 -11.998  1.00 46.70           C
ANISOU   28  CG  ARG B  75     5485   6977   5280   -546    114   1018       C
ATOM     29  CD  ARG B  75      16.191 -40.897 -13.329  1.00 42.74           C
ANISOU   29  CD  ARG B  75     4853   6657   4731   -462     83   1157       C
ATOM     30  NE  ARG B  75      15.155 -39.854 -13.375  1.00 34.72           N
ANISOU   30  NE  ARG B  75     3639   5757   3797   -328    183   1395       N
ATOM     31  CZ  ARG B  75      15.001 -38.974 -14.356  1.00 51.34           C
ANISOU   31  CZ  ARG B  75     5594   8014   5897   -207    205   1586       C
ATOM     32  NH1 ARG B  75      15.823 -38.982 -15.401  1.00 48.43           N
ANISOU   32  NH1 ARG B  75     5253   7720   5430   -204    128   1565       N
ATOM     33  NH2 ARG B  75      14.028 -38.071 -14.297  1.00 37.51           N
ANISOU   33  NH2 ARG B  75     3656   6350   4245    -76    315   1819       N
ATOM     34  N   LEU B  76      18.954 -40.655  -8.687  1.00 33.74           N
ANISOU   34  N   LEU B  76     4363   4641   3815   -385    398    682       N
ATOM     35  N   GLN B  77      20.993 -37.735  -8.751  1.00 33.28           N
ANISOU   35  N   GLN B  77     4419   4239   3985   -115    619    643       N
ATOM     36  CA  GLN B  77      21.843 -36.938  -9.638  1.00 33.15           C
ANISOU   36  CA  GLN B  77     4397   4160   4039    -46    635    687       C
ATOM     37  CB  GLN B  77      21.184 -35.623 -10.076  1.00 35.27           C
ANISOU   37  CB  GLN B  77     4517   4421   4464    102    775    870       C
ATOM     38  CG  GLN B  77      22.036 -34.806 -11.064  1.00 39.95           C
ANISOU   38  CG  GLN B  77     5082   4952   5147    183    804    956       C
ATOM     39  CD  GLN B  77      21.334 -33.565 -11.593  1.00 51.06           C
ANISOU   39  CD  GLN B  77     6315   6362   6724    342    953   1186       C
ATOM     40  OE1 GLN B  77      20.152 -33.585 -11.965  1.00 40.99           O
ANISOU   40  OE1 GLN B  77     4884   5265   5425    385    959   1360       O
ATOM     41  NE2 GLN B  77      22.054 -32.452 -11.652  1.00 41.50           N
ANISOU   41  NE2 GLN B  77     5113   4951   5704    433   1081   1206       N
ATOM     42  N   LYS B  82      21.845 -38.324 -14.088  1.00 38.89           N
ANISOU   42  N   LYS B  82     4873   5491   4414   -116    277    974       N
ATOM     43  CA  LYS B  82      20.912 -39.089 -13.254  1.00 37.55           C
ANISOU   43  CA  LYS B  82     4702   5349   4216   -212    250    910       C
ATOM     44  CB  LYS B  82      19.461 -38.613 -13.473  1.00 40.49           C
ANISOU   44  CB  LYS B  82     4868   5899   4618   -155    290   1104       C
ATOM     45  CG  LYS B  82      19.108 -37.357 -12.703  1.00 48.79           C
ANISOU   45  CG  LYS B  82     5876   6808   5853    -12    472   1204       C
ATOM     46  CD  LYS B  82      17.731 -36.862 -13.078  1.00 56.45           C
ANISOU   46  CD  LYS B  82     6621   7968   6858     64    520   1433       C
ATOM     47  CE  LYS B  82      17.480 -35.482 -12.533  1.00 53.69           C
ANISOU   47  CE  LYS B  82     6220   7461   6719    236    729   1552       C
ATOM     48  NZ  LYS B  82      16.277 -34.849 -13.106  1.00 47.71           N
ANISOU   48  NZ  LYS B  82     5220   6893   6016    349    794   1830       N
TER
ATOM     49  N3   DC C   3      10.163 -41.537 -19.049  1.00 80.79           N
ANISOU   49  N3   DC C   3    10710   9779  10207  -4007  -4243    909       N
ATOM     50  C4   DC C   3       9.646 -41.759 -17.831  1.00 79.18           C
ANISOU   50  C4   DC C   3     9652   9809  10625  -3952  -4092   1165       C
ATOM     51  N4   DC C   3       8.666 -40.948 -17.413  1.00 79.82           N
ANISOU   51  N4   DC C   3     9076  10166  11085  -3841  -4325   1478       N
ATOM     52  C2'  DA C   4      16.585 -39.755 -19.866  1.00 71.00           C
ANISOU   52  C2'  DA C   4    11283   7990   7703  -2982  -1073    -32       C
ATOM     53  C1'  DA C   4      15.216 -40.359 -20.154  1.00 72.80           C
ANISOU   53  C1'  DA C   4    11569   8233   7860  -3259  -1829     63       C
ATOM     54  N9   DA C   4      14.239 -40.124 -19.086  1.00 68.67           N
ANISOU   54  N9   DA C   4    10182   8121   7788  -3226  -2202    355       N
ATOM     55  C8   DA C   4      14.092 -40.840 -17.918  1.00 65.84           C
ANISOU   55  C8   DA C   4     9183   7910   7923  -3213  -2132    479       C
ATOM     56  N7   DA C   4      13.100 -40.424 -17.159  1.00 64.40           N
ANISOU   56  N7   DA C   4     8366   8045   8057  -3173  -2415    759       N
ATOM     57  C5   DA C   4      12.555 -39.366 -17.877  1.00 65.98           C
ANISOU   57  C5   DA C   4     8738   8326   8005  -3149  -2743    825       C
ATOM     58  C6   DA C   4      11.470 -38.496 -17.619  1.00 66.40           C
ANISOU   58  C6   DA C   4     8321   8648   8261  -3067  -3101   1105       C
ATOM     59  N6   DA C   4      10.712 -38.580 -16.525  1.00 65.91           N
ANISOU   59  N6   DA C   4     7510   8816   8718  -3005  -3106   1369       N
ATOM     60  N1   DA C   4      11.182 -37.548 -18.542  1.00 68.26           N
ANISOU   60  N1   DA C   4     8922   8859   8155  -3028  -3410   1122       N
ATOM     61  C2   DA C   4      11.944 -37.464 -19.645  1.00 69.97           C
ANISOU   61  C2   DA C   4     9995   8792   7799  -3080  -3314    872       C
ATOM     62  N3   DA C   4      12.986 -38.224 -20.004  1.00 70.04           N
ANISOU   62  N3   DA C   4    10532   8513   7567  -3161  -2900    591       N
ATOM     63  C4   DA C   4      13.241 -39.169 -19.068  1.00 68.13           C
ANISOU   63  C4   DA C   4     9830   8317   7740  -3187  -2648    582       C
ATOM     64  O4'  DG C   5      16.905 -36.381 -21.325  1.00 69.22           O
ANISOU   64  O4'  DG C   5    11852   7803   6647  -2679   -800     43       O
ATOM     65  C2'  DG C   5      18.423 -35.229 -20.012  1.00 62.44           C
ANISOU   65  C2'  DG C   5    10161   7150   6414  -2353     39     49       C
ATOM     66  C1'  DG C   5      16.956 -35.376 -20.348  1.00 63.78           C
ANISOU   66  C1'  DG C   5    10472   7460   6302  -2477   -714    200       C
ATOM     67  N9   DG C   5      16.122 -35.773 -19.211  1.00 59.65           N
ANISOU   67  N9   DG C   5     9179   7287   6199  -2475  -1125    383       N
ATOM     68  C8   DG C   5      16.347 -36.806 -18.326  1.00 57.78           C
ANISOU   68  C8   DG C   5     8490   7105   6359  -2501  -1037    364       C
ATOM     69  N7   DG C   5      15.436 -36.911 -17.398  1.00 55.67           N
ANISOU   69  N7   DG C   5     7639   7129   6384  -2483  -1374    578       N
ATOM     70  C5   DG C   5      14.560 -35.866 -17.675  1.00 55.99           C
ANISOU   70  C5   DG C   5     7667   7329   6279  -2425  -1701    748       C
ATOM     71  C6   DG C   5      13.380 -35.454 -16.997  1.00 55.38           C
ANISOU   71  C6   DG C   5     7038   7537   6465  -2349  -2046   1030       C
ATOM     72  O6   DG C   5      12.844 -35.974 -16.003  1.00 55.39           O
ANISOU   72  O6   DG C   5     6490   7702   6853  -2340  -2093   1187       O
ATOM     73  N1   DG C   5      12.788 -34.348 -17.615  1.00 55.50           N
ANISOU   73  N1   DG C   5     7219   7595   6272  -2261  -2308   1153       N
ATOM     74  C2   DG C   5      13.289 -33.704 -18.728  1.00 56.19           C
ANISOU   74  C2   DG C   5     7998   7470   5880  -2256  -2243   1022       C
ATOM     75  N2   DG C   5      12.616 -32.638 -19.150  1.00 56.89           N
ANISOU   75  N2   DG C   5     8185   7613   5819  -2132  -2533   1197       N
ATOM     76  N3   DG C   5      14.397 -34.064 -19.359  1.00 57.59           N
ANISOU   76  N3   DG C   5     8742   7365   5774  -2338  -1849    760       N
ATOM     77  C4   DG C   5      14.980 -35.151 -18.781  1.00 57.50           C
ANISOU   77  C4   DG C   5     8503   7316   6030  -2415  -1591    633       C
ATOM     78  C4'  DG C   6      17.499 -30.332 -21.669  1.00 68.00           C
ANISOU   78  C4'  DG C   6    11949   7860   6028  -1980    -49    456       C
ATOM     79  O4'  DG C   6      16.616 -30.873 -20.651  1.00 64.59           O
ANISOU   79  O4'  DG C   6    10767   7811   5963  -1974   -585    584       O
ATOM     80  C2'  DG C   6      18.230 -29.602 -19.482  1.00 61.13           C
ANISOU   80  C2'  DG C   6     9767   7395   6063  -1789    273    481       C
ATOM     81  C1'  DG C   6      16.819 -30.179 -19.428  1.00 59.91           C
ANISOU   81  C1'  DG C   6     9488   7475   5799  -1811   -424    654       C
ATOM     82  N9   DG C   6      16.602 -31.109 -18.320  1.00 53.93           N
ANISOU   82  N9   DG C   6     8075   6960   5456  -1834   -591    674       N
ATOM     83  C8   DG C   6      17.312 -32.253 -18.046  1.00 52.41           C
ANISOU   83  C8   DG C   6     7749   6681   5482  -1940   -385    514       C
ATOM     84  N7   DG C   6      16.843 -32.925 -17.035  1.00 50.66           N
ANISOU   84  N7   DG C   6     6993   6689   5566  -1929   -618    607       N
ATOM     85  C5   DG C   6      15.752 -32.181 -16.614  1.00 49.45           C
ANISOU   85  C5   DG C   6     6580   6784   5425  -1809   -942    838       C
ATOM     86  C6   DG C   6      14.837 -32.426 -15.573  1.00 47.58           C
ANISOU   86  C6   DG C   6     5799   6807   5471  -1736  -1178   1041       C
ATOM     87  O6   DG C   6      14.820 -33.371 -14.798  1.00 48.06           O
ANISOU   87  O6   DG C   6     5544   6935   5781  -1777  -1175   1056       O
ATOM     88  N1   DG C   6      13.878 -31.427 -15.468  1.00 46.77           N
ANISOU   88  N1   DG C   6     5555   6852   5363  -1576  -1370   1262       N
ATOM     89  C2   DG C   6      13.795 -30.332 -16.288  1.00 48.97           C
ANISOU   89  C2   DG C   6     6199   7043   5364  -1495  -1408   1290       C
ATOM     90  N2   DG C   6      12.777 -29.485 -16.060  1.00 49.05           N
ANISOU   90  N2   DG C   6     5979   7190   5466  -1303  -1608   1541       N
ATOM     91  N3   DG C   6      14.631 -30.103 -17.301  1.00 51.62           N
ANISOU   91  N3   DG C   6     7118   7128   5367  -1581  -1217   1106       N
ATOM     92  C4   DG C   6      15.584 -31.069 -17.402  1.00 51.37           C
ANISOU   92  C4   DG C   6     7205   6946   5366  -1740   -958    883       C
ATOM     93  O5'  DC C   7      18.156 -25.995 -19.708  1.00 66.35           O
ANISOU   93  O5'  DC C   7    10858   7922   6431  -1452    599    728       O
ATOM     94  C5'  DC C   7      16.798 -25.510 -19.857  1.00 65.57           C
ANISOU   94  C5'  DC C   7    10834   7992   6086  -1300     39    981       C
ATOM     95  C4'  DC C   7      16.151 -25.269 -18.506  1.00 60.75           C
ANISOU   95  C4'  DC C   7     9495   7728   5861  -1138   -201   1105       C
ATOM     96  O4'  DC C   7      16.069 -26.519 -17.796  1.00 58.03           O
ANISOU   96  O4'  DC C   7     8663   7588   5798  -1238   -353   1042       O
ATOM     97  C3'  DC C   7      16.912 -24.316 -17.587  1.00 57.29           C
ANISOU   97  C3'  DC C   7     8824   7258   5685  -1055    199   1018       C
ATOM     98  O3'  DC C   7      16.250 -23.034 -17.546  1.00 56.66           O
ANISOU   98  O3'  DC C   7     8861   7173   5496   -827    123   1208       O
ATOM     99  C2'  DC C   7      16.930 -25.017 -16.210  1.00 54.04           C
ANISOU   99  C2'  DC C   7     7770   7103   5659  -1052    111    960       C
ATOM    100  C1'  DC C   7      16.110 -26.290 -16.412  1.00 53.52           C
ANISOU  100  C1'  DC C   7     7547   7214   5573  -1119   -279   1054       C
ATOM    101  N1   DC C   7      16.692 -27.554 -15.723  1.00 49.41           N
ANISOU  101  N1   DC C   7     6672   6774   5329  -1253   -234    909       N
ATOM    102  C2   DC C   7      16.009 -28.150 -14.619  1.00 47.47           C
ANISOU  102  C2   DC C   7     5948   6781   5306  -1177   -451   1029       C
ATOM    103  O2   DC C   7      14.973 -27.621 -14.169  1.00 47.56           O
ANISOU  103  O2   DC C   7     5780   6947   5345   -996   -605   1243       O
ATOM    104  N3   DC C   7      16.526 -29.288 -14.063  1.00 45.88           N
ANISOU  104  N3   DC C   7     5514   6609   5309  -1282   -425    925       N
ATOM    105  C4   DC C   7      17.633 -29.855 -14.584  1.00 45.68           C
ANISOU  105  C4   DC C   7     5646   6382   5329  -1438   -211    714       C
ATOM    106  N4   DC C   7      18.076 -30.991 -14.027  1.00 44.11           N
ANISOU  106  N4   DC C   7     5203   6194   5363  -1502   -215    643       N
ATOM    107  C5   DC C   7      18.322 -29.282 -15.715  1.00 47.08           C
ANISOU  107  C5   DC C   7     6265   6291   5331  -1513     75    590       C
ATOM    108  C6   DC C   7      17.832 -28.144 -16.233  1.00 48.38           C
ANISOU  108  C6   DC C   7     6721   6425   5238  -1426     57    692       C
ATOM    109  O5'  DG C   8      16.620 -21.727 -15.437  1.00 51.98           O
ANISOU  109  O5'  DG C   8     7763   6659   5327   -615    406   1138       O
ATOM    110  C5'  DG C   8      15.245 -21.796 -15.034  1.00 49.83           C
ANISOU  110  C5'  DG C   8     7234   6629   5071   -380     82   1394       C
ATOM    111  C4'  DG C   8      15.121 -21.983 -13.541  1.00 45.19           C
ANISOU  111  C4'  DG C   8     6242   6210   4717   -280    118   1367       C
ATOM    112  O4'  DG C   8      15.466 -23.341 -13.181  1.00 43.09           O
ANISOU  112  O4'  DG C   8     5688   6092   4594   -465     15   1257       O
ATOM    113  C2'  DG C   8      17.141 -22.000 -12.279  1.00 42.03           C
ANISOU  113  C2'  DG C   8     5789   5636   4543   -531    402    922       C
ATOM    114  C1'  DG C   8      16.387 -23.312 -12.104  1.00 41.26           C
ANISOU  114  C1'  DG C   8     5371   5812   4493   -517    163   1053       C
ATOM    115  N9   DG C   8      17.227 -24.515 -12.167  1.00 39.38           N
ANISOU  115  N9   DG C   8     4970   5588   4403   -751    119    887       N
ATOM    116  C8   DG C   8      18.311 -24.733 -12.994  1.00 38.73           C
ANISOU  116  C8   DG C   8     5009   5311   4395   -970    281    704       C
ATOM    117  N7   DG C   8      18.819 -25.921 -12.882  1.00 37.78           N
ANISOU  117  N7   DG C   8     4679   5224   4452  -1104    233    609       N
ATOM    118  C5   DG C   8      18.045 -26.530 -11.903  1.00 36.89           C
ANISOU  118  C5   DG C   8     4319   5347   4352   -987      0    735       C
ATOM    119  C6   DG C   8      18.153 -27.826 -11.324  1.00 36.01           C
ANISOU  119  C6   DG C   8     3952   5336   4393  -1041   -135    725       C
ATOM    120  O6   DG C   8      18.959 -28.725 -11.611  1.00 36.04           O
ANISOU  120  O6   DG C   8     3874   5247   4573  -1190   -100    595       O
ATOM    121  N1   DG C   8      17.162 -28.049 -10.352  1.00 35.01           N
ANISOU  121  N1   DG C   8     3683   5401   4218   -879   -261    910       N
ATOM    122  C2   DG C   8      16.214 -27.122  -9.978  1.00 36.10           C
ANISOU  122  C2   DG C   8     3879   5610   4226   -669   -217   1080       C
ATOM    123  N2   DG C   8      15.345 -27.510  -9.058  1.00 37.34           N
ANISOU  123  N2   DG C   8     3884   5899   4404   -520   -221   1264       N
ATOM    124  N3   DG C   8      16.091 -25.920 -10.524  1.00 37.64           N
ANISOU  124  N3   DG C   8     4281   5716   4305   -594   -120   1091       N
ATOM    125  C4   DG C   8      17.045 -25.684 -11.469  1.00 37.58           C
ANISOU  125  C4   DG C   8     4453   5531   4294   -771    -36    912       C
ATOM    126  C4'  DC C   9      13.333 -21.206  -8.026  1.00 44.80           C
ANISOU  126  C4'  DC C   9     5853   6335   4834    614    696   1592       C
ATOM    127  O4'  DC C   9      14.262 -22.312  -8.097  1.00 42.52           O
ANISOU  127  O4'  DC C   9     5441   6135   4581    295    463   1401       O
ATOM    128  O2   DC C   9      16.471 -24.699  -7.001  1.00 40.14           O
ANISOU  128  O2   DC C   9     4964   5890   4398   -201     32    981       O
ATOM    129  C3'  DC C  15      37.907 -15.298   2.284  1.00168.93           C
ANISOU  129  C3'  DC C  15    19382  15636  29167  -5738 -10509  -3429       C
ATOM    130  O3'  DC C  15      38.465 -14.761   1.075  1.00170.68           O
ANISOU  130  O3'  DC C  15    18669  15664  30516  -6074  -9655  -3380       O
ATOM    131  C2'  DC C  15      36.591 -14.607   2.676  1.00167.52           C
ANISOU  131  C2'  DC C  15    20689  15100  27862  -5472 -10714  -3518       C
ATOM    132  P    DA C  16      39.540 -13.579   1.112  1.00176.14           P
ANISOU  132  P    DA C  16    19180  16467  31279  -6762  -9164  -3643       P
ATOM    133  OP1  DA C  16      40.110 -13.464  -0.249  1.00176.33           O
ANISOU  133  OP1  DA C  16    18191  16349  32458  -6993  -8227  -3436       O
ATOM    134  OP2  DA C  16      40.445 -13.802   2.272  1.00178.26           O
ANISOU  134  OP2  DA C  16    19468  17458  30806  -7003  -9460  -3849       O
ATOM    135  O5'  DA C  16      38.631 -12.284   1.402  1.00177.90           O
ANISOU  135  O5'  DA C  16    20632  16164  30796  -6779  -9257  -3894       O
ATOM    136  C5'  DA C  16      38.946 -11.384   2.476  1.00181.14           C
ANISOU  136  C5'  DA C  16    21791  16799  30236  -7115  -9322  -4304       C
ATOM    137  C4'  DA C  16      37.833 -10.366   2.678  1.00181.77           C
ANISOU  137  C4'  DA C  16    23133  16330  29602  -6938  -9362  -4468       C
ATOM    138  O4'  DA C  16      36.553 -11.043   2.621  1.00178.16           O
ANISOU  138  O4'  DA C  16    23351  15711  28630  -6287  -9708  -4194       O
ATOM    139  C3'  DA C  16      37.852  -9.655   4.024  1.00183.91           C
ANISOU  139  C3'  DA C  16    24314  16850  28714  -7056  -9451  -4932       C
ATOM    140  O3'  DA C  16      38.675  -8.488   3.955  1.00187.48           O
ANISOU  140  O3'  DA C  16    24548  17238  29446  -7688  -8925  -5266       O
ATOM    141  C2'  DA C  16      36.381  -9.292   4.229  1.00182.60           C
ANISOU  141  C2'  DA C  16    25526  16220  27635  -6539  -9609  -4887       C
ATOM    142  C1'  DA C  16      35.647 -10.446   3.531  1.00178.66           C
ANISOU  142  C1'  DA C  16    24888  15661  27335  -6045  -9868  -4392       C
ATOM    143  N9   DA C  16      35.137 -11.478   4.447  1.00177.48           N
ANISOU  143  N9   DA C  16    25312  15858  26263  -5591 -10406  -4293       N
ATOM    144  C8   DA C  16      35.866 -12.428   5.117  1.00178.63           C
ANISOU  144  C8   DA C  16    24887  16495  26489  -5611 -10852  -4307       C
ATOM    145  N7   DA C  16      35.141 -13.238   5.853  1.00177.03           N
ANISOU  145  N7   DA C  16    25449  16482  25331  -5133 -11210  -4171       N
ATOM    146  C5   DA C  16      33.851 -12.763   5.699  1.00174.71           C
ANISOU  146  C5   DA C  16    26368  15833  24180  -4793 -10927  -4077       C
ATOM    147  N3   DA C  16      32.738 -10.969   4.451  1.00170.48           N
ANISOU  147  N3   DA C  16    26470  14921  23384  -4780  -9425  -4092       N
ATOM    148  C4   DA C  16      33.826 -11.677   4.831  1.00175.56           C
ANISOU  148  C4   DA C  16    26414  15480  24810  -5063 -10533  -4139       C
TER
ATOM    149  C2'  DG D   8      21.125 -32.880  -7.497  1.00 41.74           C
ANISOU  149  C2'  DG D   8     5133   5644   5083   -268   -267    271       C
ATOM    150  N2   DG D   8      17.756 -27.223  -6.279  1.00 41.65           N
ANISOU  150  N2   DG D   8     5670   5704   4452    256   -451   -153       N
ATOM    151  OP2  DC D   9      19.444 -36.087  -6.966  1.00 45.49           O
ANISOU  151  OP2  DC D   9     5707   6215   5362   -240    158    751       O
ATOM    152  O5'  DC D   9      17.963 -35.148  -5.189  1.00 47.61           O
ANISOU  152  O5'  DC D   9     5891   6796   5401    108    130    782       O
ATOM    153  C4'  DC D   9      16.438 -33.511  -4.181  1.00 47.68           C
ANISOU  153  C4'  DC D   9     5905   6954   5256    421    173    777       C
ATOM    154  O4'  DC D   9      16.636 -32.414  -5.115  1.00 46.32           O
ANISOU  154  O4'  DC D   9     5720   6717   5161    270    -41    594       O
ATOM    155  C3'  DC D   9      15.222 -34.281  -4.663  1.00 47.87           C
ANISOU  155  C3'  DC D   9     5691   6956   5542    259    368   1004       C
ATOM    156  O3'  DC D   9      14.066 -33.831  -3.936  1.00 49.99           O
ANISOU  156  O3'  DC D   9     5865   7288   5841    500    604   1169       O
ATOM    157  C2'  DC D   9      15.155 -33.937  -6.154  1.00 46.75           C
ANISOU  157  C2'  DC D   9     5461   6721   5580    -58    121    904       C
ATOM    158  C1'  DC D   9      15.761 -32.532  -6.208  1.00 46.36           C
ANISOU  158  C1'  DC D   9     5559   6672   5385     57    -46    686       C
ATOM    159  N1   DC D   9      16.555 -32.244  -7.476  1.00 45.92           N
ANISOU  159  N1   DC D   9     5610   6451   5387   -177   -223    525       N
ATOM    160  C2   DC D   9      16.550 -30.940  -8.025  1.00 45.71           C
ANISOU  160  C2   DC D   9     5676   6352   5341   -158   -331    390       C
ATOM    161  O2   DC D   9      15.858 -30.056  -7.494  1.00 46.93           O
ANISOU  161  O2   DC D   9     5811   6591   5429     45   -303    403       O
ATOM    162  N3   DC D   9      17.299 -30.692  -9.148  1.00 44.69           N
ANISOU  162  N3   DC D   9     5710   6013   5258   -327   -387    274       N
ATOM    163  C4   DC D   9      18.002 -31.679  -9.726  1.00 44.18           C
ANISOU  163  C4   DC D   9     5723   5809   5255   -494   -326    301       C
ATOM    164  N4   DC D   9      18.688 -31.392 -10.831  1.00 43.68           N
ANISOU  164  N4   DC D   9     5885   5481   5229   -605   -277    224       N
ATOM    165  C5   DC D   9      18.008 -33.015  -9.199  1.00 44.61           C
ANISOU  165  C5   DC D   9     5687   5940   5323   -518   -233    435       C
ATOM    166  C6   DC D   9      17.303 -33.245  -8.072  1.00 45.48           C
ANISOU  166  C6   DC D   9     5629   6264   5389   -363   -193    536       C
ATOM    167  P    DG D  10      12.633 -34.536  -4.085  1.00 51.63           P
ANISOU  167  P    DG D  10     5690   7480   6448    388    859   1471       P
ATOM    168  OP1  DG D  10      11.993 -34.566  -2.745  1.00 55.90           O
ANISOU  168  OP1  DG D  10     6283   8030   6926    780   1329   1697       O
ATOM    169  OP2  DG D  10      12.792 -35.793  -4.861  1.00 51.10           O
ANISOU  169  OP2  DG D  10     5538   7308   6569      6    778   1496       O
ATOM    170  O5'  DG D  10      11.835 -33.511  -4.991  1.00 51.95           O
ANISOU  170  O5'  DG D  10     5466   7555   6717    297    634   1466       O
ATOM    171  C5'  DG D  10      11.714 -32.153  -4.599  1.00 52.39           C
ANISOU  171  C5'  DG D  10     5649   7656   6599    612    672   1410       C
ATOM    172  C4'  DG D  10      11.196 -31.311  -5.747  1.00 52.11           C
ANISOU  172  C4'  DG D  10     5418   7630   6751    490    384   1385       C
ATOM    173  O4'  DG D  10      12.222 -31.189  -6.760  1.00 49.39           O
ANISOU  173  O4'  DG D  10     5315   7201   6250    233     30   1112       O
ATOM    174  C3'  DG D  10       9.952 -31.848  -6.451  1.00 54.58           C
ANISOU  174  C3'  DG D  10     5206   7973   7559    275    284   1638       C
ATOM    175  O3'  DG D  10       9.016 -30.796  -6.576  1.00 58.75           O
ANISOU  175  O3'  DG D  10     5490   8567   8267    512    297   1794       O
ATOM    176  C2'  DG D  10      10.477 -32.307  -7.809  1.00 51.83           C
ANISOU  176  C2'  DG D  10     4978   7529   7186   -143   -178   1447       C
ATOM    177  C1'  DG D  10      11.640 -31.352  -8.025  1.00 49.44           C
ANISOU  177  C1'  DG D  10     5132   7167   6485    -32   -268   1161       C
ATOM    178  N9   DG D  10      12.684 -31.840  -8.943  1.00 47.12           N
ANISOU  178  N9   DG D  10     5146   6716   6042   -316   -476    956       N
ATOM    179  C8   DG D  10      13.307 -33.070  -8.914  1.00 46.20           C
ANISOU  179  C8   DG D  10     5133   6515   5904   -515   -409    937       C
ATOM    180  N7   DG D  10      14.254 -33.199  -9.818  1.00 44.53           N
ANISOU  180  N7   DG D  10     5246   6119   5554   -679   -524    774       N
ATOM    181  C5   DG D  10      14.280 -31.969 -10.477  1.00 43.30           C
ANISOU  181  C5   DG D  10     5225   5914   5314   -597   -675    667       C
ATOM    182  C6   DG D  10      15.112 -31.506 -11.556  1.00 41.62           C
ANISOU  182  C6   DG D  10     5395   5462   4955   -668   -744    507       C
ATOM    183  O6   DG D  10      15.979 -32.137 -12.188  1.00 41.25           O
ANISOU  183  O6   DG D  10     5636   5194   4842   -819   -674    445       O
ATOM    184  N1   DG D  10      14.797 -30.192 -11.935  1.00 41.60           N
ANISOU  184  N1   DG D  10     5469   5445   4892   -509   -832    459       N
ATOM    185  C2   DG D  10      13.813 -29.418 -11.332  1.00 43.73           C
ANISOU  185  C2   DG D  10     5468   5915   5233   -286   -849    563       C
ATOM    186  N2   DG D  10      13.646 -28.173 -11.808  1.00 43.93           N
ANISOU  186  N2   DG D  10     5658   5867   5167   -113   -891    518       N
ATOM    187  N3   DG D  10      13.041 -29.841 -10.321  1.00 45.36           N
ANISOU  187  N3   DG D  10     5302   6335   5597   -199   -748    732       N
ATOM    188  C4   DG D  10      13.317 -31.120  -9.954  1.00 44.89           C
ANISOU  188  C4   DG D  10     5171   6288   5599   -373   -668    771       C
ATOM    189  P    DC D  11       7.464 -31.076  -6.856  1.00 64.47           P
ANISOU  189  P    DC D  11     5497   9365   9635    459    284   2173       P
ATOM    190  OP1  DC D  11       6.694 -30.199  -5.955  1.00 68.29           O
ANISOU  190  OP1  DC D  11     5821   9892  10233    961    768   2440       O
ATOM    191  OP2  DC D  11       7.221 -32.542  -6.838  1.00 66.22           O
ANISOU  191  OP2  DC D  11     5442   9536  10183     92    297   2280       O
ATOM    192  O5'  DC D  11       7.294 -30.564  -8.369  1.00 64.31           O
ANISOU  192  O5'  DC D  11     5423   9353   9659    251   -357   2068       O
ATOM    193  C5'  DC D  11       7.627 -29.216  -8.713  1.00 63.28           C
ANISOU  193  C5'  DC D  11     5632   9211   9200    523   -437   1929       C
ATOM    194  C4'  DC D  11       8.011 -29.086 -10.181  1.00 62.67           C
ANISOU  194  C4'  DC D  11     5821   9041   8950    261  -1009   1721       C
ATOM    195  O4'  DC D  11       9.255 -29.758 -10.428  1.00 58.49           O
ANISOU  195  O4'  DC D  11     5760   8365   8097    -24  -1057   1430       O
ATOM    196  C3'  DC D  11       7.016 -29.681 -11.186  1.00 67.45           C
ANISOU  196  C3'  DC D  11     6000   9677   9951    -27  -1557   1885       C
ATOM    197  O3'  DC D  11       6.256 -28.657 -11.805  1.00 72.04           O
ANISOU  197  O3'  DC D  11     6413  10328  10632    230  -1830   2033       O
ATOM    198  C2'  DC D  11       7.890 -30.400 -12.212  1.00 64.48           C
ANISOU  198  C2'  DC D  11     6150   9097   9252   -428  -1934   1593       C
ATOM    199  C1'  DC D  11       9.306 -30.020 -11.805  1.00 58.64           C
ANISOU  199  C1'  DC D  11     5982   8251   8047   -301  -1549   1328       C
ATOM    200  N1   DC D  11      10.301 -31.101 -12.087  1.00 54.72           N
ANISOU  200  N1   DC D  11     5853   7578   7362   -630  -1553   1136       N
ATOM    201  C2   DC D  11      11.214 -30.932 -13.141  1.00 52.51           C
ANISOU  201  C2   DC D  11     6165   7054   6734   -727  -1703    915       C
ATOM    202  O2   DC D  11      11.240 -29.851 -13.751  1.00 52.40           O
ANISOU  202  O2   DC D  11     6386   6974   6548   -537  -1809    863       O
ATOM    203  N3   DC D  11      12.076 -31.957 -13.436  1.00 51.07           N
ANISOU  203  N3   DC D  11     6319   6673   6412   -983  -1636    793       N
ATOM    204  C4   DC D  11      12.018 -33.112 -12.738  1.00 51.92           C
ANISOU  204  C4   DC D  11     6202   6832   6694  -1150  -1478    871       C
ATOM    205  N4   DC D  11      12.895 -34.084 -13.036  1.00 50.99           N
ANISOU  205  N4   DC D  11     6456   6495   6424  -1347  -1360    775       N
ATOM    206  C5   DC D  11      11.056 -33.313 -11.693  1.00 53.75           C
ANISOU  206  C5   DC D  11     5848   7303   7273  -1078  -1345   1085       C
ATOM    207  C6   DC D  11      10.213 -32.306 -11.428  1.00 54.96           C
ANISOU  207  C6   DC D  11     5658   7636   7588   -821  -1379   1220       C
ATOM    208  P    DC D  12       4.982 -29.027 -12.712  1.00 79.92           P
ANISOU  208  P    DC D  12     6815  11412  12140     35  -2495   2280       P
ATOM    209  OP1  DC D  12       4.045 -27.883 -12.655  1.00 84.68           O
ANISOU  209  OP1  DC D  12     7009  12168  12999    510  -2460   2587       O
ATOM    210  OP2  DC D  12       4.513 -30.390 -12.342  1.00 82.50           O
ANISOU  210  OP2  DC D  12     6639  11752  12957   -372  -2514   2401       O
ATOM    211  O5'  DC D  12       5.591 -29.119 -14.190  1.00 78.68           O
ANISOU  211  O5'  DC D  12     7339  11049  11508   -225  -3141   1981       O
ATOM    212  C5'  DC D  12       6.341 -28.033 -14.735  1.00 75.42           C
ANISOU  212  C5'  DC D  12     7617  10501  10539     57  -3086   1788       C
ATOM    213  C4'  DC D  12       7.081 -28.473 -15.987  1.00 73.85           C
ANISOU  213  C4'  DC D  12     8167  10013   9878   -235  -3505   1508       C
ATOM    214  O4'  DC D  12       8.144 -29.361 -15.612  1.00 68.93           O
ANISOU  214  O4'  DC D  12     7855   9247   9089   -518  -3156   1294       O
ATOM    215  C3'  DC D  12       6.231 -29.244 -16.987  1.00 79.69           C
ANISOU  215  C3'  DC D  12     8782  10711  10787   -563  -4329   1573       C
ATOM    216  O3'  DC D  12       5.932 -28.434 -18.123  1.00 84.39           O
ANISOU  216  O3'  DC D  12     9773  11213  11079   -333  -4853   1581       O
ATOM    217  C2'  DC D  12       7.065 -30.470 -17.365  1.00 76.49           C
ANISOU  217  C2'  DC D  12     8925  10024  10113  -1022  -4366   1313       C
ATOM    218  C1'  DC D  12       8.392 -30.247 -16.669  1.00 69.20           C
ANISOU  218  C1'  DC D  12     8373   9022   8899   -878  -3589   1142       C
ATOM    219  N1   DC D  12       8.969 -31.516 -16.114  1.00 65.22           N
ANISOU  219  N1   DC D  12     7875   8442   8465  -1214  -3298   1054       N
ATOM    220  C2   DC D  12      10.097 -32.088 -16.724  1.00 61.84           C
ANISOU  220  C2   DC D  12     8201   7678   7618  -1383  -3174    828       C
ATOM    221  O2   DC D  12      10.648 -31.493 -17.653  1.00 61.62           O
ANISOU  221  O2   DC D  12     8828   7406   7177  -1244  -3231    703       O
ATOM    222  N3   DC D  12      10.570 -33.278 -16.249  1.00 59.55           N
ANISOU  222  N3   DC D  12     7919   7307   7399  -1647  -2908    788       N
ATOM    223  C4   DC D  12       9.933 -33.914 -15.251  1.00 60.34           C
ANISOU  223  C4   DC D  12     7360   7627   7939  -1767  -2789    947       C
ATOM    224  N4   DC D  12      10.438 -35.079 -14.825  1.00 58.98           N
ANISOU  224  N4   DC D  12     7286   7338   7787  -1987  -2495    915       N
ATOM    225  C5   DC D  12       8.755 -33.372 -14.641  1.00 63.69           C
ANISOU  225  C5   DC D  12     7020   8364   8816  -1619  -2885   1183       C
ATOM    226  C6   DC D  12       8.305 -32.190 -15.105  1.00 65.90           C
ANISOU  226  C6   DC D  12     7254   8739   9047  -1342  -3145   1236       C
ATOM    227  P    DT D  13       4.832 -28.910 -19.199  1.00 92.81           P
ANISOU  227  P    DT D  13    10681  12271  12312   -565  -5913   1685       P
ATOM    228  OP1  DT D  13       4.277 -27.696 -19.840  1.00 97.01           O
ANISOU  228  OP1  DT D  13    11287  12872  12702    -83  -6269   1848       O
ATOM    229  OP2  DT D  13       3.912 -29.890 -18.553  1.00 96.47           O
ANISOU  229  OP2  DT D  13    10177  12940  13537   -943  -6106   1880       O
ATOM    230  O5'  DT D  13       5.711 -29.720 -20.264  1.00 91.31           O
ANISOU  230  O5'  DT D  13    11574  11637  11481   -915  -6194   1339       O
ATOM    231  C5'  DT D  13       6.930 -29.169 -20.789  1.00 86.22           C
ANISOU  231  C5'  DT D  13    11952  10670  10139   -680  -5761   1116       C
ATOM    232  C4'  DT D  13       7.719 -30.231 -21.542  1.00 85.45           C
ANISOU  232  C4'  DT D  13    12743  10137   9587  -1049  -5843    853       C
ATOM    233  O4'  DT D  13       8.322 -31.135 -20.598  1.00 80.33           O
ANISOU  233  O4'  DT D  13    11803   9525   9192  -1339  -5271    790       O
ATOM    234  C3'  DT D  13       6.887 -31.101 -22.483  1.00 92.93           C
ANISOU  234  C3'  DT D  13    13905  10926  10480  -1423  -6845    817       C
ATOM    235  C2'  DT D  13       7.251 -32.549 -22.122  1.00 90.86           C
ANISOU  235  C2'  DT D  13    13659  10505  10357  -1953  -6665    685       C
ATOM    236  C1'  DT D  13       8.437 -32.407 -21.184  1.00 81.85           C
ANISOU  236  C1'  DT D  13    12491   9402   9208  -1782  -5589    643       C
ATOM    237  N1   DT D  13       8.458 -33.445 -20.074  1.00 78.39           N
ANISOU  237  N1   DT D  13    11412   9119   9254  -2111  -5221    685       N
ATOM    238  C2   DT D  13       9.496 -34.372 -20.017  1.00 74.10           C
ANISOU  238  C2   DT D  13    11412   8277   8466  -2303  -4743    532       C
ATOM    239  O2   DT D  13      10.411 -34.417 -20.833  1.00 72.77           O
ANISOU  239  O2   DT D  13    12199   7705   7744  -2231  -4569    375       O
ATOM    240  N3   DT D  13       9.417 -35.256 -18.956  1.00 71.85           N
ANISOU  240  N3   DT D  13    10523   8153   8624  -2538  -4412    609       N
ATOM    241  C4   DT D  13       8.409 -35.325 -17.983  1.00 73.57           C
ANISOU  241  C4   DT D  13     9705   8751   9497  -2610  -4462    823       C
ATOM    242  O4   DT D  13       8.462 -36.195 -17.112  1.00 72.40           O
ANISOU  242  O4   DT D  13     9208   8650   9652  -2798  -4081    884       O
ATOM    243  C5   DT D  13       7.341 -34.344 -18.119  1.00 77.71           C
ANISOU  243  C5   DT D  13     9668   9555  10302  -2410  -4932    995       C
ATOM    244  C7   DT D  13       6.188 -34.325 -17.149  1.00 80.34           C
ANISOU  244  C7   DT D  13     8862  10255  11407  -2420  -4921   1294       C
ATOM    245  C6   DT D  13       7.412 -33.474 -19.145  1.00 79.83           C
ANISOU  245  C6   DT D  13    10493   9706  10133  -2174  -5316    917       C
ATOM    246  C6   DG D  14       8.280 -38.494 -20.423  1.00 83.95           C
ANISOU  246  C6   DG D  14    12861   8857  10179  -3894  -5663    374       C
ATOM    247  O6   DG D  14       7.769 -38.670 -19.310  1.00 82.63           O
ANISOU  247  O6   DG D  14    11704   9034  10658  -3957  -5402    563       O
TER
HETATM  248  O   HOH B 350      21.454 -30.750 -15.477  1.00 65.67           O
HETATM  249  O   HOH B 355      10.526 -35.905  -9.116  1.00 45.59           O
HETATM  250  O   HOH C 104      21.084 -29.582 -13.041  1.00 44.23           O
HETATM  251  O   HOH C 105      13.755 -24.488 -10.051  1.00 55.10           O
HETATM  252  O   HOH C 108      19.457 -33.371 -15.015  1.00 54.30           O
HETATM  253  O   HOH C 114      10.055 -22.443  -5.392  1.00 51.50           O
HETATM  254  O   HOH C 115      14.423 -33.496 -22.721  1.00 58.74           O
HETATM  255  O   HOH D 102      17.487 -36.654  -8.759  1.00 46.91           O
HETATM  256  O   HOH D 104      14.192 -29.033  -5.516  1.00 45.92           O
HETATM  257  O   HOH D 105       4.788 -32.025  -5.002  1.00 63.52           O
HETATM  258  O   HOH D 108       9.056 -30.329  -2.445  1.00 63.77           O
END
'''

def write_and_run(pdb_name):
  input_model_filename = 'paral_geo_output.pdb'
  with open(input_model_filename, 'w') as f:
    f.write(pdb_name)
  cmd = 'phenix.fmodel %s high_resolution=3' % input_model_filename
  print('\n~> %s\n' % cmd)
  rc = easy_run.go(cmd)
  cmd = 'phenix.real_space_refine %s %s.mtz' % (input_model_filename,
                                                input_model_filename)
  cmd += ' refinement.macro_cycles=0'
  cmd += ' base_pair.restrain_planarity=True'
  cmd += ' overwrite=True'
  print('\n~> %s\n' % cmd)
  rc = easy_run.go(cmd)

def test_geo(result, opposite=False):
  input_model_filename = 'paral_geo_output.pdb'
  with open('%s_real_space_refined_000_initial.geo' % input_model_filename.replace('.pdb', '')) as f:
    lines = f.read()
  if 0:
    print(lines)
    for i in range(len(result)):
      print(i, lines.find(result[:i]), result[i-10:i])
  if opposite:
    assert lines.find(result)==-1, 'found: %s' % result
  else:
    assert lines.find(result)>-1, 'not found: %s' % result
  print('OK')

def main():
  write_and_run(large_pdb)
  result = '''Planarity | Basepair planarity | restraints: 5
Sorted by residual:
                               delta    sigma   weight rms_deltas residual
plane pdb=" C1'  DC C   7 "   -0.366 1.76e-01 3.23e+01   1.84e-01 2.28e+01
      pdb=" N1   DC C   7 "   -0.112 1.76e-01 3.23e+01
      pdb=" C2   DC C   7 "   -0.073 1.76e-01 3.23e+01
      pdb=" O2   DC C   7 "   -0.185 1.76e-01 3.23e+01
      pdb=" N3   DC C   7 "    0.110 1.76e-01 3.23e+01
      pdb=" C4   DC C   7 "    0.202 1.76e-01 3.23e+01
      pdb=" N4   DC C   7 "    0.340 1.76e-01 3.23e+01
      pdb=" C5   DC C   7 "    0.138 1.76e-01 3.23e+01
      pdb=" C6   DC C   7 "   -0.002 1.76e-01 3.23e+01
      pdb=" C1'  DG D  10 "    0.142 1.76e-01 3.23e+01
      pdb=" N9   DG D  10 "   -0.030 1.76e-01 3.23e+01
      pdb=" C8   DG D  10 "   -0.167 1.76e-01 3.23e+01
      pdb=" N7   DG D  10 "   -0.231 1.76e-01 3.23e+01
      pdb=" C5   DG D  10 "   -0.106 1.76e-01 3.23e+01
      pdb=" C6   DG D  10 "   -0.096 1.76e-01 3.23e+01
      pdb=" O6   DG D  10 "   -0.252 1.76e-01 3.23e+01
      pdb=" N1   DG D  10 "    0.039 1.76e-01 3.23e+01
      pdb=" C2   DG D  10 "    0.167 1.76e-01 3.23e+01
      pdb=" N2   DG D  10 "    0.300 1.76e-01 3.23e+01
      pdb=" N3   DG D  10 "    0.167 1.76e-01 3.23e+01
      pdb=" C4   DG D  10 "    0.015 1.76e-01 3.23e+01'''
  test_geo(result)
  result = '''Parallelity | Stacking parallelity | restraints: 8
Sorted by residual:
    plane 1                plane 2                residual  delta(deg) sigma
    pdb=" C1'  DC C   7 "  pdb=" C1'  DG C   8 "  3.21e+01  12.4210    0.0270
    pdb=" N1   DC C   7 "  pdb=" N9   DG C   8 "
    pdb=" C2   DC C   7 "  pdb=" C8   DG C   8 "
    pdb=" O2   DC C   7 "  pdb=" N7   DG C   8 "
    pdb=" N3   DC C   7 "  pdb=" C5   DG C   8 "
    pdb=" C4   DC C   7 "  pdb=" C6   DG C   8 "
    pdb=" N4   DC C   7 "  pdb=" O6   DG C   8 "
    pdb=" C5   DC C   7 "  pdb=" N1   DG C   8 "
    pdb=" C6   DC C   7 "  pdb=" C2   DG C   8 "
                           pdb=" N2   DG C   8 "
                           pdb=" N3   DG C   8 "
                           pdb=" C4   DG C   8 "'''
  test_geo(result)
  result = '''Parallelity | Basepair parallelity | restraints: 5
Sorted by residual:
    plane 1                plane 2                residual  delta(deg) sigma
    pdb=" C1'  DG C   8 "  pdb=" C1'  DC D   9 "  2.80e+01  14.3936    0.0335
    pdb=" N9   DG C   8 "  pdb=" N1   DC D   9 "
    pdb=" C8   DG C   8 "  pdb=" C2   DC D   9 "
    pdb=" N7   DG C   8 "  pdb=" O2   DC D   9 "
    pdb=" C5   DG C   8 "  pdb=" N3   DC D   9 "
    pdb=" C6   DG C   8 "  pdb=" C4   DC D   9 "
    pdb=" O6   DG C   8 "  pdb=" N4   DC D   9 "
    pdb=" N1   DG C   8 "  pdb=" C5   DC D   9 "
    pdb=" C2   DG C   8 "  pdb=" C6   DC D   9 "
    pdb=" N2   DG C   8 "'''
  test_geo(result)

  write_and_run(small_pdb)
  result = '''Parallelity | Stacking parallelity | restraints: 2
Sorted by residual:
    plane 1                plane 2                residual  delta(deg) sigma
    pdb=" C1'  DC D  11 "  pdb=" C1'  DC D  12 "  1.50e+01   8.4829    0.0270
    pdb=" N1   DC D  11 "  pdb=" N1   DC D  12 "
    pdb=" C2   DC D  11 "  pdb=" C2   DC D  12 "
    pdb=" O2   DC D  11 "  pdb=" O2   DC D  12 "
    pdb=" N3   DC D  11 "  pdb=" N3   DC D  12 "
    pdb=" C4   DC D  11 "  pdb=" C4   DC D  12 "
    pdb=" N4   DC D  11 "  pdb=" N4   DC D  12 "
    pdb=" C5   DC D  11 "  pdb=" C5   DC D  12 "
    pdb=" C6   DC D  11 "  pdb=" C6   DC D  12 "

    plane 1                plane 2                residual  delta(deg) sigma
    pdb=" C1'  DG D  10 "  pdb=" C1'  DC D  11 "  1.14e+00   2.3398    0.0270
    pdb=" N9   DG D  10 "  pdb=" N1   DC D  11 "
    pdb=" C8   DG D  10 "  pdb=" C2   DC D  11 "
    pdb=" N7   DG D  10 "  pdb=" O2   DC D  11 "
    pdb=" C5   DG D  10 "  pdb=" N3   DC D  11 "
    pdb=" C6   DG D  10 "  pdb=" C4   DC D  11 "
    pdb=" O6   DG D  10 "  pdb=" N4   DC D  11 "
    pdb=" N1   DG D  10 "  pdb=" C5   DC D  11 "
    pdb=" C2   DG D  10 "  pdb=" C6   DC D  11 "
    pdb=" N2   DG D  10 "'''
  test_geo(result)
  test_geo('Basepair planarity | restraints:', opposite=True)
  test_geo('Basepair parallelity | restraints:', opposite=True)

if __name__ == '__main__':
  main()
