; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mips -mcpu=mips2 -relocation-model=pic \
; RUN:   -mips-jalr-reloc=false | FileCheck %s -check-prefixes=MIPS2
; RUN: llc < %s -mtriple=mips -mcpu=mips32 -relocation-model=pic \
; RUN:   -mips-jalr-reloc=false | FileCheck %s -check-prefixes=MIPS32

; RUN: llc < %s -mtriple=mips64 -mcpu=mips3 -relocation-model=pic \
; RUN:   -mips-jalr-reloc=false | FileCheck %s -check-prefixes=MIPS3
; RUN: llc < %s -mtriple=mips64 -mcpu=mips64 -relocation-model=pic \
; RUN:   -mips-jalr-reloc=false | FileCheck %s -check-prefixes=MIPS64

; RUN: llc < %s -mtriple=mips -mcpu=mips2 -O0 -relocation-model=pic \
; RUN:   -mips-jalr-reloc=false | FileCheck %s -check-prefixes=MIPS2-O0
; RUN: llc < %s -mtriple=mips -mcpu=mips32 -O0 -relocation-model=pic \
; RUN:   -mips-jalr-reloc=false | FileCheck %s -check-prefixes=MIPS32-O0

define signext i32 @udiv_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; MIPS2-LABEL: udiv_i32:
; MIPS2:       # %bb.0: # %entry
; MIPS2-NEXT:    divu $zero, $4, $5
; MIPS2-NEXT:    teq $5, $zero, 7
; MIPS2-NEXT:    mflo $1
; MIPS2-NEXT:    nop
; MIPS2-NEXT:    nop
; MIPS2-NEXT:    divu $zero, $1, $6
; MIPS2-NEXT:    teq $6, $zero, 7
; MIPS2-NEXT:    mflo $2
; MIPS2-NEXT:    jr $ra
; MIPS2-NEXT:    nop
;
; MIPS32-LABEL: udiv_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    divu $zero, $4, $5
; MIPS32-NEXT:    teq $5, $zero, 7
; MIPS32-NEXT:    mflo $1
; MIPS32-NEXT:    divu $zero, $1, $6
; MIPS32-NEXT:    teq $6, $zero, 7
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    mflo $2
;
entry:
  %udiv = udiv i32 %a, %b
  %udiv1 = udiv i32 %udiv, %c
  ret i32 %udiv1
}

define signext i64 @udiv_i64(i64 signext %a, i64 signext %b, i64 signext %c) {
; MIPS3-LABEL: udiv_i64:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    ddivu $zero, $4, $5
; MIPS3-NEXT:    teq $5, $zero, 7
; MIPS3-NEXT:    mflo $1
; MIPS3-NEXT:    nop
; MIPS3-NEXT:    nop
; MIPS3-NEXT:    ddivu $zero, $1, $6
; MIPS3-NEXT:    teq $6, $zero, 7
; MIPS3-NEXT:    mflo $2
; MIPS3-NEXT:    jr $ra
; MIPS3-NEXT:    nop
;
; MIPS64-LABEL: udiv_i64:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    ddivu $zero, $4, $5
; MIPS64-NEXT:    teq $5, $zero, 7
; MIPS64-NEXT:    mflo $1
; MIPS64-NEXT:    ddivu $zero, $1, $6
; MIPS64-NEXT:    teq $6, $zero, 7
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    mflo $2
;
entry:
  %udiv = udiv i64 %a, %b
  %udiv1 = udiv i64 %udiv, %c
  ret i64 %udiv1
}

define signext i32 @udiv_lw_udiv_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; MIPS2-O0-LABEL: udiv_lw_udiv_i32:
; MIPS2-O0:       # %bb.0: # %entry
; MIPS2-O0-NEXT:    addiu $sp, $sp, -16
; MIPS2-O0-NEXT:    .cfi_def_cfa_offset 16
; MIPS2-O0-NEXT:    sw $4, 12($sp)
; MIPS2-O0-NEXT:    sw $5, 8($sp)
; MIPS2-O0-NEXT:    sw $6, 4($sp)
; MIPS2-O0-NEXT:    lw $2, 12($sp)
; MIPS2-O0-NEXT:    lw $1, 8($sp)
; MIPS2-O0-NEXT:    divu $zero, $2, $1
; MIPS2-O0-NEXT:    teq	$1, $zero, 7
; MIPS2-O0-NEXT:    mflo $2
; MIPS2-O0-NEXT:    lw $1, 4($sp)
; MIPS2-O0-NEXT:    nop
; MIPS2-O0-NEXT:    divu $zero, $2, $1
; MIPS2-O0-NEXT:    teq	$1, $zero, 7
; MIPS2-O0-NEXT:    mflo $2
; MIPS2-O0-NEXT:    addiu $sp, $sp, 16
; MIPS2-O0-NEXT:    jr $ra
; MIPS2-O0-NEXT:    nop
;
; MIPS32-O0-LABEL: udiv_lw_udiv_i32:
; MIPS32-O0:       # %bb.0: # %entry
; MIPS32-O0-NEXT:    addiu $sp, $sp, -16
; MIPS32-O0-NEXT:    .cfi_def_cfa_offset 16
; MIPS32-O0-NEXT:    sw $4, 12($sp)
; MIPS32-O0-NEXT:    sw $5, 8($sp)
; MIPS32-O0-NEXT:    sw $6, 4($sp)
; MIPS32-O0-NEXT:    lw $2, 12($sp)
; MIPS32-O0-NEXT:    lw $1, 8($sp)
; MIPS32-O0-NEXT:    divu $zero, $2, $1
; MIPS32-O0-NEXT:    teq $1, $zero, 7
; MIPS32-O0-NEXT:    mflo $2
; MIPS32-O0-NEXT:    lw $1, 4($sp)
; MIPS32-O0-NEXT:    divu $zero, $2, $1
; MIPS32-O0-NEXT:    teq $1, $zero, 7
; MIPS32-O0-NEXT:    mflo $2
; MIPS32-O0-NEXT:    addiu $sp, $sp, 16
; MIPS32-O0-NEXT:    jr $ra
; MIPS32-O0-NEXT:    nop
;
entry:
  %a.addr = alloca i32, align 4
  %b.addr = alloca i32, align 4
  %c.addr = alloca i32, align 4
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  store i32 %c, ptr %c.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %udiv = udiv i32 %0, %1
  %2 = load i32, ptr %c.addr, align 4
  %udiv1 = udiv i32 %udiv, %2
  ret i32 %udiv1
}

