# makefile.vs
# Makefile for use with Visual Studio to generate Windows binaries
# Copyright 2005-2022 by Christopher Heng. All rights reserved.

# Programs
CC = cl
CP = copy
LD = link
RM = del
ZIP = zip

# Flags
CFLAGS = $(CFL1) $(CFL2)
	# /nologo	- suppress startup banner
	# /Zi		- debug - create program database
	# /W4		- warning level 4
	# /WX		- treat warnings as errors
	# /02		- maximize speed (/Og /Oi /Ot /Oy /Gs /GF /Gy)
	#		note that
	#		/Og global optimizations (implied by /O2)
	#		/Oi - enable intrinsic functions
	#		/Ot - optimize speed
	#		/Oy -
	#		/Gs stack checking calls (for local variables)
	#		/GF enable string pooling
	#		/Gy function-level linking
	# /D "NDEBUG" /D "_CONSOLE" /D "WIN32" /D "_MBCS"
	# /MT		- multi-threaded library
	# /utf-8 - set source and execution character sets to UTF-8
	# /Fo		- output dir
	# /I		- include directory
	# /c		- compile only
CFL1 =  /nologo /W4 /WX /O2 /D "NDEBUG" /D "_CONSOLE" /D "WIN32" /D "_MBCS" /MT /utf-8 /std:c17
CFL2 = /I "$(LIBDIR)" /Fo"$(BINDIR)\\" /c
LDFLAGS = $(LDFL1) $(LDFL2) $(LDFL3)
LDFL1 = /OUT:"$(FROMDOS)" /INCREMENTAL:NO /NOLOGO
LDFL2 = /SUBSYSTEM:CONSOLE /OPT:REF /OPT:ICF /WX
LDFL3 = setargv.obj

# Directories
BINDIR = .\bin
LIBDIR = .\lib

# Files
FROMDOS = $(BINDIR)\fromdos.exe
TODOS = $(BINDIR)\todos.exe

OBJS =	$(BINDIR)\emsg.obj \
	$(BINDIR)\init.obj \
	$(BINDIR)\getopt.obj \
	$(BINDIR)\mkstemp.obj \
	$(BINDIR)\tofrodos.obj \
	$(BINDIR)\utility.obj

# Implicit rules
.c{$(BINDIR)}.obj:
	$(CC) @<<
  $(CFLAGS) $<
<<

# Rules
all: $(FROMDOS) $(TODOS)

clean:
	$(RM) $(OBJS)

clobber: clean
	$(RM) $(FROMDOS) $(TODOS)

$(FROMDOS): $(OBJS)
	$(LD) @<<
  $(LDFLAGS) $(OBJS)
<<

$(TODOS): $(FROMDOS)
	$(CP) $(FROMDOS) $(TODOS)

$(BINDIR)\getopt.obj: $(LIBDIR)\getopt.c $(LIBDIR)\getopt.h
	$(CC) $(CFLAGS) $(LIBDIR)\getopt.c

$(BINDIR)\mkstemp.obj: $(LIBDIR)\mkstemp.c
	$(CC) $(CFLAGS) $(LIBDIR)\mkstemp.c

$(BINDIR)\emsg.obj: emsg.c emsg.h tofrodos.h

$(BINDIR)\init.obj: init.c emsg.h tofrodos.h utility.h version.h

$(BINDIR)\tofrodos.obj: tofrodos.c emsg.h tofrodos.h utility.h version.h

$(BINDIR)\utility.obj: utility.c emsg.h tofrodos.h utility.h
