.PS
# PS50.m4
# See Horowitz and Hill Fig 9.49 p. 630
cct_init
command "{\small"

# pconnex(U,PF)

   h = dimen_*2.5
 T: dot
 Cs: capacitor(down_ h/2)
   llabel(,"$C_s$" ljust "$0.1{-}\SI{1}{\micro\farad}$" ljust)
   dot; { line right_ dimen_*3/4; ground(,,F) }
 Rs: resistor(down_ Cs.len)
   llabel(,"$R_s$" ljust "$\SI{10}{\ohm}{-}$" ljust "\SI{100}{\ohm}" ljust)
 B: dot
 Br: [ size=dimen_/2; W: dot; 
  { diode(to Here+(size, size)); N: dot
    diode(to Here+( size,-size)); E: dot }
   diode(to Here+( size,-size)); S: dot; diode(to E)
   box thick 0.4 dashed wid 3*size ht 3*size with .c at 0.5 between N and S
   "\scriptsize GBU604" at last box.n above rjust ] \
     with .W at Cs.end+(dimen_*3/2,0)
   line from Br.N to (Br.N,T) then left Br.N.x-Cs.x+dimen_*3/4
   { line from (Here,B) to (Br.S,B) then to Br.S }
 T80: transformer(up_ h,,,W) with .P2 at Here
   "\SI{115}{\volt}:\SI{80}{V} CT" at T80+(-dimen_/4,-h/2-dimen_/3) \
   "\SI{4}{\ampere}"

   line from Br.E right dimen_/2 then up T.y-Br.E.y then right_ dimen_*2/3
   dot; {C1: capacitor(down_ Cs.len+dimen_/3,C+); rlabel(,C_1)
    dot; C2: capacitor(down_ C1.len,C+); rlabel(,C_2); dot}
   {"$2$ $\times$ \SI{8200}{\micro\farad}" at C1.start+(0,dimen_/2) \
    "\SI{80}{\volt}dc" }
   {line right_ dimen_*3/2
 P50: dot(,dotrad_*3/2,1)
     "${+}\SI{50}{\volt}$" wid 29bp__ at last [].e ljust \
     "\SI{2}{\ampere}" ljust }
   dot(at 1/2 between Here and P50)
 R2: resistor(down_ C1.len)
   llabel(,"$R_2$" ljust "$680$" ljust "\SI{5}{\watt}" ljust)
   {dot; line to (C1,Here)}
   {line to (P50,Here); dot(,dotrad_*3/2,1)
    "\scriptsize COM" at last [].e ljust}
 R3: resistor(down_ C2.len)
   llabel(,"$R_3$" ljust "$680$" ljust "\SI{5}{\watt}" ljust); dot
   {line to (P50,Here); dot(,dotrad_*3/2,1); 
     "${-}\SI{50}{\volt}$" at last [].e ljust "\SI{2}{\ampere}" ljust }
   line left_ Here.x-Br.W.x+dimen_/2; continue to (Here,Br.W) then to Br.W
   line from T80.TP right_ (Rs.x-T80.TP.x)/2 \
     then down_ T80.TP.y-B.y + (B.y-C2.end.y)/2
   continue to (Br.E+(dimen_/2,0),Here) 
   continue to (Here,C2.start) then to C2.start
   dot(at (T80.S2,T)-(dimen_*4/3,0))
   { line from (T80.S2,T) to Here-(dimen_/2,0)
    line dashed to Here-(dimen_/2,0) chop dimen_/10; In1: Here }
   { line from (T80.S2,B) to (Here-(dimen_/2,0),B)
    line dashed to Here-(dimen_/2,0) chop dimen_/10; In2: Here}
 F2: fuse(down_ h/2,D)
   llabel(,"$F_2$" ljust "\SI{100}{\celsius}" ljust "cutout" ljust)
 MOV: ebox(down_ to (Here,B))
   variable(,uNN,,dimen_/2)
   "\scriptsize MOV" at last [].e ljust \
   "$130\hbox{V}_{\hbox{\scriptsize ac}}$" ljust "\scriptsize S20K130" ljust
   { arc dashed from 3rd last [].w-(2bp__,0) to 2nd last [].w-(2bp__,0) \
      rad dimen_ }
   dot(at MOV.end)

 SB: In1+(dimen_*4,dimen_/2)
 ST: SB+(0,h)
 T880: transformer(right_ dimen_*7/8,,,WD1) at (ST+SB)/2-(2*dimen_,0)
   line from T880.P2 to (T880.P2,SB) then to SB; dot(,dotrad_*3/2,1)
   line from T880.S2 to (T880.S2,ST) then to ST; dot(,dotrad_*3/2,1)
   line dashed from ST.e right_ dimen_/2 chop dimen_/10
   line dashed from SB.e right_ dimen_/2 chop dimen_/10
   dot(at (T880.P2,ST)+(dimen_,0))
 Cy: capacitor(down_ h/2); rlabel(C_y,,\SI{2.2}{\nano\farad}); dot
   {line right_ dimen_/3; ground(,,F)}
   capacitor(down_ to (Here,SB)); rlabel(C_y,,\SI{2.2}{\nano\farad}); dot
 Socket: pconnex(U,PF) at T880.w-(dimen_*3.5,0)
   line right_ dimen_/2 from Socket.G.e; ground(,,F)
   line from Socket.H.n to (Socket.H.n,ST); 
 F1: fuse(right_ dimen_,D); llabel(,"F1"); rlabel(,"\SI{6}{\ampere} SB")
 TS: lswitch(right_ dimen_*3/4,,D); { line to (T880.S1,Here) then to T880.S1 }
   dot(at Here+(dimen_/2,0))
   { R1: resistor(down_ to (Here,SB)); rlabel(,"$R_1$" rjust \
      "\SI{1}{\mega\ohm}" rjust); dot }
   dot(at Here+(dimen_/2,0))
 Cx: capacitor(down_ to (Here,SB)); llabel(C_{\hbox{\scriptsize x}},,
     \SI{100}{\nano\farad}); dot
   line from Socket.N.s to (Socket.N.s,SB) then to (TS.start,SB)
 BS: lswitch(right_ TS.len,,D); { line dashed from TS to BS chop dimen_/3 }
   line to (T880.P1,Here) then to T880.P1
   "Qualtek 880-06/006" at Cx.start+(dimen_/2,dimen_/4)

command "}%"
.PE
