
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <AppStd_Application.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_AppStd(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("AppStd"));
py::object klass;

//Python trampoline classes

// classes

    // Class AppStd_Application from ./opencascade/AppStd_Application.hxx
    klass = m.attr("AppStd_Application");

    // default constructor
    register_default_constructor<AppStd_Application ,opencascade::handle<AppStd_Application>>(m,"AppStd_Application");

    // nested enums

    static_cast<py::class_<AppStd_Application ,opencascade::handle<AppStd_Application>  , TDocStd_Application >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ResourcesName",
             (Standard_CString (AppStd_Application::*)() ) static_cast<Standard_CString (AppStd_Application::*)() >(&AppStd_Application::ResourcesName),
             R"#(returns the file name which contains application resources)#" 
          )
        .def("DumpJson",
             (void (AppStd_Application::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (AppStd_Application::*)( std::ostream & ,  Standard_Integer  ) const>(&AppStd_Application::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&AppStd_Application::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&AppStd_Application::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (AppStd_Application::*)() const) static_cast<const opencascade::handle<Standard_Type> & (AppStd_Application::*)() const>(&AppStd_Application::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/AppStd_Application.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
