# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._operations._operations import build_logs_ingestion_upload_request
from ..._utils.model_base import SdkJSONEncoder
from ..._utils.utils import ClientMixinABC
from .._configuration import LogsIngestionClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class LogsIngestionClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], LogsIngestionClientConfiguration]
):

    @overload
    async def _upload(
        self,
        rule_id: str,
        stream_name: str,
        body: List[Dict[str, Any]],
        *,
        content_encoding: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...
    @overload
    async def _upload(
        self,
        rule_id: str,
        stream_name: str,
        body: IO[bytes],
        *,
        content_encoding: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...

    @distributed_trace_async
    async def _upload(
        self,
        rule_id: str,
        stream_name: str,
        body: Union[List[Dict[str, Any]], IO[bytes]],
        *,
        content_encoding: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Ingestion API used to directly ingest data using Data Collection Rules.

        Ingestion API used to directly ingest data using Data Collection Rules.

        :param rule_id: The immutable ID of the Data Collection Rule resource. Required.
        :type rule_id: str
        :param stream_name: The streamDeclaration name as defined in the Data Collection Rule.
         Required.
        :type stream_name: str
        :param body: The array of objects matching the schema defined by the provided stream. Is either
         a [{str: Any}] type or a IO[bytes] type. Required.
        :type body: list[dict[str, any]] or IO[bytes]
        :keyword content_encoding: The content encoding of the request body which is always 'gzip'.
         Default value is None.
        :paramtype content_encoding: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_logs_ingestion_upload_request(
            rule_id=rule_id,
            stream_name=stream_name,
            content_encoding=content_encoding,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
