# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementGuestDiagnosticsSettingsAssociationOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_association_create_or_update(self, resource_group):
        response = await self.client.guest_diagnostics_settings_association.create_or_update(
            resource_uri="str",
            association_name="str",
            diagnostic_settings_association={
                "guestDiagnosticSettingsName": "str",
                "location": "str",
                "id": "str",
                "name": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_association_get(self, resource_group):
        response = await self.client.guest_diagnostics_settings_association.get(
            resource_uri="str",
            association_name="str",
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_association_delete(self, resource_group):
        response = await self.client.guest_diagnostics_settings_association.delete(
            resource_uri="str",
            association_name="str",
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_association_update(self, resource_group):
        response = await self.client.guest_diagnostics_settings_association.update(
            resource_uri="str",
            association_name="str",
            parameters={"guestDiagnosticSettingsName": "str", "tags": {"str": "str"}},
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_association_list(self, resource_group):
        response = self.client.guest_diagnostics_settings_association.list(
            api_version="2018-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_association_list_by_resource_group(self, resource_group):
        response = self.client.guest_diagnostics_settings_association.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
