# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hardwaresecuritymodules import HardwareSecurityModulesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHardwareSecurityModulesMgmtCloudHsmClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HardwareSecurityModulesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_get(self, resource_group):
        response = self.client.cloud_hsm_clusters.get(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_create_or_update(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            body={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "activationState": "str",
                    "autoGeneratedDomainNameLabelScope": "str",
                    "hsms": [{"fqdn": "str", "state": "str", "stateMessage": "str"}],
                    "privateEndpointConnections": [
                        {
                            "etag": "str",
                            "id": "str",
                            "name": "str",
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "groupIds": ["str"],
                                "privateEndpoint": {"id": "str"},
                                "provisioningState": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "statusMessage": "str",
                },
                "sku": {"family": "str", "name": "str", "capacity": 0},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_update(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_update(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            body={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_delete(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_delete(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_list_by_resource_group(self, resource_group):
        response = self.client.cloud_hsm_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_list_by_subscription(self, resource_group):
        response = self.client.cloud_hsm_clusters.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_validate_backup_properties(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_validate_backup_properties(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_backup(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_backup(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_validate_restore_properties(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_validate_restore_properties(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_hsm_clusters_begin_restore(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_restore(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            restore_request_properties={"azureStorageBlobContainerUri": "str", "backupId": "str", "token": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
