# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementAppServicePlansOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list(self, resource_group):
        response = self.client.app_service_plans.list(
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_by_resource_group(self, resource_group):
        response = self.client.app_service_plans.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get(self, resource_group):
        response = self.client.app_service_plans.get(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_begin_create_or_update(self, resource_group):
        response = self.client.app_service_plans.begin_create_or_update(
            resource_group_name=resource_group.name,
            name="str",
            app_service_plan={
                "location": "str",
                "asyncScalingEnabled": bool,
                "elasticScaleEnabled": bool,
                "extendedLocation": {"name": "str", "type": "str"},
                "freeOfferExpirationTime": "2020-02-20 00:00:00",
                "geoRegion": "str",
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "hyperV": False,
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "installScripts": [{"name": "str", "source": {"sourceUri": "str", "type": "str"}}],
                "isCustomMode": bool,
                "isSpot": bool,
                "isXenon": False,
                "kind": "str",
                "kubeEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "maximumElasticWorkerCount": 0,
                "maximumNumberOfWorkers": 0,
                "name": "str",
                "network": {"virtualNetworkSubnetId": "str"},
                "numberOfSites": 0,
                "numberOfWorkers": 0,
                "perSiteScaling": False,
                "planDefaultIdentity": {"identityType": "str", "userAssignedIdentityResourceId": "str"},
                "provisioningState": "str",
                "rdpEnabled": bool,
                "registryAdapters": [
                    {
                        "keyVaultSecretReference": {"referenceStatus": "str", "secretUri": "str"},
                        "registryKey": "str",
                        "type": "str",
                    }
                ],
                "reserved": False,
                "resourceGroup": "str",
                "sku": {
                    "capabilities": [{"name": "str", "reason": "str", "value": "str"}],
                    "capacity": 0,
                    "family": "str",
                    "locations": ["str"],
                    "name": "str",
                    "size": "str",
                    "skuCapacity": {"default": 0, "elasticMaximum": 0, "maximum": 0, "minimum": 0, "scaleType": "str"},
                    "tier": "str",
                },
                "spotExpirationTime": "2020-02-20 00:00:00",
                "status": "str",
                "storageMounts": [
                    {
                        "credentialsKeyVaultReference": {"referenceStatus": "str", "secretUri": "str"},
                        "destinationPath": "str",
                        "name": "str",
                        "source": "str",
                        "type": "str",
                    }
                ],
                "subscription": "str",
                "tags": {"str": "str"},
                "targetWorkerCount": 0,
                "targetWorkerSizeId": 0,
                "type": "str",
                "workerTierName": "str",
                "zoneRedundant": False,
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_delete(self, resource_group):
        response = self.client.app_service_plans.delete(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_update(self, resource_group):
        response = self.client.app_service_plans.update(
            resource_group_name=resource_group.name,
            name="str",
            app_service_plan={
                "elasticScaleEnabled": bool,
                "freeOfferExpirationTime": "2020-02-20 00:00:00",
                "geoRegion": "str",
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "hyperV": False,
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isSpot": bool,
                "isXenon": False,
                "kind": "str",
                "kubeEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "maximumElasticWorkerCount": 0,
                "maximumNumberOfWorkers": 0,
                "name": "str",
                "numberOfSites": 0,
                "numberOfWorkers": 0,
                "perSiteScaling": False,
                "provisioningState": "str",
                "reserved": False,
                "resourceGroup": "str",
                "spotExpirationTime": "2020-02-20 00:00:00",
                "status": "str",
                "subscription": "str",
                "targetWorkerCount": 0,
                "targetWorkerSizeId": 0,
                "type": "str",
                "workerTierName": "str",
                "zoneRedundant": False,
            },
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_capabilities(self, resource_group):
        response = self.client.app_service_plans.list_capabilities(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_server_farm_rdp_password(self, resource_group):
        response = self.client.app_service_plans.get_server_farm_rdp_password(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_hybrid_connection(self, resource_group):
        response = self.client.app_service_plans.get_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_delete_hybrid_connection(self, resource_group):
        response = self.client.app_service_plans.delete_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_hybrid_connection_keys(self, resource_group):
        response = self.client.app_service_plans.list_hybrid_connection_keys(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_web_apps_by_hybrid_connection(self, resource_group):
        response = self.client.app_service_plans.list_web_apps_by_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_hybrid_connection_plan_limit(self, resource_group):
        response = self.client.app_service_plans.get_hybrid_connection_plan_limit(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_hybrid_connections(self, resource_group):
        response = self.client.app_service_plans.list_hybrid_connections(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_server_farm_instance_details(self, resource_group):
        response = self.client.app_service_plans.get_server_farm_instance_details(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_restart_web_apps(self, resource_group):
        response = self.client.app_service_plans.restart_web_apps(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_web_apps(self, resource_group):
        response = self.client.app_service_plans.list_web_apps(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_server_farm_skus(self, resource_group):
        response = self.client.app_service_plans.get_server_farm_skus(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_usages(self, resource_group):
        response = self.client.app_service_plans.list_usages(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_vnets(self, resource_group):
        response = self.client.app_service_plans.list_vnets(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_vnet_from_server_farm(self, resource_group):
        response = self.client.app_service_plans.get_vnet_from_server_farm(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_vnet_gateway(self, resource_group):
        response = self.client.app_service_plans.get_vnet_gateway(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_update_vnet_gateway(self, resource_group):
        response = self.client.app_service_plans.update_vnet_gateway(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "vnetName": "str",
                "vpnPackageUri": "str",
            },
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_list_routes_for_vnet(self, resource_group):
        response = self.client.app_service_plans.list_routes_for_vnet(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_get_route_for_vnet(self, resource_group):
        response = self.client.app_service_plans.get_route_for_vnet(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            route_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_create_or_update_vnet_route(self, resource_group):
        response = self.client.app_service_plans.create_or_update_vnet_route(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            route_name="str",
            route={
                "endAddress": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "routeType": "str",
                "startAddress": "str",
                "type": "str",
            },
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_delete_vnet_route(self, resource_group):
        response = self.client.app_service_plans.delete_vnet_route(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            route_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_update_vnet_route(self, resource_group):
        response = self.client.app_service_plans.update_vnet_route(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            route_name="str",
            route={
                "endAddress": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "routeType": "str",
                "startAddress": "str",
                "type": "str",
            },
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_reboot_worker(self, resource_group):
        response = self.client.app_service_plans.reboot_worker(
            resource_group_name=resource_group.name,
            name="str",
            worker_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_app_service_plans_recycle_managed_instance_worker(self, resource_group):
        response = self.client.app_service_plans.recycle_managed_instance_worker(
            resource_group_name=resource_group.name,
            name="str",
            worker_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...
