// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.

#ifndef _BLDVER_H_
#define _BLDVER_H_

#define STR_HELPER(x) #x
#define WSTR_HELPER(x) L#x
#define NUM_TO_STR(x) STR_HELPER(x)
#define NUM_TO_WSTR(x) WSTR_HELPER(x)

//
// Build versions are properties of the build system but can be overwritten below
//
//  #define PRODUCT_MAJOR             7
//  #define PRODUCT_MINOR             1
//  #define BUILD_MAJOR               1972
//  #define BUILD_MINOR               0

#define PRODUCT_MAJOR_STRING      NUM_TO_STR(PRODUCT_MAJOR)
#define PRODUCT_MAJOR_STRING_L    NUM_TO_WSTR(PRODUCT_MAJOR)
#define PRODUCT_MAJOR_NUMBER      PRODUCT_MAJOR

#define PRODUCT_MINOR_STRING      NUM_TO_STR(PRODUCT_MINOR)
#define PRODUCT_MINOR_STRING_L    NUM_TO_WSTR(PRODUCT_MINOR)
#define PRODUCT_MINOR_NUMBER      PRODUCT_MINOR

#define BUILD_MAJOR_STRING        NUM_TO_STR(BUILD_MAJOR)
#define BUILD_MAJOR_STRING_L      NUM_TO_WSTR(BUILD_MAJOR)
#define BUILD_MAJOR_NUMBER        BUILD_MAJOR

#define BUILD_MINOR_STRING        NUM_TO_STR(BUILD_MINOR)
#define BUILD_MINOR_STRING_L      NUM_TO_WSTR(BUILD_MINOR)
#define BUILD_MINOR_NUMBER        BUILD_MINOR

#define BUILD_NUMBER              BUILD_MAJOR_STRING "." BUILD_MINOR_STRING
#define BUILD_NUM                 BUILD_MAJOR , BUILD_MINOR
#define PRODUCT_NUMBER            PRODUCT_MAJOR_STRING "." PRODUCT_MINOR_STRING
#define PRODUCT_NUM               PRODUCT_MAJOR , PRODUCT_MINOR
#define INET_VERSION              PRODUCT_MAJOR_STRING "." PRODUCT_MINOR_STRING "." BUILD_MAJOR_STRING "." BUILD_MINOR_STRING
#define INET_VERSION_L            PRODUCT_MAJOR_STRING_L L"." PRODUCT_MINOR_STRING_L L"." BUILD_MAJOR_STRING_L L"." BUILD_MINOR_STRING_L
#define INET_VER                  PRODUCT_MAJOR , PRODUCT_MINOR , BUILD_MAJOR , BUILD_MINOR

#define BUILD_PRIVATE             "Built by IISBLD on IISBLD.\0"

#undef VER_PRODUCTVERSION
#undef VER_PRODUCTVERSION_STR
#undef VER_PRODUCTMAJORVERSION
#undef VER_PRODUCTMINORVERSION
#undef VER_PRODUCTBUILD
#undef VER_PRODUCTBUILD_QFE
#undef VER_PRODUCTNAME_STR
#undef VER_COMPANYNAME_STR

#define VER_PRODUCTVERSION        PRODUCT_MAJOR,PRODUCT_MINOR,BUILD_MAJOR,BUILD_MINOR
#define VER_PRODUCTVERSION_STR    PRODUCT_MAJOR_STRING "." PRODUCT_MINOR_STRING "." BUILD_MAJOR_STRING "." BUILD_MINOR_STRING
#define VER_PRODUCTMAJORVERSION   PRODUCT_MAJOR
#define VER_PRODUCTMINORVERSION   PRODUCT_MINOR
#define VER_PRODUCTBUILD          BUILD_MAJOR
#define VER_PRODUCTBUILD_QFE      BUILD_MINOR
#define VER_PRODUCTNAME_STR       "Microsoft Web Platform Extensions"
#define VER_COMPANYNAME_STR       "Microsoft Corporation"

#endif
