#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Skullgirls
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250701.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='skullgirls'
GAME_NAME='Skullgirls'

# The following DRM-free archives are no longer available for sale from Humble Bundle.
# The game is still listed on their store, but only provided as a Steam key.

ARCHIVE_BASE_1_NAME='Skullgirls-15719.tar'
ARCHIVE_BASE_1_MD5='104a6976aec70d423756e008a5b8554c'
ARCHIVE_BASE_1_SIZE='4172735'
ARCHIVE_BASE_1_VERSION='15719-humble170628'

ARCHIVE_BASE_0_NAME='Skullgirls-1.0.1.sh'
ARCHIVE_BASE_0_MD5='bf110f7d29bfd4b9e075584e41fef402'
ARCHIVE_BASE_0_SIZE='4200000'
ARCHIVE_BASE_0_VERSION='1.0.1-humble152310'

CONTENT_PATH_DEFAULT='SkullGirls'
CONTENT_PATH_DEFAULT_0='data'
CONTENT_LIBS_BIN_FILES='
libSDL2_locale.so.0'
## libSDL2_mixer-2.0.so.0 must be included, because it provides a non-standard symbol
## (SDL_AudioStreamGet) that libSDL2_locale.so.0 relies on.
CONTENT_LIBS_BIN_FILES="$CONTENT_LIBS_BIN_FILES
libSDL2_mixer-2.0.so.0"
## libSDL2-2.0.so.0 must be included to prevent a silent crash on start-up.
CONTENT_LIBS_BIN_FILES="$CONTENT_LIBS_BIN_FILES
libSDL2-2.0.so.0"
CONTENT_LIBS_BIN64_RELATIVE_PATH='lib/x86_64-pc-linux-gnu'
CONTENT_LIBS_BIN64_RELATIVE_PATH_0='x86_64/lib/x86_64-pc-linux-gnu'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='lib/i686-pc-linux-gnu'
CONTENT_LIBS_BIN32_RELATIVE_PATH_0='i686/lib/i686-pc-linux-gnu'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_RELATIVE_PATH_0='x86_64'
CONTENT_GAME_BIN64_FILES='
SkullGirls.x86_64-pc-linux-gnu'
CONTENT_GAME_BIN32_RELATIVE_PATH_0='i686'
CONTENT_GAME_BIN32_FILES='
SkullGirls.i686-pc-linux-gnu'
CONTENT_GAME_DATA_RELATIVE_PATH_0='noarch'
CONTENT_GAME_DATA_FILES='
data01
Salmon
Icon.png
gamecontrollerdb.txt
ProgressionInit.txt'

APP_MAIN_EXE_BIN64='SkullGirls.x86_64-pc-linux-gnu'
APP_MAIN_EXE_BIN32='SkullGirls.i686-pc-linux-gnu'
APP_MAIN_ICON='Icon.png'
APP_MAIN_ICON_0='noarch/Icon.png'
## Trying to run the game with wayland SDL backend leads to a crash on launch:
## CRITICAL: Unable to create SDL Window
APP_MAIN_PRERUN='
# Prevent a crash on launch when wayland SDL backend is used.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
