/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.text;

import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfTextList
extends TextListElement {
    public OdfTextList(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTextList(OdfFileDom ownerDoc, String[] itemList, char indentDelim, String listStyleName) {
        super(ownerDoc);
        OdfTextList[] listArray = new OdfTextList[10];
        int level = 0;
        int lastLevel = 0;
        listArray[0] = this;
        for (int i = 0; i < itemList.length; ++i) {
            String item = itemList[i];
            for (level = 0; level < item.length() && item.charAt(level) == indentDelim; ++level) {
            }
            item = item.substring(level);
            if (level > lastLevel) {
                for (int lev = lastLevel + 1; lev <= level; ++lev) {
                    listArray[lev] = new OdfTextList(ownerDoc);
                    listArray[lev].setTextStyleNameAttribute(listStyleName);
                }
            } else if (level < lastLevel) {
                this.closeLevels(ownerDoc, listArray, lastLevel, level);
            }
            listArray[level].setTextStyleNameAttribute(listStyleName);
            TextListItemElement listItem = new TextListItemElement(ownerDoc);
            OdfTextParagraph para = new OdfTextParagraph(ownerDoc);
            para.setTextContent(item);
            listItem.appendChild(para);
            listArray[level].appendChild(listItem);
            lastLevel = level;
        }
        this.closeLevels(ownerDoc, listArray, lastLevel, 0);
    }

    private void closeLevels(OdfFileDom ownerDoc, OdfTextList[] listArray, int fromLevel, int toLevel) {
        for (int level = fromLevel; level > toLevel; --level) {
            if (!listArray[level - 1].hasChildNodes()) {
                listArray[level - 1].appendChild(new TextListItemElement(ownerDoc));
            }
            listArray[level - 1].getLastChild().appendChild(listArray[level]);
        }
    }

    public OdfTextListStyle getListStyle() {
        OdfTextListStyle style = null;
        String listName = this.getTextStyleNameAttribute();
        if (listName != null && listName.length() > 0) {
            OdfOfficeStyles styles;
            OdfFileDom fileDom = (OdfFileDom)this.ownerDocument;
            OdfOfficeAutomaticStyles autoStyles = null;
            if (fileDom instanceof OdfContentDom) {
                autoStyles = ((OdfContentDom)fileDom).getAutomaticStyles();
            } else if (fileDom instanceof OdfStylesDom) {
                autoStyles = ((OdfStylesDom)fileDom).getAutomaticStyles();
            }
            if (autoStyles != null) {
                style = autoStyles.getListStyle(listName);
            }
            if (style == null && (styles = ((OdfSchemaDocument)fileDom.getDocument()).getDocumentStyles()) != null) {
                style = styles.getListStyle(listName);
            }
        } else {
            OdfTextList parentList = this.getParentList();
            if (parentList != null) {
                style = parentList.getListStyle();
            }
        }
        return style;
    }

    public int getListLevel() {
        int level = 1;
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof TextListElement)) continue;
            ++level;
        }
        return level;
    }

    public TextListLevelStyleElementBase getListLevelStyle() {
        TextListLevelStyleElementBase odfListLevelStyle = null;
        OdfTextListStyle style = this.getListStyle();
        int level = this.getListLevel();
        if (style != null) {
            odfListLevelStyle = style.getLevel(level);
        } else {
            Logger.getLogger(OdfTextList.class.getName()).warning("No ListLevelStyle found!");
        }
        return odfListLevelStyle;
    }

    public OdfTextListStyle getOrCreateLocalListStyle() {
        OdfTextListStyle listStyle = this.getListStyle();
        if (listStyle == null) {
            OdfOfficeAutomaticStyles autoStyles = null;
            OdfFileDom fileDom = (OdfFileDom)this.ownerDocument;
            if (fileDom instanceof OdfContentDom) {
                autoStyles = ((OdfContentDom)fileDom).getOrCreateAutomaticStyles();
            } else if (fileDom instanceof OdfStylesDom) {
                autoStyles = ((OdfStylesDom)fileDom).getOrCreateAutomaticStyles();
            }
            if (autoStyles != null) {
                listStyle = autoStyles.newListStyle();
            }
        }
        return listStyle;
    }

    public OdfTextList getParentList() {
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof OdfTextList)) continue;
            return (OdfTextList)parent;
        }
        return null;
    }
}

