/* SPDX-License-Identifier: GPL-2.0+ */
/* Microchip Sparx5 Switch driver
 *
 * Copyright (c) 2024 Microchip Technology Inc.
 */

/* This file is autogenerated by cml-utils 2024-09-30 11:48:29 +0200.
 * Commit ID: 9d07b8d19363f3cd3590ddb3f7a2e2768e16524b
 */

#ifndef _SPARX5_REGS_H_
#define _SPARX5_REGS_H_

/* These enumerated values are used to index the platform specific structs
 * containing the addresses, counts, size and positions, of register groups,
 * registers and fields.
 */

enum sparx5_tsize_enum {
	TC_DEV10G,
	TC_DEV2G5,
	TC_DEV5G,
	TC_PCS10G_BR,
	TC_PCS5G_BR,
	TSIZE_LAST,
};

enum sparx5_raddr_enum {
	RA_CPU_PROC_CTRL,
	RA_GCB_SOFT_RST,
	RA_GCB_HW_SGPIO_TO_SD_MAP_CFG,
	RADDR_LAST,
};

enum sparx5_rcnt_enum {
	RC_ANA_AC_OWN_UPSID,
	RC_ANA_ACL_VCAP_S2_CFG,
	RC_ANA_ACL_OWN_UPSID,
	RC_ANA_CL_OWN_UPSID,
	RC_ANA_L2_OWN_UPSID,
	RC_ASM_PORT_CFG,
	RC_DSM_BUF_CFG,
	RC_DSM_DEV_TX_STOP_WM_CFG,
	RC_DSM_RX_PAUSE_CFG,
	RC_DSM_MAC_CFG,
	RC_DSM_MAC_ADDR_BASE_HIGH_CFG,
	RC_DSM_MAC_ADDR_BASE_LOW_CFG,
	RC_DSM_TAXI_CAL_CFG,
	RC_GCB_HW_SGPIO_TO_SD_MAP_CFG,
	RC_HSCH_PORT_MODE,
	RC_QFWD_SWITCH_PORT_MODE,
	RC_QSYS_PAUSE_CFG,
	RC_QSYS_ATOP,
	RC_QSYS_FWD_PRESSURE,
	RC_QSYS_CAL_AUTO,
	RC_REW_OWN_UPSID,
	RC_REW_RTAG_ETAG_CTRL,
	RCNT_LAST,
};

enum sparx5_gaddr_enum {
	GA_ANA_AC_RAM_CTRL,
	GA_ANA_AC_PS_COMMON,
	GA_ANA_AC_MIRROR_PROBE,
	GA_ANA_AC_SRC,
	GA_ANA_AC_PGID,
	GA_ANA_AC_TSN_SF,
	GA_ANA_AC_TSN_SF_CFG,
	GA_ANA_AC_TSN_SF_STATUS,
	GA_ANA_AC_SG_ACCESS,
	GA_ANA_AC_SG_CONFIG,
	GA_ANA_AC_SG_STATUS,
	GA_ANA_AC_SG_STATUS_STICKY,
	GA_ANA_AC_STAT_GLOBAL_CFG_PORT,
	GA_ANA_AC_STAT_CNT_CFG_PORT,
	GA_ANA_AC_STAT_GLOBAL_CFG_ACL,
	GA_ANA_ACL_COMMON,
	GA_ANA_ACL_KEY_SEL,
	GA_ANA_ACL_CNT_B,
	GA_ANA_ACL_STICKY,
	GA_ANA_AC_POL_POL_ALL_CFG,
	GA_ANA_AC_POL_COMMON_BDLB,
	GA_ANA_AC_POL_COMMON_BUM_SLB,
	GA_ANA_AC_SDLB_LBGRP_TBL,
	GA_ANA_CL_PORT,
	GA_ANA_CL_COMMON,
	GA_ANA_L2_COMMON,
	GA_ANA_L3_COMMON,
	GA_ANA_L3_VLAN_ARP_L3MC_STICKY,
	GA_ASM_CFG,
	GA_ASM_PFC_TIMER_CFG,
	GA_ASM_LBK_WM_CFG,
	GA_ASM_LBK_MISC_CFG,
	GA_ASM_RAM_CTRL,
	GA_EACL_ES2_KEY_SELECT_PROFILE,
	GA_EACL_CNT_TBL,
	GA_EACL_POL_CFG,
	GA_EACL_ES2_STICKY,
	GA_EACL_RAM_CTRL,
	GA_GCB_SIO_CTRL,
	GA_HSCH_HSCH_DWRR,
	GA_HSCH_HSCH_MISC,
	GA_HSCH_HSCH_LEAK_LISTS,
	GA_HSCH_SYSTEM,
	GA_HSCH_MMGT,
	GA_HSCH_TAS_CONFIG,
	GA_PTP_PTP_CFG,
	GA_PTP_PTP_TOD_DOMAINS,
	GA_PTP_PHASE_DETECTOR_CTRL,
	GA_QSYS_CALCFG,
	GA_QSYS_RAM_CTRL,
	GA_REW_COMMON,
	GA_REW_PORT,
	GA_REW_VOE_PORT_LM_CNT,
	GA_REW_RAM_CTRL,
	GA_VOP_RAM_CTRL,
	GA_XQS_SYSTEM,
	GA_XQS_QLIMIT_SHR,
	GADDR_LAST,
};

enum sparx5_gcnt_enum {
	GC_ANA_AC_SRC,
	GC_ANA_AC_PGID,
	GC_ANA_AC_TSN_SF_CFG,
	GC_ANA_AC_STAT_CNT_CFG_PORT,
	GC_ANA_ACL_KEY_SEL,
	GC_ANA_ACL_CNT_A,
	GC_ANA_ACL_CNT_B,
	GC_ANA_AC_SDLB_LBGRP_TBL,
	GC_ANA_AC_SDLB_LBSET_TBL,
	GC_ANA_CL_PORT,
	GC_ANA_L2_ISDX_LIMIT,
	GC_ANA_L2_ISDX,
	GC_ANA_L3_VLAN,
	GC_ASM_DEV_STATISTICS,
	GC_EACL_ES2_KEY_SELECT_PROFILE,
	GC_EACL_CNT_TBL,
	GC_GCB_SIO_CTRL,
	GC_HSCH_HSCH_CFG,
	GC_HSCH_HSCH_DWRR,
	GC_PTP_PTP_PINS,
	GC_PTP_PHASE_DETECTOR_CTRL,
	GC_REW_PORT,
	GC_REW_VOE_PORT_LM_CNT,
	GCNT_LAST,
};

enum sparx5_gsize_enum {
	GW_ANA_AC_SRC,
	GW_ANA_L2_COMMON,
	GW_ASM_CFG,
	GW_CPU_CPU_REGS,
	GW_DEV2G5_PHASE_DETECTOR_CTRL,
	GW_FDMA_FDMA,
	GW_GCB_CHIP_REGS,
	GW_HSCH_TAS_CONFIG,
	GW_PTP_PHASE_DETECTOR_CTRL,
	GW_QSYS_PAUSE_CFG,
	GSIZE_LAST,
};

enum sparx5_fpos_enum {
	FP_CPU_PROC_CTRL_AARCH64_MODE_ENA,
	FP_CPU_PROC_CTRL_L2_RST_INVALIDATE_DIS,
	FP_CPU_PROC_CTRL_L1_RST_INVALIDATE_DIS,
	FP_CPU_PROC_CTRL_BE_EXCEP_MODE,
	FP_CPU_PROC_CTRL_VINITHI,
	FP_CPU_PROC_CTRL_CFGTE,
	FP_CPU_PROC_CTRL_CP15S_DISABLE,
	FP_CPU_PROC_CTRL_PROC_CRYPTO_DISABLE,
	FP_CPU_PROC_CTRL_L2_FLUSH_REQ,
	FP_DEV2G5_PHAD_CTRL_PHAD_ENA,
	FP_DEV2G5_PHAD_CTRL_PHAD_FAILED,
	FP_FDMA_CH_CFG_CH_XTR_STATUS_MODE,
	FP_FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY,
	FP_FDMA_CH_CFG_CH_INJ_PORT,
	FP_PTP_PTP_PIN_CFG_PTP_PIN_ACTION,
	FP_PTP_PTP_PIN_CFG_PTP_PIN_SYNC,
	FP_PTP_PTP_PIN_CFG_PTP_PIN_INV_POL,
	FP_PTP_PHAD_CTRL_PHAD_ENA,
	FP_PTP_PHAD_CTRL_PHAD_FAILED,
	FPOS_LAST,
};

enum sparx5_fsize_enum {
	FW_ANA_AC_PROBE_PORT_CFG_PROBE_PORT_MASK,
	FW_ANA_AC_SRC_CFG_PORT_MASK,
	FW_ANA_AC_PGID_CFG_PORT_MASK,
	FW_ANA_AC_TSN_SF_PORT_NUM,
	FW_ANA_AC_TSN_SF_CFG_TSN_SGID,
	FW_ANA_AC_TSN_SF_STATUS_TSN_SFID,
	FW_ANA_AC_SG_ACCESS_CTRL_SGID,
	FW_ANA_AC_PORT_SGE_CFG_MASK,
	FW_ANA_AC_SDLB_XLB_START_LBSET_START,
	FW_ANA_AC_SDLB_LBGRP_MISC_THRES_SHIFT,
	FW_ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_LBSET_NEXT,
	FW_ANA_AC_SDLB_XLB_NEXT_LBSET_NEXT,
	FW_ANA_AC_SDLB_XLB_NEXT_LBGRP,
	FW_ANA_AC_SDLB_INH_LBSET_ADDR_INH_LBSET_ADDR,
	FW_ANA_L2_AUTO_LRN_CFG_AUTO_LRN_ENA,
	FW_ANA_L2_DLB_CFG_DLB_IDX,
	FW_ANA_L2_TSN_CFG_TSN_SFID,
	FW_ANA_L3_VLAN_MASK_CFG_VLAN_PORT_MASK,
	FW_FDMA_CH_CFG_CH_DCB_DB_CNT,
	FW_GCB_HW_SGPIO_TO_SD_MAP_CFG_SGPIO_TO_SD_SEL,
	FW_HSCH_SE_CFG_SE_DWRR_CNT,
	FW_HSCH_SE_CONNECT_SE_LEAK_LINK,
	FW_HSCH_SE_DLB_SENSE_SE_DLB_DPORT,
	FW_HSCH_HSCH_CFG_CFG_CFG_SE_IDX,
	FW_HSCH_HSCH_LEAK_CFG_LEAK_FIRST,
	FW_HSCH_FLUSH_CTRL_FLUSH_PORT,
	FW_HSCH_FLUSH_CTRL_FLUSH_HIER,
	FW_LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_ROW,
	FW_LRN_MAC_ACCESS_CFG_3_MAC_ENTRY_ISDX_LIMIT_IDX,
	FW_LRN_AUTOAGE_CFG_2_NEXT_ROW,
	FW_PTP_PTP_PIN_INTR_INTR_PTP,
	FW_PTP_PTP_PIN_INTR_ENA_INTR_PTP_ENA,
	FW_PTP_PTP_INTR_IDENT_INTR_PTP_IDENT,
	FW_PTP_PTP_PIN_CFG_PTP_PIN_SELECT,
	FW_QFWD_FRAME_COPY_CFG_FRMC_PORT_VAL,
	FW_QRES_RES_CFG_WM_HIGH,
	FW_QRES_RES_STAT_MAXUSE,
	FW_QRES_RES_STAT_CUR_INUSE,
	FW_QSYS_PAUSE_CFG_PAUSE_START,
	FW_QSYS_PAUSE_CFG_PAUSE_STOP,
	FW_QSYS_ATOP_ATOP,
	FW_QSYS_ATOP_TOT_CFG_ATOP_TOT,
	FW_REW_RTAG_ETAG_CTRL_IPE_TBL,
	FW_XQS_STAT_CFG_STAT_VIEW,
	FW_XQS_QLIMIT_SHR_TOP_CFG_QLIMIT_SHR_TOP,
	FW_XQS_QLIMIT_SHR_ATOP_CFG_QLIMIT_SHR_ATOP,
	FW_XQS_QLIMIT_SHR_CTOP_CFG_QLIMIT_SHR_CTOP,
	FW_XQS_QLIMIT_SHR_QLIM_CFG_QLIMIT_SHR_QLIM,
	FSIZE_LAST,
};

extern const unsigned int sparx5_tsize[TSIZE_LAST];
extern const unsigned int sparx5_raddr[RADDR_LAST];
extern const unsigned int sparx5_rcnt[RCNT_LAST];
extern const unsigned int sparx5_gaddr[GADDR_LAST];
extern const unsigned int sparx5_gcnt[GCNT_LAST];
extern const unsigned int sparx5_gsize[GSIZE_LAST];
extern const unsigned int sparx5_fpos[FPOS_LAST];
extern const unsigned int sparx5_fsize[FSIZE_LAST];

#endif /* _SPARX5_REGS_H_ */
