# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module DlpV2beta1
      
      class GoogleLongrunningCancelOperationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleLongrunningListOperationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleLongrunningOperation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1AnalyzeDataSourceRiskRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1AuxiliaryTable
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1BigQueryOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1BigQueryTable
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Bucket
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1BucketingConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CategoricalStatsConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CategoricalStatsHistogramBucket
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CategoricalStatsResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CategoryDescription
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CharacterMaskConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CharsToIgnore
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CloudStorageKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CloudStorageOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CloudStoragePath
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Color
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Condition
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Conditions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ContentItem
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CreateInspectOperationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CryptoHashConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CryptoKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CryptoReplaceFfxFpeConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1CustomInfoType
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1DatastoreKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1DatastoreOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1DeidentificationSummary
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1DeidentifyConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1DeidentifyContentRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1DeidentifyContentResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Dictionary
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1EntityId
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Expressions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1FieldId
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1FieldTransformation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1FileSet
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Finding
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1FixedSizeBucketingConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ImageLocation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ImageRedactionConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InfoType
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeDescription
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeLimit
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeStatistics
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeTransformation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeTransformations
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InspectConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InspectContentRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InspectContentResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InspectOperationMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InspectOperationResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1InspectResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityEquivalenceClass
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityHistogramBucket
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationHistogramBucket
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationQuasiIdValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Key
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KindExpression
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1KmsWrappedCryptoKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1LDiversityConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1LDiversityEquivalenceClass
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1LDiversityHistogramBucket
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1LDiversityResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ListInfoTypesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ListInspectFindingsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ListRootCategoriesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Location
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1NumericalStatsConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1NumericalStatsResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1OperationConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1OutputStorageConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1PartitionId
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1PathElement
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1PrimitiveTransformation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1PrivacyMetric
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Projection
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1PropertyReference
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1QuasiIdField
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Range
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RecordCondition
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RecordKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RecordSuppression
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RecordTransformations
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RedactConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RedactContentRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RedactContentResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ReplaceConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ReplaceValueConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ReplaceWithInfoTypeConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RiskAnalysisOperationMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1RiskAnalysisOperationResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Row
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1StorageConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1SummaryResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1SurrogateType
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Table
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1TableLocation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1TaggedField
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1TimePartConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1TransformationSummary
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1TransientCryptoKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1UnwrappedCryptoKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1Value
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1ValueFrequency
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GooglePrivacyDlpV2beta1WordList
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleProtobufEmpty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleRpcStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleTypeDate
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleTypeTimeOfDay
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleLongrunningCancelOperationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GoogleLongrunningListOperationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :operations, as: 'operations', class: Google::Apis::DlpV2beta1::GoogleLongrunningOperation, decorator: Google::Apis::DlpV2beta1::GoogleLongrunningOperation::Representation
      
        end
      end
      
      class GoogleLongrunningOperation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :done, as: 'done'
          property :error, as: 'error', class: Google::Apis::DlpV2beta1::GoogleRpcStatus, decorator: Google::Apis::DlpV2beta1::GoogleRpcStatus::Representation
      
          hash :metadata, as: 'metadata'
          property :name, as: 'name'
          hash :response, as: 'response'
        end
      end
      
      class GooglePrivacyDlpV2beta1AnalyzeDataSourceRiskRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :privacy_metric, as: 'privacyMetric', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrivacyMetric, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrivacyMetric::Representation
      
          property :source_table, as: 'sourceTable', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1AuxiliaryTable
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :quasi_ids, as: 'quasiIds', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1QuasiIdField, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1QuasiIdField::Representation
      
          property :relative_frequency, as: 'relativeFrequency', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :table, as: 'table', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1BigQueryOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :identifying_fields, as: 'identifyingFields', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :table_reference, as: 'tableReference', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1BigQueryTable
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :dataset_id, as: 'datasetId'
          property :project_id, as: 'projectId'
          property :table_id, as: 'tableId'
        end
      end
      
      class GooglePrivacyDlpV2beta1Bucket
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :max, as: 'max', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
          property :min, as: 'min', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
          property :replacement_value, as: 'replacementValue', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1BucketingConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :buckets, as: 'buckets', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Bucket, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Bucket::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CategoricalStatsConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CategoricalStatsHistogramBucket
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_size, :numeric_string => true, as: 'bucketSize'
          collection :bucket_values, as: 'bucketValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ValueFrequency, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ValueFrequency::Representation
      
          property :value_frequency_lower_bound, :numeric_string => true, as: 'valueFrequencyLowerBound'
          property :value_frequency_upper_bound, :numeric_string => true, as: 'valueFrequencyUpperBound'
        end
      end
      
      class GooglePrivacyDlpV2beta1CategoricalStatsResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :value_frequency_histogram_buckets, as: 'valueFrequencyHistogramBuckets', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoricalStatsHistogramBucket, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoricalStatsHistogramBucket::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CategoryDescription
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_name, as: 'displayName'
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1CharacterMaskConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :characters_to_ignore, as: 'charactersToIgnore', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CharsToIgnore, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CharsToIgnore::Representation
      
          property :masking_character, as: 'maskingCharacter'
          property :number_to_mask, as: 'numberToMask'
          property :reverse_order, as: 'reverseOrder'
        end
      end
      
      class GooglePrivacyDlpV2beta1CharsToIgnore
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :characters_to_skip, as: 'charactersToSkip'
          property :common_characters_to_ignore, as: 'commonCharactersToIgnore'
        end
      end
      
      class GooglePrivacyDlpV2beta1CloudStorageKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :file_path, as: 'filePath'
          property :start_offset, :numeric_string => true, as: 'startOffset'
        end
      end
      
      class GooglePrivacyDlpV2beta1CloudStorageOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :file_set, as: 'fileSet', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FileSet, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FileSet::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CloudStoragePath
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :path, as: 'path'
        end
      end
      
      class GooglePrivacyDlpV2beta1Color
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :blue, as: 'blue'
          property :green, as: 'green'
          property :red, as: 'red'
        end
      end
      
      class GooglePrivacyDlpV2beta1Condition
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :operator, as: 'operator'
          property :value, as: 'value', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Conditions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :conditions, as: 'conditions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Condition, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Condition::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ContentItem
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :data, :base64 => true, as: 'data'
          property :table, as: 'table', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Table, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Table::Representation
      
          property :type, as: 'type'
          property :value, as: 'value'
        end
      end
      
      class GooglePrivacyDlpV2beta1CreateInspectOperationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :inspect_config, as: 'inspectConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig::Representation
      
          property :operation_config, as: 'operationConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1OperationConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1OperationConfig::Representation
      
          property :output_config, as: 'outputConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1OutputStorageConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1OutputStorageConfig::Representation
      
          property :storage_config, as: 'storageConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1StorageConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1StorageConfig::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CryptoHashConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :crypto_key, as: 'cryptoKey', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoKey::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CryptoKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :kms_wrapped, as: 'kmsWrapped', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KmsWrappedCryptoKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KmsWrappedCryptoKey::Representation
      
          property :transient, as: 'transient', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TransientCryptoKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TransientCryptoKey::Representation
      
          property :unwrapped, as: 'unwrapped', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1UnwrappedCryptoKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1UnwrappedCryptoKey::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CryptoReplaceFfxFpeConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :common_alphabet, as: 'commonAlphabet'
          property :context, as: 'context', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :crypto_key, as: 'cryptoKey', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoKey::Representation
      
          property :custom_alphabet, as: 'customAlphabet'
          property :radix, as: 'radix'
          property :surrogate_info_type, as: 'surrogateInfoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1CustomInfoType
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :dictionary, as: 'dictionary', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Dictionary, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Dictionary::Representation
      
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :surrogate_type, as: 'surrogateType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1SurrogateType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1SurrogateType::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1DatastoreKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :entity_key, as: 'entityKey', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Key, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Key::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1DatastoreOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :kind, as: 'kind', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KindExpression, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KindExpression::Representation
      
          property :partition_id, as: 'partitionId', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PartitionId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PartitionId::Representation
      
          collection :projection, as: 'projection', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Projection, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Projection::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1DeidentificationSummary
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :transformation_summaries, as: 'transformationSummaries', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TransformationSummary, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TransformationSummary::Representation
      
          property :transformed_bytes, :numeric_string => true, as: 'transformedBytes'
        end
      end
      
      class GooglePrivacyDlpV2beta1DeidentifyConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :info_type_transformations, as: 'infoTypeTransformations', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeTransformations, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeTransformations::Representation
      
          property :record_transformations, as: 'recordTransformations', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordTransformations, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordTransformations::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1DeidentifyContentRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :deidentify_config, as: 'deidentifyConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DeidentifyConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DeidentifyConfig::Representation
      
          property :inspect_config, as: 'inspectConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig::Representation
      
          collection :items, as: 'items', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1DeidentifyContentResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :items, as: 'items', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem::Representation
      
          collection :summaries, as: 'summaries', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DeidentificationSummary, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DeidentificationSummary::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Dictionary
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :word_list, as: 'wordList', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1WordList, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1WordList::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1EntityId
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Expressions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :conditions, as: 'conditions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Conditions, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Conditions::Representation
      
          property :logical_operator, as: 'logicalOperator'
        end
      end
      
      class GooglePrivacyDlpV2beta1FieldId
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :column_name, as: 'columnName'
        end
      end
      
      class GooglePrivacyDlpV2beta1FieldTransformation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :condition, as: 'condition', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordCondition, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordCondition::Representation
      
          collection :fields, as: 'fields', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :info_type_transformations, as: 'infoTypeTransformations', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeTransformations, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeTransformations::Representation
      
          property :primitive_transformation, as: 'primitiveTransformation', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrimitiveTransformation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrimitiveTransformation::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1FileSet
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :url, as: 'url'
        end
      end
      
      class GooglePrivacyDlpV2beta1Finding
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :likelihood, as: 'likelihood'
          property :location, as: 'location', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Location, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Location::Representation
      
          property :quote, as: 'quote'
        end
      end
      
      class GooglePrivacyDlpV2beta1FixedSizeBucketingConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_size, as: 'bucketSize'
          property :lower_bound, as: 'lowerBound', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
          property :upper_bound, as: 'upperBound', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ImageLocation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :height, as: 'height'
          property :left, as: 'left'
          property :top, as: 'top'
          property :width, as: 'width'
        end
      end
      
      class GooglePrivacyDlpV2beta1ImageRedactionConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :redact_all_text, as: 'redactAllText'
          property :redaction_color, as: 'redactionColor', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Color, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Color::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1InfoType
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeDescription
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :categories, as: 'categories', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoryDescription, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoryDescription::Representation
      
          property :display_name, as: 'displayName'
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeLimit
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :max_findings, as: 'maxFindings'
        end
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeStatistics
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :count, :numeric_string => true, as: 'count'
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeTransformation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :info_types, as: 'infoTypes', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :primitive_transformation, as: 'primitiveTransformation', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrimitiveTransformation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrimitiveTransformation::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1InfoTypeTransformations
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :transformations, as: 'transformations', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeTransformation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeTransformation::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1InspectConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :custom_info_types, as: 'customInfoTypes', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CustomInfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CustomInfoType::Representation
      
          property :exclude_types, as: 'excludeTypes'
          property :include_quote, as: 'includeQuote'
          collection :info_type_limits, as: 'infoTypeLimits', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeLimit, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeLimit::Representation
      
          collection :info_types, as: 'infoTypes', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :max_findings, as: 'maxFindings'
          property :min_likelihood, as: 'minLikelihood'
        end
      end
      
      class GooglePrivacyDlpV2beta1InspectContentRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :inspect_config, as: 'inspectConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig::Representation
      
          collection :items, as: 'items', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1InspectContentResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :results, as: 'results', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectResult::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1InspectOperationMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          collection :info_type_stats, as: 'infoTypeStats', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeStatistics, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeStatistics::Representation
      
          property :processed_bytes, :numeric_string => true, as: 'processedBytes'
          property :request_inspect_config, as: 'requestInspectConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig::Representation
      
          property :request_output_config, as: 'requestOutputConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1OutputStorageConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1OutputStorageConfig::Representation
      
          property :request_storage_config, as: 'requestStorageConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1StorageConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1StorageConfig::Representation
      
          property :total_estimated_bytes, :numeric_string => true, as: 'totalEstimatedBytes'
        end
      end
      
      class GooglePrivacyDlpV2beta1InspectOperationResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1InspectResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :findings, as: 'findings', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Finding, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Finding::Representation
      
          property :findings_truncated, as: 'findingsTruncated'
        end
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :entity_id, as: 'entityId', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1EntityId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1EntityId::Representation
      
          collection :quasi_ids, as: 'quasiIds', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityEquivalenceClass
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :equivalence_class_size, :numeric_string => true, as: 'equivalenceClassSize'
          collection :quasi_ids_values, as: 'quasiIdsValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityHistogramBucket
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_size, :numeric_string => true, as: 'bucketSize'
          collection :bucket_values, as: 'bucketValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityEquivalenceClass, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityEquivalenceClass::Representation
      
          property :equivalence_class_size_lower_bound, :numeric_string => true, as: 'equivalenceClassSizeLowerBound'
          property :equivalence_class_size_upper_bound, :numeric_string => true, as: 'equivalenceClassSizeUpperBound'
        end
      end
      
      class GooglePrivacyDlpV2beta1KAnonymityResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :equivalence_class_histogram_buckets, as: 'equivalenceClassHistogramBuckets', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityHistogramBucket, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityHistogramBucket::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :auxiliary_tables, as: 'auxiliaryTables', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1AuxiliaryTable, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1AuxiliaryTable::Representation
      
          collection :quasi_ids, as: 'quasiIds', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TaggedField, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TaggedField::Representation
      
          property :region_code, as: 'regionCode'
        end
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationHistogramBucket
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_size, :numeric_string => true, as: 'bucketSize'
          collection :bucket_values, as: 'bucketValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationQuasiIdValues, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationQuasiIdValues::Representation
      
          property :max_anonymity, :numeric_string => true, as: 'maxAnonymity'
          property :min_anonymity, :numeric_string => true, as: 'minAnonymity'
        end
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationQuasiIdValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :estimated_anonymity, :numeric_string => true, as: 'estimatedAnonymity'
          collection :quasi_ids_values, as: 'quasiIdsValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1KMapEstimationResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :k_map_estimation_histogram, as: 'kMapEstimationHistogram', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationHistogramBucket, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationHistogramBucket::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Key
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :partition_id, as: 'partitionId', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PartitionId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PartitionId::Representation
      
          collection :path, as: 'path', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PathElement, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PathElement::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1KindExpression
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1KmsWrappedCryptoKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :crypto_key_name, as: 'cryptoKeyName'
          property :wrapped_key, :base64 => true, as: 'wrappedKey'
        end
      end
      
      class GooglePrivacyDlpV2beta1LDiversityConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :quasi_ids, as: 'quasiIds', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :sensitive_attribute, as: 'sensitiveAttribute', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1LDiversityEquivalenceClass
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :equivalence_class_size, :numeric_string => true, as: 'equivalenceClassSize'
          property :num_distinct_sensitive_values, :numeric_string => true, as: 'numDistinctSensitiveValues'
          collection :quasi_ids_values, as: 'quasiIdsValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
          collection :top_sensitive_values, as: 'topSensitiveValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ValueFrequency, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ValueFrequency::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1LDiversityHistogramBucket
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_size, :numeric_string => true, as: 'bucketSize'
          collection :bucket_values, as: 'bucketValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityEquivalenceClass, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityEquivalenceClass::Representation
      
          property :sensitive_value_frequency_lower_bound, :numeric_string => true, as: 'sensitiveValueFrequencyLowerBound'
          property :sensitive_value_frequency_upper_bound, :numeric_string => true, as: 'sensitiveValueFrequencyUpperBound'
        end
      end
      
      class GooglePrivacyDlpV2beta1LDiversityResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :sensitive_value_frequency_histogram_buckets, as: 'sensitiveValueFrequencyHistogramBuckets', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityHistogramBucket, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityHistogramBucket::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ListInfoTypesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :info_types, as: 'infoTypes', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeDescription, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoTypeDescription::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ListInspectFindingsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          property :result, as: 'result', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectResult::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ListRootCategoriesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :categories, as: 'categories', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoryDescription, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoryDescription::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Location
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :byte_range, as: 'byteRange', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Range, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Range::Representation
      
          property :codepoint_range, as: 'codepointRange', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Range, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Range::Representation
      
          property :field_id, as: 'fieldId', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          collection :image_boxes, as: 'imageBoxes', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ImageLocation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ImageLocation::Representation
      
          property :record_key, as: 'recordKey', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordKey::Representation
      
          property :table_location, as: 'tableLocation', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TableLocation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TableLocation::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1NumericalStatsConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1NumericalStatsResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :max_value, as: 'maxValue', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
          property :min_value, as: 'minValue', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
          collection :quantile_values, as: 'quantileValues', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1OperationConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :max_item_findings, :numeric_string => true, as: 'maxItemFindings'
        end
      end
      
      class GooglePrivacyDlpV2beta1OutputStorageConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :storage_path, as: 'storagePath', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CloudStoragePath, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CloudStoragePath::Representation
      
          property :table, as: 'table', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1PartitionId
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :namespace_id, as: 'namespaceId'
          property :project_id, as: 'projectId'
        end
      end
      
      class GooglePrivacyDlpV2beta1PathElement
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :id, :numeric_string => true, as: 'id'
          property :kind, as: 'kind'
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1PrimitiveTransformation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucketing_config, as: 'bucketingConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BucketingConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BucketingConfig::Representation
      
          property :character_mask_config, as: 'characterMaskConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CharacterMaskConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CharacterMaskConfig::Representation
      
          property :crypto_hash_config, as: 'cryptoHashConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoHashConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoHashConfig::Representation
      
          property :crypto_replace_ffx_fpe_config, as: 'cryptoReplaceFfxFpeConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoReplaceFfxFpeConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CryptoReplaceFfxFpeConfig::Representation
      
          property :fixed_size_bucketing_config, as: 'fixedSizeBucketingConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FixedSizeBucketingConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FixedSizeBucketingConfig::Representation
      
          property :redact_config, as: 'redactConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RedactConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RedactConfig::Representation
      
          property :replace_config, as: 'replaceConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ReplaceValueConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ReplaceValueConfig::Representation
      
          property :replace_with_info_type_config, as: 'replaceWithInfoTypeConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ReplaceWithInfoTypeConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ReplaceWithInfoTypeConfig::Representation
      
          property :time_part_config, as: 'timePartConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TimePartConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1TimePartConfig::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1PrivacyMetric
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :categorical_stats_config, as: 'categoricalStatsConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoricalStatsConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoricalStatsConfig::Representation
      
          property :k_anonymity_config, as: 'kAnonymityConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityConfig::Representation
      
          property :k_map_estimation_config, as: 'kMapEstimationConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationConfig::Representation
      
          property :l_diversity_config, as: 'lDiversityConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityConfig::Representation
      
          property :numerical_stats_config, as: 'numericalStatsConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1NumericalStatsConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1NumericalStatsConfig::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Projection
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :property, as: 'property', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PropertyReference, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PropertyReference::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1PropertyReference
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1QuasiIdField
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :custom_tag, as: 'customTag'
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Range
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end, :numeric_string => true, as: 'end'
          property :start, :numeric_string => true, as: 'start'
        end
      end
      
      class GooglePrivacyDlpV2beta1RecordCondition
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :expressions, as: 'expressions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Expressions, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Expressions::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1RecordKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :cloud_storage_key, as: 'cloudStorageKey', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CloudStorageKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CloudStorageKey::Representation
      
          property :datastore_key, as: 'datastoreKey', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DatastoreKey, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DatastoreKey::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1RecordSuppression
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :condition, as: 'condition', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordCondition, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordCondition::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1RecordTransformations
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :field_transformations, as: 'fieldTransformations', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldTransformation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldTransformation::Representation
      
          collection :record_suppressions, as: 'recordSuppressions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordSuppression, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordSuppression::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1RedactConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GooglePrivacyDlpV2beta1RedactContentRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :image_redaction_configs, as: 'imageRedactionConfigs', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ImageRedactionConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ImageRedactionConfig::Representation
      
          property :inspect_config, as: 'inspectConfig', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InspectConfig::Representation
      
          collection :items, as: 'items', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem::Representation
      
          collection :replace_configs, as: 'replaceConfigs', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ReplaceConfig, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ReplaceConfig::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1RedactContentResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :items, as: 'items', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1ContentItem::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ReplaceConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :replace_with, as: 'replaceWith'
        end
      end
      
      class GooglePrivacyDlpV2beta1ReplaceValueConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :new_value, as: 'newValue', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1ReplaceWithInfoTypeConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GooglePrivacyDlpV2beta1RiskAnalysisOperationMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          property :requested_privacy_metric, as: 'requestedPrivacyMetric', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrivacyMetric, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrivacyMetric::Representation
      
          property :requested_source_table, as: 'requestedSourceTable', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryTable::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1RiskAnalysisOperationResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :categorical_stats_result, as: 'categoricalStatsResult', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoricalStatsResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CategoricalStatsResult::Representation
      
          property :k_anonymity_result, as: 'kAnonymityResult', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KAnonymityResult::Representation
      
          property :k_map_estimation_result, as: 'kMapEstimationResult', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1KMapEstimationResult::Representation
      
          property :l_diversity_result, as: 'lDiversityResult', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1LDiversityResult::Representation
      
          property :numerical_stats_result, as: 'numericalStatsResult', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1NumericalStatsResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1NumericalStatsResult::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1Row
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1StorageConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :big_query_options, as: 'bigQueryOptions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryOptions, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1BigQueryOptions::Representation
      
          property :cloud_storage_options, as: 'cloudStorageOptions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CloudStorageOptions, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1CloudStorageOptions::Representation
      
          property :datastore_options, as: 'datastoreOptions', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DatastoreOptions, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1DatastoreOptions::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1SummaryResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          property :count, :numeric_string => true, as: 'count'
          property :details, as: 'details'
        end
      end
      
      class GooglePrivacyDlpV2beta1SurrogateType
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GooglePrivacyDlpV2beta1Table
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :headers, as: 'headers', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          collection :rows, as: 'rows', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Row, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Row::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1TableLocation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :row_index, :numeric_string => true, as: 'rowIndex'
        end
      end
      
      class GooglePrivacyDlpV2beta1TaggedField
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :custom_tag, as: 'customTag'
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          property :inferred, as: 'inferred', class: Google::Apis::DlpV2beta1::GoogleProtobufEmpty, decorator: Google::Apis::DlpV2beta1::GoogleProtobufEmpty::Representation
      
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1TimePartConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :part_to_extract, as: 'partToExtract'
        end
      end
      
      class GooglePrivacyDlpV2beta1TransformationSummary
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :field, as: 'field', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldId::Representation
      
          collection :field_transformations, as: 'fieldTransformations', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldTransformation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1FieldTransformation::Representation
      
          property :info_type, as: 'infoType', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1InfoType::Representation
      
          property :record_suppress, as: 'recordSuppress', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordSuppression, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1RecordSuppression::Representation
      
          collection :results, as: 'results', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1SummaryResult, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1SummaryResult::Representation
      
          property :transformation, as: 'transformation', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrimitiveTransformation, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1PrimitiveTransformation::Representation
      
          property :transformed_bytes, :numeric_string => true, as: 'transformedBytes'
        end
      end
      
      class GooglePrivacyDlpV2beta1TransientCryptoKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class GooglePrivacyDlpV2beta1UnwrappedCryptoKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :key, :base64 => true, as: 'key'
        end
      end
      
      class GooglePrivacyDlpV2beta1Value
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :boolean_value, as: 'booleanValue'
          property :date_value, as: 'dateValue', class: Google::Apis::DlpV2beta1::GoogleTypeDate, decorator: Google::Apis::DlpV2beta1::GoogleTypeDate::Representation
      
          property :float_value, as: 'floatValue'
          property :integer_value, :numeric_string => true, as: 'integerValue'
          property :string_value, as: 'stringValue'
          property :time_value, as: 'timeValue', class: Google::Apis::DlpV2beta1::GoogleTypeTimeOfDay, decorator: Google::Apis::DlpV2beta1::GoogleTypeTimeOfDay::Representation
      
          property :timestamp_value, as: 'timestampValue'
        end
      end
      
      class GooglePrivacyDlpV2beta1ValueFrequency
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :count, :numeric_string => true, as: 'count'
          property :value, as: 'value', class: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value, decorator: Google::Apis::DlpV2beta1::GooglePrivacyDlpV2beta1Value::Representation
      
        end
      end
      
      class GooglePrivacyDlpV2beta1WordList
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :words, as: 'words'
        end
      end
      
      class GoogleProtobufEmpty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GoogleRpcStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          collection :details, as: 'details'
          property :message, as: 'message'
        end
      end
      
      class GoogleTypeDate
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :day, as: 'day'
          property :month, as: 'month'
          property :year, as: 'year'
        end
      end
      
      class GoogleTypeTimeOfDay
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :hours, as: 'hours'
          property :minutes, as: 'minutes'
          property :nanos, as: 'nanos'
          property :seconds, as: 'seconds'
        end
      end
    end
  end
end
