# Announce: Rakudo Perl 6 compiler, Development Release #72 ("Plano")

On behalf of the Rakudo development team, I'm happy to announce the
January 2014 release of Rakudo Perl #72 "Plano". Rakudo is an
implementation of Perl 6 on the Parrot Virtual Machine, the Java Virtual
Machine and the Moar Virtual Machine[^1]. The tarball for this release 
is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it's announcing a new release of the compiler
only.  For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. The January 2014 release is
code-named after Plano, because that suggestion was way better than
"Three Blind Mice".

    <masak> hm, so what should we name this release...
    <PerlJam> Fred
    <TimToady> Three Musketeers
    <TimToady> Three Stooges
    <TimToady> Three Blind Mice
    <TimToady> Three Little Pigs
    ...
    <TimToady> maybe we should name it Plano because that implies at least three dimensions
    <jnthn> oooh!
    <PerlJam> +1
    <jnthn> TimToady++

Some of the changes in this release are outlined below:

+ `Numeric.narrow` to coerce to narrowest type possible
+ Can now supply blocks with multiple arguments as sequence endpoints
+ The `eval` sub and method are now spelled `EVAL`
+ Method calls and hash/list access on `Nil` give `Nil`
+ Added support for MoarVM; passes >99% of the spectests that Rakudo JVM does
+ Implement more parts of `NativeCall` for the JVM
+ Fixed gather/take stack overflow bug in JVM backend

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite and the specification.

The following people contributed to this release:

Jonathan Worthington, Tobias Leich, Timo Paulssen, Moritz Lenz, Will "Coke"
Coleda, Brian Gernhardt, Carl Masak, Rob Hoelz, Geoffrey Broadwell, Kevan
Benson, Solomon Foster, grondilu, diakopter, Elizabeth Mattijsen, Mouq,
Jonathan Scott Duff, Tadeusz Sośnierz, lue

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC
\#perl6 on freenode.

The next release of Rakudo (#73), is scheduled for February 20, 2014.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

On behalf of the development team, I encourage you to enjoy the new release,
try awesome stuff, and get back to us with feedback.

[^1]: See <http://6guts.wordpress.com/2013/05/31/moarvm-a-virtual-machine-for-nqp-and-rakudo/>
and <http://moarvm.org/>

[^2]: What's the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Nothing else.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the "Using Perl 6" book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what's possible with
Rakudo Perl 6 and provide feedback on what works, what doesn't, and
what else they would like to see included in the distribution.
