% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_xml_document.R
\name{as_xml_document}
\alias{as_xml_document}
\title{Coerce a R list to xml nodes.}
\usage{
as_xml_document(x, ...)
}
\arguments{
\item{x}{A document, node, or node set.}

\item{...}{Needed for compatibility with generic. Unused.}
}
\description{
This turns an R list into the equivalent XML document. Not all R lists will
produce valid XML, in particular there can only be one root node and all
child nodes need to be named (or empty) lists. R attributes become XML
attributes and R names become XML node names.
}
\examples{
as_xml_document(list(x = list()))

# Nesting multiple nodes
as_xml_document(list(foo = list(bar = list(baz = list()))))

# attributes are stored as R attributes
as_xml_document(list(foo = structure(list(), id = "a")))
as_xml_document(list(foo = list(
     bar = structure(list(), id = "a"),
     bar = structure(list(), id = "b"))))
}
