% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{keep_units}
\alias{keep_units}
\title{Apply a function keeping units}
\usage{
keep_units(FUN, x, ..., unit = units(x))
}
\arguments{
\item{FUN}{the function to be applied.}

\item{x}{first argument of \code{FUN}, of class \code{units}.}

\item{...}{optional arguments to \code{FUN}.}

\item{unit}{symbolic unit to restore after \code{FUN}.}
}
\value{
An object of class \code{units}.
}
\description{
Helper function to apply a function to a \code{units} object and then restore
the original units.
}
\details{
Provided for incompatible functions that do not preserve units. The user is
responsible for ensuring the correctness of the output.
}
\examples{
x <- set_units(1:5, m)
keep_units(drop_units, x)

}
