# .x must be the same size as .i

    Code
      (expect_error(slide_index(1, 1:2, identity), class = "slider_error_index_incompatible_size")
      )
    Output
      <error/slider_error_index_incompatible_size>
      Error in `slide_index()`:
      ! `.i` must have size 1, not 2.

# .i must be ascending

    Code
      (expect_error(slide_index(1:2, 2:1, identity), class = "slider_error_index_must_be_ascending")
      )
    Output
      <error/slider_error_index_must_be_ascending>
      Error in `slide_index()`:
      i In locations: 2
      ! `.i` must be in ascending order.

# empty input returns a list, but after the index size check

    Code
      (expect_error(slide_index(integer(), 1, ~.x), class = "slider_error_index_incompatible_size")
      )
    Output
      <error/slider_error_index_incompatible_size>
      Error in `slide_index()`:
      ! `.i` must have size 0, not 1.

# .i must not contain NA values

    Code
      (expect_error(slide_index(1:2, c(NA, 1), identity), class = "slider_error_index_cannot_be_na")
      )
    Output
      <error/slider_error_index_cannot_be_na>
      Error in `slide_index()`:
      i In locations: 1
      ! `.i` can't be `NA`.

# .before must be size 1

    Code
      (expect_error(slide_index(1, 1, identity, .before = c(1L, 2L)), class = "vctrs_error_assert_size")
      )
    Output
      <error/vctrs_error_assert_size>
      Error in `slide_index()`:
      ! `.before` must have size 1, not size 2.

# error if .before is NULL

    Code
      (expect_error(slide_index(1, 1, identity, .before = NULL), class = "vctrs_error_scalar_type")
      )
    Output
      <error/vctrs_error_scalar_type>
      Error in `slide_index()`:
      ! `.before` must be a vector, not `NULL`.

# negative .before errors if its absolute value is past .after

    Code
      slide_index(x, i, identity, .before = -1, .after = 0)
    Condition
      Error:
      i In locations: 1, 2, 3, and 4
      i In the ranges generated by `.before` and `.after`:
      ! The start of the range can't be after the end of the range.

# errors if negative .before Duration is further than .after

    Code
      slide_index(x, i, identity, .before = -lubridate::ddays(1), .after = 0)
    Condition
      Error:
      i In locations: 1, 2, 3, and 4
      i In the ranges generated by `.before` and `.after`:
      ! The start of the range can't be after the end of the range.

# can generally use (tricky!) month Periods with Dates

    Code
      (expect_error(slide_index(x, i, identity, .before = months(1)), class = "slider_error_generated_endpoints_cannot_be_na")
      )
    Output
      <error/slider_error_generated_endpoints_cannot_be_na>
      Error in `slide_index()`:
      i In locations: 1
      ! Endpoints generated by `.before` can't be `NA`.

---

    Code
      (expect_error(slide_index(x, i, identity, .after = months(1)), class = "slider_error_generated_endpoints_cannot_be_na")
      )
    Output
      <error/slider_error_generated_endpoints_cannot_be_na>
      Error in `slide_index()`:
      i In locations: 4
      ! Endpoints generated by `.after` can't be `NA`.

# .after must be size 1

    Code
      (expect_error(slide_index(1, 1, identity, .after = c(1L, 2L)), class = "vctrs_error_assert_size")
      )
    Output
      <error/vctrs_error_assert_size>
      Error in `slide_index()`:
      ! `.after` must have size 1, not size 2.

# error if .after is NULL

    Code
      (expect_error(slide_index(1, 1, identity, .after = NULL), class = "vctrs_error_scalar_type")
      )
    Output
      <error/vctrs_error_scalar_type>
      Error in `slide_index()`:
      ! `.after` must be a vector, not `NULL`.

# negative .after errors if its absolute value is past .before

    Code
      slide_index(x, i, identity, .after = -1, .before = 0)
    Condition
      Error:
      i In locations: 1, 2, 3, and 4
      i In the ranges generated by `.before` and `.after`:
      ! The start of the range can't be after the end of the range.

# .before/.after - generated endpoints must be in weakly ascending order

    Code
      (expect_error(slide_index(x, x, identity, .before = ~ .x - c(2, 4)), class = "slider_error_generated_endpoints_must_be_ascending")
      )
    Output
      <error/slider_error_generated_endpoints_must_be_ascending>
      Error in `slide_index()`:
      i In locations: 2
      ! Endpoints generated by `.before` must be in ascending order.
    Code
      (expect_error(slide_index(x, x, identity, .after = ~ .x + c(4, 2)), class = "slider_error_generated_endpoints_must_be_ascending")
      )
    Output
      <error/slider_error_generated_endpoints_must_be_ascending>
      Error in `slide_index()`:
      i In locations: 2
      ! Endpoints generated by `.after` must be in ascending order.

# .before/.after - generated endpoints must maintain .before <= .after ordering

    Code
      (expect_error(slide_index(1:2, 1:2, identity, .before = ~ .x + 1, .after = 0)))
    Output
      <error/rlang_error>
      Error:
      i In locations: 1 and 2
      i In the ranges generated by `.before` and `.after`:
      ! The start of the range can't be after the end of the range.
    Code
      (expect_error(slide_index(1:2, 1:2, identity, .before = 0, .after = ~ .x - 1)))
    Output
      <error/rlang_error>
      Error:
      i In locations: 1 and 2
      i In the ranges generated by `.before` and `.after`:
      ! The start of the range can't be after the end of the range.

# .before/.after - generated endpoints can't be NA

    Code
      (expect_error(slide_index(1:2, 1:2, identity, .before = ~ rep(NA_integer_,
        length(.x)))))
    Output
      <error/slider_error_generated_endpoints_cannot_be_na>
      Error in `slide_index()`:
      i In locations: 1 and 2
      ! Endpoints generated by `.before` can't be `NA`.
    Code
      (expect_error(slide_index(1:2, 1:2, identity, .after = ~ rep(NA_integer_,
        length(.x)))))
    Output
      <error/slider_error_generated_endpoints_cannot_be_na>
      Error in `slide_index()`:
      i In locations: 1 and 2
      ! Endpoints generated by `.after` can't be `NA`.

# .before/.after - generated endpoints shouldn't rely on original `.i` length

    Code
      (expect_error(slide_index(x, x, identity, .before = ~ .x - adjust), class = "slider_error_generated_endpoints_incompatible_size")
      )
    Output
      <error/slider_error_generated_endpoints_incompatible_size>
      Error in `slide_index()`:
      ! Endpoints generated by `.before` must have size 1, not 2.
    Code
      (expect_error(slide_index(x, x, identity, .after = ~ .x + adjust), class = "slider_error_generated_endpoints_incompatible_size")
      )
    Output
      <error/slider_error_generated_endpoints_incompatible_size>
      Error in `slide_index()`:
      ! Endpoints generated by `.after` must have size 1, not 2.

# cannot use an invalid .complete value

    Code
      (expect_error(slide_index(1, 1, identity, .complete = "hi"), class = "vctrs_error_incompatible_type")
      )
    Output
      <error/vctrs_error_cast>
      Error in `slide_index()`:
      ! Can't convert `.complete` <character> to <logical>.

# `.i - .before` must be castable to `.i`

    Code
      (expect_error(slide_index(1, i, identity, .before = 1.5), class = "vctrs_error_cast_lossy")
      )
    Output
      <error/vctrs_error_cast_lossy>
      Error in `slide_index()`:
      ! Can't convert from `starts` <double> to `.i` <integer> due to loss of precision.
      * Locations: 1

# `.i + .after` must be castable to `.i`

    Code
      (expect_error(slide_index(1, i, identity, .after = 1.5), class = "vctrs_error_cast_lossy")
      )
    Output
      <error/vctrs_error_cast_lossy>
      Error in `slide_index()`:
      ! Can't convert from `stops` <double> to `.i` <integer> due to loss of precision.
      * Locations: 1

# `error_call` and `.error_call` args aren't swallowed

    Code
      slide_index(1, 1, fn, error_call = call("foo"))
    Condition
      Error in `foo()`:
      ! hi

---

    Code
      slide_index(1, 1, fn_dot, .error_call = call("foo"))
    Condition
      Error in `foo()`:
      ! hi

