% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{moduleServer}
\alias{moduleServer}
\title{Shiny modules}
\usage{
moduleServer(id, module, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{An ID string that corresponds with the ID used to call the module's
UI function.}

\item{module}{A Shiny module server function.}

\item{session}{Session from which to make a child scope (the default should
almost always be used).}
}
\value{
The return value, if any, from executing the module server function
}
\description{
Shiny's module feature lets you break complicated UI and server logic into
smaller, self-contained pieces. Compared to large monolithic Shiny apps,
modules are easier to reuse and easier to reason about. See the article at
\url{https://shiny.rstudio.com/articles/modules.html} to learn more.
}
\details{
Starting in Shiny 1.5.0, we recommend using \code{moduleServer} instead of
\code{\link[=callModule]{callModule()}}, because the syntax is a little easier
to understand, and modules created with \code{moduleServer} can be tested with
\code{\link[=testServer]{testServer()}}.
}
\examples{
# Define the UI for a module
counterUI <- function(id, label = "Counter") {
  ns <- NS(id)
  tagList(
    actionButton(ns("button"), label = label),
    verbatimTextOutput(ns("out"))
  )
}

# Define the server logic for a module
counterServer <- function(id) {
  moduleServer(
    id,
    function(input, output, session) {
      count <- reactiveVal(0)
      observeEvent(input$button, {
        count(count() + 1)
      })
      output$out <- renderText({
        count()
      })
      count
    }
  )
}

# Use the module in an app
ui <- fluidPage(
  counterUI("counter1", "Counter #1"),
  counterUI("counter2", "Counter #2")
)
server <- function(input, output, session) {
  counterServer("counter1")
  counterServer("counter2")
}
if (interactive()) {
  shinyApp(ui, server)
}



# If you want to pass extra parameters to the module's server logic, you can
# add them to your function. In this case `prefix` is text that will be
# printed before the count.
counterServer2 <- function(id, prefix = NULL) {
  moduleServer(
    id,
    function(input, output, session) {
      count <- reactiveVal(0)
      observeEvent(input$button, {
        count(count() + 1)
      })
      output$out <- renderText({
        paste0(prefix, count())
      })
      count
    }
  )
}

ui <- fluidPage(
  counterUI("counter", "Counter"),
)
server <- function(input, output, session) {
  counterServer2("counter", "The current count is: ")
}
if (interactive()) {
  shinyApp(ui, server)
}

}
\seealso{
\url{https://shiny.rstudio.com/articles/modules.html}
}
