% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_delim.R
\name{read_delim}
\alias{read_delim}
\alias{read_csv}
\alias{read_csv2}
\alias{read_tsv}
\title{Read a delimited file (including csv & tsv) into a tibble}
\usage{
read_delim(file, delim, quote = "\\"", escape_backslash = FALSE,
  escape_double = TRUE, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  comment = "", trim_ws = FALSE, skip = 0, n_max = Inf,
  guess_max = min(1000, n_max), progress = show_progress(),
  skip_empty_rows = TRUE)

read_csv(file, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  quote = "\\"", comment = "", trim_ws = TRUE, skip = 0,
  n_max = Inf, guess_max = min(1000, n_max),
  progress = show_progress(), skip_empty_rows = TRUE)

read_csv2(file, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  quote = "\\"", comment = "", trim_ws = TRUE, skip = 0,
  n_max = Inf, guess_max = min(1000, n_max),
  progress = show_progress(), skip_empty_rows = TRUE)

read_tsv(file, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  quote = "\\"", comment = "", trim_ws = TRUE, skip = 0,
  n_max = Inf, guess_max = min(1000, n_max),
  progress = show_progress(), skip_empty_rows = TRUE)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{delim}{Single character used to separate fields within a record.}

\item{quote}{Single character used to quote strings.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimiter character, the quote character, or
to add special characters like \code{\\n}.}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value \code{""""} represents
a single quote, \code{\"}.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{X1}, \code{X2} etc. Duplicate column names
will generate a warning and be made unique with a numeric prefix.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be imputed from the first 1000 rows
on the input. This is convenient (and fast), but not robust. If the
imputation fails, you'll need to supply the correct types yourself.

If a column specification created by \code{\link[=cols]{cols()}}, it must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[=cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
c = character, i = integer, n = number, d = double,
l = logical, f = factor, D = date, T = date time, t = time, ? = guess, or
\code{_}/\code{-} to skip the column.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quoted_na}{Should missing values inside quotes be treated as missing
values (the default) or strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{guess_max}{Maximum number of records to use for guessing column types.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}
}
\value{
A \code{\link[=tibble]{tibble()}}. If there are parsing problems, a warning tells you
how many, and you can retrieve the details with \code{\link[=problems]{problems()}}.
}
\description{
\code{read_csv()} and \code{read_tsv()} are special cases of the general
\code{read_delim()}. They're useful for reading the most common types of
flat file data, comma separated values and tab separated values,
respectively. \code{read_csv2()} uses \code{;} for the field separator and \code{,} for the
decimal point. This is common in some European countries.
}
\examples{
# Input sources -------------------------------------------------------------
# Read from a path
read_csv(readr_example("mtcars.csv"))
read_csv(readr_example("mtcars.csv.zip"))
read_csv(readr_example("mtcars.csv.bz2"))

\dontrun{
# Including remote paths
read_csv("https://github.com/tidyverse/readr/raw/master/inst/extdata/mtcars.csv")
}

# Or directly from a string (must contain a newline)
read_csv("x,y\\n1,2\\n3,4")

# Column types --------------------------------------------------------------
# By default, readr guesses the columns types, looking at the first 1000 rows.
# You can override with a compact specification:
read_csv("x,y\\n1,2\\n3,4", col_types = "dc")

# Or with a list of column types:
read_csv("x,y\\n1,2\\n3,4", col_types = list(col_double(), col_character()))

# If there are parsing problems, you get a warning, and can extract
# more details with problems()
y <- read_csv("x\\n1\\n2\\nb", col_types = list(col_double()))
y
problems(y)

# File types ----------------------------------------------------------------
read_csv("a,b\\n1.0,2.0")
read_csv2("a;b\\n1,0;2,0")
read_tsv("a\\tb\\n1.0\\t2.0")
read_delim("a|b\\n1.0|2.0", delim = "|")
}
