% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizor.R
\name{summarizor}
\alias{summarizor}
\title{Data summary preparation}
\usage{
summarizor(
  x,
  by = character(),
  overall_label = NULL,
  num_stats = c("mean_sd", "median_iqr", "range"),
  hide_null_na = TRUE,
  use_labels = TRUE
)
}
\arguments{
\item{x}{dataset}

\item{by}{columns names to be used as grouping columns}

\item{overall_label}{label to use as overall label}

\item{num_stats}{available statistics for numerical columns
to show, available options are "mean_sd", "median_iqr" and "range".}

\item{hide_null_na}{if TRUE (default), NA counts will not be shown when 0.}

\item{use_labels}{Logical; if TRUE, any column labels or value labels
present in the dataset will be used for display purposes. Defaults
to TRUE.}
}
\description{
It performs a univariate statistical analysis of a dataset
by group and formats the results so that they can be used with
the \code{\link[=tabulator]{tabulator()}} function or directly with \link[=as_flextable.summarizor]{as_flextable}.
\if{html}{\out{
<img src="https://www.ardata.fr/img/flextable-imgs/flextable-018-square.png" alt="summarizor illustration" style="width:100\%;">
}}
}
\note{
This is very first version of the function; be aware it
can evolve or change.
}
\examples{
\dontshow{
data.table::setDTthreads(1)
}
z <- summarizor(CO2[-c(1, 4)],
  by = "Treatment",
  overall_label = "Overall"
)
ft_1 <- as_flextable(z)
ft_1

ft_2 <- as_flextable(z, sep_w = 0, spread_first_col = TRUE)
ft_2

z <- summarizor(CO2[-c(1, 4)])
ft_3 <- as_flextable(z, sep_w = 0, spread_first_col = TRUE)
ft_3
}
\seealso{
\code{\link[=fmt_summarizor]{fmt_summarizor()}}, \code{\link[=labelizor]{labelizor()}}
}
