% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{set_knit_hooks}
\alias{set_knit_hooks}
\title{Set an Output Hook to Display ANSI CSI SGR in Rmarkdown}
\usage{
set_knit_hooks(hooks, which = "output", proc.fun = function(x, class)
  html_code_block(sgr_to_html(html_esc(x)), class = class),
  class = sprintf("fansi fansi-\%s", which),
  style = getOption("fansi.css"), split.nl = FALSE, .test = FALSE)
}
\arguments{
\item{hooks}{list, this should the be \code{knitr::knit_hooks} object; we
require you pass this to avoid a run-time dependency on \code{knitr}.}

\item{which}{character vector with the names of the hooks that should be
replaced, defaults to 'output', but can also contain values
'message', 'warning', and 'error'.}

\item{proc.fun}{function that will be applied to output that contains ANSI
CSI SGR sequences.  Should accept parameters \code{x} and \code{class}, where \code{x} is
the output, and \code{class} is the CSS class that should be applied to
the <PRE><CODE> blocks the output will be placed in.}

\item{class}{character the CSS class to give the output chunks.  Each type of
output chunk specified in \code{which} will be matched position-wise to the
classes specified here.  This vector should be the same length as \code{which}.}

\item{style}{character a vector of CSS styles; these will be output inside
HTML <STYLE> tags as a side effect.  The default value is designed to
ensure that there is no visible gap in background color with lines with
height 1.5 (as is the default setting in \code{rmarkdown} documents v1.1).}

\item{split.nl}{TRUE or FALSE (default), set to TRUE to split input strings
by any newlines they may contain to avoid any newlines inside SPAN tags
created by \code{\link[=sgr_to_html]{sgr_to_html()}}.  Some markdown->html renders can be configured
to convert embedded newlines into line breaks, which may lead to a doubling
of line breaks.  With the default \code{proc.fun} the split strings are
recombined by \code{\link[=html_code_block]{html_code_block()}}, but if you provide your own \code{proc.fun}
you'll need to account for the possibility that the character vector it
receives will have a different number of elements than the chunk output.
This argument only has an effect if chunk output contains ANSI CSI SGR
sequences.}

\item{.test}{TRUE or FALSE, for internal testing use only.}
}
\value{
named list with the prior output hooks for each of \code{which}.
}
\description{
This is a convenience function designed for use within an \code{rmarkdown}
document.  It overrides the \code{knitr} output hooks by using
\code{knitr::knit_hooks$set}.  It replaces the hooks with ones that convert ANSI
CSI SGR sequences into HTML.  In addition to replacing the hook functions,
this will output a <STYLE> HTML block to stdout.  These two actions are side
effects as a result of which R chunks in the \code{rmarkdown} document that
contain ANSI CSI SGR are shown in their HTML equivalent form.
}
\details{
The replacement hook function tests for the presence of ANSI CSI SGR
sequences in chunk output with \code{\link{has_sgr}}, and if it is detected then
processes it with the user provided \code{proc.fun}.  Chunks that do not contain
ANSI CSI SGR are passed off to the previously set hook function.  The default
\code{proc.fun} will run the output through \code{\link{html_esc}}, \code{\link{sgr_to_html}}, and
finally \code{\link{html_code_block}}.

If you require more control than this function provides you can set the
\code{knitr} hooks manually with \code{knitr::knit_hooks$set}.  If you are seeing your
output gaining extra line breaks, look at the \code{split.nl} option.
}
\note{
Since we do not formally import the \code{knitr} functions we do not
guarantee that this function will always work properly with \code{knitr} /
\code{rmarkdown}.
}
\examples{
\dontrun{
## The following should be done within an `rmarkdown` document chunk with
## chunk option `results` set to 'asis' and the chunk option `comment` set
## to ''.

```{r comment="", results='asis', echo=FALSE}
## Change the "output" hook to handle ANSI CSI SGR

old.hooks <- set_knit_hooks(knitr::knit_hooks)

## Do the same with the warning, error, and message, and add styles for
## them (alternatively we could have done output as part of this call too)

styles <- c(
  getOption('fansi.style'),  # default style
  "PRE.fansi CODE {background-color: transparent;}",
  "PRE.fansi-error {background-color: #DD5555;}",
  "PRE.fansi-warning {background-color: #DDDD55;}",
  "PRE.fansi-message {background-color: #EEEEEE;}"
)
old.hooks <- c(
  old.hooks,
  fansi::set_knit_hooks(
    knitr::knit_hooks,
    which=c('warning', 'error', 'message'),
    style=styles
) )
```
## You may restore old hooks with the following chunk

## Restore Hooks
```{r}
do.call(knitr::knit_hooks$set, old.hooks)
```
}
}
\seealso{
\code{\link{has_sgr}}, \code{\link{sgr_to_html}}, \code{\link{html_esc}}, \code{\link{html_code_block}},
\href{https://yihui.name/knitr/hooks/#output-hooks}{knitr output hooks},
\href{https://bookdown.org/yihui/rmarkdown/language-engines.html#javascript-and-css}{embedding CSS in Rmd},
and the vignette \code{vignette(package='fansi', 'sgr-in-rmd')}.
}
