% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhoToPValue.R
\name{rhoToPValue}
\alias{rhoToPValue}
\title{Spearman's rho to a p-value}
\usage{
rhoToPValue(rho, n, positive = NULL)
}
\arguments{
\item{rho}{Numeric vector of rho values.}

\item{n}{Integer scalar specifying the number of observations used to compute \code{rho}.}

\item{positive}{Logical scalar indicating whether to perform a one-sided test for the alternative of a positive (\code{TRUE}) or negative rho (\code{FALSE}).
Default is to return statistics for both directions.}
}
\value{
If \code{positive=NULL}, a list of two numeric vectors is returned,
containing p-values for the test against the alternative hypothesis in each direction.

Otherwise, a numeric vector is returned containing the p-values for the test in the specified direction.
}
\description{
Compute an approximate p-value against the null hypothesis that Spearman's rho is zero.
This vectorizes the approximate p-value calculation in \code{\link{cor.test}} with \code{method="spearman"}.
}
\examples{
rhoToPValue(seq(-1, 1, 21), 50)

}
\author{
Aaron Lun
}
