% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLogNormal.R
\name{fitLogNormal}
\alias{fitLogNormal}
\title{Computes a log-normal linear model and permutation based p-values.}
\usage{
fitLogNormal(obj, mod, useCSSoffset = TRUE, B = 1000, coef = 2,
  sl = 1000)
}
\arguments{
\item{obj}{A MRexperiment object with count data.}

\item{mod}{The model for the count distribution.}

\item{useCSSoffset}{Boolean, whether to include the default scaling
parameters in the model or not.}

\item{B}{Number of permutations.}

\item{coef}{The coefficient of interest.}

\item{sl}{The value to scale by (default=1000).}
}
\value{
Call made, fit object from lmFit, t-statistics and p-values for each feature.
}
\description{
Wrapper to perform the permutation test on the t-statistic. This is the original
method employed by metastats (for non-sparse large samples). We include CSS normalization
though (optional) and log2 transform the data. In this method the null distribution is not assumed to be a t-dist.
}
\examples{

# This is a simple demonstration
data(lungData)
k = grep("Extraction.Control",pData(lungData)$SampleType)
lungTrim = lungData[,-k]
k = which(rowSums(MRcounts(lungTrim)>0)<30)
lungTrim = cumNorm(lungTrim)
lungTrim = lungTrim[-k,]
smokingStatus = pData(lungTrim)$SmokingStatus
mod = model.matrix(~smokingStatus)
fit = fitLogNormal(obj = lungTrim,mod=mod,B=1)

}
