% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleR-decouple.R
\name{decouple}
\alias{decouple}
\title{Evaluate multiple statistics with same input data}
\usage{
decouple(
  mat,
  network,
  .source = source,
  .target = target,
  statistics = NULL,
  args = list(NULL),
  consensus_score = TRUE,
  consensus_stats = NULL,
  include_time = FALSE,
  show_toy_call = FALSE,
  minsize = 5
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{statistics}{Statistical methods to be run sequentially. If none are
provided, only top performer methods are run (mlm, ulm and wsum).}

\item{args}{A list of argument-lists the same length as \code{statistics}
(or length 1). The default argument, list(NULL), will be recycled to the
same length as \code{statistics}, and will call each function with no arguments
(apart from \code{mat}, \code{network}, \code{.source} and, \code{.target}).}

\item{consensus_score}{Boolean whether to run a consensus score between
methods.}

\item{consensus_stats}{List of estimate names to use for the calculation
of the consensus score. This is used to filter out extra estimations
from some methods, for example wsum returns wsum, corr_wsum and norm_wsum. If
none are provided, and also no statstics where provided, only top performer
methods are used (mlm, ulm and norm_wsum). Else, it will use all available
estimates after running all methods in the statistics argument.}

\item{include_time}{Should the time per statistic evaluated be informed?}

\item{show_toy_call}{The call of each statistic must be informed?}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{run_id}: Indicates the order in which the methods have been executed.
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
\item \code{statistic_time}: If requested, internal execution time indicator.
\item \code{p_value}: p-value (if available) of the obtained score.
}
}
\description{
Calculate the source activity per sample out of a gene expression matrix by
coupling a regulatory network with a variety of statistics.
}
\examples{
if (FALSE) {
    inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

    mat <- readRDS(file.path(inputs_dir, "mat.rds"))
    net <- readRDS(file.path(inputs_dir, "net.rds"))

    decouple(
        mat = mat,
        network = net,
        .source = "source",
        .target = "target",
        statistics = c("gsva", "wmean", "wsum", "ulm", "aucell"),
        args = list(
            gsva = list(verbose = FALSE),
            wmean = list(.mor = "mor", .likelihood = "likelihood"),
            wsum = list(.mor = "mor"),
            ulm = list(.mor = "mor")
        ),
        minsize = 0
    )
}
}
\seealso{
Other decoupleR statistics: 
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_ulm}()},
\code{\link{run_viper}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
