% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HclustParam.R
\docType{class}
\name{HclustParam-class}
\alias{HclustParam-class}
\alias{.defaultScalarArguments,HclustParam-method}
\alias{updateObject,HclustParam-method}
\alias{show,HclustParam-method}
\alias{[[,HclustParam-method}
\alias{HclustParam}
\alias{clusterRows,ANY,HclustParam-method}
\title{Hierarchical clustering}
\usage{
HclustParam(
  metric = NULL,
  method = NULL,
  cut.fun = NULL,
  cut.dynamic = FALSE,
  cut.height = NULL,
  cut.number = NULL,
  cut.params = list(),
  ...
)

\S4method{clusterRows}{ANY,HclustParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{metric}{String specifying the distance metric to use in \code{\link{dist}}.}

\item{method}{String specifying the agglomeration method to use in \code{\link{hclust}}.}

\item{cut.fun}{Function specifying the method to use to cut the dendrogram.
The first argument of this function should be the output of \code{\link{hclust}},
and the return value should be an atomic vector specifying the cluster assignment for each observation.
Defaults to \code{\link{cutree}} if \code{cut.dynamic=FALSE} and \code{\link[dynamicTreeCut]{cutreeDynamic}} otherwise.}

\item{cut.dynamic}{Logical scalar indicating whether a dynamic tree cut should be performed using the \pkg{dynamicTreeCut} package.}

\item{cut.height, cut.number}{Deprecated, use \code{h} and \code{k} in \code{cut.params} instead.}

\item{cut.params}{Further arguments to pass to \code{cut.fun}.}

\item{...}{Deprecated, more arguments to add to \code{cut.params}.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{HclustParam} object.}

\item{full}{Logical scalar indicating whether the hierarchical clustering statistics should be returned.}
}
\value{
The \code{HclustParam} constructor will return a \linkS4class{HclustParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects} 
(a list containing \code{dist}, the distance matrix; and \code{hclust}, the output of \code{\link{hclust}}).
}
\description{
Run the base \code{\link{hclust}} function on a distance matrix within \code{\link{clusterRows}}.
}
\details{
To modify an existing HclustParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.

If \code{cut.fun=NULL}, \code{cut.dynamic=FALSE} and \code{cut.params} does not have \code{h} or \code{k},
\code{\link{clusterRows}} will automatically set \code{h} to half the tree height when calling \code{\link{cutree}}.
}
\examples{
clusterRows(iris[,1:4], HclustParam())
clusterRows(iris[,1:4], HclustParam(method="ward.D2"))

}
\seealso{
\code{\link{dist}}, \code{\link{hclust}} and \code{\link{cutree}}, which actually do all the heavy lifting.

\code{\link[dynamicTreeCut]{cutreeDynamic}}, for an alternative tree cutting method to use in \code{cut.fun}.
}
\author{
Aaron Lun
}
