# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicebus import ServiceBusManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceBusManagementNamespacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceBusManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.namespaces.list(
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.namespaces.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.namespaces.begin_create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            parameters={
                "location": "str",
                "alternateName": "str",
                "createdAt": "2020-02-20 00:00:00",
                "disableLocalAuth": bool,
                "encryption": {
                    "keySource": "Microsoft.KeyVault",
                    "keyVaultProperties": [
                        {
                            "identity": {"userAssignedIdentity": "str"},
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVersion": "str",
                        }
                    ],
                    "requireInfrastructureEncryption": bool,
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "metricId": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {"description": "str", "status": "str"},
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "serviceBusEndpoint": "str",
                "sku": {"name": "str", "capacity": 0, "tier": "str"},
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
                "zoneRedundant": bool,
            },
            api_version="2021-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.namespaces.begin_delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.namespaces.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.namespaces.update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            parameters={
                "alternateName": "str",
                "createdAt": "2020-02-20 00:00:00",
                "disableLocalAuth": bool,
                "encryption": {
                    "keySource": "Microsoft.KeyVault",
                    "keyVaultProperties": [
                        {
                            "identity": {"userAssignedIdentity": "str"},
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVersion": "str",
                        }
                    ],
                    "requireInfrastructureEncryption": bool,
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "metricId": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {"description": "str", "status": "str"},
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "serviceBusEndpoint": "str",
                "sku": {"name": "str", "capacity": 0, "tier": "str"},
                "status": "str",
                "tags": {"str": "str"},
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update_network_rule_set(self, resource_group):
        response = self.client.namespaces.create_or_update_network_rule_set(
            resource_group_name=resource_group.name,
            namespace_name="str",
            parameters={
                "defaultAction": "str",
                "id": "str",
                "ipRules": [{"action": "Allow", "ipMask": "str"}],
                "location": "str",
                "name": "str",
                "publicNetworkAccess": "Enabled",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "trustedServiceAccessEnabled": bool,
                "type": "str",
                "virtualNetworkRules": [{"ignoreMissingVnetServiceEndpoint": bool, "subnet": {"id": "str"}}],
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_network_rule_set(self, resource_group):
        response = self.client.namespaces.get_network_rule_set(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_network_rule_sets(self, resource_group):
        response = self.client.namespaces.list_network_rule_sets(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_authorization_rules(self, resource_group):
        response = self.client.namespaces.list_authorization_rules(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update_authorization_rule(self, resource_group):
        response = self.client.namespaces.create_or_update_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            parameters={
                "id": "str",
                "location": "str",
                "name": "str",
                "rights": ["str"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_authorization_rule(self, resource_group):
        response = self.client.namespaces.delete_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_authorization_rule(self, resource_group):
        response = self.client.namespaces.get_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_keys(self, resource_group):
        response = self.client.namespaces.list_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_regenerate_keys(self, resource_group):
        response = self.client.namespaces.regenerate_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            authorization_rule_name="str",
            parameters={"keyType": "str", "key": "str"},
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_check_name_availability(self, resource_group):
        response = self.client.namespaces.check_name_availability(
            parameters={"name": "str"},
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...
