# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appconfiguration import AppConfigurationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAppConfigurationManagementSnapshotsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AppConfigurationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.snapshots.get(
            resource_group_name=resource_group.name,
            config_store_name="str",
            snapshot_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.snapshots.begin_create(
            resource_group_name=resource_group.name,
            config_store_name="str",
            snapshot_name="str",
            body={
                "compositionType": "str",
                "created": "2020-02-20 00:00:00",
                "etag": "str",
                "expires": "2020-02-20 00:00:00",
                "filters": [{"key": "str", "label": "str"}],
                "id": "str",
                "itemsCount": 0,
                "name": "str",
                "provisioningState": "str",
                "retentionPeriod": 0,
                "size": 0,
                "status": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
