# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._operations._operations import build_logs_ingestion_upload_request
from .._vendor import LogsIngestionClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class LogsIngestionClientOperationsMixin(LogsIngestionClientMixinABC):
    @overload
    async def _upload(  # pylint: disable=inconsistent-return-statements
        self,
        rule_id: str,
        stream: str,
        body: List[JSON],
        *,
        content_encoding: Optional[str] = None,
        x_ms_client_request_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        ...

    @overload
    async def _upload(  # pylint: disable=inconsistent-return-statements
        self,
        rule_id: str,
        stream: str,
        body: IO,
        *,
        content_encoding: Optional[str] = None,
        x_ms_client_request_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        ...

    @distributed_trace_async
    async def _upload(  # pylint: disable=inconsistent-return-statements
        self,
        rule_id: str,
        stream: str,
        body: Union[List[JSON], IO],
        *,
        content_encoding: Optional[str] = None,
        x_ms_client_request_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Ingestion API used to directly ingest data using Data Collection Rules.

        See error response code and error response message for more detail.

        :param rule_id: The immutable Id of the Data Collection Rule resource. Required.
        :type rule_id: str
        :param stream: The streamDeclaration name as defined in the Data Collection Rule. Required.
        :type stream: str
        :param body: An array of objects matching the schema defined by the provided stream. Is either
         a [JSON] type or a IO type. Required.
        :type body: list[JSON] or IO
        :keyword content_encoding: gzip. Default value is None.
        :paramtype content_encoding: str
        :keyword x_ms_client_request_id: Client request Id. Default value is None.
        :paramtype x_ms_client_request_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        request = build_logs_ingestion_upload_request(
            rule_id=rule_id,
            stream=stream,
            content_encoding=content_encoding,
            x_ms_client_request_id=x_ms_client_request_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
