# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AcceptJobOfferResult(_serialization.Model):
    """Response containing Id's for the worker, job, and assignment from an accepted offer.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The assignment Id that assigns a worker that has accepted an offer to a
     job. Required.
    :vartype assignment_id: str
    :ivar job_id: The Id of the job assigned. Required.
    :vartype job_id: str
    :ivar worker_id: The Id of the worker that has been assigned this job. Required.
    :vartype worker_id: str
    """

    _validation = {
        "assignment_id": {"required": True, "min_length": 1},
        "job_id": {"required": True, "min_length": 1},
        "worker_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "worker_id": {"key": "workerId", "type": "str"},
    }

    def __init__(self, *, assignment_id: str, job_id: str, worker_id: str, **kwargs: Any) -> None:
        """
        :keyword assignment_id: The assignment Id that assigns a worker that has accepted an offer to a
         job. Required.
        :paramtype assignment_id: str
        :keyword job_id: The Id of the job assigned. Required.
        :paramtype job_id: str
        :keyword worker_id: The Id of the worker that has been assigned this job. Required.
        :paramtype worker_id: str
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.job_id = job_id
        self.worker_id = worker_id


class DistributionMode(_serialization.Model):
    """Abstract base class for defining a distribution mode.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BestWorkerMode, LongestIdleMode, RoundRobinMode

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
    }

    _subtype_map = {
        "kind": {"best-worker": "BestWorkerMode", "longest-idle": "LongestIdleMode", "round-robin": "RoundRobinMode"}
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.min_concurrent_offers = min_concurrent_offers
        self.max_concurrent_offers = max_concurrent_offers
        self.bypass_selectors = bypass_selectors


class BestWorkerMode(DistributionMode):
    """Jobs are distributed to the worker with the strongest abilities available.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    :ivar scoring_rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
     WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
     protocol.
    :vartype scoring_rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar scoring_rule_options: Encapsulates all options that can be passed as parameters for
     scoring rule with BestWorkerMode.
    :vartype scoring_rule_options: ~azure.communication.jobrouter.models.ScoringRuleOptions
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
        "scoring_rule": {"key": "scoringRule", "type": "RouterRule"},
        "scoring_rule_options": {"key": "scoringRuleOptions", "type": "ScoringRuleOptions"},
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
        scoring_rule: Optional["_models.RouterRule"] = None,
        scoring_rule_options: Optional["_models.ScoringRuleOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        :keyword scoring_rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
         WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
         protocol.
        :paramtype scoring_rule: ~azure.communication.jobrouter.models.RouterRule
        :keyword scoring_rule_options: Encapsulates all options that can be passed as parameters for
         scoring rule with BestWorkerMode.
        :paramtype scoring_rule_options: ~azure.communication.jobrouter.models.ScoringRuleOptions
        """
        super().__init__(
            min_concurrent_offers=min_concurrent_offers,
            max_concurrent_offers=max_concurrent_offers,
            bypass_selectors=bypass_selectors,
            **kwargs
        )
        self.kind: str = "best-worker"
        self.scoring_rule = scoring_rule
        self.scoring_rule_options = scoring_rule_options


class ExceptionAction(_serialization.Model):
    """The action to take when the exception is triggered.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CancelExceptionAction, ManualReclassifyExceptionAction, ReclassifyExceptionAction

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "cancel": "CancelExceptionAction",
            "manual-reclassify": "ManualReclassifyExceptionAction",
            "reclassify": "ReclassifyExceptionAction",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class CancelExceptionAction(ExceptionAction):
    """An action that marks a job as cancelled.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with th
     current timestamp.
    :vartype note: str
    :ivar disposition_code: (Optional) Indicates the outcome of the job, populate this field with
     your own custom values.
    :vartype disposition_code: str
    """

    _validation = {
        "kind": {"required": True},
        "note": {"max_length": 2000},
        "disposition_code": {"max_length": 500},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "note": {"key": "note", "type": "str"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
    }

    def __init__(self, *, note: Optional[str] = None, disposition_code: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with th
         current timestamp.
        :paramtype note: str
        :keyword disposition_code: (Optional) Indicates the outcome of the job, populate this field
         with your own custom values.
        :paramtype disposition_code: str
        """
        super().__init__(**kwargs)
        self.kind: str = "cancel"
        self.note = note
        self.disposition_code = disposition_code


class CancelJobRequest(_serialization.Model):
    """Request payload for deleting a job.

    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with the
     current timestamp.
    :vartype note: str
    :ivar disposition_code: Indicates the outcome of the job, populate this field with your own
     custom values.
     If not provided, default value of "Cancelled" is set.
    :vartype disposition_code: str
    """

    _validation = {
        "note": {"max_length": 2000},
        "disposition_code": {"max_length": 500},
    }

    _attribute_map = {
        "note": {"key": "note", "type": "str"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
    }

    def __init__(self, *, note: Optional[str] = None, disposition_code: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with the
         current timestamp.
        :paramtype note: str
        :keyword disposition_code: Indicates the outcome of the job, populate this field with your own
         custom values.
         If not provided, default value of "Cancelled" is set.
        :paramtype disposition_code: str
        """
        super().__init__(**kwargs)
        self.note = note
        self.disposition_code = disposition_code


class ChannelConfiguration(_serialization.Model):
    """Represents the capacity a job in this channel will consume from a worker.

    All required parameters must be populated in order to send to Azure.

    :ivar capacity_cost_per_job: The amount of capacity that an instance of a job of this channel
     will consume of the total worker capacity. Required.
    :vartype capacity_cost_per_job: int
    :ivar max_number_of_jobs: The maximum number of jobs that can be supported concurrently for
     this channel.
    :vartype max_number_of_jobs: int
    """

    _validation = {
        "capacity_cost_per_job": {"required": True},
    }

    _attribute_map = {
        "capacity_cost_per_job": {"key": "capacityCostPerJob", "type": "int"},
        "max_number_of_jobs": {"key": "maxNumberOfJobs", "type": "int"},
    }

    def __init__(self, *, capacity_cost_per_job: int, max_number_of_jobs: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword capacity_cost_per_job: The amount of capacity that an instance of a job of this
         channel will consume of the total worker capacity. Required.
        :paramtype capacity_cost_per_job: int
        :keyword max_number_of_jobs: The maximum number of jobs that can be supported concurrently for
         this channel.
        :paramtype max_number_of_jobs: int
        """
        super().__init__(**kwargs)
        self.capacity_cost_per_job = capacity_cost_per_job
        self.max_number_of_jobs = max_number_of_jobs


class ClassificationPolicy(_serialization.Model):
    """A container for the rules that govern how jobs are classified.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique identifier of this policy.
    :vartype id: str
    :ivar name: Friendly name of this policy.
    :vartype name: str
    :ivar fallback_queue_id: The fallback queue to select if the queue selector doesn't find a
     match.
    :vartype fallback_queue_id: str
    :ivar queue_selectors: The queue selectors to resolve a queue for a given job.
    :vartype queue_selectors: list[~azure.communication.jobrouter.models.QueueSelectorAttachment]
    :ivar prioritization_rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
     WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
     protocol.
    :vartype prioritization_rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar worker_selectors: The worker label selectors to attach to a given job.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.WorkerSelectorAttachment]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "fallback_queue_id": {"key": "fallbackQueueId", "type": "str"},
        "queue_selectors": {"key": "queueSelectors", "type": "[QueueSelectorAttachment]"},
        "prioritization_rule": {"key": "prioritizationRule", "type": "RouterRule"},
        "worker_selectors": {"key": "workerSelectors", "type": "[WorkerSelectorAttachment]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        fallback_queue_id: Optional[str] = None,
        queue_selectors: Optional[List["_models.QueueSelectorAttachment"]] = None,
        prioritization_rule: Optional["_models.RouterRule"] = None,
        worker_selectors: Optional[List["_models.WorkerSelectorAttachment"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Friendly name of this policy.
        :paramtype name: str
        :keyword fallback_queue_id: The fallback queue to select if the queue selector doesn't find a
         match.
        :paramtype fallback_queue_id: str
        :keyword queue_selectors: The queue selectors to resolve a queue for a given job.
        :paramtype queue_selectors: list[~azure.communication.jobrouter.models.QueueSelectorAttachment]
        :keyword prioritization_rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
         WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
         protocol.
        :paramtype prioritization_rule: ~azure.communication.jobrouter.models.RouterRule
        :keyword worker_selectors: The worker label selectors to attach to a given job.
        :paramtype worker_selectors:
         list[~azure.communication.jobrouter.models.WorkerSelectorAttachment]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.fallback_queue_id = fallback_queue_id
        self.queue_selectors = queue_selectors
        self.prioritization_rule = prioritization_rule
        self.worker_selectors = worker_selectors


class ClassificationPolicyCollection(_serialization.Model):
    """A paged collection of classification policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.ClassificationPolicyItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClassificationPolicyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ClassificationPolicyItem"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.ClassificationPolicyItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClassificationPolicyItem(_serialization.Model):
    """Paged instance of ClassificationPolicy.

    :ivar classification_policy: A container for the rules that govern how jobs are classified.
    :vartype classification_policy: ~azure.communication.jobrouter.models.ClassificationPolicy
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "classification_policy": {"key": "classificationPolicy", "type": "ClassificationPolicy"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        classification_policy: Optional["_models.ClassificationPolicy"] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword classification_policy: A container for the rules that govern how jobs are classified.
        :paramtype classification_policy: ~azure.communication.jobrouter.models.ClassificationPolicy
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.classification_policy = classification_policy
        self.etag = etag


class CloseJobRequest(_serialization.Model):
    """Request payload for closing jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The assignment within which the job is to be closed. Required.
    :vartype assignment_id: str
    :ivar disposition_code: Indicates the outcome of the job, populate this field with your own
     custom values.
    :vartype disposition_code: str
    :ivar close_at: If not provided, worker capacity is released immediately along with a
     JobClosedEvent notification.
     If provided, worker capacity is released along with a JobClosedEvent notification at a future
     time in UTC.
    :vartype close_at: ~datetime.datetime
    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with the
     current timestamp.
    :vartype note: str
    """

    _validation = {
        "assignment_id": {"required": True, "max_length": 50},
        "disposition_code": {"max_length": 500},
        "note": {"max_length": 2000},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
        "close_at": {"key": "closeAt", "type": "iso-8601"},
        "note": {"key": "note", "type": "str"},
    }

    def __init__(
        self,
        *,
        assignment_id: str,
        disposition_code: Optional[str] = None,
        close_at: Optional[datetime.datetime] = None,
        note: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword assignment_id: The assignment within which the job is to be closed. Required.
        :paramtype assignment_id: str
        :keyword disposition_code: Indicates the outcome of the job, populate this field with your own
         custom values.
        :paramtype disposition_code: str
        :keyword close_at: If not provided, worker capacity is released immediately along with a
         JobClosedEvent notification.
         If provided, worker capacity is released along with a JobClosedEvent notification at a future
         time in UTC.
        :paramtype close_at: ~datetime.datetime
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with the
         current timestamp.
        :paramtype note: str
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.disposition_code = disposition_code
        self.close_at = close_at
        self.note = note


class CommunicationError(_serialization.Model):
    """The Communication Services error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Further details about specific errors that led to this error.
    :vartype details: list[~azure.communication.jobrouter.models.CommunicationError]
    :ivar inner_error: The inner error if any.
    :vartype inner_error: ~azure.communication.jobrouter.models.CommunicationError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CommunicationError]"},
        "inner_error": {"key": "innererror", "type": "CommunicationError"},
    }

    def __init__(self, *, code: str, message: str, **kwargs: Any) -> None:
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        :keyword message: The error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.details = None
        self.inner_error = None


class CommunicationErrorResponse(_serialization.Model):
    """The Communication Services error.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The Communication Services error. Required.
    :vartype error: ~azure.communication.jobrouter.models.CommunicationError
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "CommunicationError"},
    }

    def __init__(self, *, error: "_models.CommunicationError", **kwargs: Any) -> None:
        """
        :keyword error: The Communication Services error. Required.
        :paramtype error: ~azure.communication.jobrouter.models.CommunicationError
        """
        super().__init__(**kwargs)
        self.error = error


class CompleteJobRequest(_serialization.Model):
    """Request payload for completing jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The assignment within the job to complete. Required.
    :vartype assignment_id: str
    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with the
     current timestamp.
    :vartype note: str
    """

    _validation = {
        "assignment_id": {"required": True, "max_length": 50},
        "note": {"max_length": 2000},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "note": {"key": "note", "type": "str"},
    }

    def __init__(self, *, assignment_id: str, note: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword assignment_id: The assignment within the job to complete. Required.
        :paramtype assignment_id: str
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with the
         current timestamp.
        :paramtype note: str
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.note = note


class QueueSelectorAttachment(_serialization.Model):
    """An attachment of queue selectors to resolve a queue to a job from a classification policy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConditionalQueueSelectorAttachment, PassThroughQueueSelectorAttachment,
    RuleEngineQueueSelectorAttachment, StaticQueueSelectorAttachment,
    WeightedAllocationQueueSelectorAttachment

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "conditional": "ConditionalQueueSelectorAttachment",
            "pass-through": "PassThroughQueueSelectorAttachment",
            "rule-engine": "RuleEngineQueueSelectorAttachment",
            "static": "StaticQueueSelectorAttachment",
            "weighted-allocation-queue-selector": "WeightedAllocationQueueSelectorAttachment",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class ConditionalQueueSelectorAttachment(QueueSelectorAttachment):
    """Describes a set of queue selectors that will be attached if the given condition resolves to
    true.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
    :vartype kind: str
    :ivar condition: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
     WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
     protocol. Required.
    :vartype condition: ~azure.communication.jobrouter.models.RouterRule
    :ivar queue_selectors: The queue selectors to attach. Required.
    :vartype queue_selectors: list[~azure.communication.jobrouter.models.RouterQueueSelector]
    """

    _validation = {
        "kind": {"required": True},
        "condition": {"required": True},
        "queue_selectors": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "condition": {"key": "condition", "type": "RouterRule"},
        "queue_selectors": {"key": "queueSelectors", "type": "[RouterQueueSelector]"},
    }

    def __init__(
        self, *, condition: "_models.RouterRule", queue_selectors: List["_models.RouterQueueSelector"], **kwargs: Any
    ) -> None:
        """
        :keyword condition: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
         WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
         protocol. Required.
        :paramtype condition: ~azure.communication.jobrouter.models.RouterRule
        :keyword queue_selectors: The queue selectors to attach. Required.
        :paramtype queue_selectors: list[~azure.communication.jobrouter.models.RouterQueueSelector]
        """
        super().__init__(**kwargs)
        self.kind: str = "conditional"
        self.condition = condition
        self.queue_selectors = queue_selectors


class WorkerSelectorAttachment(_serialization.Model):
    """An attachment which attaches worker selectors to a job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConditionalWorkerSelectorAttachment, PassThroughWorkerSelectorAttachment,
    RuleEngineWorkerSelectorAttachment, StaticWorkerSelectorAttachment,
    WeightedAllocationWorkerSelectorAttachment

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "conditional": "ConditionalWorkerSelectorAttachment",
            "pass-through": "PassThroughWorkerSelectorAttachment",
            "rule-engine": "RuleEngineWorkerSelectorAttachment",
            "static": "StaticWorkerSelectorAttachment",
            "weighted-allocation-worker-selector": "WeightedAllocationWorkerSelectorAttachment",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class ConditionalWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Describes a set of worker selectors that will be attached if the given condition resolves to
    true.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
    :vartype kind: str
    :ivar condition: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
     WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
     protocol. Required.
    :vartype condition: ~azure.communication.jobrouter.models.RouterRule
    :ivar worker_selectors: The worker selectors to attach. Required.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    """

    _validation = {
        "kind": {"required": True},
        "condition": {"required": True},
        "worker_selectors": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "condition": {"key": "condition", "type": "RouterRule"},
        "worker_selectors": {"key": "workerSelectors", "type": "[RouterWorkerSelector]"},
    }

    def __init__(
        self, *, condition: "_models.RouterRule", worker_selectors: List["_models.RouterWorkerSelector"], **kwargs: Any
    ) -> None:
        """
        :keyword condition: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
         WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
         protocol. Required.
        :paramtype condition: ~azure.communication.jobrouter.models.RouterRule
        :keyword worker_selectors: The worker selectors to attach. Required.
        :paramtype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
        """
        super().__init__(**kwargs)
        self.kind: str = "conditional"
        self.condition = condition
        self.worker_selectors = worker_selectors


class DeclineJobOfferRequest(_serialization.Model):
    """Request payload for declining offers.

    :ivar retry_offer_at: If the RetryOfferAt is not provided, then this job will not be offered
     again to the worker who declined this job unless
     the worker is de-registered and re-registered.  If a RetryOfferAt time is provided, then the
     job will be re-matched to
     eligible workers at the retry time in UTC.  The worker that declined the job will also be
     eligible for the job at that time.
    :vartype retry_offer_at: ~datetime.datetime
    """

    _attribute_map = {
        "retry_offer_at": {"key": "retryOfferAt", "type": "iso-8601"},
    }

    def __init__(self, *, retry_offer_at: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword retry_offer_at: If the RetryOfferAt is not provided, then this job will not be offered
         again to the worker who declined this job unless
         the worker is de-registered and re-registered.  If a RetryOfferAt time is provided, then the
         job will be re-matched to
         eligible workers at the retry time in UTC.  The worker that declined the job will also be
         eligible for the job at that time.
        :paramtype retry_offer_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.retry_offer_at = retry_offer_at


class RouterRule(_serialization.Model):
    """A rule of one of the following types:

    StaticRule:  A rule providing static rules that always return the same result, regardless of
    input.
    DirectMapRule:  A rule that return the same labels as the input labels.
    ExpressionRule: A rule providing inline expression rules.
    AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
    WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
    protocol.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FunctionRule, DirectMapRule, ExpressionRule, StaticRule, WebhookRule

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "azure-function-rule": "FunctionRule",
            "direct-map-rule": "DirectMapRule",
            "expression-rule": "ExpressionRule",
            "static-rule": "StaticRule",
            "webhook-rule": "WebhookRule",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class DirectMapRule(RouterRule):
    """A rule that return the same labels as the input labels.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: str = "direct-map-rule"


class DistributionPolicy(_serialization.Model):
    """Policy governing how jobs are distributed to workers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique identifier of the policy.
    :vartype id: str
    :ivar name: The human readable name of the policy.
    :vartype name: str
    :ivar offer_expires_after_seconds: The number of seconds after which any offers created under
     this policy will be expired.
    :vartype offer_expires_after_seconds: float
    :ivar mode: Abstract base class for defining a distribution mode.
    :vartype mode: ~azure.communication.jobrouter.models.DistributionMode
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "offer_expires_after_seconds": {"key": "offerExpiresAfterSeconds", "type": "float"},
        "mode": {"key": "mode", "type": "DistributionMode"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        offer_expires_after_seconds: Optional[float] = None,
        mode: Optional["_models.DistributionMode"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The human readable name of the policy.
        :paramtype name: str
        :keyword offer_expires_after_seconds: The number of seconds after which any offers created
         under this policy will be expired.
        :paramtype offer_expires_after_seconds: float
        :keyword mode: Abstract base class for defining a distribution mode.
        :paramtype mode: ~azure.communication.jobrouter.models.DistributionMode
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.offer_expires_after_seconds = offer_expires_after_seconds
        self.mode = mode


class DistributionPolicyCollection(_serialization.Model):
    """A paged collection of distribution policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.DistributionPolicyItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DistributionPolicyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DistributionPolicyItem"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.DistributionPolicyItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DistributionPolicyItem(_serialization.Model):
    """Paged instance of DistributionPolicy.

    :ivar distribution_policy: Policy governing how jobs are distributed to workers.
    :vartype distribution_policy: ~azure.communication.jobrouter.models.DistributionPolicy
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "distribution_policy": {"key": "distributionPolicy", "type": "DistributionPolicy"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        distribution_policy: Optional["_models.DistributionPolicy"] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword distribution_policy: Policy governing how jobs are distributed to workers.
        :paramtype distribution_policy: ~azure.communication.jobrouter.models.DistributionPolicy
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.distribution_policy = distribution_policy
        self.etag = etag


class ExceptionPolicy(_serialization.Model):
    """A policy that defines actions to execute when exception are triggered.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Id of the exception policy.
    :vartype id: str
    :ivar name: (Optional) The name of the exception policy.
    :vartype name: str
    :ivar exception_rules: (Optional) A dictionary collection of exception rules on the exception
     policy. Key is the Id of each exception rule.
    :vartype exception_rules: dict[str, ~azure.communication.jobrouter.models.ExceptionRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "exception_rules": {"key": "exceptionRules", "type": "{ExceptionRule}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        exception_rules: Optional[Dict[str, "_models.ExceptionRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: (Optional) The name of the exception policy.
        :paramtype name: str
        :keyword exception_rules: (Optional) A dictionary collection of exception rules on the
         exception policy. Key is the Id of each exception rule.
        :paramtype exception_rules: dict[str, ~azure.communication.jobrouter.models.ExceptionRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.exception_rules = exception_rules


class ExceptionPolicyCollection(_serialization.Model):
    """A paged collection of exception policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.ExceptionPolicyItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExceptionPolicyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ExceptionPolicyItem"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.ExceptionPolicyItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ExceptionPolicyItem(_serialization.Model):
    """Paged instance of ExceptionPolicy.

    :ivar exception_policy: A policy that defines actions to execute when exception are triggered.
    :vartype exception_policy: ~azure.communication.jobrouter.models.ExceptionPolicy
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "exception_policy": {"key": "exceptionPolicy", "type": "ExceptionPolicy"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self, *, exception_policy: Optional["_models.ExceptionPolicy"] = None, etag: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exception_policy: A policy that defines actions to execute when exception are
         triggered.
        :paramtype exception_policy: ~azure.communication.jobrouter.models.ExceptionPolicy
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.exception_policy = exception_policy
        self.etag = etag


class ExceptionRule(_serialization.Model):
    """A rule that defines actions to execute upon a specific trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar trigger: The trigger for this exception rule. Required.
    :vartype trigger: ~azure.communication.jobrouter.models.ExceptionTrigger
    :ivar actions: A dictionary collection of actions to perform once the exception is triggered.
     Key is the Id of each exception action. Required.
    :vartype actions: dict[str, ~azure.communication.jobrouter.models.ExceptionAction]
    """

    _validation = {
        "trigger": {"required": True},
        "actions": {"required": True},
    }

    _attribute_map = {
        "trigger": {"key": "trigger", "type": "ExceptionTrigger"},
        "actions": {"key": "actions", "type": "{ExceptionAction}"},
    }

    def __init__(
        self, *, trigger: "_models.ExceptionTrigger", actions: Dict[str, "_models.ExceptionAction"], **kwargs: Any
    ) -> None:
        """
        :keyword trigger: The trigger for this exception rule. Required.
        :paramtype trigger: ~azure.communication.jobrouter.models.ExceptionTrigger
        :keyword actions: A dictionary collection of actions to perform once the exception is
         triggered. Key is the Id of each exception action. Required.
        :paramtype actions: dict[str, ~azure.communication.jobrouter.models.ExceptionAction]
        """
        super().__init__(**kwargs)
        self.trigger = trigger
        self.actions = actions


class ExceptionTrigger(_serialization.Model):
    """The trigger for this exception rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    QueueLengthExceptionTrigger, WaitTimeExceptionTrigger

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"queue-length": "QueueLengthExceptionTrigger", "wait-time": "WaitTimeExceptionTrigger"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class ExpressionRule(RouterRule):
    """A rule providing inline expression rules.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar language: The expression language to compile to and execute. "powerFx"
    :vartype language: str or ~azure.communication.jobrouter.models.ExpressionLanguage
    :ivar expression: The string containing the expression to evaluate. Should contain return
     statement with calculated values. Required.
    :vartype expression: str
    """

    _validation = {
        "kind": {"required": True},
        "expression": {"required": True, "max_length": 500},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "expression": {"key": "expression", "type": "str"},
    }

    def __init__(
        self, *, expression: str, language: Optional[Union[str, "_models.ExpressionLanguage"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword language: The expression language to compile to and execute. "powerFx"
        :paramtype language: str or ~azure.communication.jobrouter.models.ExpressionLanguage
        :keyword expression: The string containing the expression to evaluate. Should contain return
         statement with calculated values. Required.
        :paramtype expression: str
        """
        super().__init__(**kwargs)
        self.kind: str = "expression-rule"
        self.language = language
        self.expression = expression


class FunctionRule(RouterRule):
    """A rule providing a binding to an HTTP Triggered Azure Function.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar function_uri: URL for Azure Function. Required.
    :vartype function_uri: str
    :ivar credential: Credentials used to access Azure function rule.
    :vartype credential: ~azure.communication.jobrouter.models.FunctionRuleCredential
    """

    _validation = {
        "kind": {"required": True},
        "function_uri": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "function_uri": {"key": "functionUri", "type": "str"},
        "credential": {"key": "credential", "type": "FunctionRuleCredential"},
    }

    def __init__(
        self, *, function_uri: str, credential: Optional["_models.FunctionRuleCredential"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword function_uri: URL for Azure Function. Required.
        :paramtype function_uri: str
        :keyword credential: Credentials used to access Azure function rule.
        :paramtype credential: ~azure.communication.jobrouter.models.FunctionRuleCredential
        """
        super().__init__(**kwargs)
        self.kind: str = "azure-function-rule"
        self.function_uri = function_uri
        self.credential = credential


class FunctionRuleCredential(_serialization.Model):
    """Credentials used to access Azure function rule.

    :ivar function_key: (Optional) Access key scoped to a particular function.
    :vartype function_key: str
    :ivar app_key: (Optional) Access key scoped to a Azure Function app.
     This key grants access to all functions under the app.
    :vartype app_key: str
    :ivar client_id: (Optional) Client id, when AppKey is provided
     In context of Azure function, this is usually the name of the key.
    :vartype client_id: str
    """

    _validation = {
        "function_key": {"max_length": 500},
        "app_key": {"max_length": 500},
        "client_id": {"max_length": 500},
    }

    _attribute_map = {
        "function_key": {"key": "functionKey", "type": "str"},
        "app_key": {"key": "appKey", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        function_key: Optional[str] = None,
        app_key: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword function_key: (Optional) Access key scoped to a particular function.
        :paramtype function_key: str
        :keyword app_key: (Optional) Access key scoped to a Azure Function app.
         This key grants access to all functions under the app.
        :paramtype app_key: str
        :keyword client_id: (Optional) Client id, when AppKey is provided
         In context of Azure function, this is usually the name of the key.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.function_key = function_key
        self.app_key = app_key
        self.client_id = client_id


class JobMatchingMode(_serialization.Model):
    """JobMatchingMode.

    :ivar mode_type: Known values are: "queueAndMatchMode", "scheduleAndSuspendMode", and
     "suspendMode".
    :vartype mode_type: str or ~azure.communication.jobrouter.models.JobMatchModeType
    :ivar queue_and_match_mode: Any object.
    :vartype queue_and_match_mode: JSON
    :ivar schedule_and_suspend_mode:
    :vartype schedule_and_suspend_mode:
     ~azure.communication.jobrouter.models.ScheduleAndSuspendMode
    :ivar suspend_mode: Any object.
    :vartype suspend_mode: JSON
    """

    _attribute_map = {
        "mode_type": {"key": "modeType", "type": "str"},
        "queue_and_match_mode": {"key": "queueAndMatchMode", "type": "object"},
        "schedule_and_suspend_mode": {"key": "scheduleAndSuspendMode", "type": "ScheduleAndSuspendMode"},
        "suspend_mode": {"key": "suspendMode", "type": "object"},
    }

    def __init__(
        self,
        *,
        mode_type: Optional[Union[str, "_models.JobMatchModeType"]] = None,
        queue_and_match_mode: Optional[JSON] = None,
        schedule_and_suspend_mode: Optional["_models.ScheduleAndSuspendMode"] = None,
        suspend_mode: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode_type: Known values are: "queueAndMatchMode", "scheduleAndSuspendMode", and
         "suspendMode".
        :paramtype mode_type: str or ~azure.communication.jobrouter.models.JobMatchModeType
        :keyword queue_and_match_mode: Any object.
        :paramtype queue_and_match_mode: JSON
        :keyword schedule_and_suspend_mode:
        :paramtype schedule_and_suspend_mode:
         ~azure.communication.jobrouter.models.ScheduleAndSuspendMode
        :keyword suspend_mode: Any object.
        :paramtype suspend_mode: JSON
        """
        super().__init__(**kwargs)
        self.mode_type = mode_type
        self.queue_and_match_mode = queue_and_match_mode
        self.schedule_and_suspend_mode = schedule_and_suspend_mode
        self.suspend_mode = suspend_mode


class LongestIdleMode(DistributionMode):
    """Jobs are directed to the worker who has been idle longest.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        """
        super().__init__(
            min_concurrent_offers=min_concurrent_offers,
            max_concurrent_offers=max_concurrent_offers,
            bypass_selectors=bypass_selectors,
            **kwargs
        )
        self.kind: str = "longest-idle"


class ManualReclassifyExceptionAction(ExceptionAction):
    """An action that manually reclassifies a job by providing the queue, priority and worker
    selectors.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    :ivar queue_id: Updated QueueId.
    :vartype queue_id: str
    :ivar priority: Updated Priority.
    :vartype priority: int
    :ivar worker_selectors: Updated WorkerSelectors.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    """

    _validation = {
        "kind": {"required": True},
        "queue_id": {"max_length": 50},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "queue_id": {"key": "queueId", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "worker_selectors": {"key": "workerSelectors", "type": "[RouterWorkerSelector]"},
    }

    def __init__(
        self,
        *,
        queue_id: Optional[str] = None,
        priority: Optional[int] = None,
        worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword queue_id: Updated QueueId.
        :paramtype queue_id: str
        :keyword priority: Updated Priority.
        :paramtype priority: int
        :keyword worker_selectors: Updated WorkerSelectors.
        :paramtype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
        """
        super().__init__(**kwargs)
        self.kind: str = "manual-reclassify"
        self.queue_id = queue_id
        self.priority = priority
        self.worker_selectors = worker_selectors


class Oauth2ClientCredential(_serialization.Model):
    """OAuth2.0 Credentials used to Contoso's Authorization server.
    Reference: https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/.

    :ivar client_id: ClientId for Contoso Authorization server.
    :vartype client_id: str
    :ivar client_secret: Client secret for Contoso Authorization server.
    :vartype client_secret: str
    """

    _validation = {
        "client_id": {"max_length": 500},
        "client_secret": {"max_length": 500},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, client_secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: ClientId for Contoso Authorization server.
        :paramtype client_id: str
        :keyword client_secret: Client secret for Contoso Authorization server.
        :paramtype client_secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class PassThroughQueueSelectorAttachment(QueueSelectorAttachment):
    """Attaches a queue selector where the value is passed through from the job label with the same
    key.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
    :vartype kind: str
    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value pass
     through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
     "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    """

    _validation = {
        "kind": {"required": True},
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
    }

    def __init__(self, *, key: str, label_operator: Union[str, "_models.LabelOperator"], **kwargs: Any) -> None:
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value pass
         through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
         "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        """
        super().__init__(**kwargs)
        self.kind: str = "pass-through"
        self.key = key
        self.label_operator = label_operator


class PassThroughWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Attaches a worker selector where the value is passed through from the job label with the same
    key.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
    :vartype kind: str
    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value pass
     through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
     "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar expires_after_seconds: Describes how long the attached label selector is valid in
     seconds.
    :vartype expires_after_seconds: float
    """

    _validation = {
        "kind": {"required": True},
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
        "expires_after_seconds": {"key": "expiresAfterSeconds", "type": "float"},
    }

    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        expires_after_seconds: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value pass
         through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
         "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        :keyword expires_after_seconds: Describes how long the attached label selector is valid in
         seconds.
        :paramtype expires_after_seconds: float
        """
        super().__init__(**kwargs)
        self.kind: str = "pass-through"
        self.key = key
        self.label_operator = label_operator
        self.expires_after_seconds = expires_after_seconds


class QueueLengthExceptionTrigger(ExceptionTrigger):
    """Trigger for an exception action on exceeding queue length.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
    :vartype kind: str
    :ivar threshold: Threshold of number of jobs ahead in the queue to for this trigger to fire.
     Required.
    :vartype threshold: int
    """

    _validation = {
        "kind": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "threshold": {"key": "threshold", "type": "int"},
    }

    def __init__(self, *, threshold: int, **kwargs: Any) -> None:
        """
        :keyword threshold: Threshold of number of jobs ahead in the queue to for this trigger to fire.
         Required.
        :paramtype threshold: int
        """
        super().__init__(**kwargs)
        self.kind: str = "queue-length"
        self.threshold = threshold


class QueueWeightedAllocation(_serialization.Model):
    """Contains the weight percentage and queue selectors to be applied if selected for weighted
    distributions.

    All required parameters must be populated in order to send to Azure.

    :ivar weight: The percentage of this weight, expressed as a fraction of 1. Required.
    :vartype weight: float
    :ivar queue_selectors: A collection of queue selectors that will be applied if this allocation
     is selected. Required.
    :vartype queue_selectors: list[~azure.communication.jobrouter.models.RouterQueueSelector]
    """

    _validation = {
        "weight": {"required": True},
        "queue_selectors": {"required": True},
    }

    _attribute_map = {
        "weight": {"key": "weight", "type": "float"},
        "queue_selectors": {"key": "queueSelectors", "type": "[RouterQueueSelector]"},
    }

    def __init__(self, *, weight: float, queue_selectors: List["_models.RouterQueueSelector"], **kwargs: Any) -> None:
        """
        :keyword weight: The percentage of this weight, expressed as a fraction of 1. Required.
        :paramtype weight: float
        :keyword queue_selectors: A collection of queue selectors that will be applied if this
         allocation is selected. Required.
        :paramtype queue_selectors: list[~azure.communication.jobrouter.models.RouterQueueSelector]
        """
        super().__init__(**kwargs)
        self.weight = weight
        self.queue_selectors = queue_selectors


class ReclassifyExceptionAction(ExceptionAction):
    """An action that modifies labels on a job and then reclassifies it.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    :ivar classification_policy_id: (optional) The new classification policy that will determine
     queue, priority and worker selectors.
    :vartype classification_policy_id: str
    :ivar labels_to_upsert: (optional) Dictionary containing the labels to update (or add if not
     existing) in key-value pairs.
    :vartype labels_to_upsert: dict[str, any]
    """

    _validation = {
        "kind": {"required": True},
        "classification_policy_id": {"max_length": 50},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "classification_policy_id": {"key": "classificationPolicyId", "type": "str"},
        "labels_to_upsert": {"key": "labelsToUpsert", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        classification_policy_id: Optional[str] = None,
        labels_to_upsert: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword classification_policy_id: (optional) The new classification policy that will determine
         queue, priority and worker selectors.
        :paramtype classification_policy_id: str
        :keyword labels_to_upsert: (optional) Dictionary containing the labels to update (or add if not
         existing) in key-value pairs.
        :paramtype labels_to_upsert: dict[str, any]
        """
        super().__init__(**kwargs)
        self.kind: str = "reclassify"
        self.classification_policy_id = classification_policy_id
        self.labels_to_upsert = labels_to_upsert


class RoundRobinMode(DistributionMode):
    """Jobs are distributed in order to workers, starting with the worker that is after the last
    worker to receive a job.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        """
        super().__init__(
            min_concurrent_offers=min_concurrent_offers,
            max_concurrent_offers=max_concurrent_offers,
            bypass_selectors=bypass_selectors,
            **kwargs
        )
        self.kind: str = "round-robin"


class RouterJob(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A unit of work to be routed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The id of the job.
    :vartype id: str
    :ivar channel_reference: Reference to an external parent context, eg. call ID.
    :vartype channel_reference: str
    :ivar status: The status of the Job. Known values are: "pendingClassification", "queued",
     "assigned", "completed", "closed", "cancelled", "classificationFailed", "created",
     "pendingSchedule", "scheduled", "scheduleFailed", and "waitingForActivation".
    :vartype status: str or ~azure.communication.jobrouter.models.RouterJobStatus
    :ivar enqueued_at: The time a job was queued in UTC.
    :vartype enqueued_at: ~datetime.datetime
    :ivar channel_id: The channel identifier. eg. voice, chat, etc.
    :vartype channel_id: str
    :ivar classification_policy_id: The Id of the Classification policy used for classifying a job.
    :vartype classification_policy_id: str
    :ivar queue_id: The Id of the Queue that this job is queued to.
    :vartype queue_id: str
    :ivar priority: The priority of this job.
    :vartype priority: int
    :ivar disposition_code: Reason code for cancelled or closed jobs.
    :vartype disposition_code: str
    :ivar requested_worker_selectors: A collection of manually specified label selectors, which a
     worker must satisfy in order to process this job.
    :vartype requested_worker_selectors:
     list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    :ivar attached_worker_selectors: A collection of label selectors attached by a classification
     policy, which a worker must satisfy in order to process this job.
    :vartype attached_worker_selectors:
     list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions.
    :vartype labels: dict[str, any]
    :ivar assignments: A collection of the assignments of the job.
     Key is AssignmentId.
    :vartype assignments: dict[str, ~azure.communication.jobrouter.models.RouterJobAssignment]
    :ivar tags: A set of non-identifying attributes attached to this job.
    :vartype tags: dict[str, any]
    :ivar notes: Notes attached to a job, sorted by timestamp.
    :vartype notes: dict[str, str]
    :ivar scheduled_at: If set, job will be scheduled to be enqueued at a given time.
    :vartype scheduled_at: ~datetime.datetime
    :ivar matching_mode:
    :vartype matching_mode: ~azure.communication.jobrouter.models.JobMatchingMode
    """

    _validation = {
        "id": {"readonly": True},
        "status": {"readonly": True},
        "enqueued_at": {"readonly": True},
        "attached_worker_selectors": {"readonly": True},
        "assignments": {"readonly": True},
        "scheduled_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "channel_reference": {"key": "channelReference", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "enqueued_at": {"key": "enqueuedAt", "type": "iso-8601"},
        "channel_id": {"key": "channelId", "type": "str"},
        "classification_policy_id": {"key": "classificationPolicyId", "type": "str"},
        "queue_id": {"key": "queueId", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
        "requested_worker_selectors": {"key": "requestedWorkerSelectors", "type": "[RouterWorkerSelector]"},
        "attached_worker_selectors": {"key": "attachedWorkerSelectors", "type": "[RouterWorkerSelector]"},
        "labels": {"key": "labels", "type": "{object}"},
        "assignments": {"key": "assignments", "type": "{RouterJobAssignment}"},
        "tags": {"key": "tags", "type": "{object}"},
        "notes": {"key": "notes", "type": "{str}"},
        "scheduled_at": {"key": "scheduledAt", "type": "iso-8601"},
        "matching_mode": {"key": "matchingMode", "type": "JobMatchingMode"},
    }

    def __init__(
        self,
        *,
        channel_reference: Optional[str] = None,
        channel_id: Optional[str] = None,
        classification_policy_id: Optional[str] = None,
        queue_id: Optional[str] = None,
        priority: Optional[int] = None,
        disposition_code: Optional[str] = None,
        requested_worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = None,
        labels: Optional[Dict[str, Any]] = None,
        tags: Optional[Dict[str, Any]] = None,
        notes: Optional[Dict[str, str]] = None,
        matching_mode: Optional["_models.JobMatchingMode"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword channel_reference: Reference to an external parent context, eg. call ID.
        :paramtype channel_reference: str
        :keyword channel_id: The channel identifier. eg. voice, chat, etc.
        :paramtype channel_id: str
        :keyword classification_policy_id: The Id of the Classification policy used for classifying a
         job.
        :paramtype classification_policy_id: str
        :keyword queue_id: The Id of the Queue that this job is queued to.
        :paramtype queue_id: str
        :keyword priority: The priority of this job.
        :paramtype priority: int
        :keyword disposition_code: Reason code for cancelled or closed jobs.
        :paramtype disposition_code: str
        :keyword requested_worker_selectors: A collection of manually specified label selectors, which
         a worker must satisfy in order to process this job.
        :paramtype requested_worker_selectors:
         list[~azure.communication.jobrouter.models.RouterWorkerSelector]
        :keyword labels: A set of key/value pairs that are identifying attributes used by the rules
         engines to make decisions.
        :paramtype labels: dict[str, any]
        :keyword tags: A set of non-identifying attributes attached to this job.
        :paramtype tags: dict[str, any]
        :keyword notes: Notes attached to a job, sorted by timestamp.
        :paramtype notes: dict[str, str]
        :keyword matching_mode:
        :paramtype matching_mode: ~azure.communication.jobrouter.models.JobMatchingMode
        """
        super().__init__(**kwargs)
        self.id = None
        self.channel_reference = channel_reference
        self.status = None
        self.enqueued_at = None
        self.channel_id = channel_id
        self.classification_policy_id = classification_policy_id
        self.queue_id = queue_id
        self.priority = priority
        self.disposition_code = disposition_code
        self.requested_worker_selectors = requested_worker_selectors
        self.attached_worker_selectors = None
        self.labels = labels
        self.assignments = None
        self.tags = tags
        self.notes = notes
        self.scheduled_at = None
        self.matching_mode = matching_mode


class RouterJobAssignment(_serialization.Model):
    """Assignment details of a job to a worker.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The Id of the job assignment. Required.
    :vartype assignment_id: str
    :ivar worker_id: The Id of the Worker assigned to the job.
    :vartype worker_id: str
    :ivar assigned_at: The assignment time of the job in UTC. Required.
    :vartype assigned_at: ~datetime.datetime
    :ivar completed_at: The time the job was marked as completed after being assigned in UTC.
    :vartype completed_at: ~datetime.datetime
    :ivar closed_at: The time the job was marked as closed after being completed in UTC.
    :vartype closed_at: ~datetime.datetime
    """

    _validation = {
        "assignment_id": {"required": True, "min_length": 1},
        "assigned_at": {"required": True},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "worker_id": {"key": "workerId", "type": "str"},
        "assigned_at": {"key": "assignedAt", "type": "iso-8601"},
        "completed_at": {"key": "completedAt", "type": "iso-8601"},
        "closed_at": {"key": "closedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        assignment_id: str,
        assigned_at: datetime.datetime,
        worker_id: Optional[str] = None,
        completed_at: Optional[datetime.datetime] = None,
        closed_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword assignment_id: The Id of the job assignment. Required.
        :paramtype assignment_id: str
        :keyword worker_id: The Id of the Worker assigned to the job.
        :paramtype worker_id: str
        :keyword assigned_at: The assignment time of the job in UTC. Required.
        :paramtype assigned_at: ~datetime.datetime
        :keyword completed_at: The time the job was marked as completed after being assigned in UTC.
        :paramtype completed_at: ~datetime.datetime
        :keyword closed_at: The time the job was marked as closed after being completed in UTC.
        :paramtype closed_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.worker_id = worker_id
        self.assigned_at = assigned_at
        self.completed_at = completed_at
        self.closed_at = closed_at


class RouterJobCollection(_serialization.Model):
    """A paged collection of jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.RouterJobItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RouterJobItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RouterJobItem"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.RouterJobItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RouterJobItem(_serialization.Model):
    """Paged instance of RouterJob.

    :ivar job: A unit of work to be routed.
    :vartype job: ~azure.communication.jobrouter.models.RouterJob
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "job": {"key": "job", "type": "RouterJob"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, job: Optional["_models.RouterJob"] = None, etag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword job: A unit of work to be routed.
        :paramtype job: ~azure.communication.jobrouter.models.RouterJob
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.job = job
        self.etag = etag


class RouterJobOffer(_serialization.Model):
    """An offer of a job to a worker.

    All required parameters must be populated in order to send to Azure.

    :ivar offer_id: The Id of the offer. Required.
    :vartype offer_id: str
    :ivar job_id: The Id of the job. Required.
    :vartype job_id: str
    :ivar capacity_cost: The capacity cost consumed by the job offer. Required.
    :vartype capacity_cost: int
    :ivar offered_at: The time the offer was created in UTC.
    :vartype offered_at: ~datetime.datetime
    :ivar expires_at: The time that the offer will expire in UTC.
    :vartype expires_at: ~datetime.datetime
    """

    _validation = {
        "offer_id": {"required": True, "min_length": 1},
        "job_id": {"required": True, "min_length": 1},
        "capacity_cost": {"required": True},
    }

    _attribute_map = {
        "offer_id": {"key": "offerId", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "capacity_cost": {"key": "capacityCost", "type": "int"},
        "offered_at": {"key": "offeredAt", "type": "iso-8601"},
        "expires_at": {"key": "expiresAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        offer_id: str,
        job_id: str,
        capacity_cost: int,
        offered_at: Optional[datetime.datetime] = None,
        expires_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword offer_id: The Id of the offer. Required.
        :paramtype offer_id: str
        :keyword job_id: The Id of the job. Required.
        :paramtype job_id: str
        :keyword capacity_cost: The capacity cost consumed by the job offer. Required.
        :paramtype capacity_cost: int
        :keyword offered_at: The time the offer was created in UTC.
        :paramtype offered_at: ~datetime.datetime
        :keyword expires_at: The time that the offer will expire in UTC.
        :paramtype expires_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.offer_id = offer_id
        self.job_id = job_id
        self.capacity_cost = capacity_cost
        self.offered_at = offered_at
        self.expires_at = expires_at


class RouterJobPositionDetails(_serialization.Model):
    """Position and estimated wait time for a job.

    All required parameters must be populated in order to send to Azure.

    :ivar job_id: Id of the job these details are about. Required.
    :vartype job_id: str
    :ivar position: Position of the job in question within that queue. Required.
    :vartype position: int
    :ivar queue_id: Id of the queue this job is enqueued in. Required.
    :vartype queue_id: str
    :ivar queue_length: Length of the queue: total number of enqueued jobs. Required.
    :vartype queue_length: int
    :ivar estimated_wait_time_minutes: Estimated wait time of the job rounded up to the nearest
     minute. Required.
    :vartype estimated_wait_time_minutes: float
    """

    _validation = {
        "job_id": {"required": True, "min_length": 1},
        "position": {"required": True},
        "queue_id": {"required": True, "min_length": 1},
        "queue_length": {"required": True},
        "estimated_wait_time_minutes": {"required": True},
    }

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "position": {"key": "position", "type": "int"},
        "queue_id": {"key": "queueId", "type": "str"},
        "queue_length": {"key": "queueLength", "type": "int"},
        "estimated_wait_time_minutes": {"key": "estimatedWaitTimeMinutes", "type": "float"},
    }

    def __init__(
        self,
        *,
        job_id: str,
        position: int,
        queue_id: str,
        queue_length: int,
        estimated_wait_time_minutes: float,
        **kwargs: Any
    ) -> None:
        """
        :keyword job_id: Id of the job these details are about. Required.
        :paramtype job_id: str
        :keyword position: Position of the job in question within that queue. Required.
        :paramtype position: int
        :keyword queue_id: Id of the queue this job is enqueued in. Required.
        :paramtype queue_id: str
        :keyword queue_length: Length of the queue: total number of enqueued jobs. Required.
        :paramtype queue_length: int
        :keyword estimated_wait_time_minutes: Estimated wait time of the job rounded up to the nearest
         minute. Required.
        :paramtype estimated_wait_time_minutes: float
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.position = position
        self.queue_id = queue_id
        self.queue_length = queue_length
        self.estimated_wait_time_minutes = estimated_wait_time_minutes


class RouterQueue(_serialization.Model):
    """A queue that can contain jobs to be routed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Id of this queue.
    :vartype id: str
    :ivar name: The name of this queue.
    :vartype name: str
    :ivar distribution_policy_id: The ID of the distribution policy that will determine how a job
     is distributed to workers.
    :vartype distribution_policy_id: str
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions.
    :vartype labels: dict[str, any]
    :ivar exception_policy_id: (Optional) The ID of the exception policy that determines various
     job escalation rules.
    :vartype exception_policy_id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "distribution_policy_id": {"key": "distributionPolicyId", "type": "str"},
        "labels": {"key": "labels", "type": "{object}"},
        "exception_policy_id": {"key": "exceptionPolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        distribution_policy_id: Optional[str] = None,
        labels: Optional[Dict[str, Any]] = None,
        exception_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of this queue.
        :paramtype name: str
        :keyword distribution_policy_id: The ID of the distribution policy that will determine how a
         job is distributed to workers.
        :paramtype distribution_policy_id: str
        :keyword labels: A set of key/value pairs that are identifying attributes used by the rules
         engines to make decisions.
        :paramtype labels: dict[str, any]
        :keyword exception_policy_id: (Optional) The ID of the exception policy that determines various
         job escalation rules.
        :paramtype exception_policy_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.distribution_policy_id = distribution_policy_id
        self.labels = labels
        self.exception_policy_id = exception_policy_id


class RouterQueueCollection(_serialization.Model):
    """A paged collection of queues.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.RouterQueueItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RouterQueueItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RouterQueueItem"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.RouterQueueItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RouterQueueItem(_serialization.Model):
    """Paged instance of RouterQueue.

    :ivar queue: A queue that can contain jobs to be routed.
    :vartype queue: ~azure.communication.jobrouter.models.RouterQueue
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "queue": {"key": "queue", "type": "RouterQueue"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self, *, queue: Optional["_models.RouterQueue"] = None, etag: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword queue: A queue that can contain jobs to be routed.
        :paramtype queue: ~azure.communication.jobrouter.models.RouterQueue
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.queue = queue
        self.etag = etag


class RouterQueueSelector(_serialization.Model):
    """Describes a condition that must be met against a set of labels for queue selection.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value defined on
     the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
     "lessThanEqual", "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar value: The value to compare against the actual label value with the given operator.
    :vartype value: JSON
    """

    _validation = {
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        value: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value defined
         on the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
         "lessThanEqual", "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        :keyword value: The value to compare against the actual label value with the given operator.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.key = key
        self.label_operator = label_operator
        self.value = value


class RouterQueueStatistics(_serialization.Model):
    """Statistics for the queue.

    All required parameters must be populated in order to send to Azure.

    :ivar queue_id: Id of the queue these details are about. Required.
    :vartype queue_id: str
    :ivar length: Length of the queue: total number of enqueued jobs. Required.
    :vartype length: int
    :ivar estimated_wait_time_minutes: The estimated wait time of this queue rounded up to the
     nearest minute, grouped by job priority.
    :vartype estimated_wait_time_minutes: dict[str, float]
    :ivar longest_job_wait_time_minutes: The wait time of the job that has been enqueued in this
     queue for the longest.
    :vartype longest_job_wait_time_minutes: float
    """

    _validation = {
        "queue_id": {"required": True, "min_length": 1},
        "length": {"required": True},
    }

    _attribute_map = {
        "queue_id": {"key": "queueId", "type": "str"},
        "length": {"key": "length", "type": "int"},
        "estimated_wait_time_minutes": {"key": "estimatedWaitTimeMinutes", "type": "{float}"},
        "longest_job_wait_time_minutes": {"key": "longestJobWaitTimeMinutes", "type": "float"},
    }

    def __init__(
        self,
        *,
        queue_id: str,
        length: int,
        estimated_wait_time_minutes: Optional[Dict[str, float]] = None,
        longest_job_wait_time_minutes: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword queue_id: Id of the queue these details are about. Required.
        :paramtype queue_id: str
        :keyword length: Length of the queue: total number of enqueued jobs. Required.
        :paramtype length: int
        :keyword estimated_wait_time_minutes: The estimated wait time of this queue rounded up to the
         nearest minute, grouped by job priority.
        :paramtype estimated_wait_time_minutes: dict[str, float]
        :keyword longest_job_wait_time_minutes: The wait time of the job that has been enqueued in this
         queue for the longest.
        :paramtype longest_job_wait_time_minutes: float
        """
        super().__init__(**kwargs)
        self.queue_id = queue_id
        self.length = length
        self.estimated_wait_time_minutes = estimated_wait_time_minutes
        self.longest_job_wait_time_minutes = longest_job_wait_time_minutes


class RouterWorker(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """An entity for jobs to be routed to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar state: The current state of the worker. Known values are: "active", "draining", and
     "inactive".
    :vartype state: str or ~azure.communication.jobrouter.models.RouterWorkerState
    :ivar queue_assignments: The queue(s) that this worker can receive work from.
    :vartype queue_assignments: dict[str, JSON]
    :ivar total_capacity: The total capacity score this worker has to manage multiple concurrent
     jobs.
    :vartype total_capacity: int
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions.
    :vartype labels: dict[str, any]
    :ivar tags: A set of non-identifying attributes attached to this worker.
    :vartype tags: dict[str, any]
    :ivar channel_configurations: The channel(s) this worker can handle and their impact on the
     workers capacity.
    :vartype channel_configurations: dict[str,
     ~azure.communication.jobrouter.models.ChannelConfiguration]
    :ivar offers: A list of active offers issued to this worker.
    :vartype offers: list[~azure.communication.jobrouter.models.RouterJobOffer]
    :ivar assigned_jobs: A list of assigned jobs attached to this worker.
    :vartype assigned_jobs: list[~azure.communication.jobrouter.models.RouterWorkerAssignment]
    :ivar load_ratio: A value indicating the workers capacity. A value of '1' means all capacity is
     consumed. A value of '0' means no capacity is currently consumed.
    :vartype load_ratio: float
    :ivar available_for_offers: A flag indicating this worker is open to receive offers or not.
    :vartype available_for_offers: bool
    """

    _validation = {
        "id": {"readonly": True},
        "state": {"readonly": True},
        "offers": {"readonly": True},
        "assigned_jobs": {"readonly": True},
        "load_ratio": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "queue_assignments": {"key": "queueAssignments", "type": "{object}"},
        "total_capacity": {"key": "totalCapacity", "type": "int"},
        "labels": {"key": "labels", "type": "{object}"},
        "tags": {"key": "tags", "type": "{object}"},
        "channel_configurations": {"key": "channelConfigurations", "type": "{ChannelConfiguration}"},
        "offers": {"key": "offers", "type": "[RouterJobOffer]"},
        "assigned_jobs": {"key": "assignedJobs", "type": "[RouterWorkerAssignment]"},
        "load_ratio": {"key": "loadRatio", "type": "float"},
        "available_for_offers": {"key": "availableForOffers", "type": "bool"},
    }

    def __init__(
        self,
        *,
        queue_assignments: Optional[Dict[str, JSON]] = None,
        total_capacity: Optional[int] = None,
        labels: Optional[Dict[str, Any]] = None,
        tags: Optional[Dict[str, Any]] = None,
        channel_configurations: Optional[Dict[str, "_models.ChannelConfiguration"]] = None,
        available_for_offers: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword queue_assignments: The queue(s) that this worker can receive work from.
        :paramtype queue_assignments: dict[str, JSON]
        :keyword total_capacity: The total capacity score this worker has to manage multiple concurrent
         jobs.
        :paramtype total_capacity: int
        :keyword labels: A set of key/value pairs that are identifying attributes used by the rules
         engines to make decisions.
        :paramtype labels: dict[str, any]
        :keyword tags: A set of non-identifying attributes attached to this worker.
        :paramtype tags: dict[str, any]
        :keyword channel_configurations: The channel(s) this worker can handle and their impact on the
         workers capacity.
        :paramtype channel_configurations: dict[str,
         ~azure.communication.jobrouter.models.ChannelConfiguration]
        :keyword available_for_offers: A flag indicating this worker is open to receive offers or not.
        :paramtype available_for_offers: bool
        """
        super().__init__(**kwargs)
        self.id = None
        self.state = None
        self.queue_assignments = queue_assignments
        self.total_capacity = total_capacity
        self.labels = labels
        self.tags = tags
        self.channel_configurations = channel_configurations
        self.offers = None
        self.assigned_jobs = None
        self.load_ratio = None
        self.available_for_offers = available_for_offers


class RouterWorkerAssignment(_serialization.Model):
    """The assignment for a worker to a job.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The Id of the assignment. Required.
    :vartype assignment_id: str
    :ivar job_id: The Id of the Job assigned. Required.
    :vartype job_id: str
    :ivar capacity_cost: The amount of capacity this assignment has consumed on the worker.
     Required.
    :vartype capacity_cost: int
    :ivar assigned_at: The assignment time of the job in UTC. Required.
    :vartype assigned_at: ~datetime.datetime
    """

    _validation = {
        "assignment_id": {"required": True, "min_length": 1},
        "job_id": {"required": True, "min_length": 1},
        "capacity_cost": {"required": True},
        "assigned_at": {"required": True},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "capacity_cost": {"key": "capacityCost", "type": "int"},
        "assigned_at": {"key": "assignedAt", "type": "iso-8601"},
    }

    def __init__(
        self, *, assignment_id: str, job_id: str, capacity_cost: int, assigned_at: datetime.datetime, **kwargs: Any
    ) -> None:
        """
        :keyword assignment_id: The Id of the assignment. Required.
        :paramtype assignment_id: str
        :keyword job_id: The Id of the Job assigned. Required.
        :paramtype job_id: str
        :keyword capacity_cost: The amount of capacity this assignment has consumed on the worker.
         Required.
        :paramtype capacity_cost: int
        :keyword assigned_at: The assignment time of the job in UTC. Required.
        :paramtype assigned_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.job_id = job_id
        self.capacity_cost = capacity_cost
        self.assigned_at = assigned_at


class RouterWorkerCollection(_serialization.Model):
    """A paged collection of workers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.RouterWorkerItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RouterWorkerItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RouterWorkerItem"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.RouterWorkerItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RouterWorkerItem(_serialization.Model):
    """Paged instance of RouterWorker.

    :ivar worker: An entity for jobs to be routed to.
    :vartype worker: ~azure.communication.jobrouter.models.RouterWorker
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "worker": {"key": "worker", "type": "RouterWorker"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self, *, worker: Optional["_models.RouterWorker"] = None, etag: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword worker: An entity for jobs to be routed to.
        :paramtype worker: ~azure.communication.jobrouter.models.RouterWorker
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.worker = worker
        self.etag = etag


class RouterWorkerSelector(_serialization.Model):
    """Describes a condition that must be met against a set of labels for worker selection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value defined on
     the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
     "lessThanEqual", "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar value: The value to compare against the actual label value with the given operator.
    :vartype value: JSON
    :ivar expires_after_seconds: Describes how long this label selector is valid in seconds.
    :vartype expires_after_seconds: float
    :ivar expedite: Pushes the job to the front of the queue as long as this selector is active.
    :vartype expedite: bool
    :ivar status: The status of the worker selector. Known values are: "active" and "expired".
    :vartype status: str or ~azure.communication.jobrouter.models.RouterWorkerSelectorStatus
    :ivar expires_at: The time at which this worker selector expires in UTC.
    :vartype expires_at: ~datetime.datetime
    """

    _validation = {
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
        "status": {"readonly": True},
        "expires_at": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
        "value": {"key": "value", "type": "object"},
        "expires_after_seconds": {"key": "expiresAfterSeconds", "type": "float"},
        "expedite": {"key": "expedite", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "expires_at": {"key": "expiresAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        value: Optional[JSON] = None,
        expires_after_seconds: Optional[float] = None,
        expedite: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value defined
         on the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
         "lessThanEqual", "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        :keyword value: The value to compare against the actual label value with the given operator.
        :paramtype value: JSON
        :keyword expires_after_seconds: Describes how long this label selector is valid in seconds.
        :paramtype expires_after_seconds: float
        :keyword expedite: Pushes the job to the front of the queue as long as this selector is active.
        :paramtype expedite: bool
        """
        super().__init__(**kwargs)
        self.key = key
        self.label_operator = label_operator
        self.value = value
        self.expires_after_seconds = expires_after_seconds
        self.expedite = expedite
        self.status = None
        self.expires_at = None


class RuleEngineQueueSelectorAttachment(QueueSelectorAttachment):
    """Attaches queue selectors to a job when the RouterRule is resolved.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
    :vartype kind: str
    :ivar rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
     WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
     protocol. Required.
    :vartype rule: ~azure.communication.jobrouter.models.RouterRule
    """

    _validation = {
        "kind": {"required": True},
        "rule": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "rule": {"key": "rule", "type": "RouterRule"},
    }

    def __init__(self, *, rule: "_models.RouterRule", **kwargs: Any) -> None:
        """
        :keyword rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
         WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
         protocol. Required.
        :paramtype rule: ~azure.communication.jobrouter.models.RouterRule
        """
        super().__init__(**kwargs)
        self.kind: str = "rule-engine"
        self.rule = rule


class RuleEngineWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Attaches worker selectors to a job when a RouterRule is resolved.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
    :vartype kind: str
    :ivar rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
     WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
     protocol. Required.
    :vartype rule: ~azure.communication.jobrouter.models.RouterRule
    """

    _validation = {
        "kind": {"required": True},
        "rule": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "rule": {"key": "rule", "type": "RouterRule"},
    }

    def __init__(self, *, rule: "_models.RouterRule", **kwargs: Any) -> None:
        """
        :keyword rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
         WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
         protocol. Required.
        :paramtype rule: ~azure.communication.jobrouter.models.RouterRule
        """
        super().__init__(**kwargs)
        self.kind: str = "rule-engine"
        self.rule = rule


class ScheduleAndSuspendMode(_serialization.Model):
    """ScheduleAndSuspendMode.

    :ivar schedule_at:
    :vartype schedule_at: ~datetime.datetime
    """

    _attribute_map = {
        "schedule_at": {"key": "scheduleAt", "type": "iso-8601"},
    }

    def __init__(self, *, schedule_at: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword schedule_at:
        :paramtype schedule_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.schedule_at = schedule_at


class ScoringRuleOptions(_serialization.Model):
    """Encapsulates all options that can be passed as parameters for scoring rule with BestWorkerMode.

    :ivar batch_size: (Optional) Set batch size when AllowScoringBatchOfWorkers is set to true.
     Defaults to 20 if not configured.
    :vartype batch_size: int
    :ivar scoring_parameters: (Optional) List of extra parameters from the job that will be sent as
     part of the payload to scoring rule.
     If not set, the job's labels (sent in the payload as ``job``\ ) and the job's worker selectors
     (sent in the payload as ``selectors``\ )
     are added to the payload of the scoring rule by default.
     Note: Worker labels are always sent with scoring payload.
    :vartype scoring_parameters: list[str or
     ~azure.communication.jobrouter.models.ScoringRuleParameterSelector]
    :ivar allow_scoring_batch_of_workers: (Optional)
     If set to true, will score workers in batches, and the parameter name of the worker labels
     will be sent as ``workers``.
     By default, set to false and the parameter name for the worker labels will be sent as
     ``worker``.
     Note: If enabled, use BatchSize to set batch size.
    :vartype allow_scoring_batch_of_workers: bool
    :ivar descending_order: (Optional)
     If false, will sort scores by ascending order. By default, set to true.
    :vartype descending_order: bool
    """

    _attribute_map = {
        "batch_size": {"key": "batchSize", "type": "int"},
        "scoring_parameters": {"key": "scoringParameters", "type": "[str]"},
        "allow_scoring_batch_of_workers": {"key": "allowScoringBatchOfWorkers", "type": "bool"},
        "descending_order": {"key": "descendingOrder", "type": "bool"},
    }

    def __init__(
        self,
        *,
        batch_size: Optional[int] = None,
        scoring_parameters: Optional[List[Union[str, "_models.ScoringRuleParameterSelector"]]] = None,
        allow_scoring_batch_of_workers: Optional[bool] = None,
        descending_order: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword batch_size: (Optional) Set batch size when AllowScoringBatchOfWorkers is set to true.
         Defaults to 20 if not configured.
        :paramtype batch_size: int
        :keyword scoring_parameters: (Optional) List of extra parameters from the job that will be sent
         as part of the payload to scoring rule.
         If not set, the job's labels (sent in the payload as ``job``\ ) and the job's worker selectors
         (sent in the payload as ``selectors``\ )
         are added to the payload of the scoring rule by default.
         Note: Worker labels are always sent with scoring payload.
        :paramtype scoring_parameters: list[str or
         ~azure.communication.jobrouter.models.ScoringRuleParameterSelector]
        :keyword allow_scoring_batch_of_workers: (Optional)
         If set to true, will score workers in batches, and the parameter name of the worker labels
         will be sent as ``workers``.
         By default, set to false and the parameter name for the worker labels will be sent as
         ``worker``.
         Note: If enabled, use BatchSize to set batch size.
        :paramtype allow_scoring_batch_of_workers: bool
        :keyword descending_order: (Optional)
         If false, will sort scores by ascending order. By default, set to true.
        :paramtype descending_order: bool
        """
        super().__init__(**kwargs)
        self.batch_size = batch_size
        self.scoring_parameters = scoring_parameters
        self.allow_scoring_batch_of_workers = allow_scoring_batch_of_workers
        self.descending_order = descending_order


class StaticQueueSelectorAttachment(QueueSelectorAttachment):
    """Describes a queue selector that will be attached to the job.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
    :vartype kind: str
    :ivar queue_selector: Describes a condition that must be met against a set of labels for queue
     selection. Required.
    :vartype queue_selector: ~azure.communication.jobrouter.models.RouterQueueSelector
    """

    _validation = {
        "kind": {"required": True},
        "queue_selector": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "queue_selector": {"key": "queueSelector", "type": "RouterQueueSelector"},
    }

    def __init__(self, *, queue_selector: "_models.RouterQueueSelector", **kwargs: Any) -> None:
        """
        :keyword queue_selector: Describes a condition that must be met against a set of labels for
         queue selection. Required.
        :paramtype queue_selector: ~azure.communication.jobrouter.models.RouterQueueSelector
        """
        super().__init__(**kwargs)
        self.kind: str = "static"
        self.queue_selector = queue_selector


class StaticRule(RouterRule):
    """A rule providing static rules that always return the same result, regardless of input.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar value: The static value this rule always returns.
    :vartype value: JSON
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword value: The static value this rule always returns.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.kind: str = "static-rule"
        self.value = value


class StaticWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Describes a worker selector that will be attached to the job.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
    :vartype kind: str
    :ivar worker_selector: Describes a condition that must be met against a set of labels for
     worker selection. Required.
    :vartype worker_selector: ~azure.communication.jobrouter.models.RouterWorkerSelector
    """

    _validation = {
        "kind": {"required": True},
        "worker_selector": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "worker_selector": {"key": "workerSelector", "type": "RouterWorkerSelector"},
    }

    def __init__(self, *, worker_selector: "_models.RouterWorkerSelector", **kwargs: Any) -> None:
        """
        :keyword worker_selector: Describes a condition that must be met against a set of labels for
         worker selection. Required.
        :paramtype worker_selector: ~azure.communication.jobrouter.models.RouterWorkerSelector
        """
        super().__init__(**kwargs)
        self.kind: str = "static"
        self.worker_selector = worker_selector


class UnassignJobRequest(_serialization.Model):
    """Request payload for unassigning a job.

    :ivar suspend_matching: If WaitForActivation is true, then the job is not queued for
     re-matching with a worker.
    :vartype suspend_matching: bool
    """

    _attribute_map = {
        "suspend_matching": {"key": "suspendMatching", "type": "bool"},
    }

    def __init__(self, *, suspend_matching: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword suspend_matching: If WaitForActivation is true, then the job is not queued for
         re-matching with a worker.
        :paramtype suspend_matching: bool
        """
        super().__init__(**kwargs)
        self.suspend_matching = suspend_matching


class UnassignJobResult(_serialization.Model):
    """Response payload after a job has been successfully unassigned.

    All required parameters must be populated in order to send to Azure.

    :ivar job_id: The Id of the job unassigned. Required.
    :vartype job_id: str
    :ivar unassignment_count: The number of times a job is unassigned. At a maximum 3. Required.
    :vartype unassignment_count: int
    """

    _validation = {
        "job_id": {"required": True, "min_length": 1},
        "unassignment_count": {"required": True},
    }

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "unassignment_count": {"key": "unassignmentCount", "type": "int"},
    }

    def __init__(self, *, job_id: str, unassignment_count: int, **kwargs: Any) -> None:
        """
        :keyword job_id: The Id of the job unassigned. Required.
        :paramtype job_id: str
        :keyword unassignment_count: The number of times a job is unassigned. At a maximum 3. Required.
        :paramtype unassignment_count: int
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.unassignment_count = unassignment_count


class WaitTimeExceptionTrigger(ExceptionTrigger):
    """Trigger for an exception action on exceeding wait time.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
    :vartype kind: str
    :ivar threshold_seconds: Threshold for wait time for this trigger. Required.
    :vartype threshold_seconds: float
    """

    _validation = {
        "kind": {"required": True},
        "threshold_seconds": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "threshold_seconds": {"key": "thresholdSeconds", "type": "float"},
    }

    def __init__(self, *, threshold_seconds: float, **kwargs: Any) -> None:
        """
        :keyword threshold_seconds: Threshold for wait time for this trigger. Required.
        :paramtype threshold_seconds: float
        """
        super().__init__(**kwargs)
        self.kind: str = "wait-time"
        self.threshold_seconds = threshold_seconds


class WebhookRule(RouterRule):
    """A rule providing a binding to an external web server.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar authorization_server_uri: Uri for Authorization Server.
    :vartype authorization_server_uri: str
    :ivar client_credential: OAuth2.0 Credentials used to Contoso's Authorization server.
     Reference: https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/.
    :vartype client_credential: ~azure.communication.jobrouter.models.Oauth2ClientCredential
    :ivar webhook_uri: Uri for Contoso's Web Server.
    :vartype webhook_uri: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "authorization_server_uri": {"key": "authorizationServerUri", "type": "str"},
        "client_credential": {"key": "clientCredential", "type": "Oauth2ClientCredential"},
        "webhook_uri": {"key": "webhookUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        authorization_server_uri: Optional[str] = None,
        client_credential: Optional["_models.Oauth2ClientCredential"] = None,
        webhook_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorization_server_uri: Uri for Authorization Server.
        :paramtype authorization_server_uri: str
        :keyword client_credential: OAuth2.0 Credentials used to Contoso's Authorization server.
         Reference: https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/.
        :paramtype client_credential: ~azure.communication.jobrouter.models.Oauth2ClientCredential
        :keyword webhook_uri: Uri for Contoso's Web Server.
        :paramtype webhook_uri: str
        """
        super().__init__(**kwargs)
        self.kind: str = "webhook-rule"
        self.authorization_server_uri = authorization_server_uri
        self.client_credential = client_credential
        self.webhook_uri = webhook_uri


class WeightedAllocationQueueSelectorAttachment(QueueSelectorAttachment):
    """Describes multiple sets of queue selectors, of which one will be selected and attached
    according to a weighting.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
    :vartype kind: str
    :ivar allocations: A collection of percentage based weighted allocations. Required.
    :vartype allocations: list[~azure.communication.jobrouter.models.QueueWeightedAllocation]
    """

    _validation = {
        "kind": {"required": True},
        "allocations": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "allocations": {"key": "allocations", "type": "[QueueWeightedAllocation]"},
    }

    def __init__(self, *, allocations: List["_models.QueueWeightedAllocation"], **kwargs: Any) -> None:
        """
        :keyword allocations: A collection of percentage based weighted allocations. Required.
        :paramtype allocations: list[~azure.communication.jobrouter.models.QueueWeightedAllocation]
        """
        super().__init__(**kwargs)
        self.kind: str = "weighted-allocation-queue-selector"
        self.allocations = allocations


class WeightedAllocationWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Describes multiple sets of worker selectors, of which one will be selected and attached
    according to a weighting.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
    :vartype kind: str
    :ivar allocations: A collection of percentage based weighted allocations. Required.
    :vartype allocations: list[~azure.communication.jobrouter.models.WorkerWeightedAllocation]
    """

    _validation = {
        "kind": {"required": True},
        "allocations": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "allocations": {"key": "allocations", "type": "[WorkerWeightedAllocation]"},
    }

    def __init__(self, *, allocations: List["_models.WorkerWeightedAllocation"], **kwargs: Any) -> None:
        """
        :keyword allocations: A collection of percentage based weighted allocations. Required.
        :paramtype allocations: list[~azure.communication.jobrouter.models.WorkerWeightedAllocation]
        """
        super().__init__(**kwargs)
        self.kind: str = "weighted-allocation-worker-selector"
        self.allocations = allocations


class WorkerWeightedAllocation(_serialization.Model):
    """Contains the weight percentage and worker selectors to be applied if selected for weighted
    distributions.

    All required parameters must be populated in order to send to Azure.

    :ivar weight: The percentage of this weight, expressed as a fraction of 1. Required.
    :vartype weight: float
    :ivar worker_selectors: A collection of worker selectors that will be applied if this
     allocation is selected. Required.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    """

    _validation = {
        "weight": {"required": True},
        "worker_selectors": {"required": True},
    }

    _attribute_map = {
        "weight": {"key": "weight", "type": "float"},
        "worker_selectors": {"key": "workerSelectors", "type": "[RouterWorkerSelector]"},
    }

    def __init__(self, *, weight: float, worker_selectors: List["_models.RouterWorkerSelector"], **kwargs: Any) -> None:
        """
        :keyword weight: The percentage of this weight, expressed as a fraction of 1. Required.
        :paramtype weight: float
        :keyword worker_selectors: A collection of worker selectors that will be applied if this
         allocation is selected. Required.
        :paramtype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
        """
        super().__init__(**kwargs)
        self.weight = weight
        self.worker_selectors = worker_selectors
