# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._event_grid_management_client_enums import *


class AdvancedFilter(msrest.serialization.Model):
    """This is the base type that represents an advanced filter. To configure an advanced filter, do not directly instantiate an object of this class. Instead, instantiate an object of a derived class such as BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of the key based on which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BoolEqualsAdvancedFilter, IsNotNullAdvancedFilter, IsNullOrUndefinedAdvancedFilter, NumberGreaterThanAdvancedFilter, NumberGreaterThanOrEqualsAdvancedFilter, NumberInAdvancedFilter, NumberInRangeAdvancedFilter, NumberLessThanAdvancedFilter, NumberLessThanOrEqualsAdvancedFilter, NumberNotInAdvancedFilter, NumberNotInRangeAdvancedFilter, StringBeginsWithAdvancedFilter, StringContainsAdvancedFilter, StringEndsWithAdvancedFilter, StringInAdvancedFilter, StringNotBeginsWithAdvancedFilter, StringNotContainsAdvancedFilter, StringNotEndsWithAdvancedFilter, StringNotInAdvancedFilter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    _subtype_map = {
        'operator_type': {'BoolEquals': 'BoolEqualsAdvancedFilter', 'IsNotNull': 'IsNotNullAdvancedFilter', 'IsNullOrUndefined': 'IsNullOrUndefinedAdvancedFilter', 'NumberGreaterThan': 'NumberGreaterThanAdvancedFilter', 'NumberGreaterThanOrEquals': 'NumberGreaterThanOrEqualsAdvancedFilter', 'NumberIn': 'NumberInAdvancedFilter', 'NumberInRange': 'NumberInRangeAdvancedFilter', 'NumberLessThan': 'NumberLessThanAdvancedFilter', 'NumberLessThanOrEquals': 'NumberLessThanOrEqualsAdvancedFilter', 'NumberNotIn': 'NumberNotInAdvancedFilter', 'NumberNotInRange': 'NumberNotInRangeAdvancedFilter', 'StringBeginsWith': 'StringBeginsWithAdvancedFilter', 'StringContains': 'StringContainsAdvancedFilter', 'StringEndsWith': 'StringEndsWithAdvancedFilter', 'StringIn': 'StringInAdvancedFilter', 'StringNotBeginsWith': 'StringNotBeginsWithAdvancedFilter', 'StringNotContains': 'StringNotContainsAdvancedFilter', 'StringNotEndsWith': 'StringNotEndsWithAdvancedFilter', 'StringNotIn': 'StringNotInAdvancedFilter'}
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        **kwargs
    ):
        super(AdvancedFilter, self).__init__(**kwargs)
        self.operator_type = None  # type: Optional[str]
        self.key = key


class EventSubscriptionDestination(msrest.serialization.Model):
    """Information about the destination for an event subscription.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFunctionEventSubscriptionDestination, EventHubEventSubscriptionDestination, HybridConnectionEventSubscriptionDestination, ServiceBusQueueEventSubscriptionDestination, ServiceBusTopicEventSubscriptionDestination, StorageQueueEventSubscriptionDestination, WebHookEventSubscriptionDestination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'AzureFunction': 'AzureFunctionEventSubscriptionDestination', 'EventHub': 'EventHubEventSubscriptionDestination', 'HybridConnection': 'HybridConnectionEventSubscriptionDestination', 'ServiceBusQueue': 'ServiceBusQueueEventSubscriptionDestination', 'ServiceBusTopic': 'ServiceBusTopicEventSubscriptionDestination', 'StorageQueue': 'StorageQueueEventSubscriptionDestination', 'WebHook': 'WebHookEventSubscriptionDestination'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]


class AzureFunctionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the azure function destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Azure Function
     destination of an event subscription.
    :type resource_id: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        max_events_per_batch: Optional[int] = 1,
        preferred_batch_size_in_kilobytes: Optional[int] = 64,
        delivery_attribute_mappings: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(AzureFunctionEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'AzureFunction'  # type: str
        self.resource_id = resource_id
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.delivery_attribute_mappings = delivery_attribute_mappings


class BoolEqualsAdvancedFilter(AdvancedFilter):
    """BoolEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The boolean filter value.
    :type value: bool
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[bool] = None,
        **kwargs
    ):
        super(BoolEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'BoolEquals'  # type: str
        self.value = value


class ConnectionState(msrest.serialization.Model):
    """ConnectionState information.

    :param status: Status of the connection. Possible values include: "Pending", "Approved",
     "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.eventgrid.models.PersistedConnectionStatus
    :param description: Description of the connection state.
    :type description: str
    :param actions_required: Actions required (if any).
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PersistedConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class DeadLetterDestination(msrest.serialization.Model):
    """Information about the dead letter destination for an event subscription. To configure a deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an object of a derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StorageBlobDeadLetterDestination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the dead letter destination.Constant
     filled by server.  Possible values include: "StorageBlob".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'StorageBlob': 'StorageBlobDeadLetterDestination'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]


class DeadLetterWithResourceIdentity(msrest.serialization.Model):
    """Information about the deadletter destination with resource identity.

    :param identity: The identity to use when dead-lettering events.
    :type identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
    :param dead_letter_destination: Information about the destination where events have to be
     delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery / dead-lettering.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'EventSubscriptionIdentity'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(
        self,
        *,
        identity: Optional["EventSubscriptionIdentity"] = None,
        dead_letter_destination: Optional["DeadLetterDestination"] = None,
        **kwargs
    ):
        super(DeadLetterWithResourceIdentity, self).__init__(**kwargs)
        self.identity = identity
        self.dead_letter_destination = dead_letter_destination


class DeliveryAttributeListResult(msrest.serialization.Model):
    """Result of the Get delivery attributes operation.

    :param value: A collection of DeliveryAttributeMapping.
    :type value: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(DeliveryAttributeListResult, self).__init__(**kwargs)
        self.value = value


class DeliveryAttributeMapping(msrest.serialization.Model):
    """Delivery attribute mapping details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DynamicDeliveryAttributeMapping, StaticDeliveryAttributeMapping.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the delivery attribute or header.
    :type name: str
    :param type: Required. Type of the delivery attribute or header name.Constant filled by server.
     Possible values include: "Static", "Dynamic".
    :type type: str or ~azure.mgmt.eventgrid.models.DeliveryAttributeMappingType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Dynamic': 'DynamicDeliveryAttributeMapping', 'Static': 'StaticDeliveryAttributeMapping'}
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DeliveryAttributeMapping, self).__init__(**kwargs)
        self.name = name
        self.type = None  # type: Optional[str]


class DeliveryWithResourceIdentity(msrest.serialization.Model):
    """Information about the delivery for an event subscription with resource identity.

    :param identity: The identity to use when delivering events.
    :type identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'EventSubscriptionIdentity'},
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
    }

    def __init__(
        self,
        *,
        identity: Optional["EventSubscriptionIdentity"] = None,
        destination: Optional["EventSubscriptionDestination"] = None,
        **kwargs
    ):
        super(DeliveryWithResourceIdentity, self).__init__(**kwargs)
        self.identity = identity
        self.destination = destination


class Resource(msrest.serialization.Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """Definition of a Tracked Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class Domain(TrackedResource):
    """EventGrid Domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param sku: The Sku pricing tier for the domain.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to Domain resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the domain. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainProvisioningState
    :ivar endpoint: Endpoint for the domain.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should expect for incoming
     events published to the domain. Possible values include: "EventGridSchema",
     "CustomEventSchema", "CloudEventSchemaV1_0".
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: Information about the InputSchemaMapping which specified the info
     about mapping event payload.
    :type input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the domain.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ResourceSku"] = None,
        identity: Optional["IdentityInfo"] = None,
        input_schema: Optional[Union[str, "InputSchema"]] = None,
        input_schema_mapping: Optional["InputSchemaMapping"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(Domain, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.system_data = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class DomainRegenerateKeyRequest(msrest.serialization.Model):
    """Domain regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        super(DomainRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class DomainSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the Domain.

    :param key1: Shared access key1 for the domain.
    :type key1: str
    :param key2: Shared access key2 for the domain.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key1: Optional[str] = None,
        key2: Optional[str] = None,
        **kwargs
    ):
        super(DomainSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class DomainsListResult(msrest.serialization.Model):
    """Result of the List Domains operation.

    :param value: A collection of Domains.
    :type value: list[~azure.mgmt.eventgrid.models.Domain]
    :param next_link: A link for the next page of domains.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Domain"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DomainsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DomainTopic(Resource):
    """Domain Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to Domain Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the domain topic. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainTopicProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainTopic, self).__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None


class DomainTopicsListResult(msrest.serialization.Model):
    """Result of the List Domain Topics operation.

    :param value: A collection of Domain Topics.
    :type value: list[~azure.mgmt.eventgrid.models.DomainTopic]
    :param next_link: A link for the next page of domain topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainTopic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DomainTopic"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DomainTopicsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DomainUpdateParameters(msrest.serialization.Model):
    """Properties of the Domain update.

    :param tags: A set of tags. Tags of the domains resource.
    :type tags: dict[str, str]
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :param sku: The Sku pricing tier for the domain.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityInfo"] = None,
        sku: Optional["ResourceSku"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(DomainUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.sku = sku
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class DynamicDeliveryAttributeMapping(DeliveryAttributeMapping):
    """Dynamic delivery attribute mapping details.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the delivery attribute or header.
    :type name: str
    :param type: Required. Type of the delivery attribute or header name.Constant filled by server.
     Possible values include: "Static", "Dynamic".
    :type type: str or ~azure.mgmt.eventgrid.models.DeliveryAttributeMappingType
    :param source_field: JSON path in the event which contains attribute value.
    :type source_field: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'source_field': {'key': 'properties.sourceField', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        source_field: Optional[str] = None,
        **kwargs
    ):
        super(DynamicDeliveryAttributeMapping, self).__init__(name=name, **kwargs)
        self.type = 'Dynamic'  # type: str
        self.source_field = source_field


class EventChannel(Resource):
    """Event Channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to Event Channel resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :param source: Source of the event channel. This represents a unique resource in the partner's
     resource model.
    :type source: ~azure.mgmt.eventgrid.models.EventChannelSource
    :param destination: Represents the destination of an event channel.
    :type destination: ~azure.mgmt.eventgrid.models.EventChannelDestination
    :ivar provisioning_state: Provisioning state of the event channel. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.EventChannelProvisioningState
    :ivar partner_topic_readiness_state: The readiness state of the corresponding partner topic.
     Possible values include: "NotActivatedByUserYet", "ActivatedByUser", "DeactivatedByUser",
     "DeletedByUser".
    :vartype partner_topic_readiness_state: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicReadinessState
    :param expiration_time_if_not_activated_utc: Expiration time of the event channel. If this
     timer expires while the corresponding partner topic is never activated,
     the event channel and corresponding partner topic are deleted.
    :type expiration_time_if_not_activated_utc: ~datetime.datetime
    :param filter: Information about the filter for the event channel.
    :type filter: ~azure.mgmt.eventgrid.models.EventChannelFilter
    :param partner_topic_friendly_description: Friendly description about the topic. This can be
     set by the publisher/partner to show custom description for the customer partner topic.
     This will be helpful to remove any ambiguity of the origin of creation of the partner topic
     for the customer.
    :type partner_topic_friendly_description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'partner_topic_readiness_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'source': {'key': 'properties.source', 'type': 'EventChannelSource'},
        'destination': {'key': 'properties.destination', 'type': 'EventChannelDestination'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_topic_readiness_state': {'key': 'properties.partnerTopicReadinessState', 'type': 'str'},
        'expiration_time_if_not_activated_utc': {'key': 'properties.expirationTimeIfNotActivatedUtc', 'type': 'iso-8601'},
        'filter': {'key': 'properties.filter', 'type': 'EventChannelFilter'},
        'partner_topic_friendly_description': {'key': 'properties.partnerTopicFriendlyDescription', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: Optional["EventChannelSource"] = None,
        destination: Optional["EventChannelDestination"] = None,
        expiration_time_if_not_activated_utc: Optional[datetime.datetime] = None,
        filter: Optional["EventChannelFilter"] = None,
        partner_topic_friendly_description: Optional[str] = None,
        **kwargs
    ):
        super(EventChannel, self).__init__(**kwargs)
        self.system_data = None
        self.source = source
        self.destination = destination
        self.provisioning_state = None
        self.partner_topic_readiness_state = None
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc
        self.filter = filter
        self.partner_topic_friendly_description = partner_topic_friendly_description


class EventChannelDestination(msrest.serialization.Model):
    """Properties of the destination of an event channel.

    :param azure_subscription_id: Azure subscription ID of the customer creating the event channel.
     The partner topic
     associated with the event channel will be created under this Azure subscription.
    :type azure_subscription_id: str
    :param resource_group: Azure Resource Group of the customer creating the event channel. The
     partner topic
     associated with the event channel will be created under this resource group.
    :type resource_group: str
    :param partner_topic_name: Name of the partner topic associated with the event channel.
    :type partner_topic_name: str
    """

    _attribute_map = {
        'azure_subscription_id': {'key': 'azureSubscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'partner_topic_name': {'key': 'partnerTopicName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        partner_topic_name: Optional[str] = None,
        **kwargs
    ):
        super(EventChannelDestination, self).__init__(**kwargs)
        self.azure_subscription_id = azure_subscription_id
        self.resource_group = resource_group
        self.partner_topic_name = partner_topic_name


class EventChannelFilter(msrest.serialization.Model):
    """Filter for the Event Channel.

    :param enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against an
     array of values instead of expecting a singular value.
    :type enable_advanced_filtering_on_arrays: bool
    :param advanced_filters: An array of advanced filters that are used for filtering event
     channels.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'enable_advanced_filtering_on_arrays': {'key': 'enableAdvancedFilteringOnArrays', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(
        self,
        *,
        enable_advanced_filtering_on_arrays: Optional[bool] = None,
        advanced_filters: Optional[List["AdvancedFilter"]] = None,
        **kwargs
    ):
        super(EventChannelFilter, self).__init__(**kwargs)
        self.enable_advanced_filtering_on_arrays = enable_advanced_filtering_on_arrays
        self.advanced_filters = advanced_filters


class EventChannelsListResult(msrest.serialization.Model):
    """Result of the List Event Channels operation.

    :param value: A collection of Event Channels.
    :type value: list[~azure.mgmt.eventgrid.models.EventChannel]
    :param next_link: A link for the next page of event channels.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventChannel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventChannel"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EventChannelsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventChannelSource(msrest.serialization.Model):
    """Properties of the source of an event channel.

    :param source: The identifier of the resource that's the source of the events.
     This represents a unique resource in the partner's resource model.
    :type source: str
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        **kwargs
    ):
        super(EventChannelSource, self).__init__(**kwargs)
        self.source = source


class EventHubEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the event hub destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of an Event Hub
     destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(EventHubEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'EventHub'  # type: str
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class EventSubscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to Event Subscription resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar topic: Name of the topic of the event subscription.
    :vartype topic: str
    :ivar provisioning_state: Provisioning state of the event subscription. Possible values
     include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed",
     "AwaitingManualAction".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionProvisioningState
    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param delivery_with_resource_identity: Information about the destination where events have to
     be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery / dead-lettering.
    :type delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Expiration time of the event subscription.
    :type expiration_time_utc: ~datetime.datetime
    :param event_delivery_schema: The event delivery schema for the event subscription. Possible
     values include: "EventGridSchema", "CustomInputSchema", "CloudEventSchemaV1_0".
    :type event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The dead letter destination of the event subscription. Any
     event that cannot be delivered to its' destination is sent to the dead letter destination.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    :param dead_letter_with_resource_identity: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
     destination.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery / dead-lettering.
    :type dead_letter_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'topic': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'topic': {'key': 'properties.topic', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'EventSubscriptionDestination'},
        'delivery_with_resource_identity': {'key': 'properties.deliveryWithResourceIdentity', 'type': 'DeliveryWithResourceIdentity'},
        'filter': {'key': 'properties.filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'properties.expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'properties.eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'properties.retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'properties.deadLetterDestination', 'type': 'DeadLetterDestination'},
        'dead_letter_with_resource_identity': {'key': 'properties.deadLetterWithResourceIdentity', 'type': 'DeadLetterWithResourceIdentity'},
    }

    def __init__(
        self,
        *,
        destination: Optional["EventSubscriptionDestination"] = None,
        delivery_with_resource_identity: Optional["DeliveryWithResourceIdentity"] = None,
        filter: Optional["EventSubscriptionFilter"] = None,
        labels: Optional[List[str]] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        event_delivery_schema: Optional[Union[str, "EventDeliverySchema"]] = None,
        retry_policy: Optional["RetryPolicy"] = None,
        dead_letter_destination: Optional["DeadLetterDestination"] = None,
        dead_letter_with_resource_identity: Optional["DeadLetterWithResourceIdentity"] = None,
        **kwargs
    ):
        super(EventSubscription, self).__init__(**kwargs)
        self.system_data = None
        self.topic = None
        self.provisioning_state = None
        self.destination = destination
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination
        self.dead_letter_with_resource_identity = dead_letter_with_resource_identity


class EventSubscriptionFilter(msrest.serialization.Model):
    """Filter for the Event Subscription.

    :param subject_begins_with: An optional string to filter events for an event subscription based
     on a resource path prefix.
     The format of this depends on the publisher of the events.
     Wildcard characters are not supported in this path.
    :type subject_begins_with: str
    :param subject_ends_with: An optional string to filter events for an event subscription based
     on a resource path suffix.
     Wildcard characters are not supported in this path.
    :type subject_ends_with: str
    :param included_event_types: A list of applicable event types that need to be part of the event
     subscription. If it is desired to subscribe to all default event types, set the
     IncludedEventTypes to null.
    :type included_event_types: list[str]
    :param is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith
     properties of the filter
     should be compared in a case sensitive manner.
    :type is_subject_case_sensitive: bool
    :param enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against an
     array of values instead of expecting a singular value.
    :type enable_advanced_filtering_on_arrays: bool
    :param advanced_filters: An array of advanced filters that are used for filtering event
     subscriptions.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'subject_begins_with': {'key': 'subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'subjectEndsWith', 'type': 'str'},
        'included_event_types': {'key': 'includedEventTypes', 'type': '[str]'},
        'is_subject_case_sensitive': {'key': 'isSubjectCaseSensitive', 'type': 'bool'},
        'enable_advanced_filtering_on_arrays': {'key': 'enableAdvancedFilteringOnArrays', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(
        self,
        *,
        subject_begins_with: Optional[str] = None,
        subject_ends_with: Optional[str] = None,
        included_event_types: Optional[List[str]] = None,
        is_subject_case_sensitive: Optional[bool] = False,
        enable_advanced_filtering_on_arrays: Optional[bool] = None,
        advanced_filters: Optional[List["AdvancedFilter"]] = None,
        **kwargs
    ):
        super(EventSubscriptionFilter, self).__init__(**kwargs)
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.included_event_types = included_event_types
        self.is_subject_case_sensitive = is_subject_case_sensitive
        self.enable_advanced_filtering_on_arrays = enable_advanced_filtering_on_arrays
        self.advanced_filters = advanced_filters


class EventSubscriptionFullUrl(msrest.serialization.Model):
    """Full endpoint url of an event subscription.

    :param endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :type endpoint_url: str
    """

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint_url: Optional[str] = None,
        **kwargs
    ):
        super(EventSubscriptionFullUrl, self).__init__(**kwargs)
        self.endpoint_url = endpoint_url


class EventSubscriptionIdentity(msrest.serialization.Model):
    """The identity information with the event subscription.

    :param type: The type of managed identity used. The type 'SystemAssigned, UserAssigned'
     includes both an implicitly created identity and a set of user-assigned identities. The type
     'None' will remove any identity. Possible values include: "SystemAssigned", "UserAssigned".
    :type type: str or ~azure.mgmt.eventgrid.models.EventSubscriptionIdentityType
    :param user_assigned_identity: The user identity associated with the resource.
    :type user_assigned_identity: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "EventSubscriptionIdentityType"]] = None,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        super(EventSubscriptionIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identity = user_assigned_identity


class EventSubscriptionsListResult(msrest.serialization.Model):
    """Result of the List EventSubscriptions operation.

    :param value: A collection of EventSubscriptions.
    :type value: list[~azure.mgmt.eventgrid.models.EventSubscription]
    :param next_link: A link for the next page of event subscriptions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventSubscription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventSubscription"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EventSubscriptionsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventSubscriptionUpdateParameters(msrest.serialization.Model):
    """Properties of the Event Subscription update.

    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param delivery_with_resource_identity: Information about the destination where events have to
     be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (topic / domain) to acquire the
     authentication tokens being used during delivery / dead-lettering.
    :type delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Information about the expiration time for the event subscription.
    :type expiration_time_utc: ~datetime.datetime
    :param event_delivery_schema: The event delivery schema for the event subscription. Possible
     values include: "EventGridSchema", "CustomInputSchema", "CloudEventSchemaV1_0".
    :type event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The dead letter destination of the event subscription. Any
     event that cannot be delivered to its' destination is sent to the dead letter destination.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    :param dead_letter_with_resource_identity: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
     destination.
     Uses the managed identity setup on the parent resource (topic / domain) to acquire the
     authentication tokens being used during delivery / dead-lettering.
    :type dead_letter_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
        'delivery_with_resource_identity': {'key': 'deliveryWithResourceIdentity', 'type': 'DeliveryWithResourceIdentity'},
        'filter': {'key': 'filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
        'dead_letter_with_resource_identity': {'key': 'deadLetterWithResourceIdentity', 'type': 'DeadLetterWithResourceIdentity'},
    }

    def __init__(
        self,
        *,
        destination: Optional["EventSubscriptionDestination"] = None,
        delivery_with_resource_identity: Optional["DeliveryWithResourceIdentity"] = None,
        filter: Optional["EventSubscriptionFilter"] = None,
        labels: Optional[List[str]] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        event_delivery_schema: Optional[Union[str, "EventDeliverySchema"]] = None,
        retry_policy: Optional["RetryPolicy"] = None,
        dead_letter_destination: Optional["DeadLetterDestination"] = None,
        dead_letter_with_resource_identity: Optional["DeadLetterWithResourceIdentity"] = None,
        **kwargs
    ):
        super(EventSubscriptionUpdateParameters, self).__init__(**kwargs)
        self.destination = destination
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination
        self.dead_letter_with_resource_identity = dead_letter_with_resource_identity


class EventType(Resource):
    """Event Type for a subject under a topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param display_name: Display name of the event type.
    :type display_name: str
    :param description: Description of the event type.
    :type description: str
    :param schema_url: Url of the schema for this event type.
    :type schema_url: str
    :param is_in_default_set: IsInDefaultSet flag of the event type.
    :type is_in_default_set: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema_url': {'key': 'properties.schemaUrl', 'type': 'str'},
        'is_in_default_set': {'key': 'properties.isInDefaultSet', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        schema_url: Optional[str] = None,
        is_in_default_set: Optional[bool] = None,
        **kwargs
    ):
        super(EventType, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.schema_url = schema_url
        self.is_in_default_set = is_in_default_set


class EventTypesListResult(msrest.serialization.Model):
    """Result of the List Event Types operation.

    :param value: A collection of event types.
    :type value: list[~azure.mgmt.eventgrid.models.EventType]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventType]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventType"]] = None,
        **kwargs
    ):
        super(EventTypesListResult, self).__init__(**kwargs)
        self.value = value


class ExtendedLocation(msrest.serialization.Model):
    """Definition of an Extended Location.

    :param name: Fully qualified name of the extended location.
    :type name: str
    :param type: Type of the extended location.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = type


class ExtensionTopic(Resource):
    """Event grid Extension Topic. This is used for getting Event Grid related metrics for Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param description: Description of the extension topic.
    :type description: str
    :param system_topic: System topic resource id which is mapped to the source.
    :type system_topic: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'system_topic': {'key': 'properties.systemTopic', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        system_topic: Optional[str] = None,
        **kwargs
    ):
        super(ExtensionTopic, self).__init__(**kwargs)
        self.description = description
        self.system_topic = system_topic


class HybridConnectionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the HybridConnection destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource ID of an hybrid connection that is the destination of an
     event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(HybridConnectionEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'HybridConnection'  # type: str
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class IdentityInfo(msrest.serialization.Model):
    """The identity information for the resource.

    :param type: The type of managed identity used. The type 'SystemAssigned, UserAssigned'
     includes both an implicitly created identity and a set of user-assigned identities. The type
     'None' will remove any identity. Possible values include: "None", "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned".
    :type type: str or ~azure.mgmt.eventgrid.models.IdentityType
    :param principal_id: The principal ID of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant ID of resource.
    :type tenant_id: str
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     This property is currently not used and reserved for future usage.
    :type user_assigned_identities: dict[str, ~azure.mgmt.eventgrid.models.UserIdentityProperties]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IdentityType"]] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        user_assigned_identities: Optional[Dict[str, "UserIdentityProperties"]] = None,
        **kwargs
    ):
        super(IdentityInfo, self).__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.user_assigned_identities = user_assigned_identities


class InboundIpRule(msrest.serialization.Model):
    """InboundIpRule.

    :param ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
    :type ip_mask: str
    :param action: Action to perform based on the match or no match of the IpMask. Possible values
     include: "Allow".
    :type action: str or ~azure.mgmt.eventgrid.models.IpActionType
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "IpActionType"]] = None,
        **kwargs
    ):
        super(InboundIpRule, self).__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class InputSchemaMapping(msrest.serialization.Model):
    """By default, Event Grid expects events to be in the Event Grid event schema. Specifying an input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JsonInputSchemaMapping.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Type of the custom mapping.Constant filled by
     server.  Possible values include: "Json".
    :type input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
    }

    _subtype_map = {
        'input_schema_mapping_type': {'Json': 'JsonInputSchemaMapping'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = None  # type: Optional[str]


class IsNotNullAdvancedFilter(AdvancedFilter):
    """IsNotNull Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        **kwargs
    ):
        super(IsNotNullAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'IsNotNull'  # type: str


class IsNullOrUndefinedAdvancedFilter(AdvancedFilter):
    """IsNullOrUndefined Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        **kwargs
    ):
        super(IsNullOrUndefinedAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'IsNullOrUndefined'  # type: str


class JsonField(msrest.serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.

    :param source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :type source_field: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_field: Optional[str] = None,
        **kwargs
    ):
        super(JsonField, self).__init__(**kwargs)
        self.source_field = source_field


class JsonFieldWithDefault(msrest.serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field
in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
'eventtype' and 'dataversion' properties. This represents a field in the input event schema
along with a default value to be used, and at least one of these two properties should be provided.

    :param source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :type source_field: str
    :param default_value: The default value to be used for mapping when a SourceField is not
     provided or if there's no property with the specified name in the published JSON event payload.
    :type default_value: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_field: Optional[str] = None,
        default_value: Optional[str] = None,
        **kwargs
    ):
        super(JsonFieldWithDefault, self).__init__(**kwargs)
        self.source_field = source_field
        self.default_value = default_value


class JsonInputSchemaMapping(InputSchemaMapping):
    """This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Type of the custom mapping.Constant filled by
     server.  Possible values include: "Json".
    :type input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    :param id: The mapping information for the Id property of the Event Grid Event.
    :type id: ~azure.mgmt.eventgrid.models.JsonField
    :param topic: The mapping information for the Topic property of the Event Grid Event.
    :type topic: ~azure.mgmt.eventgrid.models.JsonField
    :param event_time: The mapping information for the EventTime property of the Event Grid Event.
    :type event_time: ~azure.mgmt.eventgrid.models.JsonField
    :param event_type: The mapping information for the EventType property of the Event Grid Event.
    :type event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param subject: The mapping information for the Subject property of the Event Grid Event.
    :type subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param data_version: The mapping information for the DataVersion property of the Event Grid
     Event.
    :type data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'JsonField'},
        'topic': {'key': 'properties.topic', 'type': 'JsonField'},
        'event_time': {'key': 'properties.eventTime', 'type': 'JsonField'},
        'event_type': {'key': 'properties.eventType', 'type': 'JsonFieldWithDefault'},
        'subject': {'key': 'properties.subject', 'type': 'JsonFieldWithDefault'},
        'data_version': {'key': 'properties.dataVersion', 'type': 'JsonFieldWithDefault'},
    }

    def __init__(
        self,
        *,
        id: Optional["JsonField"] = None,
        topic: Optional["JsonField"] = None,
        event_time: Optional["JsonField"] = None,
        event_type: Optional["JsonFieldWithDefault"] = None,
        subject: Optional["JsonFieldWithDefault"] = None,
        data_version: Optional["JsonFieldWithDefault"] = None,
        **kwargs
    ):
        super(JsonInputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = 'Json'  # type: str
        self.id = id
        self.topic = topic
        self.event_time = event_time
        self.event_type = event_type
        self.subject = subject
        self.data_version = data_version


class NumberGreaterThanAdvancedFilter(AdvancedFilter):
    """NumberGreaterThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberGreaterThanAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberGreaterThan'  # type: str
        self.value = value


class NumberGreaterThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberGreaterThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberGreaterThanOrEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberGreaterThanOrEquals'  # type: str
        self.value = value


class NumberInAdvancedFilter(AdvancedFilter):
    """NumberIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[float]] = None,
        **kwargs
    ):
        super(NumberInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberIn'  # type: str
        self.values = values


class NumberInRangeAdvancedFilter(AdvancedFilter):
    """NumberInRange Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[list[float]]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[[float]]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[List[float]]] = None,
        **kwargs
    ):
        super(NumberInRangeAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberInRange'  # type: str
        self.values = values


class NumberLessThanAdvancedFilter(AdvancedFilter):
    """NumberLessThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberLessThanAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberLessThan'  # type: str
        self.value = value


class NumberLessThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberLessThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberLessThanOrEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberLessThanOrEquals'  # type: str
        self.value = value


class NumberNotInAdvancedFilter(AdvancedFilter):
    """NumberNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[float]] = None,
        **kwargs
    ):
        super(NumberNotInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberNotIn'  # type: str
        self.values = values


class NumberNotInRangeAdvancedFilter(AdvancedFilter):
    """NumberNotInRange Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[list[float]]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[[float]]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[List[float]]] = None,
        **kwargs
    ):
        super(NumberNotInRangeAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberNotInRange'  # type: str
        self.values = values


class Operation(msrest.serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :param name: Name of the operation.
    :type name: str
    :param display: Display name of the operation.
    :type display: ~azure.mgmt.eventgrid.models.OperationInfo
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationInfo(msrest.serialization.Model):
    """Information about an operation.

    :param provider: Name of the provider.
    :type provider: str
    :param resource: Name of the resource type.
    :type resource: str
    :param operation: Name of the operation.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationInfo, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResult(msrest.serialization.Model):
    """Result of the List Operations operation.

    :param value: A collection of operations.
    :type value: list[~azure.mgmt.eventgrid.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = value


class PartnerNamespace(TrackedResource):
    """EventGrid Partner Namespace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :ivar system_data: The system metadata relating to Partner Namespace resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the partner namespace. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerNamespaceProvisioningState
    :param partner_registration_fully_qualified_id: The fully qualified ARM Id of the partner
     registration that should be associated with this partner namespace. This takes the following
     format:
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
    :type partner_registration_fully_qualified_id: str
    :ivar endpoint: Endpoint for the partner namespace.
    :vartype endpoint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_registration_fully_qualified_id': {'key': 'properties.partnerRegistrationFullyQualifiedId', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        partner_registration_fully_qualified_id: Optional[str] = None,
        **kwargs
    ):
        super(PartnerNamespace, self).__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.partner_registration_fully_qualified_id = partner_registration_fully_qualified_id
        self.endpoint = None


class PartnerNamespaceRegenerateKeyRequest(msrest.serialization.Model):
    """PartnerNamespace regenerate shared access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate (key1 or key2).
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        super(PartnerNamespaceRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class PartnerNamespaceSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the partner namespace.

    :param key1: Shared access key1 for the partner namespace.
    :type key1: str
    :param key2: Shared access key2 for the partner namespace.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key1: Optional[str] = None,
        key2: Optional[str] = None,
        **kwargs
    ):
        super(PartnerNamespaceSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class PartnerNamespacesListResult(msrest.serialization.Model):
    """Result of the List Partner Namespaces operation.

    :param value: A collection of partner namespaces.
    :type value: list[~azure.mgmt.eventgrid.models.PartnerNamespace]
    :param next_link: A link for the next page of partner namespaces.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PartnerNamespace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PartnerNamespace"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PartnerNamespacesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerNamespaceUpdateParameters(msrest.serialization.Model):
    """Properties of the PartnerNamespace update.

    :param tags: A set of tags. Tags of the partner namespace.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PartnerNamespaceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class PartnerRegistration(TrackedResource):
    """Information about a partner registration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :ivar system_data: The system metadata relating to Partner Registration resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the partner registration. Possible values
     include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerRegistrationProvisioningState
    :param partner_name: Official name of the partner name. For example: "Contoso".
    :type partner_name: str
    :param partner_resource_type_name: Name of the partner resource type.
    :type partner_resource_type_name: str
    :param partner_resource_type_display_name: Display name of the partner resource type.
    :type partner_resource_type_display_name: str
    :param partner_resource_type_description: Short description of the partner resource type. The
     length of this description should not exceed 256 characters.
    :type partner_resource_type_description: str
    :param long_description: Long description for the custom scenarios and integration to be
     displayed in the portal if needed.
     Length of this description should not exceed 2048 characters.
    :type long_description: str
    :param partner_customer_service_number: The customer service number of the publisher. The
     expected phone format should start with a '+' sign
     followed by the country code. The remaining digits are then followed. Only digits and spaces
     are allowed and its
     length cannot exceed 16 digits including country code. Examples of valid phone numbers are: +1
     515 123 4567 and
     +966 7 5115 2471. Examples of invalid phone numbers are: +1 (515) 123-4567, 1 515 123 4567 and
     +966 121 5115 24 7 551 1234 43.
    :type partner_customer_service_number: str
    :param partner_customer_service_extension: The extension of the customer service number of the
     publisher. Only digits are allowed and number of digits should not exceed 10.
    :type partner_customer_service_extension: str
    :param customer_service_uri: The extension of the customer service URI of the publisher.
    :type customer_service_uri: str
    :param setup_uri: URI of the partner website that can be used by Azure customers to setup Event
     Grid
     integration on an event source.
    :type setup_uri: str
    :param logo_uri: URI of the logo.
    :type logo_uri: str
    :param visibility_state: Visibility state of the partner registration. Possible values include:
     "Hidden", "PublicPreview", "GenerallyAvailable".
    :type visibility_state: str or ~azure.mgmt.eventgrid.models.PartnerRegistrationVisibilityState
    :param authorized_azure_subscription_ids: List of Azure subscription Ids that are authorized to
     create a partner namespace
     associated with this partner registration. This is an optional property. Creating
     partner namespaces is always permitted under the same Azure subscription as the one used
     for creating the partner registration.
    :type authorized_azure_subscription_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_name': {'key': 'properties.partnerName', 'type': 'str'},
        'partner_resource_type_name': {'key': 'properties.partnerResourceTypeName', 'type': 'str'},
        'partner_resource_type_display_name': {'key': 'properties.partnerResourceTypeDisplayName', 'type': 'str'},
        'partner_resource_type_description': {'key': 'properties.partnerResourceTypeDescription', 'type': 'str'},
        'long_description': {'key': 'properties.longDescription', 'type': 'str'},
        'partner_customer_service_number': {'key': 'properties.partnerCustomerServiceNumber', 'type': 'str'},
        'partner_customer_service_extension': {'key': 'properties.partnerCustomerServiceExtension', 'type': 'str'},
        'customer_service_uri': {'key': 'properties.customerServiceUri', 'type': 'str'},
        'setup_uri': {'key': 'properties.setupUri', 'type': 'str'},
        'logo_uri': {'key': 'properties.logoUri', 'type': 'str'},
        'visibility_state': {'key': 'properties.visibilityState', 'type': 'str'},
        'authorized_azure_subscription_ids': {'key': 'properties.authorizedAzureSubscriptionIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        partner_name: Optional[str] = None,
        partner_resource_type_name: Optional[str] = None,
        partner_resource_type_display_name: Optional[str] = None,
        partner_resource_type_description: Optional[str] = None,
        long_description: Optional[str] = None,
        partner_customer_service_number: Optional[str] = None,
        partner_customer_service_extension: Optional[str] = None,
        customer_service_uri: Optional[str] = None,
        setup_uri: Optional[str] = None,
        logo_uri: Optional[str] = None,
        visibility_state: Optional[Union[str, "PartnerRegistrationVisibilityState"]] = None,
        authorized_azure_subscription_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(PartnerRegistration, self).__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.partner_name = partner_name
        self.partner_resource_type_name = partner_resource_type_name
        self.partner_resource_type_display_name = partner_resource_type_display_name
        self.partner_resource_type_description = partner_resource_type_description
        self.long_description = long_description
        self.partner_customer_service_number = partner_customer_service_number
        self.partner_customer_service_extension = partner_customer_service_extension
        self.customer_service_uri = customer_service_uri
        self.setup_uri = setup_uri
        self.logo_uri = logo_uri
        self.visibility_state = visibility_state
        self.authorized_azure_subscription_ids = authorized_azure_subscription_ids


class PartnerRegistrationEventTypesListResult(msrest.serialization.Model):
    """Result of the List Partner Registration Event Types operation.

    :param value: A collection of partner registration event types.
    :type value: list[~azure.mgmt.eventgrid.models.EventType]
    :param next_link: A link for the next page of partner registration event types.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventType"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PartnerRegistrationEventTypesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerRegistrationsListResult(msrest.serialization.Model):
    """Result of the List Partner Registrations operation.

    :param value: A collection of partner registrations.
    :type value: list[~azure.mgmt.eventgrid.models.PartnerRegistration]
    :param next_link: A link for the next page of partner registrations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PartnerRegistration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PartnerRegistration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PartnerRegistrationsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerRegistrationUpdateParameters(msrest.serialization.Model):
    """Properties of the Partner Registration update.

    :param tags: A set of tags. Tags of the partner registration resource.
    :type tags: dict[str, str]
    :param partner_topic_type_name: Name of the partner topic type.
    :type partner_topic_type_name: str
    :param partner_topic_type_display_name: Display name of the partner topic type.
    :type partner_topic_type_display_name: str
    :param partner_topic_type_description: Description of the partner topic type.
    :type partner_topic_type_description: str
    :param setup_uri: URI of the partner website that can be used by Azure customers to setup Event
     Grid
     integration on an event source.
    :type setup_uri: str
    :param logo_uri: URI of the partner logo.
    :type logo_uri: str
    :param authorized_azure_subscription_ids: List of IDs of Azure AD applications that are
     authorized to create a partner namespace
     associated with this partner registration. This is an optional property. Creating
     partner namespaces is always permitted under the same Azure subscription as the one used
     for creating the partner registration.
    :type authorized_azure_subscription_ids: list[str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'partner_topic_type_name': {'key': 'partnerTopicTypeName', 'type': 'str'},
        'partner_topic_type_display_name': {'key': 'partnerTopicTypeDisplayName', 'type': 'str'},
        'partner_topic_type_description': {'key': 'partnerTopicTypeDescription', 'type': 'str'},
        'setup_uri': {'key': 'setupUri', 'type': 'str'},
        'logo_uri': {'key': 'logoUri', 'type': 'str'},
        'authorized_azure_subscription_ids': {'key': 'authorizedAzureSubscriptionIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        partner_topic_type_name: Optional[str] = None,
        partner_topic_type_display_name: Optional[str] = None,
        partner_topic_type_description: Optional[str] = None,
        setup_uri: Optional[str] = None,
        logo_uri: Optional[str] = None,
        authorized_azure_subscription_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(PartnerRegistrationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.partner_topic_type_name = partner_topic_type_name
        self.partner_topic_type_display_name = partner_topic_type_display_name
        self.partner_topic_type_description = partner_topic_type_description
        self.setup_uri = setup_uri
        self.logo_uri = logo_uri
        self.authorized_azure_subscription_ids = authorized_azure_subscription_ids


class PartnerTopic(TrackedResource):
    """EventGrid Partner Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to Partner Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :param source: Source associated with this partner topic. This represents a unique partner
     resource.
    :type source: str
    :param expiration_time_if_not_activated_utc: Expiration time of the partner topic. If this
     timer expires while the partner topic is still never activated,
     the partner topic and corresponding event channel are deleted.
    :type expiration_time_if_not_activated_utc: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the partner topic. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.PartnerTopicProvisioningState
    :param activation_state: Activation state of the partner topic. Possible values include:
     "NeverActivated", "Activated", "Deactivated".
    :type activation_state: str or ~azure.mgmt.eventgrid.models.PartnerTopicActivationState
    :param partner_topic_friendly_description: Friendly description about the topic. This can be
     set by the publisher/partner to show custom description for the customer partner topic.
     This will be helpful to remove any ambiguity of the origin of creation of the partner topic
     for the customer.
    :type partner_topic_friendly_description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'expiration_time_if_not_activated_utc': {'key': 'properties.expirationTimeIfNotActivatedUtc', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'activation_state': {'key': 'properties.activationState', 'type': 'str'},
        'partner_topic_friendly_description': {'key': 'properties.partnerTopicFriendlyDescription', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityInfo"] = None,
        source: Optional[str] = None,
        expiration_time_if_not_activated_utc: Optional[datetime.datetime] = None,
        activation_state: Optional[Union[str, "PartnerTopicActivationState"]] = None,
        partner_topic_friendly_description: Optional[str] = None,
        **kwargs
    ):
        super(PartnerTopic, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.system_data = None
        self.source = source
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc
        self.provisioning_state = None
        self.activation_state = activation_state
        self.partner_topic_friendly_description = partner_topic_friendly_description


class PartnerTopicsListResult(msrest.serialization.Model):
    """Result of the List Partner Topics operation.

    :param value: A collection of partner topics.
    :type value: list[~azure.mgmt.eventgrid.models.PartnerTopic]
    :param next_link: A link for the next page of partner topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PartnerTopic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PartnerTopic"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PartnerTopicsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerTopicType(Resource):
    """Properties of a partner topic type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param partner_name: Official name of the partner.
    :type partner_name: str
    :param topic_type_name: Name of the partner topic type. This name should be unique among all
     partner topic types names.
    :type topic_type_name: str
    :param display_name: Display Name for the partner topic type.
    :type display_name: str
    :param description: Description of the partner topic type.
    :type description: str
    :param setup_uri: URI of the partner website that can be used by Azure customers to setup Event
     Grid
     integration on an event source.
    :type setup_uri: str
    :param authorization_state: Status of whether the customer has authorized a partner to create
     partner topics
     in the customer's subscription. Possible values include: "NotApplicable", "NotAuthorized",
     "Authorized".
    :type authorization_state: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicTypeAuthorizationState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'partner_name': {'key': 'properties.partnerName', 'type': 'str'},
        'topic_type_name': {'key': 'properties.topicTypeName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'setup_uri': {'key': 'properties.setupUri', 'type': 'str'},
        'authorization_state': {'key': 'properties.authorizationState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        partner_name: Optional[str] = None,
        topic_type_name: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        setup_uri: Optional[str] = None,
        authorization_state: Optional[Union[str, "PartnerTopicTypeAuthorizationState"]] = None,
        **kwargs
    ):
        super(PartnerTopicType, self).__init__(**kwargs)
        self.partner_name = partner_name
        self.topic_type_name = topic_type_name
        self.display_name = display_name
        self.description = description
        self.setup_uri = setup_uri
        self.authorization_state = authorization_state


class PartnerTopicTypesListResult(msrest.serialization.Model):
    """Result of the List Partner Topic Types operation.

    :param value: A collection of partner topic types.
    :type value: list[~azure.mgmt.eventgrid.models.PartnerTopicType]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PartnerTopicType]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PartnerTopicType"]] = None,
        **kwargs
    ):
        super(PartnerTopicTypesListResult, self).__init__(**kwargs)
        self.value = value


class PartnerTopicUpdateParameters(msrest.serialization.Model):
    """Properties of the Partner Topic update.

    :param tags: A set of tags. Tags of the partner topic.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PartnerTopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class PrivateEndpoint(msrest.serialization.Model):
    """PrivateEndpoint information.

    :param id: The ARM identifier for Private Endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Resource):
    """PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param private_endpoint: The Private Endpoint resource for this Connection.
    :type private_endpoint: ~azure.mgmt.eventgrid.models.PrivateEndpoint
    :param group_ids: GroupIds from the private link service resource.
    :type group_ids: list[str]
    :param private_link_service_connection_state: Details about the state of the connection.
    :type private_link_service_connection_state: ~azure.mgmt.eventgrid.models.ConnectionState
    :param provisioning_state: Provisioning state of the Private Endpoint Connection. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "ResourceProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :param value: A collection of private endpoint connection resources.
    :type value: list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :param next_link: A link for the next page of private endpoint connection resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(msrest.serialization.Model):
    """Information of the private link resource.

    :param id: Fully qualified identifier of the resource.
    :type id: str
    :param name: Name of the resource.
    :type name: str
    :param type: Type of the resource.
    :type type: str
    :param group_id:
    :type group_id: str
    :param display_name:
    :type display_name: str
    :param required_members:
    :type required_members: list[str]
    :param required_zone_names:
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        display_name: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.display_name = display_name
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(msrest.serialization.Model):
    """Result of the List private link resources operation.

    :param value: A collection of private link resources.
    :type value: list[~azure.mgmt.eventgrid.models.PrivateLinkResource]
    :param next_link: A link for the next page of private link resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSku(msrest.serialization.Model):
    """Describes an EventGrid Resource Sku.

    :param name: The Sku name of the resource. The possible values are: Basic or Premium. Possible
     values include: "Basic", "Premium". Default value: "Basic".
    :type name: str or ~azure.mgmt.eventgrid.models.Sku
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "Sku"]] = "Basic",
        **kwargs
    ):
        super(ResourceSku, self).__init__(**kwargs)
        self.name = name


class RetryPolicy(msrest.serialization.Model):
    """Information about the retry policy for an event subscription.

    :param max_delivery_attempts: Maximum number of delivery retry attempts for events.
    :type max_delivery_attempts: int
    :param event_time_to_live_in_minutes: Time To Live (in minutes) for events.
    :type event_time_to_live_in_minutes: int
    """

    _attribute_map = {
        'max_delivery_attempts': {'key': 'maxDeliveryAttempts', 'type': 'int'},
        'event_time_to_live_in_minutes': {'key': 'eventTimeToLiveInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_delivery_attempts: Optional[int] = 30,
        event_time_to_live_in_minutes: Optional[int] = 1440,
        **kwargs
    ):
        super(RetryPolicy, self).__init__(**kwargs)
        self.max_delivery_attempts = max_delivery_attempts
        self.event_time_to_live_in_minutes = event_time_to_live_in_minutes


class ServiceBusQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Service Bus
     destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(ServiceBusQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'ServiceBusQueue'  # type: str
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class ServiceBusTopicEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus topic destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Service Bus Topic
     destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(ServiceBusTopicEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'ServiceBusTopic'  # type: str
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class StaticDeliveryAttributeMapping(DeliveryAttributeMapping):
    """Static delivery attribute mapping details.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the delivery attribute or header.
    :type name: str
    :param type: Required. Type of the delivery attribute or header name.Constant filled by server.
     Possible values include: "Static", "Dynamic".
    :type type: str or ~azure.mgmt.eventgrid.models.DeliveryAttributeMappingType
    :param value: Value of the delivery attribute.
    :type value: str
    :param is_secret: Boolean flag to tell if the attribute contains sensitive information .
    :type is_secret: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'is_secret': {'key': 'properties.isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        is_secret: Optional[bool] = None,
        **kwargs
    ):
        super(StaticDeliveryAttributeMapping, self).__init__(name=name, **kwargs)
        self.type = 'Static'  # type: str
        self.value = value
        self.is_secret = is_secret


class StorageBlobDeadLetterDestination(DeadLetterDestination):
    """Information about the storage blob based dead letter destination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the dead letter destination.Constant
     filled by server.  Possible values include: "StorageBlob".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    :param resource_id: The Azure Resource ID of the storage account that is the destination of the
     deadletter events.
    :type resource_id: str
    :param blob_container_name: The name of the Storage blob container that is the destination of
     the deadletter events.
    :type blob_container_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'blob_container_name': {'key': 'properties.blobContainerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        blob_container_name: Optional[str] = None,
        **kwargs
    ):
        super(StorageBlobDeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = 'StorageBlob'  # type: str
        self.resource_id = resource_id
        self.blob_container_name = blob_container_name


class StorageQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the storage queue destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource ID of the storage account that contains the queue that
     is the destination of an event subscription.
    :type resource_id: str
    :param queue_name: The name of the Storage queue under a storage account that is the
     destination of an event subscription.
    :type queue_name: str
    :param queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
    :type queue_message_time_to_live_in_seconds: long
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'queue_name': {'key': 'properties.queueName', 'type': 'str'},
        'queue_message_time_to_live_in_seconds': {'key': 'properties.queueMessageTimeToLiveInSeconds', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        queue_name: Optional[str] = None,
        queue_message_time_to_live_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(StorageQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'StorageQueue'  # type: str
        self.resource_id = resource_id
        self.queue_name = queue_name
        self.queue_message_time_to_live_in_seconds = queue_message_time_to_live_in_seconds


class StringBeginsWithAdvancedFilter(AdvancedFilter):
    """StringBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringBeginsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringBeginsWith'  # type: str
        self.values = values


class StringContainsAdvancedFilter(AdvancedFilter):
    """StringContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringContainsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringContains'  # type: str
        self.values = values


class StringEndsWithAdvancedFilter(AdvancedFilter):
    """StringEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringEndsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringEndsWith'  # type: str
        self.values = values


class StringInAdvancedFilter(AdvancedFilter):
    """StringIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringIn'  # type: str
        self.values = values


class StringNotBeginsWithAdvancedFilter(AdvancedFilter):
    """StringNotBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringNotBeginsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringNotBeginsWith'  # type: str
        self.values = values


class StringNotContainsAdvancedFilter(AdvancedFilter):
    """StringNotContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringNotContainsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringNotContains'  # type: str
        self.values = values


class StringNotEndsWithAdvancedFilter(AdvancedFilter):
    """StringNotEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringNotEndsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringNotEndsWith'  # type: str
        self.values = values


class StringNotInAdvancedFilter(AdvancedFilter):
    """StringNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains", "NumberInRange", "NumberNotInRange", "StringNotBeginsWith",
     "StringNotEndsWith", "StringNotContains", "IsNullOrUndefined", "IsNotNull".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringNotInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringNotIn'  # type: str
        self.values = values


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemTopic(TrackedResource):
    """EventGrid System Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to System Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the system topic. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    :param source: Source for the system topic.
    :type source: str
    :param topic_type: TopicType for the system topic.
    :type topic_type: str
    :ivar metric_resource_id: Metric resource id for the system topic.
    :vartype metric_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'topic_type': {'key': 'properties.topicType', 'type': 'str'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityInfo"] = None,
        source: Optional[str] = None,
        topic_type: Optional[str] = None,
        **kwargs
    ):
        super(SystemTopic, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.system_data = None
        self.provisioning_state = None
        self.source = source
        self.topic_type = topic_type
        self.metric_resource_id = None


class SystemTopicsListResult(msrest.serialization.Model):
    """Result of the List System topics operation.

    :param value: A collection of system Topics.
    :type value: list[~azure.mgmt.eventgrid.models.SystemTopic]
    :param next_link: A link for the next page of topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SystemTopic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SystemTopic"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SystemTopicsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemTopicUpdateParameters(msrest.serialization.Model):
    """Properties of the System Topic update.

    :param tags: A set of tags. Tags of the system topic.
    :type tags: dict[str, str]
    :param identity: Resource identity information.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityInfo"] = None,
        **kwargs
    ):
        super(SystemTopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class Topic(TrackedResource):
    """EventGrid Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param sku: The Sku pricing tier for the topic.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :param kind: Kind of the resource. Possible values include: "Azure", "AzureArc".
    :type kind: str or ~azure.mgmt.eventgrid.models.ResourceKind
    :param extended_location: Extended location of the resource.
    :type extended_location: ~azure.mgmt.eventgrid.models.ExtendedLocation
    :ivar system_data: The system metadata relating to Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar private_endpoint_connections:
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the topic. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicProvisioningState
    :ivar endpoint: Endpoint for the topic.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should expect for incoming
     events published to the topic. Possible values include: "EventGridSchema", "CustomEventSchema",
     "CloudEventSchemaV1_0".
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: This enables publishing using custom event schemas. An
     InputSchemaMapping can be specified to map various properties of a source schema to various
     required properties of the EventGridEvent schema.
    :type input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the topic.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'kind': {'key': 'kind', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ResourceSku"] = None,
        identity: Optional["IdentityInfo"] = None,
        kind: Optional[Union[str, "ResourceKind"]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        input_schema: Optional[Union[str, "InputSchema"]] = None,
        input_schema_mapping: Optional["InputSchemaMapping"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(Topic, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.kind = kind
        self.extended_location = extended_location
        self.system_data = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class TopicRegenerateKeyRequest(msrest.serialization.Model):
    """Topic regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        super(TopicRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class TopicSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the Topic.

    :param key1: Shared access key1 for the topic.
    :type key1: str
    :param key2: Shared access key2 for the topic.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key1: Optional[str] = None,
        key2: Optional[str] = None,
        **kwargs
    ):
        super(TopicSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class TopicsListResult(msrest.serialization.Model):
    """Result of the List Topics operation.

    :param value: A collection of Topics.
    :type value: list[~azure.mgmt.eventgrid.models.Topic]
    :param next_link: A link for the next page of topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Topic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Topic"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(TopicsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TopicTypeInfo(Resource):
    """Properties of a topic type info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provider: Namespace of the provider of the topic type.
    :type provider: str
    :param display_name: Display Name for the topic type.
    :type display_name: str
    :param description: Description of the topic type.
    :type description: str
    :param resource_region_type: Region type of the resource. Possible values include:
     "RegionalResource", "GlobalResource".
    :type resource_region_type: str or ~azure.mgmt.eventgrid.models.ResourceRegionType
    :param provisioning_state: Provisioning state of the topic type. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
    :param supported_locations: List of locations supported by this topic type.
    :type supported_locations: list[str]
    :param source_resource_format: Source resource format.
    :type source_resource_format: str
    :param supported_scopes_for_source: Supported source scopes.
    :type supported_scopes_for_source: list[str or
     ~azure.mgmt.eventgrid.models.TopicTypePropertiesSupportedScopesForSourceItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_region_type': {'key': 'properties.resourceRegionType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'supported_locations': {'key': 'properties.supportedLocations', 'type': '[str]'},
        'source_resource_format': {'key': 'properties.sourceResourceFormat', 'type': 'str'},
        'supported_scopes_for_source': {'key': 'properties.supportedScopesForSource', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        resource_region_type: Optional[Union[str, "ResourceRegionType"]] = None,
        provisioning_state: Optional[Union[str, "TopicTypeProvisioningState"]] = None,
        supported_locations: Optional[List[str]] = None,
        source_resource_format: Optional[str] = None,
        supported_scopes_for_source: Optional[List[Union[str, "TopicTypePropertiesSupportedScopesForSourceItem"]]] = None,
        **kwargs
    ):
        super(TopicTypeInfo, self).__init__(**kwargs)
        self.provider = provider
        self.display_name = display_name
        self.description = description
        self.resource_region_type = resource_region_type
        self.provisioning_state = provisioning_state
        self.supported_locations = supported_locations
        self.source_resource_format = source_resource_format
        self.supported_scopes_for_source = supported_scopes_for_source


class TopicTypesListResult(msrest.serialization.Model):
    """Result of the List Topic Types operation.

    :param value: A collection of topic types.
    :type value: list[~azure.mgmt.eventgrid.models.TopicTypeInfo]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopicTypeInfo]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TopicTypeInfo"]] = None,
        **kwargs
    ):
        super(TopicTypesListResult, self).__init__(**kwargs)
        self.value = value


class TopicUpdateParameters(msrest.serialization.Model):
    """Properties of the Topic update.

    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param identity: Resource identity information.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :param sku: The Sku pricing tier for the topic.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityInfo"] = None,
        sku: Optional["ResourceSku"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(TopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.sku = sku
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class UserIdentityProperties(msrest.serialization.Model):
    """The information about the user identity.

    :param principal_id: The principal id of user assigned identity.
    :type principal_id: str
    :param client_id: The client id of user assigned identity.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.client_id = client_id


class WebHookEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the webhook destination for an event subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :type endpoint_url: str
    :ivar endpoint_base_url: The base URL that represents the endpoint of the destination of an
     event subscription.
    :vartype endpoint_base_url: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    :param azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access
     token that will be included as the bearer token in delivery requests.
    :type azure_active_directory_tenant_id: str
    :param azure_active_directory_application_id_or_uri: The Azure Active Directory Application ID
     or URI to get the access token that will be included as the bearer token in delivery requests.
    :type azure_active_directory_application_id_or_uri: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
        'endpoint_base_url': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_url': {'key': 'properties.endpointUrl', 'type': 'str'},
        'endpoint_base_url': {'key': 'properties.endpointBaseUrl', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'azure_active_directory_tenant_id': {'key': 'properties.azureActiveDirectoryTenantId', 'type': 'str'},
        'azure_active_directory_application_id_or_uri': {'key': 'properties.azureActiveDirectoryApplicationIdOrUri', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(
        self,
        *,
        endpoint_url: Optional[str] = None,
        max_events_per_batch: Optional[int] = 1,
        preferred_batch_size_in_kilobytes: Optional[int] = 64,
        azure_active_directory_tenant_id: Optional[str] = None,
        azure_active_directory_application_id_or_uri: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["DeliveryAttributeMapping"]] = None,
        **kwargs
    ):
        super(WebHookEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'WebHook'  # type: str
        self.endpoint_url = endpoint_url
        self.endpoint_base_url = None
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.azure_active_directory_tenant_id = azure_active_directory_tenant_id
        self.azure_active_directory_application_id_or_uri = azure_active_directory_application_id_or_uri
        self.delivery_attribute_mappings = delivery_attribute_mappings
