/* Copyright (c) 1997-2021
   Ewgenij Gawrilow, Michael Joswig, and the polymake team
   Technische Universität Berlin, Germany
   https://polymake.org

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version: http://www.gnu.org/licenses/gpl.txt.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
--------------------------------------------------------------------------------
*/

package de.tuberlin.polymake.graph;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SpringEmbedderAnimationPanel extends JPanel {

	/** autogenerated ID for serialization */
	private static final long serialVersionUID = 4483041565568619063L;

	protected ButtonGroup stepGroup = new ButtonGroup();

	protected JButton stopButton = new JButton("Stop");

	protected JRadioButton noneRadioButton = new JRadioButton("none");
	
	protected JSpinner delaySpinner;
	
	protected String delay = "50";
	
	public SpringEmbedderAnimationPanel() {
		super();
		setLayout(new GridBagLayout());
		GridBagConstraints c1 = new GridBagConstraints();
		c1.insets = new Insets(1,1,1,1);
		c1.fill = GridBagConstraints.BOTH;
		c1.anchor = GridBagConstraints.WEST;
		c1.weightx = 1.0;
		c1.gridwidth = 1;
		
		GridBagConstraints c2 = new GridBagConstraints();
		c2.insets = new Insets(1,1,1,1);
		c2.fill = GridBagConstraints.BOTH;
		c2.anchor = GridBagConstraints.WEST;
		c2.weightx = 1.0;
		c2.gridwidth = GridBagConstraints.REMAINDER;
		
		add(new JLabel("AnimationSteps"),c1);
		noneRadioButton.setSelected(true);
		noneRadioButton.setActionCommand("none");
		stepGroup.add(noneRadioButton);
		add(noneRadioButton,c1);
		JRadioButton rButton = new JRadioButton("1");
		stepGroup.add(rButton);
		rButton.setActionCommand("1");
		add(rButton,c1);
		rButton = new JRadioButton("5");
		stepGroup.add(rButton);
		rButton.setActionCommand("5");
		add(rButton,c1);
		rButton = new JRadioButton("10");
		stepGroup.add(rButton);
		rButton.setActionCommand("10");
		add(rButton,c1);
		rButton = new JRadioButton("50");
		stepGroup.add(rButton);
		rButton.setActionCommand("50");
		add(rButton,c1);
		add(stopButton);
		JPanel delayPanel = new JPanel(new GridBagLayout());
		JLabel delayLabel = new JLabel("Delay");
		delayPanel.add(delayLabel, c1);
		SpinnerNumberModel delayModel = new SpinnerNumberModel(50,0,1000,10);
		delaySpinner = new JSpinner(delayModel);
		delaySpinner.setPreferredSize(new Dimension(50,20));
		delayPanel.add(delaySpinner,c2);
		add(delayPanel,c2);
	}

	public String getStepValue() {

		if (stepGroup.getSelection() == null
				|| stepGroup.getSelection().getActionCommand().equals("none")) {
			return "0";
		} else {
			return stepGroup.getSelection().getActionCommand();
		}
	}

	public void resetStepValue() {
		noneRadioButton.setSelected(true);
	}
	
	public void addStopButtonListener(ActionListener al) {
		stopButton.addActionListener(al);
	}

	/**
	 * Enable or disable the stop button of the animation panel.
	 * @param autoRecompute
	 */
	public void setStopButtonEnabled(boolean autoRecompute) {
		stopButton.setEnabled(autoRecompute);
	}

	public void setDelay(String val) {
		delaySpinner.setValue(Integer.parseInt(val));
	}

	public String getDelay() {
		return delaySpinner.getValue().toString();
	}
}
