/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

public final class ZipShort
implements Cloneable {
    private int value;

    public ZipShort(int value) {
        this.value = value;
    }

    public ZipShort(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipShort(byte[] bytes, int offset) {
        this.value = ZipShort.convert(bytes, offset);
    }

    public byte[] getBytes() {
        return ZipShort.bytes(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)o).getValue();
    }

    public int hashCode() {
        return this.value;
    }

    static int convert(byte[] bytes) {
        return ZipShort.convert(bytes, 0);
    }

    static int convert(byte[] bytes, int offset) {
        int value = bytes[offset + 1] << 8 & 0xFF00;
        return value += bytes[offset] & 0xFF;
    }

    static byte[] bytes(int value) {
        return ZipShort.bytes(value, new byte[2]);
    }

    static byte[] bytes(int value, byte[] result) {
        result[0] = (byte)(value & 0xFF);
        result[1] = (byte)((value & 0xFF00) >> 8);
        return result;
    }
}

