#! /usr/bin/perl -w

use strict;
use warnings;

use CGI;

package main;

require 'Functions/parser.pl';
require 'Functions/web.pl';

our $cgi = '';	# CGI data
our %conf = ();	#

$conf{'extension'} = '.pl';

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

our $PageTitle = ' - LML .rules editor';
ParseComponent( 'CommonHeader' );

  # Import CGI parameters :
$cgi = CGI->new();

ParseComponent( 'rules' );

if ( $cgi->param( 'ruleset' ) and $cgi->param( 'syslog' ) )
{
	print "&nbsp;<b>test results :</b><br><br>";

	if ( $cgi->param( 'ruleset' ) =~ m/^regex=([^;]*)([^\\]);/m )
	{
		my $match = $1.$2;
		print "regex=$match<br><br>\n";

		$match =~ s/\$IP/[\\dA-Fa-f\\:\\.]+/g;
		$match =~ s/\$PID/-?\\d+/g;
		$match =~ s/\$HOSTNAME/[\\w\\-\\.]+/g;
		$match =~ s/\$PORT/\\d+/g;
		print "regex=$match<br><br>\n";

		foreach my $Line ( split( /\n/m, $cgi->param( 'syslog' ) ) )
		{
			$Line =~ s/\r//g;
			if ( my @elt = ( $Line =~ m/$match/ ) )
			{
				print "$Line<br>\n";

				my $cnt = 1;
				foreach my $Elt ( @elt )
				{
					print "&nbsp;&nbsp;\$$cnt = $Elt<br>\n";
					$cnt ++;
				}
			}
			else
			{
				print "<font color=red>$Line</font><br>";
			}
		}
	}
}

ParseComponent( 'CommonFooter' );
