#ifndef COMMANDLINEPACKAGEDB_H
#define COMMANDLINEPACKAGEDB_H

#include "iprovider.h"
#include "ipackagedb.h"
#include "ipackage.h"
#include "packagedetails.h"

namespace NApt {

class CommandLinePackageDB : public IPackageDB
{
    map<QString, unique_ptr<const IPackage>> _packages;
public:
    CommandLinePackageDB(const NPlugin::IProvider& provider, NUtil::IProgressObserver& observer);
    const IPackage& getPackageRecord(const QString &pkg) const override;
    const IPackage& getPackageRecord(const string &package) const override;
    PackageDetails getPackageDetails(const string& name) const override;
    const QString getShortDescription(const string &package) const override;
    IPackage::InstalledState getState(const string &package) const override;
    void reloadPackageInformation(NUtil::IProgressObserver *pObserver) override;
};

}

#endif // COMMANDLINEPACKAGEDB_H
