﻿open System
open System.Diagnostics
open System.IO
open FSharp.Compiler.CodeAnalysis
open FSharp.Compiler.Text
open BenchmarkDotNet.Attributes
open BenchmarkDotNet.Running
open FSharp.Benchmarks.Common.Categories

module Project =
    let nugetCache =
        let ps = ProcessStartInfo("dotnet", "nuget locals global-packages -l")
        ps.RedirectStandardOutput <- true
        ps.RedirectStandardError <- true
        let p = Process.Start ps
        let stdout = p.StandardOutput.ReadToEnd().Trim()
        p.WaitForExit()
        stdout.Replace("global-packages:", "").Trim()

    let FSharpCore =
        let projectOptions =
            { ProjectFileName = __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\FSharp.Core.fsproj"
              ProjectId = None
              SourceFiles =
                [| __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\prim-types-prelude.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\prim-types-prelude.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Core\Debug\netstandard2.1\FSCore.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Core\Debug\netstandard2.1\FSharp.Core.AssemblyInfo.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\prim-types.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\prim-types.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\local.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\local.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\array2.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\array2.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\option.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\option.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\result.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\result.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\collections.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\collections.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\seqcore.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\seqcore.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\seq.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\seq.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\string.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\string.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\list.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\list.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\array.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\array.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\array3.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\array3.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\map.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\map.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\set.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\set.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\reflect.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\reflect.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\math\z.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\math\z.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\sformat.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\sformat.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\printf.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\printf.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\quotations.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\quotations.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\nativeptr.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\nativeptr.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\event.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\event.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\resumable.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\resumable.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\async.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\async.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\tasks.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\tasks.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\eventmodule.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\eventmodule.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\observable.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\observable.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\mailbox.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\mailbox.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\Nullable.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\Nullable.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\Linq.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\Linq.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\MutableTuple.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\QueryExtensions.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\Query.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\Query.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\SI.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\fslib-extra-pervasives.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.Core\fslib-extra-pervasives.fs" |]
              OtherOptions =
                [| sprintf "-o:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\obj\FSharp.Core\Debug\netstandard2.1\FSharp.Core.dll"
                   @"-g"
                   @"--debug:embedded"
                   @"--langversion:preview"
                   @"--noframework"
                   @"--define:TRACE"
                   @"--define:FSHARP_CORE"
                   @"--define:DEBUG"
                   @"--define:NETSTANDARD"
                   @"--define:FX_NO_WINFORMS"
                   @"--define:NETSTANDARD"
                   @"--define:NETSTANDARD2_1"
                   @"--define:NETSTANDARD1_0_OR_GREATER"
                   @"--define:NETSTANDARD1_1_OR_GREATER"
                   @"--define:NETSTANDARD1_2_OR_GREATER"
                   @"--define:NETSTANDARD1_3_OR_GREATER"
                   @"--define:NETSTANDARD1_4_OR_GREATER"
                   @"--define:NETSTANDARD1_5_OR_GREATER"
                   @"--define:NETSTANDARD1_6_OR_GREATER"
                   @"--define:NETSTANDARD2_0_OR_GREATER"
                   @"--define:NETSTANDARD2_1_OR_GREATER"
                   sprintf "-doc:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\obj\FSharp.Core\Debug\netstandard2.1\FSharp.Core.xml"
                   @"--publicsign+"
                   @"--optimize-"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\Microsoft.Win32.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\mscorlib.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\netstandard.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.AppContext.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Buffers.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Collections.Concurrent.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Collections.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Collections.NonGeneric.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Collections.Specialized.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ComponentModel.Composition.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ComponentModel.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ComponentModel.EventBasedAsync.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ComponentModel.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ComponentModel.TypeConverter.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Console.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Core.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Data.Common.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Data.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.Contracts.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.Debug.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.FileVersionInfo.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.Process.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.StackTrace.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.TextWriterTraceListener.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.Tools.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.TraceSource.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Diagnostics.Tracing.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Drawing.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Drawing.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Dynamic.Runtime.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Globalization.Calendars.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Globalization.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Globalization.Extensions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.Compression.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.Compression.FileSystem.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.Compression.ZipFile.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.FileSystem.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.FileSystem.DriveInfo.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.FileSystem.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.FileSystem.Watcher.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.IsolatedStorage.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.MemoryMappedFiles.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.Pipes.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.IO.UnmanagedMemoryStream.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Linq.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Linq.Expressions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Linq.Parallel.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Linq.Queryable.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Memory.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.Http.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.NameResolution.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.NetworkInformation.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.Ping.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.Requests.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.Security.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.Sockets.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.WebHeaderCollection.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.WebSockets.Client.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Net.WebSockets.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Numerics.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Numerics.Vectors.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ObjectModel.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.DispatchProxy.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.Emit.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.Emit.ILGeneration.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.Emit.Lightweight.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.Extensions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Reflection.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Resources.Reader.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Resources.ResourceManager.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Resources.Writer.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.CompilerServices.VisualC.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Extensions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Handles.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.InteropServices.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.InteropServices.RuntimeInformation.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Numerics.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Serialization.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Serialization.Formatters.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Serialization.Json.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Serialization.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Runtime.Serialization.Xml.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Claims.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Cryptography.Algorithms.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Cryptography.Csp.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Cryptography.Encoding.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Cryptography.Primitives.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Cryptography.X509Certificates.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.Principal.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Security.SecureString.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ServiceModel.Web.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Text.Encoding.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Text.Encoding.Extensions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Text.RegularExpressions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.Overlapped.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.Tasks.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.Tasks.Extensions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.Tasks.Parallel.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.Thread.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.ThreadPool.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Threading.Timer.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Transactions.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.ValueTuple.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Web.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Windows.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.Linq.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.ReaderWriter.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.Serialization.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.XDocument.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.XmlDocument.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.XmlSerializer.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.XPath.dll"
                   sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\.dotnet\packs\NETStandard.Library.Ref\2.1.0\ref\netstandard2.1\System.Xml.XPath.XDocument.dll"
                   @"--target:library"
                   @"--nowarn:FS2003,62,75,1204,NU5105"
                   @"--warn:3"
                   @"--warnaserror:3239,1182,0025"
                   @"--fullpaths"
                   @"--flaterrors"
                   @"--highentropyva+"
                   @"--targetprofile:netstandard"
                   @"--nocopyfsharpcore"
                   @"--deterministic+"
                   @"--simpleresolution"
                   @"--nowarn:3384"
                   @"--warnon:3218"
                   @"--warnon:1182"
                   @"--warnon:3390"
                   @"--warnon:3520"
                   @"--warnon:1182"
                   @"--warnon:3390"
                   @"--nowarn:57"
                   @"--nowarn:3511"
                   @"--nowarn:3513"
                   @"--compiling-fslib"
                   @"--compiling-fslib-40"
                   @"--maxerrors:100"
                   @"--extraoptimizationloops:1"
                   @"--simpleresolution" |]
              ReferencedProjects = [||]
              IsIncompleteTypeCheckEnvironment = false
              UseScriptResolutionRules = false
              LoadTime = DateTime.Now
              UnresolvedReferences = None
              OriginalLoadReferences = []
              Stamp = None }

        FSharpReferencedProject.FSharpReference(
            __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\bin\FSharp.Core\Debug\netstandard2.1\FSharp.Core.dll",
            projectOptions
        )
    
    let FSharpDependencyManagerNuget =
        let projectOptions =
            { ProjectFileName = __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.DependencyManager.Nuget\FSharp.DependencyManager.Nuget.fsproj"
              ProjectId = None
              SourceFiles =
                [| __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSDependencyManager.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\UtilsStrings.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSharp.DependencyManager.Nuget.InternalsVisibleTo.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSharp.DependencyManager.Nuget.AssemblyInfo.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\CompilerLocation.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\CompilerLocation.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.DependencyManager.Nuget\FSharp.DependencyManager.ProjectFile.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.DependencyManager.Nuget\FSharp.DependencyManager.Utilities.fs"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.DependencyManager.Nuget\FSharp.DependencyManager.fsi"
                   __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\FSharp.DependencyManager.Nuget\FSharp.DependencyManager.fs" |]
              OtherOptions =
                [| sprintf "-o:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\obj\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSharp.DependencyManager.Nuget.dll"
                   @"-g"
                   @"--debug:embedded"
                   @"--noframework"
                   @"--define:TRACE"
                   @"--define:COMPILER"
                   @"--define:DEBUG"
                   @"--define:NETSTANDARD"
                   @"--define:FX_NO_WINFORMS"
                   @"--define:NETSTANDARD"
                   @"--define:NETSTANDARD2_0"
                   @"--define:NETSTANDARD1_0_OR_GREATER"
                   @"--define:NETSTANDARD1_1_OR_GREATER"
                   @"--define:NETSTANDARD1_2_OR_GREATER"
                   @"--define:NETSTANDARD1_3_OR_GREATER"
                   @"--define:NETSTANDARD1_4_OR_GREATER"
                   @"--define:NETSTANDARD1_5_OR_GREATER"
                   @"--define:NETSTANDARD1_6_OR_GREATER"
                   @"--define:NETSTANDARD2_0_OR_GREATER"
                   sprintf "-doc:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\obj\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSharp.DependencyManager.Nuget.xml"
                   @"--publicsign+"
                   @"--optimize-"
                   sprintf "-r:%s%s" nugetCache @"fsharp.core\6.0.1\lib\netstandard2.0\FSharp.Core.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\Microsoft.Win32.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\mscorlib.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\netstandard.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.AppContext.dll"
                   sprintf "-r:%s%s" nugetCache @"system.buffers\4.5.1\ref\netstandard2.0\System.Buffers.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Collections.Concurrent.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Collections.dll"
                   sprintf "-r:%s%s" nugetCache @"system.collections.immutable\5.0.0\lib\netstandard2.0\System.Collections.Immutable.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Collections.NonGeneric.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Collections.Specialized.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ComponentModel.Composition.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ComponentModel.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ComponentModel.EventBasedAsync.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ComponentModel.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ComponentModel.TypeConverter.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Console.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Core.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Data.Common.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Data.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.Contracts.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.Debug.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.FileVersionInfo.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.Process.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.StackTrace.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.TextWriterTraceListener.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.Tools.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.TraceSource.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Diagnostics.Tracing.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Drawing.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Drawing.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Dynamic.Runtime.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Globalization.Calendars.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Globalization.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Globalization.Extensions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.Compression.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.Compression.FileSystem.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.Compression.ZipFile.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.FileSystem.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.FileSystem.DriveInfo.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.FileSystem.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.FileSystem.Watcher.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.IsolatedStorage.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.MemoryMappedFiles.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.Pipes.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.IO.UnmanagedMemoryStream.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Linq.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Linq.Expressions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Linq.Parallel.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Linq.Queryable.dll"
                   sprintf "-r:%s%s" nugetCache @"system.memory\4.5.4\lib\netstandard2.0\System.Memory.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.Http.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.NameResolution.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.NetworkInformation.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.Ping.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.Requests.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.Security.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.Sockets.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.WebHeaderCollection.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.WebSockets.Client.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Net.WebSockets.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Numerics.dll"
                   sprintf "-r:%s%s" nugetCache @"system.numerics.vectors\4.4.0\ref\netstandard2.0\System.Numerics.Vectors.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ObjectModel.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Reflection.dll"
                   sprintf "-r:%s%s" nugetCache @"system.reflection.emit\4.3.0\ref\netstandard1.1\System.Reflection.Emit.dll"
                   sprintf "-r:%s%s" nugetCache @"system.reflection.emit.ilgeneration\4.3.0\ref\netstandard1.0\System.Reflection.Emit.ILGeneration.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Reflection.Extensions.dll"
                   sprintf "-r:%s%s" nugetCache @"system.reflection.metadata\5.0.0\lib\netstandard2.0\System.Reflection.Metadata.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Reflection.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"system.reflection.typeextensions\4.3.0\ref\netstandard1.5\System.Reflection.TypeExtensions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Resources.Reader.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Resources.ResourceManager.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Resources.Writer.dll"
                   sprintf "-r:%s%s" nugetCache @"system.runtime.compilerservices.unsafe\6.0.0\lib\netstandard2.0\System.Runtime.CompilerServices.Unsafe.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.CompilerServices.VisualC.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Extensions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Handles.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.InteropServices.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.InteropServices.RuntimeInformation.dll"
                   sprintf "-r:%s%s" nugetCache @"system.runtime.loader\4.3.0\ref\netstandard1.5\System.Runtime.Loader.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Numerics.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Serialization.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Serialization.Formatters.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Serialization.Json.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Serialization.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Runtime.Serialization.Xml.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Claims.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Cryptography.Algorithms.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Cryptography.Csp.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Cryptography.Encoding.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Cryptography.Primitives.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Cryptography.X509Certificates.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.Principal.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Security.SecureString.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ServiceModel.Web.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Text.Encoding.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Text.Encoding.Extensions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Text.RegularExpressions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.Overlapped.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.Tasks.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.Tasks.Parallel.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.Thread.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.ThreadPool.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Threading.Timer.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Transactions.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.ValueTuple.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Web.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Windows.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.Linq.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.ReaderWriter.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.Serialization.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.XDocument.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.XmlDocument.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.XmlSerializer.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.XPath.dll"
                   sprintf "-r:%s%s" nugetCache @"netstandard.library\2.0.3\build\netstandard2.0\ref\System.Xml.XPath.XDocument.dll"
                   @"--target:library"
                   @"--nowarn:FS2003,NU5105"
                   @"--warn:3"
                   @"--warnaserror:3239,1182,0025"
                   @"--fullpaths"
                   @"--flaterrors"
                   @"--highentropyva+"
                   @"--targetprofile:netstandard"
                   @"--nocopyfsharpcore"
                   @"--deterministic+"
                   @"--simpleresolution"
                   @"--nowarn:3384"
                   @"--warnon:1182"
                   @"--simpleresolution" |]
              ReferencedProjects = [| FSharpCore |]
              IsIncompleteTypeCheckEnvironment = false
              UseScriptResolutionRules = false
              LoadTime = DateTime.Now
              UnresolvedReferences = None
              OriginalLoadReferences = []
              Stamp = None }

        FSharpReferencedProject.FSharpReference(
            __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\bin\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSharp.DependencyManager.Nuget.dll",
            projectOptions
        )
        
    let FSharpCompilerService =
        { ProjectFileName = __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\FSharp.Compiler.Service.fsproj"
          ProjectId = None
          SourceFiles =
            [| __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\FSComp.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\FSIstrings.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\UtilsStrings.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\FSharp.Compiler.Service.InternalsVisibleTo.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\FSharp.Compiler.Service.AssemblyInfo.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\sformat.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\sformat.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\sr.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\sr.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\ResizeArray.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\ResizeArray.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\HashMultiMap.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\HashMultiMap.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\EditDistance.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\EditDistance.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\TaggedCollections.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\TaggedCollections.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\illib.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\illib.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\FileSystem.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\FileSystem.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\ildiag.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\ildiag.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\zmap.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\zmap.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\zset.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\zset.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\XmlAdapters.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\XmlAdapters.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\InternalCollections.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\InternalCollections.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\QueueList.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\QueueList.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\lib.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\lib.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\ImmutableArray.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\ImmutableArray.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\rational.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\rational.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\PathMap.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\PathMap.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\RidHelpers.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\range.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Utilities\range.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\Logger.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\Logger.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\LanguageFeatures.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\LanguageFeatures.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\Diagnostics.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\Diagnostics.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\TextLayoutRender.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\TextLayoutRender.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\DiagnosticsLogger.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\DiagnosticsLogger.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\ErrorResolutionHints.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\ErrorResolutionHints.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\prim-lexing.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\prim-lexing.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\prim-parsing.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\prim-parsing.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\ReferenceResolver.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\ReferenceResolver.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\SimulatedMSBuildReferenceResolver.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\SimulatedMSBuildReferenceResolver.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\CompilerLocation.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Facilities\CompilerLocation.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\il.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\il.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilx.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilx.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilascii.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilascii.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\ilpars.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\illex.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilprint.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilprint.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilmorph.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilmorph.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilsign.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilsign.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilnativeres.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilnativeres.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilsupp.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilsupp.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilbinary.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilbinary.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilread.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilread.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilwritepdb.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilwritepdb.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilwrite.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilwrite.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilreflect.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\AbstractIL\ilreflect.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\PrettyNaming.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\PrettyNaming.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\CodeGen\EraseClosures.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\CodeGen\EraseClosures.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\UnicodeLexing.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\UnicodeLexing.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\XmlDoc.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\XmlDoc.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\SyntaxTrivia.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\SyntaxTrivia.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\SyntaxTree.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\SyntaxTree.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\SyntaxTreeOps.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\SyntaxTreeOps.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\ParseHelpers.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\ParseHelpers.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\pppars.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\pars.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\LexHelpers.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\LexHelpers.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\pplex.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\lex.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\LexFilter.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\SyntaxTree\LexFilter.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\tainted.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\tainted.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypeProviders.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypeProviders.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\QuotationPickler.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\QuotationPickler.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\CompilerGlobalState.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\CompilerGlobalState.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTree.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTreeBasics.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTreeBasics.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TcGlobals.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTreeOps.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTreeOps.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTreePickle.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\TypedTree\TypedTreePickle.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\import.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\import.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\TypeHierarchy.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\TypeHierarchy.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\infos.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\infos.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\AccessibilityLogic.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\AccessibilityLogic.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\AttributeChecking.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\AttributeChecking.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\TypeRelations.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\TypeRelations.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\InfoReader.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\InfoReader.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\NicePrint.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\NicePrint.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\AugmentTypeDefinitions.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\AugmentTypeDefinitions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\NameResolution.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\NameResolution.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\SignatureConformance.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\SignatureConformance.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\MethodOverrides.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\MethodOverrides.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\MethodCalls.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\MethodCalls.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\PatternMatchCompilation.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\PatternMatchCompilation.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\ConstraintSolver.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\ConstraintSolver.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\CheckFormatStrings.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\CheckFormatStrings.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\FindUnsolved.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\FindUnsolved.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\QuotationTranslator.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\QuotationTranslator.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\PostInferenceChecks.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\PostInferenceChecks.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckExpressionsOps.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckExpressions.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckExpressions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckComputationExpressions.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckComputationExpressions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckSequenceExpressions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\Expressions\CheckArrayOrListComputedExpressions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\CheckDeclarations.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Checking\CheckDeclarations.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\Optimizer.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\Optimizer.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\DetupleArgs.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\DetupleArgs.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\InnerLambdasToTopLevelFuncs.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\InnerLambdasToTopLevelFuncs.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerCalls.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerCalls.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerSequences.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerSequences.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerComputedCollections.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerComputedCollections.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerStateMachines.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerStateMachines.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerLocalMutables.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Optimize\LowerLocalMutables.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\CodeGen\EraseUnions.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\CodeGen\EraseUnions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\CodeGen\IlxGen.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\CodeGen\IlxGen.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\FxResolver.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\DependencyManager\AssemblyResolveHandler.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\DependencyManager\AssemblyResolveHandler.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\DependencyManager\NativeDllResolveHandler.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\DependencyManager\NativeDllResolveHandler.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\DependencyManager\DependencyProvider.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\DependencyManager\DependencyProvider.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\BuildGraph.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\BuildGraph.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerConfig.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerConfig.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerImports.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerImports.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerDiagnostics.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerDiagnostics.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\ParseAndCheckInputs.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\ParseAndCheckInputs.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\ScriptClosure.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\ScriptClosure.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerOptions.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CompilerOptions.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\OptimizeInputs.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\OptimizeInputs.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\XmlDocFileWriter.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\XmlDocFileWriter.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\BinaryResourceFormats.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\BinaryResourceFormats.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\StaticLinking.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\StaticLinking.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CreateILModule.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\CreateILModule.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\fsc.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Driver\fsc.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\FSharpDiagnostic.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\FSharpDiagnostic.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\SymbolHelpers.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\SymbolHelpers.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\Symbols.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\Symbols.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\Exprs.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\Exprs.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\SymbolPatterns.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Symbols\SymbolPatterns.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\SemanticClassification.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\SemanticClassification.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ItemKey.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ItemKey.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\SemanticClassificationKey.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\SemanticClassificationKey.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\FSharpSource.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\FSharpSource.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\IncrementalBuild.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\IncrementalBuild.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceCompilerDiagnostics.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceCompilerDiagnostics.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceConstants.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceDeclarationLists.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceDeclarationLists.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceLexing.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceLexing.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceParseTreeWalk.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceParseTreeWalk.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceNavigation.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceNavigation.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceParamInfoLocations.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceParamInfoLocations.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\FSharpParseFileResults.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\FSharpParseFileResults.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceParsedInputOps.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceParsedInputOps.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceAssemblyContent.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceAssemblyContent.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceXmlDocParser.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceXmlDocParser.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ExternalSymbol.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ExternalSymbol.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\QuickParse.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\QuickParse.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\FSharpCheckerResults.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\FSharpCheckerResults.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\service.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\service.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceInterfaceStubGenerator.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceInterfaceStubGenerator.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceStructure.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceStructure.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceAnalysis.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Service\ServiceAnalysis.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Interactive\fsi.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Interactive\fsi.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Legacy\LegacyMSBuildReferenceResolver.fsi"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Legacy\LegacyMSBuildReferenceResolver.fs"
               __SOURCE_DIRECTORY__ + @"\..\..\..\..\src\Compiler\Legacy\LegacyHostedCompilerForTesting.fs" |]
          OtherOptions =
            [| sprintf "-o:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\FSharp.Compiler.Service.dll"
               @"-g"
               @"--debug:embedded"
               @"--noframework"
               @"--define:TRACE"
               @"--define:COMPILER"
               @"--define:ENABLE_MONO_SUPPORT"
               @"--define:DEBUG"
               @"--define:ENABLE_MONO_SUPPORT"
               @"--define:NETFRAMEWORK"
               @"--define:NET472"
               @"--define:NET20_OR_GREATER"
               @"--define:NET30_OR_GREATER"
               @"--define:NET35_OR_GREATER"
               @"--define:NET40_OR_GREATER"
               @"--define:NET45_OR_GREATER"
               @"--define:NET451_OR_GREATER"
               @"--define:NET452_OR_GREATER"
               @"--define:NET46_OR_GREATER"
               @"--define:NET461_OR_GREATER"
               @"--define:NET462_OR_GREATER"
               @"--define:NET47_OR_GREATER"
               @"--define:NET471_OR_GREATER"
               @"--define:NET472_OR_GREATER"
               sprintf "-doc:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\obj\FSharp.Compiler.Service\Debug\net472\FSharp.Compiler.Service.xml"
               @"--publicsign+"
               @"--optimize-"
               sprintf "-r:%s%s" nugetCache @"fsharp.core\6.0.1\lib\netstandard2.0\FSharp.Core.dll"
               sprintf "-r:%s%s" __SOURCE_DIRECTORY__ @"\..\..\..\..\artifacts\bin\FSharp.DependencyManager.Nuget\Debug\netstandard2.0\FSharp.DependencyManager.Nuget.dll"
               sprintf "-r:%s%s" nugetCache @"microsoft.build.framework\17.0.0\lib\net472\Microsoft.Build.Framework.dll"
               sprintf "-r:%s%s" nugetCache @"microsoft.build.tasks.core\17.0.0\lib\net472\Microsoft.Build.Tasks.Core.dll"
               sprintf "-r:%s%s" nugetCache @"microsoft.build.utilities.core\17.0.0\lib\net472\Microsoft.Build.Utilities.Core.dll"
               sprintf "-r:%s%s" nugetCache @"microsoft.net.stringtools\1.0.0\lib\net472\Microsoft.NET.StringTools.dll"
               sprintf "-r:%s%s" nugetCache @"microsoft.visualstudio.setup.configuration.interop\1.16.30\lib\net35\Microsoft.VisualStudio.Setup.Configuration.Interop.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\mscorlib.dll"
               sprintf "-r:%s%s" nugetCache @"system.buffers\4.5.1\ref\net45\System.Buffers.dll"
               sprintf "-r:%s%s" nugetCache @"system.collections.immutable\5.0.0\lib\net461\System.Collections.Immutable.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.ComponentModel.Composition.dll"
               sprintf "-r:%s%s" nugetCache @"system.configuration.configurationmanager\4.7.0\ref\net461\System.Configuration.ConfigurationManager.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Configuration.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Core.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Data.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Data.OracleClient.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Diagnostics.Process.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Diagnostics.TraceSource.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Drawing.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.IO.Compression.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.IO.Compression.FileSystem.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.IO.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Linq.Expressions.dll"
               sprintf "-r:%s%s" nugetCache @"system.memory\4.5.4\lib\net461\System.Memory.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Net.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Net.Http.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Net.Security.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Numerics.dll"
               sprintf "-r:%s%s" nugetCache @"system.numerics.vectors\4.5.0\ref\net46\System.Numerics.Vectors.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Reflection.dll"
               sprintf "-r:%s%s" nugetCache @"system.reflection.metadata\5.0.0\lib\net461\System.Reflection.Metadata.dll"
               sprintf "-r:%s%s" nugetCache @"system.reflection.typeextensions\4.3.0\ref\net462\System.Reflection.TypeExtensions.dll"
               sprintf "-r:%s%s" nugetCache @"system.resources.extensions\4.6.0\ref\netstandard2.0\System.Resources.Extensions.dll"
               sprintf "-r:%s%s" nugetCache @"system.runtime.compilerservices.unsafe\6.0.0\lib\net461\System.Runtime.CompilerServices.Unsafe.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Runtime.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Runtime.InteropServices.dll"
               sprintf "-r:%s%s" nugetCache @"system.runtime.loader\4.3.0\ref\netstandard1.5\System.Runtime.Loader.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Runtime.Serialization.dll"
               sprintf "-r:%s%s" nugetCache @"system.security.accesscontrol\4.7.0\ref\net461\System.Security.AccessControl.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Security.Claims.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Security.Cryptography.Algorithms.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Security.Cryptography.Encoding.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Security.Cryptography.Primitives.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Security.Cryptography.X509Certificates.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Security.dll"
               sprintf "-r:%s%s" nugetCache @"system.security.permissions\4.7.0\ref\net461\System.Security.Permissions.dll"
               sprintf "-r:%s%s" nugetCache @"system.security.principal.windows\4.7.0\ref\net461\System.Security.Principal.Windows.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.ServiceProcess.dll"
               sprintf "-r:%s%s" nugetCache @"system.threading.tasks.dataflow\4.9.0\lib\netstandard2.0\System.Threading.Tasks.Dataflow.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Threading.Thread.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\Facades\System.Threading.ThreadPool.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Transactions.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Windows.Forms.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Xaml.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Xml.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\System.Xml.Linq.dll"
               @"-r:C:\Program Files (x86)\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.7.2\WindowsBase.dll"
               @"--target:library"
               @"--nowarn:FS2003,44,57,75,1204,NU5125,NU5105"
               @"--warn:3"
               @"--warnaserror:3239,1182,0025"
               @"--fullpaths"
               @"--flaterrors"
               @"--subsystemversion:6.00"
               @"--highentropyva+"
               @"--targetprofile:mscorlib"
               @"--nocopyfsharpcore"
               @"--deterministic+"
               @"--simpleresolution"
               @"--nowarn:3384"
               @"--extraoptimizationloops:1"
               @"--times"
               @"--warnon:1182"
               @"--warnon:3218"
               @"--warnon:3390" |]
          ReferencedProjects =
            [| FSharpDependencyManagerNuget
               FSharpCore |]
          IsIncompleteTypeCheckEnvironment = false
          UseScriptResolutionRules = false
          LoadTime = DateTime.Now
          UnresolvedReferences = None
          OriginalLoadReferences = []
          Stamp = None }

[<MemoryDiagnoser>]
[<BenchmarkCategory(ShortCategory)>]
type CompilerService() =
    let mutable checkerOpt = None
    let mutable sourceOpt : (string * ISourceText) array option = None

    let projectOptions = Project.FSharpCompilerService

    [<GlobalSetup>]
    member _.Setup() =
        match checkerOpt with
        | None -> checkerOpt <- Some(FSharpChecker.Create(projectCacheSize = 200))
        | _ -> ()

        match sourceOpt with
        | None -> 
            sourceOpt <- 
                projectOptions.SourceFiles
                |> Array.filter (fun filePath -> filePath.EndsWith("CheckDeclarations.fs"))
                |> Array.map (fun filePath -> filePath, SourceText.ofString (File.ReadAllText(filePath)))
                |> Some
        | _ -> ()

    [<Benchmark>]
    member _.ParseAndCheckFileInProject() =
        match checkerOpt, sourceOpt with
        | None, _ -> failwith "no checker"
        | _, None -> failwith "no source"
        | Some checker, Some sourceFiles ->
            checker.InvalidateAll()
            sourceFiles
            |> Array.iter (fun (filePath, sourceText) ->
                let _fileResult, _checkResult =
                    checker.ParseAndCheckFileInProject(filePath, 0, sourceText, projectOptions)
                    |> Async.RunSynchronously

                ()
            )

[<EntryPoint>]
let main args =
    BenchmarkSwitcher.FromAssembly(typeof<CompilerService>.Assembly).Run(args) |> ignore
    0
